"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppsyncFunction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const appsync_generated_1 = require("./appsync.generated");
/**
 * AppSync Functions are local functions that perform certain operations
 * onto a backend data source. Developers can compose operations (Functions)
 * and execute them in sequence with Pipeline Resolvers.
 *
 * @resource AWS::AppSync::FunctionConfiguration
 */
class AppsyncFunction extends core_1.Resource {
    constructor(scope, id, props) {
        var _b, _c;
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_appsync_AppsyncFunctionProps(props);
        this.function = new appsync_generated_1.CfnFunctionConfiguration(this, 'Resource', {
            name: props.name,
            description: props.description,
            apiId: props.api.apiId,
            dataSourceName: props.dataSource.name,
            functionVersion: '2018-05-29',
            requestMappingTemplate: (_b = props.requestMappingTemplate) === null || _b === void 0 ? void 0 : _b.renderTemplate(),
            responseMappingTemplate: (_c = props.responseMappingTemplate) === null || _c === void 0 ? void 0 : _c.renderTemplate(),
        });
        this.functionName = this.function.attrName;
        this.functionArn = this.function.attrFunctionArn;
        this.functionId = this.function.attrFunctionId;
        this.dataSource = props.dataSource;
        this.function.addDependsOn(this.dataSource.ds);
        props.api.addSchemaDependency(this.function);
    }
    /**
     * Import Appsync Function from arn
     */
    static fromAppsyncFunctionAttributes(scope, id, attrs) {
        jsiiDeprecationWarnings._aws_cdk_aws_appsync_AppsyncFunctionAttributes(attrs);
        class Import extends core_1.Resource {
            constructor(s, i) {
                super(s, i);
                this.functionId = core_1.Lazy.stringValue({
                    produce: () => core_1.Fn.select(3, core_1.Fn.split('/', attrs.functionArn)),
                });
                this.functionArn = attrs.functionArn;
            }
        }
        return new Import(scope, id);
    }
}
exports.AppsyncFunction = AppsyncFunction;
_a = JSII_RTTI_SYMBOL_1;
AppsyncFunction[_a] = { fqn: "@aws-cdk/aws-appsync.AppsyncFunction", version: "1.146.0" };
//# sourceMappingURL=data:application/json;base64,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