from argparse import ArgumentParser
import sys
import subprocess
import pandas as pd
from pathlib import Path
import yaml

TAXCALC_REQUIRED_INPUTS = [
    "RECID",
    "MARS",
]

TAXCALC_INPUT_VARIABLES = [
    "DSI",
    "EIC",
    "FLPDYR",
    "MARS",
    "MIDR",
    "RECID",
    "XTOT",
    "age_head",
    "age_spouse",
    "agi_bin",
    "blind_head",
    "blind_spouse",
    "cmbtp",
    "e00200",
    "e00200p",
    "e00200s",
    "pencon_p",
    "pencon_s",
    "e00300",
    "e00400",
    "e00600",
    "e00650",
    "e00700",
    "e00800",
    "e00900",
    "e00900p",
    "e00900s",
    "e01100",
    "e01200",
    "e01400",
    "e01500",
    "e01700",
    "e02000",
    "e02100",
    "e02100p",
    "e02100s",
    "e02300",
    "e02400",
    "e03150",
    "e03210",
    "e03220",
    "e03230",
    "e03240",
    "e03270",
    "e03290",
    "e03300",
    "e03400",
    "e03500",
    "e07240",
    "e07260",
    "e07300",
    "e07400",
    "e07600",
    "e09700",
    "e09800",
    "e09900",
    "e11200",
    "e17500",
    "e18400",
    "e18500",
    "e19200",
    "e19800",
    "e20100",
    "e20400",
    "g20500",
    "e24515",
    "e24518",
    "e26270",
    "e27200",
    "e32800",
    "e58990",
    "e62900",
    "e87530",
    "elderly_dependents",
    "f2441",
    "f6251",
    "a_lineno",
    "ffpos",
    "fips",
    "h_seq",
    "data_source",
    "k1bx14p",
    "k1bx14s",
    "mcaid_ben",
    "mcare_ben",
    "n24",
    "nu06",
    "nu13",
    "nu18",
    "n1820",
    "n21",
    "other_ben",
    "p08000",
    "p22250",
    "p23250",
    "e87521",
    "s006",
    "snap_ben",
    "housing_ben",
    "ssi_ben",
    "tanf_ben",
    "vet_ben",
    "wic_ben",
    "PT_SSTB_income",
    "PT_binc_w2_wages",
    "PT_ubia_property",
]

TAXCALC_OUTPUT_VARIABLES = [
    "niit",
    "combined",
    "earned",
    "earned_p",
    "earned_s",
    "was_plus_sey_p",
    "was_plus_sey_s",
    "eitc",
    "rptc",
    "rptc_p",
    "rptc_s",
    "exact",
    "expanded_income",
    "iitax",
    "num",
    "othertaxes",
    "payrolltax",
    "refund",
    "sep",
    "sey",
    "standard",
    "surtax",
    "taxbc",
    "c00100",
    "c01000",
    "c02500",
    "c02900",
    "c03260",
    "c04470",
    "c04600",
    "qbided",
    "c04800",
    "c05200",
    "c05700",
    "c05800",
    "c07100",
    "c07180",
    "CDCC_refund",
    "c07200",
    "c07220",
    "c07230",
    "c07240",
    "c07260",
    "c07300",
    "c07400",
    "c07600",
    "c08000",
    "c09200",
    "c09600",
    "c10960",
    "c11070",
    "c17000",
    "e17500_capped",
    "c18300",
    "e18400_capped",
    "e18500_capped",
    "c19200",
    "e19200_capped",
    "c19700",
    "e19800_capped",
    "e20100_capped",
    "c20500",
    "g20500_capped",
    "c20800",
    "e20400_capped",
    "c21040",
    "c21060",
    "c23650",
    "c59660",
    "c62100",
    "c87668",
    "care_deduction",
    "ctc_new",
    "odc",
    "personal_refundable_credit",
    "recovery_rebate_credit",
    "personal_nonrefundable_credit",
    "charity_credit",
    "dwks10",
    "dwks13",
    "dwks14",
    "dwks19",
    "fstax",
    "invinc_agi_ec",
    "invinc_ec_base",
    "lumpsum_tax",
    "pre_c04600",
    "codtc_limited",
    "ptax_amc",
    "ptax_oasdi",
    "ptax_was",
    "setax",
    "ymod",
    "ymod1",
    "ubi",
    "taxable_ubi",
    "nontaxable_ubi",
    "mtr_paytax",
    "mtr_inctax",
    "aftertax_income",
    "benefit_cost_total",
    "benefit_value_total",
]

parser = ArgumentParser(
    description="Utility to run taxcalc on a single tax unit"
)

for variable in TAXCALC_INPUT_VARIABLES:
    parser.add_argument(
        "--" + variable, required=variable in TAXCALC_REQUIRED_INPUTS
    )
parser.add_argument("--output", nargs="+", default=TAXCALC_OUTPUT_VARIABLES)
parser.add_argument("--year", type=int, default=2020)
args = parser.parse_args()

output_dir = Path("./taxcalc_output")
output_dir.mkdir(exist_ok=True)
pd.DataFrame(
    {
        variable: [getattr(args, variable)]
        for variable in TAXCALC_INPUT_VARIABLES
        if getattr(args, variable) is not None
    }
).to_csv("taxcalc_output/input.csv", index=False)
process = subprocess.Popen(
    f"tc ./taxcalc_output/input.csv {args.year} --dump --outdir ./taxcalc_output",
    shell=True,
    stdout=subprocess.PIPE,
)
process.wait()
result = pd.read_csv(output_dir / f"input-{args.year % 100}-#-#-#.csv")
output = {}
for col in result.columns:
    if col in args.output or args.output == []:
        output[col] = float(result[col].iloc[0])
yaml.dump(output, sys.stdout)
