#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['pepdocs', 'pepdocs.config']

package_data = \
{'': ['*']}

install_requires = \
['pyconfs[toml]', 'requests', 'typer']

extras_require = \
{":python_version < '3.7'": ['importlib_resources'],
 'dev': ['black',
         'bumpversion',
         'flake8',
         'flit',
         'interrogate',
         'isort',
         'mypy',
         'pre-commit'],
 'doc': ['mkdocs'],
 'test': ['black',
          'flake8',
          'interrogate',
          'isort',
          'mypy',
          'pytest',
          'pytest-cov',
          'tox']}

entry_points = \
{'console_scripts': ['pep = pepdocs.__main__:main',
                     'pepdocs = pepdocs.__main__:main']}

setup(name='pepdocs',
      version='0.1.0',
      description='PepDocs, read PEPs in your console',
      author='Geir Arne Hjelle',
      author_email='geirarne@gmail.com',
      url='https://github.com/gahjelle/pepdocs',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      entry_points=entry_points,
      python_requires='>=3.6',
     )
