# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['renconstruct', 'renconstruct.tasks']

package_data = \
{'': ['*']}

install_requires = \
['click>=7.1.2,<8.0.0',
 'diff-match-patch>=20181111,<20181112',
 'logzero>=1.5.0,<2.0.0',
 'pyyaml>=5.3.1,<6.0.0',
 'renotize>=1.1.0,<2.0.0',
 'renutil>=1.11.0,<2.0.0',
 'termcolor>=1.1.0,<2.0.0',
 'tqdm>=4.46.1,<5.0.0']

entry_points = \
{'console_scripts': ['renconstruct = renconstruct.renconstruct:cli']}

setup_kwargs = {
    'name': 'renconstruct',
    'version': '1.2.2',
    'description': "A utility script for automatically building Ren'Py applications for multiple platforms.",
    'long_description': '# renConstruct\n[![CircleCI](https://circleci.com/gh/kobaltcore/renconstruct.svg?style=svg)](https://circleci.com/gh/kobaltcore/renconstruct)\n[![Downloads](https://pepy.tech/badge/renconstruct)](https://pepy.tech/project/renconstruct)\n\nA utility script to automatically build Ren\'Py applications for multiple platforms.\n\nrenConstruct can build distributions for Windows, Linux, macOS and Android, including extra processing steps pre- and post-build.\nBy default it supports notarization for macOS distributions, a memory limit increase for Windows distributions (using `LARGEADDRESSAWARE`) and cleanup of temporary build artifacts. In addition, a `patch` task is available which enables pre-build patching of Python Ren\'Py source files.\n\nCustom pre- and post-build steps can easily be added.\n\n## Installation\nrenConstruct can be installed via pip:\n```bash\n$ pip install renconstruct\n```\n\nPlease note that renConstruct requires Python 3 and will not provide backwards compatibility for Python 2 for the foreseeable future.\n\n## Usage\nrenConstruct operates based on the following process flow:\n- Ensure dependencies are installed\n- Validate configuration file\n- Install specific version of Ren\'Py if necessary\n- Run the `pre-build` stage of all active tasks\n- Build the Android distribution if enabled\n- Build the macOS and Windows/Linux distributions if enabled\n- Run the `post-build` stage of all active tasks\n\nIn the default configuration, the following tasks are executed at the respective build stage:\n- `pre-build`:\n    + `None`\n- `post-build`:\n    + `set_extended_memory_limit`\n    + `clean`\n\n### Configuration\nrenConstruct requires a configuration file to be supplied containing the information required to complete the build process for the various platforms. An empty template is provided in this repository under the name `config.empty.yml`\n\nIt consists of the following sections:\n\n#### `tasks`\n- `path`: An optional path to a directory containing Python files with custom tasks\n- `set_extended_memory_limit`: A value of `true` or `false` determining whether to run this task or not\n- `notarize`: A value of `true` or `false` determining whether to run this task or not\n- `clean`: A value of `true` or `false` determining whether to run this task or not\n- `patch`: A value of `true` or `false` determining whether to run this task or not\n\n#### `build`\n- `win`: A value of `true` or `false` determining whether to build the Windows/Linux distribution or not\n- `mac`: A value of `true` or `false` determining whether to build the macOS distribution or not\n- `android`: A value of `true` or `false` determining whether to build the Android distribution or not\n\n\n#### `renutil`\n- `version`: The version of Ren\'Py to use while building the distributions\n- `registry`: A path where `renutil` data is stored. Mostly useful for CI environments\n\n#### `renotize`\n- `apple_id`: The e-Mail address belonging to the Apple ID you want to use for signing applications.\n- `password`: An app-specific password generated through the [management portal](https://appleid.apple.com/account/manage) of your Apple ID.\n- `identity`: The identity associated with your Developer Certificate which can be found in `Keychain Access` under the category "My Certificates". It starts with `Developer ID Application:`, however it suffices to provide the 10-character code in the title of the certificate.\n- `bundle`: The internal name for your app. This is typically the reverse domain notation of your website plus your application name, i.e. `com.example.mygame`.\n- `altool_extra`: An optional string that will be passed on to all `altool` runs in all commands. Useful for selecting an organization when your Apple ID belongs to multiple, for example. Typically you will not have to touch this and you can leave it empty.\n\n### Default Tasks\nrenConstruct ships with several built-in tasks that enable project-independent functionality.\n\n#### `Clean`\nThis task runs as the last task in the `post-build` stage. Its purpose is to remove unnecessary artifacts and temporary build data. It achieves this by running `renutil clean`, which will remove all temporary build artifacts from the Ren\'Py instance used to build the project. In addition it removes non-universal APK artifacts from the output folder.\n\nGiven that the universal APK\'s are only a few Megabytes larger and more widely compatible, the author opines that shipping the universal versions is preferable in all cases.\n\n#### `Notarize`\nThis task runs in the `post-build` stage and utilizes the `renotize` utility to automatically notarize the macOS build of the project, if it was generated. The process is entirely automatic, though it may take a few minutes depending on the size of the game and the load on Apple\'s notarization servers.\n\n#### `Set Extended Memory Limit`\nThis task runs in the `post-build` stage and operates on the Windows build of the project, if it was generated. Specifically, it modifies the executable file by setting the `LARGEADDRESSAWARE` flag in the header of the file, which enables the final build to access 4GB of RAM on Windows, instead of the typical 2GB when running in regular 32-Bit mode.\n\nGiven that Ren\'Py already supports 64-Bit operation under Linux and macOS (and through personal experience deploying thusly modified games), this option should be safe to use in effectively all cases.\n\n#### `Patch`\nThis task runs early in the `pre-build` stage and is capable of applying patch files (code diffs) to Python files of the Ren\'Py instance that will be used to build the project. This allows for automatic application of game-specific patches before building, enabling customization at the engine level.\n\nIt is important to note that renConstruct does *not* build or rebuild Ren\'Py after these patches are applied. As such it is only possible to patch runtime files, which effectively boils down to the pure-Python parts of Ren\'Py. Patching the compiled parts is not supported and actively discouraged.\n\nThe task works by looking at a directory of patch files (specified in the configuration file) and applying them to equally-named files in the directory of the Ren\'Py instance. For this to work, the structure of the patch directory must exactly mirror that of the paths to the actual file to patch, relative to the instance directory.\n\nFor example, if you wanted to patch the file `renpy/display/presplash.py` you would generated a patch file and name it `presplash.py`. After that you would put it into the directory `patches/renpy/display/presplash.py`.\nPatch files are expected to match the `diff-match-patch` format for diffs. These types of files can be easily generated using the [`diffusor`](https://github.com/kobaltcore/diffusor) command-line utility.\n\nrenConstruct will automatically figure out the actual file to apply it to, as well as create a backup of the original file. If any part of the patching process files, all changes are rolled back. it is also guaranteed that a file will only ever be patched once. Even if a file has been patched before and the patch file has changed, the new patch will be reliably applied to the original, unmodified file and the currently modified version will be replaced by the new version.\n\n### Custom Tasks\nCustom tasks can easily be added using the `path` value. It should point to a directory containing Python files.\nEach file can contain one or more task, which will be picked up by renConstruct.\n\nA task is an object that looks like this:\n```python\nclass DoSomethingTask():\n\n    PRIORITY = -100\n\n    def __init__(self, name, config):\n        self.name = name\n        self.config = config\n\n    @staticmethod\n    def validate_config(config):\n        pass\n\n    def pre_build(self):\n        pass\n\n    def post_build(self):\n        pass\n```\n\nThe name of the class must end with `Task` for it to be picked up by renConstruct.\nEvery custom task will automatically receive a setting in the config file based on the class name split on uppercase letters, converted to lowercase and joined by underscores.\nThe example task above would receive the config variable `do_something`.\n\nA task can have a custom section in the config file. To support this, each task class can have an optional static method `validate_config`, which is passed the subsection of the config object pertaining to that task. It can then validate this config object in any way it sees fit, raising an Exception when an issue occurs.\nThe parsed config subsection is then integrated into the full config object, which is then passed back to the task upon initialization.\n\nA task can have two methods `pre_build` and `post_build` (either or both is possible).\nThey will be called with the validated config object at the specified build stage.\nAt that point they can do whatever they want. As an example, a custom task could be built to automatically optimize image assets in the game directory before every build.\n\nEach task also has a `PRIORITY` class attribute which has a default value of `0` and determines the order in which to run the tasks. A higher priority means that task will be executed earlier than others with a lower value. Both positive and negative values are possible.\n\nAs an example, the built-in `clean` task runs at `PRIORITY = -1000` to ensure it\'s always the last task to be run.\n\n### Example\n```bash\nrenconstruct -c config.yml -i path/to/my-game/ -o out/\n```\n\n## Using `renConstruct` with Gitlab CI\nA common use case for headless building of distributions is Continuous Integration.\nFind below an example of a GitLab CI configuration file which should work for most projects.\n\n```yaml\n# Recent experience shows that using "python:latest" can cause issues\n# because its definition may vary per runner. Always specify the exact\n# version you intend to use to avoid issues.\nimage: python:3.8\n\nvariables:\n    PIP_CACHE_DIR: "$CI_PROJECT_DIR/.cache/pip"\n\ncache:\n  paths:\n    - .cache/pip\n    - venv/\n\nbefore_script:\n  # Downloads renconstruct through pip\n  - pip install renconstruct\n\nrun:\n  script:\n    # Runs renconstruct in the project directory, saving the build outputs to a new folder called "artifacts"\n    # inside the project directory and utilises the file config.yml to specify reconstruct options.\n    - renconstruct -d -i $CI_PROJECT_DIR -o $CI_PROJECT_DIR/artifacts -c $CI_PROJECT_DIR/config.yml\n\n  artifacts:\n    paths:\n     # Saves the artifacts located in the "artifacts" folder to GitLab\n      - $CI_PROJECT_DIR/artifacts/**.*\n```\n\n### Command Line Interface\n```\nUsage: renconstruct.py [OPTIONS]\n\n  A utility script to automatically build Ren\'Py applications for multiple\n  platforms.\n\nOptions:\n  -i, --input TEXT   The path to the Ren\'Py project to build  [required]\n  -o, --output TEXT  The directory to output build artifacts to  [required]\n  -c, --config TEXT  The configuration file for this run  [required]\n  -d, --debug        If given, shows debug information if\n  --help             Show this message and exit.\n```\n\n# Disclaimer\nrenConstruct is a hobby project and not in any way affiliated with Ren\'Py. This means that there is no way I can guarantee that it will work at all, or continue to work once it does.\n',
    'author': 'CobaltCore',
    'author_email': 'cobaltcore@yandex.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/kobaltcore/renconstruct',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.5,<4.0',
}


setup(**setup_kwargs)
