# -*- coding: utf8 -*-
# Copyright (c) 2017-2025 Tencent. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import warnings

from tencentcloud.common.abstract_model import AbstractModel


class AccessFieldValueRatioInfo(AbstractModel):
    r"""DescribeAccessFastAnalysis接口的出参

    """

    def __init__(self):
        r"""
        :param _Count: 日志条数
        :type Count: int
        :param _Ratio: 对应的Value值的百分比
        :type Ratio: float
        :param _Value: 字段对应的值
        :type Value: str
        """
        self._Count = None
        self._Ratio = None
        self._Value = None

    @property
    def Count(self):
        r"""日志条数
        :rtype: int
        """
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def Ratio(self):
        r"""对应的Value值的百分比
        :rtype: float
        """
        return self._Ratio

    @Ratio.setter
    def Ratio(self, Ratio):
        self._Ratio = Ratio

    @property
    def Value(self):
        r"""字段对应的值
        :rtype: str
        """
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value


    def _deserialize(self, params):
        self._Count = params.get("Count")
        self._Ratio = params.get("Ratio")
        self._Value = params.get("Value")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AccessFullTextInfo(AbstractModel):
    r"""DescribeAccessIndex

    """

    def __init__(self):
        r"""
        :param _CaseSensitive: 是否大小写敏感
        :type CaseSensitive: bool
        :param _Tokenizer: 全文索引的分词符，字符串中每个字符代表一个分词符
        :type Tokenizer: str
        :param _ContainZH: 是否包含中文
注意：此字段可能返回 null，表示取不到有效值。
        :type ContainZH: bool
        """
        self._CaseSensitive = None
        self._Tokenizer = None
        self._ContainZH = None

    @property
    def CaseSensitive(self):
        r"""是否大小写敏感
        :rtype: bool
        """
        return self._CaseSensitive

    @CaseSensitive.setter
    def CaseSensitive(self, CaseSensitive):
        self._CaseSensitive = CaseSensitive

    @property
    def Tokenizer(self):
        r"""全文索引的分词符，字符串中每个字符代表一个分词符
        :rtype: str
        """
        return self._Tokenizer

    @Tokenizer.setter
    def Tokenizer(self, Tokenizer):
        self._Tokenizer = Tokenizer

    @property
    def ContainZH(self):
        r"""是否包含中文
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._ContainZH

    @ContainZH.setter
    def ContainZH(self, ContainZH):
        self._ContainZH = ContainZH


    def _deserialize(self, params):
        self._CaseSensitive = params.get("CaseSensitive")
        self._Tokenizer = params.get("Tokenizer")
        self._ContainZH = params.get("ContainZH")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AccessHistogramItem(AbstractModel):
    r"""用于接口DescribeAccessHistogram 的出参

    """

    def __init__(self):
        r"""
        :param _BTime: 时间，单位ms
        :type BTime: int
        :param _Count: 日志条数
        :type Count: int
        :param _BeginTime: 时间，单位ms
        :type BeginTime: int
        """
        self._BTime = None
        self._Count = None
        self._BeginTime = None

    @property
    def BTime(self):
        warnings.warn("parameter `BTime` is deprecated", DeprecationWarning) 

        r"""时间，单位ms
        :rtype: int
        """
        return self._BTime

    @BTime.setter
    def BTime(self, BTime):
        warnings.warn("parameter `BTime` is deprecated", DeprecationWarning) 

        self._BTime = BTime

    @property
    def Count(self):
        r"""日志条数
        :rtype: int
        """
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def BeginTime(self):
        r"""时间，单位ms
        :rtype: int
        """
        return self._BeginTime

    @BeginTime.setter
    def BeginTime(self, BeginTime):
        self._BeginTime = BeginTime


    def _deserialize(self, params):
        self._BTime = params.get("BTime")
        self._Count = params.get("Count")
        self._BeginTime = params.get("BeginTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AccessKeyValueInfo(AbstractModel):
    r"""用于 DescribeAccessIndex 的出参

    """

    def __init__(self):
        r"""
        :param _Key: 需要配置键值或者元字段索引的字段
        :type Key: str
        :param _Value: 字段的索引描述信息
        :type Value: :class:`tencentcloud.waf.v20180125.models.AccessValueInfo`
        """
        self._Key = None
        self._Value = None

    @property
    def Key(self):
        r"""需要配置键值或者元字段索引的字段
        :rtype: str
        """
        return self._Key

    @Key.setter
    def Key(self, Key):
        self._Key = Key

    @property
    def Value(self):
        r"""字段的索引描述信息
        :rtype: :class:`tencentcloud.waf.v20180125.models.AccessValueInfo`
        """
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value


    def _deserialize(self, params):
        self._Key = params.get("Key")
        if params.get("Value") is not None:
            self._Value = AccessValueInfo()
            self._Value._deserialize(params.get("Value"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AccessLogInfo(AbstractModel):
    r"""单条日志数据描述

    """

    def __init__(self):
        r"""
        :param _Time: 日志时间，单位ms
        :type Time: int
        :param _TopicId: 日志主题ID
        :type TopicId: str
        :param _TopicName: 日志主题名称
        :type TopicName: str
        :param _Source: 日志来源IP
        :type Source: str
        :param _FileName: 日志文件名称
        :type FileName: str
        :param _PkgId: 日志上报请求包的ID
        :type PkgId: str
        :param _PkgLogId: 请求包内日志的ID
        :type PkgLogId: str
        :param _LogJson: 日志内容的Json序列化字符串
注意：此字段可能返回 null，表示取不到有效值。
        :type LogJson: str
        """
        self._Time = None
        self._TopicId = None
        self._TopicName = None
        self._Source = None
        self._FileName = None
        self._PkgId = None
        self._PkgLogId = None
        self._LogJson = None

    @property
    def Time(self):
        r"""日志时间，单位ms
        :rtype: int
        """
        return self._Time

    @Time.setter
    def Time(self, Time):
        self._Time = Time

    @property
    def TopicId(self):
        r"""日志主题ID
        :rtype: str
        """
        return self._TopicId

    @TopicId.setter
    def TopicId(self, TopicId):
        self._TopicId = TopicId

    @property
    def TopicName(self):
        r"""日志主题名称
        :rtype: str
        """
        return self._TopicName

    @TopicName.setter
    def TopicName(self, TopicName):
        self._TopicName = TopicName

    @property
    def Source(self):
        r"""日志来源IP
        :rtype: str
        """
        return self._Source

    @Source.setter
    def Source(self, Source):
        self._Source = Source

    @property
    def FileName(self):
        r"""日志文件名称
        :rtype: str
        """
        return self._FileName

    @FileName.setter
    def FileName(self, FileName):
        self._FileName = FileName

    @property
    def PkgId(self):
        r"""日志上报请求包的ID
        :rtype: str
        """
        return self._PkgId

    @PkgId.setter
    def PkgId(self, PkgId):
        self._PkgId = PkgId

    @property
    def PkgLogId(self):
        r"""请求包内日志的ID
        :rtype: str
        """
        return self._PkgLogId

    @PkgLogId.setter
    def PkgLogId(self, PkgLogId):
        self._PkgLogId = PkgLogId

    @property
    def LogJson(self):
        r"""日志内容的Json序列化字符串
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._LogJson

    @LogJson.setter
    def LogJson(self, LogJson):
        self._LogJson = LogJson


    def _deserialize(self, params):
        self._Time = params.get("Time")
        self._TopicId = params.get("TopicId")
        self._TopicName = params.get("TopicName")
        self._Source = params.get("Source")
        self._FileName = params.get("FileName")
        self._PkgId = params.get("PkgId")
        self._PkgLogId = params.get("PkgLogId")
        self._LogJson = params.get("LogJson")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AccessLogItem(AbstractModel):
    r"""日志KeyValue对

    """

    def __init__(self):
        r"""
        :param _Key: 日记Key
        :type Key: str
        :param _Value: 日志Value
        :type Value: str
        """
        self._Key = None
        self._Value = None

    @property
    def Key(self):
        r"""日记Key
        :rtype: str
        """
        return self._Key

    @Key.setter
    def Key(self, Key):
        self._Key = Key

    @property
    def Value(self):
        r"""日志Value
        :rtype: str
        """
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value


    def _deserialize(self, params):
        self._Key = params.get("Key")
        self._Value = params.get("Value")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AccessLogItems(AbstractModel):
    r"""日志KeyValue对数组，用于搜索访问日志

    """

    def __init__(self):
        r"""
        :param _Data: 分析结果返回的KV数据对
        :type Data: list of AccessLogItem
        """
        self._Data = None

    @property
    def Data(self):
        r"""分析结果返回的KV数据对
        :rtype: list of AccessLogItem
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = AccessLogItem()
                obj._deserialize(item)
                self._Data.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AccessRuleInfo(AbstractModel):
    r"""DescribeAccessIndex接口的出参数

    """

    def __init__(self):
        r"""
        :param _FullText: 全文索引配置
注意：此字段可能返回 null，表示取不到有效值。
        :type FullText: :class:`tencentcloud.waf.v20180125.models.AccessFullTextInfo`
        :param _KeyValue: 键值索引配置
注意：此字段可能返回 null，表示取不到有效值。
        :type KeyValue: :class:`tencentcloud.waf.v20180125.models.AccessRuleKeyValueInfo`
        :param _Tag: 元字段索引配置
注意：此字段可能返回 null，表示取不到有效值。
        :type Tag: :class:`tencentcloud.waf.v20180125.models.AccessRuleTagInfo`
        """
        self._FullText = None
        self._KeyValue = None
        self._Tag = None

    @property
    def FullText(self):
        r"""全文索引配置
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.waf.v20180125.models.AccessFullTextInfo`
        """
        return self._FullText

    @FullText.setter
    def FullText(self, FullText):
        self._FullText = FullText

    @property
    def KeyValue(self):
        r"""键值索引配置
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.waf.v20180125.models.AccessRuleKeyValueInfo`
        """
        return self._KeyValue

    @KeyValue.setter
    def KeyValue(self, KeyValue):
        self._KeyValue = KeyValue

    @property
    def Tag(self):
        r"""元字段索引配置
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.waf.v20180125.models.AccessRuleTagInfo`
        """
        return self._Tag

    @Tag.setter
    def Tag(self, Tag):
        self._Tag = Tag


    def _deserialize(self, params):
        if params.get("FullText") is not None:
            self._FullText = AccessFullTextInfo()
            self._FullText._deserialize(params.get("FullText"))
        if params.get("KeyValue") is not None:
            self._KeyValue = AccessRuleKeyValueInfo()
            self._KeyValue._deserialize(params.get("KeyValue"))
        if params.get("Tag") is not None:
            self._Tag = AccessRuleTagInfo()
            self._Tag._deserialize(params.get("Tag"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AccessRuleKeyValueInfo(AbstractModel):
    r"""DescribeAccessIndex接口的出参

    """

    def __init__(self):
        r"""
        :param _CaseSensitive: 是否大小写敏感
        :type CaseSensitive: bool
        :param _KeyValues: 需要建立索引的键值对信息；最大只能配置100个键值对
        :type KeyValues: list of AccessKeyValueInfo
        """
        self._CaseSensitive = None
        self._KeyValues = None

    @property
    def CaseSensitive(self):
        r"""是否大小写敏感
        :rtype: bool
        """
        return self._CaseSensitive

    @CaseSensitive.setter
    def CaseSensitive(self, CaseSensitive):
        self._CaseSensitive = CaseSensitive

    @property
    def KeyValues(self):
        r"""需要建立索引的键值对信息；最大只能配置100个键值对
        :rtype: list of AccessKeyValueInfo
        """
        return self._KeyValues

    @KeyValues.setter
    def KeyValues(self, KeyValues):
        self._KeyValues = KeyValues


    def _deserialize(self, params):
        self._CaseSensitive = params.get("CaseSensitive")
        if params.get("KeyValues") is not None:
            self._KeyValues = []
            for item in params.get("KeyValues"):
                obj = AccessKeyValueInfo()
                obj._deserialize(item)
                self._KeyValues.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AccessRuleTagInfo(AbstractModel):
    r"""DescribeAccessIndex接口的出参

    """

    def __init__(self):
        r"""
        :param _CaseSensitive: 是否大小写敏感
        :type CaseSensitive: bool
        :param _KeyValues: 标签索引配置中的字段信息
        :type KeyValues: list of AccessKeyValueInfo
        """
        self._CaseSensitive = None
        self._KeyValues = None

    @property
    def CaseSensitive(self):
        r"""是否大小写敏感
        :rtype: bool
        """
        return self._CaseSensitive

    @CaseSensitive.setter
    def CaseSensitive(self, CaseSensitive):
        self._CaseSensitive = CaseSensitive

    @property
    def KeyValues(self):
        r"""标签索引配置中的字段信息
        :rtype: list of AccessKeyValueInfo
        """
        return self._KeyValues

    @KeyValues.setter
    def KeyValues(self, KeyValues):
        self._KeyValues = KeyValues


    def _deserialize(self, params):
        self._CaseSensitive = params.get("CaseSensitive")
        if params.get("KeyValues") is not None:
            self._KeyValues = []
            for item in params.get("KeyValues"):
                obj = AccessKeyValueInfo()
                obj._deserialize(item)
                self._KeyValues.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AccessValueInfo(AbstractModel):
    r"""用于DescribeAccessIndex接口的出参

    """

    def __init__(self):
        r"""
        :param _Type: 字段类型，目前支持的类型有：long、text、double
        :type Type: str
        :param _Tokenizer: 字段的分词符，只有当字段类型为text时才有意义；输入字符串中的每个字符代表一个分词符
        :type Tokenizer: str
        :param _SqlFlag: 字段是否开启分析功能
        :type SqlFlag: bool
        :param _ContainZH: 是否包含中文
注意：此字段可能返回 null，表示取不到有效值。
        :type ContainZH: bool
        """
        self._Type = None
        self._Tokenizer = None
        self._SqlFlag = None
        self._ContainZH = None

    @property
    def Type(self):
        r"""字段类型，目前支持的类型有：long、text、double
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Tokenizer(self):
        r"""字段的分词符，只有当字段类型为text时才有意义；输入字符串中的每个字符代表一个分词符
        :rtype: str
        """
        return self._Tokenizer

    @Tokenizer.setter
    def Tokenizer(self, Tokenizer):
        self._Tokenizer = Tokenizer

    @property
    def SqlFlag(self):
        r"""字段是否开启分析功能
        :rtype: bool
        """
        return self._SqlFlag

    @SqlFlag.setter
    def SqlFlag(self, SqlFlag):
        self._SqlFlag = SqlFlag

    @property
    def ContainZH(self):
        r"""是否包含中文
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._ContainZH

    @ContainZH.setter
    def ContainZH(self, ContainZH):
        self._ContainZH = ContainZH


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._Tokenizer = params.get("Tokenizer")
        self._SqlFlag = params.get("SqlFlag")
        self._ContainZH = params.get("ContainZH")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddAntiFakeUrlRequest(AbstractModel):
    r"""AddAntiFakeUrl请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _Name: 名称
        :type Name: str
        :param _Uri: uri
        :type Uri: str
        """
        self._Domain = None
        self._Name = None
        self._Uri = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Name(self):
        r"""名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Uri(self):
        r"""uri
        :rtype: str
        """
        return self._Uri

    @Uri.setter
    def Uri(self, Uri):
        self._Uri = Uri


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Name = params.get("Name")
        self._Uri = params.get("Uri")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddAntiFakeUrlResponse(AbstractModel):
    r"""AddAntiFakeUrl返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 结果
        :type Result: str
        :param _Id: 规则ID
        :type Id: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._Id = None
        self._RequestId = None

    @property
    def Result(self):
        r"""结果
        :rtype: str
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def Id(self):
        r"""规则ID
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._Id = params.get("Id")
        self._RequestId = params.get("RequestId")


class AddAntiInfoLeakRulesRequest(AbstractModel):
    r"""AddAntiInfoLeakRules请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _Name: 规则名称
        :type Name: str
        :param _ActionType: 动作，0（告警）、1（替换）、2（仅显示前四位）、3（仅显示后四位）、4（阻断）
        :type ActionType: int
        :param _Strategies: 策略详情
        :type Strategies: list of StrategyForAntiInfoLeak
        :param _Uri: 网址
        :type Uri: str
        """
        self._Domain = None
        self._Name = None
        self._ActionType = None
        self._Strategies = None
        self._Uri = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Name(self):
        r"""规则名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def ActionType(self):
        r"""动作，0（告警）、1（替换）、2（仅显示前四位）、3（仅显示后四位）、4（阻断）
        :rtype: int
        """
        return self._ActionType

    @ActionType.setter
    def ActionType(self, ActionType):
        self._ActionType = ActionType

    @property
    def Strategies(self):
        r"""策略详情
        :rtype: list of StrategyForAntiInfoLeak
        """
        return self._Strategies

    @Strategies.setter
    def Strategies(self, Strategies):
        self._Strategies = Strategies

    @property
    def Uri(self):
        r"""网址
        :rtype: str
        """
        return self._Uri

    @Uri.setter
    def Uri(self, Uri):
        self._Uri = Uri


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Name = params.get("Name")
        self._ActionType = params.get("ActionType")
        if params.get("Strategies") is not None:
            self._Strategies = []
            for item in params.get("Strategies"):
                obj = StrategyForAntiInfoLeak()
                obj._deserialize(item)
                self._Strategies.append(obj)
        self._Uri = params.get("Uri")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddAntiInfoLeakRulesResponse(AbstractModel):
    r"""AddAntiInfoLeakRules返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleId: 规则ID
        :type RuleId: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RuleId = None
        self._RequestId = None

    @property
    def RuleId(self):
        r"""规则ID
        :rtype: int
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RuleId = params.get("RuleId")
        self._RequestId = params.get("RequestId")


class AddAreaBanAreasRequest(AbstractModel):
    r"""AddAreaBanAreas请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 需要修改的域名
        :type Domain: str
        :param _Areas: 需要新增的封禁地域
        :type Areas: list of str
        :param _Edition: waf版本信息，spart-waf或者clb-waf，其他无效，请一定填写
        :type Edition: str
        :param _JobType: 规则执行的方式，TimedJob为定时执行，CronJob为周期执行
        :type JobType: str
        :param _JobDateTime: 定时任务配置
        :type JobDateTime: :class:`tencentcloud.waf.v20180125.models.JobDateTime`
        """
        self._Domain = None
        self._Areas = None
        self._Edition = None
        self._JobType = None
        self._JobDateTime = None

    @property
    def Domain(self):
        r"""需要修改的域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Areas(self):
        r"""需要新增的封禁地域
        :rtype: list of str
        """
        return self._Areas

    @Areas.setter
    def Areas(self, Areas):
        self._Areas = Areas

    @property
    def Edition(self):
        r"""waf版本信息，spart-waf或者clb-waf，其他无效，请一定填写
        :rtype: str
        """
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition

    @property
    def JobType(self):
        r"""规则执行的方式，TimedJob为定时执行，CronJob为周期执行
        :rtype: str
        """
        return self._JobType

    @JobType.setter
    def JobType(self, JobType):
        self._JobType = JobType

    @property
    def JobDateTime(self):
        r"""定时任务配置
        :rtype: :class:`tencentcloud.waf.v20180125.models.JobDateTime`
        """
        return self._JobDateTime

    @JobDateTime.setter
    def JobDateTime(self, JobDateTime):
        self._JobDateTime = JobDateTime


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Areas = params.get("Areas")
        self._Edition = params.get("Edition")
        self._JobType = params.get("JobType")
        if params.get("JobDateTime") is not None:
            self._JobDateTime = JobDateTime()
            self._JobDateTime._deserialize(params.get("JobDateTime"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddAreaBanAreasResponse(AbstractModel):
    r"""AddAreaBanAreas返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AddAttackWhiteRuleRequest(AbstractModel):
    r"""AddAttackWhiteRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _Status: 规则状态
        :type Status: int
        :param _Rules: 匹配规则项列表
        :type Rules: list of UserWhiteRuleItem
        :param _RuleId: 规则序号
        :type RuleId: int
        :param _SignatureId: 规则Id
        :type SignatureId: str
        :param _SignatureIds: 加白的规则ID列表
        :type SignatureIds: list of str
        :param _TypeIds: 加白的大类规则ID
        :type TypeIds: list of str
        :param _Mode: 0:按照特定规则ID加白, 1:按照规则类型加白
        :type Mode: int
        :param _Name: 规则名
        :type Name: str
        """
        self._Domain = None
        self._Status = None
        self._Rules = None
        self._RuleId = None
        self._SignatureId = None
        self._SignatureIds = None
        self._TypeIds = None
        self._Mode = None
        self._Name = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Status(self):
        r"""规则状态
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Rules(self):
        r"""匹配规则项列表
        :rtype: list of UserWhiteRuleItem
        """
        return self._Rules

    @Rules.setter
    def Rules(self, Rules):
        self._Rules = Rules

    @property
    def RuleId(self):
        r"""规则序号
        :rtype: int
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def SignatureId(self):
        r"""规则Id
        :rtype: str
        """
        return self._SignatureId

    @SignatureId.setter
    def SignatureId(self, SignatureId):
        self._SignatureId = SignatureId

    @property
    def SignatureIds(self):
        r"""加白的规则ID列表
        :rtype: list of str
        """
        return self._SignatureIds

    @SignatureIds.setter
    def SignatureIds(self, SignatureIds):
        self._SignatureIds = SignatureIds

    @property
    def TypeIds(self):
        r"""加白的大类规则ID
        :rtype: list of str
        """
        return self._TypeIds

    @TypeIds.setter
    def TypeIds(self, TypeIds):
        self._TypeIds = TypeIds

    @property
    def Mode(self):
        r"""0:按照特定规则ID加白, 1:按照规则类型加白
        :rtype: int
        """
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode

    @property
    def Name(self):
        r"""规则名
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Status = params.get("Status")
        if params.get("Rules") is not None:
            self._Rules = []
            for item in params.get("Rules"):
                obj = UserWhiteRuleItem()
                obj._deserialize(item)
                self._Rules.append(obj)
        self._RuleId = params.get("RuleId")
        self._SignatureId = params.get("SignatureId")
        self._SignatureIds = params.get("SignatureIds")
        self._TypeIds = params.get("TypeIds")
        self._Mode = params.get("Mode")
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddAttackWhiteRuleResponse(AbstractModel):
    r"""AddAttackWhiteRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleId: 规则总数
        :type RuleId: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RuleId = None
        self._RequestId = None

    @property
    def RuleId(self):
        r"""规则总数
        :rtype: int
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RuleId = params.get("RuleId")
        self._RequestId = params.get("RequestId")


class AddCustomRuleRequest(AbstractModel):
    r"""AddCustomRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 规则名称
        :type Name: str
        :param _SortId: 优先级
        :type SortId: str
        :param _Strategies: 策略详情
        :type Strategies: list of Strategy
        :param _Domain: 需要添加策略的域名
        :type Domain: str
        :param _ActionType: 动作类型，1代表阻断，2代表人机识别，3代表观察，4代表重定向，5代表JS校验
        :type ActionType: str
        :param _Redirect: 如果动作是重定向，则表示重定向的地址；其他情况可以为空
        :type Redirect: str
        :param _ExpireTime: 过期时间，单位为秒级时间戳，例如1677254399表示过期时间为2023-02-24 23:59:59. 0表示永不过期
        :type ExpireTime: str
        :param _Edition: WAF实例类型，sparta-waf表示SAAS型WAF，clb-waf表示负载均衡型WAF
        :type Edition: str
        :param _Bypass: 放行时是否继续执行其它检查逻辑，继续执行地域封禁防护：geoip、继续执行CC策略防护：cc、继续执行WEB应用防护：owasp、继续执行AI引擎防护：ai、继续执行信息防泄漏防护：antileakage。如果多个勾选那么以,串接。默认是"geoip,cc,owasp,ai,antileakage"
        :type Bypass: str
        :param _EventId: 添加规则的来源，默认为空
        :type EventId: str
        :param _JobType: 规则执行的方式，TimedJob为定时执行，CronJob为周期执行
        :type JobType: str
        :param _JobDateTime: 规则执行的时间
        :type JobDateTime: :class:`tencentcloud.waf.v20180125.models.JobDateTime`
        :param _Source: 规则来源，判断是不是小程序的
        :type Source: str
        :param _Label: 规则标签，小程序规则用，标识是内置规则还是自定义规则
        :type Label: str
        :param _Status: 开关状态，小程序风控规则的时候传该值
        :type Status: int
        :param _PageId: 拦截页面id
        :type PageId: str
        :param _LogicalOp: 匹配条件的逻辑关系，支持and、or，分别表示多个逻辑匹配条件是与、或的关系
        :type LogicalOp: str
        :param _ActionRatio: 按照动作灰度的比例，默认是100
        :type ActionRatio: int
        """
        self._Name = None
        self._SortId = None
        self._Strategies = None
        self._Domain = None
        self._ActionType = None
        self._Redirect = None
        self._ExpireTime = None
        self._Edition = None
        self._Bypass = None
        self._EventId = None
        self._JobType = None
        self._JobDateTime = None
        self._Source = None
        self._Label = None
        self._Status = None
        self._PageId = None
        self._LogicalOp = None
        self._ActionRatio = None

    @property
    def Name(self):
        r"""规则名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def SortId(self):
        r"""优先级
        :rtype: str
        """
        return self._SortId

    @SortId.setter
    def SortId(self, SortId):
        self._SortId = SortId

    @property
    def Strategies(self):
        r"""策略详情
        :rtype: list of Strategy
        """
        return self._Strategies

    @Strategies.setter
    def Strategies(self, Strategies):
        self._Strategies = Strategies

    @property
    def Domain(self):
        r"""需要添加策略的域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def ActionType(self):
        r"""动作类型，1代表阻断，2代表人机识别，3代表观察，4代表重定向，5代表JS校验
        :rtype: str
        """
        return self._ActionType

    @ActionType.setter
    def ActionType(self, ActionType):
        self._ActionType = ActionType

    @property
    def Redirect(self):
        r"""如果动作是重定向，则表示重定向的地址；其他情况可以为空
        :rtype: str
        """
        return self._Redirect

    @Redirect.setter
    def Redirect(self, Redirect):
        self._Redirect = Redirect

    @property
    def ExpireTime(self):
        r"""过期时间，单位为秒级时间戳，例如1677254399表示过期时间为2023-02-24 23:59:59. 0表示永不过期
        :rtype: str
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def Edition(self):
        r"""WAF实例类型，sparta-waf表示SAAS型WAF，clb-waf表示负载均衡型WAF
        :rtype: str
        """
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition

    @property
    def Bypass(self):
        warnings.warn("parameter `Bypass` is deprecated", DeprecationWarning) 

        r"""放行时是否继续执行其它检查逻辑，继续执行地域封禁防护：geoip、继续执行CC策略防护：cc、继续执行WEB应用防护：owasp、继续执行AI引擎防护：ai、继续执行信息防泄漏防护：antileakage。如果多个勾选那么以,串接。默认是"geoip,cc,owasp,ai,antileakage"
        :rtype: str
        """
        return self._Bypass

    @Bypass.setter
    def Bypass(self, Bypass):
        warnings.warn("parameter `Bypass` is deprecated", DeprecationWarning) 

        self._Bypass = Bypass

    @property
    def EventId(self):
        r"""添加规则的来源，默认为空
        :rtype: str
        """
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId

    @property
    def JobType(self):
        r"""规则执行的方式，TimedJob为定时执行，CronJob为周期执行
        :rtype: str
        """
        return self._JobType

    @JobType.setter
    def JobType(self, JobType):
        self._JobType = JobType

    @property
    def JobDateTime(self):
        r"""规则执行的时间
        :rtype: :class:`tencentcloud.waf.v20180125.models.JobDateTime`
        """
        return self._JobDateTime

    @JobDateTime.setter
    def JobDateTime(self, JobDateTime):
        self._JobDateTime = JobDateTime

    @property
    def Source(self):
        r"""规则来源，判断是不是小程序的
        :rtype: str
        """
        return self._Source

    @Source.setter
    def Source(self, Source):
        self._Source = Source

    @property
    def Label(self):
        r"""规则标签，小程序规则用，标识是内置规则还是自定义规则
        :rtype: str
        """
        return self._Label

    @Label.setter
    def Label(self, Label):
        self._Label = Label

    @property
    def Status(self):
        r"""开关状态，小程序风控规则的时候传该值
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def PageId(self):
        r"""拦截页面id
        :rtype: str
        """
        return self._PageId

    @PageId.setter
    def PageId(self, PageId):
        self._PageId = PageId

    @property
    def LogicalOp(self):
        r"""匹配条件的逻辑关系，支持and、or，分别表示多个逻辑匹配条件是与、或的关系
        :rtype: str
        """
        return self._LogicalOp

    @LogicalOp.setter
    def LogicalOp(self, LogicalOp):
        self._LogicalOp = LogicalOp

    @property
    def ActionRatio(self):
        r"""按照动作灰度的比例，默认是100
        :rtype: int
        """
        return self._ActionRatio

    @ActionRatio.setter
    def ActionRatio(self, ActionRatio):
        self._ActionRatio = ActionRatio


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._SortId = params.get("SortId")
        if params.get("Strategies") is not None:
            self._Strategies = []
            for item in params.get("Strategies"):
                obj = Strategy()
                obj._deserialize(item)
                self._Strategies.append(obj)
        self._Domain = params.get("Domain")
        self._ActionType = params.get("ActionType")
        self._Redirect = params.get("Redirect")
        self._ExpireTime = params.get("ExpireTime")
        self._Edition = params.get("Edition")
        self._Bypass = params.get("Bypass")
        self._EventId = params.get("EventId")
        self._JobType = params.get("JobType")
        if params.get("JobDateTime") is not None:
            self._JobDateTime = JobDateTime()
            self._JobDateTime._deserialize(params.get("JobDateTime"))
        self._Source = params.get("Source")
        self._Label = params.get("Label")
        self._Status = params.get("Status")
        self._PageId = params.get("PageId")
        self._LogicalOp = params.get("LogicalOp")
        self._ActionRatio = params.get("ActionRatio")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddCustomRuleResponse(AbstractModel):
    r"""AddCustomRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Success: 操作的状态码，如果所有的资源操作成功则返回的是成功的状态码，如果有资源操作失败则需要解析Message的内容来查看哪个资源失败
        :type Success: :class:`tencentcloud.waf.v20180125.models.ResponseCode`
        :param _RuleId: 添加成功的规则ID
        :type RuleId: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Success = None
        self._RuleId = None
        self._RequestId = None

    @property
    def Success(self):
        r"""操作的状态码，如果所有的资源操作成功则返回的是成功的状态码，如果有资源操作失败则需要解析Message的内容来查看哪个资源失败
        :rtype: :class:`tencentcloud.waf.v20180125.models.ResponseCode`
        """
        return self._Success

    @Success.setter
    def Success(self, Success):
        self._Success = Success

    @property
    def RuleId(self):
        r"""添加成功的规则ID
        :rtype: int
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Success") is not None:
            self._Success = ResponseCode()
            self._Success._deserialize(params.get("Success"))
        self._RuleId = params.get("RuleId")
        self._RequestId = params.get("RequestId")


class AddCustomWhiteRuleRequest(AbstractModel):
    r"""AddCustomWhiteRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 规则名称
        :type Name: str
        :param _SortId: 优先级
        :type SortId: str
        :param _Strategies: 策略详情
        :type Strategies: list of Strategy
        :param _Domain: 需要添加策略的域名
        :type Domain: str
        :param _Bypass: 放行的模块，多个模块之间用逗号连接。支持的模块：acl（自定义规则）、owasp（规则引擎）、webshell（恶意文件检测）、geoip（地域封禁）、bwip（IP黑白名单）、cc、botrpc（BOT防护）、antileakage（信息防泄露）、api（API安全）、ai（AI引擎）、ip_auto_deny（IP封禁）、applet（小程序流量风控）
        :type Bypass: str
        :param _ExpireTime: 如果没有设置JobDateTime字段则用此字段，0表示永久生效，其它表示定时生效的截止时间（单位为秒）
        :type ExpireTime: str
        :param _JobType: 规则执行的方式，TimedJob为定时执行，CronJob为周期执行
        :type JobType: str
        :param _JobDateTime: 定时任务配置
        :type JobDateTime: :class:`tencentcloud.waf.v20180125.models.JobDateTime`
        :param _LogicalOp: 匹配条件的逻辑关系，支持and、or，分别表示多个逻辑匹配条件是与、或的关系
        :type LogicalOp: str
        """
        self._Name = None
        self._SortId = None
        self._Strategies = None
        self._Domain = None
        self._Bypass = None
        self._ExpireTime = None
        self._JobType = None
        self._JobDateTime = None
        self._LogicalOp = None

    @property
    def Name(self):
        r"""规则名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def SortId(self):
        r"""优先级
        :rtype: str
        """
        return self._SortId

    @SortId.setter
    def SortId(self, SortId):
        self._SortId = SortId

    @property
    def Strategies(self):
        r"""策略详情
        :rtype: list of Strategy
        """
        return self._Strategies

    @Strategies.setter
    def Strategies(self, Strategies):
        self._Strategies = Strategies

    @property
    def Domain(self):
        r"""需要添加策略的域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Bypass(self):
        r"""放行的模块，多个模块之间用逗号连接。支持的模块：acl（自定义规则）、owasp（规则引擎）、webshell（恶意文件检测）、geoip（地域封禁）、bwip（IP黑白名单）、cc、botrpc（BOT防护）、antileakage（信息防泄露）、api（API安全）、ai（AI引擎）、ip_auto_deny（IP封禁）、applet（小程序流量风控）
        :rtype: str
        """
        return self._Bypass

    @Bypass.setter
    def Bypass(self, Bypass):
        self._Bypass = Bypass

    @property
    def ExpireTime(self):
        r"""如果没有设置JobDateTime字段则用此字段，0表示永久生效，其它表示定时生效的截止时间（单位为秒）
        :rtype: str
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def JobType(self):
        r"""规则执行的方式，TimedJob为定时执行，CronJob为周期执行
        :rtype: str
        """
        return self._JobType

    @JobType.setter
    def JobType(self, JobType):
        self._JobType = JobType

    @property
    def JobDateTime(self):
        r"""定时任务配置
        :rtype: :class:`tencentcloud.waf.v20180125.models.JobDateTime`
        """
        return self._JobDateTime

    @JobDateTime.setter
    def JobDateTime(self, JobDateTime):
        self._JobDateTime = JobDateTime

    @property
    def LogicalOp(self):
        r"""匹配条件的逻辑关系，支持and、or，分别表示多个逻辑匹配条件是与、或的关系
        :rtype: str
        """
        return self._LogicalOp

    @LogicalOp.setter
    def LogicalOp(self, LogicalOp):
        self._LogicalOp = LogicalOp


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._SortId = params.get("SortId")
        if params.get("Strategies") is not None:
            self._Strategies = []
            for item in params.get("Strategies"):
                obj = Strategy()
                obj._deserialize(item)
                self._Strategies.append(obj)
        self._Domain = params.get("Domain")
        self._Bypass = params.get("Bypass")
        self._ExpireTime = params.get("ExpireTime")
        self._JobType = params.get("JobType")
        if params.get("JobDateTime") is not None:
            self._JobDateTime = JobDateTime()
            self._JobDateTime._deserialize(params.get("JobDateTime"))
        self._LogicalOp = params.get("LogicalOp")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddCustomWhiteRuleResponse(AbstractModel):
    r"""AddCustomWhiteRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Success: 操作的状态码，如果所有的资源操作成功则返回的是成功的状态码，如果有资源操作失败则需要解析Message的内容来查看哪个资源失败
        :type Success: :class:`tencentcloud.waf.v20180125.models.ResponseCode`
        :param _RuleId: 添加成功的规则ID
        :type RuleId: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Success = None
        self._RuleId = None
        self._RequestId = None

    @property
    def Success(self):
        r"""操作的状态码，如果所有的资源操作成功则返回的是成功的状态码，如果有资源操作失败则需要解析Message的内容来查看哪个资源失败
        :rtype: :class:`tencentcloud.waf.v20180125.models.ResponseCode`
        """
        return self._Success

    @Success.setter
    def Success(self, Success):
        self._Success = Success

    @property
    def RuleId(self):
        r"""添加成功的规则ID
        :rtype: int
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Success") is not None:
            self._Success = ResponseCode()
            self._Success._deserialize(params.get("Success"))
        self._RuleId = params.get("RuleId")
        self._RequestId = params.get("RequestId")


class AddDomainWhiteRuleRequest(AbstractModel):
    r"""AddDomainWhiteRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 需要添加的域名
        :type Domain: str
        :param _Rules: 需要添加的规则
        :type Rules: list of int non-negative
        :param _Url: 需要添加的规则url
        :type Url: str
        :param _Function: 规则的方法
        :type Function: str
        :param _Status: 规则的开关，0表示规则关闭，1表示规则打开
        :type Status: int
        """
        self._Domain = None
        self._Rules = None
        self._Url = None
        self._Function = None
        self._Status = None

    @property
    def Domain(self):
        r"""需要添加的域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Rules(self):
        r"""需要添加的规则
        :rtype: list of int non-negative
        """
        return self._Rules

    @Rules.setter
    def Rules(self, Rules):
        self._Rules = Rules

    @property
    def Url(self):
        r"""需要添加的规则url
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def Function(self):
        r"""规则的方法
        :rtype: str
        """
        return self._Function

    @Function.setter
    def Function(self, Function):
        self._Function = Function

    @property
    def Status(self):
        r"""规则的开关，0表示规则关闭，1表示规则打开
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Rules = params.get("Rules")
        self._Url = params.get("Url")
        self._Function = params.get("Function")
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddDomainWhiteRuleResponse(AbstractModel):
    r"""AddDomainWhiteRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: 规则id
        :type Id: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Id = None
        self._RequestId = None

    @property
    def Id(self):
        r"""规则id
        :rtype: int
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._RequestId = params.get("RequestId")


class AddSpartaProtectionRequest(AbstractModel):
    r"""AddSpartaProtection请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 需要防护的域名
        :type Domain: str
        :param _CertType: 证书类型。
0：仅配置HTTP监听端口，没有证书
1：证书来源为自有证书
2：证书来源为托管证书
        :type CertType: int
        :param _IsCdn: waf前是否部署有七层代理服务。
0：没有部署代理服务
1：有部署代理服务，waf将使用XFF获取客户端IP
2：有部署代理服务，waf将使用remote_addr获取客户端IP
3：有部署代理服务，waf将使用ip_headers中的自定义header获取客户端IP
        :type IsCdn: int
        :param _UpstreamType: 回源类型。
0：通过IP回源
1：通过域名回源
        :type UpstreamType: int
        :param _IsWebsocket: 是否开启WebSocket支持。
0：关闭
1：开启
        :type IsWebsocket: int
        :param _LoadBalance: 回源负载均衡策略。
0：轮询
1：IP hash
2：加权轮询
        :type LoadBalance: str
        :param _Ports: 服务端口列表配置。
NginxServerId：新增域名时填'0'
Port：监听端口号
Protocol：端口协议
UpstreamPort：与Port相同
UpstreamProtocol：与Protocol相同
        :type Ports: list of PortItem
        :param _IsKeepAlive: 必填项，是否开启长连接。
0： 短连接
1： 长连接
        :type IsKeepAlive: str
        :param _InstanceID: 必填项，域名所属实例id
        :type InstanceID: str
        :param _HttpsRewrite: 是否开启HTTP强制跳转到HTTPS。0：不强制跳转1：开启强制跳转
        :type HttpsRewrite: int
        :param _IsHttp2: 是否开启HTTP2，需要开启HTTPS协议支持。0：关闭1：开启
        :type IsHttp2: int
        :param _ActiveCheck: 是否开启主动健康检测。0：不开启1：开启
        :type ActiveCheck: int
        :param _CipherTemplate: 加密套件模板。0：不支持选择，使用默认模板  1：通用型模板 2：安全型模板3：自定义模板
        :type CipherTemplate: int
        :param _Cert: CertType为1时，需要填充此参数，表示自有证书的证书链
        :type Cert: str
        :param _PrivateKey: CertType为1时，需要填充此参数，表示自有证书的私钥
        :type PrivateKey: str
        :param _SSLId: CertType为2时，需要填充此参数，表示腾讯云SSL平台托管的证书id
        :type SSLId: str
        :param _ResourceId: Waf的资源ID。
        :type ResourceId: str
        :param _IpHeaders: IsCdn为3时，需要填此参数，表示自定义header
        :type IpHeaders: list of str
        :param _UpstreamScheme: 服务配置有HTTPS端口时，HTTPS的回源协议。
http：使用http协议回源，和HttpsUpstreamPort配合使用
https：使用https协议回源
        :type UpstreamScheme: str
        :param _HttpsUpstreamPort: HTTPS回源端口,仅UpstreamScheme为http时需要填当前字段
        :type HttpsUpstreamPort: str
        :param _IsGray: 是否开启灰度，0表示不开启灰度。
        :type IsGray: int
        :param _GrayAreas: 灰度的地区
        :type GrayAreas: list of str
        :param _UpstreamDomain: 域名回源时的回源域名。UpstreamType为1时，需要填充此字段
        :type UpstreamDomain: str
        :param _SrcList: IP回源时的回源IP列表。UpstreamType为0时，需要填充此字段
        :type SrcList: list of str
        :param _Edition: WAF实例类型。
sparta-waf：SAAS型WAF
clb-waf：负载均衡型WAF
cdn-waf：CDN上的Web防护能力
        :type Edition: str
        :param _Anycast: 目前填0即可。anycast IP类型开关： 0 普通IP 1 Anycast IP
        :type Anycast: int
        :param _Weights: 回源IP列表各IP的权重，和SrcList一一对应。当且仅当UpstreamType为0，并且SrcList有多个IP，并且LoadBalance为2时需要填写，否则填 []
        :type Weights: list of int
        :param _TLSVersion: TLS版本信息
        :type TLSVersion: int
        :param _Ciphers: 自定义的加密套件列表。CipherTemplate为3时需要填此字段，表示自定义的加密套件，值通过DescribeCiphersDetail接口获取。
        :type Ciphers: list of int
        :param _ProxyConnectTimeout: WAF与源站的连接超时，默认10s。
        :type ProxyConnectTimeout: int
        :param _ProxyReadTimeout: WAF与源站的读超时时间，默认300s。
        :type ProxyReadTimeout: int
        :param _ProxySendTimeout: WAF与源站的写超时时间，默认300s。
        :type ProxySendTimeout: int
        :param _SniType: WAF回源时的SNI类型。
0：关闭SNI，不配置client_hello中的server_name
1：开启SNI，client_hello中的server_name为防护域名
2：开启SNI，SNI为域名回源时的源站域名
3：开启SNI，SNI为自定义域名
        :type SniType: int
        :param _SniHost: SniType为3时，需要填此参数，表示自定义的SNI；
        :type SniHost: str
        :param _XFFReset: 是否开启XFF重置。0：关闭 1：开启
        :type XFFReset: int
        :param _Note: 域名备注信息
        :type Note: str
        :param _UpstreamHost: 自定义回源Host。默认为空字符串，表示使用防护域名作为回源Host。
        :type UpstreamHost: str
        :param _ProxyBuffer: 是否开启缓存。 0：关闭 1：开启
        :type ProxyBuffer: int
        :param _ProbeStatus: 是否开启拨测。 0: 禁用拨测  1: 启用拨测。默认启用拨测
        :type ProbeStatus: int
        :param _GmType: 国密选项。0：不开启国密 1：在原有TLS选项的基础上追加支持国密 2：开启国密并仅支持国密客户端访问
        :type GmType: int
        :param _GmCertType: 国密证书类型。0：无国密证书 1：证书来源为自有国密证书 2：证书来源为托管国密证书
        :type GmCertType: int
        :param _GmCert: GmCertType为1时，需要填充此参数，表示自有国密证书的证书链
        :type GmCert: str
        :param _GmPrivateKey: GmCertType为1时，需要填充此参数，表示自有国密证书的私钥
        :type GmPrivateKey: str
        :param _GmEncCert: GmCertType为1时，需要填充此参数，表示自有国密证书的加密证书
        :type GmEncCert: str
        :param _GmEncPrivateKey: GmCertType为1时，需要填充此参数，表示自有国密证书的加密证书的私钥
        :type GmEncPrivateKey: str
        :param _GmSSLId: GmCertType为2时，需要填充此参数，表示腾讯云SSL平台托管的证书id
        :type GmSSLId: str
        :param _UpstreamPolicy: 回源策略，支持负载均衡回源和分流回源两种方式。0：默认值，负载均衡回源；1：分流回源
        :type UpstreamPolicy: int
        :param _UpstreamRules: 分流回源时生效，分流回源的规则。
        :type UpstreamRules: list of UpstreamRule
        :param _UseCase: 业务场景。0：默认值，表示常规业务场景 1：大模型业务场景
        :type UseCase: int
        :param _Gzip: gzip开关。0：关闭 1：默认值，打开。
        :type Gzip: int
        """
        self._Domain = None
        self._CertType = None
        self._IsCdn = None
        self._UpstreamType = None
        self._IsWebsocket = None
        self._LoadBalance = None
        self._Ports = None
        self._IsKeepAlive = None
        self._InstanceID = None
        self._HttpsRewrite = None
        self._IsHttp2 = None
        self._ActiveCheck = None
        self._CipherTemplate = None
        self._Cert = None
        self._PrivateKey = None
        self._SSLId = None
        self._ResourceId = None
        self._IpHeaders = None
        self._UpstreamScheme = None
        self._HttpsUpstreamPort = None
        self._IsGray = None
        self._GrayAreas = None
        self._UpstreamDomain = None
        self._SrcList = None
        self._Edition = None
        self._Anycast = None
        self._Weights = None
        self._TLSVersion = None
        self._Ciphers = None
        self._ProxyConnectTimeout = None
        self._ProxyReadTimeout = None
        self._ProxySendTimeout = None
        self._SniType = None
        self._SniHost = None
        self._XFFReset = None
        self._Note = None
        self._UpstreamHost = None
        self._ProxyBuffer = None
        self._ProbeStatus = None
        self._GmType = None
        self._GmCertType = None
        self._GmCert = None
        self._GmPrivateKey = None
        self._GmEncCert = None
        self._GmEncPrivateKey = None
        self._GmSSLId = None
        self._UpstreamPolicy = None
        self._UpstreamRules = None
        self._UseCase = None
        self._Gzip = None

    @property
    def Domain(self):
        r"""需要防护的域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def CertType(self):
        r"""证书类型。
0：仅配置HTTP监听端口，没有证书
1：证书来源为自有证书
2：证书来源为托管证书
        :rtype: int
        """
        return self._CertType

    @CertType.setter
    def CertType(self, CertType):
        self._CertType = CertType

    @property
    def IsCdn(self):
        r"""waf前是否部署有七层代理服务。
0：没有部署代理服务
1：有部署代理服务，waf将使用XFF获取客户端IP
2：有部署代理服务，waf将使用remote_addr获取客户端IP
3：有部署代理服务，waf将使用ip_headers中的自定义header获取客户端IP
        :rtype: int
        """
        return self._IsCdn

    @IsCdn.setter
    def IsCdn(self, IsCdn):
        self._IsCdn = IsCdn

    @property
    def UpstreamType(self):
        r"""回源类型。
0：通过IP回源
1：通过域名回源
        :rtype: int
        """
        return self._UpstreamType

    @UpstreamType.setter
    def UpstreamType(self, UpstreamType):
        self._UpstreamType = UpstreamType

    @property
    def IsWebsocket(self):
        r"""是否开启WebSocket支持。
0：关闭
1：开启
        :rtype: int
        """
        return self._IsWebsocket

    @IsWebsocket.setter
    def IsWebsocket(self, IsWebsocket):
        self._IsWebsocket = IsWebsocket

    @property
    def LoadBalance(self):
        r"""回源负载均衡策略。
0：轮询
1：IP hash
2：加权轮询
        :rtype: str
        """
        return self._LoadBalance

    @LoadBalance.setter
    def LoadBalance(self, LoadBalance):
        self._LoadBalance = LoadBalance

    @property
    def Ports(self):
        r"""服务端口列表配置。
NginxServerId：新增域名时填'0'
Port：监听端口号
Protocol：端口协议
UpstreamPort：与Port相同
UpstreamProtocol：与Protocol相同
        :rtype: list of PortItem
        """
        return self._Ports

    @Ports.setter
    def Ports(self, Ports):
        self._Ports = Ports

    @property
    def IsKeepAlive(self):
        r"""必填项，是否开启长连接。
0： 短连接
1： 长连接
        :rtype: str
        """
        return self._IsKeepAlive

    @IsKeepAlive.setter
    def IsKeepAlive(self, IsKeepAlive):
        self._IsKeepAlive = IsKeepAlive

    @property
    def InstanceID(self):
        r"""必填项，域名所属实例id
        :rtype: str
        """
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID

    @property
    def HttpsRewrite(self):
        r"""是否开启HTTP强制跳转到HTTPS。0：不强制跳转1：开启强制跳转
        :rtype: int
        """
        return self._HttpsRewrite

    @HttpsRewrite.setter
    def HttpsRewrite(self, HttpsRewrite):
        self._HttpsRewrite = HttpsRewrite

    @property
    def IsHttp2(self):
        r"""是否开启HTTP2，需要开启HTTPS协议支持。0：关闭1：开启
        :rtype: int
        """
        return self._IsHttp2

    @IsHttp2.setter
    def IsHttp2(self, IsHttp2):
        self._IsHttp2 = IsHttp2

    @property
    def ActiveCheck(self):
        r"""是否开启主动健康检测。0：不开启1：开启
        :rtype: int
        """
        return self._ActiveCheck

    @ActiveCheck.setter
    def ActiveCheck(self, ActiveCheck):
        self._ActiveCheck = ActiveCheck

    @property
    def CipherTemplate(self):
        r"""加密套件模板。0：不支持选择，使用默认模板  1：通用型模板 2：安全型模板3：自定义模板
        :rtype: int
        """
        return self._CipherTemplate

    @CipherTemplate.setter
    def CipherTemplate(self, CipherTemplate):
        self._CipherTemplate = CipherTemplate

    @property
    def Cert(self):
        r"""CertType为1时，需要填充此参数，表示自有证书的证书链
        :rtype: str
        """
        return self._Cert

    @Cert.setter
    def Cert(self, Cert):
        self._Cert = Cert

    @property
    def PrivateKey(self):
        r"""CertType为1时，需要填充此参数，表示自有证书的私钥
        :rtype: str
        """
        return self._PrivateKey

    @PrivateKey.setter
    def PrivateKey(self, PrivateKey):
        self._PrivateKey = PrivateKey

    @property
    def SSLId(self):
        r"""CertType为2时，需要填充此参数，表示腾讯云SSL平台托管的证书id
        :rtype: str
        """
        return self._SSLId

    @SSLId.setter
    def SSLId(self, SSLId):
        self._SSLId = SSLId

    @property
    def ResourceId(self):
        warnings.warn("parameter `ResourceId` is deprecated", DeprecationWarning) 

        r"""Waf的资源ID。
        :rtype: str
        """
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        warnings.warn("parameter `ResourceId` is deprecated", DeprecationWarning) 

        self._ResourceId = ResourceId

    @property
    def IpHeaders(self):
        r"""IsCdn为3时，需要填此参数，表示自定义header
        :rtype: list of str
        """
        return self._IpHeaders

    @IpHeaders.setter
    def IpHeaders(self, IpHeaders):
        self._IpHeaders = IpHeaders

    @property
    def UpstreamScheme(self):
        r"""服务配置有HTTPS端口时，HTTPS的回源协议。
http：使用http协议回源，和HttpsUpstreamPort配合使用
https：使用https协议回源
        :rtype: str
        """
        return self._UpstreamScheme

    @UpstreamScheme.setter
    def UpstreamScheme(self, UpstreamScheme):
        self._UpstreamScheme = UpstreamScheme

    @property
    def HttpsUpstreamPort(self):
        r"""HTTPS回源端口,仅UpstreamScheme为http时需要填当前字段
        :rtype: str
        """
        return self._HttpsUpstreamPort

    @HttpsUpstreamPort.setter
    def HttpsUpstreamPort(self, HttpsUpstreamPort):
        self._HttpsUpstreamPort = HttpsUpstreamPort

    @property
    def IsGray(self):
        warnings.warn("parameter `IsGray` is deprecated", DeprecationWarning) 

        r"""是否开启灰度，0表示不开启灰度。
        :rtype: int
        """
        return self._IsGray

    @IsGray.setter
    def IsGray(self, IsGray):
        warnings.warn("parameter `IsGray` is deprecated", DeprecationWarning) 

        self._IsGray = IsGray

    @property
    def GrayAreas(self):
        warnings.warn("parameter `GrayAreas` is deprecated", DeprecationWarning) 

        r"""灰度的地区
        :rtype: list of str
        """
        return self._GrayAreas

    @GrayAreas.setter
    def GrayAreas(self, GrayAreas):
        warnings.warn("parameter `GrayAreas` is deprecated", DeprecationWarning) 

        self._GrayAreas = GrayAreas

    @property
    def UpstreamDomain(self):
        r"""域名回源时的回源域名。UpstreamType为1时，需要填充此字段
        :rtype: str
        """
        return self._UpstreamDomain

    @UpstreamDomain.setter
    def UpstreamDomain(self, UpstreamDomain):
        self._UpstreamDomain = UpstreamDomain

    @property
    def SrcList(self):
        r"""IP回源时的回源IP列表。UpstreamType为0时，需要填充此字段
        :rtype: list of str
        """
        return self._SrcList

    @SrcList.setter
    def SrcList(self, SrcList):
        self._SrcList = SrcList

    @property
    def Edition(self):
        warnings.warn("parameter `Edition` is deprecated", DeprecationWarning) 

        r"""WAF实例类型。
sparta-waf：SAAS型WAF
clb-waf：负载均衡型WAF
cdn-waf：CDN上的Web防护能力
        :rtype: str
        """
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        warnings.warn("parameter `Edition` is deprecated", DeprecationWarning) 

        self._Edition = Edition

    @property
    def Anycast(self):
        warnings.warn("parameter `Anycast` is deprecated", DeprecationWarning) 

        r"""目前填0即可。anycast IP类型开关： 0 普通IP 1 Anycast IP
        :rtype: int
        """
        return self._Anycast

    @Anycast.setter
    def Anycast(self, Anycast):
        warnings.warn("parameter `Anycast` is deprecated", DeprecationWarning) 

        self._Anycast = Anycast

    @property
    def Weights(self):
        r"""回源IP列表各IP的权重，和SrcList一一对应。当且仅当UpstreamType为0，并且SrcList有多个IP，并且LoadBalance为2时需要填写，否则填 []
        :rtype: list of int
        """
        return self._Weights

    @Weights.setter
    def Weights(self, Weights):
        self._Weights = Weights

    @property
    def TLSVersion(self):
        r"""TLS版本信息
        :rtype: int
        """
        return self._TLSVersion

    @TLSVersion.setter
    def TLSVersion(self, TLSVersion):
        self._TLSVersion = TLSVersion

    @property
    def Ciphers(self):
        r"""自定义的加密套件列表。CipherTemplate为3时需要填此字段，表示自定义的加密套件，值通过DescribeCiphersDetail接口获取。
        :rtype: list of int
        """
        return self._Ciphers

    @Ciphers.setter
    def Ciphers(self, Ciphers):
        self._Ciphers = Ciphers

    @property
    def ProxyConnectTimeout(self):
        r"""WAF与源站的连接超时，默认10s。
        :rtype: int
        """
        return self._ProxyConnectTimeout

    @ProxyConnectTimeout.setter
    def ProxyConnectTimeout(self, ProxyConnectTimeout):
        self._ProxyConnectTimeout = ProxyConnectTimeout

    @property
    def ProxyReadTimeout(self):
        r"""WAF与源站的读超时时间，默认300s。
        :rtype: int
        """
        return self._ProxyReadTimeout

    @ProxyReadTimeout.setter
    def ProxyReadTimeout(self, ProxyReadTimeout):
        self._ProxyReadTimeout = ProxyReadTimeout

    @property
    def ProxySendTimeout(self):
        r"""WAF与源站的写超时时间，默认300s。
        :rtype: int
        """
        return self._ProxySendTimeout

    @ProxySendTimeout.setter
    def ProxySendTimeout(self, ProxySendTimeout):
        self._ProxySendTimeout = ProxySendTimeout

    @property
    def SniType(self):
        r"""WAF回源时的SNI类型。
0：关闭SNI，不配置client_hello中的server_name
1：开启SNI，client_hello中的server_name为防护域名
2：开启SNI，SNI为域名回源时的源站域名
3：开启SNI，SNI为自定义域名
        :rtype: int
        """
        return self._SniType

    @SniType.setter
    def SniType(self, SniType):
        self._SniType = SniType

    @property
    def SniHost(self):
        r"""SniType为3时，需要填此参数，表示自定义的SNI；
        :rtype: str
        """
        return self._SniHost

    @SniHost.setter
    def SniHost(self, SniHost):
        self._SniHost = SniHost

    @property
    def XFFReset(self):
        r"""是否开启XFF重置。0：关闭 1：开启
        :rtype: int
        """
        return self._XFFReset

    @XFFReset.setter
    def XFFReset(self, XFFReset):
        self._XFFReset = XFFReset

    @property
    def Note(self):
        r"""域名备注信息
        :rtype: str
        """
        return self._Note

    @Note.setter
    def Note(self, Note):
        self._Note = Note

    @property
    def UpstreamHost(self):
        r"""自定义回源Host。默认为空字符串，表示使用防护域名作为回源Host。
        :rtype: str
        """
        return self._UpstreamHost

    @UpstreamHost.setter
    def UpstreamHost(self, UpstreamHost):
        self._UpstreamHost = UpstreamHost

    @property
    def ProxyBuffer(self):
        r"""是否开启缓存。 0：关闭 1：开启
        :rtype: int
        """
        return self._ProxyBuffer

    @ProxyBuffer.setter
    def ProxyBuffer(self, ProxyBuffer):
        self._ProxyBuffer = ProxyBuffer

    @property
    def ProbeStatus(self):
        r"""是否开启拨测。 0: 禁用拨测  1: 启用拨测。默认启用拨测
        :rtype: int
        """
        return self._ProbeStatus

    @ProbeStatus.setter
    def ProbeStatus(self, ProbeStatus):
        self._ProbeStatus = ProbeStatus

    @property
    def GmType(self):
        r"""国密选项。0：不开启国密 1：在原有TLS选项的基础上追加支持国密 2：开启国密并仅支持国密客户端访问
        :rtype: int
        """
        return self._GmType

    @GmType.setter
    def GmType(self, GmType):
        self._GmType = GmType

    @property
    def GmCertType(self):
        r"""国密证书类型。0：无国密证书 1：证书来源为自有国密证书 2：证书来源为托管国密证书
        :rtype: int
        """
        return self._GmCertType

    @GmCertType.setter
    def GmCertType(self, GmCertType):
        self._GmCertType = GmCertType

    @property
    def GmCert(self):
        r"""GmCertType为1时，需要填充此参数，表示自有国密证书的证书链
        :rtype: str
        """
        return self._GmCert

    @GmCert.setter
    def GmCert(self, GmCert):
        self._GmCert = GmCert

    @property
    def GmPrivateKey(self):
        r"""GmCertType为1时，需要填充此参数，表示自有国密证书的私钥
        :rtype: str
        """
        return self._GmPrivateKey

    @GmPrivateKey.setter
    def GmPrivateKey(self, GmPrivateKey):
        self._GmPrivateKey = GmPrivateKey

    @property
    def GmEncCert(self):
        r"""GmCertType为1时，需要填充此参数，表示自有国密证书的加密证书
        :rtype: str
        """
        return self._GmEncCert

    @GmEncCert.setter
    def GmEncCert(self, GmEncCert):
        self._GmEncCert = GmEncCert

    @property
    def GmEncPrivateKey(self):
        r"""GmCertType为1时，需要填充此参数，表示自有国密证书的加密证书的私钥
        :rtype: str
        """
        return self._GmEncPrivateKey

    @GmEncPrivateKey.setter
    def GmEncPrivateKey(self, GmEncPrivateKey):
        self._GmEncPrivateKey = GmEncPrivateKey

    @property
    def GmSSLId(self):
        r"""GmCertType为2时，需要填充此参数，表示腾讯云SSL平台托管的证书id
        :rtype: str
        """
        return self._GmSSLId

    @GmSSLId.setter
    def GmSSLId(self, GmSSLId):
        self._GmSSLId = GmSSLId

    @property
    def UpstreamPolicy(self):
        r"""回源策略，支持负载均衡回源和分流回源两种方式。0：默认值，负载均衡回源；1：分流回源
        :rtype: int
        """
        return self._UpstreamPolicy

    @UpstreamPolicy.setter
    def UpstreamPolicy(self, UpstreamPolicy):
        self._UpstreamPolicy = UpstreamPolicy

    @property
    def UpstreamRules(self):
        r"""分流回源时生效，分流回源的规则。
        :rtype: list of UpstreamRule
        """
        return self._UpstreamRules

    @UpstreamRules.setter
    def UpstreamRules(self, UpstreamRules):
        self._UpstreamRules = UpstreamRules

    @property
    def UseCase(self):
        r"""业务场景。0：默认值，表示常规业务场景 1：大模型业务场景
        :rtype: int
        """
        return self._UseCase

    @UseCase.setter
    def UseCase(self, UseCase):
        self._UseCase = UseCase

    @property
    def Gzip(self):
        r"""gzip开关。0：关闭 1：默认值，打开。
        :rtype: int
        """
        return self._Gzip

    @Gzip.setter
    def Gzip(self, Gzip):
        self._Gzip = Gzip


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._CertType = params.get("CertType")
        self._IsCdn = params.get("IsCdn")
        self._UpstreamType = params.get("UpstreamType")
        self._IsWebsocket = params.get("IsWebsocket")
        self._LoadBalance = params.get("LoadBalance")
        if params.get("Ports") is not None:
            self._Ports = []
            for item in params.get("Ports"):
                obj = PortItem()
                obj._deserialize(item)
                self._Ports.append(obj)
        self._IsKeepAlive = params.get("IsKeepAlive")
        self._InstanceID = params.get("InstanceID")
        self._HttpsRewrite = params.get("HttpsRewrite")
        self._IsHttp2 = params.get("IsHttp2")
        self._ActiveCheck = params.get("ActiveCheck")
        self._CipherTemplate = params.get("CipherTemplate")
        self._Cert = params.get("Cert")
        self._PrivateKey = params.get("PrivateKey")
        self._SSLId = params.get("SSLId")
        self._ResourceId = params.get("ResourceId")
        self._IpHeaders = params.get("IpHeaders")
        self._UpstreamScheme = params.get("UpstreamScheme")
        self._HttpsUpstreamPort = params.get("HttpsUpstreamPort")
        self._IsGray = params.get("IsGray")
        self._GrayAreas = params.get("GrayAreas")
        self._UpstreamDomain = params.get("UpstreamDomain")
        self._SrcList = params.get("SrcList")
        self._Edition = params.get("Edition")
        self._Anycast = params.get("Anycast")
        self._Weights = params.get("Weights")
        self._TLSVersion = params.get("TLSVersion")
        self._Ciphers = params.get("Ciphers")
        self._ProxyConnectTimeout = params.get("ProxyConnectTimeout")
        self._ProxyReadTimeout = params.get("ProxyReadTimeout")
        self._ProxySendTimeout = params.get("ProxySendTimeout")
        self._SniType = params.get("SniType")
        self._SniHost = params.get("SniHost")
        self._XFFReset = params.get("XFFReset")
        self._Note = params.get("Note")
        self._UpstreamHost = params.get("UpstreamHost")
        self._ProxyBuffer = params.get("ProxyBuffer")
        self._ProbeStatus = params.get("ProbeStatus")
        self._GmType = params.get("GmType")
        self._GmCertType = params.get("GmCertType")
        self._GmCert = params.get("GmCert")
        self._GmPrivateKey = params.get("GmPrivateKey")
        self._GmEncCert = params.get("GmEncCert")
        self._GmEncPrivateKey = params.get("GmEncPrivateKey")
        self._GmSSLId = params.get("GmSSLId")
        self._UpstreamPolicy = params.get("UpstreamPolicy")
        if params.get("UpstreamRules") is not None:
            self._UpstreamRules = []
            for item in params.get("UpstreamRules"):
                obj = UpstreamRule()
                obj._deserialize(item)
                self._UpstreamRules.append(obj)
        self._UseCase = params.get("UseCase")
        self._Gzip = params.get("Gzip")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddSpartaProtectionResponse(AbstractModel):
    r"""AddSpartaProtection返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AnonymousInfo(AbstractModel):
    r"""免鉴权信息

    """

    def __init__(self):
        r"""
        :param _Operations: 操作列表，支持trackLog(JS/HTTP上传日志  )和realtimeProducer(kafka协议上传日志)
        :type Operations: list of str
        :param _Conditions: 条件列表
        :type Conditions: list of ConditionInfo
        """
        self._Operations = None
        self._Conditions = None

    @property
    def Operations(self):
        r"""操作列表，支持trackLog(JS/HTTP上传日志  )和realtimeProducer(kafka协议上传日志)
        :rtype: list of str
        """
        return self._Operations

    @Operations.setter
    def Operations(self, Operations):
        self._Operations = Operations

    @property
    def Conditions(self):
        r"""条件列表
        :rtype: list of ConditionInfo
        """
        return self._Conditions

    @Conditions.setter
    def Conditions(self, Conditions):
        self._Conditions = Conditions


    def _deserialize(self, params):
        self._Operations = params.get("Operations")
        if params.get("Conditions") is not None:
            self._Conditions = []
            for item in params.get("Conditions"):
                obj = ConditionInfo()
                obj._deserialize(item)
                self._Conditions.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApiAsset(AbstractModel):
    r"""api列表

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _Method: 请求方法
        :type Method: str
        :param _ApiName: api名称
        :type ApiName: str
        :param _Scene: 场景
        :type Scene: str
        :param _Label: 数据标签
        :type Label: list of str
        :param _Active: 过去7天是否活跃
        :type Active: bool
        :param _Timestamp: 最近更新时间
        :type Timestamp: int
        :param _InsertTime: api发现时间
        :type InsertTime: int
        :param _Mode: 资产状态，1:新发现，2，确认中，3，已确认，4，已下线，5，已忽略
        :type Mode: str
        :param _Level: 风险等级，100,200,300对应低中高
        :type Level: str
        :param _Count: 近30天调用量
        :type Count: int
        :param _Remark: 备注
        :type Remark: str
        :param _IsAuth: 是否鉴权，1标识是，0表示否
        :type IsAuth: int
        :param _ApiRequestRuleId: 如果添加了api入参检测规则，则此id返回值不为0
        :type ApiRequestRuleId: int
        :param _ApiLimitRuleId: 如果添加了api限流规则，则此id返回值不为0
        :type ApiLimitRuleId: int
        :param _HostList: 对象接入和泛域名接入时，展示host列表
        :type HostList: list of str
        """
        self._Domain = None
        self._Method = None
        self._ApiName = None
        self._Scene = None
        self._Label = None
        self._Active = None
        self._Timestamp = None
        self._InsertTime = None
        self._Mode = None
        self._Level = None
        self._Count = None
        self._Remark = None
        self._IsAuth = None
        self._ApiRequestRuleId = None
        self._ApiLimitRuleId = None
        self._HostList = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Method(self):
        r"""请求方法
        :rtype: str
        """
        return self._Method

    @Method.setter
    def Method(self, Method):
        self._Method = Method

    @property
    def ApiName(self):
        r"""api名称
        :rtype: str
        """
        return self._ApiName

    @ApiName.setter
    def ApiName(self, ApiName):
        self._ApiName = ApiName

    @property
    def Scene(self):
        r"""场景
        :rtype: str
        """
        return self._Scene

    @Scene.setter
    def Scene(self, Scene):
        self._Scene = Scene

    @property
    def Label(self):
        r"""数据标签
        :rtype: list of str
        """
        return self._Label

    @Label.setter
    def Label(self, Label):
        self._Label = Label

    @property
    def Active(self):
        r"""过去7天是否活跃
        :rtype: bool
        """
        return self._Active

    @Active.setter
    def Active(self, Active):
        self._Active = Active

    @property
    def Timestamp(self):
        r"""最近更新时间
        :rtype: int
        """
        return self._Timestamp

    @Timestamp.setter
    def Timestamp(self, Timestamp):
        self._Timestamp = Timestamp

    @property
    def InsertTime(self):
        r"""api发现时间
        :rtype: int
        """
        return self._InsertTime

    @InsertTime.setter
    def InsertTime(self, InsertTime):
        self._InsertTime = InsertTime

    @property
    def Mode(self):
        r"""资产状态，1:新发现，2，确认中，3，已确认，4，已下线，5，已忽略
        :rtype: str
        """
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode

    @property
    def Level(self):
        r"""风险等级，100,200,300对应低中高
        :rtype: str
        """
        return self._Level

    @Level.setter
    def Level(self, Level):
        self._Level = Level

    @property
    def Count(self):
        r"""近30天调用量
        :rtype: int
        """
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def Remark(self):
        r"""备注
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def IsAuth(self):
        r"""是否鉴权，1标识是，0表示否
        :rtype: int
        """
        return self._IsAuth

    @IsAuth.setter
    def IsAuth(self, IsAuth):
        self._IsAuth = IsAuth

    @property
    def ApiRequestRuleId(self):
        r"""如果添加了api入参检测规则，则此id返回值不为0
        :rtype: int
        """
        return self._ApiRequestRuleId

    @ApiRequestRuleId.setter
    def ApiRequestRuleId(self, ApiRequestRuleId):
        self._ApiRequestRuleId = ApiRequestRuleId

    @property
    def ApiLimitRuleId(self):
        r"""如果添加了api限流规则，则此id返回值不为0
        :rtype: int
        """
        return self._ApiLimitRuleId

    @ApiLimitRuleId.setter
    def ApiLimitRuleId(self, ApiLimitRuleId):
        self._ApiLimitRuleId = ApiLimitRuleId

    @property
    def HostList(self):
        r"""对象接入和泛域名接入时，展示host列表
        :rtype: list of str
        """
        return self._HostList

    @HostList.setter
    def HostList(self, HostList):
        self._HostList = HostList


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Method = params.get("Method")
        self._ApiName = params.get("ApiName")
        self._Scene = params.get("Scene")
        self._Label = params.get("Label")
        self._Active = params.get("Active")
        self._Timestamp = params.get("Timestamp")
        self._InsertTime = params.get("InsertTime")
        self._Mode = params.get("Mode")
        self._Level = params.get("Level")
        self._Count = params.get("Count")
        self._Remark = params.get("Remark")
        self._IsAuth = params.get("IsAuth")
        self._ApiRequestRuleId = params.get("ApiRequestRuleId")
        self._ApiLimitRuleId = params.get("ApiLimitRuleId")
        self._HostList = params.get("HostList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApiDataFilter(AbstractModel):
    r"""api资产列表过滤器

    """

    def __init__(self):
        r"""
        :param _Entity: 数据标签，是否活跃，功能场景
        :type Entity: str
        :param _Operator: 等于
        :type Operator: str
        :param _Value: 日期，手机号，邮箱等
        :type Value: str
        :param _ValueList: 风险等级
        :type ValueList: list of str
        """
        self._Entity = None
        self._Operator = None
        self._Value = None
        self._ValueList = None

    @property
    def Entity(self):
        r"""数据标签，是否活跃，功能场景
        :rtype: str
        """
        return self._Entity

    @Entity.setter
    def Entity(self, Entity):
        self._Entity = Entity

    @property
    def Operator(self):
        r"""等于
        :rtype: str
        """
        return self._Operator

    @Operator.setter
    def Operator(self, Operator):
        self._Operator = Operator

    @property
    def Value(self):
        r"""日期，手机号，邮箱等
        :rtype: str
        """
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value

    @property
    def ValueList(self):
        r"""风险等级
        :rtype: list of str
        """
        return self._ValueList

    @ValueList.setter
    def ValueList(self, ValueList):
        self._ValueList = ValueList


    def _deserialize(self, params):
        self._Entity = params.get("Entity")
        self._Operator = params.get("Operator")
        self._Value = params.get("Value")
        self._ValueList = params.get("ValueList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApiDetailSampleHistory(AbstractModel):
    r"""api历史样例返回结构体

    """

    def __init__(self):
        r"""
        :param _SampleNme: 样例名称
        :type SampleNme: str
        :param _RepLog: 请求样例
        :type RepLog: str
        :param _RspLog: 响应样例
        :type RspLog: str
        """
        self._SampleNme = None
        self._RepLog = None
        self._RspLog = None

    @property
    def SampleNme(self):
        r"""样例名称
        :rtype: str
        """
        return self._SampleNme

    @SampleNme.setter
    def SampleNme(self, SampleNme):
        self._SampleNme = SampleNme

    @property
    def RepLog(self):
        r"""请求样例
        :rtype: str
        """
        return self._RepLog

    @RepLog.setter
    def RepLog(self, RepLog):
        self._RepLog = RepLog

    @property
    def RspLog(self):
        r"""响应样例
        :rtype: str
        """
        return self._RspLog

    @RspLog.setter
    def RspLog(self, RspLog):
        self._RspLog = RspLog


    def _deserialize(self, params):
        self._SampleNme = params.get("SampleNme")
        self._RepLog = params.get("RepLog")
        self._RspLog = params.get("RspLog")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApiParameterType(AbstractModel):
    r"""api请求参数类型

    """

    def __init__(self):
        r"""
        :param _ParameterName: 参数名称
        :type ParameterName: str
        :param _Type: 参数类型
        :type Type: str
        :param _Location: 参数位置
        :type Location: str
        :param _Label: 数据标签(敏感字段)
        :type Label: list of str
        :param _Timestamp: 时间戳
        :type Timestamp: int
        :param _Remark: 备注信息
        :type Remark: str
        :param _Source: 来源是请求或者响应
        :type Source: str
        :param _IsPan: 是否需要泛化 ，0表示不需要，1表示需要
        :type IsPan: int
        :param _IsAuth: 是否鉴权，1表示是，0表示否
        :type IsAuth: int
        """
        self._ParameterName = None
        self._Type = None
        self._Location = None
        self._Label = None
        self._Timestamp = None
        self._Remark = None
        self._Source = None
        self._IsPan = None
        self._IsAuth = None

    @property
    def ParameterName(self):
        r"""参数名称
        :rtype: str
        """
        return self._ParameterName

    @ParameterName.setter
    def ParameterName(self, ParameterName):
        self._ParameterName = ParameterName

    @property
    def Type(self):
        r"""参数类型
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Location(self):
        r"""参数位置
        :rtype: str
        """
        return self._Location

    @Location.setter
    def Location(self, Location):
        self._Location = Location

    @property
    def Label(self):
        r"""数据标签(敏感字段)
        :rtype: list of str
        """
        return self._Label

    @Label.setter
    def Label(self, Label):
        self._Label = Label

    @property
    def Timestamp(self):
        r"""时间戳
        :rtype: int
        """
        return self._Timestamp

    @Timestamp.setter
    def Timestamp(self, Timestamp):
        self._Timestamp = Timestamp

    @property
    def Remark(self):
        r"""备注信息
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def Source(self):
        r"""来源是请求或者响应
        :rtype: str
        """
        return self._Source

    @Source.setter
    def Source(self, Source):
        self._Source = Source

    @property
    def IsPan(self):
        r"""是否需要泛化 ，0表示不需要，1表示需要
        :rtype: int
        """
        return self._IsPan

    @IsPan.setter
    def IsPan(self, IsPan):
        self._IsPan = IsPan

    @property
    def IsAuth(self):
        r"""是否鉴权，1表示是，0表示否
        :rtype: int
        """
        return self._IsAuth

    @IsAuth.setter
    def IsAuth(self, IsAuth):
        self._IsAuth = IsAuth


    def _deserialize(self, params):
        self._ParameterName = params.get("ParameterName")
        self._Type = params.get("Type")
        self._Location = params.get("Location")
        self._Label = params.get("Label")
        self._Timestamp = params.get("Timestamp")
        self._Remark = params.get("Remark")
        self._Source = params.get("Source")
        self._IsPan = params.get("IsPan")
        self._IsAuth = params.get("IsAuth")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApiPkg(AbstractModel):
    r"""API安全资源信息

    """

    def __init__(self):
        r"""
        :param _ResourceIds: 资源id
        :type ResourceIds: str
        :param _Status: 状态
        :type Status: int
        :param _Region: 地域
        :type Region: int
        :param _BeginTime: 开始时间
        :type BeginTime: str
        :param _EndTime: 结束时间
        :type EndTime: str
        :param _InquireNum: 申请数量
        :type InquireNum: int
        :param _UsedNum: 使用数量
        :type UsedNum: int
        :param _RenewFlag: 续费标志
        :type RenewFlag: int
        :param _BillingItem: 计费项
        :type BillingItem: str
        :param _IsAPISecurityTrial: api安全7天试用标识。1试用。0没试用
        :type IsAPISecurityTrial: int
        """
        self._ResourceIds = None
        self._Status = None
        self._Region = None
        self._BeginTime = None
        self._EndTime = None
        self._InquireNum = None
        self._UsedNum = None
        self._RenewFlag = None
        self._BillingItem = None
        self._IsAPISecurityTrial = None

    @property
    def ResourceIds(self):
        r"""资源id
        :rtype: str
        """
        return self._ResourceIds

    @ResourceIds.setter
    def ResourceIds(self, ResourceIds):
        self._ResourceIds = ResourceIds

    @property
    def Status(self):
        r"""状态
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Region(self):
        r"""地域
        :rtype: int
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def BeginTime(self):
        r"""开始时间
        :rtype: str
        """
        return self._BeginTime

    @BeginTime.setter
    def BeginTime(self, BeginTime):
        self._BeginTime = BeginTime

    @property
    def EndTime(self):
        r"""结束时间
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def InquireNum(self):
        r"""申请数量
        :rtype: int
        """
        return self._InquireNum

    @InquireNum.setter
    def InquireNum(self, InquireNum):
        self._InquireNum = InquireNum

    @property
    def UsedNum(self):
        r"""使用数量
        :rtype: int
        """
        return self._UsedNum

    @UsedNum.setter
    def UsedNum(self, UsedNum):
        self._UsedNum = UsedNum

    @property
    def RenewFlag(self):
        r"""续费标志
        :rtype: int
        """
        return self._RenewFlag

    @RenewFlag.setter
    def RenewFlag(self, RenewFlag):
        self._RenewFlag = RenewFlag

    @property
    def BillingItem(self):
        r"""计费项
        :rtype: str
        """
        return self._BillingItem

    @BillingItem.setter
    def BillingItem(self, BillingItem):
        self._BillingItem = BillingItem

    @property
    def IsAPISecurityTrial(self):
        r"""api安全7天试用标识。1试用。0没试用
        :rtype: int
        """
        return self._IsAPISecurityTrial

    @IsAPISecurityTrial.setter
    def IsAPISecurityTrial(self, IsAPISecurityTrial):
        self._IsAPISecurityTrial = IsAPISecurityTrial


    def _deserialize(self, params):
        self._ResourceIds = params.get("ResourceIds")
        self._Status = params.get("Status")
        self._Region = params.get("Region")
        self._BeginTime = params.get("BeginTime")
        self._EndTime = params.get("EndTime")
        self._InquireNum = params.get("InquireNum")
        self._UsedNum = params.get("UsedNum")
        self._RenewFlag = params.get("RenewFlag")
        self._BillingItem = params.get("BillingItem")
        self._IsAPISecurityTrial = params.get("IsAPISecurityTrial")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApiSecKey(AbstractModel):
    r"""api列表

    """

    def __init__(self):
        r"""
        :param _ApiName: api名称
        :type ApiName: str
        :param _Domain: 域名
        :type Domain: str
        :param _Method: 请求方法
        :type Method: str
        """
        self._ApiName = None
        self._Domain = None
        self._Method = None

    @property
    def ApiName(self):
        r"""api名称
        :rtype: str
        """
        return self._ApiName

    @ApiName.setter
    def ApiName(self, ApiName):
        self._ApiName = ApiName

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Method(self):
        r"""请求方法
        :rtype: str
        """
        return self._Method

    @Method.setter
    def Method(self, Method):
        self._Method = Method


    def _deserialize(self, params):
        self._ApiName = params.get("ApiName")
        self._Domain = params.get("Domain")
        self._Method = params.get("Method")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Area(AbstractModel):
    r"""地域信息

    """

    def __init__(self):
        r"""
        :param _Country: 国家，除了标准的国家外还支持国内、国外这两个特殊的标识
        :type Country: str
        :param _Region: 省份
        :type Region: str
        :param _City: 城市
        :type City: str
        """
        self._Country = None
        self._Region = None
        self._City = None

    @property
    def Country(self):
        r"""国家，除了标准的国家外还支持国内、国外这两个特殊的标识
        :rtype: str
        """
        return self._Country

    @Country.setter
    def Country(self, Country):
        self._Country = Country

    @property
    def Region(self):
        r"""省份
        :rtype: str
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def City(self):
        r"""城市
        :rtype: str
        """
        return self._City

    @City.setter
    def City(self, City):
        self._City = City


    def _deserialize(self, params):
        self._Country = params.get("Country")
        self._Region = params.get("Region")
        self._City = params.get("City")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AreaBanRule(AbstractModel):
    r"""地域封禁规则详情

    """

    def __init__(self):
        r"""
        :param _Status: 状态 0：未开启地域封禁、1：开启地域封禁
        :type Status: int
        :param _Source: 数据来源 custom：自定义(默认)、batch：批量防护
        :type Source: str
        :param _Areas: 配置的地域列表
        :type Areas: list of Area
        :param _JobType: 规则执行的方式，TimedJob为定时执行，CronJob为周期执行
        :type JobType: str
        :param _JobDateTime: 定时任务配置
        :type JobDateTime: :class:`tencentcloud.waf.v20180125.models.JobDateTime`
        :param _CronType: 如果是周期任务类型，那么表示周期的类型，支持 Week：按周、Month：按月
        :type CronType: str
        :param _Lang: 地域信息的语言，支持cn、en，默认为中文cn
        :type Lang: str
        """
        self._Status = None
        self._Source = None
        self._Areas = None
        self._JobType = None
        self._JobDateTime = None
        self._CronType = None
        self._Lang = None

    @property
    def Status(self):
        r"""状态 0：未开启地域封禁、1：开启地域封禁
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Source(self):
        r"""数据来源 custom：自定义(默认)、batch：批量防护
        :rtype: str
        """
        return self._Source

    @Source.setter
    def Source(self, Source):
        self._Source = Source

    @property
    def Areas(self):
        r"""配置的地域列表
        :rtype: list of Area
        """
        return self._Areas

    @Areas.setter
    def Areas(self, Areas):
        self._Areas = Areas

    @property
    def JobType(self):
        r"""规则执行的方式，TimedJob为定时执行，CronJob为周期执行
        :rtype: str
        """
        return self._JobType

    @JobType.setter
    def JobType(self, JobType):
        self._JobType = JobType

    @property
    def JobDateTime(self):
        r"""定时任务配置
        :rtype: :class:`tencentcloud.waf.v20180125.models.JobDateTime`
        """
        return self._JobDateTime

    @JobDateTime.setter
    def JobDateTime(self, JobDateTime):
        self._JobDateTime = JobDateTime

    @property
    def CronType(self):
        r"""如果是周期任务类型，那么表示周期的类型，支持 Week：按周、Month：按月
        :rtype: str
        """
        return self._CronType

    @CronType.setter
    def CronType(self, CronType):
        self._CronType = CronType

    @property
    def Lang(self):
        r"""地域信息的语言，支持cn、en，默认为中文cn
        :rtype: str
        """
        return self._Lang

    @Lang.setter
    def Lang(self, Lang):
        self._Lang = Lang


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._Source = params.get("Source")
        if params.get("Areas") is not None:
            self._Areas = []
            for item in params.get("Areas"):
                obj = Area()
                obj._deserialize(item)
                self._Areas.append(obj)
        self._JobType = params.get("JobType")
        if params.get("JobDateTime") is not None:
            self._JobDateTime = JobDateTime()
            self._JobDateTime._deserialize(params.get("JobDateTime"))
        self._CronType = params.get("CronType")
        self._Lang = params.get("Lang")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AttackLogInfo(AbstractModel):
    r"""攻击日志详情

    """

    def __init__(self):
        r"""
        :param _Content: 攻击日志的详情内容
        :type Content: str
        :param _FileName: CLS返回内容
        :type FileName: str
        :param _Source: CLS返回内容
        :type Source: str
        :param _TimeStamp: CLS返回内容
        :type TimeStamp: str
        """
        self._Content = None
        self._FileName = None
        self._Source = None
        self._TimeStamp = None

    @property
    def Content(self):
        r"""攻击日志的详情内容
        :rtype: str
        """
        return self._Content

    @Content.setter
    def Content(self, Content):
        self._Content = Content

    @property
    def FileName(self):
        r"""CLS返回内容
        :rtype: str
        """
        return self._FileName

    @FileName.setter
    def FileName(self, FileName):
        self._FileName = FileName

    @property
    def Source(self):
        r"""CLS返回内容
        :rtype: str
        """
        return self._Source

    @Source.setter
    def Source(self, Source):
        self._Source = Source

    @property
    def TimeStamp(self):
        r"""CLS返回内容
        :rtype: str
        """
        return self._TimeStamp

    @TimeStamp.setter
    def TimeStamp(self, TimeStamp):
        self._TimeStamp = TimeStamp


    def _deserialize(self, params):
        self._Content = params.get("Content")
        self._FileName = params.get("FileName")
        self._Source = params.get("Source")
        self._TimeStamp = params.get("TimeStamp")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AutoDenyDetail(AbstractModel):
    r"""Waf 攻击自动封禁详情

    """

    def __init__(self):
        r"""
        :param _AttackTags: 攻击封禁类型标签
        :type AttackTags: list of str
        :param _AttackThreshold: 攻击次数阈值
        :type AttackThreshold: int
        :param _DefenseStatus: 自动封禁状态
        :type DefenseStatus: int
        :param _TimeThreshold: 攻击时间阈值
        :type TimeThreshold: int
        :param _DenyTimeThreshold: 自动封禁时间
        :type DenyTimeThreshold: int
        :param _LastUpdateTime: 最后更新时间
        :type LastUpdateTime: str
        """
        self._AttackTags = None
        self._AttackThreshold = None
        self._DefenseStatus = None
        self._TimeThreshold = None
        self._DenyTimeThreshold = None
        self._LastUpdateTime = None

    @property
    def AttackTags(self):
        r"""攻击封禁类型标签
        :rtype: list of str
        """
        return self._AttackTags

    @AttackTags.setter
    def AttackTags(self, AttackTags):
        self._AttackTags = AttackTags

    @property
    def AttackThreshold(self):
        r"""攻击次数阈值
        :rtype: int
        """
        return self._AttackThreshold

    @AttackThreshold.setter
    def AttackThreshold(self, AttackThreshold):
        self._AttackThreshold = AttackThreshold

    @property
    def DefenseStatus(self):
        r"""自动封禁状态
        :rtype: int
        """
        return self._DefenseStatus

    @DefenseStatus.setter
    def DefenseStatus(self, DefenseStatus):
        self._DefenseStatus = DefenseStatus

    @property
    def TimeThreshold(self):
        r"""攻击时间阈值
        :rtype: int
        """
        return self._TimeThreshold

    @TimeThreshold.setter
    def TimeThreshold(self, TimeThreshold):
        self._TimeThreshold = TimeThreshold

    @property
    def DenyTimeThreshold(self):
        r"""自动封禁时间
        :rtype: int
        """
        return self._DenyTimeThreshold

    @DenyTimeThreshold.setter
    def DenyTimeThreshold(self, DenyTimeThreshold):
        self._DenyTimeThreshold = DenyTimeThreshold

    @property
    def LastUpdateTime(self):
        r"""最后更新时间
        :rtype: str
        """
        return self._LastUpdateTime

    @LastUpdateTime.setter
    def LastUpdateTime(self, LastUpdateTime):
        self._LastUpdateTime = LastUpdateTime


    def _deserialize(self, params):
        self._AttackTags = params.get("AttackTags")
        self._AttackThreshold = params.get("AttackThreshold")
        self._DefenseStatus = params.get("DefenseStatus")
        self._TimeThreshold = params.get("TimeThreshold")
        self._DenyTimeThreshold = params.get("DenyTimeThreshold")
        self._LastUpdateTime = params.get("LastUpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchDomainResult(AbstractModel):
    r"""批量防护失败的域名以及对应的原因。

    """

    def __init__(self):
        r"""
        :param _Domain: 批量操作中失败的域名
        :type Domain: str
        :param _Message: 操作失败的原因
        :type Message: str
        """
        self._Domain = None
        self._Message = None

    @property
    def Domain(self):
        r"""批量操作中失败的域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Message(self):
        r"""操作失败的原因
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Message = params.get("Message")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchIpAccessControlData(AbstractModel):
    r"""多域名黑白名单describe返回

    """

    def __init__(self):
        r"""
        :param _TotalCount: 总数
        :type TotalCount: int
        :param _Res: 黑白名单条目
        :type Res: list of BatchIpAccessControlItem
        """
        self._TotalCount = None
        self._Res = None

    @property
    def TotalCount(self):
        r"""总数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Res(self):
        r"""黑白名单条目
        :rtype: list of BatchIpAccessControlItem
        """
        return self._Res

    @Res.setter
    def Res(self, Res):
        self._Res = Res


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Res") is not None:
            self._Res = []
            for item in params.get("Res"):
                obj = BatchIpAccessControlItem()
                obj._deserialize(item)
                self._Res.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchIpAccessControlItem(AbstractModel):
    r"""批量多域名黑白名单列表Ip

    """

    def __init__(self):
        r"""
        :param _Id: mongo表自增Id
        :type Id: str
        :param _ActionType: 黑名单42或白名单40
        :type ActionType: int
        :param _Ip: 黑白名单的IP
        :type Ip: str
        :param _Note: 备注
        :type Note: str
        :param _Source: batch为批量域名，batch-group为防护对象组
        :type Source: str
        :param _TsVersion: 修改时间
        :type TsVersion: int
        :param _ValidTs: 超时时间
        :type ValidTs: int
        :param _Hosts: 域名列表
        :type Hosts: list of str
        :param _RuleId: 55101145
        :type RuleId: int
        :param _IpList: IP列表
        :type IpList: list of str
        :param _CreateTime: 创建时间
        :type CreateTime: int
        :param _JobType: 定时任务类型
        :type JobType: str
        :param _CronType: 周期任务类型
        :type CronType: str
        :param _JobDateTime: 定时任务配置详情
        :type JobDateTime: :class:`tencentcloud.waf.v20180125.models.JobDateTime`
        :param _ValidStatus: 生效状态
        :type ValidStatus: int
        :param _GroupIds: 防护对象组ID列表，如果绑定的是防护对象组
        :type GroupIds: list of int non-negative
        """
        self._Id = None
        self._ActionType = None
        self._Ip = None
        self._Note = None
        self._Source = None
        self._TsVersion = None
        self._ValidTs = None
        self._Hosts = None
        self._RuleId = None
        self._IpList = None
        self._CreateTime = None
        self._JobType = None
        self._CronType = None
        self._JobDateTime = None
        self._ValidStatus = None
        self._GroupIds = None

    @property
    def Id(self):
        warnings.warn("parameter `Id` is deprecated", DeprecationWarning) 

        r"""mongo表自增Id
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        warnings.warn("parameter `Id` is deprecated", DeprecationWarning) 

        self._Id = Id

    @property
    def ActionType(self):
        r"""黑名单42或白名单40
        :rtype: int
        """
        return self._ActionType

    @ActionType.setter
    def ActionType(self, ActionType):
        self._ActionType = ActionType

    @property
    def Ip(self):
        warnings.warn("parameter `Ip` is deprecated", DeprecationWarning) 

        r"""黑白名单的IP
        :rtype: str
        """
        return self._Ip

    @Ip.setter
    def Ip(self, Ip):
        warnings.warn("parameter `Ip` is deprecated", DeprecationWarning) 

        self._Ip = Ip

    @property
    def Note(self):
        r"""备注
        :rtype: str
        """
        return self._Note

    @Note.setter
    def Note(self, Note):
        self._Note = Note

    @property
    def Source(self):
        r"""batch为批量域名，batch-group为防护对象组
        :rtype: str
        """
        return self._Source

    @Source.setter
    def Source(self, Source):
        self._Source = Source

    @property
    def TsVersion(self):
        r"""修改时间
        :rtype: int
        """
        return self._TsVersion

    @TsVersion.setter
    def TsVersion(self, TsVersion):
        self._TsVersion = TsVersion

    @property
    def ValidTs(self):
        r"""超时时间
        :rtype: int
        """
        return self._ValidTs

    @ValidTs.setter
    def ValidTs(self, ValidTs):
        self._ValidTs = ValidTs

    @property
    def Hosts(self):
        r"""域名列表
        :rtype: list of str
        """
        return self._Hosts

    @Hosts.setter
    def Hosts(self, Hosts):
        self._Hosts = Hosts

    @property
    def RuleId(self):
        r"""55101145
        :rtype: int
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def IpList(self):
        r"""IP列表
        :rtype: list of str
        """
        return self._IpList

    @IpList.setter
    def IpList(self, IpList):
        self._IpList = IpList

    @property
    def CreateTime(self):
        r"""创建时间
        :rtype: int
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def JobType(self):
        r"""定时任务类型
        :rtype: str
        """
        return self._JobType

    @JobType.setter
    def JobType(self, JobType):
        self._JobType = JobType

    @property
    def CronType(self):
        r"""周期任务类型
        :rtype: str
        """
        return self._CronType

    @CronType.setter
    def CronType(self, CronType):
        self._CronType = CronType

    @property
    def JobDateTime(self):
        r"""定时任务配置详情
        :rtype: :class:`tencentcloud.waf.v20180125.models.JobDateTime`
        """
        return self._JobDateTime

    @JobDateTime.setter
    def JobDateTime(self, JobDateTime):
        self._JobDateTime = JobDateTime

    @property
    def ValidStatus(self):
        r"""生效状态
        :rtype: int
        """
        return self._ValidStatus

    @ValidStatus.setter
    def ValidStatus(self, ValidStatus):
        self._ValidStatus = ValidStatus

    @property
    def GroupIds(self):
        r"""防护对象组ID列表，如果绑定的是防护对象组
        :rtype: list of int non-negative
        """
        return self._GroupIds

    @GroupIds.setter
    def GroupIds(self, GroupIds):
        self._GroupIds = GroupIds


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._ActionType = params.get("ActionType")
        self._Ip = params.get("Ip")
        self._Note = params.get("Note")
        self._Source = params.get("Source")
        self._TsVersion = params.get("TsVersion")
        self._ValidTs = params.get("ValidTs")
        self._Hosts = params.get("Hosts")
        self._RuleId = params.get("RuleId")
        self._IpList = params.get("IpList")
        self._CreateTime = params.get("CreateTime")
        self._JobType = params.get("JobType")
        self._CronType = params.get("CronType")
        if params.get("JobDateTime") is not None:
            self._JobDateTime = JobDateTime()
            self._JobDateTime._deserialize(params.get("JobDateTime"))
        self._ValidStatus = params.get("ValidStatus")
        self._GroupIds = params.get("GroupIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchOperateUserSignatureRulesRequest(AbstractModel):
    r"""BatchOperateUserSignatureRules请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _Status: 0:关闭，1:开启，2:仅观察
        :type Status: str
        :param _RuleIds: 如果SelectedAll为true，则表示反选的规则，否则表示手动选择的规则ID
        :type RuleIds: list of str
        :param _Reason: 仅观察原因
        :type Reason: int
        :param _SelectedAll: 是否全选
        :type SelectedAll: bool
        :param _Filters: 过滤
        :type Filters: list of FiltersItemNew
        """
        self._Domain = None
        self._Status = None
        self._RuleIds = None
        self._Reason = None
        self._SelectedAll = None
        self._Filters = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Status(self):
        r"""0:关闭，1:开启，2:仅观察
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def RuleIds(self):
        r"""如果SelectedAll为true，则表示反选的规则，否则表示手动选择的规则ID
        :rtype: list of str
        """
        return self._RuleIds

    @RuleIds.setter
    def RuleIds(self, RuleIds):
        self._RuleIds = RuleIds

    @property
    def Reason(self):
        r"""仅观察原因
        :rtype: int
        """
        return self._Reason

    @Reason.setter
    def Reason(self, Reason):
        self._Reason = Reason

    @property
    def SelectedAll(self):
        r"""是否全选
        :rtype: bool
        """
        return self._SelectedAll

    @SelectedAll.setter
    def SelectedAll(self, SelectedAll):
        self._SelectedAll = SelectedAll

    @property
    def Filters(self):
        r"""过滤
        :rtype: list of FiltersItemNew
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Status = params.get("Status")
        self._RuleIds = params.get("RuleIds")
        self._Reason = params.get("Reason")
        self._SelectedAll = params.get("SelectedAll")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = FiltersItemNew()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchOperateUserSignatureRulesResponse(AbstractModel):
    r"""BatchOperateUserSignatureRules返回参数结构体

    """

    def __init__(self):
        r"""
        :param _CommonRsp: 操作结果
        :type CommonRsp: :class:`tencentcloud.waf.v20180125.models.CommonRspData`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._CommonRsp = None
        self._RequestId = None

    @property
    def CommonRsp(self):
        r"""操作结果
        :rtype: :class:`tencentcloud.waf.v20180125.models.CommonRspData`
        """
        return self._CommonRsp

    @CommonRsp.setter
    def CommonRsp(self, CommonRsp):
        self._CommonRsp = CommonRsp

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("CommonRsp") is not None:
            self._CommonRsp = CommonRspData()
            self._CommonRsp._deserialize(params.get("CommonRsp"))
        self._RequestId = params.get("RequestId")


class BotActionScopeRuleEntry(AbstractModel):
    r"""动作策略的匹配规则实体

    """

    def __init__(self):
        r"""
        :param _Key: 参数
        :type Key: str
        :param _Op: 匹配符
        :type Op: str
        :param _Value: 参数值
        :type Value: str
        :param _Name: 对于头部字段匹配value的时候指定的头部名
        :type Name: str
        :param _ValueArray: 470后使用此字段存储多值
        :type ValueArray: list of str
        """
        self._Key = None
        self._Op = None
        self._Value = None
        self._Name = None
        self._ValueArray = None

    @property
    def Key(self):
        r"""参数
        :rtype: str
        """
        return self._Key

    @Key.setter
    def Key(self, Key):
        self._Key = Key

    @property
    def Op(self):
        r"""匹配符
        :rtype: str
        """
        return self._Op

    @Op.setter
    def Op(self, Op):
        self._Op = Op

    @property
    def Value(self):
        r"""参数值
        :rtype: str
        """
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value

    @property
    def Name(self):
        r"""对于头部字段匹配value的时候指定的头部名
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def ValueArray(self):
        r"""470后使用此字段存储多值
        :rtype: list of str
        """
        return self._ValueArray

    @ValueArray.setter
    def ValueArray(self, ValueArray):
        self._ValueArray = ValueArray


    def _deserialize(self, params):
        self._Key = params.get("Key")
        self._Op = params.get("Op")
        self._Value = params.get("Value")
        self._Name = params.get("Name")
        self._ValueArray = params.get("ValueArray")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BotPkg(AbstractModel):
    r"""Bot资源信息

    """

    def __init__(self):
        r"""
        :param _ResourceIds: 资源id
        :type ResourceIds: str
        :param _Status: 状态
        :type Status: int
        :param _Region: 地域
        :type Region: int
        :param _BeginTime: 开始时间
        :type BeginTime: str
        :param _EndTime: 结束时间
        :type EndTime: str
        :param _InquireNum: 申请数量
        :type InquireNum: int
        :param _UsedNum: 使用数量
        :type UsedNum: int
        :param _Type: 子产品code
        :type Type: str
        :param _RenewFlag: 续费标志	
        :type RenewFlag: int
        :param _BotCPWaf: 购买页bot6折
        :type BotCPWaf: int
        :param _BotNPWaf: 控制台买bot5折
        :type BotNPWaf: int
        :param _IsBotTrial: 7天bot试用标识 1 试用 0 没有试用
        :type IsBotTrial: int
        """
        self._ResourceIds = None
        self._Status = None
        self._Region = None
        self._BeginTime = None
        self._EndTime = None
        self._InquireNum = None
        self._UsedNum = None
        self._Type = None
        self._RenewFlag = None
        self._BotCPWaf = None
        self._BotNPWaf = None
        self._IsBotTrial = None

    @property
    def ResourceIds(self):
        r"""资源id
        :rtype: str
        """
        return self._ResourceIds

    @ResourceIds.setter
    def ResourceIds(self, ResourceIds):
        self._ResourceIds = ResourceIds

    @property
    def Status(self):
        r"""状态
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Region(self):
        r"""地域
        :rtype: int
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def BeginTime(self):
        r"""开始时间
        :rtype: str
        """
        return self._BeginTime

    @BeginTime.setter
    def BeginTime(self, BeginTime):
        self._BeginTime = BeginTime

    @property
    def EndTime(self):
        r"""结束时间
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def InquireNum(self):
        r"""申请数量
        :rtype: int
        """
        return self._InquireNum

    @InquireNum.setter
    def InquireNum(self, InquireNum):
        self._InquireNum = InquireNum

    @property
    def UsedNum(self):
        r"""使用数量
        :rtype: int
        """
        return self._UsedNum

    @UsedNum.setter
    def UsedNum(self, UsedNum):
        self._UsedNum = UsedNum

    @property
    def Type(self):
        r"""子产品code
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def RenewFlag(self):
        r"""续费标志	
        :rtype: int
        """
        return self._RenewFlag

    @RenewFlag.setter
    def RenewFlag(self, RenewFlag):
        self._RenewFlag = RenewFlag

    @property
    def BotCPWaf(self):
        r"""购买页bot6折
        :rtype: int
        """
        return self._BotCPWaf

    @BotCPWaf.setter
    def BotCPWaf(self, BotCPWaf):
        self._BotCPWaf = BotCPWaf

    @property
    def BotNPWaf(self):
        r"""控制台买bot5折
        :rtype: int
        """
        return self._BotNPWaf

    @BotNPWaf.setter
    def BotNPWaf(self, BotNPWaf):
        self._BotNPWaf = BotNPWaf

    @property
    def IsBotTrial(self):
        r"""7天bot试用标识 1 试用 0 没有试用
        :rtype: int
        """
        return self._IsBotTrial

    @IsBotTrial.setter
    def IsBotTrial(self, IsBotTrial):
        self._IsBotTrial = IsBotTrial


    def _deserialize(self, params):
        self._ResourceIds = params.get("ResourceIds")
        self._Status = params.get("Status")
        self._Region = params.get("Region")
        self._BeginTime = params.get("BeginTime")
        self._EndTime = params.get("EndTime")
        self._InquireNum = params.get("InquireNum")
        self._UsedNum = params.get("UsedNum")
        self._Type = params.get("Type")
        self._RenewFlag = params.get("RenewFlag")
        self._BotCPWaf = params.get("BotCPWaf")
        self._BotNPWaf = params.get("BotNPWaf")
        self._IsBotTrial = params.get("IsBotTrial")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BotQPS(AbstractModel):
    r"""bot的qps详情

    """

    def __init__(self):
        r"""
        :param _ResourceIds: 资源id
        :type ResourceIds: str
        :param _ValidTime: 有效时间
        :type ValidTime: str
        :param _Count: 资源数量
        :type Count: int
        :param _Region: 资源所在地区
        :type Region: str
        :param _MaxBotQPS: 使用qps的最大值
        :type MaxBotQPS: int
        :param _RenewFlag: 续费标志
        :type RenewFlag: int
        """
        self._ResourceIds = None
        self._ValidTime = None
        self._Count = None
        self._Region = None
        self._MaxBotQPS = None
        self._RenewFlag = None

    @property
    def ResourceIds(self):
        r"""资源id
        :rtype: str
        """
        return self._ResourceIds

    @ResourceIds.setter
    def ResourceIds(self, ResourceIds):
        self._ResourceIds = ResourceIds

    @property
    def ValidTime(self):
        r"""有效时间
        :rtype: str
        """
        return self._ValidTime

    @ValidTime.setter
    def ValidTime(self, ValidTime):
        self._ValidTime = ValidTime

    @property
    def Count(self):
        r"""资源数量
        :rtype: int
        """
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def Region(self):
        r"""资源所在地区
        :rtype: str
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def MaxBotQPS(self):
        r"""使用qps的最大值
        :rtype: int
        """
        return self._MaxBotQPS

    @MaxBotQPS.setter
    def MaxBotQPS(self, MaxBotQPS):
        self._MaxBotQPS = MaxBotQPS

    @property
    def RenewFlag(self):
        r"""续费标志
        :rtype: int
        """
        return self._RenewFlag

    @RenewFlag.setter
    def RenewFlag(self, RenewFlag):
        self._RenewFlag = RenewFlag


    def _deserialize(self, params):
        self._ResourceIds = params.get("ResourceIds")
        self._ValidTime = params.get("ValidTime")
        self._Count = params.get("Count")
        self._Region = params.get("Region")
        self._MaxBotQPS = params.get("MaxBotQPS")
        self._RenewFlag = params.get("RenewFlag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BotSceneActionRule(AbstractModel):
    r"""获取场景动作策略列表时的动作策略实体

    """

    def __init__(self):
        r"""
        :param _RuleId: 动作策略ID
        :type RuleId: str
        :param _RuleName: 动作策略名称
        :type RuleName: str
        :param _Priority: 策略优先级
        :type Priority: int
        :param _Status: 策略生效状态
        :type Status: bool
        :param _Score: 分数范围
        :type Score: list of BotScoreRuleEntry
        :param _Level: 100-宽松、200-中等、300-严格、0-自定义
        :type Level: str
        :param _Scope: 生效范围，为空表示全部范围
        :type Scope: list of BotActionScopeRuleEntry
        :param _Type: default：默认创建 custom：自定义创建
        :type Type: str
        :param _ScopeType: 匹配范围类型：全局匹配 or 自定义匹配范围
        :type ScopeType: str
        :param _ActionMatchType: 匹配条件间的与或关系
        :type ActionMatchType: str
        """
        self._RuleId = None
        self._RuleName = None
        self._Priority = None
        self._Status = None
        self._Score = None
        self._Level = None
        self._Scope = None
        self._Type = None
        self._ScopeType = None
        self._ActionMatchType = None

    @property
    def RuleId(self):
        r"""动作策略ID
        :rtype: str
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def RuleName(self):
        r"""动作策略名称
        :rtype: str
        """
        return self._RuleName

    @RuleName.setter
    def RuleName(self, RuleName):
        self._RuleName = RuleName

    @property
    def Priority(self):
        r"""策略优先级
        :rtype: int
        """
        return self._Priority

    @Priority.setter
    def Priority(self, Priority):
        self._Priority = Priority

    @property
    def Status(self):
        r"""策略生效状态
        :rtype: bool
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Score(self):
        r"""分数范围
        :rtype: list of BotScoreRuleEntry
        """
        return self._Score

    @Score.setter
    def Score(self, Score):
        self._Score = Score

    @property
    def Level(self):
        r"""100-宽松、200-中等、300-严格、0-自定义
        :rtype: str
        """
        return self._Level

    @Level.setter
    def Level(self, Level):
        self._Level = Level

    @property
    def Scope(self):
        r"""生效范围，为空表示全部范围
        :rtype: list of BotActionScopeRuleEntry
        """
        return self._Scope

    @Scope.setter
    def Scope(self, Scope):
        self._Scope = Scope

    @property
    def Type(self):
        r"""default：默认创建 custom：自定义创建
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def ScopeType(self):
        r"""匹配范围类型：全局匹配 or 自定义匹配范围
        :rtype: str
        """
        return self._ScopeType

    @ScopeType.setter
    def ScopeType(self, ScopeType):
        self._ScopeType = ScopeType

    @property
    def ActionMatchType(self):
        r"""匹配条件间的与或关系
        :rtype: str
        """
        return self._ActionMatchType

    @ActionMatchType.setter
    def ActionMatchType(self, ActionMatchType):
        self._ActionMatchType = ActionMatchType


    def _deserialize(self, params):
        self._RuleId = params.get("RuleId")
        self._RuleName = params.get("RuleName")
        self._Priority = params.get("Priority")
        self._Status = params.get("Status")
        if params.get("Score") is not None:
            self._Score = []
            for item in params.get("Score"):
                obj = BotScoreRuleEntry()
                obj._deserialize(item)
                self._Score.append(obj)
        self._Level = params.get("Level")
        if params.get("Scope") is not None:
            self._Scope = []
            for item in params.get("Scope"):
                obj = BotActionScopeRuleEntry()
                obj._deserialize(item)
                self._Scope.append(obj)
        self._Type = params.get("Type")
        self._ScopeType = params.get("ScopeType")
        self._ActionMatchType = params.get("ActionMatchType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BotSceneInfo(AbstractModel):
    r"""场景的详细配置信息

    """

    def __init__(self):
        r"""
        :param _SceneId: 场景ID
        :type SceneId: str
        :param _Type: 场景类型，default:默认场景,custom:非默认场景
        :type Type: str
        :param _SceneName: 场景名
        :type SceneName: str
        :param _UpdateTime: 更新时间
        :type UpdateTime: int
        :param _BusinessType: 场景模板类型，登录: login  秒杀:seckill  爬内容：crawl 自定义: custom
        :type BusinessType: list of str
        :param _ClientType: 客户端类型，浏览器/H5 : browser  小程序: miniApp  App:
        :type ClientType: list of str
        :param _Priority: 优先级
        :type Priority: int
        :param _MatchCondition: 匹配范围
        :type MatchCondition: list of BotSceneMatchCondition
        :param _SceneStatus: 场景开关
        :type SceneStatus: bool
        :param _JsInjectStatus: 前端对抗开关
        :type JsInjectStatus: bool
        :param _AIStatus: AI开关
        :type AIStatus: bool
        :param _TIStatus: TI开关
        :type TIStatus: bool
        :param _StatisticStatus: 智能统计开关
        :type StatisticStatus: bool
        :param _ActionRuleCount: 动作策略数量
        :type ActionRuleCount: int
        :param _UCBCount: 自定义规则数量
        :type UCBCount: int
        :param _MatchType: 场景的匹配范围，global-全部匹配 custom-自定义匹配范围
        :type MatchType: str
        :param _ActionMatchType: 匹配条件间的与或关系
        :type ActionMatchType: str
        :param _UAStatus: UA模块开关
        :type UAStatus: bool
        :param _JsInjectRuleId: 简易模式场景：前端对抗对应mysql的记录id
        :type JsInjectRuleId: int
        :param _JsInjectAction: 简易模式场景：前端对抗配置动作
        :type JsInjectAction: int
        :param _JsInjectRedirect: 简易模式场景：前端对抗重定向路径
        :type JsInjectRedirect: str
        :param _ActionRuleList: 简易模式场景：动作策略信息  PS:简易模式只有一个动作策略
        :type ActionRuleList: list of BotSceneActionRule
        :param _BotIdPattern: 简易模式场景：monitor-观察 intercept-拦截 custom-自定义
        :type BotIdPattern: str
        :param _BotIdCount: 简易模式场景：bot_id规则总数
        :type BotIdCount: int
        :param _BotIdMonitorCount: 简易模式场景：观察动作的规则总数
        :type BotIdMonitorCount: int
        :param _BotIdInterceptCount: 简易模式场景：拦截动作的规则总数
        :type BotIdInterceptCount: int
        :param _RuleSetSelection: 创建场景时选择的规则集
        :type RuleSetSelection: list of str
        :param _TokenList: 改场景的bot token列表
        :type TokenList: list of BotToken
        :param _BotIdRedirectCount: 简易模式场景：重定向动作的规则总数
        :type BotIdRedirectCount: int
        :param _BotIdCaptchaCount: 简易模式场景：人机识别动作的规则总数
        :type BotIdCaptchaCount: int
        :param _BotIdProtectLevel: 简易模式场景：防护等级
        :type BotIdProtectLevel: str
        :param _BotIdGlobalRedirect: 简易模式场景：全局重定向路径
        :type BotIdGlobalRedirect: str
        :param _BotIdJsChallengeCount: 简易模式场景：JS校验动作的规则总数
        :type BotIdJsChallengeCount: int
        """
        self._SceneId = None
        self._Type = None
        self._SceneName = None
        self._UpdateTime = None
        self._BusinessType = None
        self._ClientType = None
        self._Priority = None
        self._MatchCondition = None
        self._SceneStatus = None
        self._JsInjectStatus = None
        self._AIStatus = None
        self._TIStatus = None
        self._StatisticStatus = None
        self._ActionRuleCount = None
        self._UCBCount = None
        self._MatchType = None
        self._ActionMatchType = None
        self._UAStatus = None
        self._JsInjectRuleId = None
        self._JsInjectAction = None
        self._JsInjectRedirect = None
        self._ActionRuleList = None
        self._BotIdPattern = None
        self._BotIdCount = None
        self._BotIdMonitorCount = None
        self._BotIdInterceptCount = None
        self._RuleSetSelection = None
        self._TokenList = None
        self._BotIdRedirectCount = None
        self._BotIdCaptchaCount = None
        self._BotIdProtectLevel = None
        self._BotIdGlobalRedirect = None
        self._BotIdJsChallengeCount = None

    @property
    def SceneId(self):
        r"""场景ID
        :rtype: str
        """
        return self._SceneId

    @SceneId.setter
    def SceneId(self, SceneId):
        self._SceneId = SceneId

    @property
    def Type(self):
        r"""场景类型，default:默认场景,custom:非默认场景
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def SceneName(self):
        r"""场景名
        :rtype: str
        """
        return self._SceneName

    @SceneName.setter
    def SceneName(self, SceneName):
        self._SceneName = SceneName

    @property
    def UpdateTime(self):
        r"""更新时间
        :rtype: int
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def BusinessType(self):
        r"""场景模板类型，登录: login  秒杀:seckill  爬内容：crawl 自定义: custom
        :rtype: list of str
        """
        return self._BusinessType

    @BusinessType.setter
    def BusinessType(self, BusinessType):
        self._BusinessType = BusinessType

    @property
    def ClientType(self):
        r"""客户端类型，浏览器/H5 : browser  小程序: miniApp  App:
        :rtype: list of str
        """
        return self._ClientType

    @ClientType.setter
    def ClientType(self, ClientType):
        self._ClientType = ClientType

    @property
    def Priority(self):
        r"""优先级
        :rtype: int
        """
        return self._Priority

    @Priority.setter
    def Priority(self, Priority):
        self._Priority = Priority

    @property
    def MatchCondition(self):
        r"""匹配范围
        :rtype: list of BotSceneMatchCondition
        """
        return self._MatchCondition

    @MatchCondition.setter
    def MatchCondition(self, MatchCondition):
        self._MatchCondition = MatchCondition

    @property
    def SceneStatus(self):
        r"""场景开关
        :rtype: bool
        """
        return self._SceneStatus

    @SceneStatus.setter
    def SceneStatus(self, SceneStatus):
        self._SceneStatus = SceneStatus

    @property
    def JsInjectStatus(self):
        r"""前端对抗开关
        :rtype: bool
        """
        return self._JsInjectStatus

    @JsInjectStatus.setter
    def JsInjectStatus(self, JsInjectStatus):
        self._JsInjectStatus = JsInjectStatus

    @property
    def AIStatus(self):
        r"""AI开关
        :rtype: bool
        """
        return self._AIStatus

    @AIStatus.setter
    def AIStatus(self, AIStatus):
        self._AIStatus = AIStatus

    @property
    def TIStatus(self):
        r"""TI开关
        :rtype: bool
        """
        return self._TIStatus

    @TIStatus.setter
    def TIStatus(self, TIStatus):
        self._TIStatus = TIStatus

    @property
    def StatisticStatus(self):
        r"""智能统计开关
        :rtype: bool
        """
        return self._StatisticStatus

    @StatisticStatus.setter
    def StatisticStatus(self, StatisticStatus):
        self._StatisticStatus = StatisticStatus

    @property
    def ActionRuleCount(self):
        r"""动作策略数量
        :rtype: int
        """
        return self._ActionRuleCount

    @ActionRuleCount.setter
    def ActionRuleCount(self, ActionRuleCount):
        self._ActionRuleCount = ActionRuleCount

    @property
    def UCBCount(self):
        r"""自定义规则数量
        :rtype: int
        """
        return self._UCBCount

    @UCBCount.setter
    def UCBCount(self, UCBCount):
        self._UCBCount = UCBCount

    @property
    def MatchType(self):
        r"""场景的匹配范围，global-全部匹配 custom-自定义匹配范围
        :rtype: str
        """
        return self._MatchType

    @MatchType.setter
    def MatchType(self, MatchType):
        self._MatchType = MatchType

    @property
    def ActionMatchType(self):
        r"""匹配条件间的与或关系
        :rtype: str
        """
        return self._ActionMatchType

    @ActionMatchType.setter
    def ActionMatchType(self, ActionMatchType):
        self._ActionMatchType = ActionMatchType

    @property
    def UAStatus(self):
        r"""UA模块开关
        :rtype: bool
        """
        return self._UAStatus

    @UAStatus.setter
    def UAStatus(self, UAStatus):
        self._UAStatus = UAStatus

    @property
    def JsInjectRuleId(self):
        r"""简易模式场景：前端对抗对应mysql的记录id
        :rtype: int
        """
        return self._JsInjectRuleId

    @JsInjectRuleId.setter
    def JsInjectRuleId(self, JsInjectRuleId):
        self._JsInjectRuleId = JsInjectRuleId

    @property
    def JsInjectAction(self):
        r"""简易模式场景：前端对抗配置动作
        :rtype: int
        """
        return self._JsInjectAction

    @JsInjectAction.setter
    def JsInjectAction(self, JsInjectAction):
        self._JsInjectAction = JsInjectAction

    @property
    def JsInjectRedirect(self):
        r"""简易模式场景：前端对抗重定向路径
        :rtype: str
        """
        return self._JsInjectRedirect

    @JsInjectRedirect.setter
    def JsInjectRedirect(self, JsInjectRedirect):
        self._JsInjectRedirect = JsInjectRedirect

    @property
    def ActionRuleList(self):
        r"""简易模式场景：动作策略信息  PS:简易模式只有一个动作策略
        :rtype: list of BotSceneActionRule
        """
        return self._ActionRuleList

    @ActionRuleList.setter
    def ActionRuleList(self, ActionRuleList):
        self._ActionRuleList = ActionRuleList

    @property
    def BotIdPattern(self):
        r"""简易模式场景：monitor-观察 intercept-拦截 custom-自定义
        :rtype: str
        """
        return self._BotIdPattern

    @BotIdPattern.setter
    def BotIdPattern(self, BotIdPattern):
        self._BotIdPattern = BotIdPattern

    @property
    def BotIdCount(self):
        r"""简易模式场景：bot_id规则总数
        :rtype: int
        """
        return self._BotIdCount

    @BotIdCount.setter
    def BotIdCount(self, BotIdCount):
        self._BotIdCount = BotIdCount

    @property
    def BotIdMonitorCount(self):
        r"""简易模式场景：观察动作的规则总数
        :rtype: int
        """
        return self._BotIdMonitorCount

    @BotIdMonitorCount.setter
    def BotIdMonitorCount(self, BotIdMonitorCount):
        self._BotIdMonitorCount = BotIdMonitorCount

    @property
    def BotIdInterceptCount(self):
        r"""简易模式场景：拦截动作的规则总数
        :rtype: int
        """
        return self._BotIdInterceptCount

    @BotIdInterceptCount.setter
    def BotIdInterceptCount(self, BotIdInterceptCount):
        self._BotIdInterceptCount = BotIdInterceptCount

    @property
    def RuleSetSelection(self):
        r"""创建场景时选择的规则集
        :rtype: list of str
        """
        return self._RuleSetSelection

    @RuleSetSelection.setter
    def RuleSetSelection(self, RuleSetSelection):
        self._RuleSetSelection = RuleSetSelection

    @property
    def TokenList(self):
        r"""改场景的bot token列表
        :rtype: list of BotToken
        """
        return self._TokenList

    @TokenList.setter
    def TokenList(self, TokenList):
        self._TokenList = TokenList

    @property
    def BotIdRedirectCount(self):
        r"""简易模式场景：重定向动作的规则总数
        :rtype: int
        """
        return self._BotIdRedirectCount

    @BotIdRedirectCount.setter
    def BotIdRedirectCount(self, BotIdRedirectCount):
        self._BotIdRedirectCount = BotIdRedirectCount

    @property
    def BotIdCaptchaCount(self):
        r"""简易模式场景：人机识别动作的规则总数
        :rtype: int
        """
        return self._BotIdCaptchaCount

    @BotIdCaptchaCount.setter
    def BotIdCaptchaCount(self, BotIdCaptchaCount):
        self._BotIdCaptchaCount = BotIdCaptchaCount

    @property
    def BotIdProtectLevel(self):
        r"""简易模式场景：防护等级
        :rtype: str
        """
        return self._BotIdProtectLevel

    @BotIdProtectLevel.setter
    def BotIdProtectLevel(self, BotIdProtectLevel):
        self._BotIdProtectLevel = BotIdProtectLevel

    @property
    def BotIdGlobalRedirect(self):
        r"""简易模式场景：全局重定向路径
        :rtype: str
        """
        return self._BotIdGlobalRedirect

    @BotIdGlobalRedirect.setter
    def BotIdGlobalRedirect(self, BotIdGlobalRedirect):
        self._BotIdGlobalRedirect = BotIdGlobalRedirect

    @property
    def BotIdJsChallengeCount(self):
        r"""简易模式场景：JS校验动作的规则总数
        :rtype: int
        """
        return self._BotIdJsChallengeCount

    @BotIdJsChallengeCount.setter
    def BotIdJsChallengeCount(self, BotIdJsChallengeCount):
        self._BotIdJsChallengeCount = BotIdJsChallengeCount


    def _deserialize(self, params):
        self._SceneId = params.get("SceneId")
        self._Type = params.get("Type")
        self._SceneName = params.get("SceneName")
        self._UpdateTime = params.get("UpdateTime")
        self._BusinessType = params.get("BusinessType")
        self._ClientType = params.get("ClientType")
        self._Priority = params.get("Priority")
        if params.get("MatchCondition") is not None:
            self._MatchCondition = []
            for item in params.get("MatchCondition"):
                obj = BotSceneMatchCondition()
                obj._deserialize(item)
                self._MatchCondition.append(obj)
        self._SceneStatus = params.get("SceneStatus")
        self._JsInjectStatus = params.get("JsInjectStatus")
        self._AIStatus = params.get("AIStatus")
        self._TIStatus = params.get("TIStatus")
        self._StatisticStatus = params.get("StatisticStatus")
        self._ActionRuleCount = params.get("ActionRuleCount")
        self._UCBCount = params.get("UCBCount")
        self._MatchType = params.get("MatchType")
        self._ActionMatchType = params.get("ActionMatchType")
        self._UAStatus = params.get("UAStatus")
        self._JsInjectRuleId = params.get("JsInjectRuleId")
        self._JsInjectAction = params.get("JsInjectAction")
        self._JsInjectRedirect = params.get("JsInjectRedirect")
        if params.get("ActionRuleList") is not None:
            self._ActionRuleList = []
            for item in params.get("ActionRuleList"):
                obj = BotSceneActionRule()
                obj._deserialize(item)
                self._ActionRuleList.append(obj)
        self._BotIdPattern = params.get("BotIdPattern")
        self._BotIdCount = params.get("BotIdCount")
        self._BotIdMonitorCount = params.get("BotIdMonitorCount")
        self._BotIdInterceptCount = params.get("BotIdInterceptCount")
        self._RuleSetSelection = params.get("RuleSetSelection")
        if params.get("TokenList") is not None:
            self._TokenList = []
            for item in params.get("TokenList"):
                obj = BotToken()
                obj._deserialize(item)
                self._TokenList.append(obj)
        self._BotIdRedirectCount = params.get("BotIdRedirectCount")
        self._BotIdCaptchaCount = params.get("BotIdCaptchaCount")
        self._BotIdProtectLevel = params.get("BotIdProtectLevel")
        self._BotIdGlobalRedirect = params.get("BotIdGlobalRedirect")
        self._BotIdJsChallengeCount = params.get("BotIdJsChallengeCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BotSceneMatchCondition(AbstractModel):
    r"""场景匹配条件

    """

    def __init__(self):
        r"""
        :param _Key: 匹配参数
        :type Key: str
        :param _Op: 匹配符
        :type Op: str
        :param _Value: 匹配值
        :type Value: str
        :param _Name: 对于头部字段匹配value的时候指定的头部名
        :type Name: str
        :param _ValueArray: 470后使用此入参存在多值
        :type ValueArray: list of str
        """
        self._Key = None
        self._Op = None
        self._Value = None
        self._Name = None
        self._ValueArray = None

    @property
    def Key(self):
        r"""匹配参数
        :rtype: str
        """
        return self._Key

    @Key.setter
    def Key(self, Key):
        self._Key = Key

    @property
    def Op(self):
        r"""匹配符
        :rtype: str
        """
        return self._Op

    @Op.setter
    def Op(self, Op):
        self._Op = Op

    @property
    def Value(self):
        r"""匹配值
        :rtype: str
        """
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value

    @property
    def Name(self):
        r"""对于头部字段匹配value的时候指定的头部名
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def ValueArray(self):
        r"""470后使用此入参存在多值
        :rtype: list of str
        """
        return self._ValueArray

    @ValueArray.setter
    def ValueArray(self, ValueArray):
        self._ValueArray = ValueArray


    def _deserialize(self, params):
        self._Key = params.get("Key")
        self._Op = params.get("Op")
        self._Value = params.get("Value")
        self._Name = params.get("Name")
        self._ValueArray = params.get("ValueArray")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BotScoreRuleEntry(AbstractModel):
    r"""动作策略的一条分数段实体

    """

    def __init__(self):
        r"""
        :param _Upper: 分数区间上限
        :type Upper: str
        :param _Lower: 分数区间下限
        :type Lower: str
        :param _Action: 处置动作
        :type Action: str
        :param _Label: 流量标签
        :type Label: str
        :param _Redirect: 重定向
        :type Redirect: str
        """
        self._Upper = None
        self._Lower = None
        self._Action = None
        self._Label = None
        self._Redirect = None

    @property
    def Upper(self):
        r"""分数区间上限
        :rtype: str
        """
        return self._Upper

    @Upper.setter
    def Upper(self, Upper):
        self._Upper = Upper

    @property
    def Lower(self):
        r"""分数区间下限
        :rtype: str
        """
        return self._Lower

    @Lower.setter
    def Lower(self, Lower):
        self._Lower = Lower

    @property
    def Action(self):
        r"""处置动作
        :rtype: str
        """
        return self._Action

    @Action.setter
    def Action(self, Action):
        self._Action = Action

    @property
    def Label(self):
        r"""流量标签
        :rtype: str
        """
        return self._Label

    @Label.setter
    def Label(self, Label):
        self._Label = Label

    @property
    def Redirect(self):
        r"""重定向
        :rtype: str
        """
        return self._Redirect

    @Redirect.setter
    def Redirect(self, Redirect):
        self._Redirect = Redirect


    def _deserialize(self, params):
        self._Upper = params.get("Upper")
        self._Lower = params.get("Lower")
        self._Action = params.get("Action")
        self._Label = params.get("Label")
        self._Redirect = params.get("Redirect")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BotStatPointItem(AbstractModel):
    r"""bot的趋势图对象

    """

    def __init__(self):
        r"""
        :param _TimeStamp: 横坐标
        :type TimeStamp: str
        :param _Key: value的所属对象
        :type Key: str
        :param _Value: 纵列表
        :type Value: int
        :param _Label: Key对应的页面展示内容
        :type Label: str
        """
        self._TimeStamp = None
        self._Key = None
        self._Value = None
        self._Label = None

    @property
    def TimeStamp(self):
        r"""横坐标
        :rtype: str
        """
        return self._TimeStamp

    @TimeStamp.setter
    def TimeStamp(self, TimeStamp):
        self._TimeStamp = TimeStamp

    @property
    def Key(self):
        r"""value的所属对象
        :rtype: str
        """
        return self._Key

    @Key.setter
    def Key(self, Key):
        self._Key = Key

    @property
    def Value(self):
        r"""纵列表
        :rtype: int
        """
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value

    @property
    def Label(self):
        r"""Key对应的页面展示内容
        :rtype: str
        """
        return self._Label

    @Label.setter
    def Label(self, Label):
        self._Label = Label


    def _deserialize(self, params):
        self._TimeStamp = params.get("TimeStamp")
        self._Key = params.get("Key")
        self._Value = params.get("Value")
        self._Label = params.get("Label")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BotToken(AbstractModel):
    r"""bot-token配置

    """

    def __init__(self):
        r"""
        :param _Name: 会话名称
        :type Name: str
        :param _Description: 会话描述
        :type Description: str
        :param _Id: 会话id
        :type Id: str
        :param _Status: 策略的开关状态
        :type Status: bool
        :param _Location: 会话位置
        :type Location: str
        :param _Key: 会话key
        :type Key: str
        :param _Operator: 会话匹配方式，前缀匹配、后缀匹配等
        :type Operator: str
        :param _Timestamp: 会话更新的时间戳
        :type Timestamp: int
        :param _Scene: 场景列表，内容为空表示全部场景应用
        :type Scene: list of str
        :param _Priority: 优先级
        :type Priority: int
        :param _TokenValidation: token有效性配置信息
        :type TokenValidation: :class:`tencentcloud.waf.v20180125.models.TokenValidation`
        """
        self._Name = None
        self._Description = None
        self._Id = None
        self._Status = None
        self._Location = None
        self._Key = None
        self._Operator = None
        self._Timestamp = None
        self._Scene = None
        self._Priority = None
        self._TokenValidation = None

    @property
    def Name(self):
        r"""会话名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Description(self):
        r"""会话描述
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Id(self):
        r"""会话id
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Status(self):
        r"""策略的开关状态
        :rtype: bool
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Location(self):
        r"""会话位置
        :rtype: str
        """
        return self._Location

    @Location.setter
    def Location(self, Location):
        self._Location = Location

    @property
    def Key(self):
        r"""会话key
        :rtype: str
        """
        return self._Key

    @Key.setter
    def Key(self, Key):
        self._Key = Key

    @property
    def Operator(self):
        r"""会话匹配方式，前缀匹配、后缀匹配等
        :rtype: str
        """
        return self._Operator

    @Operator.setter
    def Operator(self, Operator):
        self._Operator = Operator

    @property
    def Timestamp(self):
        r"""会话更新的时间戳
        :rtype: int
        """
        return self._Timestamp

    @Timestamp.setter
    def Timestamp(self, Timestamp):
        self._Timestamp = Timestamp

    @property
    def Scene(self):
        r"""场景列表，内容为空表示全部场景应用
        :rtype: list of str
        """
        return self._Scene

    @Scene.setter
    def Scene(self, Scene):
        self._Scene = Scene

    @property
    def Priority(self):
        r"""优先级
        :rtype: int
        """
        return self._Priority

    @Priority.setter
    def Priority(self, Priority):
        self._Priority = Priority

    @property
    def TokenValidation(self):
        r"""token有效性配置信息
        :rtype: :class:`tencentcloud.waf.v20180125.models.TokenValidation`
        """
        return self._TokenValidation

    @TokenValidation.setter
    def TokenValidation(self, TokenValidation):
        self._TokenValidation = TokenValidation


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Description = params.get("Description")
        self._Id = params.get("Id")
        self._Status = params.get("Status")
        self._Location = params.get("Location")
        self._Key = params.get("Key")
        self._Operator = params.get("Operator")
        self._Timestamp = params.get("Timestamp")
        self._Scene = params.get("Scene")
        self._Priority = params.get("Priority")
        if params.get("TokenValidation") is not None:
            self._TokenValidation = TokenValidation()
            self._TokenValidation._deserialize(params.get("TokenValidation"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CCRuleData(AbstractModel):
    r"""数据封装

    """

    def __init__(self):
        r"""
        :param _Res: cc规则
        :type Res: list of CCRuleItem
        :param _TotalCount: 规则数目
        :type TotalCount: int
        """
        self._Res = None
        self._TotalCount = None

    @property
    def Res(self):
        r"""cc规则
        :rtype: list of CCRuleItem
        """
        return self._Res

    @Res.setter
    def Res(self, Res):
        self._Res = Res

    @property
    def TotalCount(self):
        r"""规则数目
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount


    def _deserialize(self, params):
        if params.get("Res") is not None:
            self._Res = []
            for item in params.get("Res"):
                obj = CCRuleItem()
                obj._deserialize(item)
                self._Res.append(obj)
        self._TotalCount = params.get("TotalCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CCRuleItem(AbstractModel):
    r"""cc规则

    """

    def __init__(self):
        r"""
        :param _ActionType: 动作，20表示观察，21表示人机识别，22表示拦截，23表示精准拦截，24表示JS校验
        :type ActionType: int
        :param _Advance: 高级模式
        :type Advance: int
        :param _Interval: 时间周期
        :type Interval: int
        :param _Limit: 限制次数
        :type Limit: int
        :param _MatchFunc: 匹配方法
        :type MatchFunc: int
        :param _Name: 名称
        :type Name: str
        :param _Priority: 优先级
        :type Priority: int
        :param _Status: 状态
        :type Status: int
        :param _TsVersion: 更新时间戳
        :type TsVersion: int
        :param _Url: 匹配url
        :type Url: str
        :param _ValidTime: 策略动作有效时间
        :type ValidTime: int
        :param _OptionsArr: 高级参数
        :type OptionsArr: str
        :param _Length: url长度
        :type Length: int
        :param _RuleId: 规则ID
        :type RuleId: int
        :param _EventId: 事件id
        :type EventId: str
        :param _SessionApplied: 关联的Session规则
        :type SessionApplied: list of int
        :param _CreateTime: 创建时间
        :type CreateTime: int
        """
        self._ActionType = None
        self._Advance = None
        self._Interval = None
        self._Limit = None
        self._MatchFunc = None
        self._Name = None
        self._Priority = None
        self._Status = None
        self._TsVersion = None
        self._Url = None
        self._ValidTime = None
        self._OptionsArr = None
        self._Length = None
        self._RuleId = None
        self._EventId = None
        self._SessionApplied = None
        self._CreateTime = None

    @property
    def ActionType(self):
        r"""动作，20表示观察，21表示人机识别，22表示拦截，23表示精准拦截，24表示JS校验
        :rtype: int
        """
        return self._ActionType

    @ActionType.setter
    def ActionType(self, ActionType):
        self._ActionType = ActionType

    @property
    def Advance(self):
        r"""高级模式
        :rtype: int
        """
        return self._Advance

    @Advance.setter
    def Advance(self, Advance):
        self._Advance = Advance

    @property
    def Interval(self):
        r"""时间周期
        :rtype: int
        """
        return self._Interval

    @Interval.setter
    def Interval(self, Interval):
        self._Interval = Interval

    @property
    def Limit(self):
        r"""限制次数
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def MatchFunc(self):
        r"""匹配方法
        :rtype: int
        """
        return self._MatchFunc

    @MatchFunc.setter
    def MatchFunc(self, MatchFunc):
        self._MatchFunc = MatchFunc

    @property
    def Name(self):
        r"""名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Priority(self):
        r"""优先级
        :rtype: int
        """
        return self._Priority

    @Priority.setter
    def Priority(self, Priority):
        self._Priority = Priority

    @property
    def Status(self):
        r"""状态
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def TsVersion(self):
        r"""更新时间戳
        :rtype: int
        """
        return self._TsVersion

    @TsVersion.setter
    def TsVersion(self, TsVersion):
        self._TsVersion = TsVersion

    @property
    def Url(self):
        r"""匹配url
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def ValidTime(self):
        r"""策略动作有效时间
        :rtype: int
        """
        return self._ValidTime

    @ValidTime.setter
    def ValidTime(self, ValidTime):
        self._ValidTime = ValidTime

    @property
    def OptionsArr(self):
        r"""高级参数
        :rtype: str
        """
        return self._OptionsArr

    @OptionsArr.setter
    def OptionsArr(self, OptionsArr):
        self._OptionsArr = OptionsArr

    @property
    def Length(self):
        r"""url长度
        :rtype: int
        """
        return self._Length

    @Length.setter
    def Length(self, Length):
        self._Length = Length

    @property
    def RuleId(self):
        r"""规则ID
        :rtype: int
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def EventId(self):
        r"""事件id
        :rtype: str
        """
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId

    @property
    def SessionApplied(self):
        r"""关联的Session规则
        :rtype: list of int
        """
        return self._SessionApplied

    @SessionApplied.setter
    def SessionApplied(self, SessionApplied):
        self._SessionApplied = SessionApplied

    @property
    def CreateTime(self):
        r"""创建时间
        :rtype: int
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime


    def _deserialize(self, params):
        self._ActionType = params.get("ActionType")
        self._Advance = params.get("Advance")
        self._Interval = params.get("Interval")
        self._Limit = params.get("Limit")
        self._MatchFunc = params.get("MatchFunc")
        self._Name = params.get("Name")
        self._Priority = params.get("Priority")
        self._Status = params.get("Status")
        self._TsVersion = params.get("TsVersion")
        self._Url = params.get("Url")
        self._ValidTime = params.get("ValidTime")
        self._OptionsArr = params.get("OptionsArr")
        self._Length = params.get("Length")
        self._RuleId = params.get("RuleId")
        self._EventId = params.get("EventId")
        self._SessionApplied = params.get("SessionApplied")
        self._CreateTime = params.get("CreateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CCRuleItems(AbstractModel):
    r"""CC规则详情

    """

    def __init__(self):
        r"""
        :param _Name: 名字
        :type Name: str
        :param _Status: 状态
        :type Status: int
        :param _Advance: 模式
        :type Advance: int
        :param _Limit: 限制
        :type Limit: int
        :param _Interval: 范围
        :type Interval: int
        :param _Url: 网址
        :type Url: str
        :param _MatchFunc: 匹配类型
        :type MatchFunc: int
        :param _ActionType: 动作，20表示观察，21表示人机识别，22表示拦截，23表示精准拦截，24表示JS校验
        :type ActionType: int
        :param _Priority: 优先级
        :type Priority: int
        :param _ValidTime: 有效时间
        :type ValidTime: int
        :param _TsVersion: 版本
        :type TsVersion: int
        :param _Options: key为匹配字段；args为base64编码后的参数，等于号前为匹配参数，等于号后为匹配内容；match为逻辑符号；encodeflag为参数内容是否编码
        :type Options: str
        :param _RuleId: 规则ID
        :type RuleId: int
        :param _EventId: 事件id
        :type EventId: str
        :param _SessionApplied: 关联的Session规则
        :type SessionApplied: list of int
        :param _CreateTime: 创建时间
        :type CreateTime: int
        :param _LimitMethod: 限频方式
        :type LimitMethod: str
        :param _CelRule: cel表达式
        :type CelRule: str
        :param _LogicalOp: 逻辑操作符
        :type LogicalOp: str
        :param _PageId: 页面ID
        :type PageId: str
        :param _ActionRatio: 动作灰度比例，默认值100
        :type ActionRatio: int
        :param _Domains: 批量cc规则配置的批量域名
        :type Domains: list of str
        :param _GroupIds: 批量cc规则使用的批量防护组
        :type GroupIds: list of int non-negative
        :param _JobType: 定时任务类型
        :type JobType: str
        :param _JobDateTime: 定时任务配置
        :type JobDateTime: :class:`tencentcloud.waf.v20180125.models.JobDateTime`
        :param _CronType: 定时任务类型：month or week
        :type CronType: str
        :param _ExpireTime: 过期时间
        :type ExpireTime: int
        :param _ValidStatus: 是否生效
        :type ValidStatus: int
        :param _Source: 来源：批量还是单个规则
        :type Source: str
        """
        self._Name = None
        self._Status = None
        self._Advance = None
        self._Limit = None
        self._Interval = None
        self._Url = None
        self._MatchFunc = None
        self._ActionType = None
        self._Priority = None
        self._ValidTime = None
        self._TsVersion = None
        self._Options = None
        self._RuleId = None
        self._EventId = None
        self._SessionApplied = None
        self._CreateTime = None
        self._LimitMethod = None
        self._CelRule = None
        self._LogicalOp = None
        self._PageId = None
        self._ActionRatio = None
        self._Domains = None
        self._GroupIds = None
        self._JobType = None
        self._JobDateTime = None
        self._CronType = None
        self._ExpireTime = None
        self._ValidStatus = None
        self._Source = None

    @property
    def Name(self):
        r"""名字
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Status(self):
        r"""状态
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Advance(self):
        r"""模式
        :rtype: int
        """
        return self._Advance

    @Advance.setter
    def Advance(self, Advance):
        self._Advance = Advance

    @property
    def Limit(self):
        r"""限制
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Interval(self):
        r"""范围
        :rtype: int
        """
        return self._Interval

    @Interval.setter
    def Interval(self, Interval):
        self._Interval = Interval

    @property
    def Url(self):
        r"""网址
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def MatchFunc(self):
        r"""匹配类型
        :rtype: int
        """
        return self._MatchFunc

    @MatchFunc.setter
    def MatchFunc(self, MatchFunc):
        self._MatchFunc = MatchFunc

    @property
    def ActionType(self):
        r"""动作，20表示观察，21表示人机识别，22表示拦截，23表示精准拦截，24表示JS校验
        :rtype: int
        """
        return self._ActionType

    @ActionType.setter
    def ActionType(self, ActionType):
        self._ActionType = ActionType

    @property
    def Priority(self):
        r"""优先级
        :rtype: int
        """
        return self._Priority

    @Priority.setter
    def Priority(self, Priority):
        self._Priority = Priority

    @property
    def ValidTime(self):
        r"""有效时间
        :rtype: int
        """
        return self._ValidTime

    @ValidTime.setter
    def ValidTime(self, ValidTime):
        self._ValidTime = ValidTime

    @property
    def TsVersion(self):
        r"""版本
        :rtype: int
        """
        return self._TsVersion

    @TsVersion.setter
    def TsVersion(self, TsVersion):
        self._TsVersion = TsVersion

    @property
    def Options(self):
        r"""key为匹配字段；args为base64编码后的参数，等于号前为匹配参数，等于号后为匹配内容；match为逻辑符号；encodeflag为参数内容是否编码
        :rtype: str
        """
        return self._Options

    @Options.setter
    def Options(self, Options):
        self._Options = Options

    @property
    def RuleId(self):
        r"""规则ID
        :rtype: int
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def EventId(self):
        r"""事件id
        :rtype: str
        """
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId

    @property
    def SessionApplied(self):
        r"""关联的Session规则
        :rtype: list of int
        """
        return self._SessionApplied

    @SessionApplied.setter
    def SessionApplied(self, SessionApplied):
        self._SessionApplied = SessionApplied

    @property
    def CreateTime(self):
        r"""创建时间
        :rtype: int
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def LimitMethod(self):
        r"""限频方式
        :rtype: str
        """
        return self._LimitMethod

    @LimitMethod.setter
    def LimitMethod(self, LimitMethod):
        self._LimitMethod = LimitMethod

    @property
    def CelRule(self):
        r"""cel表达式
        :rtype: str
        """
        return self._CelRule

    @CelRule.setter
    def CelRule(self, CelRule):
        self._CelRule = CelRule

    @property
    def LogicalOp(self):
        r"""逻辑操作符
        :rtype: str
        """
        return self._LogicalOp

    @LogicalOp.setter
    def LogicalOp(self, LogicalOp):
        self._LogicalOp = LogicalOp

    @property
    def PageId(self):
        r"""页面ID
        :rtype: str
        """
        return self._PageId

    @PageId.setter
    def PageId(self, PageId):
        self._PageId = PageId

    @property
    def ActionRatio(self):
        r"""动作灰度比例，默认值100
        :rtype: int
        """
        return self._ActionRatio

    @ActionRatio.setter
    def ActionRatio(self, ActionRatio):
        self._ActionRatio = ActionRatio

    @property
    def Domains(self):
        r"""批量cc规则配置的批量域名
        :rtype: list of str
        """
        return self._Domains

    @Domains.setter
    def Domains(self, Domains):
        self._Domains = Domains

    @property
    def GroupIds(self):
        r"""批量cc规则使用的批量防护组
        :rtype: list of int non-negative
        """
        return self._GroupIds

    @GroupIds.setter
    def GroupIds(self, GroupIds):
        self._GroupIds = GroupIds

    @property
    def JobType(self):
        r"""定时任务类型
        :rtype: str
        """
        return self._JobType

    @JobType.setter
    def JobType(self, JobType):
        self._JobType = JobType

    @property
    def JobDateTime(self):
        r"""定时任务配置
        :rtype: :class:`tencentcloud.waf.v20180125.models.JobDateTime`
        """
        return self._JobDateTime

    @JobDateTime.setter
    def JobDateTime(self, JobDateTime):
        self._JobDateTime = JobDateTime

    @property
    def CronType(self):
        r"""定时任务类型：month or week
        :rtype: str
        """
        return self._CronType

    @CronType.setter
    def CronType(self, CronType):
        self._CronType = CronType

    @property
    def ExpireTime(self):
        r"""过期时间
        :rtype: int
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def ValidStatus(self):
        r"""是否生效
        :rtype: int
        """
        return self._ValidStatus

    @ValidStatus.setter
    def ValidStatus(self, ValidStatus):
        self._ValidStatus = ValidStatus

    @property
    def Source(self):
        r"""来源：批量还是单个规则
        :rtype: str
        """
        return self._Source

    @Source.setter
    def Source(self, Source):
        self._Source = Source


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Status = params.get("Status")
        self._Advance = params.get("Advance")
        self._Limit = params.get("Limit")
        self._Interval = params.get("Interval")
        self._Url = params.get("Url")
        self._MatchFunc = params.get("MatchFunc")
        self._ActionType = params.get("ActionType")
        self._Priority = params.get("Priority")
        self._ValidTime = params.get("ValidTime")
        self._TsVersion = params.get("TsVersion")
        self._Options = params.get("Options")
        self._RuleId = params.get("RuleId")
        self._EventId = params.get("EventId")
        self._SessionApplied = params.get("SessionApplied")
        self._CreateTime = params.get("CreateTime")
        self._LimitMethod = params.get("LimitMethod")
        self._CelRule = params.get("CelRule")
        self._LogicalOp = params.get("LogicalOp")
        self._PageId = params.get("PageId")
        self._ActionRatio = params.get("ActionRatio")
        self._Domains = params.get("Domains")
        self._GroupIds = params.get("GroupIds")
        self._JobType = params.get("JobType")
        if params.get("JobDateTime") is not None:
            self._JobDateTime = JobDateTime()
            self._JobDateTime._deserialize(params.get("JobDateTime"))
        self._CronType = params.get("CronType")
        self._ExpireTime = params.get("ExpireTime")
        self._ValidStatus = params.get("ValidStatus")
        self._Source = params.get("Source")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CCRuleLists(AbstractModel):
    r"""CC规则总览

    """

    def __init__(self):
        r"""
        :param _TotalCount: 总数
        :type TotalCount: int
        :param _Res: 规则
        :type Res: list of CCRuleItems
        :param _Limit: 规则限制总数
        :type Limit: int
        :param _Available: 规则剩余多少可用
        :type Available: int
        """
        self._TotalCount = None
        self._Res = None
        self._Limit = None
        self._Available = None

    @property
    def TotalCount(self):
        r"""总数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Res(self):
        r"""规则
        :rtype: list of CCRuleItems
        """
        return self._Res

    @Res.setter
    def Res(self, Res):
        self._Res = Res

    @property
    def Limit(self):
        r"""规则限制总数
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Available(self):
        r"""规则剩余多少可用
        :rtype: int
        """
        return self._Available

    @Available.setter
    def Available(self, Available):
        self._Available = Available


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Res") is not None:
            self._Res = []
            for item in params.get("Res"):
                obj = CCRuleItems()
                obj._deserialize(item)
                self._Res.append(obj)
        self._Limit = params.get("Limit")
        self._Available = params.get("Available")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CacheUrlItems(AbstractModel):
    r"""防篡改url元素

    """

    def __init__(self):
        r"""
        :param _Id: 标识
        :type Id: int
        :param _Name: 名字
        :type Name: str
        :param _Domain: 域名
        :type Domain: str
        :param _Uri: 网址
        :type Uri: str
        :param _Protocol: 协议
        :type Protocol: str
        :param _Status: 状态
        :type Status: int
        :param _ModifyTime: 修改时间
        :type ModifyTime: str
        :param _CreateTime: 创建时间
        :type CreateTime: str
        """
        self._Id = None
        self._Name = None
        self._Domain = None
        self._Uri = None
        self._Protocol = None
        self._Status = None
        self._ModifyTime = None
        self._CreateTime = None

    @property
    def Id(self):
        r"""标识
        :rtype: int
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Name(self):
        r"""名字
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Uri(self):
        r"""网址
        :rtype: str
        """
        return self._Uri

    @Uri.setter
    def Uri(self, Uri):
        self._Uri = Uri

    @property
    def Protocol(self):
        r"""协议
        :rtype: str
        """
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol

    @property
    def Status(self):
        r"""状态
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ModifyTime(self):
        r"""修改时间
        :rtype: str
        """
        return self._ModifyTime

    @ModifyTime.setter
    def ModifyTime(self, ModifyTime):
        self._ModifyTime = ModifyTime

    @property
    def CreateTime(self):
        r"""创建时间
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Name = params.get("Name")
        self._Domain = params.get("Domain")
        self._Uri = params.get("Uri")
        self._Protocol = params.get("Protocol")
        self._Status = params.get("Status")
        self._ModifyTime = params.get("ModifyTime")
        self._CreateTime = params.get("CreateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CdcCluster(AbstractModel):
    r"""CDC场景下负载均衡WAF的集群信息

    """

    def __init__(self):
        r"""
        :param _Id: cdc的集群id
        :type Id: str
        :param _Name: cdc的集群名称
        :type Name: str
        """
        self._Id = None
        self._Name = None

    @property
    def Id(self):
        r"""cdc的集群id
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Name(self):
        r"""cdc的集群名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CdcRegion(AbstractModel):
    r"""CDC场景下负载均衡WAF的地域信息

    """

    def __init__(self):
        r"""
        :param _Region: 地域
        :type Region: str
        :param _Clusters: 该地域对应的集群信息
        :type Clusters: list of CdcCluster
        """
        self._Region = None
        self._Clusters = None

    @property
    def Region(self):
        r"""地域
        :rtype: str
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def Clusters(self):
        r"""该地域对应的集群信息
        :rtype: list of CdcCluster
        """
        return self._Clusters

    @Clusters.setter
    def Clusters(self, Clusters):
        self._Clusters = Clusters


    def _deserialize(self, params):
        self._Region = params.get("Region")
        if params.get("Clusters") is not None:
            self._Clusters = []
            for item in params.get("Clusters"):
                obj = CdcCluster()
                obj._deserialize(item)
                self._Clusters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClbDomainsInfo(AbstractModel):
    r"""负载均衡型WAF域名详情

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _DomainId: 域名唯一ID
        :type DomainId: str
        :param _InstanceId: 域名所属实例ID
        :type InstanceId: str
        :param _InstanceName: 域名所属实例名
        :type InstanceName: str
        :param _Edition: 域名所属实例类型
        :type Edition: str
        :param _IsCdn: waf前是否部署有七层代理服务。 0：没有部署代理服务 1：有部署代理服务，waf将使用XFF获取客户端IP 2：有部署代理服务，waf将使用remote_addr获取客户端IP 3：有部署代理服务，waf将使用ip_headers中的自定义header获取客户端IP
        :type IsCdn: int
        :param _LoadBalancerSet: 负载均衡类型为clb时，对应的负载均衡器信息
        :type LoadBalancerSet: list of LoadBalancerPackageNew
        :param _FlowMode: 负载均衡型WAF的流量模式，1：清洗模式，0：镜像模式
        :type FlowMode: int
        :param _State: 域名绑定负载均衡器状态
        :type State: int
        :param _AlbType: 负载均衡类型，clb或者apisix
        :type AlbType: str
        :param _IpHeaders: IsCdn=3时，表示自定义header
        :type IpHeaders: list of str
        :param _CdcClusters: cdc-clb-waf类型WAF的CDC集群信息
        :type CdcClusters: str
        :param _CloudType: 云类型:public:公有云；private:私有云;hybrid:混合云
        :type CloudType: str
        :param _Note: 域名备注信息
        :type Note: str
        :param _Labels: 域名标签
        :type Labels: list of str
        :param _AccessStatus: clbwaf接入状态，0代表“尚无流量接入”，1代表“流量接入”，2代表“CLB监听器已注销”，3代表“配置生效中”，4代表“配置下发失败中”
        :type AccessStatus: int
        """
        self._Domain = None
        self._DomainId = None
        self._InstanceId = None
        self._InstanceName = None
        self._Edition = None
        self._IsCdn = None
        self._LoadBalancerSet = None
        self._FlowMode = None
        self._State = None
        self._AlbType = None
        self._IpHeaders = None
        self._CdcClusters = None
        self._CloudType = None
        self._Note = None
        self._Labels = None
        self._AccessStatus = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def DomainId(self):
        r"""域名唯一ID
        :rtype: str
        """
        return self._DomainId

    @DomainId.setter
    def DomainId(self, DomainId):
        self._DomainId = DomainId

    @property
    def InstanceId(self):
        r"""域名所属实例ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def InstanceName(self):
        r"""域名所属实例名
        :rtype: str
        """
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def Edition(self):
        r"""域名所属实例类型
        :rtype: str
        """
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition

    @property
    def IsCdn(self):
        r"""waf前是否部署有七层代理服务。 0：没有部署代理服务 1：有部署代理服务，waf将使用XFF获取客户端IP 2：有部署代理服务，waf将使用remote_addr获取客户端IP 3：有部署代理服务，waf将使用ip_headers中的自定义header获取客户端IP
        :rtype: int
        """
        return self._IsCdn

    @IsCdn.setter
    def IsCdn(self, IsCdn):
        self._IsCdn = IsCdn

    @property
    def LoadBalancerSet(self):
        r"""负载均衡类型为clb时，对应的负载均衡器信息
        :rtype: list of LoadBalancerPackageNew
        """
        return self._LoadBalancerSet

    @LoadBalancerSet.setter
    def LoadBalancerSet(self, LoadBalancerSet):
        self._LoadBalancerSet = LoadBalancerSet

    @property
    def FlowMode(self):
        r"""负载均衡型WAF的流量模式，1：清洗模式，0：镜像模式
        :rtype: int
        """
        return self._FlowMode

    @FlowMode.setter
    def FlowMode(self, FlowMode):
        self._FlowMode = FlowMode

    @property
    def State(self):
        r"""域名绑定负载均衡器状态
        :rtype: int
        """
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def AlbType(self):
        r"""负载均衡类型，clb或者apisix
        :rtype: str
        """
        return self._AlbType

    @AlbType.setter
    def AlbType(self, AlbType):
        self._AlbType = AlbType

    @property
    def IpHeaders(self):
        r"""IsCdn=3时，表示自定义header
        :rtype: list of str
        """
        return self._IpHeaders

    @IpHeaders.setter
    def IpHeaders(self, IpHeaders):
        self._IpHeaders = IpHeaders

    @property
    def CdcClusters(self):
        r"""cdc-clb-waf类型WAF的CDC集群信息
        :rtype: str
        """
        return self._CdcClusters

    @CdcClusters.setter
    def CdcClusters(self, CdcClusters):
        self._CdcClusters = CdcClusters

    @property
    def CloudType(self):
        r"""云类型:public:公有云；private:私有云;hybrid:混合云
        :rtype: str
        """
        return self._CloudType

    @CloudType.setter
    def CloudType(self, CloudType):
        self._CloudType = CloudType

    @property
    def Note(self):
        r"""域名备注信息
        :rtype: str
        """
        return self._Note

    @Note.setter
    def Note(self, Note):
        self._Note = Note

    @property
    def Labels(self):
        r"""域名标签
        :rtype: list of str
        """
        return self._Labels

    @Labels.setter
    def Labels(self, Labels):
        self._Labels = Labels

    @property
    def AccessStatus(self):
        r"""clbwaf接入状态，0代表“尚无流量接入”，1代表“流量接入”，2代表“CLB监听器已注销”，3代表“配置生效中”，4代表“配置下发失败中”
        :rtype: int
        """
        return self._AccessStatus

    @AccessStatus.setter
    def AccessStatus(self, AccessStatus):
        self._AccessStatus = AccessStatus


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._DomainId = params.get("DomainId")
        self._InstanceId = params.get("InstanceId")
        self._InstanceName = params.get("InstanceName")
        self._Edition = params.get("Edition")
        self._IsCdn = params.get("IsCdn")
        if params.get("LoadBalancerSet") is not None:
            self._LoadBalancerSet = []
            for item in params.get("LoadBalancerSet"):
                obj = LoadBalancerPackageNew()
                obj._deserialize(item)
                self._LoadBalancerSet.append(obj)
        self._FlowMode = params.get("FlowMode")
        self._State = params.get("State")
        self._AlbType = params.get("AlbType")
        self._IpHeaders = params.get("IpHeaders")
        self._CdcClusters = params.get("CdcClusters")
        self._CloudType = params.get("CloudType")
        self._Note = params.get("Note")
        self._Labels = params.get("Labels")
        self._AccessStatus = params.get("AccessStatus")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClbObject(AbstractModel):
    r"""Clb类型防护对象

    """

    def __init__(self):
        r"""
        :param _ObjectId: 对象ID
        :type ObjectId: str
        :param _InstanceId: 实例ID
        :type InstanceId: str
        :param _InstanceName: 实例名称
        :type InstanceName: str
        :param _PreciseDomains: 精准域名列表
        :type PreciseDomains: list of str
        :param _Status: WAF功能开关状态，0关闭1开启
        :type Status: int
        :param _ClsStatus: WAF日志开关状态，0关闭1开启
        :type ClsStatus: int
        :param _VirtualDomain: CLB对象对应的虚拟域名
        :type VirtualDomain: str
        :param _ObjectName: 对象名称
        :type ObjectName: str
        :param _PublicIp: 公网地址
        :type PublicIp: list of str
        :param _PrivateIp: 内网地址
        :type PrivateIp: list of str
        :param _VpcName: VPC名称
        :type VpcName: str
        :param _Vpc: VPC ID
        :type Vpc: str
        :param _InstanceLevel: waf实例等级，如果未绑定实例为0
        :type InstanceLevel: int
        :param _PostCLSStatus: clb投递开关
        :type PostCLSStatus: int
        :param _PostCKafkaStatus: kafka投递开关
        :type PostCKafkaStatus: int
        :param _Type: 对象类型：CLB:负载均衡器，TSE:云原生网关
        :type Type: str
        :param _Region: 对象地域
        :type Region: str
        :param _Proxy: 代理状态: 0:不开启,1:以XFF的第一个IP地址作为客户端IP,2:以remote_addr作为客户端IP,3:从指定的头部字段获取客户端IP，字段通过IpHeaders字段给出
        :type Proxy: int
        :param _IpHeaders: 指定获取客户端IP的头部字段列表。IsCdn为3时有效
        :type IpHeaders: list of str
        :param _BotStatus: bot防护开关
        :type BotStatus: int
        :param _ApiStatus: api防护开关
        :type ApiStatus: int
        :param _ObjectFlowMode: 对象接入模式，0表示镜像模式，1表示清洗模式，2表示体检模式，默认为清洗模式
        :type ObjectFlowMode: int
        :param _NumericalVpcId: 数值形式的私有网络 ID
        :type NumericalVpcId: int
        :param _ModifyTime: 修改时间
        :type ModifyTime: str
        :param _AddTime: 创建时间
        :type AddTime: str
        """
        self._ObjectId = None
        self._InstanceId = None
        self._InstanceName = None
        self._PreciseDomains = None
        self._Status = None
        self._ClsStatus = None
        self._VirtualDomain = None
        self._ObjectName = None
        self._PublicIp = None
        self._PrivateIp = None
        self._VpcName = None
        self._Vpc = None
        self._InstanceLevel = None
        self._PostCLSStatus = None
        self._PostCKafkaStatus = None
        self._Type = None
        self._Region = None
        self._Proxy = None
        self._IpHeaders = None
        self._BotStatus = None
        self._ApiStatus = None
        self._ObjectFlowMode = None
        self._NumericalVpcId = None
        self._ModifyTime = None
        self._AddTime = None

    @property
    def ObjectId(self):
        r"""对象ID
        :rtype: str
        """
        return self._ObjectId

    @ObjectId.setter
    def ObjectId(self, ObjectId):
        self._ObjectId = ObjectId

    @property
    def InstanceId(self):
        r"""实例ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def InstanceName(self):
        r"""实例名称
        :rtype: str
        """
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def PreciseDomains(self):
        r"""精准域名列表
        :rtype: list of str
        """
        return self._PreciseDomains

    @PreciseDomains.setter
    def PreciseDomains(self, PreciseDomains):
        self._PreciseDomains = PreciseDomains

    @property
    def Status(self):
        r"""WAF功能开关状态，0关闭1开启
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ClsStatus(self):
        r"""WAF日志开关状态，0关闭1开启
        :rtype: int
        """
        return self._ClsStatus

    @ClsStatus.setter
    def ClsStatus(self, ClsStatus):
        self._ClsStatus = ClsStatus

    @property
    def VirtualDomain(self):
        r"""CLB对象对应的虚拟域名
        :rtype: str
        """
        return self._VirtualDomain

    @VirtualDomain.setter
    def VirtualDomain(self, VirtualDomain):
        self._VirtualDomain = VirtualDomain

    @property
    def ObjectName(self):
        r"""对象名称
        :rtype: str
        """
        return self._ObjectName

    @ObjectName.setter
    def ObjectName(self, ObjectName):
        self._ObjectName = ObjectName

    @property
    def PublicIp(self):
        r"""公网地址
        :rtype: list of str
        """
        return self._PublicIp

    @PublicIp.setter
    def PublicIp(self, PublicIp):
        self._PublicIp = PublicIp

    @property
    def PrivateIp(self):
        r"""内网地址
        :rtype: list of str
        """
        return self._PrivateIp

    @PrivateIp.setter
    def PrivateIp(self, PrivateIp):
        self._PrivateIp = PrivateIp

    @property
    def VpcName(self):
        r"""VPC名称
        :rtype: str
        """
        return self._VpcName

    @VpcName.setter
    def VpcName(self, VpcName):
        self._VpcName = VpcName

    @property
    def Vpc(self):
        r"""VPC ID
        :rtype: str
        """
        return self._Vpc

    @Vpc.setter
    def Vpc(self, Vpc):
        self._Vpc = Vpc

    @property
    def InstanceLevel(self):
        r"""waf实例等级，如果未绑定实例为0
        :rtype: int
        """
        return self._InstanceLevel

    @InstanceLevel.setter
    def InstanceLevel(self, InstanceLevel):
        self._InstanceLevel = InstanceLevel

    @property
    def PostCLSStatus(self):
        r"""clb投递开关
        :rtype: int
        """
        return self._PostCLSStatus

    @PostCLSStatus.setter
    def PostCLSStatus(self, PostCLSStatus):
        self._PostCLSStatus = PostCLSStatus

    @property
    def PostCKafkaStatus(self):
        r"""kafka投递开关
        :rtype: int
        """
        return self._PostCKafkaStatus

    @PostCKafkaStatus.setter
    def PostCKafkaStatus(self, PostCKafkaStatus):
        self._PostCKafkaStatus = PostCKafkaStatus

    @property
    def Type(self):
        r"""对象类型：CLB:负载均衡器，TSE:云原生网关
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Region(self):
        r"""对象地域
        :rtype: str
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def Proxy(self):
        r"""代理状态: 0:不开启,1:以XFF的第一个IP地址作为客户端IP,2:以remote_addr作为客户端IP,3:从指定的头部字段获取客户端IP，字段通过IpHeaders字段给出
        :rtype: int
        """
        return self._Proxy

    @Proxy.setter
    def Proxy(self, Proxy):
        self._Proxy = Proxy

    @property
    def IpHeaders(self):
        r"""指定获取客户端IP的头部字段列表。IsCdn为3时有效
        :rtype: list of str
        """
        return self._IpHeaders

    @IpHeaders.setter
    def IpHeaders(self, IpHeaders):
        self._IpHeaders = IpHeaders

    @property
    def BotStatus(self):
        r"""bot防护开关
        :rtype: int
        """
        return self._BotStatus

    @BotStatus.setter
    def BotStatus(self, BotStatus):
        self._BotStatus = BotStatus

    @property
    def ApiStatus(self):
        r"""api防护开关
        :rtype: int
        """
        return self._ApiStatus

    @ApiStatus.setter
    def ApiStatus(self, ApiStatus):
        self._ApiStatus = ApiStatus

    @property
    def ObjectFlowMode(self):
        r"""对象接入模式，0表示镜像模式，1表示清洗模式，2表示体检模式，默认为清洗模式
        :rtype: int
        """
        return self._ObjectFlowMode

    @ObjectFlowMode.setter
    def ObjectFlowMode(self, ObjectFlowMode):
        self._ObjectFlowMode = ObjectFlowMode

    @property
    def NumericalVpcId(self):
        r"""数值形式的私有网络 ID
        :rtype: int
        """
        return self._NumericalVpcId

    @NumericalVpcId.setter
    def NumericalVpcId(self, NumericalVpcId):
        self._NumericalVpcId = NumericalVpcId

    @property
    def ModifyTime(self):
        r"""修改时间
        :rtype: str
        """
        return self._ModifyTime

    @ModifyTime.setter
    def ModifyTime(self, ModifyTime):
        self._ModifyTime = ModifyTime

    @property
    def AddTime(self):
        r"""创建时间
        :rtype: str
        """
        return self._AddTime

    @AddTime.setter
    def AddTime(self, AddTime):
        self._AddTime = AddTime


    def _deserialize(self, params):
        self._ObjectId = params.get("ObjectId")
        self._InstanceId = params.get("InstanceId")
        self._InstanceName = params.get("InstanceName")
        self._PreciseDomains = params.get("PreciseDomains")
        self._Status = params.get("Status")
        self._ClsStatus = params.get("ClsStatus")
        self._VirtualDomain = params.get("VirtualDomain")
        self._ObjectName = params.get("ObjectName")
        self._PublicIp = params.get("PublicIp")
        self._PrivateIp = params.get("PrivateIp")
        self._VpcName = params.get("VpcName")
        self._Vpc = params.get("Vpc")
        self._InstanceLevel = params.get("InstanceLevel")
        self._PostCLSStatus = params.get("PostCLSStatus")
        self._PostCKafkaStatus = params.get("PostCKafkaStatus")
        self._Type = params.get("Type")
        self._Region = params.get("Region")
        self._Proxy = params.get("Proxy")
        self._IpHeaders = params.get("IpHeaders")
        self._BotStatus = params.get("BotStatus")
        self._ApiStatus = params.get("ApiStatus")
        self._ObjectFlowMode = params.get("ObjectFlowMode")
        self._NumericalVpcId = params.get("NumericalVpcId")
        self._ModifyTime = params.get("ModifyTime")
        self._AddTime = params.get("AddTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClbWafRegionItem(AbstractModel):
    r"""Clb-waf地域信息

    """

    def __init__(self):
        r"""
        :param _Id: 地域ID
        :type Id: str
        :param _Text: 地域中文说明
        :type Text: str
        :param _Value: 地域英文全拼
        :type Value: str
        :param _Code: 地域编码
        :type Code: str
        """
        self._Id = None
        self._Text = None
        self._Value = None
        self._Code = None

    @property
    def Id(self):
        r"""地域ID
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Text(self):
        r"""地域中文说明
        :rtype: str
        """
        return self._Text

    @Text.setter
    def Text(self, Text):
        self._Text = Text

    @property
    def Value(self):
        r"""地域英文全拼
        :rtype: str
        """
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value

    @property
    def Code(self):
        r"""地域编码
        :rtype: str
        """
        return self._Code

    @Code.setter
    def Code(self, Code):
        self._Code = Code


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Text = params.get("Text")
        self._Value = params.get("Value")
        self._Code = params.get("Code")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Column(AbstractModel):
    r"""日志分析的列属性

    """

    def __init__(self):
        r"""
        :param _Name: 列的名字
        :type Name: str
        :param _Type: 列的属性
        :type Type: str
        """
        self._Name = None
        self._Type = None

    @property
    def Name(self):
        r"""列的名字
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Type(self):
        r"""列的属性
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CommonRspData(AbstractModel):
    r"""通用返回

    """

    def __init__(self):
        r"""
        :param _Code: 操作结果
        :type Code: int
        :param _Msg: 输出信息
        :type Msg: str
        """
        self._Code = None
        self._Msg = None

    @property
    def Code(self):
        r"""操作结果
        :rtype: int
        """
        return self._Code

    @Code.setter
    def Code(self, Code):
        self._Code = Code

    @property
    def Msg(self):
        r"""输出信息
        :rtype: str
        """
        return self._Msg

    @Msg.setter
    def Msg(self, Msg):
        self._Msg = Msg


    def _deserialize(self, params):
        self._Code = params.get("Code")
        self._Msg = params.get("Msg")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ConditionInfo(AbstractModel):
    r"""免鉴权条件信息

    """

    def __init__(self):
        r"""
        :param _Attributes: 条件属性，目前只支持VpcID
        :type Attributes: str
        :param _Rule: 条件规则，1:等于，2:不等于
        :type Rule: int
        :param _ConditionValue: 对应条件属性的值
        :type ConditionValue: str
        """
        self._Attributes = None
        self._Rule = None
        self._ConditionValue = None

    @property
    def Attributes(self):
        r"""条件属性，目前只支持VpcID
        :rtype: str
        """
        return self._Attributes

    @Attributes.setter
    def Attributes(self, Attributes):
        self._Attributes = Attributes

    @property
    def Rule(self):
        r"""条件规则，1:等于，2:不等于
        :rtype: int
        """
        return self._Rule

    @Rule.setter
    def Rule(self, Rule):
        self._Rule = Rule

    @property
    def ConditionValue(self):
        r"""对应条件属性的值
        :rtype: str
        """
        return self._ConditionValue

    @ConditionValue.setter
    def ConditionValue(self, ConditionValue):
        self._ConditionValue = ConditionValue


    def _deserialize(self, params):
        self._Attributes = params.get("Attributes")
        self._Rule = params.get("Rule")
        self._ConditionValue = params.get("ConditionValue")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAccessExportRequest(AbstractModel):
    r"""CreateAccessExport请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TopicId: 客户要查询的日志主题ID，每个客户都有对应的一个主题
        :type TopicId: str
        :param _From: 要查询的日志的起始时间，Unix时间戳，单位ms
        :type From: int
        :param _To: 要查询的日志的结束时间，Unix时间戳，单位ms
        :type To: int
        :param _Query: 日志导出检索语句
        :type Query: str
        :param _Count: 日志导出数量，最大值100w
        :type Count: int
        :param _Format: 日志导出数据格式。json，csv，默认为json
        :type Format: str
        :param _Order: 日志导出时间排序。desc，asc，默认为desc
        :type Order: str
        """
        self._TopicId = None
        self._From = None
        self._To = None
        self._Query = None
        self._Count = None
        self._Format = None
        self._Order = None

    @property
    def TopicId(self):
        r"""客户要查询的日志主题ID，每个客户都有对应的一个主题
        :rtype: str
        """
        return self._TopicId

    @TopicId.setter
    def TopicId(self, TopicId):
        self._TopicId = TopicId

    @property
    def From(self):
        r"""要查询的日志的起始时间，Unix时间戳，单位ms
        :rtype: int
        """
        return self._From

    @From.setter
    def From(self, From):
        self._From = From

    @property
    def To(self):
        r"""要查询的日志的结束时间，Unix时间戳，单位ms
        :rtype: int
        """
        return self._To

    @To.setter
    def To(self, To):
        self._To = To

    @property
    def Query(self):
        r"""日志导出检索语句
        :rtype: str
        """
        return self._Query

    @Query.setter
    def Query(self, Query):
        self._Query = Query

    @property
    def Count(self):
        r"""日志导出数量，最大值100w
        :rtype: int
        """
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def Format(self):
        r"""日志导出数据格式。json，csv，默认为json
        :rtype: str
        """
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def Order(self):
        r"""日志导出时间排序。desc，asc，默认为desc
        :rtype: str
        """
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._TopicId = params.get("TopicId")
        self._From = params.get("From")
        self._To = params.get("To")
        self._Query = params.get("Query")
        self._Count = params.get("Count")
        self._Format = params.get("Format")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAccessExportResponse(AbstractModel):
    r"""CreateAccessExport返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ExportId: 日志导出ID。
        :type ExportId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ExportId = None
        self._RequestId = None

    @property
    def ExportId(self):
        r"""日志导出ID。
        :rtype: str
        """
        return self._ExportId

    @ExportId.setter
    def ExportId(self, ExportId):
        self._ExportId = ExportId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ExportId = params.get("ExportId")
        self._RequestId = params.get("RequestId")


class CreateAreaBanRuleRequest(AbstractModel):
    r"""CreateAreaBanRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 需要修改的域名
        :type Domain: str
        :param _Areas: 需要新增的封禁地域
        :type Areas: list of Area
        :param _JobType: 规则执行的方式，TimedJob为定时执行，CronJob为周期执行
        :type JobType: str
        :param _JobDateTime: 定时任务配置
        :type JobDateTime: :class:`tencentcloud.waf.v20180125.models.JobDateTime`
        :param _Lang: 地域信息的语言，支持cn、en，默认为中文cn
        :type Lang: str
        """
        self._Domain = None
        self._Areas = None
        self._JobType = None
        self._JobDateTime = None
        self._Lang = None

    @property
    def Domain(self):
        r"""需要修改的域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Areas(self):
        r"""需要新增的封禁地域
        :rtype: list of Area
        """
        return self._Areas

    @Areas.setter
    def Areas(self, Areas):
        self._Areas = Areas

    @property
    def JobType(self):
        r"""规则执行的方式，TimedJob为定时执行，CronJob为周期执行
        :rtype: str
        """
        return self._JobType

    @JobType.setter
    def JobType(self, JobType):
        self._JobType = JobType

    @property
    def JobDateTime(self):
        r"""定时任务配置
        :rtype: :class:`tencentcloud.waf.v20180125.models.JobDateTime`
        """
        return self._JobDateTime

    @JobDateTime.setter
    def JobDateTime(self, JobDateTime):
        self._JobDateTime = JobDateTime

    @property
    def Lang(self):
        r"""地域信息的语言，支持cn、en，默认为中文cn
        :rtype: str
        """
        return self._Lang

    @Lang.setter
    def Lang(self, Lang):
        self._Lang = Lang


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        if params.get("Areas") is not None:
            self._Areas = []
            for item in params.get("Areas"):
                obj = Area()
                obj._deserialize(item)
                self._Areas.append(obj)
        self._JobType = params.get("JobType")
        if params.get("JobDateTime") is not None:
            self._JobDateTime = JobDateTime()
            self._JobDateTime._deserialize(params.get("JobDateTime"))
        self._Lang = params.get("Lang")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAreaBanRuleResponse(AbstractModel):
    r"""CreateAreaBanRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateBatchIpAccessControlRequest(AbstractModel):
    r"""CreateBatchIpAccessControl请求参数结构体

    """

    def __init__(self):
        r"""
        :param _IpList: IP参数列表
        :type IpList: list of str
        :param _JobType: 规则执行的方式，TimedJob为定时执行，CronJob为周期执行
        :type JobType: str
        :param _JobDateTime: 定时任务配置
        :type JobDateTime: :class:`tencentcloud.waf.v20180125.models.JobDateTime`
        :param _ActionType: 42为黑名单，40为白名单
        :type ActionType: int
        :param _GroupIds: 防护对象组ID列表，如果绑定的是防护对象组，和Domains参数二选一
        :type GroupIds: list of int non-negative
        :param _Domains: 域名列表，如果绑定的是批量域名，和GroupIds参数二选一
        :type Domains: list of str
        :param _Note: 备注
        :type Note: str
        """
        self._IpList = None
        self._JobType = None
        self._JobDateTime = None
        self._ActionType = None
        self._GroupIds = None
        self._Domains = None
        self._Note = None

    @property
    def IpList(self):
        r"""IP参数列表
        :rtype: list of str
        """
        return self._IpList

    @IpList.setter
    def IpList(self, IpList):
        self._IpList = IpList

    @property
    def JobType(self):
        r"""规则执行的方式，TimedJob为定时执行，CronJob为周期执行
        :rtype: str
        """
        return self._JobType

    @JobType.setter
    def JobType(self, JobType):
        self._JobType = JobType

    @property
    def JobDateTime(self):
        r"""定时任务配置
        :rtype: :class:`tencentcloud.waf.v20180125.models.JobDateTime`
        """
        return self._JobDateTime

    @JobDateTime.setter
    def JobDateTime(self, JobDateTime):
        self._JobDateTime = JobDateTime

    @property
    def ActionType(self):
        r"""42为黑名单，40为白名单
        :rtype: int
        """
        return self._ActionType

    @ActionType.setter
    def ActionType(self, ActionType):
        self._ActionType = ActionType

    @property
    def GroupIds(self):
        r"""防护对象组ID列表，如果绑定的是防护对象组，和Domains参数二选一
        :rtype: list of int non-negative
        """
        return self._GroupIds

    @GroupIds.setter
    def GroupIds(self, GroupIds):
        self._GroupIds = GroupIds

    @property
    def Domains(self):
        r"""域名列表，如果绑定的是批量域名，和GroupIds参数二选一
        :rtype: list of str
        """
        return self._Domains

    @Domains.setter
    def Domains(self, Domains):
        self._Domains = Domains

    @property
    def Note(self):
        r"""备注
        :rtype: str
        """
        return self._Note

    @Note.setter
    def Note(self, Note):
        self._Note = Note


    def _deserialize(self, params):
        self._IpList = params.get("IpList")
        self._JobType = params.get("JobType")
        if params.get("JobDateTime") is not None:
            self._JobDateTime = JobDateTime()
            self._JobDateTime._deserialize(params.get("JobDateTime"))
        self._ActionType = params.get("ActionType")
        self._GroupIds = params.get("GroupIds")
        self._Domains = params.get("Domains")
        self._Note = params.get("Note")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateBatchIpAccessControlResponse(AbstractModel):
    r"""CreateBatchIpAccessControl返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Failed: 添加失败的域名列表，如果非空则表示有域名添加失败，整个批量规则添加失败，否则则表示批量规则添加成功。
        :type Failed: list of BatchDomainResult
        :param _RuleId: 添加成功的批量规则ID
        :type RuleId: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Failed = None
        self._RuleId = None
        self._RequestId = None

    @property
    def Failed(self):
        r"""添加失败的域名列表，如果非空则表示有域名添加失败，整个批量规则添加失败，否则则表示批量规则添加成功。
        :rtype: list of BatchDomainResult
        """
        return self._Failed

    @Failed.setter
    def Failed(self, Failed):
        self._Failed = Failed

    @property
    def RuleId(self):
        r"""添加成功的批量规则ID
        :rtype: int
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Failed") is not None:
            self._Failed = []
            for item in params.get("Failed"):
                obj = BatchDomainResult()
                obj._deserialize(item)
                self._Failed.append(obj)
        self._RuleId = params.get("RuleId")
        self._RequestId = params.get("RequestId")


class CreateDealsGoods(AbstractModel):
    r"""计费下单接口出入参Goods

    """

    def __init__(self):
        r"""
        :param _GoodsNum: 商品数量
        :type GoodsNum: int
        :param _GoodsDetail: 商品明细
        :type GoodsDetail: :class:`tencentcloud.waf.v20180125.models.CreateDealsGoodsDetail`
        :param _GoodsCategoryId: 订单类型ID，用来唯一标识一个业务的一种场景（总共三种场景：新购、配置变更、续费）
高级版: 102375(新购),102376(续费),102377(变配)
企业版 : 102378(新购),102379(续费),102380(变配)
旗舰版 : 102369(新购),102370(续费),102371(变配)
域名包 : 102372(新购),102373(续费),102374(变配)
业务扩展包 : 101040(新购),101041(续费),101042(变配)

高级版-CLB: 新购 101198  续费 101199 变配 101200
企业版-CLB 101204(新购),101205(续费),101206(变配)
旗舰版-CLB : 101201(新购),101202(续费),101203(变配)
域名包-CLB: 101207(新购),101208(续费),101209(变配)
业务扩展包-CLB: 101210(新购),101211(续费),101212(变配)

        :type GoodsCategoryId: int
        :param _RegionId: 购买waf实例区域ID
1 表示购买大陆资源;
9表示购买非中国大陆资源
        :type RegionId: int
        """
        self._GoodsNum = None
        self._GoodsDetail = None
        self._GoodsCategoryId = None
        self._RegionId = None

    @property
    def GoodsNum(self):
        r"""商品数量
        :rtype: int
        """
        return self._GoodsNum

    @GoodsNum.setter
    def GoodsNum(self, GoodsNum):
        self._GoodsNum = GoodsNum

    @property
    def GoodsDetail(self):
        r"""商品明细
        :rtype: :class:`tencentcloud.waf.v20180125.models.CreateDealsGoodsDetail`
        """
        return self._GoodsDetail

    @GoodsDetail.setter
    def GoodsDetail(self, GoodsDetail):
        self._GoodsDetail = GoodsDetail

    @property
    def GoodsCategoryId(self):
        r"""订单类型ID，用来唯一标识一个业务的一种场景（总共三种场景：新购、配置变更、续费）
高级版: 102375(新购),102376(续费),102377(变配)
企业版 : 102378(新购),102379(续费),102380(变配)
旗舰版 : 102369(新购),102370(续费),102371(变配)
域名包 : 102372(新购),102373(续费),102374(变配)
业务扩展包 : 101040(新购),101041(续费),101042(变配)

高级版-CLB: 新购 101198  续费 101199 变配 101200
企业版-CLB 101204(新购),101205(续费),101206(变配)
旗舰版-CLB : 101201(新购),101202(续费),101203(变配)
域名包-CLB: 101207(新购),101208(续费),101209(变配)
业务扩展包-CLB: 101210(新购),101211(续费),101212(变配)

        :rtype: int
        """
        return self._GoodsCategoryId

    @GoodsCategoryId.setter
    def GoodsCategoryId(self, GoodsCategoryId):
        self._GoodsCategoryId = GoodsCategoryId

    @property
    def RegionId(self):
        r"""购买waf实例区域ID
1 表示购买大陆资源;
9表示购买非中国大陆资源
        :rtype: int
        """
        return self._RegionId

    @RegionId.setter
    def RegionId(self, RegionId):
        self._RegionId = RegionId


    def _deserialize(self, params):
        self._GoodsNum = params.get("GoodsNum")
        if params.get("GoodsDetail") is not None:
            self._GoodsDetail = CreateDealsGoodsDetail()
            self._GoodsDetail._deserialize(params.get("GoodsDetail"))
        self._GoodsCategoryId = params.get("GoodsCategoryId")
        self._RegionId = params.get("RegionId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateDealsGoodsDetail(AbstractModel):
    r"""产品明细

    """

    def __init__(self):
        r"""
        :param _TimeSpan: 时间间隔
        :type TimeSpan: int
        :param _TimeUnit: 单位，支持购买d、m、y 即（日、月、年）
        :type TimeUnit: str
        :param _SubProductCode: 子产品标签,。新购，续费必传，变配时放在oldConfig newConfig里面

Saas 高级版 ：sp_wsm_waf_premium
Saas企业版 ：sp_wsm_waf_enterprise
Saas旗舰版 ：sp_wsm_waf_ultimate
Saas 业务扩展包：sp_wsm_waf_qpsep
Saas 域名扩展包：sp_wsm_waf_domain

高级版-CLB:sp_wsm_waf_premium_clb
企业版-CLB : sp_wsm_waf_enterprise_clb
旗舰版-CLB:sp_wsm_waf_ultimate_clb
 业务扩展包-CLB：sp_wsm_waf_qpsep_clb
域名扩展包-CLB：sp_wsm_waf_domain_clb

        :type SubProductCode: str
        :param _Pid: 业务产品申请的pid（对应一个定价公式），通过pid计费查询到定价模型
高级版 ：1000827
企业版 ：1000830
旗舰版 ：1000832
域名包 : 1000834
业务扩展包 : 1000481
高级版-CLB:1001150
企业版-CLB : 1001152
旗舰版-CLB:1001154
域名包-CLB: 1001156
业务扩展包-CLB : 1001160

        :type Pid: int
        :param _InstanceName: waf实例名
        :type InstanceName: str
        :param _AutoRenewFlag: 1:自动续费，0:不自动续费
        :type AutoRenewFlag: int
        :param _RealRegion: waf购买的实际地域信息
        :type RealRegion: int
        :param _LabelTypes: 计费细项标签数组
Saas 高级版  sv_wsm_waf_package_premium 
Saas 企业版  sv_wsm_waf_package_enterprise
Saas 旗舰版  sv_wsm_waf_package_ultimate 
Saas 非中国大陆高级版  sv_wsm_waf_package_premium_intl
Saas 非中国大陆企业版   sv_wsm_waf_package_enterprise_intl
Saas 非中国大陆旗舰版  sv_wsm_waf_package_ultimate _intl
Saas 业务扩展包  sv_wsm_waf_qps_ep
Saas 域名扩展包  sv_wsm_waf_domain

高级版CLB   sv_wsm_waf_package_premium_clb
企业版CLB  sv_wsm_waf_package_enterprise_clb
旗舰版CLB   sv_wsm_waf_package_ultimate_clb
非中国大陆高级版 CLB sv_wsm_waf_package_premium_clb_intl
非中国大陆企业版CLB   sv_wsm_waf_package_premium_clb_intl
非中国大陆旗舰版CLB  sv_wsm_waf_package_ultimate_clb _intl
业务扩展包CLB sv_wsm_waf_qps_ep_clb
域名扩展包CLB  sv_wsm_waf_domain_clb

        :type LabelTypes: list of str
        :param _LabelCounts: 计费细项标签数量，一般和SvLabelType一一对应
        :type LabelCounts: list of int
        :param _CurDeadline: 变配使用，实例到期时间
        :type CurDeadline: str
        :param _InstanceId: 对存在的实例购买bot 或api 安全
        :type InstanceId: str
        :param _ResourceId: 资源id
        :type ResourceId: str
        """
        self._TimeSpan = None
        self._TimeUnit = None
        self._SubProductCode = None
        self._Pid = None
        self._InstanceName = None
        self._AutoRenewFlag = None
        self._RealRegion = None
        self._LabelTypes = None
        self._LabelCounts = None
        self._CurDeadline = None
        self._InstanceId = None
        self._ResourceId = None

    @property
    def TimeSpan(self):
        r"""时间间隔
        :rtype: int
        """
        return self._TimeSpan

    @TimeSpan.setter
    def TimeSpan(self, TimeSpan):
        self._TimeSpan = TimeSpan

    @property
    def TimeUnit(self):
        r"""单位，支持购买d、m、y 即（日、月、年）
        :rtype: str
        """
        return self._TimeUnit

    @TimeUnit.setter
    def TimeUnit(self, TimeUnit):
        self._TimeUnit = TimeUnit

    @property
    def SubProductCode(self):
        r"""子产品标签,。新购，续费必传，变配时放在oldConfig newConfig里面

Saas 高级版 ：sp_wsm_waf_premium
Saas企业版 ：sp_wsm_waf_enterprise
Saas旗舰版 ：sp_wsm_waf_ultimate
Saas 业务扩展包：sp_wsm_waf_qpsep
Saas 域名扩展包：sp_wsm_waf_domain

高级版-CLB:sp_wsm_waf_premium_clb
企业版-CLB : sp_wsm_waf_enterprise_clb
旗舰版-CLB:sp_wsm_waf_ultimate_clb
 业务扩展包-CLB：sp_wsm_waf_qpsep_clb
域名扩展包-CLB：sp_wsm_waf_domain_clb

        :rtype: str
        """
        return self._SubProductCode

    @SubProductCode.setter
    def SubProductCode(self, SubProductCode):
        self._SubProductCode = SubProductCode

    @property
    def Pid(self):
        r"""业务产品申请的pid（对应一个定价公式），通过pid计费查询到定价模型
高级版 ：1000827
企业版 ：1000830
旗舰版 ：1000832
域名包 : 1000834
业务扩展包 : 1000481
高级版-CLB:1001150
企业版-CLB : 1001152
旗舰版-CLB:1001154
域名包-CLB: 1001156
业务扩展包-CLB : 1001160

        :rtype: int
        """
        return self._Pid

    @Pid.setter
    def Pid(self, Pid):
        self._Pid = Pid

    @property
    def InstanceName(self):
        r"""waf实例名
        :rtype: str
        """
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def AutoRenewFlag(self):
        r"""1:自动续费，0:不自动续费
        :rtype: int
        """
        return self._AutoRenewFlag

    @AutoRenewFlag.setter
    def AutoRenewFlag(self, AutoRenewFlag):
        self._AutoRenewFlag = AutoRenewFlag

    @property
    def RealRegion(self):
        r"""waf购买的实际地域信息
        :rtype: int
        """
        return self._RealRegion

    @RealRegion.setter
    def RealRegion(self, RealRegion):
        self._RealRegion = RealRegion

    @property
    def LabelTypes(self):
        r"""计费细项标签数组
Saas 高级版  sv_wsm_waf_package_premium 
Saas 企业版  sv_wsm_waf_package_enterprise
Saas 旗舰版  sv_wsm_waf_package_ultimate 
Saas 非中国大陆高级版  sv_wsm_waf_package_premium_intl
Saas 非中国大陆企业版   sv_wsm_waf_package_enterprise_intl
Saas 非中国大陆旗舰版  sv_wsm_waf_package_ultimate _intl
Saas 业务扩展包  sv_wsm_waf_qps_ep
Saas 域名扩展包  sv_wsm_waf_domain

高级版CLB   sv_wsm_waf_package_premium_clb
企业版CLB  sv_wsm_waf_package_enterprise_clb
旗舰版CLB   sv_wsm_waf_package_ultimate_clb
非中国大陆高级版 CLB sv_wsm_waf_package_premium_clb_intl
非中国大陆企业版CLB   sv_wsm_waf_package_premium_clb_intl
非中国大陆旗舰版CLB  sv_wsm_waf_package_ultimate_clb _intl
业务扩展包CLB sv_wsm_waf_qps_ep_clb
域名扩展包CLB  sv_wsm_waf_domain_clb

        :rtype: list of str
        """
        return self._LabelTypes

    @LabelTypes.setter
    def LabelTypes(self, LabelTypes):
        self._LabelTypes = LabelTypes

    @property
    def LabelCounts(self):
        r"""计费细项标签数量，一般和SvLabelType一一对应
        :rtype: list of int
        """
        return self._LabelCounts

    @LabelCounts.setter
    def LabelCounts(self, LabelCounts):
        self._LabelCounts = LabelCounts

    @property
    def CurDeadline(self):
        r"""变配使用，实例到期时间
        :rtype: str
        """
        return self._CurDeadline

    @CurDeadline.setter
    def CurDeadline(self, CurDeadline):
        self._CurDeadline = CurDeadline

    @property
    def InstanceId(self):
        r"""对存在的实例购买bot 或api 安全
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def ResourceId(self):
        r"""资源id
        :rtype: str
        """
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId


    def _deserialize(self, params):
        self._TimeSpan = params.get("TimeSpan")
        self._TimeUnit = params.get("TimeUnit")
        self._SubProductCode = params.get("SubProductCode")
        self._Pid = params.get("Pid")
        self._InstanceName = params.get("InstanceName")
        self._AutoRenewFlag = params.get("AutoRenewFlag")
        self._RealRegion = params.get("RealRegion")
        self._LabelTypes = params.get("LabelTypes")
        self._LabelCounts = params.get("LabelCounts")
        self._CurDeadline = params.get("CurDeadline")
        self._InstanceId = params.get("InstanceId")
        self._ResourceId = params.get("ResourceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateDealsRequest(AbstractModel):
    r"""CreateDeals请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Goods: 计费下单入参
        :type Goods: list of CreateDealsGoods
        """
        self._Goods = None

    @property
    def Goods(self):
        r"""计费下单入参
        :rtype: list of CreateDealsGoods
        """
        return self._Goods

    @Goods.setter
    def Goods(self, Goods):
        self._Goods = Goods


    def _deserialize(self, params):
        if params.get("Goods") is not None:
            self._Goods = []
            for item in params.get("Goods"):
                obj = CreateDealsGoods()
                obj._deserialize(item)
                self._Goods.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateDealsResponse(AbstractModel):
    r"""CreateDeals返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 计费下单响应结构体
        :type Data: :class:`tencentcloud.waf.v20180125.models.DealData`
        :param _Status: 1:成功，0:失败
        :type Status: int
        :param _ReturnMessage: 返回message
        :type ReturnMessage: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._Status = None
        self._ReturnMessage = None
        self._RequestId = None

    @property
    def Data(self):
        r"""计费下单响应结构体
        :rtype: :class:`tencentcloud.waf.v20180125.models.DealData`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def Status(self):
        r"""1:成功，0:失败
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ReturnMessage(self):
        r"""返回message
        :rtype: str
        """
        return self._ReturnMessage

    @ReturnMessage.setter
    def ReturnMessage(self, ReturnMessage):
        self._ReturnMessage = ReturnMessage

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DealData()
            self._Data._deserialize(params.get("Data"))
        self._Status = params.get("Status")
        self._ReturnMessage = params.get("ReturnMessage")
        self._RequestId = params.get("RequestId")


class CreateExportRequest(AbstractModel):
    r"""CreateExport请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TopicId: 日志主题ID，可以通过DescribeTopics接口获取,访问日志主题ID和攻击日志主题ID方式不同，注意DescribeTopics接口使用方法
        :type TopicId: str
        :param _Count: 日志导出数量,  最大值5000万
        :type Count: int
        :param _Query: 日志导出检索语句，需要进行base64编码,不支持<a href="https://cloud.tencent.com/document/product/614/44061" target="_blank">[SQL语句]</a>
        :type Query: str
        :param _From: 日志导出起始时间，毫秒时间戳
        :type From: int
        :param _To: 日志导出结束时间，毫秒时间戳
        :type To: int
        :param _Order: 日志导出时间排序。desc，asc，默认为desc
        :type Order: str
        :param _Format: 日志导出数据格式。json，csv，默认为json
        :type Format: str
        :param _SyntaxRule: 语法规则,  默认值为0。
0：Lucene语法，1：CQL语法。
        :type SyntaxRule: int
        :param _DerivedFields: 导出字段
        :type DerivedFields: list of str
        """
        self._TopicId = None
        self._Count = None
        self._Query = None
        self._From = None
        self._To = None
        self._Order = None
        self._Format = None
        self._SyntaxRule = None
        self._DerivedFields = None

    @property
    def TopicId(self):
        r"""日志主题ID，可以通过DescribeTopics接口获取,访问日志主题ID和攻击日志主题ID方式不同，注意DescribeTopics接口使用方法
        :rtype: str
        """
        return self._TopicId

    @TopicId.setter
    def TopicId(self, TopicId):
        self._TopicId = TopicId

    @property
    def Count(self):
        r"""日志导出数量,  最大值5000万
        :rtype: int
        """
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def Query(self):
        r"""日志导出检索语句，需要进行base64编码,不支持<a href="https://cloud.tencent.com/document/product/614/44061" target="_blank">[SQL语句]</a>
        :rtype: str
        """
        return self._Query

    @Query.setter
    def Query(self, Query):
        self._Query = Query

    @property
    def From(self):
        r"""日志导出起始时间，毫秒时间戳
        :rtype: int
        """
        return self._From

    @From.setter
    def From(self, From):
        self._From = From

    @property
    def To(self):
        r"""日志导出结束时间，毫秒时间戳
        :rtype: int
        """
        return self._To

    @To.setter
    def To(self, To):
        self._To = To

    @property
    def Order(self):
        r"""日志导出时间排序。desc，asc，默认为desc
        :rtype: str
        """
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def Format(self):
        r"""日志导出数据格式。json，csv，默认为json
        :rtype: str
        """
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def SyntaxRule(self):
        r"""语法规则,  默认值为0。
0：Lucene语法，1：CQL语法。
        :rtype: int
        """
        return self._SyntaxRule

    @SyntaxRule.setter
    def SyntaxRule(self, SyntaxRule):
        self._SyntaxRule = SyntaxRule

    @property
    def DerivedFields(self):
        r"""导出字段
        :rtype: list of str
        """
        return self._DerivedFields

    @DerivedFields.setter
    def DerivedFields(self, DerivedFields):
        self._DerivedFields = DerivedFields


    def _deserialize(self, params):
        self._TopicId = params.get("TopicId")
        self._Count = params.get("Count")
        self._Query = params.get("Query")
        self._From = params.get("From")
        self._To = params.get("To")
        self._Order = params.get("Order")
        self._Format = params.get("Format")
        self._SyntaxRule = params.get("SyntaxRule")
        self._DerivedFields = params.get("DerivedFields")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateExportResponse(AbstractModel):
    r"""CreateExport返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ExportId: 日志导出ID。
        :type ExportId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ExportId = None
        self._RequestId = None

    @property
    def ExportId(self):
        r"""日志导出ID。
        :rtype: str
        """
        return self._ExportId

    @ExportId.setter
    def ExportId(self, ExportId):
        self._ExportId = ExportId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ExportId = params.get("ExportId")
        self._RequestId = params.get("RequestId")


class CreateHostRequest(AbstractModel):
    r"""CreateHost请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Host: 防护域名配置信息。内网负载均衡器必须携带对应的NumericalVpcId。
        :type Host: :class:`tencentcloud.waf.v20180125.models.HostRecord`
        :param _InstanceID: 实例id
        :type InstanceID: str
        """
        self._Host = None
        self._InstanceID = None

    @property
    def Host(self):
        r"""防护域名配置信息。内网负载均衡器必须携带对应的NumericalVpcId。
        :rtype: :class:`tencentcloud.waf.v20180125.models.HostRecord`
        """
        return self._Host

    @Host.setter
    def Host(self, Host):
        self._Host = Host

    @property
    def InstanceID(self):
        r"""实例id
        :rtype: str
        """
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID


    def _deserialize(self, params):
        if params.get("Host") is not None:
            self._Host = HostRecord()
            self._Host._deserialize(params.get("Host"))
        self._InstanceID = params.get("InstanceID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateHostResponse(AbstractModel):
    r"""CreateHost返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DomainId: 新增防护域名ID
        :type DomainId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DomainId = None
        self._RequestId = None

    @property
    def DomainId(self):
        r"""新增防护域名ID
        :rtype: str
        """
        return self._DomainId

    @DomainId.setter
    def DomainId(self, DomainId):
        self._DomainId = DomainId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DomainId = params.get("DomainId")
        self._RequestId = params.get("RequestId")


class CreateIpAccessControlRequest(AbstractModel):
    r"""CreateIpAccessControl请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 具体域名如：test.qcloudwaf.com
全局域名为：global
        :type Domain: str
        :param _IpList: ip参数列表
        :type IpList: list of str
        :param _ActionType: 42为黑名单，40为白名单
        :type ActionType: int
        :param _ValidTS: valid_ts为有效日期，值为秒级时间戳（（如1680570420代表2023-04-04 09:07:00））
        :type ValidTS: int
        :param _InstanceId: 实例Id
        :type InstanceId: str
        :param _Edition: WAF实例类型，sparta-waf表示SAAS型WAF，clb-waf表示负载均衡型WAF
        :type Edition: str
        :param _SourceType: 可选值为：batch（批量添加）、bot（BOT流量分析中的BOT详情列表中添加时）、cc（在攻击日志列表中对攻击类型为CC的IP添加时）、custom（非批量添加时的默认值）
        :type SourceType: str
        :param _Note: 备注
        :type Note: str
        :param _JobType: 规则执行的方式，TimedJob为定时执行，CronJob为周期执行
        :type JobType: str
        :param _JobDateTime: 定时配置详情
        :type JobDateTime: :class:`tencentcloud.waf.v20180125.models.JobDateTime`
        """
        self._Domain = None
        self._IpList = None
        self._ActionType = None
        self._ValidTS = None
        self._InstanceId = None
        self._Edition = None
        self._SourceType = None
        self._Note = None
        self._JobType = None
        self._JobDateTime = None

    @property
    def Domain(self):
        r"""具体域名如：test.qcloudwaf.com
全局域名为：global
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def IpList(self):
        r"""ip参数列表
        :rtype: list of str
        """
        return self._IpList

    @IpList.setter
    def IpList(self, IpList):
        self._IpList = IpList

    @property
    def ActionType(self):
        r"""42为黑名单，40为白名单
        :rtype: int
        """
        return self._ActionType

    @ActionType.setter
    def ActionType(self, ActionType):
        self._ActionType = ActionType

    @property
    def ValidTS(self):
        warnings.warn("parameter `ValidTS` is deprecated", DeprecationWarning) 

        r"""valid_ts为有效日期，值为秒级时间戳（（如1680570420代表2023-04-04 09:07:00））
        :rtype: int
        """
        return self._ValidTS

    @ValidTS.setter
    def ValidTS(self, ValidTS):
        warnings.warn("parameter `ValidTS` is deprecated", DeprecationWarning) 

        self._ValidTS = ValidTS

    @property
    def InstanceId(self):
        r"""实例Id
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Edition(self):
        r"""WAF实例类型，sparta-waf表示SAAS型WAF，clb-waf表示负载均衡型WAF
        :rtype: str
        """
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition

    @property
    def SourceType(self):
        r"""可选值为：batch（批量添加）、bot（BOT流量分析中的BOT详情列表中添加时）、cc（在攻击日志列表中对攻击类型为CC的IP添加时）、custom（非批量添加时的默认值）
        :rtype: str
        """
        return self._SourceType

    @SourceType.setter
    def SourceType(self, SourceType):
        self._SourceType = SourceType

    @property
    def Note(self):
        r"""备注
        :rtype: str
        """
        return self._Note

    @Note.setter
    def Note(self, Note):
        self._Note = Note

    @property
    def JobType(self):
        r"""规则执行的方式，TimedJob为定时执行，CronJob为周期执行
        :rtype: str
        """
        return self._JobType

    @JobType.setter
    def JobType(self, JobType):
        self._JobType = JobType

    @property
    def JobDateTime(self):
        r"""定时配置详情
        :rtype: :class:`tencentcloud.waf.v20180125.models.JobDateTime`
        """
        return self._JobDateTime

    @JobDateTime.setter
    def JobDateTime(self, JobDateTime):
        self._JobDateTime = JobDateTime


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._IpList = params.get("IpList")
        self._ActionType = params.get("ActionType")
        self._ValidTS = params.get("ValidTS")
        self._InstanceId = params.get("InstanceId")
        self._Edition = params.get("Edition")
        self._SourceType = params.get("SourceType")
        self._Note = params.get("Note")
        self._JobType = params.get("JobType")
        if params.get("JobDateTime") is not None:
            self._JobDateTime = JobDateTime()
            self._JobDateTime._deserialize(params.get("JobDateTime"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateIpAccessControlResponse(AbstractModel):
    r"""CreateIpAccessControl返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleId: 新增的规则对应的ID
        :type RuleId: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RuleId = None
        self._RequestId = None

    @property
    def RuleId(self):
        r"""新增的规则对应的ID
        :rtype: int
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RuleId = params.get("RuleId")
        self._RequestId = params.get("RequestId")


class CreateOwaspWhiteRuleRequest(AbstractModel):
    r"""CreateOwaspWhiteRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 规则名称
        :type Name: str
        :param _Domain: 域名
        :type Domain: str
        :param _Strategies: 规则匹配策略列表
        :type Strategies: list of Strategy
        :param _Ids: 加白的规则ID列表
        :type Ids: list of int non-negative
        :param _Type: 加白的类型，0:按照特定规则ID加白, 1:按照规则类型加白
        :type Type: int
        :param _JobType: 规则执行的方式，TimedJob为定时执行，CronJob为周期执行
        :type JobType: str
        :param _JobDateTime: 定时任务配置
        :type JobDateTime: :class:`tencentcloud.waf.v20180125.models.JobDateTime`
        :param _ExpireTime: 如果没有设置JobDateTime字段则用此字段，0表示永久生效，其它表示定时生效的截止时间（单位为秒）
        :type ExpireTime: int
        :param _Status: 规则状态，0：关闭、1：开启，默认为开启
        :type Status: int
        :param _LogicalOp: 匹配条件的逻辑关系，支持and、or，分别表示多个逻辑匹配条件是与、或的关系
        :type LogicalOp: str
        """
        self._Name = None
        self._Domain = None
        self._Strategies = None
        self._Ids = None
        self._Type = None
        self._JobType = None
        self._JobDateTime = None
        self._ExpireTime = None
        self._Status = None
        self._LogicalOp = None

    @property
    def Name(self):
        r"""规则名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Strategies(self):
        r"""规则匹配策略列表
        :rtype: list of Strategy
        """
        return self._Strategies

    @Strategies.setter
    def Strategies(self, Strategies):
        self._Strategies = Strategies

    @property
    def Ids(self):
        r"""加白的规则ID列表
        :rtype: list of int non-negative
        """
        return self._Ids

    @Ids.setter
    def Ids(self, Ids):
        self._Ids = Ids

    @property
    def Type(self):
        r"""加白的类型，0:按照特定规则ID加白, 1:按照规则类型加白
        :rtype: int
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def JobType(self):
        r"""规则执行的方式，TimedJob为定时执行，CronJob为周期执行
        :rtype: str
        """
        return self._JobType

    @JobType.setter
    def JobType(self, JobType):
        self._JobType = JobType

    @property
    def JobDateTime(self):
        r"""定时任务配置
        :rtype: :class:`tencentcloud.waf.v20180125.models.JobDateTime`
        """
        return self._JobDateTime

    @JobDateTime.setter
    def JobDateTime(self, JobDateTime):
        self._JobDateTime = JobDateTime

    @property
    def ExpireTime(self):
        r"""如果没有设置JobDateTime字段则用此字段，0表示永久生效，其它表示定时生效的截止时间（单位为秒）
        :rtype: int
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def Status(self):
        r"""规则状态，0：关闭、1：开启，默认为开启
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def LogicalOp(self):
        r"""匹配条件的逻辑关系，支持and、or，分别表示多个逻辑匹配条件是与、或的关系
        :rtype: str
        """
        return self._LogicalOp

    @LogicalOp.setter
    def LogicalOp(self, LogicalOp):
        self._LogicalOp = LogicalOp


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Domain = params.get("Domain")
        if params.get("Strategies") is not None:
            self._Strategies = []
            for item in params.get("Strategies"):
                obj = Strategy()
                obj._deserialize(item)
                self._Strategies.append(obj)
        self._Ids = params.get("Ids")
        self._Type = params.get("Type")
        self._JobType = params.get("JobType")
        if params.get("JobDateTime") is not None:
            self._JobDateTime = JobDateTime()
            self._JobDateTime._deserialize(params.get("JobDateTime"))
        self._ExpireTime = params.get("ExpireTime")
        self._Status = params.get("Status")
        self._LogicalOp = params.get("LogicalOp")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOwaspWhiteRuleResponse(AbstractModel):
    r"""CreateOwaspWhiteRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleId: 规则ID
        :type RuleId: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RuleId = None
        self._RequestId = None

    @property
    def RuleId(self):
        r"""规则ID
        :rtype: int
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RuleId = params.get("RuleId")
        self._RequestId = params.get("RequestId")


class CreatePostCKafkaFlowRequest(AbstractModel):
    r"""CreatePostCKafkaFlow请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CKafkaRegion: 投递的CKafka所在区域
        :type CKafkaRegion: str
        :param _CKafkaID: 客户的CKafka 实例ID
        :type CKafkaID: str
        :param _Brokers: 支撑环境是IP:PORT，外网环境是domain:PORT
        :type Brokers: str
        :param _Compression: 默认为none，支持snappy、gzip和lz4压缩，推荐snappy
        :type Compression: str
        :param _VipType: 1-外网TGW，2-支撑环境，默认为支撑环境
        :type VipType: int
        :param _LogType: 1-访问日志，2-攻击日志，默认为访问日志
        :type LogType: int
        :param _Topic: 主题名称，默认不传或者传空字符串，默认值为waf_post_access_log
        :type Topic: str
        :param _KafkaVersion: kafka集群的版本号
        :type KafkaVersion: str
        :param _SASLEnable: 是否开启SASL校验，默认不开启，0-关闭，1-开启
        :type SASLEnable: int
        :param _SASLUser: SASL用户名
        :type SASLUser: str
        :param _SASLPassword: SASL密码
        :type SASLPassword: str
        :param _WriteConfig: 开启访问日志某些字段是否投递
        :type WriteConfig: :class:`tencentcloud.waf.v20180125.models.FieldWriteConfig`
        """
        self._CKafkaRegion = None
        self._CKafkaID = None
        self._Brokers = None
        self._Compression = None
        self._VipType = None
        self._LogType = None
        self._Topic = None
        self._KafkaVersion = None
        self._SASLEnable = None
        self._SASLUser = None
        self._SASLPassword = None
        self._WriteConfig = None

    @property
    def CKafkaRegion(self):
        r"""投递的CKafka所在区域
        :rtype: str
        """
        return self._CKafkaRegion

    @CKafkaRegion.setter
    def CKafkaRegion(self, CKafkaRegion):
        self._CKafkaRegion = CKafkaRegion

    @property
    def CKafkaID(self):
        r"""客户的CKafka 实例ID
        :rtype: str
        """
        return self._CKafkaID

    @CKafkaID.setter
    def CKafkaID(self, CKafkaID):
        self._CKafkaID = CKafkaID

    @property
    def Brokers(self):
        r"""支撑环境是IP:PORT，外网环境是domain:PORT
        :rtype: str
        """
        return self._Brokers

    @Brokers.setter
    def Brokers(self, Brokers):
        self._Brokers = Brokers

    @property
    def Compression(self):
        r"""默认为none，支持snappy、gzip和lz4压缩，推荐snappy
        :rtype: str
        """
        return self._Compression

    @Compression.setter
    def Compression(self, Compression):
        self._Compression = Compression

    @property
    def VipType(self):
        r"""1-外网TGW，2-支撑环境，默认为支撑环境
        :rtype: int
        """
        return self._VipType

    @VipType.setter
    def VipType(self, VipType):
        self._VipType = VipType

    @property
    def LogType(self):
        r"""1-访问日志，2-攻击日志，默认为访问日志
        :rtype: int
        """
        return self._LogType

    @LogType.setter
    def LogType(self, LogType):
        self._LogType = LogType

    @property
    def Topic(self):
        r"""主题名称，默认不传或者传空字符串，默认值为waf_post_access_log
        :rtype: str
        """
        return self._Topic

    @Topic.setter
    def Topic(self, Topic):
        self._Topic = Topic

    @property
    def KafkaVersion(self):
        r"""kafka集群的版本号
        :rtype: str
        """
        return self._KafkaVersion

    @KafkaVersion.setter
    def KafkaVersion(self, KafkaVersion):
        self._KafkaVersion = KafkaVersion

    @property
    def SASLEnable(self):
        r"""是否开启SASL校验，默认不开启，0-关闭，1-开启
        :rtype: int
        """
        return self._SASLEnable

    @SASLEnable.setter
    def SASLEnable(self, SASLEnable):
        self._SASLEnable = SASLEnable

    @property
    def SASLUser(self):
        r"""SASL用户名
        :rtype: str
        """
        return self._SASLUser

    @SASLUser.setter
    def SASLUser(self, SASLUser):
        self._SASLUser = SASLUser

    @property
    def SASLPassword(self):
        r"""SASL密码
        :rtype: str
        """
        return self._SASLPassword

    @SASLPassword.setter
    def SASLPassword(self, SASLPassword):
        self._SASLPassword = SASLPassword

    @property
    def WriteConfig(self):
        r"""开启访问日志某些字段是否投递
        :rtype: :class:`tencentcloud.waf.v20180125.models.FieldWriteConfig`
        """
        return self._WriteConfig

    @WriteConfig.setter
    def WriteConfig(self, WriteConfig):
        self._WriteConfig = WriteConfig


    def _deserialize(self, params):
        self._CKafkaRegion = params.get("CKafkaRegion")
        self._CKafkaID = params.get("CKafkaID")
        self._Brokers = params.get("Brokers")
        self._Compression = params.get("Compression")
        self._VipType = params.get("VipType")
        self._LogType = params.get("LogType")
        self._Topic = params.get("Topic")
        self._KafkaVersion = params.get("KafkaVersion")
        self._SASLEnable = params.get("SASLEnable")
        self._SASLUser = params.get("SASLUser")
        self._SASLPassword = params.get("SASLPassword")
        if params.get("WriteConfig") is not None:
            self._WriteConfig = FieldWriteConfig()
            self._WriteConfig._deserialize(params.get("WriteConfig"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreatePostCKafkaFlowResponse(AbstractModel):
    r"""CreatePostCKafkaFlow返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreatePostCLSFlowRequest(AbstractModel):
    r"""CreatePostCLSFlow请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CLSRegion: 投递的CLS所在区域，默认为ap-shanghai
        :type CLSRegion: str
        :param _LogsetName: 投递的CLS所在日志集合名称，默认为 waf_post_logset
        :type LogsetName: str
        :param _LogType: 1-访问日志，2-攻击日志，默认为访问日志。
        :type LogType: int
        :param _LogTopicName: 投递的CLS所在日志主题的名称，默认为 waf_post_logtopic
        :type LogTopicName: str
        """
        self._CLSRegion = None
        self._LogsetName = None
        self._LogType = None
        self._LogTopicName = None

    @property
    def CLSRegion(self):
        r"""投递的CLS所在区域，默认为ap-shanghai
        :rtype: str
        """
        return self._CLSRegion

    @CLSRegion.setter
    def CLSRegion(self, CLSRegion):
        self._CLSRegion = CLSRegion

    @property
    def LogsetName(self):
        r"""投递的CLS所在日志集合名称，默认为 waf_post_logset
        :rtype: str
        """
        return self._LogsetName

    @LogsetName.setter
    def LogsetName(self, LogsetName):
        self._LogsetName = LogsetName

    @property
    def LogType(self):
        r"""1-访问日志，2-攻击日志，默认为访问日志。
        :rtype: int
        """
        return self._LogType

    @LogType.setter
    def LogType(self, LogType):
        self._LogType = LogType

    @property
    def LogTopicName(self):
        r"""投递的CLS所在日志主题的名称，默认为 waf_post_logtopic
        :rtype: str
        """
        return self._LogTopicName

    @LogTopicName.setter
    def LogTopicName(self, LogTopicName):
        self._LogTopicName = LogTopicName


    def _deserialize(self, params):
        self._CLSRegion = params.get("CLSRegion")
        self._LogsetName = params.get("LogsetName")
        self._LogType = params.get("LogType")
        self._LogTopicName = params.get("LogTopicName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreatePostCLSFlowResponse(AbstractModel):
    r"""CreatePostCLSFlow返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CronJob(AbstractModel):
    r"""规则周期执行的数据结构

    """

    def __init__(self):
        r"""
        :param _Days: 每个月的几号执行
        :type Days: list of int non-negative
        :param _WDays: 每个星期的星期几执行
        :type WDays: list of int non-negative
        :param _StartTime: 开始时间
        :type StartTime: str
        :param _EndTime: 结束时间
        :type EndTime: str
        """
        self._Days = None
        self._WDays = None
        self._StartTime = None
        self._EndTime = None

    @property
    def Days(self):
        r"""每个月的几号执行
        :rtype: list of int non-negative
        """
        return self._Days

    @Days.setter
    def Days(self, Days):
        self._Days = Days

    @property
    def WDays(self):
        r"""每个星期的星期几执行
        :rtype: list of int non-negative
        """
        return self._WDays

    @WDays.setter
    def WDays(self, WDays):
        self._WDays = WDays

    @property
    def StartTime(self):
        r"""开始时间
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""结束时间
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._Days = params.get("Days")
        self._WDays = params.get("WDays")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DealData(AbstractModel):
    r"""计费下单响应实体

    """

    def __init__(self):
        r"""
        :param _DealNames: 订单号列表，元素个数与请求包的goods数组的元素个数一致，商品详情与订单按顺序对应
        :type DealNames: list of str
        :param _BigDealId: 大订单号，一个大订单号下可以有多个子订单，说明是同一次下单[{},{}]
        :type BigDealId: str
        """
        self._DealNames = None
        self._BigDealId = None

    @property
    def DealNames(self):
        r"""订单号列表，元素个数与请求包的goods数组的元素个数一致，商品详情与订单按顺序对应
        :rtype: list of str
        """
        return self._DealNames

    @DealNames.setter
    def DealNames(self, DealNames):
        self._DealNames = DealNames

    @property
    def BigDealId(self):
        r"""大订单号，一个大订单号下可以有多个子订单，说明是同一次下单[{},{}]
        :rtype: str
        """
        return self._BigDealId

    @BigDealId.setter
    def BigDealId(self, BigDealId):
        self._BigDealId = BigDealId


    def _deserialize(self, params):
        self._DealNames = params.get("DealNames")
        self._BigDealId = params.get("BigDealId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAccessExportRequest(AbstractModel):
    r"""DeleteAccessExport请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ExportId: 日志导出ID
        :type ExportId: str
        :param _TopicId: 日志主题
        :type TopicId: str
        """
        self._ExportId = None
        self._TopicId = None

    @property
    def ExportId(self):
        r"""日志导出ID
        :rtype: str
        """
        return self._ExportId

    @ExportId.setter
    def ExportId(self, ExportId):
        self._ExportId = ExportId

    @property
    def TopicId(self):
        r"""日志主题
        :rtype: str
        """
        return self._TopicId

    @TopicId.setter
    def TopicId(self, TopicId):
        self._TopicId = TopicId


    def _deserialize(self, params):
        self._ExportId = params.get("ExportId")
        self._TopicId = params.get("TopicId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAccessExportResponse(AbstractModel):
    r"""DeleteAccessExport返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteAntiFakeUrlRequest(AbstractModel):
    r"""DeleteAntiFakeUrl请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _Id: Id
        :type Id: int
        """
        self._Domain = None
        self._Id = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Id(self):
        r"""Id
        :rtype: int
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAntiFakeUrlResponse(AbstractModel):
    r"""DeleteAntiFakeUrl返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteAntiInfoLeakRuleRequest(AbstractModel):
    r"""DeleteAntiInfoLeakRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _RuleId: 规则id
        :type RuleId: int
        """
        self._Domain = None
        self._RuleId = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def RuleId(self):
        r"""规则id
        :rtype: int
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._RuleId = params.get("RuleId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAntiInfoLeakRuleResponse(AbstractModel):
    r"""DeleteAntiInfoLeakRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteAttackDownloadRecordRequest(AbstractModel):
    r"""DeleteAttackDownloadRecord请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: 下载任务记录唯一标记
        :type Id: int
        """
        self._Id = None

    @property
    def Id(self):
        r"""下载任务记录唯一标记
        :rtype: int
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAttackDownloadRecordResponse(AbstractModel):
    r"""DeleteAttackDownloadRecord返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteAttackWhiteRuleRequest(AbstractModel):
    r"""DeleteAttackWhiteRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Ids: 规则序号组
        :type Ids: list of int non-negative
        :param _Domain: 用户域名
        :type Domain: str
        """
        self._Ids = None
        self._Domain = None

    @property
    def Ids(self):
        r"""规则序号组
        :rtype: list of int non-negative
        """
        return self._Ids

    @Ids.setter
    def Ids(self, Ids):
        self._Ids = Ids

    @property
    def Domain(self):
        r"""用户域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain


    def _deserialize(self, params):
        self._Ids = params.get("Ids")
        self._Domain = params.get("Domain")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAttackWhiteRuleResponse(AbstractModel):
    r"""DeleteAttackWhiteRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _FailIds: 删除失败的规则序号组
        :type FailIds: list of int non-negative
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._FailIds = None
        self._RequestId = None

    @property
    def FailIds(self):
        r"""删除失败的规则序号组
        :rtype: list of int non-negative
        """
        return self._FailIds

    @FailIds.setter
    def FailIds(self, FailIds):
        self._FailIds = FailIds

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FailIds = params.get("FailIds")
        self._RequestId = params.get("RequestId")


class DeleteBatchIpAccessControlRequest(AbstractModel):
    r"""DeleteBatchIpAccessControl请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Ids: 规则ID列表，支持批量删除
        :type Ids: list of int non-negative
        """
        self._Ids = None

    @property
    def Ids(self):
        r"""规则ID列表，支持批量删除
        :rtype: list of int non-negative
        """
        return self._Ids

    @Ids.setter
    def Ids(self, Ids):
        self._Ids = Ids


    def _deserialize(self, params):
        self._Ids = params.get("Ids")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteBatchIpAccessControlResponse(AbstractModel):
    r"""DeleteBatchIpAccessControl返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteBotSceneUCBRuleRequest(AbstractModel):
    r"""DeleteBotSceneUCBRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _RuleId: 自定义规则ID
        :type RuleId: str
        :param _SceneId: 1.BOT全局白名单处调用时，传"global";2.BOT场景配置时，传具体的场景ID
        :type SceneId: str
        """
        self._Domain = None
        self._RuleId = None
        self._SceneId = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def RuleId(self):
        r"""自定义规则ID
        :rtype: str
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def SceneId(self):
        r"""1.BOT全局白名单处调用时，传"global";2.BOT场景配置时，传具体的场景ID
        :rtype: str
        """
        return self._SceneId

    @SceneId.setter
    def SceneId(self, SceneId):
        self._SceneId = SceneId


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._RuleId = params.get("RuleId")
        self._SceneId = params.get("SceneId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteBotSceneUCBRuleResponse(AbstractModel):
    r"""DeleteBotSceneUCBRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 正常情况下为null
        :type Data: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        r"""正常情况下为null
        :rtype: str
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DeleteCCRuleRequest(AbstractModel):
    r"""DeleteCCRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _Name: 规则名称
        :type Name: str
        :param _Edition: clb-waf或者sparta-waf
        :type Edition: str
        :param _RuleId: 规则Id
        :type RuleId: int
        """
        self._Domain = None
        self._Name = None
        self._Edition = None
        self._RuleId = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Name(self):
        r"""规则名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Edition(self):
        r"""clb-waf或者sparta-waf
        :rtype: str
        """
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition

    @property
    def RuleId(self):
        r"""规则Id
        :rtype: int
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Name = params.get("Name")
        self._Edition = params.get("Edition")
        self._RuleId = params.get("RuleId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteCCRuleResponse(AbstractModel):
    r"""DeleteCCRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 一般为null
        :type Data: str
        :param _RuleId: 操作的规则Id
        :type RuleId: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RuleId = None
        self._RequestId = None

    @property
    def Data(self):
        r"""一般为null
        :rtype: str
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RuleId(self):
        r"""操作的规则Id
        :rtype: int
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RuleId = params.get("RuleId")
        self._RequestId = params.get("RequestId")


class DeleteCustomRuleRequest(AbstractModel):
    r"""DeleteCustomRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 删除的域名
        :type Domain: str
        :param _RuleId: 删除的规则ID
        :type RuleId: str
        :param _Edition: WAF的版本，clb-waf代表负载均衡WAF、sparta-waf代表SaaS WAF，默认是sparta-waf。
        :type Edition: str
        :param _DomainRuleIdList: 批量删除的规则列表
        :type DomainRuleIdList: list of DomainRuleId
        """
        self._Domain = None
        self._RuleId = None
        self._Edition = None
        self._DomainRuleIdList = None

    @property
    def Domain(self):
        r"""删除的域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def RuleId(self):
        r"""删除的规则ID
        :rtype: str
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def Edition(self):
        r"""WAF的版本，clb-waf代表负载均衡WAF、sparta-waf代表SaaS WAF，默认是sparta-waf。
        :rtype: str
        """
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition

    @property
    def DomainRuleIdList(self):
        r"""批量删除的规则列表
        :rtype: list of DomainRuleId
        """
        return self._DomainRuleIdList

    @DomainRuleIdList.setter
    def DomainRuleIdList(self, DomainRuleIdList):
        self._DomainRuleIdList = DomainRuleIdList


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._RuleId = params.get("RuleId")
        self._Edition = params.get("Edition")
        if params.get("DomainRuleIdList") is not None:
            self._DomainRuleIdList = []
            for item in params.get("DomainRuleIdList"):
                obj = DomainRuleId()
                obj._deserialize(item)
                self._DomainRuleIdList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteCustomRuleResponse(AbstractModel):
    r"""DeleteCustomRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Success: 操作的状态码，如果所有的资源操作成功则返回的是成功的状态码，如果有资源操作失败则需要解析Message的内容来查看哪个资源失败
        :type Success: :class:`tencentcloud.waf.v20180125.models.ResponseCode`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Success = None
        self._RequestId = None

    @property
    def Success(self):
        r"""操作的状态码，如果所有的资源操作成功则返回的是成功的状态码，如果有资源操作失败则需要解析Message的内容来查看哪个资源失败
        :rtype: :class:`tencentcloud.waf.v20180125.models.ResponseCode`
        """
        return self._Success

    @Success.setter
    def Success(self, Success):
        self._Success = Success

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Success") is not None:
            self._Success = ResponseCode()
            self._Success._deserialize(params.get("Success"))
        self._RequestId = params.get("RequestId")


class DeleteCustomWhiteRuleRequest(AbstractModel):
    r"""DeleteCustomWhiteRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 删除的域名
        :type Domain: str
        :param _RuleId: 删除的规则ID
        :type RuleId: int
        """
        self._Domain = None
        self._RuleId = None

    @property
    def Domain(self):
        r"""删除的域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def RuleId(self):
        r"""删除的规则ID
        :rtype: int
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._RuleId = params.get("RuleId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteCustomWhiteRuleResponse(AbstractModel):
    r"""DeleteCustomWhiteRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Success: 操作的状态码，如果所有的资源操作成功则返回的是成功的状态码，如果有资源操作失败则需要解析Message的内容来查看哪个资源失败
        :type Success: :class:`tencentcloud.waf.v20180125.models.ResponseCode`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Success = None
        self._RequestId = None

    @property
    def Success(self):
        r"""操作的状态码，如果所有的资源操作成功则返回的是成功的状态码，如果有资源操作失败则需要解析Message的内容来查看哪个资源失败
        :rtype: :class:`tencentcloud.waf.v20180125.models.ResponseCode`
        """
        return self._Success

    @Success.setter
    def Success(self, Success):
        self._Success = Success

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Success") is not None:
            self._Success = ResponseCode()
            self._Success._deserialize(params.get("Success"))
        self._RequestId = params.get("RequestId")


class DeleteDomainWhiteRulesRequest(AbstractModel):
    r"""DeleteDomainWhiteRules请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 需要删除的规则域名
        :type Domain: str
        :param _Ids: 需要删除的白名单规则
        :type Ids: list of int non-negative
        """
        self._Domain = None
        self._Ids = None

    @property
    def Domain(self):
        r"""需要删除的规则域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Ids(self):
        r"""需要删除的白名单规则
        :rtype: list of int non-negative
        """
        return self._Ids

    @Ids.setter
    def Ids(self, Ids):
        self._Ids = Ids


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Ids = params.get("Ids")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteDomainWhiteRulesResponse(AbstractModel):
    r"""DeleteDomainWhiteRules返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 出参
        :type Data: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        r"""出参
        :rtype: str
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DeleteExportRequest(AbstractModel):
    r"""DeleteExport请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ExportId: 日志导出ID
        :type ExportId: str
        """
        self._ExportId = None

    @property
    def ExportId(self):
        r"""日志导出ID
        :rtype: str
        """
        return self._ExportId

    @ExportId.setter
    def ExportId(self, ExportId):
        self._ExportId = ExportId


    def _deserialize(self, params):
        self._ExportId = params.get("ExportId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteExportResponse(AbstractModel):
    r"""DeleteExport返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteHostRequest(AbstractModel):
    r"""DeleteHost请求参数结构体

    """

    def __init__(self):
        r"""
        :param _HostsDel: 删除的域名列表
        :type HostsDel: list of HostDel
        """
        self._HostsDel = None

    @property
    def HostsDel(self):
        r"""删除的域名列表
        :rtype: list of HostDel
        """
        return self._HostsDel

    @HostsDel.setter
    def HostsDel(self, HostsDel):
        self._HostsDel = HostsDel


    def _deserialize(self, params):
        if params.get("HostsDel") is not None:
            self._HostsDel = []
            for item in params.get("HostsDel"):
                obj = HostDel()
                obj._deserialize(item)
                self._HostsDel.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteHostResponse(AbstractModel):
    r"""DeleteHost返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Success: 域名删除结果。Code表示状态码，Message表示详细信息。
        :type Success: :class:`tencentcloud.waf.v20180125.models.ResponseCode`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Success = None
        self._RequestId = None

    @property
    def Success(self):
        r"""域名删除结果。Code表示状态码，Message表示详细信息。
        :rtype: :class:`tencentcloud.waf.v20180125.models.ResponseCode`
        """
        return self._Success

    @Success.setter
    def Success(self, Success):
        self._Success = Success

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Success") is not None:
            self._Success = ResponseCode()
            self._Success._deserialize(params.get("Success"))
        self._RequestId = params.get("RequestId")


class DeleteIpAccessControlRequest(AbstractModel):
    r"""DeleteIpAccessControl请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _Items: 删除的ip数组
        :type Items: list of str
        :param _IsId: 若IsId字段为True，则Items列表元素需为Id，否则为IP
        :type IsId: bool
        :param _DeleteAll: 是否删除对应的域名下的所有黑/白IP名单，true表示全部删除，false表示只删除指定ip名单
        :type DeleteAll: bool
        :param _SourceType: 是否为多域名黑白名单
        :type SourceType: str
        :param _ActionType: IP黑白名单类型，40为IP白名单，42为IP黑名单
        :type ActionType: int
        """
        self._Domain = None
        self._Items = None
        self._IsId = None
        self._DeleteAll = None
        self._SourceType = None
        self._ActionType = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Items(self):
        r"""删除的ip数组
        :rtype: list of str
        """
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def IsId(self):
        r"""若IsId字段为True，则Items列表元素需为Id，否则为IP
        :rtype: bool
        """
        return self._IsId

    @IsId.setter
    def IsId(self, IsId):
        self._IsId = IsId

    @property
    def DeleteAll(self):
        r"""是否删除对应的域名下的所有黑/白IP名单，true表示全部删除，false表示只删除指定ip名单
        :rtype: bool
        """
        return self._DeleteAll

    @DeleteAll.setter
    def DeleteAll(self, DeleteAll):
        self._DeleteAll = DeleteAll

    @property
    def SourceType(self):
        r"""是否为多域名黑白名单
        :rtype: str
        """
        return self._SourceType

    @SourceType.setter
    def SourceType(self, SourceType):
        self._SourceType = SourceType

    @property
    def ActionType(self):
        r"""IP黑白名单类型，40为IP白名单，42为IP黑名单
        :rtype: int
        """
        return self._ActionType

    @ActionType.setter
    def ActionType(self, ActionType):
        self._ActionType = ActionType


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Items = params.get("Items")
        self._IsId = params.get("IsId")
        self._DeleteAll = params.get("DeleteAll")
        self._SourceType = params.get("SourceType")
        self._ActionType = params.get("ActionType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteIpAccessControlResponse(AbstractModel):
    r"""DeleteIpAccessControl返回参数结构体

    """

    def __init__(self):
        r"""
        :param _FailedItems: 删除失败的条目
        :type FailedItems: str
        :param _FailedCount: 删除失败的条目数
        :type FailedCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._FailedItems = None
        self._FailedCount = None
        self._RequestId = None

    @property
    def FailedItems(self):
        r"""删除失败的条目
        :rtype: str
        """
        return self._FailedItems

    @FailedItems.setter
    def FailedItems(self, FailedItems):
        self._FailedItems = FailedItems

    @property
    def FailedCount(self):
        r"""删除失败的条目数
        :rtype: int
        """
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FailedItems = params.get("FailedItems")
        self._FailedCount = params.get("FailedCount")
        self._RequestId = params.get("RequestId")


class DeleteIpAccessControlV2Request(AbstractModel):
    r"""DeleteIpAccessControlV2请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _RuleIds: 规则ID列表，支持批量删除，在DeleteAll参数为true的时候可以不传
        :type RuleIds: list of int non-negative
        :param _DeleteAll: 是否删除对应的域名下的所有黑/白IP名单，true表示全部删除，false表示只删除指定IP名单，批量防护不支持
        :type DeleteAll: bool
        :param _SourceType: batch表示为批量防护的IP黑白名单
        :type SourceType: str
        :param _ActionType: IP黑白名单类型，40为IP白名单，42为IP黑名单，在DeleteAll为true的时候必传此参数
        :type ActionType: int
        """
        self._Domain = None
        self._RuleIds = None
        self._DeleteAll = None
        self._SourceType = None
        self._ActionType = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def RuleIds(self):
        r"""规则ID列表，支持批量删除，在DeleteAll参数为true的时候可以不传
        :rtype: list of int non-negative
        """
        return self._RuleIds

    @RuleIds.setter
    def RuleIds(self, RuleIds):
        self._RuleIds = RuleIds

    @property
    def DeleteAll(self):
        r"""是否删除对应的域名下的所有黑/白IP名单，true表示全部删除，false表示只删除指定IP名单，批量防护不支持
        :rtype: bool
        """
        return self._DeleteAll

    @DeleteAll.setter
    def DeleteAll(self, DeleteAll):
        self._DeleteAll = DeleteAll

    @property
    def SourceType(self):
        r"""batch表示为批量防护的IP黑白名单
        :rtype: str
        """
        return self._SourceType

    @SourceType.setter
    def SourceType(self, SourceType):
        self._SourceType = SourceType

    @property
    def ActionType(self):
        r"""IP黑白名单类型，40为IP白名单，42为IP黑名单，在DeleteAll为true的时候必传此参数
        :rtype: int
        """
        return self._ActionType

    @ActionType.setter
    def ActionType(self, ActionType):
        self._ActionType = ActionType


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._RuleIds = params.get("RuleIds")
        self._DeleteAll = params.get("DeleteAll")
        self._SourceType = params.get("SourceType")
        self._ActionType = params.get("ActionType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteIpAccessControlV2Response(AbstractModel):
    r"""DeleteIpAccessControlV2返回参数结构体

    """

    def __init__(self):
        r"""
        :param _FailedCount: 在批量删除的时候表示删除失败的条数
        :type FailedCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._FailedCount = None
        self._RequestId = None

    @property
    def FailedCount(self):
        r"""在批量删除的时候表示删除失败的条数
        :rtype: int
        """
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FailedCount = params.get("FailedCount")
        self._RequestId = params.get("RequestId")


class DeleteOwaspRuleStatusRequest(AbstractModel):
    r"""DeleteOwaspRuleStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _RuleIDs: 规则ID列表
        :type RuleIDs: list of str
        """
        self._Domain = None
        self._RuleIDs = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def RuleIDs(self):
        r"""规则ID列表
        :rtype: list of str
        """
        return self._RuleIDs

    @RuleIDs.setter
    def RuleIDs(self, RuleIDs):
        self._RuleIDs = RuleIDs


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._RuleIDs = params.get("RuleIDs")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteOwaspRuleStatusResponse(AbstractModel):
    r"""DeleteOwaspRuleStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteOwaspWhiteRuleRequest(AbstractModel):
    r"""DeleteOwaspWhiteRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Ids: 规则白名单ID列表
        :type Ids: list of int non-negative
        :param _Domain: 域名
        :type Domain: str
        """
        self._Ids = None
        self._Domain = None

    @property
    def Ids(self):
        r"""规则白名单ID列表
        :rtype: list of int non-negative
        """
        return self._Ids

    @Ids.setter
    def Ids(self, Ids):
        self._Ids = Ids

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain


    def _deserialize(self, params):
        self._Ids = params.get("Ids")
        self._Domain = params.get("Domain")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteOwaspWhiteRuleResponse(AbstractModel):
    r"""DeleteOwaspWhiteRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteSessionRequest(AbstractModel):
    r"""DeleteSession请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _Edition: clb-waf 或者 sprta-waf
        :type Edition: str
        :param _SessionID: 要删除的SessionID
        :type SessionID: int
        """
        self._Domain = None
        self._Edition = None
        self._SessionID = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Edition(self):
        r"""clb-waf 或者 sprta-waf
        :rtype: str
        """
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition

    @property
    def SessionID(self):
        r"""要删除的SessionID
        :rtype: int
        """
        return self._SessionID

    @SessionID.setter
    def SessionID(self, SessionID):
        self._SessionID = SessionID


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Edition = params.get("Edition")
        self._SessionID = params.get("SessionID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteSessionResponse(AbstractModel):
    r"""DeleteSession返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 结果
        :type Data: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        r"""结果
        :rtype: str
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DeleteSpartaProtectionRequest(AbstractModel):
    r"""DeleteSpartaProtection请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domains: 域名列表
        :type Domains: list of str
        :param _InstanceID: 必填项。域名所属实例ID
        :type InstanceID: str
        :param _Edition: 实例类型
        :type Edition: str
        """
        self._Domains = None
        self._InstanceID = None
        self._Edition = None

    @property
    def Domains(self):
        r"""域名列表
        :rtype: list of str
        """
        return self._Domains

    @Domains.setter
    def Domains(self, Domains):
        self._Domains = Domains

    @property
    def InstanceID(self):
        r"""必填项。域名所属实例ID
        :rtype: str
        """
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID

    @property
    def Edition(self):
        r"""实例类型
        :rtype: str
        """
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition


    def _deserialize(self, params):
        self._Domains = params.get("Domains")
        self._InstanceID = params.get("InstanceID")
        self._Edition = params.get("Edition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteSpartaProtectionResponse(AbstractModel):
    r"""DeleteSpartaProtection返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DescribeAccessExportsRequest(AbstractModel):
    r"""DescribeAccessExports请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TopicId: 客户要查询的日志主题ID，每个客户都有对应的一个主题
        :type TopicId: str
        :param _Offset: 分页的偏移量，默认值为0
        :type Offset: int
        :param _Limit: 分页单页限制数目，默认值为20，最大值100
        :type Limit: int
        """
        self._TopicId = None
        self._Offset = None
        self._Limit = None

    @property
    def TopicId(self):
        r"""客户要查询的日志主题ID，每个客户都有对应的一个主题
        :rtype: str
        """
        return self._TopicId

    @TopicId.setter
    def TopicId(self, TopicId):
        self._TopicId = TopicId

    @property
    def Offset(self):
        r"""分页的偏移量，默认值为0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""分页单页限制数目，默认值为20，最大值100
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._TopicId = params.get("TopicId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAccessExportsResponse(AbstractModel):
    r"""DescribeAccessExports返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 日志导出ID。
        :type TotalCount: int
        :param _Exports: 日志导出列表
        :type Exports: list of ExportAccessInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._Exports = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""日志导出ID。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Exports(self):
        r"""日志导出列表
        :rtype: list of ExportAccessInfo
        """
        return self._Exports

    @Exports.setter
    def Exports(self, Exports):
        self._Exports = Exports

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Exports") is not None:
            self._Exports = []
            for item in params.get("Exports"):
                obj = ExportAccessInfo()
                obj._deserialize(item)
                self._Exports.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAccessFastAnalysisRequest(AbstractModel):
    r"""DescribeAccessFastAnalysis请求参数结构体

    """

    def __init__(self):
        r"""
        :param _From: 要查询的日志的起始时间，Unix时间戳，单位ms
        :type From: int
        :param _To: 要查询的日志的结束时间，Unix时间戳，单位ms
        :type To: int
        :param _Query: 查询语句，语句长度最大为4096，由于本接口是分析接口，如果无过滤条件，必须传 * 表示匹配所有，参考CLS的分析统计语句的文档
        :type Query: str
        :param _FieldName: 需要分析统计的字段名
        :type FieldName: str
        :param _TopicId: 客户要查询的日志主题ID，每个客户都有对应的一个主题
        :type TopicId: str
        :param _Sort: 排序字段,升序asc,降序desc，默认降序desc 
        :type Sort: str
        :param _Count: 返回的top数，默认返回top5
        :type Count: int
        """
        self._From = None
        self._To = None
        self._Query = None
        self._FieldName = None
        self._TopicId = None
        self._Sort = None
        self._Count = None

    @property
    def From(self):
        r"""要查询的日志的起始时间，Unix时间戳，单位ms
        :rtype: int
        """
        return self._From

    @From.setter
    def From(self, From):
        self._From = From

    @property
    def To(self):
        r"""要查询的日志的结束时间，Unix时间戳，单位ms
        :rtype: int
        """
        return self._To

    @To.setter
    def To(self, To):
        self._To = To

    @property
    def Query(self):
        r"""查询语句，语句长度最大为4096，由于本接口是分析接口，如果无过滤条件，必须传 * 表示匹配所有，参考CLS的分析统计语句的文档
        :rtype: str
        """
        return self._Query

    @Query.setter
    def Query(self, Query):
        self._Query = Query

    @property
    def FieldName(self):
        r"""需要分析统计的字段名
        :rtype: str
        """
        return self._FieldName

    @FieldName.setter
    def FieldName(self, FieldName):
        self._FieldName = FieldName

    @property
    def TopicId(self):
        warnings.warn("parameter `TopicId` is deprecated", DeprecationWarning) 

        r"""客户要查询的日志主题ID，每个客户都有对应的一个主题
        :rtype: str
        """
        return self._TopicId

    @TopicId.setter
    def TopicId(self, TopicId):
        warnings.warn("parameter `TopicId` is deprecated", DeprecationWarning) 

        self._TopicId = TopicId

    @property
    def Sort(self):
        r"""排序字段,升序asc,降序desc，默认降序desc 
        :rtype: str
        """
        return self._Sort

    @Sort.setter
    def Sort(self, Sort):
        self._Sort = Sort

    @property
    def Count(self):
        r"""返回的top数，默认返回top5
        :rtype: int
        """
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count


    def _deserialize(self, params):
        self._From = params.get("From")
        self._To = params.get("To")
        self._Query = params.get("Query")
        self._FieldName = params.get("FieldName")
        self._TopicId = params.get("TopicId")
        self._Sort = params.get("Sort")
        self._Count = params.get("Count")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAccessFastAnalysisResponse(AbstractModel):
    r"""DescribeAccessFastAnalysis返回参数结构体

    """

    def __init__(self):
        r"""
        :param _FieldValueRatioInfos: 注意：此字段可能返回 null，表示取不到有效值
        :type FieldValueRatioInfos: list of AccessFieldValueRatioInfo
        :param _TotalCount: 日志条数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._FieldValueRatioInfos = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def FieldValueRatioInfos(self):
        r"""注意：此字段可能返回 null，表示取不到有效值
        :rtype: list of AccessFieldValueRatioInfo
        """
        return self._FieldValueRatioInfos

    @FieldValueRatioInfos.setter
    def FieldValueRatioInfos(self, FieldValueRatioInfos):
        self._FieldValueRatioInfos = FieldValueRatioInfos

    @property
    def TotalCount(self):
        r"""日志条数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("FieldValueRatioInfos") is not None:
            self._FieldValueRatioInfos = []
            for item in params.get("FieldValueRatioInfos"):
                obj = AccessFieldValueRatioInfo()
                obj._deserialize(item)
                self._FieldValueRatioInfos.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeAccessHistogramRequest(AbstractModel):
    r"""DescribeAccessHistogram请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TopicId: 老版本查询的日志主题ID，新版本传空字符串即可
        :type TopicId: str
        :param _From: 要查询的日志的起始时间，Unix时间戳，单位ms
        :type From: int
        :param _To: 要查询的日志的结束时间，Unix时间戳，单位ms
        :type To: int
        :param _Query: 查询语句，语句长度最大为4096
        :type Query: str
        :param _Interval: 柱状图间隔时间差，单位ms
        :type Interval: int
        """
        self._TopicId = None
        self._From = None
        self._To = None
        self._Query = None
        self._Interval = None

    @property
    def TopicId(self):
        r"""老版本查询的日志主题ID，新版本传空字符串即可
        :rtype: str
        """
        return self._TopicId

    @TopicId.setter
    def TopicId(self, TopicId):
        self._TopicId = TopicId

    @property
    def From(self):
        r"""要查询的日志的起始时间，Unix时间戳，单位ms
        :rtype: int
        """
        return self._From

    @From.setter
    def From(self, From):
        self._From = From

    @property
    def To(self):
        r"""要查询的日志的结束时间，Unix时间戳，单位ms
        :rtype: int
        """
        return self._To

    @To.setter
    def To(self, To):
        self._To = To

    @property
    def Query(self):
        r"""查询语句，语句长度最大为4096
        :rtype: str
        """
        return self._Query

    @Query.setter
    def Query(self, Query):
        self._Query = Query

    @property
    def Interval(self):
        r"""柱状图间隔时间差，单位ms
        :rtype: int
        """
        return self._Interval

    @Interval.setter
    def Interval(self, Interval):
        self._Interval = Interval


    def _deserialize(self, params):
        self._TopicId = params.get("TopicId")
        self._From = params.get("From")
        self._To = params.get("To")
        self._Query = params.get("Query")
        self._Interval = params.get("Interval")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAccessHistogramResponse(AbstractModel):
    r"""DescribeAccessHistogram返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Interval: 柱状图间隔时间差，单位ms
        :type Interval: int
        :param _TotalCount: 满足条件的日志条数
        :type TotalCount: int
        :param _HistogramInfos: 注意：此字段可能返回 null，表示取不到有效值
        :type HistogramInfos: list of AccessHistogramItem
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Interval = None
        self._TotalCount = None
        self._HistogramInfos = None
        self._RequestId = None

    @property
    def Interval(self):
        r"""柱状图间隔时间差，单位ms
        :rtype: int
        """
        return self._Interval

    @Interval.setter
    def Interval(self, Interval):
        self._Interval = Interval

    @property
    def TotalCount(self):
        r"""满足条件的日志条数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def HistogramInfos(self):
        r"""注意：此字段可能返回 null，表示取不到有效值
        :rtype: list of AccessHistogramItem
        """
        return self._HistogramInfos

    @HistogramInfos.setter
    def HistogramInfos(self, HistogramInfos):
        self._HistogramInfos = HistogramInfos

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Interval = params.get("Interval")
        self._TotalCount = params.get("TotalCount")
        if params.get("HistogramInfos") is not None:
            self._HistogramInfos = []
            for item in params.get("HistogramInfos"):
                obj = AccessHistogramItem()
                obj._deserialize(item)
                self._HistogramInfos.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAccessIndexRequest(AbstractModel):
    r"""DescribeAccessIndex请求参数结构体

    """


class DescribeAccessIndexResponse(AbstractModel):
    r"""DescribeAccessIndex返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Status: 是否生效，true表示生效，false表示未生效
        :type Status: bool
        :param _Rule: 索引配置信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Rule: :class:`tencentcloud.waf.v20180125.models.AccessRuleInfo`
        :param _ModifyTime: 索引修改时间，初始值为索引创建时间。
        :type ModifyTime: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Status = None
        self._Rule = None
        self._ModifyTime = None
        self._RequestId = None

    @property
    def Status(self):
        r"""是否生效，true表示生效，false表示未生效
        :rtype: bool
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Rule(self):
        r"""索引配置信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.waf.v20180125.models.AccessRuleInfo`
        """
        return self._Rule

    @Rule.setter
    def Rule(self, Rule):
        self._Rule = Rule

    @property
    def ModifyTime(self):
        r"""索引修改时间，初始值为索引创建时间。
        :rtype: str
        """
        return self._ModifyTime

    @ModifyTime.setter
    def ModifyTime(self, ModifyTime):
        self._ModifyTime = ModifyTime

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Status = params.get("Status")
        if params.get("Rule") is not None:
            self._Rule = AccessRuleInfo()
            self._Rule._deserialize(params.get("Rule"))
        self._ModifyTime = params.get("ModifyTime")
        self._RequestId = params.get("RequestId")


class DescribeAntiFakeRulesRequest(AbstractModel):
    r"""DescribeAntiFakeRules请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _Offset: 偏移
        :type Offset: int
        :param _Limit: 容量
        :type Limit: int
        :param _Filters: 过滤数组,name可以是如下的值： RuleID,ParamName,Url,Action,Method,Source,Status
        :type Filters: list of FiltersItemNew
        :param _Order: asc或者desc
        :type Order: str
        :param _By: 目前支持根据create_time、modify_time、id排序
        :type By: str
        """
        self._Domain = None
        self._Offset = None
        self._Limit = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Offset(self):
        r"""偏移
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""容量
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        r"""过滤数组,name可以是如下的值： RuleID,ParamName,Url,Action,Method,Source,Status
        :rtype: list of FiltersItemNew
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        r"""asc或者desc
        :rtype: str
        """
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        r"""目前支持根据create_time、modify_time、id排序
        :rtype: str
        """
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = FiltersItemNew()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAntiFakeRulesResponse(AbstractModel):
    r"""DescribeAntiFakeRules返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Total: 总数
        :type Total: int
        :param _Data: 返回值
        :type Data: list of CacheUrlItems
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Total = None
        self._Data = None
        self._RequestId = None

    @property
    def Total(self):
        r"""总数
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def Data(self):
        r"""返回值
        :rtype: list of CacheUrlItems
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = CacheUrlItems()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAntiInfoLeakRulesStrategyItem(AbstractModel):
    r"""DescribeAntiInfoLeakRules返回的规则元素中的具体的规则元素

    """

    def __init__(self):
        r"""
        :param _Field: 字段
        :type Field: str
        :param _CompareFunc: 条件
        :type CompareFunc: str
        :param _Content: 内容
        :type Content: str
        """
        self._Field = None
        self._CompareFunc = None
        self._Content = None

    @property
    def Field(self):
        r"""字段
        :rtype: str
        """
        return self._Field

    @Field.setter
    def Field(self, Field):
        self._Field = Field

    @property
    def CompareFunc(self):
        r"""条件
        :rtype: str
        """
        return self._CompareFunc

    @CompareFunc.setter
    def CompareFunc(self, CompareFunc):
        self._CompareFunc = CompareFunc

    @property
    def Content(self):
        r"""内容
        :rtype: str
        """
        return self._Content

    @Content.setter
    def Content(self, Content):
        self._Content = Content


    def _deserialize(self, params):
        self._Field = params.get("Field")
        self._CompareFunc = params.get("CompareFunc")
        self._Content = params.get("Content")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAntiInfoLeakageRulesRequest(AbstractModel):
    r"""DescribeAntiInfoLeakageRules请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _Offset: 翻页支持，读取偏移
        :type Offset: int
        :param _Limit: 翻页支持，读取长度限制
        :type Limit: int
        :param _Order: 排序方式，asc或者desc
        :type Order: str
        :param _Filters: 过滤器,可以允许如下的值：
RuleId,Match_field,Name,Action,Status
        :type Filters: list of FiltersItemNew
        """
        self._Domain = None
        self._Offset = None
        self._Limit = None
        self._Order = None
        self._Filters = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Offset(self):
        r"""翻页支持，读取偏移
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""翻页支持，读取长度限制
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Order(self):
        r"""排序方式，asc或者desc
        :rtype: str
        """
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def Filters(self):
        r"""过滤器,可以允许如下的值：
RuleId,Match_field,Name,Action,Status
        :rtype: list of FiltersItemNew
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Order = params.get("Order")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = FiltersItemNew()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAntiInfoLeakageRulesResponse(AbstractModel):
    r"""DescribeAntiInfoLeakageRules返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Total: 记录条数
        :type Total: int
        :param _RuleList: 规则列表
        :type RuleList: list of DescribeAntiLeakageItem
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Total = None
        self._RuleList = None
        self._RequestId = None

    @property
    def Total(self):
        r"""记录条数
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RuleList(self):
        r"""规则列表
        :rtype: list of DescribeAntiLeakageItem
        """
        return self._RuleList

    @RuleList.setter
    def RuleList(self, RuleList):
        self._RuleList = RuleList

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("RuleList") is not None:
            self._RuleList = []
            for item in params.get("RuleList"):
                obj = DescribeAntiLeakageItem()
                obj._deserialize(item)
                self._RuleList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAntiLeakageItem(AbstractModel):
    r"""出参

    """

    def __init__(self):
        r"""
        :param _RuleId: 规则ID
        :type RuleId: int
        :param _Name: 名称
        :type Name: str
        :param _Status: 状态值
        :type Status: int
        :param _Action: 动作
        :type Action: str
        :param _CreateTime: 创建时间
        :type CreateTime: str
        :param _Strategies: 匹配条件
        :type Strategies: list of DescribeAntiInfoLeakRulesStrategyItem
        :param _Uri: 匹配的URL
        :type Uri: str
        :param _ModifyTime: 修改时间
        :type ModifyTime: str
        """
        self._RuleId = None
        self._Name = None
        self._Status = None
        self._Action = None
        self._CreateTime = None
        self._Strategies = None
        self._Uri = None
        self._ModifyTime = None

    @property
    def RuleId(self):
        r"""规则ID
        :rtype: int
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def Name(self):
        r"""名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Status(self):
        r"""状态值
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Action(self):
        r"""动作
        :rtype: str
        """
        return self._Action

    @Action.setter
    def Action(self, Action):
        self._Action = Action

    @property
    def CreateTime(self):
        r"""创建时间
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def Strategies(self):
        r"""匹配条件
        :rtype: list of DescribeAntiInfoLeakRulesStrategyItem
        """
        return self._Strategies

    @Strategies.setter
    def Strategies(self, Strategies):
        self._Strategies = Strategies

    @property
    def Uri(self):
        r"""匹配的URL
        :rtype: str
        """
        return self._Uri

    @Uri.setter
    def Uri(self, Uri):
        self._Uri = Uri

    @property
    def ModifyTime(self):
        r"""修改时间
        :rtype: str
        """
        return self._ModifyTime

    @ModifyTime.setter
    def ModifyTime(self, ModifyTime):
        self._ModifyTime = ModifyTime


    def _deserialize(self, params):
        self._RuleId = params.get("RuleId")
        self._Name = params.get("Name")
        self._Status = params.get("Status")
        self._Action = params.get("Action")
        self._CreateTime = params.get("CreateTime")
        if params.get("Strategies") is not None:
            self._Strategies = []
            for item in params.get("Strategies"):
                obj = DescribeAntiInfoLeakRulesStrategyItem()
                obj._deserialize(item)
                self._Strategies.append(obj)
        self._Uri = params.get("Uri")
        self._ModifyTime = params.get("ModifyTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeApiDetailRequest(AbstractModel):
    r"""DescribeApiDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _ApiName: Api名称
        :type ApiName: str
        :param _Method: 请求方法
        :type Method: str
        :param _IsSensitive: 是否仅查询敏感的，1表示查询，0表示不查询
        :type IsSensitive: int
        :param _IsPan: 是否仅查询泛化的，1表示查询，0表示不查询
        :type IsPan: int
        """
        self._Domain = None
        self._ApiName = None
        self._Method = None
        self._IsSensitive = None
        self._IsPan = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def ApiName(self):
        r"""Api名称
        :rtype: str
        """
        return self._ApiName

    @ApiName.setter
    def ApiName(self, ApiName):
        self._ApiName = ApiName

    @property
    def Method(self):
        r"""请求方法
        :rtype: str
        """
        return self._Method

    @Method.setter
    def Method(self, Method):
        self._Method = Method

    @property
    def IsSensitive(self):
        r"""是否仅查询敏感的，1表示查询，0表示不查询
        :rtype: int
        """
        return self._IsSensitive

    @IsSensitive.setter
    def IsSensitive(self, IsSensitive):
        self._IsSensitive = IsSensitive

    @property
    def IsPan(self):
        r"""是否仅查询泛化的，1表示查询，0表示不查询
        :rtype: int
        """
        return self._IsPan

    @IsPan.setter
    def IsPan(self, IsPan):
        self._IsPan = IsPan


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._ApiName = params.get("ApiName")
        self._Method = params.get("Method")
        self._IsSensitive = params.get("IsSensitive")
        self._IsPan = params.get("IsPan")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeApiDetailResponse(AbstractModel):
    r"""DescribeApiDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Log: 请求样例，json字符串格式
        :type Log: str
        :param _ParameterList: 请求参数样例列表
        :type ParameterList: list of ApiParameterType
        :param _Scene: 当前场景标签
        :type Scene: str
        :param _SensitiveFields: 敏感字段
        :type SensitiveFields: list of str
        :param _IsActive: 7天内是否活跃
        :type IsActive: bool
        :param _IpCount: 访问ip数
        :type IpCount: int
        :param _RegionCount: 访问地域数量
        :type RegionCount: int
        :param _EventCount: 关联事件数
        :type EventCount: int
        :param _SensitiveCount: 涉敏数据条数
        :type SensitiveCount: int
        :param _Level: 风险等级
        :type Level: int
        :param _RspLog: 响应体
        :type RspLog: str
        :param _MaxQPS: 昨日访问峰值QPS
        :type MaxQPS: int
        :param _ApiDetailSampleHistory: 历史样例
        :type ApiDetailSampleHistory: list of ApiDetailSampleHistory
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Log = None
        self._ParameterList = None
        self._Scene = None
        self._SensitiveFields = None
        self._IsActive = None
        self._IpCount = None
        self._RegionCount = None
        self._EventCount = None
        self._SensitiveCount = None
        self._Level = None
        self._RspLog = None
        self._MaxQPS = None
        self._ApiDetailSampleHistory = None
        self._RequestId = None

    @property
    def Log(self):
        r"""请求样例，json字符串格式
        :rtype: str
        """
        return self._Log

    @Log.setter
    def Log(self, Log):
        self._Log = Log

    @property
    def ParameterList(self):
        r"""请求参数样例列表
        :rtype: list of ApiParameterType
        """
        return self._ParameterList

    @ParameterList.setter
    def ParameterList(self, ParameterList):
        self._ParameterList = ParameterList

    @property
    def Scene(self):
        r"""当前场景标签
        :rtype: str
        """
        return self._Scene

    @Scene.setter
    def Scene(self, Scene):
        self._Scene = Scene

    @property
    def SensitiveFields(self):
        r"""敏感字段
        :rtype: list of str
        """
        return self._SensitiveFields

    @SensitiveFields.setter
    def SensitiveFields(self, SensitiveFields):
        self._SensitiveFields = SensitiveFields

    @property
    def IsActive(self):
        r"""7天内是否活跃
        :rtype: bool
        """
        return self._IsActive

    @IsActive.setter
    def IsActive(self, IsActive):
        self._IsActive = IsActive

    @property
    def IpCount(self):
        r"""访问ip数
        :rtype: int
        """
        return self._IpCount

    @IpCount.setter
    def IpCount(self, IpCount):
        self._IpCount = IpCount

    @property
    def RegionCount(self):
        r"""访问地域数量
        :rtype: int
        """
        return self._RegionCount

    @RegionCount.setter
    def RegionCount(self, RegionCount):
        self._RegionCount = RegionCount

    @property
    def EventCount(self):
        r"""关联事件数
        :rtype: int
        """
        return self._EventCount

    @EventCount.setter
    def EventCount(self, EventCount):
        self._EventCount = EventCount

    @property
    def SensitiveCount(self):
        r"""涉敏数据条数
        :rtype: int
        """
        return self._SensitiveCount

    @SensitiveCount.setter
    def SensitiveCount(self, SensitiveCount):
        self._SensitiveCount = SensitiveCount

    @property
    def Level(self):
        r"""风险等级
        :rtype: int
        """
        return self._Level

    @Level.setter
    def Level(self, Level):
        self._Level = Level

    @property
    def RspLog(self):
        r"""响应体
        :rtype: str
        """
        return self._RspLog

    @RspLog.setter
    def RspLog(self, RspLog):
        self._RspLog = RspLog

    @property
    def MaxQPS(self):
        r"""昨日访问峰值QPS
        :rtype: int
        """
        return self._MaxQPS

    @MaxQPS.setter
    def MaxQPS(self, MaxQPS):
        self._MaxQPS = MaxQPS

    @property
    def ApiDetailSampleHistory(self):
        r"""历史样例
        :rtype: list of ApiDetailSampleHistory
        """
        return self._ApiDetailSampleHistory

    @ApiDetailSampleHistory.setter
    def ApiDetailSampleHistory(self, ApiDetailSampleHistory):
        self._ApiDetailSampleHistory = ApiDetailSampleHistory

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Log = params.get("Log")
        if params.get("ParameterList") is not None:
            self._ParameterList = []
            for item in params.get("ParameterList"):
                obj = ApiParameterType()
                obj._deserialize(item)
                self._ParameterList.append(obj)
        self._Scene = params.get("Scene")
        self._SensitiveFields = params.get("SensitiveFields")
        self._IsActive = params.get("IsActive")
        self._IpCount = params.get("IpCount")
        self._RegionCount = params.get("RegionCount")
        self._EventCount = params.get("EventCount")
        self._SensitiveCount = params.get("SensitiveCount")
        self._Level = params.get("Level")
        self._RspLog = params.get("RspLog")
        self._MaxQPS = params.get("MaxQPS")
        if params.get("ApiDetailSampleHistory") is not None:
            self._ApiDetailSampleHistory = []
            for item in params.get("ApiDetailSampleHistory"):
                obj = ApiDetailSampleHistory()
                obj._deserialize(item)
                self._ApiDetailSampleHistory.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeApiListVersionTwoRequest(AbstractModel):
    r"""DescribeApiListVersionTwo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _PageIndex: 页面索引，第几页
        :type PageIndex: int
        :param _PageSize: 页面大小
        :type PageSize: int
        :param _Filters: 过滤条件
        :type Filters: list of ApiDataFilter
        :param _Sort: 排序方法，1 升序，-1 降序
        :type Sort: list of str
        :param _NeedTotalCount: 是否进行总数查询
        :type NeedTotalCount: bool
        :param _StartTs: 查询开始时间
        :type StartTs: int
        :param _EndTs: 查询结束时间
        :type EndTs: int
        """
        self._Domain = None
        self._PageIndex = None
        self._PageSize = None
        self._Filters = None
        self._Sort = None
        self._NeedTotalCount = None
        self._StartTs = None
        self._EndTs = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def PageIndex(self):
        r"""页面索引，第几页
        :rtype: int
        """
        return self._PageIndex

    @PageIndex.setter
    def PageIndex(self, PageIndex):
        self._PageIndex = PageIndex

    @property
    def PageSize(self):
        r"""页面大小
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Filters(self):
        r"""过滤条件
        :rtype: list of ApiDataFilter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Sort(self):
        r"""排序方法，1 升序，-1 降序
        :rtype: list of str
        """
        return self._Sort

    @Sort.setter
    def Sort(self, Sort):
        self._Sort = Sort

    @property
    def NeedTotalCount(self):
        r"""是否进行总数查询
        :rtype: bool
        """
        return self._NeedTotalCount

    @NeedTotalCount.setter
    def NeedTotalCount(self, NeedTotalCount):
        self._NeedTotalCount = NeedTotalCount

    @property
    def StartTs(self):
        r"""查询开始时间
        :rtype: int
        """
        return self._StartTs

    @StartTs.setter
    def StartTs(self, StartTs):
        self._StartTs = StartTs

    @property
    def EndTs(self):
        r"""查询结束时间
        :rtype: int
        """
        return self._EndTs

    @EndTs.setter
    def EndTs(self, EndTs):
        self._EndTs = EndTs


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._PageIndex = params.get("PageIndex")
        self._PageSize = params.get("PageSize")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = ApiDataFilter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Sort = params.get("Sort")
        self._NeedTotalCount = params.get("NeedTotalCount")
        self._StartTs = params.get("StartTs")
        self._EndTs = params.get("EndTs")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeApiListVersionTwoResponse(AbstractModel):
    r"""DescribeApiListVersionTwo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: api资产列表
        :type Data: list of ApiAsset
        :param _Total: 总数
        :type Total: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._Total = None
        self._RequestId = None

    @property
    def Data(self):
        r"""api资产列表
        :rtype: list of ApiAsset
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def Total(self):
        r"""总数
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = ApiAsset()
                obj._deserialize(item)
                self._Data.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeAreaBanAreasRequest(AbstractModel):
    r"""DescribeAreaBanAreas请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 需要查询的域名
        :type Domain: str
        """
        self._Domain = None

    @property
    def Domain(self):
        r"""需要查询的域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAreaBanAreasResponse(AbstractModel):
    r"""DescribeAreaBanAreas返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 回包内容
        :type Data: :class:`tencentcloud.waf.v20180125.models.DescribeAreaBanAreasRsp`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        r"""回包内容
        :rtype: :class:`tencentcloud.waf.v20180125.models.DescribeAreaBanAreasRsp`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeAreaBanAreasRsp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeAreaBanAreasRsp(AbstractModel):
    r"""DescribeAreaBanAreas接口的回包

    """

    def __init__(self):
        r"""
        :param _Status: 状态 "0"：未开启地域封禁 "1"：开启地域封禁
        :type Status: str
        :param _Source: 数据来源 custom-自定义(默认)、batch-批量防护
        :type Source: str
        :param _Areas: 字符串数据，配置的地域列表
        :type Areas: list of str
        :param _JobType: 定时任务类型
        :type JobType: str
        :param _JobDateTime: 定时任务详细配置
        :type JobDateTime: :class:`tencentcloud.waf.v20180125.models.JobDateTime`
        :param _CronType: 周期任务配置
        :type CronType: str
        """
        self._Status = None
        self._Source = None
        self._Areas = None
        self._JobType = None
        self._JobDateTime = None
        self._CronType = None

    @property
    def Status(self):
        r"""状态 "0"：未开启地域封禁 "1"：开启地域封禁
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Source(self):
        r"""数据来源 custom-自定义(默认)、batch-批量防护
        :rtype: str
        """
        return self._Source

    @Source.setter
    def Source(self, Source):
        self._Source = Source

    @property
    def Areas(self):
        r"""字符串数据，配置的地域列表
        :rtype: list of str
        """
        return self._Areas

    @Areas.setter
    def Areas(self, Areas):
        self._Areas = Areas

    @property
    def JobType(self):
        r"""定时任务类型
        :rtype: str
        """
        return self._JobType

    @JobType.setter
    def JobType(self, JobType):
        self._JobType = JobType

    @property
    def JobDateTime(self):
        r"""定时任务详细配置
        :rtype: :class:`tencentcloud.waf.v20180125.models.JobDateTime`
        """
        return self._JobDateTime

    @JobDateTime.setter
    def JobDateTime(self, JobDateTime):
        self._JobDateTime = JobDateTime

    @property
    def CronType(self):
        r"""周期任务配置
        :rtype: str
        """
        return self._CronType

    @CronType.setter
    def CronType(self, CronType):
        self._CronType = CronType


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._Source = params.get("Source")
        self._Areas = params.get("Areas")
        self._JobType = params.get("JobType")
        if params.get("JobDateTime") is not None:
            self._JobDateTime = JobDateTime()
            self._JobDateTime._deserialize(params.get("JobDateTime"))
        self._CronType = params.get("CronType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAreaBanRuleRequest(AbstractModel):
    r"""DescribeAreaBanRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 需要查询的域名
        :type Domain: str
        """
        self._Domain = None

    @property
    def Domain(self):
        r"""需要查询的域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAreaBanRuleResponse(AbstractModel):
    r"""DescribeAreaBanRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 规则内容
        :type Data: :class:`tencentcloud.waf.v20180125.models.AreaBanRule`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        r"""规则内容
        :rtype: :class:`tencentcloud.waf.v20180125.models.AreaBanRule`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = AreaBanRule()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeAreaBanSupportAreasRequest(AbstractModel):
    r"""DescribeAreaBanSupportAreas请求参数结构体

    """


class DescribeAreaBanSupportAreasResponse(AbstractModel):
    r"""DescribeAreaBanSupportAreas返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 地域封禁的地域列表，要解析成json后使用
        :type Data: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        r"""地域封禁的地域列表，要解析成json后使用
        :rtype: str
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DescribeAttackOverviewRequest(AbstractModel):
    r"""DescribeAttackOverview请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FromTime: 查询开始时间
        :type FromTime: str
        :param _ToTime: 查询结束时间
        :type ToTime: str
        :param _Appid: 客户的Appid
        :type Appid: int
        :param _Domain: 被查询的域名
        :type Domain: str
        :param _Edition: 只有两个值有效，sparta-waf，clb-waf，不传则不过滤
        :type Edition: str
        :param _InstanceID: WAF实例ID，不传则不过滤
        :type InstanceID: str
        """
        self._FromTime = None
        self._ToTime = None
        self._Appid = None
        self._Domain = None
        self._Edition = None
        self._InstanceID = None

    @property
    def FromTime(self):
        r"""查询开始时间
        :rtype: str
        """
        return self._FromTime

    @FromTime.setter
    def FromTime(self, FromTime):
        self._FromTime = FromTime

    @property
    def ToTime(self):
        r"""查询结束时间
        :rtype: str
        """
        return self._ToTime

    @ToTime.setter
    def ToTime(self, ToTime):
        self._ToTime = ToTime

    @property
    def Appid(self):
        r"""客户的Appid
        :rtype: int
        """
        return self._Appid

    @Appid.setter
    def Appid(self, Appid):
        self._Appid = Appid

    @property
    def Domain(self):
        r"""被查询的域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Edition(self):
        r"""只有两个值有效，sparta-waf，clb-waf，不传则不过滤
        :rtype: str
        """
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition

    @property
    def InstanceID(self):
        r"""WAF实例ID，不传则不过滤
        :rtype: str
        """
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID


    def _deserialize(self, params):
        self._FromTime = params.get("FromTime")
        self._ToTime = params.get("ToTime")
        self._Appid = params.get("Appid")
        self._Domain = params.get("Domain")
        self._Edition = params.get("Edition")
        self._InstanceID = params.get("InstanceID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAttackOverviewResponse(AbstractModel):
    r"""DescribeAttackOverview返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AccessCount: 访问请求总数
        :type AccessCount: int
        :param _AttackCount: Web攻击总数
        :type AttackCount: int
        :param _ACLCount: 访问控制总数
        :type ACLCount: int
        :param _CCCount: CC攻击总数
        :type CCCount: int
        :param _BotCount: Bot攻击总数
        :type BotCount: int
        :param _ApiAssetsCount: api资产总数
        :type ApiAssetsCount: int
        :param _ApiRiskEventCount: api风险事件数量
        :type ApiRiskEventCount: int
        :param _IPBlackCount: 黑名单总数
        :type IPBlackCount: int
        :param _TamperCount: 防篡改总数
        :type TamperCount: int
        :param _LeakCount: 信息泄露总数
        :type LeakCount: int
        :param _ApiRiskEventCircleCount: API风险事件周环比
        :type ApiRiskEventCircleCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AccessCount = None
        self._AttackCount = None
        self._ACLCount = None
        self._CCCount = None
        self._BotCount = None
        self._ApiAssetsCount = None
        self._ApiRiskEventCount = None
        self._IPBlackCount = None
        self._TamperCount = None
        self._LeakCount = None
        self._ApiRiskEventCircleCount = None
        self._RequestId = None

    @property
    def AccessCount(self):
        r"""访问请求总数
        :rtype: int
        """
        return self._AccessCount

    @AccessCount.setter
    def AccessCount(self, AccessCount):
        self._AccessCount = AccessCount

    @property
    def AttackCount(self):
        r"""Web攻击总数
        :rtype: int
        """
        return self._AttackCount

    @AttackCount.setter
    def AttackCount(self, AttackCount):
        self._AttackCount = AttackCount

    @property
    def ACLCount(self):
        r"""访问控制总数
        :rtype: int
        """
        return self._ACLCount

    @ACLCount.setter
    def ACLCount(self, ACLCount):
        self._ACLCount = ACLCount

    @property
    def CCCount(self):
        r"""CC攻击总数
        :rtype: int
        """
        return self._CCCount

    @CCCount.setter
    def CCCount(self, CCCount):
        self._CCCount = CCCount

    @property
    def BotCount(self):
        r"""Bot攻击总数
        :rtype: int
        """
        return self._BotCount

    @BotCount.setter
    def BotCount(self, BotCount):
        self._BotCount = BotCount

    @property
    def ApiAssetsCount(self):
        r"""api资产总数
        :rtype: int
        """
        return self._ApiAssetsCount

    @ApiAssetsCount.setter
    def ApiAssetsCount(self, ApiAssetsCount):
        self._ApiAssetsCount = ApiAssetsCount

    @property
    def ApiRiskEventCount(self):
        r"""api风险事件数量
        :rtype: int
        """
        return self._ApiRiskEventCount

    @ApiRiskEventCount.setter
    def ApiRiskEventCount(self, ApiRiskEventCount):
        self._ApiRiskEventCount = ApiRiskEventCount

    @property
    def IPBlackCount(self):
        r"""黑名单总数
        :rtype: int
        """
        return self._IPBlackCount

    @IPBlackCount.setter
    def IPBlackCount(self, IPBlackCount):
        self._IPBlackCount = IPBlackCount

    @property
    def TamperCount(self):
        r"""防篡改总数
        :rtype: int
        """
        return self._TamperCount

    @TamperCount.setter
    def TamperCount(self, TamperCount):
        self._TamperCount = TamperCount

    @property
    def LeakCount(self):
        r"""信息泄露总数
        :rtype: int
        """
        return self._LeakCount

    @LeakCount.setter
    def LeakCount(self, LeakCount):
        self._LeakCount = LeakCount

    @property
    def ApiRiskEventCircleCount(self):
        r"""API风险事件周环比
        :rtype: int
        """
        return self._ApiRiskEventCircleCount

    @ApiRiskEventCircleCount.setter
    def ApiRiskEventCircleCount(self, ApiRiskEventCircleCount):
        self._ApiRiskEventCircleCount = ApiRiskEventCircleCount

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AccessCount = params.get("AccessCount")
        self._AttackCount = params.get("AttackCount")
        self._ACLCount = params.get("ACLCount")
        self._CCCount = params.get("CCCount")
        self._BotCount = params.get("BotCount")
        self._ApiAssetsCount = params.get("ApiAssetsCount")
        self._ApiRiskEventCount = params.get("ApiRiskEventCount")
        self._IPBlackCount = params.get("IPBlackCount")
        self._TamperCount = params.get("TamperCount")
        self._LeakCount = params.get("LeakCount")
        self._ApiRiskEventCircleCount = params.get("ApiRiskEventCircleCount")
        self._RequestId = params.get("RequestId")


class DescribeAttackTypeRequest(AbstractModel):
    r"""DescribeAttackType请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FromTime: 起始时间
        :type FromTime: str
        :param _ToTime: 结束时间
        :type ToTime: str
        :param _Host: 兼容Host，逐步淘汰Host字段
        :type Host: str
        :param _Edition: 只有两个值有效，sparta-waf，clb-waf，不传则不过滤
        :type Edition: str
        :param _InstanceID: WAF实例ID，不传则不过滤
        :type InstanceID: str
        :param _Domain: 域名过滤，不传则不过滤，用于替代Host字段，逐步淘汰Host
        :type Domain: str
        """
        self._FromTime = None
        self._ToTime = None
        self._Host = None
        self._Edition = None
        self._InstanceID = None
        self._Domain = None

    @property
    def FromTime(self):
        r"""起始时间
        :rtype: str
        """
        return self._FromTime

    @FromTime.setter
    def FromTime(self, FromTime):
        self._FromTime = FromTime

    @property
    def ToTime(self):
        r"""结束时间
        :rtype: str
        """
        return self._ToTime

    @ToTime.setter
    def ToTime(self, ToTime):
        self._ToTime = ToTime

    @property
    def Host(self):
        r"""兼容Host，逐步淘汰Host字段
        :rtype: str
        """
        return self._Host

    @Host.setter
    def Host(self, Host):
        self._Host = Host

    @property
    def Edition(self):
        r"""只有两个值有效，sparta-waf，clb-waf，不传则不过滤
        :rtype: str
        """
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition

    @property
    def InstanceID(self):
        r"""WAF实例ID，不传则不过滤
        :rtype: str
        """
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID

    @property
    def Domain(self):
        r"""域名过滤，不传则不过滤，用于替代Host字段，逐步淘汰Host
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain


    def _deserialize(self, params):
        self._FromTime = params.get("FromTime")
        self._ToTime = params.get("ToTime")
        self._Host = params.get("Host")
        self._Edition = params.get("Edition")
        self._InstanceID = params.get("InstanceID")
        self._Domain = params.get("Domain")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAttackTypeResponse(AbstractModel):
    r"""DescribeAttackType返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Piechart: 数量
        :type Piechart: list of PiechartItem
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Piechart = None
        self._RequestId = None

    @property
    def Piechart(self):
        r"""数量
        :rtype: list of PiechartItem
        """
        return self._Piechart

    @Piechart.setter
    def Piechart(self, Piechart):
        self._Piechart = Piechart

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Piechart") is not None:
            self._Piechart = []
            for item in params.get("Piechart"):
                obj = PiechartItem()
                obj._deserialize(item)
                self._Piechart.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAttackWhiteRuleRequest(AbstractModel):
    r"""DescribeAttackWhiteRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 需要查询的域名
        :type Domain: str
        :param _Offset: 分页
        :type Offset: int
        :param _Limit: 每页容量
        :type Limit: int
        :param _By: 排序的字段，支持user_id, signature_id, modify_time
        :type By: str
        :param _Order: 排序方式
        :type Order: str
        :param _Filters: 筛选条件，支持SignatureId, MatchContent
        :type Filters: list of FiltersItemNew
        """
        self._Domain = None
        self._Offset = None
        self._Limit = None
        self._By = None
        self._Order = None
        self._Filters = None

    @property
    def Domain(self):
        r"""需要查询的域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Offset(self):
        r"""分页
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""每页容量
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def By(self):
        r"""排序的字段，支持user_id, signature_id, modify_time
        :rtype: str
        """
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        r"""排序方式
        :rtype: str
        """
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def Filters(self):
        r"""筛选条件，支持SignatureId, MatchContent
        :rtype: list of FiltersItemNew
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._By = params.get("By")
        self._Order = params.get("Order")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = FiltersItemNew()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAttackWhiteRuleResponse(AbstractModel):
    r"""DescribeAttackWhiteRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Total: 规则总数
        :type Total: int
        :param _List: 规则白名单列表
        :type List: list of UserWhiteRule
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Total = None
        self._List = None
        self._RequestId = None

    @property
    def Total(self):
        r"""规则总数
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def List(self):
        r"""规则白名单列表
        :rtype: list of UserWhiteRule
        """
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = UserWhiteRule()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAutoDenyIPRequest(AbstractModel):
    r"""DescribeAutoDenyIP请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _Ip: 查询IP自动封禁状态
        :type Ip: str
        :param _Count: 计数标识
        :type Count: int
        :param _Category: 类别
        :type Category: str
        :param _VtsMin: 有效时间最小时间戳
        :type VtsMin: int
        :param _VtsMax: 有效时间最大时间戳
        :type VtsMax: int
        :param _CtsMin: 创建时间最小时间戳
        :type CtsMin: int
        :param _CtsMax: 创建时间最大时间戳
        :type CtsMax: int
        :param _Skip: 偏移量
        :type Skip: int
        :param _Limit: 限制条数
        :type Limit: int
        :param _Name: 策略名字
        :type Name: str
        :param _Sort: 排序参数
        :type Sort: str
        """
        self._Domain = None
        self._Ip = None
        self._Count = None
        self._Category = None
        self._VtsMin = None
        self._VtsMax = None
        self._CtsMin = None
        self._CtsMax = None
        self._Skip = None
        self._Limit = None
        self._Name = None
        self._Sort = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Ip(self):
        r"""查询IP自动封禁状态
        :rtype: str
        """
        return self._Ip

    @Ip.setter
    def Ip(self, Ip):
        self._Ip = Ip

    @property
    def Count(self):
        r"""计数标识
        :rtype: int
        """
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def Category(self):
        r"""类别
        :rtype: str
        """
        return self._Category

    @Category.setter
    def Category(self, Category):
        self._Category = Category

    @property
    def VtsMin(self):
        r"""有效时间最小时间戳
        :rtype: int
        """
        return self._VtsMin

    @VtsMin.setter
    def VtsMin(self, VtsMin):
        self._VtsMin = VtsMin

    @property
    def VtsMax(self):
        r"""有效时间最大时间戳
        :rtype: int
        """
        return self._VtsMax

    @VtsMax.setter
    def VtsMax(self, VtsMax):
        self._VtsMax = VtsMax

    @property
    def CtsMin(self):
        r"""创建时间最小时间戳
        :rtype: int
        """
        return self._CtsMin

    @CtsMin.setter
    def CtsMin(self, CtsMin):
        self._CtsMin = CtsMin

    @property
    def CtsMax(self):
        r"""创建时间最大时间戳
        :rtype: int
        """
        return self._CtsMax

    @CtsMax.setter
    def CtsMax(self, CtsMax):
        self._CtsMax = CtsMax

    @property
    def Skip(self):
        r"""偏移量
        :rtype: int
        """
        return self._Skip

    @Skip.setter
    def Skip(self, Skip):
        self._Skip = Skip

    @property
    def Limit(self):
        r"""限制条数
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Name(self):
        r"""策略名字
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Sort(self):
        r"""排序参数
        :rtype: str
        """
        return self._Sort

    @Sort.setter
    def Sort(self, Sort):
        self._Sort = Sort


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Ip = params.get("Ip")
        self._Count = params.get("Count")
        self._Category = params.get("Category")
        self._VtsMin = params.get("VtsMin")
        self._VtsMax = params.get("VtsMax")
        self._CtsMin = params.get("CtsMin")
        self._CtsMax = params.get("CtsMax")
        self._Skip = params.get("Skip")
        self._Limit = params.get("Limit")
        self._Name = params.get("Name")
        self._Sort = params.get("Sort")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAutoDenyIPResponse(AbstractModel):
    r"""DescribeAutoDenyIP返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 查询IP封禁状态返回结果
        :type Data: :class:`tencentcloud.waf.v20180125.models.IpHitItemsData`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        r"""查询IP封禁状态返回结果
        :rtype: :class:`tencentcloud.waf.v20180125.models.IpHitItemsData`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = IpHitItemsData()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeBatchIpAccessControlRequest(AbstractModel):
    r"""DescribeBatchIpAccessControl请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 筛选条件，支持 ActionType（可选的值为40：白名单，42：黑名单），ValidStatus（可选的值0：全部，1：生效，2：过期），Ip，Domains（域名列表），GroupId（防护对象组ID），GroupName（防护对象组名），RuleId（规则ID），TimerType（生效方式，1：永久生效，2：定时生效，3：按周周期生效，4：按月周期生效）
        :type Filters: list of FiltersItemNew
        :param _OffSet: 偏移
        :type OffSet: int
        :param _Limit: 限制
        :type Limit: int
        :param _Sort: 排序参数
        :type Sort: str
        """
        self._Filters = None
        self._OffSet = None
        self._Limit = None
        self._Sort = None

    @property
    def Filters(self):
        r"""筛选条件，支持 ActionType（可选的值为40：白名单，42：黑名单），ValidStatus（可选的值0：全部，1：生效，2：过期），Ip，Domains（域名列表），GroupId（防护对象组ID），GroupName（防护对象组名），RuleId（规则ID），TimerType（生效方式，1：永久生效，2：定时生效，3：按周周期生效，4：按月周期生效）
        :rtype: list of FiltersItemNew
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OffSet(self):
        r"""偏移
        :rtype: int
        """
        return self._OffSet

    @OffSet.setter
    def OffSet(self, OffSet):
        self._OffSet = OffSet

    @property
    def Limit(self):
        r"""限制
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Sort(self):
        r"""排序参数
        :rtype: str
        """
        return self._Sort

    @Sort.setter
    def Sort(self, Sort):
        self._Sort = Sort


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = FiltersItemNew()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._OffSet = params.get("OffSet")
        self._Limit = params.get("Limit")
        self._Sort = params.get("Sort")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBatchIpAccessControlResponse(AbstractModel):
    r"""DescribeBatchIpAccessControl返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 输出
        :type Data: :class:`tencentcloud.waf.v20180125.models.BatchIpAccessControlData`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        r"""输出
        :rtype: :class:`tencentcloud.waf.v20180125.models.BatchIpAccessControlData`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BatchIpAccessControlData()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeBotSceneListRequest(AbstractModel):
    r"""DescribeBotSceneList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _Limit: 每页数量
        :type Limit: int
        :param _Offset: 页码
        :type Offset: int
        :param _BusinessType: 场景模板类型，通过此下拉字段进行场景筛选。全部: all 登录: login  秒杀:seckill  爬内容：crawl 自定义: custom
        :type BusinessType: list of str
        :param _SceneName: 通过场景名称模糊搜索
        :type SceneName: str
        :param _IsDefault: 是否只显示默认场景
        :type IsDefault: bool
        :param _IsValid: 是否仅显示生效场景
        :type IsValid: bool
        :param _SceneId: 要查询的场景id
        :type SceneId: str
        """
        self._Domain = None
        self._Limit = None
        self._Offset = None
        self._BusinessType = None
        self._SceneName = None
        self._IsDefault = None
        self._IsValid = None
        self._SceneId = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Limit(self):
        r"""每页数量
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""页码
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def BusinessType(self):
        r"""场景模板类型，通过此下拉字段进行场景筛选。全部: all 登录: login  秒杀:seckill  爬内容：crawl 自定义: custom
        :rtype: list of str
        """
        return self._BusinessType

    @BusinessType.setter
    def BusinessType(self, BusinessType):
        self._BusinessType = BusinessType

    @property
    def SceneName(self):
        r"""通过场景名称模糊搜索
        :rtype: str
        """
        return self._SceneName

    @SceneName.setter
    def SceneName(self, SceneName):
        self._SceneName = SceneName

    @property
    def IsDefault(self):
        r"""是否只显示默认场景
        :rtype: bool
        """
        return self._IsDefault

    @IsDefault.setter
    def IsDefault(self, IsDefault):
        self._IsDefault = IsDefault

    @property
    def IsValid(self):
        r"""是否仅显示生效场景
        :rtype: bool
        """
        return self._IsValid

    @IsValid.setter
    def IsValid(self, IsValid):
        self._IsValid = IsValid

    @property
    def SceneId(self):
        r"""要查询的场景id
        :rtype: str
        """
        return self._SceneId

    @SceneId.setter
    def SceneId(self, SceneId):
        self._SceneId = SceneId


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._BusinessType = params.get("BusinessType")
        self._SceneName = params.get("SceneName")
        self._IsDefault = params.get("IsDefault")
        self._IsValid = params.get("IsValid")
        self._SceneId = params.get("SceneId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBotSceneListResponse(AbstractModel):
    r"""DescribeBotSceneList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合筛选条件的场景数目
        :type TotalCount: int
        :param _BotSceneList: 当TotalCount为0时，返回空
        :type BotSceneList: list of BotSceneInfo
        :param _SimpleFlag: true-简易模式
        :type SimpleFlag: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._BotSceneList = None
        self._SimpleFlag = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""符合筛选条件的场景数目
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def BotSceneList(self):
        r"""当TotalCount为0时，返回空
        :rtype: list of BotSceneInfo
        """
        return self._BotSceneList

    @BotSceneList.setter
    def BotSceneList(self, BotSceneList):
        self._BotSceneList = BotSceneList

    @property
    def SimpleFlag(self):
        r"""true-简易模式
        :rtype: bool
        """
        return self._SimpleFlag

    @SimpleFlag.setter
    def SimpleFlag(self, SimpleFlag):
        self._SimpleFlag = SimpleFlag

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("BotSceneList") is not None:
            self._BotSceneList = []
            for item in params.get("BotSceneList"):
                obj = BotSceneInfo()
                obj._deserialize(item)
                self._BotSceneList.append(obj)
        self._SimpleFlag = params.get("SimpleFlag")
        self._RequestId = params.get("RequestId")


class DescribeBotSceneOverviewRequest(AbstractModel):
    r"""DescribeBotSceneOverview请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        """
        self._Domain = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBotSceneOverviewResponse(AbstractModel):
    r"""DescribeBotSceneOverview返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Status: BOT总开关
        :type Status: bool
        :param _SceneCount: 场景总数
        :type SceneCount: int
        :param _ValidSceneCount: 生效场景数
        :type ValidSceneCount: int
        :param _CurrentGlobalScene: 当前开启的、匹配范围为全局、优先级最高的场景
        :type CurrentGlobalScene: :class:`tencentcloud.waf.v20180125.models.GlobalSceneInfo`
        :param _CustomRuleNums: 自定义规则总数，不包括BOT白名单
        :type CustomRuleNums: int
        :param _TldStatus: 图灵盾开关状态
        :type TldStatus: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Status = None
        self._SceneCount = None
        self._ValidSceneCount = None
        self._CurrentGlobalScene = None
        self._CustomRuleNums = None
        self._TldStatus = None
        self._RequestId = None

    @property
    def Status(self):
        r"""BOT总开关
        :rtype: bool
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def SceneCount(self):
        r"""场景总数
        :rtype: int
        """
        return self._SceneCount

    @SceneCount.setter
    def SceneCount(self, SceneCount):
        self._SceneCount = SceneCount

    @property
    def ValidSceneCount(self):
        r"""生效场景数
        :rtype: int
        """
        return self._ValidSceneCount

    @ValidSceneCount.setter
    def ValidSceneCount(self, ValidSceneCount):
        self._ValidSceneCount = ValidSceneCount

    @property
    def CurrentGlobalScene(self):
        r"""当前开启的、匹配范围为全局、优先级最高的场景
        :rtype: :class:`tencentcloud.waf.v20180125.models.GlobalSceneInfo`
        """
        return self._CurrentGlobalScene

    @CurrentGlobalScene.setter
    def CurrentGlobalScene(self, CurrentGlobalScene):
        self._CurrentGlobalScene = CurrentGlobalScene

    @property
    def CustomRuleNums(self):
        r"""自定义规则总数，不包括BOT白名单
        :rtype: int
        """
        return self._CustomRuleNums

    @CustomRuleNums.setter
    def CustomRuleNums(self, CustomRuleNums):
        self._CustomRuleNums = CustomRuleNums

    @property
    def TldStatus(self):
        r"""图灵盾开关状态
        :rtype: bool
        """
        return self._TldStatus

    @TldStatus.setter
    def TldStatus(self, TldStatus):
        self._TldStatus = TldStatus

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._SceneCount = params.get("SceneCount")
        self._ValidSceneCount = params.get("ValidSceneCount")
        if params.get("CurrentGlobalScene") is not None:
            self._CurrentGlobalScene = GlobalSceneInfo()
            self._CurrentGlobalScene._deserialize(params.get("CurrentGlobalScene"))
        self._CustomRuleNums = params.get("CustomRuleNums")
        self._TldStatus = params.get("TldStatus")
        self._RequestId = params.get("RequestId")


class DescribeBotSceneUCBRuleRequest(AbstractModel):
    r"""DescribeBotSceneUCBRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _Skip: 翻页组件的起始页
        :type Skip: int
        :param _Limit: 翻页组件的页数据条数
        :type Limit: int
        :param _Sort: 排序参数
        :type Sort: str
        :param _SceneId: 1.BOT全局白名单处调用时，传"global";2.BOT场景配置处调用时，传具体的场景ID
        :type SceneId: str
        :param _Operate: 需要过滤的动作
        :type Operate: str
        :param _Name: 需要过滤的规则名称
        :type Name: str
        :param _VersionFlag: 兼容老数据和新旧版前端
        :type VersionFlag: str
        :param _TimerType: 生效方式：0-全部 1-永久生效 2-定时生效 3-周粒度生效 4-月粒度生效
        :type TimerType: int
        :param _ValidStatus: 0-全部 1-生效中 2-已过期
        :type ValidStatus: int
        :param _RuleId: 规则id
        :type RuleId: str
        """
        self._Domain = None
        self._Skip = None
        self._Limit = None
        self._Sort = None
        self._SceneId = None
        self._Operate = None
        self._Name = None
        self._VersionFlag = None
        self._TimerType = None
        self._ValidStatus = None
        self._RuleId = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Skip(self):
        r"""翻页组件的起始页
        :rtype: int
        """
        return self._Skip

    @Skip.setter
    def Skip(self, Skip):
        self._Skip = Skip

    @property
    def Limit(self):
        r"""翻页组件的页数据条数
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Sort(self):
        r"""排序参数
        :rtype: str
        """
        return self._Sort

    @Sort.setter
    def Sort(self, Sort):
        self._Sort = Sort

    @property
    def SceneId(self):
        r"""1.BOT全局白名单处调用时，传"global";2.BOT场景配置处调用时，传具体的场景ID
        :rtype: str
        """
        return self._SceneId

    @SceneId.setter
    def SceneId(self, SceneId):
        self._SceneId = SceneId

    @property
    def Operate(self):
        r"""需要过滤的动作
        :rtype: str
        """
        return self._Operate

    @Operate.setter
    def Operate(self, Operate):
        self._Operate = Operate

    @property
    def Name(self):
        r"""需要过滤的规则名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def VersionFlag(self):
        r"""兼容老数据和新旧版前端
        :rtype: str
        """
        return self._VersionFlag

    @VersionFlag.setter
    def VersionFlag(self, VersionFlag):
        self._VersionFlag = VersionFlag

    @property
    def TimerType(self):
        r"""生效方式：0-全部 1-永久生效 2-定时生效 3-周粒度生效 4-月粒度生效
        :rtype: int
        """
        return self._TimerType

    @TimerType.setter
    def TimerType(self, TimerType):
        self._TimerType = TimerType

    @property
    def ValidStatus(self):
        r"""0-全部 1-生效中 2-已过期
        :rtype: int
        """
        return self._ValidStatus

    @ValidStatus.setter
    def ValidStatus(self, ValidStatus):
        self._ValidStatus = ValidStatus

    @property
    def RuleId(self):
        r"""规则id
        :rtype: str
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Skip = params.get("Skip")
        self._Limit = params.get("Limit")
        self._Sort = params.get("Sort")
        self._SceneId = params.get("SceneId")
        self._Operate = params.get("Operate")
        self._Name = params.get("Name")
        self._VersionFlag = params.get("VersionFlag")
        self._TimerType = params.get("TimerType")
        self._ValidStatus = params.get("ValidStatus")
        self._RuleId = params.get("RuleId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBotSceneUCBRuleResponse(AbstractModel):
    r"""DescribeBotSceneUCBRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 返回数据包
        :type Data: :class:`tencentcloud.waf.v20180125.models.DescribeBotUCBRuleRsp`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        r"""返回数据包
        :rtype: :class:`tencentcloud.waf.v20180125.models.DescribeBotUCBRuleRsp`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeBotUCBRuleRsp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeBotUCBRuleRsp(AbstractModel):
    r"""获取自定义规则列表时的出参

    """

    def __init__(self):
        r"""
        :param _Res: 规则列表
        :type Res: list of InOutputBotUCBRule
        :param _TotalCount: 规则总数
        :type TotalCount: int
        """
        self._Res = None
        self._TotalCount = None

    @property
    def Res(self):
        r"""规则列表
        :rtype: list of InOutputBotUCBRule
        """
        return self._Res

    @Res.setter
    def Res(self, Res):
        self._Res = Res

    @property
    def TotalCount(self):
        r"""规则总数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount


    def _deserialize(self, params):
        if params.get("Res") is not None:
            self._Res = []
            for item in params.get("Res"):
                obj = InOutputBotUCBRule()
                obj._deserialize(item)
                self._Res.append(obj)
        self._TotalCount = params.get("TotalCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCCAutoStatusRequest(AbstractModel):
    r"""DescribeCCAutoStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        """
        self._Domain = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCCAutoStatusResponse(AbstractModel):
    r"""DescribeCCAutoStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoCCSwitch: 配置状态，0表示关闭，1表示开启
        :type AutoCCSwitch: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AutoCCSwitch = None
        self._RequestId = None

    @property
    def AutoCCSwitch(self):
        r"""配置状态，0表示关闭，1表示开启
        :rtype: int
        """
        return self._AutoCCSwitch

    @AutoCCSwitch.setter
    def AutoCCSwitch(self, AutoCCSwitch):
        self._AutoCCSwitch = AutoCCSwitch

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AutoCCSwitch = params.get("AutoCCSwitch")
        self._RequestId = params.get("RequestId")


class DescribeCCRuleListRequest(AbstractModel):
    r"""DescribeCCRuleList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 需要查询的API所属的域名
        :type Domain: str
        :param _Offset: 偏移
        :type Offset: int
        :param _Limit: 容量
        :type Limit: int
        :param _By: 目前支持根据ts_version排序
        :type By: str
        :param _Filters: 过滤数组,name可以是如下的值： RuleID,ParamName,Url,Action,Method,Source,Status
        :type Filters: list of FiltersItemNew
        :param _Order: asc或者desc
        :type Order: str
        """
        self._Domain = None
        self._Offset = None
        self._Limit = None
        self._By = None
        self._Filters = None
        self._Order = None

    @property
    def Domain(self):
        r"""需要查询的API所属的域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Offset(self):
        r"""偏移
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""容量
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def By(self):
        r"""目前支持根据ts_version排序
        :rtype: str
        """
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Filters(self):
        r"""过滤数组,name可以是如下的值： RuleID,ParamName,Url,Action,Method,Source,Status
        :rtype: list of FiltersItemNew
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        r"""asc或者desc
        :rtype: str
        """
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._By = params.get("By")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = FiltersItemNew()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCCRuleListResponse(AbstractModel):
    r"""DescribeCCRuleList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 查询到的CC规则的列表
        :type Data: :class:`tencentcloud.waf.v20180125.models.CCRuleLists`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        r"""查询到的CC规则的列表
        :rtype: :class:`tencentcloud.waf.v20180125.models.CCRuleLists`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = CCRuleLists()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeCCRuleRequest(AbstractModel):
    r"""DescribeCCRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _Offset: 页码
        :type Offset: int
        :param _Limit: 页的数目
        :type Limit: int
        :param _Sort: 排序参数
        :type Sort: str
        :param _Edition: clb-waf 或者 sparta-waf
        :type Edition: str
        :param _Name: 过滤条件
        :type Name: str
        """
        self._Domain = None
        self._Offset = None
        self._Limit = None
        self._Sort = None
        self._Edition = None
        self._Name = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Offset(self):
        r"""页码
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""页的数目
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Sort(self):
        r"""排序参数
        :rtype: str
        """
        return self._Sort

    @Sort.setter
    def Sort(self, Sort):
        self._Sort = Sort

    @property
    def Edition(self):
        r"""clb-waf 或者 sparta-waf
        :rtype: str
        """
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition

    @property
    def Name(self):
        r"""过滤条件
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Sort = params.get("Sort")
        self._Edition = params.get("Edition")
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCCRuleResponse(AbstractModel):
    r"""DescribeCCRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 结果
        :type Data: :class:`tencentcloud.waf.v20180125.models.CCRuleData`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        r"""结果
        :rtype: :class:`tencentcloud.waf.v20180125.models.CCRuleData`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = CCRuleData()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeCertificateVerifyResultRequest(AbstractModel):
    r"""DescribeCertificateVerifyResult请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _CertType: 证书类型，此参数和GmCertType不可同时为0。 0：不检测国际标准证书 1：证书来源为自有证书 2：证书来源为托管证书
        :type CertType: int
        :param _Certificate: CertType为1时，需要填充此参数，表示自有证书的证书链
        :type Certificate: str
        :param _CertID: CertType为2时，需要填充此参数，表示腾讯云SSL平台托管的证书id
        :type CertID: str
        :param _PrivateKey: CertType为1时，需要填充此参数，表示自有证书的私钥
        :type PrivateKey: str
        :param _GmCertType: 国密证书类型，此参数和CertType不可同时为0。0：不检测国密证书 1：证书来源为自有国密证书 2：证书来源为托管国密证书
        :type GmCertType: int
        :param _GmCert: GmCertType为1时，需要填充此参数，表示自有国密证书的证书链
        :type GmCert: str
        :param _GmPrivateKey: GmCertType为1时，需要填充此参数，表示自有国密证书的私钥
        :type GmPrivateKey: str
        :param _GmEncCert: GmCertType为1时，需要填充此参数，表示自有国密证书的加密证书
        :type GmEncCert: str
        :param _GmEncPrivateKey: GmCertType为1时，需要填充此参数，表示自有国密证书的加密证书的私钥
        :type GmEncPrivateKey: str
        :param _GmSSLId: GmCertType为2时，需要填充此参数，表示腾讯云SSL平台托管的证书id
        :type GmSSLId: str
        """
        self._Domain = None
        self._CertType = None
        self._Certificate = None
        self._CertID = None
        self._PrivateKey = None
        self._GmCertType = None
        self._GmCert = None
        self._GmPrivateKey = None
        self._GmEncCert = None
        self._GmEncPrivateKey = None
        self._GmSSLId = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def CertType(self):
        r"""证书类型，此参数和GmCertType不可同时为0。 0：不检测国际标准证书 1：证书来源为自有证书 2：证书来源为托管证书
        :rtype: int
        """
        return self._CertType

    @CertType.setter
    def CertType(self, CertType):
        self._CertType = CertType

    @property
    def Certificate(self):
        r"""CertType为1时，需要填充此参数，表示自有证书的证书链
        :rtype: str
        """
        return self._Certificate

    @Certificate.setter
    def Certificate(self, Certificate):
        self._Certificate = Certificate

    @property
    def CertID(self):
        r"""CertType为2时，需要填充此参数，表示腾讯云SSL平台托管的证书id
        :rtype: str
        """
        return self._CertID

    @CertID.setter
    def CertID(self, CertID):
        self._CertID = CertID

    @property
    def PrivateKey(self):
        r"""CertType为1时，需要填充此参数，表示自有证书的私钥
        :rtype: str
        """
        return self._PrivateKey

    @PrivateKey.setter
    def PrivateKey(self, PrivateKey):
        self._PrivateKey = PrivateKey

    @property
    def GmCertType(self):
        r"""国密证书类型，此参数和CertType不可同时为0。0：不检测国密证书 1：证书来源为自有国密证书 2：证书来源为托管国密证书
        :rtype: int
        """
        return self._GmCertType

    @GmCertType.setter
    def GmCertType(self, GmCertType):
        self._GmCertType = GmCertType

    @property
    def GmCert(self):
        r"""GmCertType为1时，需要填充此参数，表示自有国密证书的证书链
        :rtype: str
        """
        return self._GmCert

    @GmCert.setter
    def GmCert(self, GmCert):
        self._GmCert = GmCert

    @property
    def GmPrivateKey(self):
        r"""GmCertType为1时，需要填充此参数，表示自有国密证书的私钥
        :rtype: str
        """
        return self._GmPrivateKey

    @GmPrivateKey.setter
    def GmPrivateKey(self, GmPrivateKey):
        self._GmPrivateKey = GmPrivateKey

    @property
    def GmEncCert(self):
        r"""GmCertType为1时，需要填充此参数，表示自有国密证书的加密证书
        :rtype: str
        """
        return self._GmEncCert

    @GmEncCert.setter
    def GmEncCert(self, GmEncCert):
        self._GmEncCert = GmEncCert

    @property
    def GmEncPrivateKey(self):
        r"""GmCertType为1时，需要填充此参数，表示自有国密证书的加密证书的私钥
        :rtype: str
        """
        return self._GmEncPrivateKey

    @GmEncPrivateKey.setter
    def GmEncPrivateKey(self, GmEncPrivateKey):
        self._GmEncPrivateKey = GmEncPrivateKey

    @property
    def GmSSLId(self):
        r"""GmCertType为2时，需要填充此参数，表示腾讯云SSL平台托管的证书id
        :rtype: str
        """
        return self._GmSSLId

    @GmSSLId.setter
    def GmSSLId(self, GmSSLId):
        self._GmSSLId = GmSSLId


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._CertType = params.get("CertType")
        self._Certificate = params.get("Certificate")
        self._CertID = params.get("CertID")
        self._PrivateKey = params.get("PrivateKey")
        self._GmCertType = params.get("GmCertType")
        self._GmCert = params.get("GmCert")
        self._GmPrivateKey = params.get("GmPrivateKey")
        self._GmEncCert = params.get("GmEncCert")
        self._GmEncPrivateKey = params.get("GmEncPrivateKey")
        self._GmSSLId = params.get("GmSSLId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCertificateVerifyResultResponse(AbstractModel):
    r"""DescribeCertificateVerifyResult返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Status: 状态码。
0：证书正常
310：证书异常
311：证书过期
312：证书即将过期
        :type Status: int
        :param _Detail: 错误详情
        :type Detail: list of str
        :param _NotAfter: 过期时间
        :type NotAfter: str
        :param _Changed: 证书是否改变。
0：未变化
1：有变化
        :type Changed: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Status = None
        self._Detail = None
        self._NotAfter = None
        self._Changed = None
        self._RequestId = None

    @property
    def Status(self):
        r"""状态码。
0：证书正常
310：证书异常
311：证书过期
312：证书即将过期
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Detail(self):
        r"""错误详情
        :rtype: list of str
        """
        return self._Detail

    @Detail.setter
    def Detail(self, Detail):
        self._Detail = Detail

    @property
    def NotAfter(self):
        r"""过期时间
        :rtype: str
        """
        return self._NotAfter

    @NotAfter.setter
    def NotAfter(self, NotAfter):
        self._NotAfter = NotAfter

    @property
    def Changed(self):
        r"""证书是否改变。
0：未变化
1：有变化
        :rtype: int
        """
        return self._Changed

    @Changed.setter
    def Changed(self, Changed):
        self._Changed = Changed

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._Detail = params.get("Detail")
        self._NotAfter = params.get("NotAfter")
        self._Changed = params.get("Changed")
        self._RequestId = params.get("RequestId")


class DescribeCiphersDetailRequest(AbstractModel):
    r"""DescribeCiphersDetail请求参数结构体

    """


class DescribeCiphersDetailResponse(AbstractModel):
    r"""DescribeCiphersDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Ciphers: 加密套件信息
        :type Ciphers: list of TLSCiphers
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Ciphers = None
        self._RequestId = None

    @property
    def Ciphers(self):
        r"""加密套件信息
        :rtype: list of TLSCiphers
        """
        return self._Ciphers

    @Ciphers.setter
    def Ciphers(self, Ciphers):
        self._Ciphers = Ciphers

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Ciphers") is not None:
            self._Ciphers = []
            for item in params.get("Ciphers"):
                obj = TLSCiphers()
                obj._deserialize(item)
                self._Ciphers.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCustomRuleListRequest(AbstractModel):
    r"""DescribeCustomRuleList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _Offset: 偏移
        :type Offset: int
        :param _Limit: 容量
        :type Limit: int
        :param _Filters: 过滤数组,name可以是如下的值： RuleID,RuleName,Match
        :type Filters: list of FiltersItemNew
        :param _Order: asc或者desc
        :type Order: str
        :param _By: exp_ts或者mod_ts
        :type By: str
        :param _DomainList: 查询的域名列表,访问控制页面不用传
        :type DomainList: list of str
        """
        self._Domain = None
        self._Offset = None
        self._Limit = None
        self._Filters = None
        self._Order = None
        self._By = None
        self._DomainList = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Offset(self):
        r"""偏移
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""容量
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        r"""过滤数组,name可以是如下的值： RuleID,RuleName,Match
        :rtype: list of FiltersItemNew
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        r"""asc或者desc
        :rtype: str
        """
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        r"""exp_ts或者mod_ts
        :rtype: str
        """
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def DomainList(self):
        r"""查询的域名列表,访问控制页面不用传
        :rtype: list of str
        """
        return self._DomainList

    @DomainList.setter
    def DomainList(self, DomainList):
        self._DomainList = DomainList


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = FiltersItemNew()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        self._DomainList = params.get("DomainList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCustomRuleListResponse(AbstractModel):
    r"""DescribeCustomRuleList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleList: 规则详情
        :type RuleList: list of DescribeCustomRulesRspRuleListItem
        :param _TotalCount: 规则条数
        :type TotalCount: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RuleList = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def RuleList(self):
        r"""规则详情
        :rtype: list of DescribeCustomRulesRspRuleListItem
        """
        return self._RuleList

    @RuleList.setter
    def RuleList(self, RuleList):
        self._RuleList = RuleList

    @property
    def TotalCount(self):
        r"""规则条数
        :rtype: str
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("RuleList") is not None:
            self._RuleList = []
            for item in params.get("RuleList"):
                obj = DescribeCustomRulesRspRuleListItem()
                obj._deserialize(item)
                self._RuleList.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeCustomRulesRspRuleListItem(AbstractModel):
    r"""DescribeCustomRules接口回包中的复杂类型

    """

    def __init__(self):
        r"""
        :param _ActionType: 动作类型，1代表阻断，2代表人机识别，3代表观察，4代表重定向，5代表JS校验
        :type ActionType: str
        :param _Bypass: 跳过的策略
        :type Bypass: str
        :param _CreateTime: 创建时间
        :type CreateTime: str
        :param _ExpireTime: 过期时间
        :type ExpireTime: str
        :param _Name: 策略名称
        :type Name: str
        :param _Redirect: 重定向地址
        :type Redirect: str
        :param _RuleId: 策略ID
        :type RuleId: str
        :param _SortId: 优先级
        :type SortId: str
        :param _Status: 状态
        :type Status: str
        :param _Strategies: 策略详情
        :type Strategies: list of Strategy
        :param _EventId: 事件id
        :type EventId: str
        :param _ModifyTime: 修改时间
        :type ModifyTime: str
        :param _ValidStatus: 生效状态
        :type ValidStatus: int
        :param _Source: 来源
        :type Source: str
        :param _JobType: 定时任务类型
        :type JobType: str
        :param _JobDateTime: 定时任务配置信息
        :type JobDateTime: :class:`tencentcloud.waf.v20180125.models.JobDateTime`
        :param _CronType: 周期任务粒度
        :type CronType: str
        :param _Label: 自定义标签，风控规则用，用来表示是内置规则还是用户自定义的
        :type Label: str
        :param _PageId: 拦截页面id
        :type PageId: str
        :param _Domain: 域名
        :type Domain: str
        :param _LogicalOp: 匹配条件的逻辑关系，支持and、or，分别表示多个逻辑匹配条件是与、或的关系
        :type LogicalOp: str
        :param _ActionRatio: 规则灰度的比例，默认是100，不灰度
        :type ActionRatio: int
        """
        self._ActionType = None
        self._Bypass = None
        self._CreateTime = None
        self._ExpireTime = None
        self._Name = None
        self._Redirect = None
        self._RuleId = None
        self._SortId = None
        self._Status = None
        self._Strategies = None
        self._EventId = None
        self._ModifyTime = None
        self._ValidStatus = None
        self._Source = None
        self._JobType = None
        self._JobDateTime = None
        self._CronType = None
        self._Label = None
        self._PageId = None
        self._Domain = None
        self._LogicalOp = None
        self._ActionRatio = None

    @property
    def ActionType(self):
        r"""动作类型，1代表阻断，2代表人机识别，3代表观察，4代表重定向，5代表JS校验
        :rtype: str
        """
        return self._ActionType

    @ActionType.setter
    def ActionType(self, ActionType):
        self._ActionType = ActionType

    @property
    def Bypass(self):
        r"""跳过的策略
        :rtype: str
        """
        return self._Bypass

    @Bypass.setter
    def Bypass(self, Bypass):
        self._Bypass = Bypass

    @property
    def CreateTime(self):
        r"""创建时间
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def ExpireTime(self):
        r"""过期时间
        :rtype: str
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def Name(self):
        r"""策略名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Redirect(self):
        r"""重定向地址
        :rtype: str
        """
        return self._Redirect

    @Redirect.setter
    def Redirect(self, Redirect):
        self._Redirect = Redirect

    @property
    def RuleId(self):
        r"""策略ID
        :rtype: str
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def SortId(self):
        r"""优先级
        :rtype: str
        """
        return self._SortId

    @SortId.setter
    def SortId(self, SortId):
        self._SortId = SortId

    @property
    def Status(self):
        r"""状态
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Strategies(self):
        r"""策略详情
        :rtype: list of Strategy
        """
        return self._Strategies

    @Strategies.setter
    def Strategies(self, Strategies):
        self._Strategies = Strategies

    @property
    def EventId(self):
        r"""事件id
        :rtype: str
        """
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId

    @property
    def ModifyTime(self):
        r"""修改时间
        :rtype: str
        """
        return self._ModifyTime

    @ModifyTime.setter
    def ModifyTime(self, ModifyTime):
        self._ModifyTime = ModifyTime

    @property
    def ValidStatus(self):
        r"""生效状态
        :rtype: int
        """
        return self._ValidStatus

    @ValidStatus.setter
    def ValidStatus(self, ValidStatus):
        self._ValidStatus = ValidStatus

    @property
    def Source(self):
        r"""来源
        :rtype: str
        """
        return self._Source

    @Source.setter
    def Source(self, Source):
        self._Source = Source

    @property
    def JobType(self):
        r"""定时任务类型
        :rtype: str
        """
        return self._JobType

    @JobType.setter
    def JobType(self, JobType):
        self._JobType = JobType

    @property
    def JobDateTime(self):
        r"""定时任务配置信息
        :rtype: :class:`tencentcloud.waf.v20180125.models.JobDateTime`
        """
        return self._JobDateTime

    @JobDateTime.setter
    def JobDateTime(self, JobDateTime):
        self._JobDateTime = JobDateTime

    @property
    def CronType(self):
        r"""周期任务粒度
        :rtype: str
        """
        return self._CronType

    @CronType.setter
    def CronType(self, CronType):
        self._CronType = CronType

    @property
    def Label(self):
        r"""自定义标签，风控规则用，用来表示是内置规则还是用户自定义的
        :rtype: str
        """
        return self._Label

    @Label.setter
    def Label(self, Label):
        self._Label = Label

    @property
    def PageId(self):
        r"""拦截页面id
        :rtype: str
        """
        return self._PageId

    @PageId.setter
    def PageId(self, PageId):
        self._PageId = PageId

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def LogicalOp(self):
        r"""匹配条件的逻辑关系，支持and、or，分别表示多个逻辑匹配条件是与、或的关系
        :rtype: str
        """
        return self._LogicalOp

    @LogicalOp.setter
    def LogicalOp(self, LogicalOp):
        self._LogicalOp = LogicalOp

    @property
    def ActionRatio(self):
        r"""规则灰度的比例，默认是100，不灰度
        :rtype: int
        """
        return self._ActionRatio

    @ActionRatio.setter
    def ActionRatio(self, ActionRatio):
        self._ActionRatio = ActionRatio


    def _deserialize(self, params):
        self._ActionType = params.get("ActionType")
        self._Bypass = params.get("Bypass")
        self._CreateTime = params.get("CreateTime")
        self._ExpireTime = params.get("ExpireTime")
        self._Name = params.get("Name")
        self._Redirect = params.get("Redirect")
        self._RuleId = params.get("RuleId")
        self._SortId = params.get("SortId")
        self._Status = params.get("Status")
        if params.get("Strategies") is not None:
            self._Strategies = []
            for item in params.get("Strategies"):
                obj = Strategy()
                obj._deserialize(item)
                self._Strategies.append(obj)
        self._EventId = params.get("EventId")
        self._ModifyTime = params.get("ModifyTime")
        self._ValidStatus = params.get("ValidStatus")
        self._Source = params.get("Source")
        self._JobType = params.get("JobType")
        if params.get("JobDateTime") is not None:
            self._JobDateTime = JobDateTime()
            self._JobDateTime._deserialize(params.get("JobDateTime"))
        self._CronType = params.get("CronType")
        self._Label = params.get("Label")
        self._PageId = params.get("PageId")
        self._Domain = params.get("Domain")
        self._LogicalOp = params.get("LogicalOp")
        self._ActionRatio = params.get("ActionRatio")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCustomWhiteRuleRequest(AbstractModel):
    r"""DescribeCustomWhiteRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _Offset: 偏移量
        :type Offset: int
        :param _Limit: 容量
        :type Limit: int
        :param _Filters: 过滤数组,name可以是如下的值： RuleID,RuleName,Match
        :type Filters: list of FiltersItemNew
        :param _Order: asc或者desc
        :type Order: str
        :param _By: exp_ts或者mod_ts
        :type By: str
        """
        self._Domain = None
        self._Offset = None
        self._Limit = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Offset(self):
        r"""偏移量
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""容量
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        r"""过滤数组,name可以是如下的值： RuleID,RuleName,Match
        :rtype: list of FiltersItemNew
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        r"""asc或者desc
        :rtype: str
        """
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        r"""exp_ts或者mod_ts
        :rtype: str
        """
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = FiltersItemNew()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCustomWhiteRuleResponse(AbstractModel):
    r"""DescribeCustomWhiteRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleList: 规则详情
        :type RuleList: list of DescribeCustomRulesRspRuleListItem
        :param _TotalCount: 规则条数
        :type TotalCount: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RuleList = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def RuleList(self):
        r"""规则详情
        :rtype: list of DescribeCustomRulesRspRuleListItem
        """
        return self._RuleList

    @RuleList.setter
    def RuleList(self, RuleList):
        self._RuleList = RuleList

    @property
    def TotalCount(self):
        r"""规则条数
        :rtype: str
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("RuleList") is not None:
            self._RuleList = []
            for item in params.get("RuleList"):
                obj = DescribeCustomRulesRspRuleListItem()
                obj._deserialize(item)
                self._RuleList.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeDomainCountInfoRequest(AbstractModel):
    r"""DescribeDomainCountInfo请求参数结构体

    """


class DescribeDomainCountInfoResponse(AbstractModel):
    r"""DescribeDomainCountInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AllDomain: 域名总数
        :type AllDomain: int
        :param _UpdateTime: 最近发现时间
        :type UpdateTime: str
        :param _WafDomainCount: 接入域名总数
        :type WafDomainCount: int
        :param _LeftDomainCount: 剩下配额
        :type LeftDomainCount: int
        :param _OpenWafDomain: 开启防护域名数
        :type OpenWafDomain: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AllDomain = None
        self._UpdateTime = None
        self._WafDomainCount = None
        self._LeftDomainCount = None
        self._OpenWafDomain = None
        self._RequestId = None

    @property
    def AllDomain(self):
        r"""域名总数
        :rtype: int
        """
        return self._AllDomain

    @AllDomain.setter
    def AllDomain(self, AllDomain):
        self._AllDomain = AllDomain

    @property
    def UpdateTime(self):
        r"""最近发现时间
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def WafDomainCount(self):
        r"""接入域名总数
        :rtype: int
        """
        return self._WafDomainCount

    @WafDomainCount.setter
    def WafDomainCount(self, WafDomainCount):
        self._WafDomainCount = WafDomainCount

    @property
    def LeftDomainCount(self):
        r"""剩下配额
        :rtype: int
        """
        return self._LeftDomainCount

    @LeftDomainCount.setter
    def LeftDomainCount(self, LeftDomainCount):
        self._LeftDomainCount = LeftDomainCount

    @property
    def OpenWafDomain(self):
        r"""开启防护域名数
        :rtype: int
        """
        return self._OpenWafDomain

    @OpenWafDomain.setter
    def OpenWafDomain(self, OpenWafDomain):
        self._OpenWafDomain = OpenWafDomain

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AllDomain = params.get("AllDomain")
        self._UpdateTime = params.get("UpdateTime")
        self._WafDomainCount = params.get("WafDomainCount")
        self._LeftDomainCount = params.get("LeftDomainCount")
        self._OpenWafDomain = params.get("OpenWafDomain")
        self._RequestId = params.get("RequestId")


class DescribeDomainDetailsClbRequest(AbstractModel):
    r"""DescribeDomainDetailsClb请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _DomainId: 域名id
        :type DomainId: str
        :param _InstanceId: 实例id
        :type InstanceId: str
        """
        self._Domain = None
        self._DomainId = None
        self._InstanceId = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def DomainId(self):
        r"""域名id
        :rtype: str
        """
        return self._DomainId

    @DomainId.setter
    def DomainId(self, DomainId):
        self._DomainId = DomainId

    @property
    def InstanceId(self):
        r"""实例id
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._DomainId = params.get("DomainId")
        self._InstanceId = params.get("InstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDomainDetailsClbResponse(AbstractModel):
    r"""DescribeDomainDetailsClb返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DomainsClbPartInfo: clb域名详情
        :type DomainsClbPartInfo: :class:`tencentcloud.waf.v20180125.models.ClbDomainsInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DomainsClbPartInfo = None
        self._RequestId = None

    @property
    def DomainsClbPartInfo(self):
        r"""clb域名详情
        :rtype: :class:`tencentcloud.waf.v20180125.models.ClbDomainsInfo`
        """
        return self._DomainsClbPartInfo

    @DomainsClbPartInfo.setter
    def DomainsClbPartInfo(self, DomainsClbPartInfo):
        self._DomainsClbPartInfo = DomainsClbPartInfo

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DomainsClbPartInfo") is not None:
            self._DomainsClbPartInfo = ClbDomainsInfo()
            self._DomainsClbPartInfo._deserialize(params.get("DomainsClbPartInfo"))
        self._RequestId = params.get("RequestId")


class DescribeDomainDetailsSaasRequest(AbstractModel):
    r"""DescribeDomainDetailsSaas请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _DomainId: 域名id
        :type DomainId: str
        :param _InstanceId: 实例id
        :type InstanceId: str
        """
        self._Domain = None
        self._DomainId = None
        self._InstanceId = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def DomainId(self):
        r"""域名id
        :rtype: str
        """
        return self._DomainId

    @DomainId.setter
    def DomainId(self, DomainId):
        self._DomainId = DomainId

    @property
    def InstanceId(self):
        r"""实例id
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._DomainId = params.get("DomainId")
        self._InstanceId = params.get("InstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDomainDetailsSaasResponse(AbstractModel):
    r"""DescribeDomainDetailsSaas返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DomainsPartInfo: 域名详情
        :type DomainsPartInfo: :class:`tencentcloud.waf.v20180125.models.DomainsPartInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DomainsPartInfo = None
        self._RequestId = None

    @property
    def DomainsPartInfo(self):
        r"""域名详情
        :rtype: :class:`tencentcloud.waf.v20180125.models.DomainsPartInfo`
        """
        return self._DomainsPartInfo

    @DomainsPartInfo.setter
    def DomainsPartInfo(self, DomainsPartInfo):
        self._DomainsPartInfo = DomainsPartInfo

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DomainsPartInfo") is not None:
            self._DomainsPartInfo = DomainsPartInfo()
            self._DomainsPartInfo._deserialize(params.get("DomainsPartInfo"))
        self._RequestId = params.get("RequestId")


class DescribeDomainRulesRequest(AbstractModel):
    r"""DescribeDomainRules请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 需要查询的域名
        :type Domain: str
        """
        self._Domain = None

    @property
    def Domain(self):
        r"""需要查询的域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDomainRulesResponse(AbstractModel):
    r"""DescribeDomainRules返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Rules: 规则列表详情
        :type Rules: list of Rule
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Rules = None
        self._RequestId = None

    @property
    def Rules(self):
        r"""规则列表详情
        :rtype: list of Rule
        """
        return self._Rules

    @Rules.setter
    def Rules(self, Rules):
        self._Rules = Rules

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Rules") is not None:
            self._Rules = []
            for item in params.get("Rules"):
                obj = Rule()
                obj._deserialize(item)
                self._Rules.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDomainVerifyResultRequest(AbstractModel):
    r"""DescribeDomainVerifyResult请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _InstanceID: 实例id
        :type InstanceID: str
        """
        self._Domain = None
        self._InstanceID = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def InstanceID(self):
        r"""实例id
        :rtype: str
        """
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._InstanceID = params.get("InstanceID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDomainVerifyResultResponse(AbstractModel):
    r"""DescribeDomainVerifyResult返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Msg: 结果描述；如果可以添加返回空字符串
        :type Msg: str
        :param _VerifyCode: 检验状态：0表示可以添加，大于0为不能添加
        :type VerifyCode: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Msg = None
        self._VerifyCode = None
        self._RequestId = None

    @property
    def Msg(self):
        r"""结果描述；如果可以添加返回空字符串
        :rtype: str
        """
        return self._Msg

    @Msg.setter
    def Msg(self, Msg):
        self._Msg = Msg

    @property
    def VerifyCode(self):
        r"""检验状态：0表示可以添加，大于0为不能添加
        :rtype: int
        """
        return self._VerifyCode

    @VerifyCode.setter
    def VerifyCode(self, VerifyCode):
        self._VerifyCode = VerifyCode

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Msg = params.get("Msg")
        self._VerifyCode = params.get("VerifyCode")
        self._RequestId = params.get("RequestId")


class DescribeDomainWhiteRulesRequest(AbstractModel):
    r"""DescribeDomainWhiteRules请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 需要查询的域名
        :type Domain: str
        :param _Url: 请求的白名单匹配路径
        :type Url: str
        :param _Page: 翻到多少页
        :type Page: int
        :param _Count: 每页展示的条数
        :type Count: int
        :param _Sort: 排序方式,desc表示降序，asc表示升序
        :type Sort: str
        :param _RuleId: 规则ID
        :type RuleId: str
        """
        self._Domain = None
        self._Url = None
        self._Page = None
        self._Count = None
        self._Sort = None
        self._RuleId = None

    @property
    def Domain(self):
        r"""需要查询的域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Url(self):
        r"""请求的白名单匹配路径
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def Page(self):
        r"""翻到多少页
        :rtype: int
        """
        return self._Page

    @Page.setter
    def Page(self, Page):
        self._Page = Page

    @property
    def Count(self):
        r"""每页展示的条数
        :rtype: int
        """
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def Sort(self):
        r"""排序方式,desc表示降序，asc表示升序
        :rtype: str
        """
        return self._Sort

    @Sort.setter
    def Sort(self, Sort):
        self._Sort = Sort

    @property
    def RuleId(self):
        r"""规则ID
        :rtype: str
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Url = params.get("Url")
        self._Page = params.get("Page")
        self._Count = params.get("Count")
        self._Sort = params.get("Sort")
        self._RuleId = params.get("RuleId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDomainWhiteRulesResponse(AbstractModel):
    r"""DescribeDomainWhiteRules返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleList: 规则列表
        :type RuleList: list of RuleList
        :param _Total: 规则的数量
        :type Total: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RuleList = None
        self._Total = None
        self._RequestId = None

    @property
    def RuleList(self):
        r"""规则列表
        :rtype: list of RuleList
        """
        return self._RuleList

    @RuleList.setter
    def RuleList(self, RuleList):
        self._RuleList = RuleList

    @property
    def Total(self):
        r"""规则的数量
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("RuleList") is not None:
            self._RuleList = []
            for item in params.get("RuleList"):
                obj = RuleList()
                obj._deserialize(item)
                self._RuleList.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeDomainsRequest(AbstractModel):
    r"""DescribeDomains请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Offset: 分页偏移量，取Limit整数倍。最小值为0，最大值= Total/Limit向上取整
        :type Offset: int
        :param _Limit: 返回域名的数量
        :type Limit: int
        :param _Filters: 过滤数组，过滤字段包括：Edition：实例版本，sparta-waf或clb-waf Domain：域名 DomainId：域名ID InstanceName：实例名称 InstanceId：实例ID FlowMode：流量接入模式，仅支持CLBWAF FlowCheckMode：流量体检模式，仅支持CLBWAF ClsStatus：日志开关 Status：WAF开关BotStatus：BOT开关 ApiStatus：API安全开关 Engine：引擎模式 UpstreamIP：源站IP，仅支持SAAS型WAF UpstreamDomain：源站域名，仅支持SAAS型WAF DomainState：域名状态，仅支持SAAS型WAF SgState：安全组状态，仅支持SAAS型WAF Label：分组标签，同时仅支持一种标签过滤
        :type Filters: list of FiltersItemNew
        """
        self._Offset = None
        self._Limit = None
        self._Filters = None

    @property
    def Offset(self):
        r"""分页偏移量，取Limit整数倍。最小值为0，最大值= Total/Limit向上取整
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""返回域名的数量
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        r"""过滤数组，过滤字段包括：Edition：实例版本，sparta-waf或clb-waf Domain：域名 DomainId：域名ID InstanceName：实例名称 InstanceId：实例ID FlowMode：流量接入模式，仅支持CLBWAF FlowCheckMode：流量体检模式，仅支持CLBWAF ClsStatus：日志开关 Status：WAF开关BotStatus：BOT开关 ApiStatus：API安全开关 Engine：引擎模式 UpstreamIP：源站IP，仅支持SAAS型WAF UpstreamDomain：源站域名，仅支持SAAS型WAF DomainState：域名状态，仅支持SAAS型WAF SgState：安全组状态，仅支持SAAS型WAF Label：分组标签，同时仅支持一种标签过滤
        :rtype: list of FiltersItemNew
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = FiltersItemNew()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDomainsResponse(AbstractModel):
    r"""DescribeDomains返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Total: 总数
        :type Total: int
        :param _Domains: domain列表
        :type Domains: list of DomainInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Total = None
        self._Domains = None
        self._RequestId = None

    @property
    def Total(self):
        r"""总数
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def Domains(self):
        r"""domain列表
        :rtype: list of DomainInfo
        """
        return self._Domains

    @Domains.setter
    def Domains(self, Domains):
        self._Domains = Domains

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("Domains") is not None:
            self._Domains = []
            for item in params.get("Domains"):
                obj = DomainInfo()
                obj._deserialize(item)
                self._Domains.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeExportsRequest(AbstractModel):
    r"""DescribeExports请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TopicId: 日志主题ID，可以通过DescribeTopics接口获取,访问日志主题ID和攻击日志主题ID方式不同，注意DescribeTopics接口使用方法
        :type TopicId: str
        :param _Offset: 分页的偏移量，默认值为0
        :type Offset: int
        :param _Limit: 分页单页限制数目，默认值为20，最大值100
        :type Limit: int
        """
        self._TopicId = None
        self._Offset = None
        self._Limit = None

    @property
    def TopicId(self):
        r"""日志主题ID，可以通过DescribeTopics接口获取,访问日志主题ID和攻击日志主题ID方式不同，注意DescribeTopics接口使用方法
        :rtype: str
        """
        return self._TopicId

    @TopicId.setter
    def TopicId(self, TopicId):
        self._TopicId = TopicId

    @property
    def Offset(self):
        r"""分页的偏移量，默认值为0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""分页单页限制数目，默认值为20，最大值100
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._TopicId = params.get("TopicId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeExportsResponse(AbstractModel):
    r"""DescribeExports返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Exports: 日志导出列表
        :type Exports: list of ExportInfo
        :param _TotalCount: 总数目
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Exports = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def Exports(self):
        r"""日志导出列表
        :rtype: list of ExportInfo
        """
        return self._Exports

    @Exports.setter
    def Exports(self, Exports):
        self._Exports = Exports

    @property
    def TotalCount(self):
        r"""总数目
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Exports") is not None:
            self._Exports = []
            for item in params.get("Exports"):
                obj = ExportInfo()
                obj._deserialize(item)
                self._Exports.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeFindDomainListRequest(AbstractModel):
    r"""DescribeFindDomainList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Offset: 分页
        :type Offset: int
        :param _Limit: 每页容量
        :type Limit: int
        :param _Key: 过滤条件
        :type Key: str
        :param _IsWafDomain: 是否接入waf；传"1"返回接入域名的详情，传"0"返回未接入域名的详情，传""返回接入和未接入域名的详情
        :type IsWafDomain: str
        :param _By: 排序参数
        :type By: str
        :param _Order: 排序方式
        :type Order: str
        """
        self._Offset = None
        self._Limit = None
        self._Key = None
        self._IsWafDomain = None
        self._By = None
        self._Order = None

    @property
    def Offset(self):
        r"""分页
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""每页容量
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Key(self):
        r"""过滤条件
        :rtype: str
        """
        return self._Key

    @Key.setter
    def Key(self, Key):
        self._Key = Key

    @property
    def IsWafDomain(self):
        r"""是否接入waf；传"1"返回接入域名的详情，传"0"返回未接入域名的详情，传""返回接入和未接入域名的详情
        :rtype: str
        """
        return self._IsWafDomain

    @IsWafDomain.setter
    def IsWafDomain(self, IsWafDomain):
        self._IsWafDomain = IsWafDomain

    @property
    def By(self):
        r"""排序参数
        :rtype: str
        """
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        r"""排序方式
        :rtype: str
        """
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Key = params.get("Key")
        self._IsWafDomain = params.get("IsWafDomain")
        self._By = params.get("By")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeFindDomainListResponse(AbstractModel):
    r"""DescribeFindDomainList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Total: 域名总数
        :type Total: int
        :param _List: 域名信息列表
        :type List: list of FindAllDomainDetail
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Total = None
        self._List = None
        self._RequestId = None

    @property
    def Total(self):
        r"""域名总数
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def List(self):
        r"""域名信息列表
        :rtype: list of FindAllDomainDetail
        """
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = FindAllDomainDetail()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeFlowTrendRequest(AbstractModel):
    r"""DescribeFlowTrend请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 需要获取流量趋势的域名, all表示所有域名
        :type Domain: str
        :param _StartTs: 起始时间戳，精度秒
        :type StartTs: int
        :param _EndTs: 结束时间戳，精度秒
        :type EndTs: int
        """
        self._Domain = None
        self._StartTs = None
        self._EndTs = None

    @property
    def Domain(self):
        r"""需要获取流量趋势的域名, all表示所有域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def StartTs(self):
        r"""起始时间戳，精度秒
        :rtype: int
        """
        return self._StartTs

    @StartTs.setter
    def StartTs(self, StartTs):
        self._StartTs = StartTs

    @property
    def EndTs(self):
        r"""结束时间戳，精度秒
        :rtype: int
        """
        return self._EndTs

    @EndTs.setter
    def EndTs(self, EndTs):
        self._EndTs = EndTs


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._StartTs = params.get("StartTs")
        self._EndTs = params.get("EndTs")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeFlowTrendResponse(AbstractModel):
    r"""DescribeFlowTrend返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 流量趋势数据
        :type Data: list of BotStatPointItem
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        r"""流量趋势数据
        :rtype: list of BotStatPointItem
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = BotStatPointItem()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeHistogramRequest(AbstractModel):
    r"""DescribeHistogram请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FromTime: 起始时间
        :type FromTime: str
        :param _ToTime: 结束时间
        :type ToTime: str
        :param _QueryField: 聚类字段，ip为ip聚合，art为响应耗时聚合，url为url聚合，local为ip转化的城市聚合,qps为每秒请求数峰值的聚合，up为上行带宽峰值聚合，down为下行带峰值聚合
        :type QueryField: str
        :param _Source: 条件，access为访问日志，attack为攻击日志
        :type Source: str
        :param _Host: 兼容Host，逐步淘汰Host字段
        :type Host: str
        :param _Edition: 只有两个值有效，sparta-waf，clb-waf，不传则不过滤
        :type Edition: str
        :param _InstanceID: WAF实例ID，不传则不过滤
        :type InstanceID: str
        :param _Domain: 域名过滤，不传则不过滤，用于替代Host字段，逐步淘汰Host
        :type Domain: str
        """
        self._FromTime = None
        self._ToTime = None
        self._QueryField = None
        self._Source = None
        self._Host = None
        self._Edition = None
        self._InstanceID = None
        self._Domain = None

    @property
    def FromTime(self):
        r"""起始时间
        :rtype: str
        """
        return self._FromTime

    @FromTime.setter
    def FromTime(self, FromTime):
        self._FromTime = FromTime

    @property
    def ToTime(self):
        r"""结束时间
        :rtype: str
        """
        return self._ToTime

    @ToTime.setter
    def ToTime(self, ToTime):
        self._ToTime = ToTime

    @property
    def QueryField(self):
        r"""聚类字段，ip为ip聚合，art为响应耗时聚合，url为url聚合，local为ip转化的城市聚合,qps为每秒请求数峰值的聚合，up为上行带宽峰值聚合，down为下行带峰值聚合
        :rtype: str
        """
        return self._QueryField

    @QueryField.setter
    def QueryField(self, QueryField):
        self._QueryField = QueryField

    @property
    def Source(self):
        r"""条件，access为访问日志，attack为攻击日志
        :rtype: str
        """
        return self._Source

    @Source.setter
    def Source(self, Source):
        self._Source = Source

    @property
    def Host(self):
        r"""兼容Host，逐步淘汰Host字段
        :rtype: str
        """
        return self._Host

    @Host.setter
    def Host(self, Host):
        self._Host = Host

    @property
    def Edition(self):
        r"""只有两个值有效，sparta-waf，clb-waf，不传则不过滤
        :rtype: str
        """
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition

    @property
    def InstanceID(self):
        r"""WAF实例ID，不传则不过滤
        :rtype: str
        """
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID

    @property
    def Domain(self):
        r"""域名过滤，不传则不过滤，用于替代Host字段，逐步淘汰Host
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain


    def _deserialize(self, params):
        self._FromTime = params.get("FromTime")
        self._ToTime = params.get("ToTime")
        self._QueryField = params.get("QueryField")
        self._Source = params.get("Source")
        self._Host = params.get("Host")
        self._Edition = params.get("Edition")
        self._InstanceID = params.get("InstanceID")
        self._Domain = params.get("Domain")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeHistogramResponse(AbstractModel):
    r"""DescribeHistogram返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Histogram: 统计数据
        :type Histogram: list of str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Histogram = None
        self._RequestId = None

    @property
    def Histogram(self):
        r"""统计数据
        :rtype: list of str
        """
        return self._Histogram

    @Histogram.setter
    def Histogram(self, Histogram):
        self._Histogram = Histogram

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Histogram = params.get("Histogram")
        self._RequestId = params.get("RequestId")


class DescribeHostLimitRequest(AbstractModel):
    r"""DescribeHostLimit请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 添加的域名
        :type Domain: str
        :param _InstanceID: 实例id
        :type InstanceID: str
        :param _AlbType: 流量来源
        :type AlbType: str
        """
        self._Domain = None
        self._InstanceID = None
        self._AlbType = None

    @property
    def Domain(self):
        r"""添加的域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def InstanceID(self):
        r"""实例id
        :rtype: str
        """
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID

    @property
    def AlbType(self):
        r"""流量来源
        :rtype: str
        """
        return self._AlbType

    @AlbType.setter
    def AlbType(self, AlbType):
        self._AlbType = AlbType


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._InstanceID = params.get("InstanceID")
        self._AlbType = params.get("AlbType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeHostLimitResponse(AbstractModel):
    r"""DescribeHostLimit返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Success: 成功返回的状态码
        :type Success: :class:`tencentcloud.waf.v20180125.models.ResponseCode`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Success = None
        self._RequestId = None

    @property
    def Success(self):
        r"""成功返回的状态码
        :rtype: :class:`tencentcloud.waf.v20180125.models.ResponseCode`
        """
        return self._Success

    @Success.setter
    def Success(self, Success):
        self._Success = Success

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Success") is not None:
            self._Success = ResponseCode()
            self._Success._deserialize(params.get("Success"))
        self._RequestId = params.get("RequestId")


class DescribeHostRequest(AbstractModel):
    r"""DescribeHost请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _DomainId: 域名ID
        :type DomainId: str
        :param _InstanceID: 实例ID
        :type InstanceID: str
        """
        self._Domain = None
        self._DomainId = None
        self._InstanceID = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def DomainId(self):
        r"""域名ID
        :rtype: str
        """
        return self._DomainId

    @DomainId.setter
    def DomainId(self, DomainId):
        self._DomainId = DomainId

    @property
    def InstanceID(self):
        r"""实例ID
        :rtype: str
        """
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._DomainId = params.get("DomainId")
        self._InstanceID = params.get("InstanceID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeHostResponse(AbstractModel):
    r"""DescribeHost返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Host: 域名详情
        :type Host: :class:`tencentcloud.waf.v20180125.models.HostRecord`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Host = None
        self._RequestId = None

    @property
    def Host(self):
        r"""域名详情
        :rtype: :class:`tencentcloud.waf.v20180125.models.HostRecord`
        """
        return self._Host

    @Host.setter
    def Host(self, Host):
        self._Host = Host

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Host") is not None:
            self._Host = HostRecord()
            self._Host._deserialize(params.get("Host"))
        self._RequestId = params.get("RequestId")


class DescribeHostsRequest(AbstractModel):
    r"""DescribeHosts请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 防护域名，如果是要查询某一具体的防护域名则传入此参数，要求是准确的域名，此参数不支持模糊搜索
        :type Domain: str
        :param _DomainId: 防护域名ID，如果是要查询某一具体的防护域名则传入此参数，要求是准确的域名ID，此参数不支持模糊搜索
        :type DomainId: str
        :param _Search: 搜索条件，根据此参数对域名做模糊搜索
        :type Search: str
        :param _Item: 复杂的搜索条件
        :type Item: :class:`tencentcloud.waf.v20180125.models.SearchItem`
        :param _InstanceID: 实例id
        :type InstanceID: str
        """
        self._Domain = None
        self._DomainId = None
        self._Search = None
        self._Item = None
        self._InstanceID = None

    @property
    def Domain(self):
        r"""防护域名，如果是要查询某一具体的防护域名则传入此参数，要求是准确的域名，此参数不支持模糊搜索
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def DomainId(self):
        r"""防护域名ID，如果是要查询某一具体的防护域名则传入此参数，要求是准确的域名ID，此参数不支持模糊搜索
        :rtype: str
        """
        return self._DomainId

    @DomainId.setter
    def DomainId(self, DomainId):
        self._DomainId = DomainId

    @property
    def Search(self):
        r"""搜索条件，根据此参数对域名做模糊搜索
        :rtype: str
        """
        return self._Search

    @Search.setter
    def Search(self, Search):
        self._Search = Search

    @property
    def Item(self):
        r"""复杂的搜索条件
        :rtype: :class:`tencentcloud.waf.v20180125.models.SearchItem`
        """
        return self._Item

    @Item.setter
    def Item(self, Item):
        self._Item = Item

    @property
    def InstanceID(self):
        r"""实例id
        :rtype: str
        """
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._DomainId = params.get("DomainId")
        self._Search = params.get("Search")
        if params.get("Item") is not None:
            self._Item = SearchItem()
            self._Item._deserialize(params.get("Item"))
        self._InstanceID = params.get("InstanceID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeHostsResponse(AbstractModel):
    r"""DescribeHosts返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 防护域名列表的长度
        :type TotalCount: int
        :param _HostList: 防护域名的列表
        :type HostList: list of HostRecord
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._HostList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""防护域名列表的长度
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def HostList(self):
        r"""防护域名的列表
        :rtype: list of HostRecord
        """
        return self._HostList

    @HostList.setter
    def HostList(self, HostList):
        self._HostList = HostList

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("HostList") is not None:
            self._HostList = []
            for item in params.get("HostList"):
                obj = HostRecord()
                obj._deserialize(item)
                self._HostList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeInstancesRequest(AbstractModel):
    r"""DescribeInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Offset: 偏移量
        :type Offset: int
        :param _Limit: 容量
        :type Limit: int
        :param _Filters: 过滤数组
        :type Filters: list of FiltersItemNew
        :param _FreeDelayFlag: 释放延期标识
        :type FreeDelayFlag: int
        """
        self._Offset = None
        self._Limit = None
        self._Filters = None
        self._FreeDelayFlag = None

    @property
    def Offset(self):
        r"""偏移量
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""容量
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        r"""过滤数组
        :rtype: list of FiltersItemNew
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def FreeDelayFlag(self):
        r"""释放延期标识
        :rtype: int
        """
        return self._FreeDelayFlag

    @FreeDelayFlag.setter
    def FreeDelayFlag(self, FreeDelayFlag):
        self._FreeDelayFlag = FreeDelayFlag


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = FiltersItemNew()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._FreeDelayFlag = params.get("FreeDelayFlag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInstancesResponse(AbstractModel):
    r"""DescribeInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Total: 总数
        :type Total: int
        :param _Instances: instance列表
        :type Instances: list of InstanceInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Total = None
        self._Instances = None
        self._RequestId = None

    @property
    def Total(self):
        r"""总数
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def Instances(self):
        r"""instance列表
        :rtype: list of InstanceInfo
        """
        return self._Instances

    @Instances.setter
    def Instances(self, Instances):
        self._Instances = Instances

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("Instances") is not None:
            self._Instances = []
            for item in params.get("Instances"):
                obj = InstanceInfo()
                obj._deserialize(item)
                self._Instances.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeIpAccessControlRequest(AbstractModel):
    r"""DescribeIpAccessControl请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _Count: 计数标识
        :type Count: int
        :param _ActionType: 动作，40表示查询白名单，42表示查询黑名单
        :type ActionType: int
        :param _VtsMin: 最小有效时间的时间戳
        :type VtsMin: int
        :param _VtsMax: 最大有效时间的时间戳
        :type VtsMax: int
        :param _CtsMin: 最小创建时间的时间戳
        :type CtsMin: int
        :param _CtsMax: 最大创建时间的时间戳
        :type CtsMax: int
        :param _OffSet: 分页偏移量，取Limit整数倍。最小值为0，最大值= Total/Limit向上取整
        :type OffSet: int
        :param _Limit: 每页返回的数量，默认为20
        :type Limit: int
        :param _Source: 来源
        :type Source: str
        :param _Sort: 排序参数
        :type Sort: str
        :param _Ip: IP
        :type Ip: str
        :param _ValidStatus: 生效状态，1表示生效中，2表示过期，0表示全部
        :type ValidStatus: int
        :param _ValidTimeStampMin: 最小有效时间的时间戳
        :type ValidTimeStampMin: str
        :param _ValidTimeStampMax: 最大有效时间的时间戳
        :type ValidTimeStampMax: str
        :param _RuleId: 规则ID
        :type RuleId: int
        :param _TimerType: 0表示全部，1表示永久生效，2表示定时生效，3表示周粒度生效，4表示月粒度生效
        :type TimerType: int
        """
        self._Domain = None
        self._Count = None
        self._ActionType = None
        self._VtsMin = None
        self._VtsMax = None
        self._CtsMin = None
        self._CtsMax = None
        self._OffSet = None
        self._Limit = None
        self._Source = None
        self._Sort = None
        self._Ip = None
        self._ValidStatus = None
        self._ValidTimeStampMin = None
        self._ValidTimeStampMax = None
        self._RuleId = None
        self._TimerType = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Count(self):
        r"""计数标识
        :rtype: int
        """
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def ActionType(self):
        r"""动作，40表示查询白名单，42表示查询黑名单
        :rtype: int
        """
        return self._ActionType

    @ActionType.setter
    def ActionType(self, ActionType):
        self._ActionType = ActionType

    @property
    def VtsMin(self):
        warnings.warn("parameter `VtsMin` is deprecated", DeprecationWarning) 

        r"""最小有效时间的时间戳
        :rtype: int
        """
        return self._VtsMin

    @VtsMin.setter
    def VtsMin(self, VtsMin):
        warnings.warn("parameter `VtsMin` is deprecated", DeprecationWarning) 

        self._VtsMin = VtsMin

    @property
    def VtsMax(self):
        warnings.warn("parameter `VtsMax` is deprecated", DeprecationWarning) 

        r"""最大有效时间的时间戳
        :rtype: int
        """
        return self._VtsMax

    @VtsMax.setter
    def VtsMax(self, VtsMax):
        warnings.warn("parameter `VtsMax` is deprecated", DeprecationWarning) 

        self._VtsMax = VtsMax

    @property
    def CtsMin(self):
        r"""最小创建时间的时间戳
        :rtype: int
        """
        return self._CtsMin

    @CtsMin.setter
    def CtsMin(self, CtsMin):
        self._CtsMin = CtsMin

    @property
    def CtsMax(self):
        r"""最大创建时间的时间戳
        :rtype: int
        """
        return self._CtsMax

    @CtsMax.setter
    def CtsMax(self, CtsMax):
        self._CtsMax = CtsMax

    @property
    def OffSet(self):
        r"""分页偏移量，取Limit整数倍。最小值为0，最大值= Total/Limit向上取整
        :rtype: int
        """
        return self._OffSet

    @OffSet.setter
    def OffSet(self, OffSet):
        self._OffSet = OffSet

    @property
    def Limit(self):
        r"""每页返回的数量，默认为20
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Source(self):
        r"""来源
        :rtype: str
        """
        return self._Source

    @Source.setter
    def Source(self, Source):
        self._Source = Source

    @property
    def Sort(self):
        r"""排序参数
        :rtype: str
        """
        return self._Sort

    @Sort.setter
    def Sort(self, Sort):
        self._Sort = Sort

    @property
    def Ip(self):
        r"""IP
        :rtype: str
        """
        return self._Ip

    @Ip.setter
    def Ip(self, Ip):
        self._Ip = Ip

    @property
    def ValidStatus(self):
        r"""生效状态，1表示生效中，2表示过期，0表示全部
        :rtype: int
        """
        return self._ValidStatus

    @ValidStatus.setter
    def ValidStatus(self, ValidStatus):
        self._ValidStatus = ValidStatus

    @property
    def ValidTimeStampMin(self):
        r"""最小有效时间的时间戳
        :rtype: str
        """
        return self._ValidTimeStampMin

    @ValidTimeStampMin.setter
    def ValidTimeStampMin(self, ValidTimeStampMin):
        self._ValidTimeStampMin = ValidTimeStampMin

    @property
    def ValidTimeStampMax(self):
        r"""最大有效时间的时间戳
        :rtype: str
        """
        return self._ValidTimeStampMax

    @ValidTimeStampMax.setter
    def ValidTimeStampMax(self, ValidTimeStampMax):
        self._ValidTimeStampMax = ValidTimeStampMax

    @property
    def RuleId(self):
        r"""规则ID
        :rtype: int
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def TimerType(self):
        r"""0表示全部，1表示永久生效，2表示定时生效，3表示周粒度生效，4表示月粒度生效
        :rtype: int
        """
        return self._TimerType

    @TimerType.setter
    def TimerType(self, TimerType):
        self._TimerType = TimerType


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Count = params.get("Count")
        self._ActionType = params.get("ActionType")
        self._VtsMin = params.get("VtsMin")
        self._VtsMax = params.get("VtsMax")
        self._CtsMin = params.get("CtsMin")
        self._CtsMax = params.get("CtsMax")
        self._OffSet = params.get("OffSet")
        self._Limit = params.get("Limit")
        self._Source = params.get("Source")
        self._Sort = params.get("Sort")
        self._Ip = params.get("Ip")
        self._ValidStatus = params.get("ValidStatus")
        self._ValidTimeStampMin = params.get("ValidTimeStampMin")
        self._ValidTimeStampMax = params.get("ValidTimeStampMax")
        self._RuleId = params.get("RuleId")
        self._TimerType = params.get("TimerType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIpAccessControlResponse(AbstractModel):
    r"""DescribeIpAccessControl返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 输出
        :type Data: :class:`tencentcloud.waf.v20180125.models.IpAccessControlData`
        :param _UsedTotal: 已经使用的IP黑白名单的IP总数
        :type UsedTotal: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._UsedTotal = None
        self._RequestId = None

    @property
    def Data(self):
        r"""输出
        :rtype: :class:`tencentcloud.waf.v20180125.models.IpAccessControlData`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def UsedTotal(self):
        r"""已经使用的IP黑白名单的IP总数
        :rtype: int
        """
        return self._UsedTotal

    @UsedTotal.setter
    def UsedTotal(self, UsedTotal):
        self._UsedTotal = UsedTotal

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = IpAccessControlData()
            self._Data._deserialize(params.get("Data"))
        self._UsedTotal = params.get("UsedTotal")
        self._RequestId = params.get("RequestId")


class DescribeIpHitItemsRequest(AbstractModel):
    r"""DescribeIpHitItems请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _Count: 计数标识
        :type Count: int
        :param _Category: 类别，ip封禁传值auto_deny
        :type Category: str
        :param _VtsMin: 有效时间最小时间戳
        :type VtsMin: int
        :param _VtsMax: 有效时间最大时间戳
        :type VtsMax: int
        :param _CtsMin: 创建时间最小时间戳
        :type CtsMin: int
        :param _CtsMax: 创建时间最大时间戳
        :type CtsMax: int
        :param _Skip: 偏移参数
        :type Skip: int
        :param _Limit: 限制数目，category不等于threat_intelligence时，该值需要必传
        :type Limit: int
        :param _Name: 策略名称
        :type Name: str
        :param _Sort: 排序参数
        :type Sort: str
        :param _Ip: IP,category传threat_intelligence的时候，该值必传
        :type Ip: str
        :param _ValidTimeStampMin: 有效时间最小时间戳
        :type ValidTimeStampMin: int
        :param _ValidTimeStampMax: 有效时间最大时间戳
        :type ValidTimeStampMax: int
        """
        self._Domain = None
        self._Count = None
        self._Category = None
        self._VtsMin = None
        self._VtsMax = None
        self._CtsMin = None
        self._CtsMax = None
        self._Skip = None
        self._Limit = None
        self._Name = None
        self._Sort = None
        self._Ip = None
        self._ValidTimeStampMin = None
        self._ValidTimeStampMax = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Count(self):
        r"""计数标识
        :rtype: int
        """
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def Category(self):
        r"""类别，ip封禁传值auto_deny
        :rtype: str
        """
        return self._Category

    @Category.setter
    def Category(self, Category):
        self._Category = Category

    @property
    def VtsMin(self):
        warnings.warn("parameter `VtsMin` is deprecated", DeprecationWarning) 

        r"""有效时间最小时间戳
        :rtype: int
        """
        return self._VtsMin

    @VtsMin.setter
    def VtsMin(self, VtsMin):
        warnings.warn("parameter `VtsMin` is deprecated", DeprecationWarning) 

        self._VtsMin = VtsMin

    @property
    def VtsMax(self):
        warnings.warn("parameter `VtsMax` is deprecated", DeprecationWarning) 

        r"""有效时间最大时间戳
        :rtype: int
        """
        return self._VtsMax

    @VtsMax.setter
    def VtsMax(self, VtsMax):
        warnings.warn("parameter `VtsMax` is deprecated", DeprecationWarning) 

        self._VtsMax = VtsMax

    @property
    def CtsMin(self):
        r"""创建时间最小时间戳
        :rtype: int
        """
        return self._CtsMin

    @CtsMin.setter
    def CtsMin(self, CtsMin):
        self._CtsMin = CtsMin

    @property
    def CtsMax(self):
        r"""创建时间最大时间戳
        :rtype: int
        """
        return self._CtsMax

    @CtsMax.setter
    def CtsMax(self, CtsMax):
        self._CtsMax = CtsMax

    @property
    def Skip(self):
        r"""偏移参数
        :rtype: int
        """
        return self._Skip

    @Skip.setter
    def Skip(self, Skip):
        self._Skip = Skip

    @property
    def Limit(self):
        r"""限制数目，category不等于threat_intelligence时，该值需要必传
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Name(self):
        r"""策略名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Sort(self):
        r"""排序参数
        :rtype: str
        """
        return self._Sort

    @Sort.setter
    def Sort(self, Sort):
        self._Sort = Sort

    @property
    def Ip(self):
        r"""IP,category传threat_intelligence的时候，该值必传
        :rtype: str
        """
        return self._Ip

    @Ip.setter
    def Ip(self, Ip):
        self._Ip = Ip

    @property
    def ValidTimeStampMin(self):
        r"""有效时间最小时间戳
        :rtype: int
        """
        return self._ValidTimeStampMin

    @ValidTimeStampMin.setter
    def ValidTimeStampMin(self, ValidTimeStampMin):
        self._ValidTimeStampMin = ValidTimeStampMin

    @property
    def ValidTimeStampMax(self):
        r"""有效时间最大时间戳
        :rtype: int
        """
        return self._ValidTimeStampMax

    @ValidTimeStampMax.setter
    def ValidTimeStampMax(self, ValidTimeStampMax):
        self._ValidTimeStampMax = ValidTimeStampMax


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Count = params.get("Count")
        self._Category = params.get("Category")
        self._VtsMin = params.get("VtsMin")
        self._VtsMax = params.get("VtsMax")
        self._CtsMin = params.get("CtsMin")
        self._CtsMax = params.get("CtsMax")
        self._Skip = params.get("Skip")
        self._Limit = params.get("Limit")
        self._Name = params.get("Name")
        self._Sort = params.get("Sort")
        self._Ip = params.get("Ip")
        self._ValidTimeStampMin = params.get("ValidTimeStampMin")
        self._ValidTimeStampMax = params.get("ValidTimeStampMax")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIpHitItemsResponse(AbstractModel):
    r"""DescribeIpHitItems返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 结果
        :type Data: :class:`tencentcloud.waf.v20180125.models.IpHitItemsData`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        r"""结果
        :rtype: :class:`tencentcloud.waf.v20180125.models.IpHitItemsData`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = IpHitItemsData()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeLogHistogramRequest(AbstractModel):
    r"""DescribeLogHistogram请求参数结构体

    """

    def __init__(self):
        r"""
        :param _From: 要查询的日志的起始时间，Unix时间戳，单位ms
        :type From: int
        :param _To: 要查询的日志的结束时间，Unix时间戳，单位ms
        :type To: int
        :param _Query: 查询语句，进行base64编码
        :type Query: str
        :param _TopicId: 日志主题ID，可以通过DescribeTopics接口获取,访问日志主题ID和攻击日志主题ID方式不同，注意DescribeTopics接口使用方法
        :type TopicId: str
        :param _Interval: 时间间隔: 单位ms  限制性条件：(To-From) / interval <= 200
        :type Interval: int
        :param _SyntaxRule: 检索语法规则，默认值为0。
0：Lucene语法，1：CQL语法。
详细说明参见<a href="https://cloud.tencent.com/document/product/614/47044#RetrievesConditionalRules" target="_blank">检索条件语法规则</a>
        :type SyntaxRule: int
        """
        self._From = None
        self._To = None
        self._Query = None
        self._TopicId = None
        self._Interval = None
        self._SyntaxRule = None

    @property
    def From(self):
        r"""要查询的日志的起始时间，Unix时间戳，单位ms
        :rtype: int
        """
        return self._From

    @From.setter
    def From(self, From):
        self._From = From

    @property
    def To(self):
        r"""要查询的日志的结束时间，Unix时间戳，单位ms
        :rtype: int
        """
        return self._To

    @To.setter
    def To(self, To):
        self._To = To

    @property
    def Query(self):
        r"""查询语句，进行base64编码
        :rtype: str
        """
        return self._Query

    @Query.setter
    def Query(self, Query):
        self._Query = Query

    @property
    def TopicId(self):
        r"""日志主题ID，可以通过DescribeTopics接口获取,访问日志主题ID和攻击日志主题ID方式不同，注意DescribeTopics接口使用方法
        :rtype: str
        """
        return self._TopicId

    @TopicId.setter
    def TopicId(self, TopicId):
        self._TopicId = TopicId

    @property
    def Interval(self):
        r"""时间间隔: 单位ms  限制性条件：(To-From) / interval <= 200
        :rtype: int
        """
        return self._Interval

    @Interval.setter
    def Interval(self, Interval):
        self._Interval = Interval

    @property
    def SyntaxRule(self):
        r"""检索语法规则，默认值为0。
0：Lucene语法，1：CQL语法。
详细说明参见<a href="https://cloud.tencent.com/document/product/614/47044#RetrievesConditionalRules" target="_blank">检索条件语法规则</a>
        :rtype: int
        """
        return self._SyntaxRule

    @SyntaxRule.setter
    def SyntaxRule(self, SyntaxRule):
        self._SyntaxRule = SyntaxRule


    def _deserialize(self, params):
        self._From = params.get("From")
        self._To = params.get("To")
        self._Query = params.get("Query")
        self._TopicId = params.get("TopicId")
        self._Interval = params.get("Interval")
        self._SyntaxRule = params.get("SyntaxRule")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLogHistogramResponse(AbstractModel):
    r"""DescribeLogHistogram返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Interval: 统计周期： 单位ms
        :type Interval: int
        :param _TotalCount: 命中关键字的日志总条数
        :type TotalCount: int
        :param _HistogramInfos: 周期内统计结果详情
        :type HistogramInfos: list of HistogramInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Interval = None
        self._TotalCount = None
        self._HistogramInfos = None
        self._RequestId = None

    @property
    def Interval(self):
        r"""统计周期： 单位ms
        :rtype: int
        """
        return self._Interval

    @Interval.setter
    def Interval(self, Interval):
        self._Interval = Interval

    @property
    def TotalCount(self):
        r"""命中关键字的日志总条数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def HistogramInfos(self):
        r"""周期内统计结果详情
        :rtype: list of HistogramInfo
        """
        return self._HistogramInfos

    @HistogramInfos.setter
    def HistogramInfos(self, HistogramInfos):
        self._HistogramInfos = HistogramInfos

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Interval = params.get("Interval")
        self._TotalCount = params.get("TotalCount")
        if params.get("HistogramInfos") is not None:
            self._HistogramInfos = []
            for item in params.get("HistogramInfos"):
                obj = HistogramInfo()
                obj._deserialize(item)
                self._HistogramInfos.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeModuleStatusRequest(AbstractModel):
    r"""DescribeModuleStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 要查询状态的域名
        :type Domain: str
        """
        self._Domain = None

    @property
    def Domain(self):
        r"""要查询状态的域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeModuleStatusResponse(AbstractModel):
    r"""DescribeModuleStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _WebSecurity: WEB安全规则是否开启
        :type WebSecurity: int
        :param _AccessControl: 访问控制规则是否开启
        :type AccessControl: int
        :param _CcProtection: CC防护是否开启
        :type CcProtection: int
        :param _AntiTamper: 网页防篡改是否开启
        :type AntiTamper: int
        :param _AntiLeakage: 信息防泄漏是否开启
        :type AntiLeakage: int
        :param _ApiProtection: API安全是否开启
        :type ApiProtection: int
        :param _RateLimit: 限流模块开关
        :type RateLimit: int
        :param _GzipAnalysis: gzip 开关
        :type GzipAnalysis: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._WebSecurity = None
        self._AccessControl = None
        self._CcProtection = None
        self._AntiTamper = None
        self._AntiLeakage = None
        self._ApiProtection = None
        self._RateLimit = None
        self._GzipAnalysis = None
        self._RequestId = None

    @property
    def WebSecurity(self):
        r"""WEB安全规则是否开启
        :rtype: int
        """
        return self._WebSecurity

    @WebSecurity.setter
    def WebSecurity(self, WebSecurity):
        self._WebSecurity = WebSecurity

    @property
    def AccessControl(self):
        r"""访问控制规则是否开启
        :rtype: int
        """
        return self._AccessControl

    @AccessControl.setter
    def AccessControl(self, AccessControl):
        self._AccessControl = AccessControl

    @property
    def CcProtection(self):
        r"""CC防护是否开启
        :rtype: int
        """
        return self._CcProtection

    @CcProtection.setter
    def CcProtection(self, CcProtection):
        self._CcProtection = CcProtection

    @property
    def AntiTamper(self):
        r"""网页防篡改是否开启
        :rtype: int
        """
        return self._AntiTamper

    @AntiTamper.setter
    def AntiTamper(self, AntiTamper):
        self._AntiTamper = AntiTamper

    @property
    def AntiLeakage(self):
        r"""信息防泄漏是否开启
        :rtype: int
        """
        return self._AntiLeakage

    @AntiLeakage.setter
    def AntiLeakage(self, AntiLeakage):
        self._AntiLeakage = AntiLeakage

    @property
    def ApiProtection(self):
        r"""API安全是否开启
        :rtype: int
        """
        return self._ApiProtection

    @ApiProtection.setter
    def ApiProtection(self, ApiProtection):
        self._ApiProtection = ApiProtection

    @property
    def RateLimit(self):
        r"""限流模块开关
        :rtype: int
        """
        return self._RateLimit

    @RateLimit.setter
    def RateLimit(self, RateLimit):
        self._RateLimit = RateLimit

    @property
    def GzipAnalysis(self):
        r"""gzip 开关
        :rtype: int
        """
        return self._GzipAnalysis

    @GzipAnalysis.setter
    def GzipAnalysis(self, GzipAnalysis):
        self._GzipAnalysis = GzipAnalysis

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._WebSecurity = params.get("WebSecurity")
        self._AccessControl = params.get("AccessControl")
        self._CcProtection = params.get("CcProtection")
        self._AntiTamper = params.get("AntiTamper")
        self._AntiLeakage = params.get("AntiLeakage")
        self._ApiProtection = params.get("ApiProtection")
        self._RateLimit = params.get("RateLimit")
        self._GzipAnalysis = params.get("GzipAnalysis")
        self._RequestId = params.get("RequestId")


class DescribeObjectsRequest(AbstractModel):
    r"""DescribeObjects请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 支持的过滤器:	ObjectId: clb实例ID	VIP: clb实例的公网IP	InstanceId: waf实例ID	Domain: 精准域名	Status: waf防护开关状态: 0关闭，1开启	ClsStatus: waf日志开关: 0关闭，1开启   
        :type Filters: list of FiltersItemNew
        :param _Order: 排序方式，支持asc或者desc
        :type Order: str
        :param _By: 根据哪个字段排序
        :type By: str
        """
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def Filters(self):
        r"""支持的过滤器:	ObjectId: clb实例ID	VIP: clb实例的公网IP	InstanceId: waf实例ID	Domain: 精准域名	Status: waf防护开关状态: 0关闭，1开启	ClsStatus: waf日志开关: 0关闭，1开启   
        :rtype: list of FiltersItemNew
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        r"""排序方式，支持asc或者desc
        :rtype: str
        """
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        r"""根据哪个字段排序
        :rtype: str
        """
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = FiltersItemNew()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeObjectsResponse(AbstractModel):
    r"""DescribeObjects返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ClbObjects: 对象列表
        :type ClbObjects: list of ClbObject
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ClbObjects = None
        self._RequestId = None

    @property
    def ClbObjects(self):
        r"""对象列表
        :rtype: list of ClbObject
        """
        return self._ClbObjects

    @ClbObjects.setter
    def ClbObjects(self, ClbObjects):
        self._ClbObjects = ClbObjects

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ClbObjects") is not None:
            self._ClbObjects = []
            for item in params.get("ClbObjects"):
                obj = ClbObject()
                obj._deserialize(item)
                self._ClbObjects.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeOwaspRuleTypesRequest(AbstractModel):
    r"""DescribeOwaspRuleTypes请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 查询域名
        :type Domain: str
        :param _Offset: 分页页数，默认为0
        :type Offset: int
        :param _Limit: 每页容量，默认为10
        :type Limit: int
        :param _Filters: 筛选条件，支持 RuleId：规则ID、CveID：CVE编号、Desc：描述
        :type Filters: list of FiltersItemNew
        """
        self._Domain = None
        self._Offset = None
        self._Limit = None
        self._Filters = None

    @property
    def Domain(self):
        r"""查询域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Offset(self):
        r"""分页页数，默认为0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""每页容量，默认为10
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        r"""筛选条件，支持 RuleId：规则ID、CveID：CVE编号、Desc：描述
        :rtype: list of FiltersItemNew
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = FiltersItemNew()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOwaspRuleTypesResponse(AbstractModel):
    r"""DescribeOwaspRuleTypes返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Total: 规则类型数量
        :type Total: int
        :param _List: 规则类型列表及信息
        :type List: list of OwaspRuleType
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Total = None
        self._List = None
        self._RequestId = None

    @property
    def Total(self):
        r"""规则类型数量
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def List(self):
        r"""规则类型列表及信息
        :rtype: list of OwaspRuleType
        """
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = OwaspRuleType()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeOwaspRulesRequest(AbstractModel):
    r"""DescribeOwaspRules请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 需要查询的域名
        :type Domain: str
        :param _Offset: 分页页数，默认为0
        :type Offset: int
        :param _Limit: 每页容量，默认为10
        :type Limit: int
        :param _By: 排序字段，支持 RuleId, UpdateTime
        :type By: str
        :param _Order: 排序方式，支持asc、desc
        :type Order: str
        :param _Filters: 筛选条件，支持 RuleId：规则ID、TypeId：规则类型、Desc：规则描述 、CveID：CVE编号、Status：规则状态、VulLevel：威胁等级
        :type Filters: list of FiltersItemNew
        """
        self._Domain = None
        self._Offset = None
        self._Limit = None
        self._By = None
        self._Order = None
        self._Filters = None

    @property
    def Domain(self):
        r"""需要查询的域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Offset(self):
        r"""分页页数，默认为0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""每页容量，默认为10
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def By(self):
        r"""排序字段，支持 RuleId, UpdateTime
        :rtype: str
        """
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        r"""排序方式，支持asc、desc
        :rtype: str
        """
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def Filters(self):
        r"""筛选条件，支持 RuleId：规则ID、TypeId：规则类型、Desc：规则描述 、CveID：CVE编号、Status：规则状态、VulLevel：威胁等级
        :rtype: list of FiltersItemNew
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._By = params.get("By")
        self._Order = params.get("Order")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = FiltersItemNew()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOwaspRulesResponse(AbstractModel):
    r"""DescribeOwaspRules返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Total: 规则总数
        :type Total: int
        :param _List: 规则列表
        :type List: list of OwaspRule
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Total = None
        self._List = None
        self._RequestId = None

    @property
    def Total(self):
        r"""规则总数
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def List(self):
        r"""规则列表
        :rtype: list of OwaspRule
        """
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = OwaspRule()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeOwaspWhiteRulesRequest(AbstractModel):
    r"""DescribeOwaspWhiteRules请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 需要查询的域名
        :type Domain: str
        :param _Offset: 分页分页，默认为0
        :type Offset: int
        :param _Limit: 每页容量，默认为10
        :type Limit: int
        :param _By: 排序的字段，支持CreateTime：新建时间、UpdateTime：修改时间
        :type By: str
        :param _Order: 排序方式，支持asc、desc
        :type Order: str
        :param _Filters: 筛选条件，支持RuleId：加白规则ID、 Name：规则名称、RuleType：加白的规则类型、Status：规则开关状态、ValidStatus：规则生效状态、TimerType：生效方式、ID：具体的加白id，根据RuleType来判断是规则id还是类型id
        :type Filters: list of FiltersItemNew
        """
        self._Domain = None
        self._Offset = None
        self._Limit = None
        self._By = None
        self._Order = None
        self._Filters = None

    @property
    def Domain(self):
        r"""需要查询的域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Offset(self):
        r"""分页分页，默认为0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""每页容量，默认为10
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def By(self):
        r"""排序的字段，支持CreateTime：新建时间、UpdateTime：修改时间
        :rtype: str
        """
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        r"""排序方式，支持asc、desc
        :rtype: str
        """
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def Filters(self):
        r"""筛选条件，支持RuleId：加白规则ID、 Name：规则名称、RuleType：加白的规则类型、Status：规则开关状态、ValidStatus：规则生效状态、TimerType：生效方式、ID：具体的加白id，根据RuleType来判断是规则id还是类型id
        :rtype: list of FiltersItemNew
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._By = params.get("By")
        self._Order = params.get("Order")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = FiltersItemNew()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOwaspWhiteRulesResponse(AbstractModel):
    r"""DescribeOwaspWhiteRules返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Total: 规则总数
        :type Total: int
        :param _List: 规则白名单列表
        :type List: list of OwaspWhiteRule
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Total = None
        self._List = None
        self._RequestId = None

    @property
    def Total(self):
        r"""规则总数
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def List(self):
        r"""规则白名单列表
        :rtype: list of OwaspWhiteRule
        """
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = OwaspWhiteRule()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribePeakPointsRequest(AbstractModel):
    r"""DescribePeakPoints请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FromTime: 查询起始时间
        :type FromTime: str
        :param _ToTime: 查询终止时间
        :type ToTime: str
        :param _Domain: 查询的域名，如果查询所有域名数据，该参数不填写
        :type Domain: str
        :param _Edition: 只有两个值有效，sparta-waf，clb-waf，不传则不过滤
        :type Edition: str
        :param _InstanceID: WAF实例ID，不传则不过滤
        :type InstanceID: str
        :param _MetricName: 十二个值可选：
access-峰值qps趋势图
botAccess- bot峰值qps趋势图
down-下行峰值带宽趋势图
up-上行峰值带宽趋势图
attack-Web攻击总数趋势图
cc-CC攻击总数趋势图
bw-黑IP攻击总数趋势图
tamper-防篡改攻击总数趋势图
leak-防泄露攻击总数趋势图
acl-访问控制攻击总数趋势图
http_status-状态码各次数趋势图
wx_access-微信小程序峰值qps趋势图
        :type MetricName: str
        """
        self._FromTime = None
        self._ToTime = None
        self._Domain = None
        self._Edition = None
        self._InstanceID = None
        self._MetricName = None

    @property
    def FromTime(self):
        r"""查询起始时间
        :rtype: str
        """
        return self._FromTime

    @FromTime.setter
    def FromTime(self, FromTime):
        self._FromTime = FromTime

    @property
    def ToTime(self):
        r"""查询终止时间
        :rtype: str
        """
        return self._ToTime

    @ToTime.setter
    def ToTime(self, ToTime):
        self._ToTime = ToTime

    @property
    def Domain(self):
        r"""查询的域名，如果查询所有域名数据，该参数不填写
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Edition(self):
        r"""只有两个值有效，sparta-waf，clb-waf，不传则不过滤
        :rtype: str
        """
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition

    @property
    def InstanceID(self):
        r"""WAF实例ID，不传则不过滤
        :rtype: str
        """
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID

    @property
    def MetricName(self):
        r"""十二个值可选：
access-峰值qps趋势图
botAccess- bot峰值qps趋势图
down-下行峰值带宽趋势图
up-上行峰值带宽趋势图
attack-Web攻击总数趋势图
cc-CC攻击总数趋势图
bw-黑IP攻击总数趋势图
tamper-防篡改攻击总数趋势图
leak-防泄露攻击总数趋势图
acl-访问控制攻击总数趋势图
http_status-状态码各次数趋势图
wx_access-微信小程序峰值qps趋势图
        :rtype: str
        """
        return self._MetricName

    @MetricName.setter
    def MetricName(self, MetricName):
        self._MetricName = MetricName


    def _deserialize(self, params):
        self._FromTime = params.get("FromTime")
        self._ToTime = params.get("ToTime")
        self._Domain = params.get("Domain")
        self._Edition = params.get("Edition")
        self._InstanceID = params.get("InstanceID")
        self._MetricName = params.get("MetricName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePeakPointsResponse(AbstractModel):
    r"""DescribePeakPoints返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Points: 数据点
        :type Points: list of PeakPointsItem
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Points = None
        self._RequestId = None

    @property
    def Points(self):
        r"""数据点
        :rtype: list of PeakPointsItem
        """
        return self._Points

    @Points.setter
    def Points(self, Points):
        self._Points = Points

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Points") is not None:
            self._Points = []
            for item in params.get("Points"):
                obj = PeakPointsItem()
                obj._deserialize(item)
                self._Points.append(obj)
        self._RequestId = params.get("RequestId")


class DescribePeakValueRequest(AbstractModel):
    r"""DescribePeakValue请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FromTime: 查询起始时间
        :type FromTime: str
        :param _ToTime: 查询结束时间
        :type ToTime: str
        :param _Domain: 需要查询的域名，当前用户所有域名可以不传
        :type Domain: str
        :param _Edition: 只有两个值有效，sparta-waf，clb-waf，不传则不过滤
        :type Edition: str
        :param _InstanceID: WAF实例ID，不传则不过滤
        :type InstanceID: str
        :param _MetricName: 五个值可选：
access-峰值qps
down-下行峰值带宽
up-上行峰值带宽
attack-Web攻击总数
cc-CC攻击总数趋势图
        :type MetricName: str
        """
        self._FromTime = None
        self._ToTime = None
        self._Domain = None
        self._Edition = None
        self._InstanceID = None
        self._MetricName = None

    @property
    def FromTime(self):
        r"""查询起始时间
        :rtype: str
        """
        return self._FromTime

    @FromTime.setter
    def FromTime(self, FromTime):
        self._FromTime = FromTime

    @property
    def ToTime(self):
        r"""查询结束时间
        :rtype: str
        """
        return self._ToTime

    @ToTime.setter
    def ToTime(self, ToTime):
        self._ToTime = ToTime

    @property
    def Domain(self):
        r"""需要查询的域名，当前用户所有域名可以不传
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Edition(self):
        r"""只有两个值有效，sparta-waf，clb-waf，不传则不过滤
        :rtype: str
        """
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition

    @property
    def InstanceID(self):
        r"""WAF实例ID，不传则不过滤
        :rtype: str
        """
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID

    @property
    def MetricName(self):
        r"""五个值可选：
access-峰值qps
down-下行峰值带宽
up-上行峰值带宽
attack-Web攻击总数
cc-CC攻击总数趋势图
        :rtype: str
        """
        return self._MetricName

    @MetricName.setter
    def MetricName(self, MetricName):
        self._MetricName = MetricName


    def _deserialize(self, params):
        self._FromTime = params.get("FromTime")
        self._ToTime = params.get("ToTime")
        self._Domain = params.get("Domain")
        self._Edition = params.get("Edition")
        self._InstanceID = params.get("InstanceID")
        self._MetricName = params.get("MetricName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePeakValueResponse(AbstractModel):
    r"""DescribePeakValue返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Access: QPS峰值
        :type Access: int
        :param _Up: 上行带宽峰值，单位B
        :type Up: int
        :param _Down: 下行带宽峰值，单位B
        :type Down: int
        :param _Attack: Web攻击总数
        :type Attack: int
        :param _Cc: CC攻击总数
        :type Cc: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Access = None
        self._Up = None
        self._Down = None
        self._Attack = None
        self._Cc = None
        self._RequestId = None

    @property
    def Access(self):
        r"""QPS峰值
        :rtype: int
        """
        return self._Access

    @Access.setter
    def Access(self, Access):
        self._Access = Access

    @property
    def Up(self):
        r"""上行带宽峰值，单位B
        :rtype: int
        """
        return self._Up

    @Up.setter
    def Up(self, Up):
        self._Up = Up

    @property
    def Down(self):
        r"""下行带宽峰值，单位B
        :rtype: int
        """
        return self._Down

    @Down.setter
    def Down(self, Down):
        self._Down = Down

    @property
    def Attack(self):
        r"""Web攻击总数
        :rtype: int
        """
        return self._Attack

    @Attack.setter
    def Attack(self, Attack):
        self._Attack = Attack

    @property
    def Cc(self):
        r"""CC攻击总数
        :rtype: int
        """
        return self._Cc

    @Cc.setter
    def Cc(self, Cc):
        self._Cc = Cc

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Access = params.get("Access")
        self._Up = params.get("Up")
        self._Down = params.get("Down")
        self._Attack = params.get("Attack")
        self._Cc = params.get("Cc")
        self._RequestId = params.get("RequestId")


class DescribePolicyStatusRequest(AbstractModel):
    r"""DescribePolicyStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _Edition: clb-waf或者saas-waf
        :type Edition: str
        """
        self._Domain = None
        self._Edition = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Edition(self):
        r"""clb-waf或者saas-waf
        :rtype: str
        """
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Edition = params.get("Edition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePolicyStatusResponse(AbstractModel):
    r"""DescribePolicyStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _InstanceId: 实例ID
        :type InstanceId: str
        :param _Status: 防护状态
        :type Status: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._InstanceId = None
        self._Status = None
        self._RequestId = None

    @property
    def InstanceId(self):
        r"""实例ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Status(self):
        r"""防护状态
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Status = params.get("Status")
        self._RequestId = params.get("RequestId")


class DescribePortsRequest(AbstractModel):
    r"""DescribePorts请求参数结构体

    """

    def __init__(self):
        r"""
        :param _InstanceID: 实例ID
        :type InstanceID: str
        :param _Edition: 实例类型
        :type Edition: str
        """
        self._InstanceID = None
        self._Edition = None

    @property
    def InstanceID(self):
        r"""实例ID
        :rtype: str
        """
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID

    @property
    def Edition(self):
        r"""实例类型
        :rtype: str
        """
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition


    def _deserialize(self, params):
        self._InstanceID = params.get("InstanceID")
        self._Edition = params.get("Edition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePortsResponse(AbstractModel):
    r"""DescribePorts返回参数结构体

    """

    def __init__(self):
        r"""
        :param _HttpPorts: http端口列表
        :type HttpPorts: list of str
        :param _HttpsPorts: https端口列表
        :type HttpsPorts: list of str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._HttpPorts = None
        self._HttpsPorts = None
        self._RequestId = None

    @property
    def HttpPorts(self):
        r"""http端口列表
        :rtype: list of str
        """
        return self._HttpPorts

    @HttpPorts.setter
    def HttpPorts(self, HttpPorts):
        self._HttpPorts = HttpPorts

    @property
    def HttpsPorts(self):
        r"""https端口列表
        :rtype: list of str
        """
        return self._HttpsPorts

    @HttpsPorts.setter
    def HttpsPorts(self, HttpsPorts):
        self._HttpsPorts = HttpsPorts

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._HttpPorts = params.get("HttpPorts")
        self._HttpsPorts = params.get("HttpsPorts")
        self._RequestId = params.get("RequestId")


class DescribePostCKafkaFlowsRequest(AbstractModel):
    r"""DescribePostCKafkaFlows请求参数结构体

    """

    def __init__(self):
        r"""
        :param _LogType: 1-访问日志，2-攻击日志，默认为访问日志。
        :type LogType: int
        """
        self._LogType = None

    @property
    def LogType(self):
        r"""1-访问日志，2-攻击日志，默认为访问日志。
        :rtype: int
        """
        return self._LogType

    @LogType.setter
    def LogType(self, LogType):
        self._LogType = LogType


    def _deserialize(self, params):
        self._LogType = params.get("LogType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePostCKafkaFlowsResponse(AbstractModel):
    r"""DescribePostCKafkaFlows返回参数结构体

    """

    def __init__(self):
        r"""
        :param _PostCKafkaFlows: 客户的投递流列表
        :type PostCKafkaFlows: list of PostCKafkaFlowInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._PostCKafkaFlows = None
        self._RequestId = None

    @property
    def PostCKafkaFlows(self):
        r"""客户的投递流列表
        :rtype: list of PostCKafkaFlowInfo
        """
        return self._PostCKafkaFlows

    @PostCKafkaFlows.setter
    def PostCKafkaFlows(self, PostCKafkaFlows):
        self._PostCKafkaFlows = PostCKafkaFlows

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("PostCKafkaFlows") is not None:
            self._PostCKafkaFlows = []
            for item in params.get("PostCKafkaFlows"):
                obj = PostCKafkaFlowInfo()
                obj._deserialize(item)
                self._PostCKafkaFlows.append(obj)
        self._RequestId = params.get("RequestId")


class DescribePostCLSFlowsRequest(AbstractModel):
    r"""DescribePostCLSFlows请求参数结构体

    """

    def __init__(self):
        r"""
        :param _LogType: 1-访问日志，2-攻击日志，默认为访问日志。
        :type LogType: int
        """
        self._LogType = None

    @property
    def LogType(self):
        r"""1-访问日志，2-攻击日志，默认为访问日志。
        :rtype: int
        """
        return self._LogType

    @LogType.setter
    def LogType(self, LogType):
        self._LogType = LogType


    def _deserialize(self, params):
        self._LogType = params.get("LogType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePostCLSFlowsResponse(AbstractModel):
    r"""DescribePostCLSFlows返回参数结构体

    """

    def __init__(self):
        r"""
        :param _PostCLSFlows: 客户的投递流列表
        :type PostCLSFlows: list of PostCLSFlowInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._PostCLSFlows = None
        self._RequestId = None

    @property
    def PostCLSFlows(self):
        r"""客户的投递流列表
        :rtype: list of PostCLSFlowInfo
        """
        return self._PostCLSFlows

    @PostCLSFlows.setter
    def PostCLSFlows(self, PostCLSFlows):
        self._PostCLSFlows = PostCLSFlows

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("PostCLSFlows") is not None:
            self._PostCLSFlows = []
            for item in params.get("PostCLSFlows"):
                obj = PostCLSFlowInfo()
                obj._deserialize(item)
                self._PostCLSFlows.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeProtectionModesRequest(AbstractModel):
    r"""DescribeProtectionModes请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Edition: sparta-waf或clb
        :type Edition: str
        :param _Domain: 域名
        :type Domain: str
        """
        self._Edition = None
        self._Domain = None

    @property
    def Edition(self):
        r"""sparta-waf或clb
        :rtype: str
        """
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain


    def _deserialize(self, params):
        self._Edition = params.get("Edition")
        self._Domain = params.get("Domain")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeProtectionModesResponse(AbstractModel):
    r"""DescribeProtectionModes返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Modes: 规则大类ID及防护模式
        :type Modes: list of TigaMainClassMode
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Modes = None
        self._RequestId = None

    @property
    def Modes(self):
        r"""规则大类ID及防护模式
        :rtype: list of TigaMainClassMode
        """
        return self._Modes

    @Modes.setter
    def Modes(self, Modes):
        self._Modes = Modes

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Modes") is not None:
            self._Modes = []
            for item in params.get("Modes"):
                obj = TigaMainClassMode()
                obj._deserialize(item)
                self._Modes.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeRuleLimitRequest(AbstractModel):
    r"""DescribeRuleLimit请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _InstanceId: 实例Id
        :type InstanceId: str
        """
        self._Domain = None
        self._InstanceId = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def InstanceId(self):
        r"""实例Id
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._InstanceId = params.get("InstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleLimitResponse(AbstractModel):
    r"""DescribeRuleLimit返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Res: waf模块的规格
        :type Res: :class:`tencentcloud.waf.v20180125.models.WafRuleLimit`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Res = None
        self._RequestId = None

    @property
    def Res(self):
        r"""waf模块的规格
        :rtype: :class:`tencentcloud.waf.v20180125.models.WafRuleLimit`
        """
        return self._Res

    @Res.setter
    def Res(self, Res):
        self._Res = Res

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Res") is not None:
            self._Res = WafRuleLimit()
            self._Res._deserialize(params.get("Res"))
        self._RequestId = params.get("RequestId")


class DescribeScanIpRequest(AbstractModel):
    r"""DescribeScanIp请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Ip: 要查询的ip地址
        :type Ip: str
        """
        self._Ip = None

    @property
    def Ip(self):
        r"""要查询的ip地址
        :rtype: str
        """
        return self._Ip

    @Ip.setter
    def Ip(self, Ip):
        self._Ip = Ip


    def _deserialize(self, params):
        self._Ip = params.get("Ip")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeScanIpResponse(AbstractModel):
    r"""DescribeScanIp返回参数结构体

    """

    def __init__(self):
        r"""
        :param _IpList: ip列表,当入参Ip为all时，返回所有已知ip列表
        :type IpList: list of ScanIpInfo
        :param _Bussiness: 所属业务
        :type Bussiness: str
        :param _Characteristic: 业务特征
        :type Characteristic: str
        :param _Descibe: 扫描说明
        :type Descibe: str
        :param _Referer: 官方公告
        :type Referer: str
        :param _Demo: 扫描示例
        :type Demo: str
        :param _Target: 扫描对象
        :type Target: str
        :param _Purpose: 扫描目的
        :type Purpose: str
        :param _Announcement: 产品文案
        :type Announcement: str
        :param _UpdateTime: 更新时间
        :type UpdateTime: int
        :param _IpOwner: ipowner
        :type IpOwner: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._IpList = None
        self._Bussiness = None
        self._Characteristic = None
        self._Descibe = None
        self._Referer = None
        self._Demo = None
        self._Target = None
        self._Purpose = None
        self._Announcement = None
        self._UpdateTime = None
        self._IpOwner = None
        self._RequestId = None

    @property
    def IpList(self):
        r"""ip列表,当入参Ip为all时，返回所有已知ip列表
        :rtype: list of ScanIpInfo
        """
        return self._IpList

    @IpList.setter
    def IpList(self, IpList):
        self._IpList = IpList

    @property
    def Bussiness(self):
        r"""所属业务
        :rtype: str
        """
        return self._Bussiness

    @Bussiness.setter
    def Bussiness(self, Bussiness):
        self._Bussiness = Bussiness

    @property
    def Characteristic(self):
        r"""业务特征
        :rtype: str
        """
        return self._Characteristic

    @Characteristic.setter
    def Characteristic(self, Characteristic):
        self._Characteristic = Characteristic

    @property
    def Descibe(self):
        r"""扫描说明
        :rtype: str
        """
        return self._Descibe

    @Descibe.setter
    def Descibe(self, Descibe):
        self._Descibe = Descibe

    @property
    def Referer(self):
        r"""官方公告
        :rtype: str
        """
        return self._Referer

    @Referer.setter
    def Referer(self, Referer):
        self._Referer = Referer

    @property
    def Demo(self):
        r"""扫描示例
        :rtype: str
        """
        return self._Demo

    @Demo.setter
    def Demo(self, Demo):
        self._Demo = Demo

    @property
    def Target(self):
        r"""扫描对象
        :rtype: str
        """
        return self._Target

    @Target.setter
    def Target(self, Target):
        self._Target = Target

    @property
    def Purpose(self):
        r"""扫描目的
        :rtype: str
        """
        return self._Purpose

    @Purpose.setter
    def Purpose(self, Purpose):
        self._Purpose = Purpose

    @property
    def Announcement(self):
        r"""产品文案
        :rtype: str
        """
        return self._Announcement

    @Announcement.setter
    def Announcement(self, Announcement):
        self._Announcement = Announcement

    @property
    def UpdateTime(self):
        r"""更新时间
        :rtype: int
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def IpOwner(self):
        r"""ipowner
        :rtype: str
        """
        return self._IpOwner

    @IpOwner.setter
    def IpOwner(self, IpOwner):
        self._IpOwner = IpOwner

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("IpList") is not None:
            self._IpList = []
            for item in params.get("IpList"):
                obj = ScanIpInfo()
                obj._deserialize(item)
                self._IpList.append(obj)
        self._Bussiness = params.get("Bussiness")
        self._Characteristic = params.get("Characteristic")
        self._Descibe = params.get("Descibe")
        self._Referer = params.get("Referer")
        self._Demo = params.get("Demo")
        self._Target = params.get("Target")
        self._Purpose = params.get("Purpose")
        self._Announcement = params.get("Announcement")
        self._UpdateTime = params.get("UpdateTime")
        self._IpOwner = params.get("IpOwner")
        self._RequestId = params.get("RequestId")


class DescribeSessionRequest(AbstractModel):
    r"""DescribeSession请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _Edition: clb-waf或者sparta-waf
        :type Edition: str
        """
        self._Domain = None
        self._Edition = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Edition(self):
        r"""clb-waf或者sparta-waf
        :rtype: str
        """
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Edition = params.get("Edition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSessionResponse(AbstractModel):
    r"""DescribeSession返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 返回结果
        :type Data: :class:`tencentcloud.waf.v20180125.models.SessionData`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        r"""返回结果
        :rtype: :class:`tencentcloud.waf.v20180125.models.SessionData`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = SessionData()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeSpartaProtectionInfoRequest(AbstractModel):
    r"""DescribeSpartaProtectionInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _Edition: 版本
        :type Edition: str
        :param _InstanceID: 实例
        :type InstanceID: str
        """
        self._Domain = None
        self._Edition = None
        self._InstanceID = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Edition(self):
        r"""版本
        :rtype: str
        """
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition

    @property
    def InstanceID(self):
        r"""实例
        :rtype: str
        """
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Edition = params.get("Edition")
        self._InstanceID = params.get("InstanceID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSpartaProtectionInfoResponse(AbstractModel):
    r"""DescribeSpartaProtectionInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _DomainId: 域名ID
        :type DomainId: str
        :param _Cname: cname取值
        :type Cname: str
        :param _Status: 状态
        :type Status: str
        :param _SrcList: 源IP地址列表
        :type SrcList: list of str
        :param _CertType: 证书类型
        :type CertType: str
        :param _Cert: 证书
        :type Cert: str
        :param _PrivateKey: 私有密钥
        :type PrivateKey: str
        :param _Sslid: ssl的id
        :type Sslid: str
        :param _IsCdn: 是否是cdn
        :type IsCdn: str
        :param _GrayAreas: 灰度区域列表
        :type GrayAreas: list of str
        :param _Engine: 引擎
        :type Engine: str
        :param _HttpsRewrite: HTTPS重写
        :type HttpsRewrite: str
        :param _UpstreamType: upstreamType取值
        :type UpstreamType: str
        :param _UpstreamDomain: upstreamDomain取值
        :type UpstreamDomain: str
        :param _UpstreamScheme: upstreamScheme取值
        :type UpstreamScheme: str
        :param _IsHttp2: 是否是HTTP2
        :type IsHttp2: str
        :param _IsWebsocket: 是否含有websocket
        :type IsWebsocket: str
        :param _LoadBalance: loadBalance信息
        :type LoadBalance: str
        :param _HttpsUpstreamPort: httpsUpstreamPort取值
        :type HttpsUpstreamPort: str
        :param _Ports: port信息
        :type Ports: list of PortItem
        :param _IsGray: 是否灰度
        :type IsGray: str
        :param _Mode: 模式
        :type Mode: str
        :param _Level: 防御等级,100,200,300
        :type Level: str
        :param _IsKeepAlive: 与源站是否保持长连接
        :type IsKeepAlive: str
        :param _Anycast: 0：BGP 1：Anycast
        :type Anycast: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Domain = None
        self._DomainId = None
        self._Cname = None
        self._Status = None
        self._SrcList = None
        self._CertType = None
        self._Cert = None
        self._PrivateKey = None
        self._Sslid = None
        self._IsCdn = None
        self._GrayAreas = None
        self._Engine = None
        self._HttpsRewrite = None
        self._UpstreamType = None
        self._UpstreamDomain = None
        self._UpstreamScheme = None
        self._IsHttp2 = None
        self._IsWebsocket = None
        self._LoadBalance = None
        self._HttpsUpstreamPort = None
        self._Ports = None
        self._IsGray = None
        self._Mode = None
        self._Level = None
        self._IsKeepAlive = None
        self._Anycast = None
        self._RequestId = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def DomainId(self):
        r"""域名ID
        :rtype: str
        """
        return self._DomainId

    @DomainId.setter
    def DomainId(self, DomainId):
        self._DomainId = DomainId

    @property
    def Cname(self):
        r"""cname取值
        :rtype: str
        """
        return self._Cname

    @Cname.setter
    def Cname(self, Cname):
        self._Cname = Cname

    @property
    def Status(self):
        r"""状态
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def SrcList(self):
        r"""源IP地址列表
        :rtype: list of str
        """
        return self._SrcList

    @SrcList.setter
    def SrcList(self, SrcList):
        self._SrcList = SrcList

    @property
    def CertType(self):
        r"""证书类型
        :rtype: str
        """
        return self._CertType

    @CertType.setter
    def CertType(self, CertType):
        self._CertType = CertType

    @property
    def Cert(self):
        r"""证书
        :rtype: str
        """
        return self._Cert

    @Cert.setter
    def Cert(self, Cert):
        self._Cert = Cert

    @property
    def PrivateKey(self):
        r"""私有密钥
        :rtype: str
        """
        return self._PrivateKey

    @PrivateKey.setter
    def PrivateKey(self, PrivateKey):
        self._PrivateKey = PrivateKey

    @property
    def Sslid(self):
        r"""ssl的id
        :rtype: str
        """
        return self._Sslid

    @Sslid.setter
    def Sslid(self, Sslid):
        self._Sslid = Sslid

    @property
    def IsCdn(self):
        r"""是否是cdn
        :rtype: str
        """
        return self._IsCdn

    @IsCdn.setter
    def IsCdn(self, IsCdn):
        self._IsCdn = IsCdn

    @property
    def GrayAreas(self):
        r"""灰度区域列表
        :rtype: list of str
        """
        return self._GrayAreas

    @GrayAreas.setter
    def GrayAreas(self, GrayAreas):
        self._GrayAreas = GrayAreas

    @property
    def Engine(self):
        r"""引擎
        :rtype: str
        """
        return self._Engine

    @Engine.setter
    def Engine(self, Engine):
        self._Engine = Engine

    @property
    def HttpsRewrite(self):
        r"""HTTPS重写
        :rtype: str
        """
        return self._HttpsRewrite

    @HttpsRewrite.setter
    def HttpsRewrite(self, HttpsRewrite):
        self._HttpsRewrite = HttpsRewrite

    @property
    def UpstreamType(self):
        r"""upstreamType取值
        :rtype: str
        """
        return self._UpstreamType

    @UpstreamType.setter
    def UpstreamType(self, UpstreamType):
        self._UpstreamType = UpstreamType

    @property
    def UpstreamDomain(self):
        r"""upstreamDomain取值
        :rtype: str
        """
        return self._UpstreamDomain

    @UpstreamDomain.setter
    def UpstreamDomain(self, UpstreamDomain):
        self._UpstreamDomain = UpstreamDomain

    @property
    def UpstreamScheme(self):
        r"""upstreamScheme取值
        :rtype: str
        """
        return self._UpstreamScheme

    @UpstreamScheme.setter
    def UpstreamScheme(self, UpstreamScheme):
        self._UpstreamScheme = UpstreamScheme

    @property
    def IsHttp2(self):
        r"""是否是HTTP2
        :rtype: str
        """
        return self._IsHttp2

    @IsHttp2.setter
    def IsHttp2(self, IsHttp2):
        self._IsHttp2 = IsHttp2

    @property
    def IsWebsocket(self):
        r"""是否含有websocket
        :rtype: str
        """
        return self._IsWebsocket

    @IsWebsocket.setter
    def IsWebsocket(self, IsWebsocket):
        self._IsWebsocket = IsWebsocket

    @property
    def LoadBalance(self):
        r"""loadBalance信息
        :rtype: str
        """
        return self._LoadBalance

    @LoadBalance.setter
    def LoadBalance(self, LoadBalance):
        self._LoadBalance = LoadBalance

    @property
    def HttpsUpstreamPort(self):
        r"""httpsUpstreamPort取值
        :rtype: str
        """
        return self._HttpsUpstreamPort

    @HttpsUpstreamPort.setter
    def HttpsUpstreamPort(self, HttpsUpstreamPort):
        self._HttpsUpstreamPort = HttpsUpstreamPort

    @property
    def Ports(self):
        r"""port信息
        :rtype: list of PortItem
        """
        return self._Ports

    @Ports.setter
    def Ports(self, Ports):
        self._Ports = Ports

    @property
    def IsGray(self):
        r"""是否灰度
        :rtype: str
        """
        return self._IsGray

    @IsGray.setter
    def IsGray(self, IsGray):
        self._IsGray = IsGray

    @property
    def Mode(self):
        r"""模式
        :rtype: str
        """
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode

    @property
    def Level(self):
        r"""防御等级,100,200,300
        :rtype: str
        """
        return self._Level

    @Level.setter
    def Level(self, Level):
        self._Level = Level

    @property
    def IsKeepAlive(self):
        r"""与源站是否保持长连接
        :rtype: str
        """
        return self._IsKeepAlive

    @IsKeepAlive.setter
    def IsKeepAlive(self, IsKeepAlive):
        self._IsKeepAlive = IsKeepAlive

    @property
    def Anycast(self):
        r"""0：BGP 1：Anycast
        :rtype: str
        """
        return self._Anycast

    @Anycast.setter
    def Anycast(self, Anycast):
        self._Anycast = Anycast

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._DomainId = params.get("DomainId")
        self._Cname = params.get("Cname")
        self._Status = params.get("Status")
        self._SrcList = params.get("SrcList")
        self._CertType = params.get("CertType")
        self._Cert = params.get("Cert")
        self._PrivateKey = params.get("PrivateKey")
        self._Sslid = params.get("Sslid")
        self._IsCdn = params.get("IsCdn")
        self._GrayAreas = params.get("GrayAreas")
        self._Engine = params.get("Engine")
        self._HttpsRewrite = params.get("HttpsRewrite")
        self._UpstreamType = params.get("UpstreamType")
        self._UpstreamDomain = params.get("UpstreamDomain")
        self._UpstreamScheme = params.get("UpstreamScheme")
        self._IsHttp2 = params.get("IsHttp2")
        self._IsWebsocket = params.get("IsWebsocket")
        self._LoadBalance = params.get("LoadBalance")
        self._HttpsUpstreamPort = params.get("HttpsUpstreamPort")
        if params.get("Ports") is not None:
            self._Ports = []
            for item in params.get("Ports"):
                obj = PortItem()
                obj._deserialize(item)
                self._Ports.append(obj)
        self._IsGray = params.get("IsGray")
        self._Mode = params.get("Mode")
        self._Level = params.get("Level")
        self._IsKeepAlive = params.get("IsKeepAlive")
        self._Anycast = params.get("Anycast")
        self._RequestId = params.get("RequestId")


class DescribeTlsVersionRequest(AbstractModel):
    r"""DescribeTlsVersion请求参数结构体

    """


class DescribeTlsVersionResponse(AbstractModel):
    r"""DescribeTlsVersion返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TLS: TLS信息
        :type TLS: list of TLSVersion
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TLS = None
        self._RequestId = None

    @property
    def TLS(self):
        r"""TLS信息
        :rtype: list of TLSVersion
        """
        return self._TLS

    @TLS.setter
    def TLS(self, TLS):
        self._TLS = TLS

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TLS") is not None:
            self._TLS = []
            for item in params.get("TLS"):
                obj = TLSVersion()
                obj._deserialize(item)
                self._TLS.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTopAttackDomainRequest(AbstractModel):
    r"""DescribeTopAttackDomain请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FromTime: 查询起始时间
        :type FromTime: str
        :param _ToTime: 查询结束时间
        :type ToTime: str
        :param _Count: TOP N,可从0-10选择，默认是10
        :type Count: int
        :param _Edition: 只有两个值有效，sparta-waf，clb-waf，不传则不过滤
        :type Edition: str
        :param _InstanceID: WAF实例ID，不传则不过滤
        :type InstanceID: str
        """
        self._FromTime = None
        self._ToTime = None
        self._Count = None
        self._Edition = None
        self._InstanceID = None

    @property
    def FromTime(self):
        r"""查询起始时间
        :rtype: str
        """
        return self._FromTime

    @FromTime.setter
    def FromTime(self, FromTime):
        self._FromTime = FromTime

    @property
    def ToTime(self):
        r"""查询结束时间
        :rtype: str
        """
        return self._ToTime

    @ToTime.setter
    def ToTime(self, ToTime):
        self._ToTime = ToTime

    @property
    def Count(self):
        r"""TOP N,可从0-10选择，默认是10
        :rtype: int
        """
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def Edition(self):
        r"""只有两个值有效，sparta-waf，clb-waf，不传则不过滤
        :rtype: str
        """
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition

    @property
    def InstanceID(self):
        r"""WAF实例ID，不传则不过滤
        :rtype: str
        """
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID


    def _deserialize(self, params):
        self._FromTime = params.get("FromTime")
        self._ToTime = params.get("ToTime")
        self._Count = params.get("Count")
        self._Edition = params.get("Edition")
        self._InstanceID = params.get("InstanceID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTopAttackDomainResponse(AbstractModel):
    r"""DescribeTopAttackDomain返回参数结构体

    """

    def __init__(self):
        r"""
        :param _CC: CC攻击域名列表
        :type CC: list of KVInt
        :param _Web: Web攻击域名列表
        :type Web: list of KVInt
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._CC = None
        self._Web = None
        self._RequestId = None

    @property
    def CC(self):
        r"""CC攻击域名列表
        :rtype: list of KVInt
        """
        return self._CC

    @CC.setter
    def CC(self, CC):
        self._CC = CC

    @property
    def Web(self):
        r"""Web攻击域名列表
        :rtype: list of KVInt
        """
        return self._Web

    @Web.setter
    def Web(self, Web):
        self._Web = Web

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("CC") is not None:
            self._CC = []
            for item in params.get("CC"):
                obj = KVInt()
                obj._deserialize(item)
                self._CC.append(obj)
        if params.get("Web") is not None:
            self._Web = []
            for item in params.get("Web"):
                obj = KVInt()
                obj._deserialize(item)
                self._Web.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTopicsRequest(AbstractModel):
    r"""DescribeTopics请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: <ul><li>topicName 按照【日志主题名称】进行过滤，默认为模糊匹配，Filter.Values 当要查询访问日志时为access，查询攻击日志时为attack</li></ul>注意：每次请求的 Filters 的上限为10，Filter.Values 的上限为100。
        :type Filters: list of FilterCls
        :param _Offset: 分页的偏移量，默认值为0。
        :type Offset: int
        :param _Limit: 分页单页限制数目，默认值为20，最大值100。
        :type Limit: int
        :param _PreciseSearch: 控制Filters相关字段是否为精确匹配。
<ul><li>0: 默认值，topicName 和 logsetName 模糊匹配</li>
<li>1: topicName   精确匹配</li>
<li>2: logsetName精确匹配</li>
<li>3: topicName 和logsetName 都精确匹配</li></ul>
        :type PreciseSearch: int
        :param _BizType: 主题类型
<ul><li>0:日志主题，默认值</li>
<li>1:指标主题</li></ul>
        :type BizType: int
        """
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._PreciseSearch = None
        self._BizType = None

    @property
    def Filters(self):
        r"""<ul><li>topicName 按照【日志主题名称】进行过滤，默认为模糊匹配，Filter.Values 当要查询访问日志时为access，查询攻击日志时为attack</li></ul>注意：每次请求的 Filters 的上限为10，Filter.Values 的上限为100。
        :rtype: list of FilterCls
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        r"""分页的偏移量，默认值为0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""分页单页限制数目，默认值为20，最大值100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def PreciseSearch(self):
        r"""控制Filters相关字段是否为精确匹配。
<ul><li>0: 默认值，topicName 和 logsetName 模糊匹配</li>
<li>1: topicName   精确匹配</li>
<li>2: logsetName精确匹配</li>
<li>3: topicName 和logsetName 都精确匹配</li></ul>
        :rtype: int
        """
        return self._PreciseSearch

    @PreciseSearch.setter
    def PreciseSearch(self, PreciseSearch):
        self._PreciseSearch = PreciseSearch

    @property
    def BizType(self):
        r"""主题类型
<ul><li>0:日志主题，默认值</li>
<li>1:指标主题</li></ul>
        :rtype: int
        """
        return self._BizType

    @BizType.setter
    def BizType(self, BizType):
        self._BizType = BizType


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = FilterCls()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._PreciseSearch = params.get("PreciseSearch")
        self._BizType = params.get("BizType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTopicsResponse(AbstractModel):
    r"""DescribeTopics返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Topics: 日志主题列表
        :type Topics: list of TopicInfo
        :param _TotalCount: 总数目
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Topics = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def Topics(self):
        r"""日志主题列表
        :rtype: list of TopicInfo
        """
        return self._Topics

    @Topics.setter
    def Topics(self, Topics):
        self._Topics = Topics

    @property
    def TotalCount(self):
        r"""总数目
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Topics") is not None:
            self._Topics = []
            for item in params.get("Topics"):
                obj = TopicInfo()
                obj._deserialize(item)
                self._Topics.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeUserCdcClbWafRegionsRequest(AbstractModel):
    r"""DescribeUserCdcClbWafRegions请求参数结构体

    """


class DescribeUserCdcClbWafRegionsResponse(AbstractModel):
    r"""DescribeUserCdcClbWafRegions返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: CdcRegion的类型描述
        :type Data: list of CdcRegion
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        r"""CdcRegion的类型描述
        :rtype: list of CdcRegion
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = CdcRegion()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeUserClbWafRegionsRequest(AbstractModel):
    r"""DescribeUserClbWafRegions请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AlbType: 流量来源，不填默认clb。clb：负载均衡器，tsegw：云原生API网关，scf：云函数，apisix：腾讯云上其他网关
        :type AlbType: str
        """
        self._AlbType = None

    @property
    def AlbType(self):
        r"""流量来源，不填默认clb。clb：负载均衡器，tsegw：云原生API网关，scf：云函数，apisix：腾讯云上其他网关
        :rtype: str
        """
        return self._AlbType

    @AlbType.setter
    def AlbType(self, AlbType):
        self._AlbType = AlbType


    def _deserialize(self, params):
        self._AlbType = params.get("AlbType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeUserClbWafRegionsResponse(AbstractModel):
    r"""DescribeUserClbWafRegions返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 地域（标准的ap-格式）列表
        :type Data: list of str
        :param _RichDatas: 包含详细属性的地域信息
        :type RichDatas: list of ClbWafRegionItem
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RichDatas = None
        self._RequestId = None

    @property
    def Data(self):
        r"""地域（标准的ap-格式）列表
        :rtype: list of str
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RichDatas(self):
        r"""包含详细属性的地域信息
        :rtype: list of ClbWafRegionItem
        """
        return self._RichDatas

    @RichDatas.setter
    def RichDatas(self, RichDatas):
        self._RichDatas = RichDatas

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        if params.get("RichDatas") is not None:
            self._RichDatas = []
            for item in params.get("RichDatas"):
                obj = ClbWafRegionItem()
                obj._deserialize(item)
                self._RichDatas.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeUserDomainInfoRequest(AbstractModel):
    r"""DescribeUserDomainInfo请求参数结构体

    """


class DescribeUserDomainInfoResponse(AbstractModel):
    r"""DescribeUserDomainInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _UsersInfo: saas和clb域名信息
        :type UsersInfo: list of UserDomainInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._UsersInfo = None
        self._RequestId = None

    @property
    def UsersInfo(self):
        r"""saas和clb域名信息
        :rtype: list of UserDomainInfo
        """
        return self._UsersInfo

    @UsersInfo.setter
    def UsersInfo(self, UsersInfo):
        self._UsersInfo = UsersInfo

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("UsersInfo") is not None:
            self._UsersInfo = []
            for item in params.get("UsersInfo"):
                obj = UserDomainInfo()
                obj._deserialize(item)
                self._UsersInfo.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeUserLevelRequest(AbstractModel):
    r"""DescribeUserLevel请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        """
        self._Domain = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeUserLevelResponse(AbstractModel):
    r"""DescribeUserLevel返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Level: 300:正常 400:严格
        :type Level: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Level = None
        self._RequestId = None

    @property
    def Level(self):
        r"""300:正常 400:严格
        :rtype: int
        """
        return self._Level

    @Level.setter
    def Level(self, Level):
        self._Level = Level

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Level = params.get("Level")
        self._RequestId = params.get("RequestId")


class DescribeUserSignatureClassRequest(AbstractModel):
    r"""DescribeUserSignatureClass请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 查询域名
        :type Domain: str
        """
        self._Domain = None

    @property
    def Domain(self):
        r"""查询域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeUserSignatureClassResponse(AbstractModel):
    r"""DescribeUserSignatureClass返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Total: 规则类型数量
        :type Total: int
        :param _RuleTypeList: 规则类型列表及信息
        :type RuleTypeList: list of RuleType
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Total = None
        self._RuleTypeList = None
        self._RequestId = None

    @property
    def Total(self):
        r"""规则类型数量
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RuleTypeList(self):
        r"""规则类型列表及信息
        :rtype: list of RuleType
        """
        return self._RuleTypeList

    @RuleTypeList.setter
    def RuleTypeList(self, RuleTypeList):
        self._RuleTypeList = RuleTypeList

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("RuleTypeList") is not None:
            self._RuleTypeList = []
            for item in params.get("RuleTypeList"):
                obj = RuleType()
                obj._deserialize(item)
                self._RuleTypeList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeUserSignatureRuleRequest(AbstractModel):
    r"""DescribeUserSignatureRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 需要查询的域名
        :type Domain: str
        :param _Offset: 分页
        :type Offset: int
        :param _Limit: 每页容量
        :type Limit: int
        :param _By: 排序字段，支持 signature_id, modify_time
        :type By: str
        :param _Order: 排序方式
        :type Order: str
        :param _Filters: 筛选条件，支持 MainClassName，SubClassID ,CveID, Status, ID;  ID为规则id
        :type Filters: list of FiltersItemNew
        """
        self._Domain = None
        self._Offset = None
        self._Limit = None
        self._By = None
        self._Order = None
        self._Filters = None

    @property
    def Domain(self):
        r"""需要查询的域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Offset(self):
        r"""分页
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""每页容量
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def By(self):
        r"""排序字段，支持 signature_id, modify_time
        :rtype: str
        """
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        r"""排序方式
        :rtype: str
        """
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def Filters(self):
        r"""筛选条件，支持 MainClassName，SubClassID ,CveID, Status, ID;  ID为规则id
        :rtype: list of FiltersItemNew
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._By = params.get("By")
        self._Order = params.get("Order")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = FiltersItemNew()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeUserSignatureRuleResponse(AbstractModel):
    r"""DescribeUserSignatureRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Total: 规则总数
        :type Total: int
        :param _Rules: 规则列表
        :type Rules: list of UserSignatureRule
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Total = None
        self._Rules = None
        self._RequestId = None

    @property
    def Total(self):
        r"""规则总数
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def Rules(self):
        r"""规则列表
        :rtype: list of UserSignatureRule
        """
        return self._Rules

    @Rules.setter
    def Rules(self, Rules):
        self._Rules = Rules

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("Rules") is not None:
            self._Rules = []
            for item in params.get("Rules"):
                obj = UserSignatureRule()
                obj._deserialize(item)
                self._Rules.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeUserSignatureRuleV2Request(AbstractModel):
    r"""DescribeUserSignatureRuleV2请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 需要查询的域名
        :type Domain: str
        :param _Offset: 分页
        :type Offset: int
        :param _Limit: 每页容量
        :type Limit: int
        :param _By: 排序字段，支持 signature_id, modify_time
        :type By: str
        :param _Order: 排序方式
        :type Order: str
        :param _Filters: 筛选条件，支持 MainClassName，SubClassID ,CveID, Status, ID;  ID为规则id
        :type Filters: list of FiltersItemNew
        """
        self._Domain = None
        self._Offset = None
        self._Limit = None
        self._By = None
        self._Order = None
        self._Filters = None

    @property
    def Domain(self):
        r"""需要查询的域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Offset(self):
        r"""分页
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""每页容量
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def By(self):
        r"""排序字段，支持 signature_id, modify_time
        :rtype: str
        """
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        r"""排序方式
        :rtype: str
        """
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def Filters(self):
        r"""筛选条件，支持 MainClassName，SubClassID ,CveID, Status, ID;  ID为规则id
        :rtype: list of FiltersItemNew
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._By = params.get("By")
        self._Order = params.get("Order")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = FiltersItemNew()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeUserSignatureRuleV2Response(AbstractModel):
    r"""DescribeUserSignatureRuleV2返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Total: 规则总数
        :type Total: int
        :param _Rules: 规则列表
        :type Rules: list of UserSignatureRule
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Total = None
        self._Rules = None
        self._RequestId = None

    @property
    def Total(self):
        r"""规则总数
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def Rules(self):
        r"""规则列表
        :rtype: list of UserSignatureRule
        """
        return self._Rules

    @Rules.setter
    def Rules(self, Rules):
        self._Rules = Rules

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("Rules") is not None:
            self._Rules = []
            for item in params.get("Rules"):
                obj = UserSignatureRule()
                obj._deserialize(item)
                self._Rules.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeVipInfoRequest(AbstractModel):
    r"""DescribeVipInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _InstanceIds: waf实例id列表
        :type InstanceIds: list of str
        """
        self._InstanceIds = None

    @property
    def InstanceIds(self):
        r"""waf实例id列表
        :rtype: list of str
        """
        return self._InstanceIds

    @InstanceIds.setter
    def InstanceIds(self, InstanceIds):
        self._InstanceIds = InstanceIds


    def _deserialize(self, params):
        self._InstanceIds = params.get("InstanceIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVipInfoResponse(AbstractModel):
    r"""DescribeVipInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _VipInfo: VIP信息
        :type VipInfo: list of VipInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._VipInfo = None
        self._RequestId = None

    @property
    def VipInfo(self):
        r"""VIP信息
        :rtype: list of VipInfo
        """
        return self._VipInfo

    @VipInfo.setter
    def VipInfo(self, VipInfo):
        self._VipInfo = VipInfo

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("VipInfo") is not None:
            self._VipInfo = []
            for item in params.get("VipInfo"):
                obj = VipInfo()
                obj._deserialize(item)
                self._VipInfo.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeWafAutoDenyRulesRequest(AbstractModel):
    r"""DescribeWafAutoDenyRules请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _InstanceId: 实例Id
        :type InstanceId: str
        """
        self._Domain = None
        self._InstanceId = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def InstanceId(self):
        r"""实例Id
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._InstanceId = params.get("InstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeWafAutoDenyRulesResponse(AbstractModel):
    r"""DescribeWafAutoDenyRules返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AttackThreshold: 攻击次数阈值
        :type AttackThreshold: int
        :param _TimeThreshold: 攻击时间阈值
        :type TimeThreshold: int
        :param _DenyTimeThreshold: 自动封禁时间
        :type DenyTimeThreshold: int
        :param _DefenseStatus: 自动封禁状态
        :type DefenseStatus: int
        :param _Source: 数据来源Source字段 custom-自定义(默认)、batch-domain-批量域名

        :type Source: str
        :param _HWState: 重保护网域名状态
        :type HWState: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AttackThreshold = None
        self._TimeThreshold = None
        self._DenyTimeThreshold = None
        self._DefenseStatus = None
        self._Source = None
        self._HWState = None
        self._RequestId = None

    @property
    def AttackThreshold(self):
        r"""攻击次数阈值
        :rtype: int
        """
        return self._AttackThreshold

    @AttackThreshold.setter
    def AttackThreshold(self, AttackThreshold):
        self._AttackThreshold = AttackThreshold

    @property
    def TimeThreshold(self):
        r"""攻击时间阈值
        :rtype: int
        """
        return self._TimeThreshold

    @TimeThreshold.setter
    def TimeThreshold(self, TimeThreshold):
        self._TimeThreshold = TimeThreshold

    @property
    def DenyTimeThreshold(self):
        r"""自动封禁时间
        :rtype: int
        """
        return self._DenyTimeThreshold

    @DenyTimeThreshold.setter
    def DenyTimeThreshold(self, DenyTimeThreshold):
        self._DenyTimeThreshold = DenyTimeThreshold

    @property
    def DefenseStatus(self):
        r"""自动封禁状态
        :rtype: int
        """
        return self._DefenseStatus

    @DefenseStatus.setter
    def DefenseStatus(self, DefenseStatus):
        self._DefenseStatus = DefenseStatus

    @property
    def Source(self):
        r"""数据来源Source字段 custom-自定义(默认)、batch-domain-批量域名

        :rtype: str
        """
        return self._Source

    @Source.setter
    def Source(self, Source):
        self._Source = Source

    @property
    def HWState(self):
        r"""重保护网域名状态
        :rtype: int
        """
        return self._HWState

    @HWState.setter
    def HWState(self, HWState):
        self._HWState = HWState

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AttackThreshold = params.get("AttackThreshold")
        self._TimeThreshold = params.get("TimeThreshold")
        self._DenyTimeThreshold = params.get("DenyTimeThreshold")
        self._DefenseStatus = params.get("DefenseStatus")
        self._Source = params.get("Source")
        self._HWState = params.get("HWState")
        self._RequestId = params.get("RequestId")


class DescribeWafAutoDenyStatusRequest(AbstractModel):
    r"""DescribeWafAutoDenyStatus请求参数结构体

    """


class DescribeWafAutoDenyStatusResponse(AbstractModel):
    r"""DescribeWafAutoDenyStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _WafAutoDenyDetails: WAF 自动封禁详情
        :type WafAutoDenyDetails: :class:`tencentcloud.waf.v20180125.models.AutoDenyDetail`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._WafAutoDenyDetails = None
        self._RequestId = None

    @property
    def WafAutoDenyDetails(self):
        r"""WAF 自动封禁详情
        :rtype: :class:`tencentcloud.waf.v20180125.models.AutoDenyDetail`
        """
        return self._WafAutoDenyDetails

    @WafAutoDenyDetails.setter
    def WafAutoDenyDetails(self, WafAutoDenyDetails):
        self._WafAutoDenyDetails = WafAutoDenyDetails

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("WafAutoDenyDetails") is not None:
            self._WafAutoDenyDetails = AutoDenyDetail()
            self._WafAutoDenyDetails._deserialize(params.get("WafAutoDenyDetails"))
        self._RequestId = params.get("RequestId")


class DescribeWafThreatenIntelligenceRequest(AbstractModel):
    r"""DescribeWafThreatenIntelligence请求参数结构体

    """


class DescribeWafThreatenIntelligenceResponse(AbstractModel):
    r"""DescribeWafThreatenIntelligence返回参数结构体

    """

    def __init__(self):
        r"""
        :param _WafThreatenIntelligenceDetails: WAF 威胁情报封禁信息
        :type WafThreatenIntelligenceDetails: :class:`tencentcloud.waf.v20180125.models.WafThreatenIntelligenceDetails`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._WafThreatenIntelligenceDetails = None
        self._RequestId = None

    @property
    def WafThreatenIntelligenceDetails(self):
        r"""WAF 威胁情报封禁信息
        :rtype: :class:`tencentcloud.waf.v20180125.models.WafThreatenIntelligenceDetails`
        """
        return self._WafThreatenIntelligenceDetails

    @WafThreatenIntelligenceDetails.setter
    def WafThreatenIntelligenceDetails(self, WafThreatenIntelligenceDetails):
        self._WafThreatenIntelligenceDetails = WafThreatenIntelligenceDetails

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("WafThreatenIntelligenceDetails") is not None:
            self._WafThreatenIntelligenceDetails = WafThreatenIntelligenceDetails()
            self._WafThreatenIntelligenceDetails._deserialize(params.get("WafThreatenIntelligenceDetails"))
        self._RequestId = params.get("RequestId")


class DescribeWebshellStatusRequest(AbstractModel):
    r"""DescribeWebshellStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        """
        self._Domain = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeWebshellStatusResponse(AbstractModel):
    r"""DescribeWebshellStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: webshell域名
        :type Domain: str
        :param _Status: 开关状态
        :type Status: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Domain = None
        self._Status = None
        self._RequestId = None

    @property
    def Domain(self):
        r"""webshell域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Status(self):
        r"""开关状态
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Status = params.get("Status")
        self._RequestId = params.get("RequestId")


class DestroyPostCKafkaFlowRequest(AbstractModel):
    r"""DestroyPostCKafkaFlow请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FlowId: 投递流的流ID
        :type FlowId: int
        :param _LogType: 1-访问日志，2-攻击日志，默认为访问日志。
        :type LogType: int
        """
        self._FlowId = None
        self._LogType = None

    @property
    def FlowId(self):
        r"""投递流的流ID
        :rtype: int
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def LogType(self):
        r"""1-访问日志，2-攻击日志，默认为访问日志。
        :rtype: int
        """
        return self._LogType

    @LogType.setter
    def LogType(self, LogType):
        self._LogType = LogType


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        self._LogType = params.get("LogType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DestroyPostCKafkaFlowResponse(AbstractModel):
    r"""DestroyPostCKafkaFlow返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DestroyPostCLSFlowRequest(AbstractModel):
    r"""DestroyPostCLSFlow请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FlowId: 投递流的流ID
        :type FlowId: int
        :param _LogType: 1-访问日志，2-攻击日志，默认为访问日志。
        :type LogType: int
        """
        self._FlowId = None
        self._LogType = None

    @property
    def FlowId(self):
        r"""投递流的流ID
        :rtype: int
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def LogType(self):
        r"""1-访问日志，2-攻击日志，默认为访问日志。
        :rtype: int
        """
        return self._LogType

    @LogType.setter
    def LogType(self, LogType):
        self._LogType = LogType


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        self._LogType = params.get("LogType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DestroyPostCLSFlowResponse(AbstractModel):
    r"""DestroyPostCLSFlow返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DomainInfo(AbstractModel):
    r"""domain列表

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _DomainId: 域名ID
        :type DomainId: str
        :param _InstanceId: 实例ID
        :type InstanceId: str
        :param _Cname: cname地址
        :type Cname: str
        :param _Edition: 域名所属实例类型。
sparta-waf：SaaS型WAF实例
clb-waf：负载均衡型WAF实例
cdc-clb-waf：CDC环境下负载均衡型WAF实例
        :type Edition: str
        :param _Region: 地域。
"多伦多": "ca"
"广州": "gz"
"成都": "cd"
"福州": "fzec"
"深圳": "szx"
"印度": "in"
"济南": "jnec"
"重庆": "cq"
"天津": "tsn"
"欧洲东北": "ru"
"南京": "nj"
"美国硅谷": "usw"
"泰国": "th"
"广州Open": "gzopen"
"深圳金融": "szjr"
"法兰克福": "de"
"日本": "jp"
"弗吉尼亚": "use"
"北京": "bj"
"中国香港": "hk"
"杭州": "hzec"
"北京金融": "bjjr"
"上海金融": "shjr"
"台北": "tpe"
"首尔": "kr"
"上海": "sh"
"新加坡": "sg"
"清远": "qy"
        :type Region: str
        :param _InstanceName: 实例名
        :type InstanceName: str
        :param _ClsStatus: 访问日志开关状态。
0：关闭
1：开启
        :type ClsStatus: int
        :param _FlowMode: 负载均衡型WAF使用模式。
0：镜像模式 
1：清洗模式
        :type FlowMode: int
        :param _Status: waf开关状态。
0：关闭 
1：开启
        :type Status: int
        :param _Mode: 规则引擎防护模式。
0：观察模式 
1：拦截模式
        :type Mode: int
        :param _Engine: 规则引擎和AI引擎防护模式联合状态。
1:初始状态,规则引擎拦截&&AI引擎未操作开关状态
10：规则引擎观察&&AI引擎关闭模式 
11：规则引擎观察&&AI引擎观察模式 
12：规则引擎观察&&AI引擎拦截模式 
20：规则引擎拦截&&AI引擎关闭模式 
21：规则引擎拦截&&AI引擎观察模式 
22：规则引擎拦截&&AI引擎拦截模式
        :type Engine: int
        :param _CCList: 沙箱集群回源出口IP列表
        :type CCList: list of str
        :param _RsList: 生产集群回源出口IP列表
        :type RsList: list of str
        :param _Ports: 服务端口配置
        :type Ports: list of PortInfo
        :param _LoadBalancerSet: 负载均衡器相关配置
        :type LoadBalancerSet: list of LoadBalancerPackageNew
        :param _AppId: 用户id
        :type AppId: int
        :param _State: SAAS型WAF域名状态：
-2：配置下发失败
-1：配置下发中
0：DNS解析中
1：无DNS解析记录，请接入WAF
10：DNS解析未知，域名启用了代理
11：DNS解析异常，使用A记录接入WAF IP
200：检测源站不可达
220：源站不支持长连接
311：证书过期
312：证书即将过期
310：证书异常
316：备案异常
5：WAF回源已变更
负载均衡型WAF域名LB监听器状态：
0：操作成功 
4：正在绑定LB 
6：正在解绑LB 
7：解绑LB失败 
8：绑定LB失败 
10：内部错误
        :type State: int
        :param _CreateTime: 创建时间
        :type CreateTime: str
        :param _Ipv6Status: Ipv6开关状态。
0：关闭 
1：开启
        :type Ipv6Status: int
        :param _BotStatus: BOT开关状态。
0：关闭 
1：关闭
2：开启
3：开启
        :type BotStatus: int
        :param _Level: 实例版本信息。
101：小微敏捷版 
102：小微超轻版
2：高级版
3：企业版
4：旗舰版
6：独享版
        :type Level: int
        :param _PostCLSStatus: 投递CLS状态。
0：关闭 
1：开启
        :type PostCLSStatus: int
        :param _PostCKafkaStatus: 投递CKafka状态。
0：关闭 
1：开启
        :type PostCKafkaStatus: int
        :param _CdcClusters: cdc实例域名接入的集群信息,非cdc实例忽略。
        :type CdcClusters: str
        :param _ApiStatus: api安全开关状态。
0：关闭 
1：开启
        :type ApiStatus: int
        :param _AlbType: 应用型负载均衡类型，默认clb。
clb：七层负载均衡器类型
apisix：apisix网关型
        :type AlbType: str
        :param _SgState: 安全组状态。
0：不展示
1：非腾讯云源站
2：安全组绑定失败
3：安全组发生变更
        :type SgState: int
        :param _SgDetail: 安全组状态的详细解释
        :type SgDetail: str
        :param _CloudType: 域名云环境。hybrid：混合云域名
public：公有云域名
        :type CloudType: str
        :param _Note: 域名备注信息
        :type Note: str
        :param _SrcList: SAASWAF源站IP列表
        :type SrcList: list of str
        :param _UpstreamDomainList: SAASWAF源站域名列表
        :type UpstreamDomainList: list of str
        :param _SgID: 安全组ID
        :type SgID: str
        :param _AccessStatus: clbwaf接入状态，0代表“尚无流量接入”，1代表“流量接入”，2代表“CLB监听器已注销”，3代表“配置生效中”，4代表“配置下发失败中”
        :type AccessStatus: int
        :param _Labels: 域名标签
        :type Labels: list of str
        """
        self._Domain = None
        self._DomainId = None
        self._InstanceId = None
        self._Cname = None
        self._Edition = None
        self._Region = None
        self._InstanceName = None
        self._ClsStatus = None
        self._FlowMode = None
        self._Status = None
        self._Mode = None
        self._Engine = None
        self._CCList = None
        self._RsList = None
        self._Ports = None
        self._LoadBalancerSet = None
        self._AppId = None
        self._State = None
        self._CreateTime = None
        self._Ipv6Status = None
        self._BotStatus = None
        self._Level = None
        self._PostCLSStatus = None
        self._PostCKafkaStatus = None
        self._CdcClusters = None
        self._ApiStatus = None
        self._AlbType = None
        self._SgState = None
        self._SgDetail = None
        self._CloudType = None
        self._Note = None
        self._SrcList = None
        self._UpstreamDomainList = None
        self._SgID = None
        self._AccessStatus = None
        self._Labels = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def DomainId(self):
        r"""域名ID
        :rtype: str
        """
        return self._DomainId

    @DomainId.setter
    def DomainId(self, DomainId):
        self._DomainId = DomainId

    @property
    def InstanceId(self):
        r"""实例ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Cname(self):
        r"""cname地址
        :rtype: str
        """
        return self._Cname

    @Cname.setter
    def Cname(self, Cname):
        self._Cname = Cname

    @property
    def Edition(self):
        r"""域名所属实例类型。
sparta-waf：SaaS型WAF实例
clb-waf：负载均衡型WAF实例
cdc-clb-waf：CDC环境下负载均衡型WAF实例
        :rtype: str
        """
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition

    @property
    def Region(self):
        r"""地域。
"多伦多": "ca"
"广州": "gz"
"成都": "cd"
"福州": "fzec"
"深圳": "szx"
"印度": "in"
"济南": "jnec"
"重庆": "cq"
"天津": "tsn"
"欧洲东北": "ru"
"南京": "nj"
"美国硅谷": "usw"
"泰国": "th"
"广州Open": "gzopen"
"深圳金融": "szjr"
"法兰克福": "de"
"日本": "jp"
"弗吉尼亚": "use"
"北京": "bj"
"中国香港": "hk"
"杭州": "hzec"
"北京金融": "bjjr"
"上海金融": "shjr"
"台北": "tpe"
"首尔": "kr"
"上海": "sh"
"新加坡": "sg"
"清远": "qy"
        :rtype: str
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def InstanceName(self):
        r"""实例名
        :rtype: str
        """
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def ClsStatus(self):
        r"""访问日志开关状态。
0：关闭
1：开启
        :rtype: int
        """
        return self._ClsStatus

    @ClsStatus.setter
    def ClsStatus(self, ClsStatus):
        self._ClsStatus = ClsStatus

    @property
    def FlowMode(self):
        r"""负载均衡型WAF使用模式。
0：镜像模式 
1：清洗模式
        :rtype: int
        """
        return self._FlowMode

    @FlowMode.setter
    def FlowMode(self, FlowMode):
        self._FlowMode = FlowMode

    @property
    def Status(self):
        r"""waf开关状态。
0：关闭 
1：开启
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Mode(self):
        r"""规则引擎防护模式。
0：观察模式 
1：拦截模式
        :rtype: int
        """
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode

    @property
    def Engine(self):
        r"""规则引擎和AI引擎防护模式联合状态。
1:初始状态,规则引擎拦截&&AI引擎未操作开关状态
10：规则引擎观察&&AI引擎关闭模式 
11：规则引擎观察&&AI引擎观察模式 
12：规则引擎观察&&AI引擎拦截模式 
20：规则引擎拦截&&AI引擎关闭模式 
21：规则引擎拦截&&AI引擎观察模式 
22：规则引擎拦截&&AI引擎拦截模式
        :rtype: int
        """
        return self._Engine

    @Engine.setter
    def Engine(self, Engine):
        self._Engine = Engine

    @property
    def CCList(self):
        r"""沙箱集群回源出口IP列表
        :rtype: list of str
        """
        return self._CCList

    @CCList.setter
    def CCList(self, CCList):
        self._CCList = CCList

    @property
    def RsList(self):
        r"""生产集群回源出口IP列表
        :rtype: list of str
        """
        return self._RsList

    @RsList.setter
    def RsList(self, RsList):
        self._RsList = RsList

    @property
    def Ports(self):
        r"""服务端口配置
        :rtype: list of PortInfo
        """
        return self._Ports

    @Ports.setter
    def Ports(self, Ports):
        self._Ports = Ports

    @property
    def LoadBalancerSet(self):
        r"""负载均衡器相关配置
        :rtype: list of LoadBalancerPackageNew
        """
        return self._LoadBalancerSet

    @LoadBalancerSet.setter
    def LoadBalancerSet(self, LoadBalancerSet):
        self._LoadBalancerSet = LoadBalancerSet

    @property
    def AppId(self):
        r"""用户id
        :rtype: int
        """
        return self._AppId

    @AppId.setter
    def AppId(self, AppId):
        self._AppId = AppId

    @property
    def State(self):
        r"""SAAS型WAF域名状态：
-2：配置下发失败
-1：配置下发中
0：DNS解析中
1：无DNS解析记录，请接入WAF
10：DNS解析未知，域名启用了代理
11：DNS解析异常，使用A记录接入WAF IP
200：检测源站不可达
220：源站不支持长连接
311：证书过期
312：证书即将过期
310：证书异常
316：备案异常
5：WAF回源已变更
负载均衡型WAF域名LB监听器状态：
0：操作成功 
4：正在绑定LB 
6：正在解绑LB 
7：解绑LB失败 
8：绑定LB失败 
10：内部错误
        :rtype: int
        """
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def CreateTime(self):
        r"""创建时间
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def Ipv6Status(self):
        r"""Ipv6开关状态。
0：关闭 
1：开启
        :rtype: int
        """
        return self._Ipv6Status

    @Ipv6Status.setter
    def Ipv6Status(self, Ipv6Status):
        self._Ipv6Status = Ipv6Status

    @property
    def BotStatus(self):
        r"""BOT开关状态。
0：关闭 
1：关闭
2：开启
3：开启
        :rtype: int
        """
        return self._BotStatus

    @BotStatus.setter
    def BotStatus(self, BotStatus):
        self._BotStatus = BotStatus

    @property
    def Level(self):
        r"""实例版本信息。
101：小微敏捷版 
102：小微超轻版
2：高级版
3：企业版
4：旗舰版
6：独享版
        :rtype: int
        """
        return self._Level

    @Level.setter
    def Level(self, Level):
        self._Level = Level

    @property
    def PostCLSStatus(self):
        r"""投递CLS状态。
0：关闭 
1：开启
        :rtype: int
        """
        return self._PostCLSStatus

    @PostCLSStatus.setter
    def PostCLSStatus(self, PostCLSStatus):
        self._PostCLSStatus = PostCLSStatus

    @property
    def PostCKafkaStatus(self):
        r"""投递CKafka状态。
0：关闭 
1：开启
        :rtype: int
        """
        return self._PostCKafkaStatus

    @PostCKafkaStatus.setter
    def PostCKafkaStatus(self, PostCKafkaStatus):
        self._PostCKafkaStatus = PostCKafkaStatus

    @property
    def CdcClusters(self):
        r"""cdc实例域名接入的集群信息,非cdc实例忽略。
        :rtype: str
        """
        return self._CdcClusters

    @CdcClusters.setter
    def CdcClusters(self, CdcClusters):
        self._CdcClusters = CdcClusters

    @property
    def ApiStatus(self):
        r"""api安全开关状态。
0：关闭 
1：开启
        :rtype: int
        """
        return self._ApiStatus

    @ApiStatus.setter
    def ApiStatus(self, ApiStatus):
        self._ApiStatus = ApiStatus

    @property
    def AlbType(self):
        r"""应用型负载均衡类型，默认clb。
clb：七层负载均衡器类型
apisix：apisix网关型
        :rtype: str
        """
        return self._AlbType

    @AlbType.setter
    def AlbType(self, AlbType):
        self._AlbType = AlbType

    @property
    def SgState(self):
        r"""安全组状态。
0：不展示
1：非腾讯云源站
2：安全组绑定失败
3：安全组发生变更
        :rtype: int
        """
        return self._SgState

    @SgState.setter
    def SgState(self, SgState):
        self._SgState = SgState

    @property
    def SgDetail(self):
        r"""安全组状态的详细解释
        :rtype: str
        """
        return self._SgDetail

    @SgDetail.setter
    def SgDetail(self, SgDetail):
        self._SgDetail = SgDetail

    @property
    def CloudType(self):
        r"""域名云环境。hybrid：混合云域名
public：公有云域名
        :rtype: str
        """
        return self._CloudType

    @CloudType.setter
    def CloudType(self, CloudType):
        self._CloudType = CloudType

    @property
    def Note(self):
        r"""域名备注信息
        :rtype: str
        """
        return self._Note

    @Note.setter
    def Note(self, Note):
        self._Note = Note

    @property
    def SrcList(self):
        r"""SAASWAF源站IP列表
        :rtype: list of str
        """
        return self._SrcList

    @SrcList.setter
    def SrcList(self, SrcList):
        self._SrcList = SrcList

    @property
    def UpstreamDomainList(self):
        r"""SAASWAF源站域名列表
        :rtype: list of str
        """
        return self._UpstreamDomainList

    @UpstreamDomainList.setter
    def UpstreamDomainList(self, UpstreamDomainList):
        self._UpstreamDomainList = UpstreamDomainList

    @property
    def SgID(self):
        r"""安全组ID
        :rtype: str
        """
        return self._SgID

    @SgID.setter
    def SgID(self, SgID):
        self._SgID = SgID

    @property
    def AccessStatus(self):
        r"""clbwaf接入状态，0代表“尚无流量接入”，1代表“流量接入”，2代表“CLB监听器已注销”，3代表“配置生效中”，4代表“配置下发失败中”
        :rtype: int
        """
        return self._AccessStatus

    @AccessStatus.setter
    def AccessStatus(self, AccessStatus):
        self._AccessStatus = AccessStatus

    @property
    def Labels(self):
        r"""域名标签
        :rtype: list of str
        """
        return self._Labels

    @Labels.setter
    def Labels(self, Labels):
        self._Labels = Labels


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._DomainId = params.get("DomainId")
        self._InstanceId = params.get("InstanceId")
        self._Cname = params.get("Cname")
        self._Edition = params.get("Edition")
        self._Region = params.get("Region")
        self._InstanceName = params.get("InstanceName")
        self._ClsStatus = params.get("ClsStatus")
        self._FlowMode = params.get("FlowMode")
        self._Status = params.get("Status")
        self._Mode = params.get("Mode")
        self._Engine = params.get("Engine")
        self._CCList = params.get("CCList")
        self._RsList = params.get("RsList")
        if params.get("Ports") is not None:
            self._Ports = []
            for item in params.get("Ports"):
                obj = PortInfo()
                obj._deserialize(item)
                self._Ports.append(obj)
        if params.get("LoadBalancerSet") is not None:
            self._LoadBalancerSet = []
            for item in params.get("LoadBalancerSet"):
                obj = LoadBalancerPackageNew()
                obj._deserialize(item)
                self._LoadBalancerSet.append(obj)
        self._AppId = params.get("AppId")
        self._State = params.get("State")
        self._CreateTime = params.get("CreateTime")
        self._Ipv6Status = params.get("Ipv6Status")
        self._BotStatus = params.get("BotStatus")
        self._Level = params.get("Level")
        self._PostCLSStatus = params.get("PostCLSStatus")
        self._PostCKafkaStatus = params.get("PostCKafkaStatus")
        self._CdcClusters = params.get("CdcClusters")
        self._ApiStatus = params.get("ApiStatus")
        self._AlbType = params.get("AlbType")
        self._SgState = params.get("SgState")
        self._SgDetail = params.get("SgDetail")
        self._CloudType = params.get("CloudType")
        self._Note = params.get("Note")
        self._SrcList = params.get("SrcList")
        self._UpstreamDomainList = params.get("UpstreamDomainList")
        self._SgID = params.get("SgID")
        self._AccessStatus = params.get("AccessStatus")
        self._Labels = params.get("Labels")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DomainPackageNew(AbstractModel):
    r"""waf 域名扩展套餐

    """

    def __init__(self):
        r"""
        :param _ResourceIds: 资源ID
        :type ResourceIds: str
        :param _ValidTime: 过期时间
        :type ValidTime: str
        :param _RenewFlag: 是否自动续费，1：自动续费，0：不自动续费
        :type RenewFlag: int
        :param _Count: 套餐购买个数
        :type Count: int
        :param _Region: 套餐购买地域，clb-waf暂时没有用到
        :type Region: str
        """
        self._ResourceIds = None
        self._ValidTime = None
        self._RenewFlag = None
        self._Count = None
        self._Region = None

    @property
    def ResourceIds(self):
        r"""资源ID
        :rtype: str
        """
        return self._ResourceIds

    @ResourceIds.setter
    def ResourceIds(self, ResourceIds):
        self._ResourceIds = ResourceIds

    @property
    def ValidTime(self):
        r"""过期时间
        :rtype: str
        """
        return self._ValidTime

    @ValidTime.setter
    def ValidTime(self, ValidTime):
        self._ValidTime = ValidTime

    @property
    def RenewFlag(self):
        r"""是否自动续费，1：自动续费，0：不自动续费
        :rtype: int
        """
        return self._RenewFlag

    @RenewFlag.setter
    def RenewFlag(self, RenewFlag):
        self._RenewFlag = RenewFlag

    @property
    def Count(self):
        r"""套餐购买个数
        :rtype: int
        """
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def Region(self):
        r"""套餐购买地域，clb-waf暂时没有用到
        :rtype: str
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region


    def _deserialize(self, params):
        self._ResourceIds = params.get("ResourceIds")
        self._ValidTime = params.get("ValidTime")
        self._RenewFlag = params.get("RenewFlag")
        self._Count = params.get("Count")
        self._Region = params.get("Region")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DomainRuleId(AbstractModel):
    r"""域名-规则id结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _RuleId: 规则id
        :type RuleId: str
        """
        self._Domain = None
        self._RuleId = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def RuleId(self):
        r"""规则id
        :rtype: str
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._RuleId = params.get("RuleId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DomainURI(AbstractModel):
    r"""唯一定位Domain

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _Edition: 版本
        :type Edition: str
        :param _InstanceID: 实例ID
        :type InstanceID: str
        """
        self._Domain = None
        self._Edition = None
        self._InstanceID = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Edition(self):
        r"""版本
        :rtype: str
        """
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition

    @property
    def InstanceID(self):
        r"""实例ID
        :rtype: str
        """
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Edition = params.get("Edition")
        self._InstanceID = params.get("InstanceID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DomainsPartInfo(AbstractModel):
    r"""SaaS型WAF域名详情

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _DomainId: 域名唯一ID
        :type DomainId: str
        :param _InstanceId: 域名所属实例唯一ID
        :type InstanceId: str
        :param _Edition: 域名所属实例类型
        :type Edition: str
        :param _InstanceName: 域名所属实例名
        :type InstanceName: str
        :param _Cert: 证书
        :type Cert: str
        :param _CreateTime: 创建时间
        :type CreateTime: str
        :param _Engine: 规则引擎和AI引擎防护模式联合状态。
1:初始状态,规则引擎拦截&&AI引擎未操作开关状态
10：规则引擎观察&&AI引擎关闭模式 
11：规则引擎观察&&AI引擎观察模式 
12：规则引擎观察&&AI引擎拦截模式 
20：规则引擎拦截&&AI引擎关闭模式 
21：规则引擎拦截&&AI引擎观察模式 
22：规则引擎拦截&&AI引擎拦截模式
        :type Engine: int
        :param _HttpsRewrite: 是否开启HTTP强制跳转到HTTPS。
0：不强制跳转
1：开启强制跳转
        :type HttpsRewrite: int
        :param _HttpsUpstreamPort: HTTPS回源端口
        :type HttpsUpstreamPort: str
        :param _IsCdn: waf前是否部署有七层代理服务。
0：没有部署代理服务
1：有部署代理服务，waf将使用XFF获取客户端IP
2：有部署代理服务，waf将使用remote_addr获取客户端IP
3：有部署代理服务，waf将使用ip_headers中的自定义header获取客户端IP
        :type IsCdn: int
        :param _IsGray: 是否开启灰度。
        :type IsGray: int
        :param _IsHttp2: 是否开启HTTP2，需要开启HTTPS协议支持。
0：关闭
1：开启
        :type IsHttp2: int
        :param _IsWebsocket: 是否开启WebSocket支持。
0：关闭
1：开启
        :type IsWebsocket: int
        :param _LoadBalance: 回源负载均衡策略。
0：轮询
1：IP hash
2：加权轮询
        :type LoadBalance: int
        :param _Mode: 防护模式。
0：观察模式
1：拦截模式
        :type Mode: int
        :param _PrivateKey: 自有证书的私钥
        :type PrivateKey: str
        :param _SSLId: CertType为2时，需要填充此参数，表示腾讯云SSL平台托管的证书id
        :type SSLId: str
        :param _UpstreamDomain: 域名回源时的回源域名。UpstreamType为1时，需要填充此字段
        :type UpstreamDomain: str
        :param _UpstreamType: 回源类型。
0：通过IP回源
1：通过域名回源
        :type UpstreamType: int
        :param _SrcList: IP回源时的回源IP列表。UpstreamType为0时，需要填充此字段
        :type SrcList: list of str
        :param _Ports: 域名端口配置
        :type Ports: list of PortInfo
        :param _CertType: 证书类型。
0：仅配置HTTP监听端口，没有证书
1：证书来源为自有证书
2：证书来源为托管证书
        :type CertType: int
        :param _UpstreamScheme: 服务配置有HTTPS端口时，HTTPS的回源协议。
http：使用http协议回源，和HttpsUpstreamPort配合使用
https：使用https协议回源
        :type UpstreamScheme: str
        :param _Cls: 日志包是否开启。
0：关闭
1：开启
        :type Cls: int
        :param _Cname: 接入Cname，SaaS型域名使用此Cname进行接入
        :type Cname: str
        :param _IsKeepAlive: 是否开启长连接。
0： 短连接
1： 长连接
        :type IsKeepAlive: int
        :param _ActiveCheck: 是否开启主动健康检测。
0：不开启
1：开启
        :type ActiveCheck: int
        :param _TLSVersion: TLS版本信息
        :type TLSVersion: int
        :param _Ciphers: 自定义的加密套件列表。CipherTemplate为3时需要填此字段，表示自定义的加密套件，值通过DescribeCiphersDetail接口获取。
        :type Ciphers: list of int
        :param _CipherTemplate: 加密套件模板。
0：不支持选择，使用默认模板  
1：通用型模板 
2：安全型模板
3：自定义模板
        :type CipherTemplate: int
        :param _ProxyConnectTimeout: WAF与源站的连接超时，默认10s。
        :type ProxyConnectTimeout: int
        :param _ProxyReadTimeout: WAF与源站的读超时时间，默认300s。
        :type ProxyReadTimeout: int
        :param _ProxySendTimeout: WAF与源站的写超时时间，默认300s。
        :type ProxySendTimeout: int
        :param _SniType: WAF回源时的SNI类型。
0：关闭SNI，不配置client_hello中的server_name
1：开启SNI，client_hello中的server_name为防护域名
2：开启SNI，SNI为域名回源时的源站域名
3：开启SNI，SNI为自定义域名
        :type SniType: int
        :param _SniHost: SniType为3时，需要填此参数，表示自定义的SNI；
        :type SniHost: str
        :param _Weights: 回源IP权重
        :type Weights: list of str
        :param _IpHeaders: IsCdn=3时，表示自定义header
        :type IpHeaders: list of str
        :param _XFFReset: 是否开启XFF重置。
0：关闭
1：开启
        :type XFFReset: int
        :param _Note: 域名备注信息
        :type Note: str
        :param _UpstreamHost: 自定义回源Host。默认为空字符串，表示使用防护域名作为回源Host。
        :type UpstreamHost: str
        :param _Level: 防护规则
        :type Level: str
        :param _ProxyBuffer: 是否开启缓存 0-关闭 1-开启
        :type ProxyBuffer: int
        :param _GmType: 国密选项。0：不开启国密 1：在原有TLS选项的基础上追加支持国密 2：开启国密并仅支持国密客户端访问
        :type GmType: int
        :param _GmCertType: 国密证书类型。0：无国密证书 1：证书来源为自有国密证书 2：证书来源为托管国密证书
        :type GmCertType: int
        :param _GmCert: GmCertType为1时，需要填充此参数，表示自有国密证书的证书链
        :type GmCert: str
        :param _GmPrivateKey: GmCertType为1时，需要填充此参数，表示自有国密证书的私钥
        :type GmPrivateKey: str
        :param _GmEncCert: GmCertType为1时，需要填充此参数，表示自有国密证书的加密证书
        :type GmEncCert: str
        :param _GmEncPrivateKey: GmCertType为1时，需要填充此参数，表示自有国密证书的加密证书的私钥
        :type GmEncPrivateKey: str
        :param _GmSSLId: GmCertType为2时，需要填充此参数，表示腾讯云SSL平台托管的证书id
        :type GmSSLId: str
        :param _Labels: 域名标签
        :type Labels: list of str
        :param _ProbeStatus: 拨测状态。 0: 禁用拨测, 1: 启用拨测
        :type ProbeStatus: int
        :param _UpstreamPolicy: 回源策略。
0：负载均衡回源
1：分流回源
        :type UpstreamPolicy: int
        :param _UpstreamRules: 分流回源策略
        :type UpstreamRules: list of UpstreamRule
        :param _UseCase: 业务场景。0：默认值，表示常规业务场景 1：大模型业务场景
        :type UseCase: int
        :param _Gzip: gzip开关。0：关闭 1：默认值，打开。
        :type Gzip: int
        :param _State: SAAS型WAF域名状态：
-2：配置下发失败
-1：配置下发中
0：DNS解析中
1：无DNS解析记录，请接入WAF
10：DNS解析未知，域名启用了代理
11：DNS解析异常，使用A记录接入WAF IP
200：检测源站不可达
220：源站不支持长连接
311：证书过期
312：证书即将过期
310：证书异常
316：备案异常
5：WAF回源已变更
负载均衡型WAF域名LB监听器状态：
0：操作成功 
4：正在绑定LB 
6：正在解绑LB 
7：解绑LB失败 
8：绑定LB失败 
10：内部错误
        :type State: int
        """
        self._Domain = None
        self._DomainId = None
        self._InstanceId = None
        self._Edition = None
        self._InstanceName = None
        self._Cert = None
        self._CreateTime = None
        self._Engine = None
        self._HttpsRewrite = None
        self._HttpsUpstreamPort = None
        self._IsCdn = None
        self._IsGray = None
        self._IsHttp2 = None
        self._IsWebsocket = None
        self._LoadBalance = None
        self._Mode = None
        self._PrivateKey = None
        self._SSLId = None
        self._UpstreamDomain = None
        self._UpstreamType = None
        self._SrcList = None
        self._Ports = None
        self._CertType = None
        self._UpstreamScheme = None
        self._Cls = None
        self._Cname = None
        self._IsKeepAlive = None
        self._ActiveCheck = None
        self._TLSVersion = None
        self._Ciphers = None
        self._CipherTemplate = None
        self._ProxyConnectTimeout = None
        self._ProxyReadTimeout = None
        self._ProxySendTimeout = None
        self._SniType = None
        self._SniHost = None
        self._Weights = None
        self._IpHeaders = None
        self._XFFReset = None
        self._Note = None
        self._UpstreamHost = None
        self._Level = None
        self._ProxyBuffer = None
        self._GmType = None
        self._GmCertType = None
        self._GmCert = None
        self._GmPrivateKey = None
        self._GmEncCert = None
        self._GmEncPrivateKey = None
        self._GmSSLId = None
        self._Labels = None
        self._ProbeStatus = None
        self._UpstreamPolicy = None
        self._UpstreamRules = None
        self._UseCase = None
        self._Gzip = None
        self._State = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def DomainId(self):
        r"""域名唯一ID
        :rtype: str
        """
        return self._DomainId

    @DomainId.setter
    def DomainId(self, DomainId):
        self._DomainId = DomainId

    @property
    def InstanceId(self):
        r"""域名所属实例唯一ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Edition(self):
        r"""域名所属实例类型
        :rtype: str
        """
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition

    @property
    def InstanceName(self):
        r"""域名所属实例名
        :rtype: str
        """
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def Cert(self):
        r"""证书
        :rtype: str
        """
        return self._Cert

    @Cert.setter
    def Cert(self, Cert):
        self._Cert = Cert

    @property
    def CreateTime(self):
        r"""创建时间
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def Engine(self):
        r"""规则引擎和AI引擎防护模式联合状态。
1:初始状态,规则引擎拦截&&AI引擎未操作开关状态
10：规则引擎观察&&AI引擎关闭模式 
11：规则引擎观察&&AI引擎观察模式 
12：规则引擎观察&&AI引擎拦截模式 
20：规则引擎拦截&&AI引擎关闭模式 
21：规则引擎拦截&&AI引擎观察模式 
22：规则引擎拦截&&AI引擎拦截模式
        :rtype: int
        """
        return self._Engine

    @Engine.setter
    def Engine(self, Engine):
        self._Engine = Engine

    @property
    def HttpsRewrite(self):
        r"""是否开启HTTP强制跳转到HTTPS。
0：不强制跳转
1：开启强制跳转
        :rtype: int
        """
        return self._HttpsRewrite

    @HttpsRewrite.setter
    def HttpsRewrite(self, HttpsRewrite):
        self._HttpsRewrite = HttpsRewrite

    @property
    def HttpsUpstreamPort(self):
        r"""HTTPS回源端口
        :rtype: str
        """
        return self._HttpsUpstreamPort

    @HttpsUpstreamPort.setter
    def HttpsUpstreamPort(self, HttpsUpstreamPort):
        self._HttpsUpstreamPort = HttpsUpstreamPort

    @property
    def IsCdn(self):
        r"""waf前是否部署有七层代理服务。
0：没有部署代理服务
1：有部署代理服务，waf将使用XFF获取客户端IP
2：有部署代理服务，waf将使用remote_addr获取客户端IP
3：有部署代理服务，waf将使用ip_headers中的自定义header获取客户端IP
        :rtype: int
        """
        return self._IsCdn

    @IsCdn.setter
    def IsCdn(self, IsCdn):
        self._IsCdn = IsCdn

    @property
    def IsGray(self):
        warnings.warn("parameter `IsGray` is deprecated", DeprecationWarning) 

        r"""是否开启灰度。
        :rtype: int
        """
        return self._IsGray

    @IsGray.setter
    def IsGray(self, IsGray):
        warnings.warn("parameter `IsGray` is deprecated", DeprecationWarning) 

        self._IsGray = IsGray

    @property
    def IsHttp2(self):
        r"""是否开启HTTP2，需要开启HTTPS协议支持。
0：关闭
1：开启
        :rtype: int
        """
        return self._IsHttp2

    @IsHttp2.setter
    def IsHttp2(self, IsHttp2):
        self._IsHttp2 = IsHttp2

    @property
    def IsWebsocket(self):
        r"""是否开启WebSocket支持。
0：关闭
1：开启
        :rtype: int
        """
        return self._IsWebsocket

    @IsWebsocket.setter
    def IsWebsocket(self, IsWebsocket):
        self._IsWebsocket = IsWebsocket

    @property
    def LoadBalance(self):
        r"""回源负载均衡策略。
0：轮询
1：IP hash
2：加权轮询
        :rtype: int
        """
        return self._LoadBalance

    @LoadBalance.setter
    def LoadBalance(self, LoadBalance):
        self._LoadBalance = LoadBalance

    @property
    def Mode(self):
        r"""防护模式。
0：观察模式
1：拦截模式
        :rtype: int
        """
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode

    @property
    def PrivateKey(self):
        r"""自有证书的私钥
        :rtype: str
        """
        return self._PrivateKey

    @PrivateKey.setter
    def PrivateKey(self, PrivateKey):
        self._PrivateKey = PrivateKey

    @property
    def SSLId(self):
        r"""CertType为2时，需要填充此参数，表示腾讯云SSL平台托管的证书id
        :rtype: str
        """
        return self._SSLId

    @SSLId.setter
    def SSLId(self, SSLId):
        self._SSLId = SSLId

    @property
    def UpstreamDomain(self):
        r"""域名回源时的回源域名。UpstreamType为1时，需要填充此字段
        :rtype: str
        """
        return self._UpstreamDomain

    @UpstreamDomain.setter
    def UpstreamDomain(self, UpstreamDomain):
        self._UpstreamDomain = UpstreamDomain

    @property
    def UpstreamType(self):
        r"""回源类型。
0：通过IP回源
1：通过域名回源
        :rtype: int
        """
        return self._UpstreamType

    @UpstreamType.setter
    def UpstreamType(self, UpstreamType):
        self._UpstreamType = UpstreamType

    @property
    def SrcList(self):
        r"""IP回源时的回源IP列表。UpstreamType为0时，需要填充此字段
        :rtype: list of str
        """
        return self._SrcList

    @SrcList.setter
    def SrcList(self, SrcList):
        self._SrcList = SrcList

    @property
    def Ports(self):
        r"""域名端口配置
        :rtype: list of PortInfo
        """
        return self._Ports

    @Ports.setter
    def Ports(self, Ports):
        self._Ports = Ports

    @property
    def CertType(self):
        r"""证书类型。
0：仅配置HTTP监听端口，没有证书
1：证书来源为自有证书
2：证书来源为托管证书
        :rtype: int
        """
        return self._CertType

    @CertType.setter
    def CertType(self, CertType):
        self._CertType = CertType

    @property
    def UpstreamScheme(self):
        r"""服务配置有HTTPS端口时，HTTPS的回源协议。
http：使用http协议回源，和HttpsUpstreamPort配合使用
https：使用https协议回源
        :rtype: str
        """
        return self._UpstreamScheme

    @UpstreamScheme.setter
    def UpstreamScheme(self, UpstreamScheme):
        self._UpstreamScheme = UpstreamScheme

    @property
    def Cls(self):
        r"""日志包是否开启。
0：关闭
1：开启
        :rtype: int
        """
        return self._Cls

    @Cls.setter
    def Cls(self, Cls):
        self._Cls = Cls

    @property
    def Cname(self):
        r"""接入Cname，SaaS型域名使用此Cname进行接入
        :rtype: str
        """
        return self._Cname

    @Cname.setter
    def Cname(self, Cname):
        self._Cname = Cname

    @property
    def IsKeepAlive(self):
        r"""是否开启长连接。
0： 短连接
1： 长连接
        :rtype: int
        """
        return self._IsKeepAlive

    @IsKeepAlive.setter
    def IsKeepAlive(self, IsKeepAlive):
        self._IsKeepAlive = IsKeepAlive

    @property
    def ActiveCheck(self):
        r"""是否开启主动健康检测。
0：不开启
1：开启
        :rtype: int
        """
        return self._ActiveCheck

    @ActiveCheck.setter
    def ActiveCheck(self, ActiveCheck):
        self._ActiveCheck = ActiveCheck

    @property
    def TLSVersion(self):
        r"""TLS版本信息
        :rtype: int
        """
        return self._TLSVersion

    @TLSVersion.setter
    def TLSVersion(self, TLSVersion):
        self._TLSVersion = TLSVersion

    @property
    def Ciphers(self):
        r"""自定义的加密套件列表。CipherTemplate为3时需要填此字段，表示自定义的加密套件，值通过DescribeCiphersDetail接口获取。
        :rtype: list of int
        """
        return self._Ciphers

    @Ciphers.setter
    def Ciphers(self, Ciphers):
        self._Ciphers = Ciphers

    @property
    def CipherTemplate(self):
        r"""加密套件模板。
0：不支持选择，使用默认模板  
1：通用型模板 
2：安全型模板
3：自定义模板
        :rtype: int
        """
        return self._CipherTemplate

    @CipherTemplate.setter
    def CipherTemplate(self, CipherTemplate):
        self._CipherTemplate = CipherTemplate

    @property
    def ProxyConnectTimeout(self):
        r"""WAF与源站的连接超时，默认10s。
        :rtype: int
        """
        return self._ProxyConnectTimeout

    @ProxyConnectTimeout.setter
    def ProxyConnectTimeout(self, ProxyConnectTimeout):
        self._ProxyConnectTimeout = ProxyConnectTimeout

    @property
    def ProxyReadTimeout(self):
        r"""WAF与源站的读超时时间，默认300s。
        :rtype: int
        """
        return self._ProxyReadTimeout

    @ProxyReadTimeout.setter
    def ProxyReadTimeout(self, ProxyReadTimeout):
        self._ProxyReadTimeout = ProxyReadTimeout

    @property
    def ProxySendTimeout(self):
        r"""WAF与源站的写超时时间，默认300s。
        :rtype: int
        """
        return self._ProxySendTimeout

    @ProxySendTimeout.setter
    def ProxySendTimeout(self, ProxySendTimeout):
        self._ProxySendTimeout = ProxySendTimeout

    @property
    def SniType(self):
        r"""WAF回源时的SNI类型。
0：关闭SNI，不配置client_hello中的server_name
1：开启SNI，client_hello中的server_name为防护域名
2：开启SNI，SNI为域名回源时的源站域名
3：开启SNI，SNI为自定义域名
        :rtype: int
        """
        return self._SniType

    @SniType.setter
    def SniType(self, SniType):
        self._SniType = SniType

    @property
    def SniHost(self):
        r"""SniType为3时，需要填此参数，表示自定义的SNI；
        :rtype: str
        """
        return self._SniHost

    @SniHost.setter
    def SniHost(self, SniHost):
        self._SniHost = SniHost

    @property
    def Weights(self):
        r"""回源IP权重
        :rtype: list of str
        """
        return self._Weights

    @Weights.setter
    def Weights(self, Weights):
        self._Weights = Weights

    @property
    def IpHeaders(self):
        r"""IsCdn=3时，表示自定义header
        :rtype: list of str
        """
        return self._IpHeaders

    @IpHeaders.setter
    def IpHeaders(self, IpHeaders):
        self._IpHeaders = IpHeaders

    @property
    def XFFReset(self):
        r"""是否开启XFF重置。
0：关闭
1：开启
        :rtype: int
        """
        return self._XFFReset

    @XFFReset.setter
    def XFFReset(self, XFFReset):
        self._XFFReset = XFFReset

    @property
    def Note(self):
        r"""域名备注信息
        :rtype: str
        """
        return self._Note

    @Note.setter
    def Note(self, Note):
        self._Note = Note

    @property
    def UpstreamHost(self):
        r"""自定义回源Host。默认为空字符串，表示使用防护域名作为回源Host。
        :rtype: str
        """
        return self._UpstreamHost

    @UpstreamHost.setter
    def UpstreamHost(self, UpstreamHost):
        self._UpstreamHost = UpstreamHost

    @property
    def Level(self):
        r"""防护规则
        :rtype: str
        """
        return self._Level

    @Level.setter
    def Level(self, Level):
        self._Level = Level

    @property
    def ProxyBuffer(self):
        r"""是否开启缓存 0-关闭 1-开启
        :rtype: int
        """
        return self._ProxyBuffer

    @ProxyBuffer.setter
    def ProxyBuffer(self, ProxyBuffer):
        self._ProxyBuffer = ProxyBuffer

    @property
    def GmType(self):
        r"""国密选项。0：不开启国密 1：在原有TLS选项的基础上追加支持国密 2：开启国密并仅支持国密客户端访问
        :rtype: int
        """
        return self._GmType

    @GmType.setter
    def GmType(self, GmType):
        self._GmType = GmType

    @property
    def GmCertType(self):
        r"""国密证书类型。0：无国密证书 1：证书来源为自有国密证书 2：证书来源为托管国密证书
        :rtype: int
        """
        return self._GmCertType

    @GmCertType.setter
    def GmCertType(self, GmCertType):
        self._GmCertType = GmCertType

    @property
    def GmCert(self):
        r"""GmCertType为1时，需要填充此参数，表示自有国密证书的证书链
        :rtype: str
        """
        return self._GmCert

    @GmCert.setter
    def GmCert(self, GmCert):
        self._GmCert = GmCert

    @property
    def GmPrivateKey(self):
        r"""GmCertType为1时，需要填充此参数，表示自有国密证书的私钥
        :rtype: str
        """
        return self._GmPrivateKey

    @GmPrivateKey.setter
    def GmPrivateKey(self, GmPrivateKey):
        self._GmPrivateKey = GmPrivateKey

    @property
    def GmEncCert(self):
        r"""GmCertType为1时，需要填充此参数，表示自有国密证书的加密证书
        :rtype: str
        """
        return self._GmEncCert

    @GmEncCert.setter
    def GmEncCert(self, GmEncCert):
        self._GmEncCert = GmEncCert

    @property
    def GmEncPrivateKey(self):
        r"""GmCertType为1时，需要填充此参数，表示自有国密证书的加密证书的私钥
        :rtype: str
        """
        return self._GmEncPrivateKey

    @GmEncPrivateKey.setter
    def GmEncPrivateKey(self, GmEncPrivateKey):
        self._GmEncPrivateKey = GmEncPrivateKey

    @property
    def GmSSLId(self):
        r"""GmCertType为2时，需要填充此参数，表示腾讯云SSL平台托管的证书id
        :rtype: str
        """
        return self._GmSSLId

    @GmSSLId.setter
    def GmSSLId(self, GmSSLId):
        self._GmSSLId = GmSSLId

    @property
    def Labels(self):
        r"""域名标签
        :rtype: list of str
        """
        return self._Labels

    @Labels.setter
    def Labels(self, Labels):
        self._Labels = Labels

    @property
    def ProbeStatus(self):
        r"""拨测状态。 0: 禁用拨测, 1: 启用拨测
        :rtype: int
        """
        return self._ProbeStatus

    @ProbeStatus.setter
    def ProbeStatus(self, ProbeStatus):
        self._ProbeStatus = ProbeStatus

    @property
    def UpstreamPolicy(self):
        r"""回源策略。
0：负载均衡回源
1：分流回源
        :rtype: int
        """
        return self._UpstreamPolicy

    @UpstreamPolicy.setter
    def UpstreamPolicy(self, UpstreamPolicy):
        self._UpstreamPolicy = UpstreamPolicy

    @property
    def UpstreamRules(self):
        r"""分流回源策略
        :rtype: list of UpstreamRule
        """
        return self._UpstreamRules

    @UpstreamRules.setter
    def UpstreamRules(self, UpstreamRules):
        self._UpstreamRules = UpstreamRules

    @property
    def UseCase(self):
        r"""业务场景。0：默认值，表示常规业务场景 1：大模型业务场景
        :rtype: int
        """
        return self._UseCase

    @UseCase.setter
    def UseCase(self, UseCase):
        self._UseCase = UseCase

    @property
    def Gzip(self):
        r"""gzip开关。0：关闭 1：默认值，打开。
        :rtype: int
        """
        return self._Gzip

    @Gzip.setter
    def Gzip(self, Gzip):
        self._Gzip = Gzip

    @property
    def State(self):
        r"""SAAS型WAF域名状态：
-2：配置下发失败
-1：配置下发中
0：DNS解析中
1：无DNS解析记录，请接入WAF
10：DNS解析未知，域名启用了代理
11：DNS解析异常，使用A记录接入WAF IP
200：检测源站不可达
220：源站不支持长连接
311：证书过期
312：证书即将过期
310：证书异常
316：备案异常
5：WAF回源已变更
负载均衡型WAF域名LB监听器状态：
0：操作成功 
4：正在绑定LB 
6：正在解绑LB 
7：解绑LB失败 
8：绑定LB失败 
10：内部错误
        :rtype: int
        """
        return self._State

    @State.setter
    def State(self, State):
        self._State = State


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._DomainId = params.get("DomainId")
        self._InstanceId = params.get("InstanceId")
        self._Edition = params.get("Edition")
        self._InstanceName = params.get("InstanceName")
        self._Cert = params.get("Cert")
        self._CreateTime = params.get("CreateTime")
        self._Engine = params.get("Engine")
        self._HttpsRewrite = params.get("HttpsRewrite")
        self._HttpsUpstreamPort = params.get("HttpsUpstreamPort")
        self._IsCdn = params.get("IsCdn")
        self._IsGray = params.get("IsGray")
        self._IsHttp2 = params.get("IsHttp2")
        self._IsWebsocket = params.get("IsWebsocket")
        self._LoadBalance = params.get("LoadBalance")
        self._Mode = params.get("Mode")
        self._PrivateKey = params.get("PrivateKey")
        self._SSLId = params.get("SSLId")
        self._UpstreamDomain = params.get("UpstreamDomain")
        self._UpstreamType = params.get("UpstreamType")
        self._SrcList = params.get("SrcList")
        if params.get("Ports") is not None:
            self._Ports = []
            for item in params.get("Ports"):
                obj = PortInfo()
                obj._deserialize(item)
                self._Ports.append(obj)
        self._CertType = params.get("CertType")
        self._UpstreamScheme = params.get("UpstreamScheme")
        self._Cls = params.get("Cls")
        self._Cname = params.get("Cname")
        self._IsKeepAlive = params.get("IsKeepAlive")
        self._ActiveCheck = params.get("ActiveCheck")
        self._TLSVersion = params.get("TLSVersion")
        self._Ciphers = params.get("Ciphers")
        self._CipherTemplate = params.get("CipherTemplate")
        self._ProxyConnectTimeout = params.get("ProxyConnectTimeout")
        self._ProxyReadTimeout = params.get("ProxyReadTimeout")
        self._ProxySendTimeout = params.get("ProxySendTimeout")
        self._SniType = params.get("SniType")
        self._SniHost = params.get("SniHost")
        self._Weights = params.get("Weights")
        self._IpHeaders = params.get("IpHeaders")
        self._XFFReset = params.get("XFFReset")
        self._Note = params.get("Note")
        self._UpstreamHost = params.get("UpstreamHost")
        self._Level = params.get("Level")
        self._ProxyBuffer = params.get("ProxyBuffer")
        self._GmType = params.get("GmType")
        self._GmCertType = params.get("GmCertType")
        self._GmCert = params.get("GmCert")
        self._GmPrivateKey = params.get("GmPrivateKey")
        self._GmEncCert = params.get("GmEncCert")
        self._GmEncPrivateKey = params.get("GmEncPrivateKey")
        self._GmSSLId = params.get("GmSSLId")
        self._Labels = params.get("Labels")
        self._ProbeStatus = params.get("ProbeStatus")
        self._UpstreamPolicy = params.get("UpstreamPolicy")
        if params.get("UpstreamRules") is not None:
            self._UpstreamRules = []
            for item in params.get("UpstreamRules"):
                obj = UpstreamRule()
                obj._deserialize(item)
                self._UpstreamRules.append(obj)
        self._UseCase = params.get("UseCase")
        self._Gzip = params.get("Gzip")
        self._State = params.get("State")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DownloadAttackRecordInfo(AbstractModel):
    r"""下载攻击日志记录数据项

    """

    def __init__(self):
        r"""
        :param _Id: 记录ID
        :type Id: int
        :param _TaskName: 下载任务名
        :type TaskName: str
        :param _TaskId: 任务ID
        :type TaskId: str
        :param _Host: 域名
        :type Host: str
        :param _Count: 当前下载任务的日志条数
        :type Count: int
        :param _Status: 下载任务运行状态：-1-下载超时，0-下载等待，1-下载完成，2-下载失败，4-正在下载
        :type Status: int
        :param _Url: 下载文件URL
        :type Url: str
        :param _CreateTime: 创建时间
        :type CreateTime: str
        :param _ModifyTime: 最后更新修改时间
        :type ModifyTime: str
        :param _ExpireTime: 过期时间
        :type ExpireTime: str
        :param _TotalCount: 下载任务需下载的日志总条数
        :type TotalCount: int
        """
        self._Id = None
        self._TaskName = None
        self._TaskId = None
        self._Host = None
        self._Count = None
        self._Status = None
        self._Url = None
        self._CreateTime = None
        self._ModifyTime = None
        self._ExpireTime = None
        self._TotalCount = None

    @property
    def Id(self):
        r"""记录ID
        :rtype: int
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def TaskName(self):
        r"""下载任务名
        :rtype: str
        """
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def TaskId(self):
        r"""任务ID
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Host(self):
        r"""域名
        :rtype: str
        """
        return self._Host

    @Host.setter
    def Host(self, Host):
        self._Host = Host

    @property
    def Count(self):
        r"""当前下载任务的日志条数
        :rtype: int
        """
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def Status(self):
        r"""下载任务运行状态：-1-下载超时，0-下载等待，1-下载完成，2-下载失败，4-正在下载
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Url(self):
        r"""下载文件URL
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def CreateTime(self):
        r"""创建时间
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def ModifyTime(self):
        r"""最后更新修改时间
        :rtype: str
        """
        return self._ModifyTime

    @ModifyTime.setter
    def ModifyTime(self, ModifyTime):
        self._ModifyTime = ModifyTime

    @property
    def ExpireTime(self):
        r"""过期时间
        :rtype: str
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def TotalCount(self):
        r"""下载任务需下载的日志总条数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._TaskName = params.get("TaskName")
        self._TaskId = params.get("TaskId")
        self._Host = params.get("Host")
        self._Count = params.get("Count")
        self._Status = params.get("Status")
        self._Url = params.get("Url")
        self._CreateTime = params.get("CreateTime")
        self._ModifyTime = params.get("ModifyTime")
        self._ExpireTime = params.get("ExpireTime")
        self._TotalCount = params.get("TotalCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExportAccessInfo(AbstractModel):
    r"""DescribeAccessExports接口

    """

    def __init__(self):
        r"""
        :param _ExportId: 日志导出任务ID
        :type ExportId: str
        :param _Query: 日志导出查询语句
        :type Query: str
        :param _FileName: 日志导出文件名
        :type FileName: str
        :param _FileSize: 日志文件大小
        :type FileSize: int
        :param _Order: 日志导出时间排序
        :type Order: str
        :param _Format: 日志导出格式
        :type Format: str
        :param _Count: 日志导出数量
        :type Count: int
        :param _Status: 日志下载状态。Processing:导出正在进行中，Complete:导出完成，Failed:导出失败，Expired:日志导出已过期（三天有效期）
        :type Status: str
        :param _From: 日志导出起始时间
        :type From: int
        :param _To: 日志导出结束时间
        :type To: int
        :param _CosPath: 日志导出路径
        :type CosPath: str
        :param _CreateTime: 日志导出创建时间
        :type CreateTime: str
        """
        self._ExportId = None
        self._Query = None
        self._FileName = None
        self._FileSize = None
        self._Order = None
        self._Format = None
        self._Count = None
        self._Status = None
        self._From = None
        self._To = None
        self._CosPath = None
        self._CreateTime = None

    @property
    def ExportId(self):
        r"""日志导出任务ID
        :rtype: str
        """
        return self._ExportId

    @ExportId.setter
    def ExportId(self, ExportId):
        self._ExportId = ExportId

    @property
    def Query(self):
        r"""日志导出查询语句
        :rtype: str
        """
        return self._Query

    @Query.setter
    def Query(self, Query):
        self._Query = Query

    @property
    def FileName(self):
        r"""日志导出文件名
        :rtype: str
        """
        return self._FileName

    @FileName.setter
    def FileName(self, FileName):
        self._FileName = FileName

    @property
    def FileSize(self):
        r"""日志文件大小
        :rtype: int
        """
        return self._FileSize

    @FileSize.setter
    def FileSize(self, FileSize):
        self._FileSize = FileSize

    @property
    def Order(self):
        r"""日志导出时间排序
        :rtype: str
        """
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def Format(self):
        r"""日志导出格式
        :rtype: str
        """
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def Count(self):
        r"""日志导出数量
        :rtype: int
        """
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def Status(self):
        r"""日志下载状态。Processing:导出正在进行中，Complete:导出完成，Failed:导出失败，Expired:日志导出已过期（三天有效期）
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def From(self):
        r"""日志导出起始时间
        :rtype: int
        """
        return self._From

    @From.setter
    def From(self, From):
        self._From = From

    @property
    def To(self):
        r"""日志导出结束时间
        :rtype: int
        """
        return self._To

    @To.setter
    def To(self, To):
        self._To = To

    @property
    def CosPath(self):
        r"""日志导出路径
        :rtype: str
        """
        return self._CosPath

    @CosPath.setter
    def CosPath(self, CosPath):
        self._CosPath = CosPath

    @property
    def CreateTime(self):
        r"""日志导出创建时间
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime


    def _deserialize(self, params):
        self._ExportId = params.get("ExportId")
        self._Query = params.get("Query")
        self._FileName = params.get("FileName")
        self._FileSize = params.get("FileSize")
        self._Order = params.get("Order")
        self._Format = params.get("Format")
        self._Count = params.get("Count")
        self._Status = params.get("Status")
        self._From = params.get("From")
        self._To = params.get("To")
        self._CosPath = params.get("CosPath")
        self._CreateTime = params.get("CreateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExportInfo(AbstractModel):
    r"""日志导出信息

    """

    def __init__(self):
        r"""
        :param _TopicId: 日志主题ID
        :type TopicId: str
        :param _ExportId: 日志导出任务ID
        :type ExportId: str
        :param _Query: 日志导出查询语句
        :type Query: str
        :param _FileName: 日志导出文件名
        :type FileName: str
        :param _FileSize: 日志文件大小
        :type FileSize: int
        :param _Order: 日志导出时间排序
        :type Order: str
        :param _Format: 日志导出格式
        :type Format: str
        :param _Count: 日志导出数量
        :type Count: int
        :param _Status: 日志下载状态。Processing:导出正在进行中，Completed:导出完成，Failed:导出失败，Expired:日志导出已过期(三天有效期), Queuing 排队中
        :type Status: str
        :param _From: 日志导出起始时间
        :type From: int
        :param _To: 日志导出结束时间
        :type To: int
        :param _CosPath: 日志导出路径,有效期一个小时，请尽快使用该路径下载。
        :type CosPath: str
        :param _CreateTime: 日志导出创建时间
        :type CreateTime: str
        :param _SyntaxRule: 语法规则。 默认值为0。
0：Lucene语法，1：CQL语法。
        :type SyntaxRule: int
        :param _DerivedFields: 导出字段
注意：此字段可能返回 null，表示取不到有效值。
        :type DerivedFields: list of str
        """
        self._TopicId = None
        self._ExportId = None
        self._Query = None
        self._FileName = None
        self._FileSize = None
        self._Order = None
        self._Format = None
        self._Count = None
        self._Status = None
        self._From = None
        self._To = None
        self._CosPath = None
        self._CreateTime = None
        self._SyntaxRule = None
        self._DerivedFields = None

    @property
    def TopicId(self):
        r"""日志主题ID
        :rtype: str
        """
        return self._TopicId

    @TopicId.setter
    def TopicId(self, TopicId):
        self._TopicId = TopicId

    @property
    def ExportId(self):
        r"""日志导出任务ID
        :rtype: str
        """
        return self._ExportId

    @ExportId.setter
    def ExportId(self, ExportId):
        self._ExportId = ExportId

    @property
    def Query(self):
        r"""日志导出查询语句
        :rtype: str
        """
        return self._Query

    @Query.setter
    def Query(self, Query):
        self._Query = Query

    @property
    def FileName(self):
        r"""日志导出文件名
        :rtype: str
        """
        return self._FileName

    @FileName.setter
    def FileName(self, FileName):
        self._FileName = FileName

    @property
    def FileSize(self):
        r"""日志文件大小
        :rtype: int
        """
        return self._FileSize

    @FileSize.setter
    def FileSize(self, FileSize):
        self._FileSize = FileSize

    @property
    def Order(self):
        r"""日志导出时间排序
        :rtype: str
        """
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def Format(self):
        r"""日志导出格式
        :rtype: str
        """
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def Count(self):
        r"""日志导出数量
        :rtype: int
        """
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def Status(self):
        r"""日志下载状态。Processing:导出正在进行中，Completed:导出完成，Failed:导出失败，Expired:日志导出已过期(三天有效期), Queuing 排队中
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def From(self):
        r"""日志导出起始时间
        :rtype: int
        """
        return self._From

    @From.setter
    def From(self, From):
        self._From = From

    @property
    def To(self):
        r"""日志导出结束时间
        :rtype: int
        """
        return self._To

    @To.setter
    def To(self, To):
        self._To = To

    @property
    def CosPath(self):
        r"""日志导出路径,有效期一个小时，请尽快使用该路径下载。
        :rtype: str
        """
        return self._CosPath

    @CosPath.setter
    def CosPath(self, CosPath):
        self._CosPath = CosPath

    @property
    def CreateTime(self):
        r"""日志导出创建时间
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def SyntaxRule(self):
        r"""语法规则。 默认值为0。
0：Lucene语法，1：CQL语法。
        :rtype: int
        """
        return self._SyntaxRule

    @SyntaxRule.setter
    def SyntaxRule(self, SyntaxRule):
        self._SyntaxRule = SyntaxRule

    @property
    def DerivedFields(self):
        r"""导出字段
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._DerivedFields

    @DerivedFields.setter
    def DerivedFields(self, DerivedFields):
        self._DerivedFields = DerivedFields


    def _deserialize(self, params):
        self._TopicId = params.get("TopicId")
        self._ExportId = params.get("ExportId")
        self._Query = params.get("Query")
        self._FileName = params.get("FileName")
        self._FileSize = params.get("FileSize")
        self._Order = params.get("Order")
        self._Format = params.get("Format")
        self._Count = params.get("Count")
        self._Status = params.get("Status")
        self._From = params.get("From")
        self._To = params.get("To")
        self._CosPath = params.get("CosPath")
        self._CreateTime = params.get("CreateTime")
        self._SyntaxRule = params.get("SyntaxRule")
        self._DerivedFields = params.get("DerivedFields")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FieldWriteConfig(AbstractModel):
    r"""设置哪些字段是否存储或转发

    """

    def __init__(self):
        r"""
        :param _EnableHeaders: 1:开启 0:不开启
        :type EnableHeaders: int
        :param _EnableBody: 1:开启 0:不开启
        :type EnableBody: int
        :param _EnableBot: 1:开启 0:不开启
        :type EnableBot: int
        """
        self._EnableHeaders = None
        self._EnableBody = None
        self._EnableBot = None

    @property
    def EnableHeaders(self):
        r"""1:开启 0:不开启
        :rtype: int
        """
        return self._EnableHeaders

    @EnableHeaders.setter
    def EnableHeaders(self, EnableHeaders):
        self._EnableHeaders = EnableHeaders

    @property
    def EnableBody(self):
        r"""1:开启 0:不开启
        :rtype: int
        """
        return self._EnableBody

    @EnableBody.setter
    def EnableBody(self, EnableBody):
        self._EnableBody = EnableBody

    @property
    def EnableBot(self):
        r"""1:开启 0:不开启
        :rtype: int
        """
        return self._EnableBot

    @EnableBot.setter
    def EnableBot(self, EnableBot):
        self._EnableBot = EnableBot


    def _deserialize(self, params):
        self._EnableHeaders = params.get("EnableHeaders")
        self._EnableBody = params.get("EnableBody")
        self._EnableBot = params.get("EnableBot")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FilterCls(AbstractModel):
    r"""过滤器

    """

    def __init__(self):
        r"""
        :param _Key: 需要过滤的字段。
        :type Key: str
        :param _Values: 需要过滤的值。
        :type Values: list of str
        """
        self._Key = None
        self._Values = None

    @property
    def Key(self):
        r"""需要过滤的字段。
        :rtype: str
        """
        return self._Key

    @Key.setter
    def Key(self, Key):
        self._Key = Key

    @property
    def Values(self):
        r"""需要过滤的值。
        :rtype: list of str
        """
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values


    def _deserialize(self, params):
        self._Key = params.get("Key")
        self._Values = params.get("Values")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FiltersItemNew(AbstractModel):
    r"""过滤数组

    """

    def __init__(self):
        r"""
        :param _Name: 字段名； 过滤
子订单号过滤通过name 为：DealName； value为子订单号
        :type Name: str
        :param _Values: 过滤值
        :type Values: list of str
        :param _ExactMatch: 是否精确查找
        :type ExactMatch: bool
        """
        self._Name = None
        self._Values = None
        self._ExactMatch = None

    @property
    def Name(self):
        r"""字段名； 过滤
子订单号过滤通过name 为：DealName； value为子订单号
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Values(self):
        r"""过滤值
        :rtype: list of str
        """
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values

    @property
    def ExactMatch(self):
        r"""是否精确查找
        :rtype: bool
        """
        return self._ExactMatch

    @ExactMatch.setter
    def ExactMatch(self, ExactMatch):
        self._ExactMatch = ExactMatch


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Values = params.get("Values")
        self._ExactMatch = params.get("ExactMatch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FindAllDomainDetail(AbstractModel):
    r"""域名列表

    """

    def __init__(self):
        r"""
        :param _Appid: 用户id
        :type Appid: int
        :param _Domain: 域名
        :type Domain: str
        :param _Ips: 域名ip
        :type Ips: list of str
        :param _FindTime: 发现时间
        :type FindTime: str
        :param _InstanceId: 实例id
        :type InstanceId: str
        :param _DomainId: 域名id
        :type DomainId: str
        :param _Edition: waf类型
        :type Edition: str
        :param _IsWafDomain: 是否接入waf
        :type IsWafDomain: int
        """
        self._Appid = None
        self._Domain = None
        self._Ips = None
        self._FindTime = None
        self._InstanceId = None
        self._DomainId = None
        self._Edition = None
        self._IsWafDomain = None

    @property
    def Appid(self):
        r"""用户id
        :rtype: int
        """
        return self._Appid

    @Appid.setter
    def Appid(self, Appid):
        self._Appid = Appid

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Ips(self):
        r"""域名ip
        :rtype: list of str
        """
        return self._Ips

    @Ips.setter
    def Ips(self, Ips):
        self._Ips = Ips

    @property
    def FindTime(self):
        r"""发现时间
        :rtype: str
        """
        return self._FindTime

    @FindTime.setter
    def FindTime(self, FindTime):
        self._FindTime = FindTime

    @property
    def InstanceId(self):
        r"""实例id
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def DomainId(self):
        r"""域名id
        :rtype: str
        """
        return self._DomainId

    @DomainId.setter
    def DomainId(self, DomainId):
        self._DomainId = DomainId

    @property
    def Edition(self):
        r"""waf类型
        :rtype: str
        """
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition

    @property
    def IsWafDomain(self):
        r"""是否接入waf
        :rtype: int
        """
        return self._IsWafDomain

    @IsWafDomain.setter
    def IsWafDomain(self, IsWafDomain):
        self._IsWafDomain = IsWafDomain


    def _deserialize(self, params):
        self._Appid = params.get("Appid")
        self._Domain = params.get("Domain")
        self._Ips = params.get("Ips")
        self._FindTime = params.get("FindTime")
        self._InstanceId = params.get("InstanceId")
        self._DomainId = params.get("DomainId")
        self._Edition = params.get("Edition")
        self._IsWafDomain = params.get("IsWafDomain")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FraudPkg(AbstractModel):
    r"""业务安全资源信息

    """

    def __init__(self):
        r"""
        :param _ResourceIds: 资源id
        :type ResourceIds: str
        :param _Status: 状态
        :type Status: int
        :param _Region: 地域
        :type Region: int
        :param _BeginTime: 开始时间
        :type BeginTime: str
        :param _EndTime: 结束时间
        :type EndTime: str
        :param _InquireNum: 申请数量
        :type InquireNum: int
        :param _UsedNum: 使用数量
        :type UsedNum: int
        :param _RenewFlag: 续费标志
        :type RenewFlag: int
        """
        self._ResourceIds = None
        self._Status = None
        self._Region = None
        self._BeginTime = None
        self._EndTime = None
        self._InquireNum = None
        self._UsedNum = None
        self._RenewFlag = None

    @property
    def ResourceIds(self):
        r"""资源id
        :rtype: str
        """
        return self._ResourceIds

    @ResourceIds.setter
    def ResourceIds(self, ResourceIds):
        self._ResourceIds = ResourceIds

    @property
    def Status(self):
        r"""状态
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Region(self):
        r"""地域
        :rtype: int
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def BeginTime(self):
        r"""开始时间
        :rtype: str
        """
        return self._BeginTime

    @BeginTime.setter
    def BeginTime(self, BeginTime):
        self._BeginTime = BeginTime

    @property
    def EndTime(self):
        r"""结束时间
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def InquireNum(self):
        r"""申请数量
        :rtype: int
        """
        return self._InquireNum

    @InquireNum.setter
    def InquireNum(self, InquireNum):
        self._InquireNum = InquireNum

    @property
    def UsedNum(self):
        r"""使用数量
        :rtype: int
        """
        return self._UsedNum

    @UsedNum.setter
    def UsedNum(self, UsedNum):
        self._UsedNum = UsedNum

    @property
    def RenewFlag(self):
        r"""续费标志
        :rtype: int
        """
        return self._RenewFlag

    @RenewFlag.setter
    def RenewFlag(self, RenewFlag):
        self._RenewFlag = RenewFlag


    def _deserialize(self, params):
        self._ResourceIds = params.get("ResourceIds")
        self._Status = params.get("Status")
        self._Region = params.get("Region")
        self._BeginTime = params.get("BeginTime")
        self._EndTime = params.get("EndTime")
        self._InquireNum = params.get("InquireNum")
        self._UsedNum = params.get("UsedNum")
        self._RenewFlag = params.get("RenewFlag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FreshAntiFakeUrlRequest(AbstractModel):
    r"""FreshAntiFakeUrl请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _Id: Id
        :type Id: int
        """
        self._Domain = None
        self._Id = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Id(self):
        r"""Id
        :rtype: int
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FreshAntiFakeUrlResponse(AbstractModel):
    r"""FreshAntiFakeUrl返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 结果成功与否
        :type Result: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        r"""结果成功与否
        :rtype: str
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class GenerateDealsAndPayNewRequest(AbstractModel):
    r"""GenerateDealsAndPayNew请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Goods: 计费下单入参
        :type Goods: list of GoodNews
        """
        self._Goods = None

    @property
    def Goods(self):
        r"""计费下单入参
        :rtype: list of GoodNews
        """
        return self._Goods

    @Goods.setter
    def Goods(self, Goods):
        self._Goods = Goods


    def _deserialize(self, params):
        if params.get("Goods") is not None:
            self._Goods = []
            for item in params.get("Goods"):
                obj = GoodNews()
                obj._deserialize(item)
                self._Goods.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GenerateDealsAndPayNewResponse(AbstractModel):
    r"""GenerateDealsAndPayNew返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 计费下单响应结构体
        :type Data: :class:`tencentcloud.waf.v20180125.models.DealData`
        :param _Status: 1:成功，0:失败
        :type Status: int
        :param _ReturnMessage: 返回message
        :type ReturnMessage: str
        :param _InstanceId: 购买的实例ID
        :type InstanceId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._Status = None
        self._ReturnMessage = None
        self._InstanceId = None
        self._RequestId = None

    @property
    def Data(self):
        r"""计费下单响应结构体
        :rtype: :class:`tencentcloud.waf.v20180125.models.DealData`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def Status(self):
        r"""1:成功，0:失败
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ReturnMessage(self):
        r"""返回message
        :rtype: str
        """
        return self._ReturnMessage

    @ReturnMessage.setter
    def ReturnMessage(self, ReturnMessage):
        self._ReturnMessage = ReturnMessage

    @property
    def InstanceId(self):
        r"""购买的实例ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DealData()
            self._Data._deserialize(params.get("Data"))
        self._Status = params.get("Status")
        self._ReturnMessage = params.get("ReturnMessage")
        self._InstanceId = params.get("InstanceId")
        self._RequestId = params.get("RequestId")


class GetAttackDownloadRecordsRequest(AbstractModel):
    r"""GetAttackDownloadRecords请求参数结构体

    """


class GetAttackDownloadRecordsResponse(AbstractModel):
    r"""GetAttackDownloadRecords返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Records: 下载攻击日志记录数组
        :type Records: list of DownloadAttackRecordInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Records = None
        self._RequestId = None

    @property
    def Records(self):
        r"""下载攻击日志记录数组
        :rtype: list of DownloadAttackRecordInfo
        """
        return self._Records

    @Records.setter
    def Records(self, Records):
        self._Records = Records

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Records") is not None:
            self._Records = []
            for item in params.get("Records"):
                obj = DownloadAttackRecordInfo()
                obj._deserialize(item)
                self._Records.append(obj)
        self._RequestId = params.get("RequestId")


class GetAttackHistogramRequest(AbstractModel):
    r"""GetAttackHistogram请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 查询的域名，所有域名使用all
        :type Domain: str
        :param _StartTime: 查询起始时间
        :type StartTime: str
        :param _EndTime: 查询结束时间
        :type EndTime: str
        :param _QueryString: Lucene语法
        :type QueryString: str
        """
        self._Domain = None
        self._StartTime = None
        self._EndTime = None
        self._QueryString = None

    @property
    def Domain(self):
        r"""查询的域名，所有域名使用all
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def StartTime(self):
        r"""查询起始时间
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""查询结束时间
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def QueryString(self):
        r"""Lucene语法
        :rtype: str
        """
        return self._QueryString

    @QueryString.setter
    def QueryString(self, QueryString):
        self._QueryString = QueryString


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._QueryString = params.get("QueryString")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GetAttackHistogramResponse(AbstractModel):
    r"""GetAttackHistogram返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 统计详情
        :type Data: list of LogHistogramInfo
        :param _Period: 时间段大小
        :type Period: int
        :param _TotalCount: 统计的条目数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._Period = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def Data(self):
        r"""统计详情
        :rtype: list of LogHistogramInfo
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def Period(self):
        r"""时间段大小
        :rtype: int
        """
        return self._Period

    @Period.setter
    def Period(self, Period):
        self._Period = Period

    @property
    def TotalCount(self):
        r"""统计的条目数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = LogHistogramInfo()
                obj._deserialize(item)
                self._Data.append(obj)
        self._Period = params.get("Period")
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class GetAttackTotalCountRequest(AbstractModel):
    r"""GetAttackTotalCount请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: 起始时间
        :type StartTime: str
        :param _EndTime: 结束时间
        :type EndTime: str
        :param _Domain: 查询的域名，全部域名填all
        :type Domain: str
        :param _QueryString: 查询条件，默认为""
        :type QueryString: str
        """
        self._StartTime = None
        self._EndTime = None
        self._Domain = None
        self._QueryString = None

    @property
    def StartTime(self):
        r"""起始时间
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""结束时间
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Domain(self):
        r"""查询的域名，全部域名填all
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def QueryString(self):
        r"""查询条件，默认为""
        :rtype: str
        """
        return self._QueryString

    @QueryString.setter
    def QueryString(self, QueryString):
        self._QueryString = QueryString


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Domain = params.get("Domain")
        self._QueryString = params.get("QueryString")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GetAttackTotalCountResponse(AbstractModel):
    r"""GetAttackTotalCount返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 攻击总次数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""攻击总次数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class GetInstanceQpsLimitRequest(AbstractModel):
    r"""GetInstanceQpsLimit请求参数结构体

    """

    def __init__(self):
        r"""
        :param _InstanceId: 套餐实例id
        :type InstanceId: str
        :param _Type: 套餐类型
        :type Type: str
        """
        self._InstanceId = None
        self._Type = None

    @property
    def InstanceId(self):
        r"""套餐实例id
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Type(self):
        r"""套餐类型
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GetInstanceQpsLimitResponse(AbstractModel):
    r"""GetInstanceQpsLimit返回参数结构体

    """

    def __init__(self):
        r"""
        :param _QpsData: 弹性qps相关值集合
        :type QpsData: :class:`tencentcloud.waf.v20180125.models.QpsData`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._QpsData = None
        self._RequestId = None

    @property
    def QpsData(self):
        r"""弹性qps相关值集合
        :rtype: :class:`tencentcloud.waf.v20180125.models.QpsData`
        """
        return self._QpsData

    @QpsData.setter
    def QpsData(self, QpsData):
        self._QpsData = QpsData

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("QpsData") is not None:
            self._QpsData = QpsData()
            self._QpsData._deserialize(params.get("QpsData"))
        self._RequestId = params.get("RequestId")


class GlobalSceneInfo(AbstractModel):
    r"""当前开启的、匹配范围为全局、优先级最高的场景信息

    """

    def __init__(self):
        r"""
        :param _SceneId: 场景ID
        :type SceneId: str
        :param _SceneName: 场景名称
        :type SceneName: str
        :param _Priority: 场景优先级
        :type Priority: int
        :param _UpdateTime: 场景更新时间
        :type UpdateTime: int
        """
        self._SceneId = None
        self._SceneName = None
        self._Priority = None
        self._UpdateTime = None

    @property
    def SceneId(self):
        r"""场景ID
        :rtype: str
        """
        return self._SceneId

    @SceneId.setter
    def SceneId(self, SceneId):
        self._SceneId = SceneId

    @property
    def SceneName(self):
        r"""场景名称
        :rtype: str
        """
        return self._SceneName

    @SceneName.setter
    def SceneName(self, SceneName):
        self._SceneName = SceneName

    @property
    def Priority(self):
        r"""场景优先级
        :rtype: int
        """
        return self._Priority

    @Priority.setter
    def Priority(self, Priority):
        self._Priority = Priority

    @property
    def UpdateTime(self):
        r"""场景更新时间
        :rtype: int
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._SceneId = params.get("SceneId")
        self._SceneName = params.get("SceneName")
        self._Priority = params.get("Priority")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GoodNews(AbstractModel):
    r"""计费下单接口出入参Goods

    """

    def __init__(self):
        r"""
        :param _GoodsNum: 商品数量
        :type GoodsNum: int
        :param _GoodsDetail: 商品明细
        :type GoodsDetail: :class:`tencentcloud.waf.v20180125.models.GoodsDetailNew`
        :param _GoodsCategoryId: 订单类型ID，用来唯一标识一个业务的一种场景（总共三种场景：新购、配置变更、续费）
高级版: 102375(新购),102376(续费),102377(变配)
企业版 : 102378(新购),102379(续费),102380(变配)
旗舰版 : 102369(新购),102370(续费),102371(变配)
域名包 : 102372(新购),102373(续费),102374(变配)
业务扩展包 : 101040(新购),101041(续费),101042(变配)

高级版-CLB: 新购 101198  续费 101199 变配 101200
企业版-CLB 101204(新购),101205(续费),101206(变配)
旗舰版-CLB : 101201(新购),101202(续费),101203(变配)
域名包-CLB: 101207(新购),101208(续费),101209(变配)
业务扩展包-CLB: 101210(新购),101211(续费),101212(变配)

        :type GoodsCategoryId: int
        :param _RegionId: 购买waf实例区域ID
1 表示购买大陆资源;
9表示购买非中国大陆资源
        :type RegionId: int
        """
        self._GoodsNum = None
        self._GoodsDetail = None
        self._GoodsCategoryId = None
        self._RegionId = None

    @property
    def GoodsNum(self):
        r"""商品数量
        :rtype: int
        """
        return self._GoodsNum

    @GoodsNum.setter
    def GoodsNum(self, GoodsNum):
        self._GoodsNum = GoodsNum

    @property
    def GoodsDetail(self):
        r"""商品明细
        :rtype: :class:`tencentcloud.waf.v20180125.models.GoodsDetailNew`
        """
        return self._GoodsDetail

    @GoodsDetail.setter
    def GoodsDetail(self, GoodsDetail):
        self._GoodsDetail = GoodsDetail

    @property
    def GoodsCategoryId(self):
        r"""订单类型ID，用来唯一标识一个业务的一种场景（总共三种场景：新购、配置变更、续费）
高级版: 102375(新购),102376(续费),102377(变配)
企业版 : 102378(新购),102379(续费),102380(变配)
旗舰版 : 102369(新购),102370(续费),102371(变配)
域名包 : 102372(新购),102373(续费),102374(变配)
业务扩展包 : 101040(新购),101041(续费),101042(变配)

高级版-CLB: 新购 101198  续费 101199 变配 101200
企业版-CLB 101204(新购),101205(续费),101206(变配)
旗舰版-CLB : 101201(新购),101202(续费),101203(变配)
域名包-CLB: 101207(新购),101208(续费),101209(变配)
业务扩展包-CLB: 101210(新购),101211(续费),101212(变配)

        :rtype: int
        """
        return self._GoodsCategoryId

    @GoodsCategoryId.setter
    def GoodsCategoryId(self, GoodsCategoryId):
        self._GoodsCategoryId = GoodsCategoryId

    @property
    def RegionId(self):
        r"""购买waf实例区域ID
1 表示购买大陆资源;
9表示购买非中国大陆资源
        :rtype: int
        """
        return self._RegionId

    @RegionId.setter
    def RegionId(self, RegionId):
        self._RegionId = RegionId


    def _deserialize(self, params):
        self._GoodsNum = params.get("GoodsNum")
        if params.get("GoodsDetail") is not None:
            self._GoodsDetail = GoodsDetailNew()
            self._GoodsDetail._deserialize(params.get("GoodsDetail"))
        self._GoodsCategoryId = params.get("GoodsCategoryId")
        self._RegionId = params.get("RegionId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Goods(AbstractModel):
    r"""计费下单接口出入参Goods

    """

    def __init__(self):
        r"""
        :param _PayMode: 付费类型，1:预付费，0:后付费
        :type PayMode: int
        :param _GoodsNum: 商品数量
        :type GoodsNum: int
        :param _GoodsDetail: 商品明细
        :type GoodsDetail: :class:`tencentcloud.waf.v20180125.models.GoodsDetail`
        :param _ProjectId: 默认为0
        :type ProjectId: int
        :param _GoodsCategoryId: 计费类目ID，对应cid
        :type GoodsCategoryId: int
        :param _Platform: 平台类型，默认1
        :type Platform: int
        :param _RegionId: 购买waf实例区域ID
        :type RegionId: int
        """
        self._PayMode = None
        self._GoodsNum = None
        self._GoodsDetail = None
        self._ProjectId = None
        self._GoodsCategoryId = None
        self._Platform = None
        self._RegionId = None

    @property
    def PayMode(self):
        r"""付费类型，1:预付费，0:后付费
        :rtype: int
        """
        return self._PayMode

    @PayMode.setter
    def PayMode(self, PayMode):
        self._PayMode = PayMode

    @property
    def GoodsNum(self):
        r"""商品数量
        :rtype: int
        """
        return self._GoodsNum

    @GoodsNum.setter
    def GoodsNum(self, GoodsNum):
        self._GoodsNum = GoodsNum

    @property
    def GoodsDetail(self):
        r"""商品明细
        :rtype: :class:`tencentcloud.waf.v20180125.models.GoodsDetail`
        """
        return self._GoodsDetail

    @GoodsDetail.setter
    def GoodsDetail(self, GoodsDetail):
        self._GoodsDetail = GoodsDetail

    @property
    def ProjectId(self):
        r"""默认为0
        :rtype: int
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def GoodsCategoryId(self):
        r"""计费类目ID，对应cid
        :rtype: int
        """
        return self._GoodsCategoryId

    @GoodsCategoryId.setter
    def GoodsCategoryId(self, GoodsCategoryId):
        self._GoodsCategoryId = GoodsCategoryId

    @property
    def Platform(self):
        r"""平台类型，默认1
        :rtype: int
        """
        return self._Platform

    @Platform.setter
    def Platform(self, Platform):
        self._Platform = Platform

    @property
    def RegionId(self):
        r"""购买waf实例区域ID
        :rtype: int
        """
        return self._RegionId

    @RegionId.setter
    def RegionId(self, RegionId):
        self._RegionId = RegionId


    def _deserialize(self, params):
        self._PayMode = params.get("PayMode")
        self._GoodsNum = params.get("GoodsNum")
        if params.get("GoodsDetail") is not None:
            self._GoodsDetail = GoodsDetail()
            self._GoodsDetail._deserialize(params.get("GoodsDetail"))
        self._ProjectId = params.get("ProjectId")
        self._GoodsCategoryId = params.get("GoodsCategoryId")
        self._Platform = params.get("Platform")
        self._RegionId = params.get("RegionId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GoodsDetail(AbstractModel):
    r"""产品明细

    """

    def __init__(self):
        r"""
        :param _TimeSpan: 时间间隔
        :type TimeSpan: int
        :param _TimeUnit: 单位，支持m、y、d
        :type TimeUnit: str
        :param _ProductCode: 产品码
        :type ProductCode: str
        :param _SubProductCode: 二级产品码
        :type SubProductCode: str
        :param _Pid: 计费策略id
        :type Pid: int
        :param _ProductInfo: waf产品码
        :type ProductInfo: list of ProductInfo
        :param _InstanceName: waf实例名
        :type InstanceName: str
        :param _ElasticQps: QPS数量
        :type ElasticQps: int
        :param _FlexBill: 弹性账单
        :type FlexBill: int
        :param _AutoRenewFlag: 1:自动续费，0:不自动续费
        :type AutoRenewFlag: int
        :param _RealRegion: waf购买的实际地域信息
        :type RealRegion: int
        :param _Type: Waf实例对应的二级产品码
        :type Type: str
        :param _LabelTypes: 计费细项标签数组
        :type LabelTypes: list of str
        :param _LabelCounts: 计费细项标签数量，一般和SvLabelType一一对应
        :type LabelCounts: list of int
        :param _CurDeadline: 变配使用，实例到期时间
        :type CurDeadline: str
        :param _InstanceId: 对存在的实例购买bot 或api 安全
        :type InstanceId: str
        """
        self._TimeSpan = None
        self._TimeUnit = None
        self._ProductCode = None
        self._SubProductCode = None
        self._Pid = None
        self._ProductInfo = None
        self._InstanceName = None
        self._ElasticQps = None
        self._FlexBill = None
        self._AutoRenewFlag = None
        self._RealRegion = None
        self._Type = None
        self._LabelTypes = None
        self._LabelCounts = None
        self._CurDeadline = None
        self._InstanceId = None

    @property
    def TimeSpan(self):
        r"""时间间隔
        :rtype: int
        """
        return self._TimeSpan

    @TimeSpan.setter
    def TimeSpan(self, TimeSpan):
        self._TimeSpan = TimeSpan

    @property
    def TimeUnit(self):
        r"""单位，支持m、y、d
        :rtype: str
        """
        return self._TimeUnit

    @TimeUnit.setter
    def TimeUnit(self, TimeUnit):
        self._TimeUnit = TimeUnit

    @property
    def ProductCode(self):
        r"""产品码
        :rtype: str
        """
        return self._ProductCode

    @ProductCode.setter
    def ProductCode(self, ProductCode):
        self._ProductCode = ProductCode

    @property
    def SubProductCode(self):
        r"""二级产品码
        :rtype: str
        """
        return self._SubProductCode

    @SubProductCode.setter
    def SubProductCode(self, SubProductCode):
        self._SubProductCode = SubProductCode

    @property
    def Pid(self):
        r"""计费策略id
        :rtype: int
        """
        return self._Pid

    @Pid.setter
    def Pid(self, Pid):
        self._Pid = Pid

    @property
    def ProductInfo(self):
        r"""waf产品码
        :rtype: list of ProductInfo
        """
        return self._ProductInfo

    @ProductInfo.setter
    def ProductInfo(self, ProductInfo):
        self._ProductInfo = ProductInfo

    @property
    def InstanceName(self):
        r"""waf实例名
        :rtype: str
        """
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def ElasticQps(self):
        r"""QPS数量
        :rtype: int
        """
        return self._ElasticQps

    @ElasticQps.setter
    def ElasticQps(self, ElasticQps):
        self._ElasticQps = ElasticQps

    @property
    def FlexBill(self):
        r"""弹性账单
        :rtype: int
        """
        return self._FlexBill

    @FlexBill.setter
    def FlexBill(self, FlexBill):
        self._FlexBill = FlexBill

    @property
    def AutoRenewFlag(self):
        r"""1:自动续费，0:不自动续费
        :rtype: int
        """
        return self._AutoRenewFlag

    @AutoRenewFlag.setter
    def AutoRenewFlag(self, AutoRenewFlag):
        self._AutoRenewFlag = AutoRenewFlag

    @property
    def RealRegion(self):
        r"""waf购买的实际地域信息
        :rtype: int
        """
        return self._RealRegion

    @RealRegion.setter
    def RealRegion(self, RealRegion):
        self._RealRegion = RealRegion

    @property
    def Type(self):
        r"""Waf实例对应的二级产品码
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def LabelTypes(self):
        r"""计费细项标签数组
        :rtype: list of str
        """
        return self._LabelTypes

    @LabelTypes.setter
    def LabelTypes(self, LabelTypes):
        self._LabelTypes = LabelTypes

    @property
    def LabelCounts(self):
        r"""计费细项标签数量，一般和SvLabelType一一对应
        :rtype: list of int
        """
        return self._LabelCounts

    @LabelCounts.setter
    def LabelCounts(self, LabelCounts):
        self._LabelCounts = LabelCounts

    @property
    def CurDeadline(self):
        r"""变配使用，实例到期时间
        :rtype: str
        """
        return self._CurDeadline

    @CurDeadline.setter
    def CurDeadline(self, CurDeadline):
        self._CurDeadline = CurDeadline

    @property
    def InstanceId(self):
        r"""对存在的实例购买bot 或api 安全
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId


    def _deserialize(self, params):
        self._TimeSpan = params.get("TimeSpan")
        self._TimeUnit = params.get("TimeUnit")
        self._ProductCode = params.get("ProductCode")
        self._SubProductCode = params.get("SubProductCode")
        self._Pid = params.get("Pid")
        if params.get("ProductInfo") is not None:
            self._ProductInfo = []
            for item in params.get("ProductInfo"):
                obj = ProductInfo()
                obj._deserialize(item)
                self._ProductInfo.append(obj)
        self._InstanceName = params.get("InstanceName")
        self._ElasticQps = params.get("ElasticQps")
        self._FlexBill = params.get("FlexBill")
        self._AutoRenewFlag = params.get("AutoRenewFlag")
        self._RealRegion = params.get("RealRegion")
        self._Type = params.get("Type")
        self._LabelTypes = params.get("LabelTypes")
        self._LabelCounts = params.get("LabelCounts")
        self._CurDeadline = params.get("CurDeadline")
        self._InstanceId = params.get("InstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GoodsDetailNew(AbstractModel):
    r"""产品明细

    """

    def __init__(self):
        r"""
        :param _TimeSpan: 时间间隔
        :type TimeSpan: int
        :param _TimeUnit: 单位，支持购买d、m、y 即（日、月、年）
        :type TimeUnit: str
        :param _SubProductCode: 子产品标签,。新购，续费必传，变配时放在oldConfig newConfig里面

Saas 高级版 ：sp_wsm_waf_premium
Saas企业版 ：sp_wsm_waf_enterprise
Saas旗舰版 ：sp_wsm_waf_ultimate
Saas 业务扩展包：sp_wsm_waf_qpsep
Saas 域名扩展包：sp_wsm_waf_domain

高级版-CLB:sp_wsm_waf_premium_clb
企业版-CLB : sp_wsm_waf_enterprise_clb
旗舰版-CLB:sp_wsm_waf_ultimate_clb
 业务扩展包-CLB：sp_wsm_waf_qpsep_clb
域名扩展包-CLB：sp_wsm_waf_domain_clb

        :type SubProductCode: str
        :param _Pid: 业务产品申请的pid（对应一个定价公式），通过pid计费查询到定价模型
高级版 ：1000827
企业版 ：1000830
旗舰版 ：1000832
域名包 : 1000834
业务扩展包 : 1000481
高级版-CLB:1001150
企业版-CLB : 1001152
旗舰版-CLB:1001154
域名包-CLB: 1001156
业务扩展包-CLB : 1001160

        :type Pid: int
        :param _InstanceName: waf实例名
        :type InstanceName: str
        :param _AutoRenewFlag: 1:自动续费，0:不自动续费
        :type AutoRenewFlag: int
        :param _RealRegion: waf购买的实际地域信息
        :type RealRegion: int
        :param _LabelTypes: 计费细项标签数组
Saas 高级版  sv_wsm_waf_package_premium 
Saas 企业版  sv_wsm_waf_package_enterprise
Saas 旗舰版  sv_wsm_waf_package_ultimate 
Saas 非中国大陆高级版  sv_wsm_waf_package_premium_intl
Saas 非中国大陆企业版   sv_wsm_waf_package_enterprise_intl
Saas 非中国大陆旗舰版  sv_wsm_waf_package_ultimate _intl
Saas 业务扩展包  sv_wsm_waf_qps_ep
Saas 域名扩展包  sv_wsm_waf_domain

高级版CLB   sv_wsm_waf_package_premium_clb
企业版CLB  sv_wsm_waf_package_enterprise_clb
旗舰版CLB   sv_wsm_waf_package_ultimate_clb
非中国大陆高级版 CLB sv_wsm_waf_package_premium_clb_intl
非中国大陆企业版CLB   sv_wsm_waf_package_premium_clb_intl
非中国大陆旗舰版CLB  sv_wsm_waf_package_ultimate_clb _intl
业务扩展包CLB sv_wsm_waf_qps_ep_clb
域名扩展包CLB  sv_wsm_waf_domain_clb

        :type LabelTypes: list of str
        :param _LabelCounts: 计费细项标签数量，一般和SvLabelType一一对应
        :type LabelCounts: list of int
        :param _CurDeadline: 变配使用，实例到期时间
        :type CurDeadline: str
        :param _InstanceId: 对存在的实例购买bot 或api 安全
        :type InstanceId: str
        :param _ResourceId: 资源id
        :type ResourceId: str
        :param _MicroVersion: 模式clb-waf或者saas-waf
        :type MicroVersion: str
        """
        self._TimeSpan = None
        self._TimeUnit = None
        self._SubProductCode = None
        self._Pid = None
        self._InstanceName = None
        self._AutoRenewFlag = None
        self._RealRegion = None
        self._LabelTypes = None
        self._LabelCounts = None
        self._CurDeadline = None
        self._InstanceId = None
        self._ResourceId = None
        self._MicroVersion = None

    @property
    def TimeSpan(self):
        r"""时间间隔
        :rtype: int
        """
        return self._TimeSpan

    @TimeSpan.setter
    def TimeSpan(self, TimeSpan):
        self._TimeSpan = TimeSpan

    @property
    def TimeUnit(self):
        r"""单位，支持购买d、m、y 即（日、月、年）
        :rtype: str
        """
        return self._TimeUnit

    @TimeUnit.setter
    def TimeUnit(self, TimeUnit):
        self._TimeUnit = TimeUnit

    @property
    def SubProductCode(self):
        r"""子产品标签,。新购，续费必传，变配时放在oldConfig newConfig里面

Saas 高级版 ：sp_wsm_waf_premium
Saas企业版 ：sp_wsm_waf_enterprise
Saas旗舰版 ：sp_wsm_waf_ultimate
Saas 业务扩展包：sp_wsm_waf_qpsep
Saas 域名扩展包：sp_wsm_waf_domain

高级版-CLB:sp_wsm_waf_premium_clb
企业版-CLB : sp_wsm_waf_enterprise_clb
旗舰版-CLB:sp_wsm_waf_ultimate_clb
 业务扩展包-CLB：sp_wsm_waf_qpsep_clb
域名扩展包-CLB：sp_wsm_waf_domain_clb

        :rtype: str
        """
        return self._SubProductCode

    @SubProductCode.setter
    def SubProductCode(self, SubProductCode):
        self._SubProductCode = SubProductCode

    @property
    def Pid(self):
        r"""业务产品申请的pid（对应一个定价公式），通过pid计费查询到定价模型
高级版 ：1000827
企业版 ：1000830
旗舰版 ：1000832
域名包 : 1000834
业务扩展包 : 1000481
高级版-CLB:1001150
企业版-CLB : 1001152
旗舰版-CLB:1001154
域名包-CLB: 1001156
业务扩展包-CLB : 1001160

        :rtype: int
        """
        return self._Pid

    @Pid.setter
    def Pid(self, Pid):
        self._Pid = Pid

    @property
    def InstanceName(self):
        r"""waf实例名
        :rtype: str
        """
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def AutoRenewFlag(self):
        r"""1:自动续费，0:不自动续费
        :rtype: int
        """
        return self._AutoRenewFlag

    @AutoRenewFlag.setter
    def AutoRenewFlag(self, AutoRenewFlag):
        self._AutoRenewFlag = AutoRenewFlag

    @property
    def RealRegion(self):
        r"""waf购买的实际地域信息
        :rtype: int
        """
        return self._RealRegion

    @RealRegion.setter
    def RealRegion(self, RealRegion):
        self._RealRegion = RealRegion

    @property
    def LabelTypes(self):
        r"""计费细项标签数组
Saas 高级版  sv_wsm_waf_package_premium 
Saas 企业版  sv_wsm_waf_package_enterprise
Saas 旗舰版  sv_wsm_waf_package_ultimate 
Saas 非中国大陆高级版  sv_wsm_waf_package_premium_intl
Saas 非中国大陆企业版   sv_wsm_waf_package_enterprise_intl
Saas 非中国大陆旗舰版  sv_wsm_waf_package_ultimate _intl
Saas 业务扩展包  sv_wsm_waf_qps_ep
Saas 域名扩展包  sv_wsm_waf_domain

高级版CLB   sv_wsm_waf_package_premium_clb
企业版CLB  sv_wsm_waf_package_enterprise_clb
旗舰版CLB   sv_wsm_waf_package_ultimate_clb
非中国大陆高级版 CLB sv_wsm_waf_package_premium_clb_intl
非中国大陆企业版CLB   sv_wsm_waf_package_premium_clb_intl
非中国大陆旗舰版CLB  sv_wsm_waf_package_ultimate_clb _intl
业务扩展包CLB sv_wsm_waf_qps_ep_clb
域名扩展包CLB  sv_wsm_waf_domain_clb

        :rtype: list of str
        """
        return self._LabelTypes

    @LabelTypes.setter
    def LabelTypes(self, LabelTypes):
        self._LabelTypes = LabelTypes

    @property
    def LabelCounts(self):
        r"""计费细项标签数量，一般和SvLabelType一一对应
        :rtype: list of int
        """
        return self._LabelCounts

    @LabelCounts.setter
    def LabelCounts(self, LabelCounts):
        self._LabelCounts = LabelCounts

    @property
    def CurDeadline(self):
        r"""变配使用，实例到期时间
        :rtype: str
        """
        return self._CurDeadline

    @CurDeadline.setter
    def CurDeadline(self, CurDeadline):
        self._CurDeadline = CurDeadline

    @property
    def InstanceId(self):
        r"""对存在的实例购买bot 或api 安全
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def ResourceId(self):
        r"""资源id
        :rtype: str
        """
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId

    @property
    def MicroVersion(self):
        r"""模式clb-waf或者saas-waf
        :rtype: str
        """
        return self._MicroVersion

    @MicroVersion.setter
    def MicroVersion(self, MicroVersion):
        self._MicroVersion = MicroVersion


    def _deserialize(self, params):
        self._TimeSpan = params.get("TimeSpan")
        self._TimeUnit = params.get("TimeUnit")
        self._SubProductCode = params.get("SubProductCode")
        self._Pid = params.get("Pid")
        self._InstanceName = params.get("InstanceName")
        self._AutoRenewFlag = params.get("AutoRenewFlag")
        self._RealRegion = params.get("RealRegion")
        self._LabelTypes = params.get("LabelTypes")
        self._LabelCounts = params.get("LabelCounts")
        self._CurDeadline = params.get("CurDeadline")
        self._InstanceId = params.get("InstanceId")
        self._ResourceId = params.get("ResourceId")
        self._MicroVersion = params.get("MicroVersion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class HistogramInfo(AbstractModel):
    r"""直方图详细信息

    """

    def __init__(self):
        r"""
        :param _Count: 统计周期内的日志条数
        :type Count: int
        :param _BTime: 按 period 取整后的 unix timestamp： 单位毫秒
        :type BTime: int
        """
        self._Count = None
        self._BTime = None

    @property
    def Count(self):
        r"""统计周期内的日志条数
        :rtype: int
        """
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def BTime(self):
        r"""按 period 取整后的 unix timestamp： 单位毫秒
        :rtype: int
        """
        return self._BTime

    @BTime.setter
    def BTime(self, BTime):
        self._BTime = BTime


    def _deserialize(self, params):
        self._Count = params.get("Count")
        self._BTime = params.get("BTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class HostDel(AbstractModel):
    r"""CLB-WAF删除域名参数

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _DomainId: 域名ID
        :type DomainId: str
        :param _InstanceID: 实例类型
        :type InstanceID: str
        """
        self._Domain = None
        self._DomainId = None
        self._InstanceID = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def DomainId(self):
        r"""域名ID
        :rtype: str
        """
        return self._DomainId

    @DomainId.setter
    def DomainId(self, DomainId):
        self._DomainId = DomainId

    @property
    def InstanceID(self):
        r"""实例类型
        :rtype: str
        """
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._DomainId = params.get("DomainId")
        self._InstanceID = params.get("InstanceID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class HostRecord(AbstractModel):
    r"""负载均衡型WAF域名信息

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _DomainId: 域名唯一ID
        :type DomainId: str
        :param _MainDomain: 主域名，入参时为空
        :type MainDomain: str
        :param _Mode: 规则引擎防护模式。
0：观察模式
1：拦截模式
        :type Mode: int
        :param _Status: waf和负载均衡器的绑定关系。
0：未绑定
1：已绑定
        :type Status: int
        :param _State: clbwaf域名监听器状态。
0：操作成功
4：正在绑定LB
6：正在解绑LB 
7：解绑LB失败 
8：绑定LB失败 
10：内部错误
        :type State: int
        :param _Engine: 规则引擎和AI引擎防护模式联合状态。
1:初始状态,规则引擎拦截&&AI引擎未操作开关状态
10：规则引擎观察&&AI引擎关闭模式 
11：规则引擎观察&&AI引擎观察模式 
12：规则引擎观察&&AI引擎拦截模式 
20：规则引擎拦截&&AI引擎关闭模式 
21：规则引擎拦截&&AI引擎观察模式 
22：规则引擎拦截&&AI引擎拦截模式
        :type Engine: int
        :param _IsCdn: waf前是否部署有七层代理服务。 0：没有部署代理服务 1：有部署代理服务，waf将使用XFF获取客户端IP 2：有部署代理服务，waf将使用remote_addr获取客户端IP 3：有部署代理服务，waf将使用ip_headers中的自定义header获取客户端IP
        :type IsCdn: int
        :param _LoadBalancerSet: 绑定的负载均衡器信息列表
        :type LoadBalancerSet: list of LoadBalancer
        :param _Region: 域名绑定的LB的地域，以逗号分割多个地域
        :type Region: str
        :param _Edition: 域名所属实例类型。负载均衡型WAF为"clb-waf"
        :type Edition: str
        :param _FlowMode: 负载均衡型WAF域名的流量模式。
1：清洗模式
0：镜像模式
        :type FlowMode: int
        :param _ClsStatus: 是否开启访问日志。
1：开启
0：关闭
        :type ClsStatus: int
        :param _Level: 防护等级，可选值100,200,300
        :type Level: int
        :param _CdcClusters: 域名需要下发到的cdc集群列表。仅CDC场景下填充
        :type CdcClusters: list of str
        :param _AlbType: 应用型负载均衡类型，默认clb。 
clb：七层负载均衡器类型 
apisix：apisix网关型
tsegw：云原生API网关
scf：云函数
        :type AlbType: str
        :param _IpHeaders: IsCdn=3时，需要填此参数，表示自定义header
        :type IpHeaders: list of str
        :param _EngineType: 规则引擎类型。
1: menshen
2: tiga
        :type EngineType: int
        :param _CloudType: 云类型。
public:公有云
private:私有云
hybrid:混合云
        :type CloudType: str
        :param _Note: 域名备注信息
        :type Note: str
        """
        self._Domain = None
        self._DomainId = None
        self._MainDomain = None
        self._Mode = None
        self._Status = None
        self._State = None
        self._Engine = None
        self._IsCdn = None
        self._LoadBalancerSet = None
        self._Region = None
        self._Edition = None
        self._FlowMode = None
        self._ClsStatus = None
        self._Level = None
        self._CdcClusters = None
        self._AlbType = None
        self._IpHeaders = None
        self._EngineType = None
        self._CloudType = None
        self._Note = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def DomainId(self):
        r"""域名唯一ID
        :rtype: str
        """
        return self._DomainId

    @DomainId.setter
    def DomainId(self, DomainId):
        self._DomainId = DomainId

    @property
    def MainDomain(self):
        r"""主域名，入参时为空
        :rtype: str
        """
        return self._MainDomain

    @MainDomain.setter
    def MainDomain(self, MainDomain):
        self._MainDomain = MainDomain

    @property
    def Mode(self):
        r"""规则引擎防护模式。
0：观察模式
1：拦截模式
        :rtype: int
        """
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode

    @property
    def Status(self):
        r"""waf和负载均衡器的绑定关系。
0：未绑定
1：已绑定
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def State(self):
        r"""clbwaf域名监听器状态。
0：操作成功
4：正在绑定LB
6：正在解绑LB 
7：解绑LB失败 
8：绑定LB失败 
10：内部错误
        :rtype: int
        """
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def Engine(self):
        r"""规则引擎和AI引擎防护模式联合状态。
1:初始状态,规则引擎拦截&&AI引擎未操作开关状态
10：规则引擎观察&&AI引擎关闭模式 
11：规则引擎观察&&AI引擎观察模式 
12：规则引擎观察&&AI引擎拦截模式 
20：规则引擎拦截&&AI引擎关闭模式 
21：规则引擎拦截&&AI引擎观察模式 
22：规则引擎拦截&&AI引擎拦截模式
        :rtype: int
        """
        return self._Engine

    @Engine.setter
    def Engine(self, Engine):
        self._Engine = Engine

    @property
    def IsCdn(self):
        r"""waf前是否部署有七层代理服务。 0：没有部署代理服务 1：有部署代理服务，waf将使用XFF获取客户端IP 2：有部署代理服务，waf将使用remote_addr获取客户端IP 3：有部署代理服务，waf将使用ip_headers中的自定义header获取客户端IP
        :rtype: int
        """
        return self._IsCdn

    @IsCdn.setter
    def IsCdn(self, IsCdn):
        self._IsCdn = IsCdn

    @property
    def LoadBalancerSet(self):
        r"""绑定的负载均衡器信息列表
        :rtype: list of LoadBalancer
        """
        return self._LoadBalancerSet

    @LoadBalancerSet.setter
    def LoadBalancerSet(self, LoadBalancerSet):
        self._LoadBalancerSet = LoadBalancerSet

    @property
    def Region(self):
        r"""域名绑定的LB的地域，以逗号分割多个地域
        :rtype: str
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def Edition(self):
        r"""域名所属实例类型。负载均衡型WAF为"clb-waf"
        :rtype: str
        """
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition

    @property
    def FlowMode(self):
        r"""负载均衡型WAF域名的流量模式。
1：清洗模式
0：镜像模式
        :rtype: int
        """
        return self._FlowMode

    @FlowMode.setter
    def FlowMode(self, FlowMode):
        self._FlowMode = FlowMode

    @property
    def ClsStatus(self):
        r"""是否开启访问日志。
1：开启
0：关闭
        :rtype: int
        """
        return self._ClsStatus

    @ClsStatus.setter
    def ClsStatus(self, ClsStatus):
        self._ClsStatus = ClsStatus

    @property
    def Level(self):
        r"""防护等级，可选值100,200,300
        :rtype: int
        """
        return self._Level

    @Level.setter
    def Level(self, Level):
        self._Level = Level

    @property
    def CdcClusters(self):
        r"""域名需要下发到的cdc集群列表。仅CDC场景下填充
        :rtype: list of str
        """
        return self._CdcClusters

    @CdcClusters.setter
    def CdcClusters(self, CdcClusters):
        self._CdcClusters = CdcClusters

    @property
    def AlbType(self):
        r"""应用型负载均衡类型，默认clb。 
clb：七层负载均衡器类型 
apisix：apisix网关型
tsegw：云原生API网关
scf：云函数
        :rtype: str
        """
        return self._AlbType

    @AlbType.setter
    def AlbType(self, AlbType):
        self._AlbType = AlbType

    @property
    def IpHeaders(self):
        r"""IsCdn=3时，需要填此参数，表示自定义header
        :rtype: list of str
        """
        return self._IpHeaders

    @IpHeaders.setter
    def IpHeaders(self, IpHeaders):
        self._IpHeaders = IpHeaders

    @property
    def EngineType(self):
        r"""规则引擎类型。
1: menshen
2: tiga
        :rtype: int
        """
        return self._EngineType

    @EngineType.setter
    def EngineType(self, EngineType):
        self._EngineType = EngineType

    @property
    def CloudType(self):
        r"""云类型。
public:公有云
private:私有云
hybrid:混合云
        :rtype: str
        """
        return self._CloudType

    @CloudType.setter
    def CloudType(self, CloudType):
        self._CloudType = CloudType

    @property
    def Note(self):
        r"""域名备注信息
        :rtype: str
        """
        return self._Note

    @Note.setter
    def Note(self, Note):
        self._Note = Note


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._DomainId = params.get("DomainId")
        self._MainDomain = params.get("MainDomain")
        self._Mode = params.get("Mode")
        self._Status = params.get("Status")
        self._State = params.get("State")
        self._Engine = params.get("Engine")
        self._IsCdn = params.get("IsCdn")
        if params.get("LoadBalancerSet") is not None:
            self._LoadBalancerSet = []
            for item in params.get("LoadBalancerSet"):
                obj = LoadBalancer()
                obj._deserialize(item)
                self._LoadBalancerSet.append(obj)
        self._Region = params.get("Region")
        self._Edition = params.get("Edition")
        self._FlowMode = params.get("FlowMode")
        self._ClsStatus = params.get("ClsStatus")
        self._Level = params.get("Level")
        self._CdcClusters = params.get("CdcClusters")
        self._AlbType = params.get("AlbType")
        self._IpHeaders = params.get("IpHeaders")
        self._EngineType = params.get("EngineType")
        self._CloudType = params.get("CloudType")
        self._Note = params.get("Note")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class HostStatus(AbstractModel):
    r"""设置WAF状态的结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _DomainId: 域名ID
        :type DomainId: str
        :param _Status: WAF的开关，1：开，0：关
        :type Status: int
        :param _InstanceID: 实例ID
        :type InstanceID: str
        """
        self._Domain = None
        self._DomainId = None
        self._Status = None
        self._InstanceID = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def DomainId(self):
        r"""域名ID
        :rtype: str
        """
        return self._DomainId

    @DomainId.setter
    def DomainId(self, DomainId):
        self._DomainId = DomainId

    @property
    def Status(self):
        r"""WAF的开关，1：开，0：关
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def InstanceID(self):
        r"""实例ID
        :rtype: str
        """
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._DomainId = params.get("DomainId")
        self._Status = params.get("Status")
        self._InstanceID = params.get("InstanceID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class HybridPkg(AbstractModel):
    r"""混合云节点资源信息

    """

    def __init__(self):
        r"""
        :param _ResourceIds: 资源id
        :type ResourceIds: str
        :param _Status: 状态
        :type Status: int
        :param _Region: 地域
        :type Region: int
        :param _BeginTime: 开始时间
        :type BeginTime: str
        :param _EndTime: 结束时间
        :type EndTime: str
        :param _InquireNum: 申请数量
        :type InquireNum: int
        :param _UsedNum: 使用数量
        :type UsedNum: int
        :param _RenewFlag: 续费标志
        :type RenewFlag: int
        """
        self._ResourceIds = None
        self._Status = None
        self._Region = None
        self._BeginTime = None
        self._EndTime = None
        self._InquireNum = None
        self._UsedNum = None
        self._RenewFlag = None

    @property
    def ResourceIds(self):
        r"""资源id
        :rtype: str
        """
        return self._ResourceIds

    @ResourceIds.setter
    def ResourceIds(self, ResourceIds):
        self._ResourceIds = ResourceIds

    @property
    def Status(self):
        r"""状态
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Region(self):
        r"""地域
        :rtype: int
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def BeginTime(self):
        r"""开始时间
        :rtype: str
        """
        return self._BeginTime

    @BeginTime.setter
    def BeginTime(self, BeginTime):
        self._BeginTime = BeginTime

    @property
    def EndTime(self):
        r"""结束时间
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def InquireNum(self):
        r"""申请数量
        :rtype: int
        """
        return self._InquireNum

    @InquireNum.setter
    def InquireNum(self, InquireNum):
        self._InquireNum = InquireNum

    @property
    def UsedNum(self):
        r"""使用数量
        :rtype: int
        """
        return self._UsedNum

    @UsedNum.setter
    def UsedNum(self, UsedNum):
        self._UsedNum = UsedNum

    @property
    def RenewFlag(self):
        r"""续费标志
        :rtype: int
        """
        return self._RenewFlag

    @RenewFlag.setter
    def RenewFlag(self, RenewFlag):
        self._RenewFlag = RenewFlag


    def _deserialize(self, params):
        self._ResourceIds = params.get("ResourceIds")
        self._Status = params.get("Status")
        self._Region = params.get("Region")
        self._BeginTime = params.get("BeginTime")
        self._EndTime = params.get("EndTime")
        self._InquireNum = params.get("InquireNum")
        self._UsedNum = params.get("UsedNum")
        self._RenewFlag = params.get("RenewFlag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ImportIpAccessControlRequest(AbstractModel):
    r"""ImportIpAccessControl请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 导入的IP黑白名单列表
        :type Data: list of IpAccessControlParam
        :param _Domain: 具体域名如：test.qcloudwaf.com
全局域名为：global
        :type Domain: str
        :param _SourceType: 是否为批量防护IP黑白名单，当为批量防护IP黑白名单时，取值为batch，否则为空
        :type SourceType: str
        :param _InstanceId: 实例Id
        :type InstanceId: str
        """
        self._Data = None
        self._Domain = None
        self._SourceType = None
        self._InstanceId = None

    @property
    def Data(self):
        r"""导入的IP黑白名单列表
        :rtype: list of IpAccessControlParam
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def Domain(self):
        r"""具体域名如：test.qcloudwaf.com
全局域名为：global
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def SourceType(self):
        r"""是否为批量防护IP黑白名单，当为批量防护IP黑白名单时，取值为batch，否则为空
        :rtype: str
        """
        return self._SourceType

    @SourceType.setter
    def SourceType(self, SourceType):
        self._SourceType = SourceType

    @property
    def InstanceId(self):
        r"""实例Id
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = IpAccessControlParam()
                obj._deserialize(item)
                self._Data.append(obj)
        self._Domain = params.get("Domain")
        self._SourceType = params.get("SourceType")
        self._InstanceId = params.get("InstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ImportIpAccessControlResponse(AbstractModel):
    r"""ImportIpAccessControl返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class InOutputBotUCBRule(AbstractModel):
    r"""修改/新增自定义规则的入参，查询自定义规则列表时的出参

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _Name: 规则名称
        :type Name: str
        :param _Rule: UCB的具体规则项
        :type Rule: list of InOutputUCBRuleEntry
        :param _Action: 处置动作
        :type Action: str
        :param _OnOff: 规则开关
        :type OnOff: str
        :param _RuleType: 规则类型
        :type RuleType: int
        :param _Prior: 规则优先级
        :type Prior: int
        :param _Timestamp: 修改时间戳
        :type Timestamp: int
        :param _Label: 标签
        :type Label: str
        :param _Id: 入参ID
        :type Id: str
        :param _SceneId: 场景ID
        :type SceneId: str
        :param _ValidTime: 生效时间
        :type ValidTime: int
        :param _Appid: 传入的appid
        :type Appid: int
        :param _AdditionArg: 额外参数
        :type AdditionArg: str
        :param _Desc: 规则描述
        :type Desc: str
        :param _RuleId: 规则ID
        :type RuleId: str
        :param _PreDefine: true-系统预设规则 false-自定义规则
        :type PreDefine: bool
        :param _JobType: 定时任务类型
        :type JobType: str
        :param _JobDateTime: 定时任务配置
        :type JobDateTime: :class:`tencentcloud.waf.v20180125.models.JobDateTime`
        :param _ExpireTime: 生效截止时间
        :type ExpireTime: int
        :param _ValidStatus: 生效-1,失效-0
        :type ValidStatus: int
        :param _BlockPageId: 自定义拦截页面ID
        :type BlockPageId: int
        :param _ActionList: 当Action=intercept时，此字段必填
        :type ActionList: list of UCBActionProportion
        :param _DelayTime: 惩罚时间
        :type DelayTime: int
        """
        self._Domain = None
        self._Name = None
        self._Rule = None
        self._Action = None
        self._OnOff = None
        self._RuleType = None
        self._Prior = None
        self._Timestamp = None
        self._Label = None
        self._Id = None
        self._SceneId = None
        self._ValidTime = None
        self._Appid = None
        self._AdditionArg = None
        self._Desc = None
        self._RuleId = None
        self._PreDefine = None
        self._JobType = None
        self._JobDateTime = None
        self._ExpireTime = None
        self._ValidStatus = None
        self._BlockPageId = None
        self._ActionList = None
        self._DelayTime = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Name(self):
        r"""规则名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Rule(self):
        r"""UCB的具体规则项
        :rtype: list of InOutputUCBRuleEntry
        """
        return self._Rule

    @Rule.setter
    def Rule(self, Rule):
        self._Rule = Rule

    @property
    def Action(self):
        r"""处置动作
        :rtype: str
        """
        return self._Action

    @Action.setter
    def Action(self, Action):
        self._Action = Action

    @property
    def OnOff(self):
        r"""规则开关
        :rtype: str
        """
        return self._OnOff

    @OnOff.setter
    def OnOff(self, OnOff):
        self._OnOff = OnOff

    @property
    def RuleType(self):
        r"""规则类型
        :rtype: int
        """
        return self._RuleType

    @RuleType.setter
    def RuleType(self, RuleType):
        self._RuleType = RuleType

    @property
    def Prior(self):
        r"""规则优先级
        :rtype: int
        """
        return self._Prior

    @Prior.setter
    def Prior(self, Prior):
        self._Prior = Prior

    @property
    def Timestamp(self):
        r"""修改时间戳
        :rtype: int
        """
        return self._Timestamp

    @Timestamp.setter
    def Timestamp(self, Timestamp):
        self._Timestamp = Timestamp

    @property
    def Label(self):
        r"""标签
        :rtype: str
        """
        return self._Label

    @Label.setter
    def Label(self, Label):
        self._Label = Label

    @property
    def Id(self):
        r"""入参ID
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def SceneId(self):
        r"""场景ID
        :rtype: str
        """
        return self._SceneId

    @SceneId.setter
    def SceneId(self, SceneId):
        self._SceneId = SceneId

    @property
    def ValidTime(self):
        r"""生效时间
        :rtype: int
        """
        return self._ValidTime

    @ValidTime.setter
    def ValidTime(self, ValidTime):
        self._ValidTime = ValidTime

    @property
    def Appid(self):
        r"""传入的appid
        :rtype: int
        """
        return self._Appid

    @Appid.setter
    def Appid(self, Appid):
        self._Appid = Appid

    @property
    def AdditionArg(self):
        r"""额外参数
        :rtype: str
        """
        return self._AdditionArg

    @AdditionArg.setter
    def AdditionArg(self, AdditionArg):
        self._AdditionArg = AdditionArg

    @property
    def Desc(self):
        r"""规则描述
        :rtype: str
        """
        return self._Desc

    @Desc.setter
    def Desc(self, Desc):
        self._Desc = Desc

    @property
    def RuleId(self):
        r"""规则ID
        :rtype: str
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def PreDefine(self):
        r"""true-系统预设规则 false-自定义规则
        :rtype: bool
        """
        return self._PreDefine

    @PreDefine.setter
    def PreDefine(self, PreDefine):
        self._PreDefine = PreDefine

    @property
    def JobType(self):
        r"""定时任务类型
        :rtype: str
        """
        return self._JobType

    @JobType.setter
    def JobType(self, JobType):
        self._JobType = JobType

    @property
    def JobDateTime(self):
        r"""定时任务配置
        :rtype: :class:`tencentcloud.waf.v20180125.models.JobDateTime`
        """
        return self._JobDateTime

    @JobDateTime.setter
    def JobDateTime(self, JobDateTime):
        self._JobDateTime = JobDateTime

    @property
    def ExpireTime(self):
        r"""生效截止时间
        :rtype: int
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def ValidStatus(self):
        r"""生效-1,失效-0
        :rtype: int
        """
        return self._ValidStatus

    @ValidStatus.setter
    def ValidStatus(self, ValidStatus):
        self._ValidStatus = ValidStatus

    @property
    def BlockPageId(self):
        r"""自定义拦截页面ID
        :rtype: int
        """
        return self._BlockPageId

    @BlockPageId.setter
    def BlockPageId(self, BlockPageId):
        self._BlockPageId = BlockPageId

    @property
    def ActionList(self):
        r"""当Action=intercept时，此字段必填
        :rtype: list of UCBActionProportion
        """
        return self._ActionList

    @ActionList.setter
    def ActionList(self, ActionList):
        self._ActionList = ActionList

    @property
    def DelayTime(self):
        r"""惩罚时间
        :rtype: int
        """
        return self._DelayTime

    @DelayTime.setter
    def DelayTime(self, DelayTime):
        self._DelayTime = DelayTime


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Name = params.get("Name")
        if params.get("Rule") is not None:
            self._Rule = []
            for item in params.get("Rule"):
                obj = InOutputUCBRuleEntry()
                obj._deserialize(item)
                self._Rule.append(obj)
        self._Action = params.get("Action")
        self._OnOff = params.get("OnOff")
        self._RuleType = params.get("RuleType")
        self._Prior = params.get("Prior")
        self._Timestamp = params.get("Timestamp")
        self._Label = params.get("Label")
        self._Id = params.get("Id")
        self._SceneId = params.get("SceneId")
        self._ValidTime = params.get("ValidTime")
        self._Appid = params.get("Appid")
        self._AdditionArg = params.get("AdditionArg")
        self._Desc = params.get("Desc")
        self._RuleId = params.get("RuleId")
        self._PreDefine = params.get("PreDefine")
        self._JobType = params.get("JobType")
        if params.get("JobDateTime") is not None:
            self._JobDateTime = JobDateTime()
            self._JobDateTime._deserialize(params.get("JobDateTime"))
        self._ExpireTime = params.get("ExpireTime")
        self._ValidStatus = params.get("ValidStatus")
        self._BlockPageId = params.get("BlockPageId")
        if params.get("ActionList") is not None:
            self._ActionList = []
            for item in params.get("ActionList"):
                obj = UCBActionProportion()
                obj._deserialize(item)
                self._ActionList.append(obj)
        self._DelayTime = params.get("DelayTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InOutputUCBRuleEntry(AbstractModel):
    r"""自定义规则UCB的Rule生效条件

    """

    def __init__(self):
        r"""
        :param _Key: 键
        :type Key: str
        :param _Op: 操作符
        :type Op: str
        :param _Value: 值
        :type Value: :class:`tencentcloud.waf.v20180125.models.UCBEntryValue`
        :param _OpOp: 可选的补充操作符
        :type OpOp: str
        :param _OpArg: 可选的补充参数
        :type OpArg: list of str
        :param _OpValue: 可选的补充值
        :type OpValue: float
        :param _Name: Header参数值时使用
        :type Name: str
        :param _Areas: 区域选择
        :type Areas: list of Area
        :param _Lang: 语言环境
        :type Lang: str
        :param _ParamCompareList: 参数匹配
        :type ParamCompareList: list of ParamCompareList
        """
        self._Key = None
        self._Op = None
        self._Value = None
        self._OpOp = None
        self._OpArg = None
        self._OpValue = None
        self._Name = None
        self._Areas = None
        self._Lang = None
        self._ParamCompareList = None

    @property
    def Key(self):
        r"""键
        :rtype: str
        """
        return self._Key

    @Key.setter
    def Key(self, Key):
        self._Key = Key

    @property
    def Op(self):
        r"""操作符
        :rtype: str
        """
        return self._Op

    @Op.setter
    def Op(self, Op):
        self._Op = Op

    @property
    def Value(self):
        r"""值
        :rtype: :class:`tencentcloud.waf.v20180125.models.UCBEntryValue`
        """
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value

    @property
    def OpOp(self):
        r"""可选的补充操作符
        :rtype: str
        """
        return self._OpOp

    @OpOp.setter
    def OpOp(self, OpOp):
        self._OpOp = OpOp

    @property
    def OpArg(self):
        r"""可选的补充参数
        :rtype: list of str
        """
        return self._OpArg

    @OpArg.setter
    def OpArg(self, OpArg):
        self._OpArg = OpArg

    @property
    def OpValue(self):
        r"""可选的补充值
        :rtype: float
        """
        return self._OpValue

    @OpValue.setter
    def OpValue(self, OpValue):
        self._OpValue = OpValue

    @property
    def Name(self):
        r"""Header参数值时使用
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Areas(self):
        r"""区域选择
        :rtype: list of Area
        """
        return self._Areas

    @Areas.setter
    def Areas(self, Areas):
        self._Areas = Areas

    @property
    def Lang(self):
        r"""语言环境
        :rtype: str
        """
        return self._Lang

    @Lang.setter
    def Lang(self, Lang):
        self._Lang = Lang

    @property
    def ParamCompareList(self):
        r"""参数匹配
        :rtype: list of ParamCompareList
        """
        return self._ParamCompareList

    @ParamCompareList.setter
    def ParamCompareList(self, ParamCompareList):
        self._ParamCompareList = ParamCompareList


    def _deserialize(self, params):
        self._Key = params.get("Key")
        self._Op = params.get("Op")
        if params.get("Value") is not None:
            self._Value = UCBEntryValue()
            self._Value._deserialize(params.get("Value"))
        self._OpOp = params.get("OpOp")
        self._OpArg = params.get("OpArg")
        self._OpValue = params.get("OpValue")
        self._Name = params.get("Name")
        if params.get("Areas") is not None:
            self._Areas = []
            for item in params.get("Areas"):
                obj = Area()
                obj._deserialize(item)
                self._Areas.append(obj)
        self._Lang = params.get("Lang")
        if params.get("ParamCompareList") is not None:
            self._ParamCompareList = []
            for item in params.get("ParamCompareList"):
                obj = ParamCompareList()
                obj._deserialize(item)
                self._ParamCompareList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InstanceInfo(AbstractModel):
    r"""一个实例的详细信息

    """

    def __init__(self):
        r"""
        :param _InstanceId: 实例唯一ID
        :type InstanceId: str
        :param _InstanceName: 实例名称
        :type InstanceName: str
        :param _ResourceIds: 实例对应资源ID，计费使用
        :type ResourceIds: str
        :param _Region: 实例所属地域
        :type Region: str
        :param _PayMode: 付费模式
        :type PayMode: int
        :param _RenewFlag: 自动续费标识。
0：关闭
1：开启
        :type RenewFlag: int
        :param _Mode: 弹性计费开关。
0：关闭
1：开启
        :type Mode: int
        :param _Level: 实例套餐版本。
101：小微版
102：超轻版
2：高级版
3：企业版
4：旗舰版
6：独享版
        :type Level: int
        :param _ValidTime: 实例过期时间
        :type ValidTime: str
        :param _BeginTime: 实例开始时间
        :type BeginTime: str
        :param _DomainCount: 已配置域名个数
        :type DomainCount: int
        :param _SubDomainLimit: 域名数量上限
        :type SubDomainLimit: int
        :param _MainDomainCount: 已配置主域名个数
        :type MainDomainCount: int
        :param _MainDomainLimit: 主域名数量上限
        :type MainDomainLimit: int
        :param _MaxQPS: 实例30天内QPS峰值
        :type MaxQPS: int
        :param _QPS: qps扩展包信息
        :type QPS: :class:`tencentcloud.waf.v20180125.models.QPSPackageNew`
        :param _DomainPkg: 域名扩展包信息
        :type DomainPkg: :class:`tencentcloud.waf.v20180125.models.DomainPackageNew`
        :param _AppId: 用户appid
        :type AppId: int
        :param _Edition: clb或saas
        :type Edition: str
        :param _FraudPkg: 业务安全包
        :type FraudPkg: :class:`tencentcloud.waf.v20180125.models.FraudPkg`
        :param _BotPkg: Bot资源包
        :type BotPkg: :class:`tencentcloud.waf.v20180125.models.BotPkg`
        :param _BotQPS: bot的qps详情
        :type BotQPS: :class:`tencentcloud.waf.v20180125.models.BotQPS`
        :param _ElasticBilling: qps弹性计费上限
        :type ElasticBilling: int
        :param _AttackLogPost: 攻击日志投递开关
        :type AttackLogPost: int
        :param _MaxBandwidth: 带宽峰值，单位为B/s(字节每秒)
        :type MaxBandwidth: int
        :param _APISecurity: api安全是否购买
        :type APISecurity: int
        :param _QpsStandard: 购买的qps规格
        :type QpsStandard: int
        :param _BandwidthStandard: 购买的带宽规格
        :type BandwidthStandard: int
        :param _Status: 实例状态
        :type Status: int
        :param _SandboxQps: 实例沙箱qps值
        :type SandboxQps: int
        :param _IsAPISecurityTrial: 是否api 安全试用
        :type IsAPISecurityTrial: int
        :param _MajorEventsPkg: 重保包
        :type MajorEventsPkg: :class:`tencentcloud.waf.v20180125.models.MajorEventsPkg`
        :param _HybridPkg: 混合云子节点包
        :type HybridPkg: :class:`tencentcloud.waf.v20180125.models.HybridPkg`
        :param _ApiPkg: API安全资源包
        :type ApiPkg: :class:`tencentcloud.waf.v20180125.models.ApiPkg`
        :param _MiniPkg: 小程序安全加速包
        :type MiniPkg: :class:`tencentcloud.waf.v20180125.models.MiniPkg`
        :param _MiniQpsStandard: 小程序qps规格
        :type MiniQpsStandard: int
        :param _MiniMaxQPS: 小程序qps峰值
        :type MiniMaxQPS: int
        :param _LastQpsExceedTime: 最近一次超量时间
        :type LastQpsExceedTime: str
        :param _MiniExtendPkg: 小程序安全接入ID数量扩张包
        :type MiniExtendPkg: :class:`tencentcloud.waf.v20180125.models.MiniExtendPkg`
        :param _BillingItem: 计费项
        :type BillingItem: str
        :param _FreeDelayFlag: 实例延期释放标识
        :type FreeDelayFlag: int
        :param _Last3MaxQPS: 最近3天最大qps
        :type Last3MaxQPS: int
        :param _Last3MaxBandwidth: 最近3天最大带宽
        :type Last3MaxBandwidth: int
        :param _MajorEventsProPkg: 重保增强包
        :type MajorEventsProPkg: :class:`tencentcloud.waf.v20180125.models.MajorEventsProPkg`
        :param _BasicFlag: 1是基础2025版本；0不是
        :type BasicFlag: int
        :param _NetworkConfig: 实例的网络配置
        :type NetworkConfig: :class:`tencentcloud.waf.v20180125.models.NetworkConfig`
        :param _RCEPkg: RCE设备安全信息包
        :type RCEPkg: :class:`tencentcloud.waf.v20180125.models.RCEPkg`
        :param _ExceedPolicy: 超量策略。0：超量沙箱
1：超量限流
        :type ExceedPolicy: int
        :param _LLMPkg: 大模型安全信息包
        :type LLMPkg: :class:`tencentcloud.waf.v20180125.models.LLMPkg`
        :param _ElasticResourceId: 弹性资源Id
        :type ElasticResourceId: str
        :param _LLMMonPkg: 预付费大模型安全信息包
        :type LLMMonPkg: :class:`tencentcloud.waf.v20180125.models.LLMMonPkg`
        :param _RegionId: 地域id
        :type RegionId: int
        """
        self._InstanceId = None
        self._InstanceName = None
        self._ResourceIds = None
        self._Region = None
        self._PayMode = None
        self._RenewFlag = None
        self._Mode = None
        self._Level = None
        self._ValidTime = None
        self._BeginTime = None
        self._DomainCount = None
        self._SubDomainLimit = None
        self._MainDomainCount = None
        self._MainDomainLimit = None
        self._MaxQPS = None
        self._QPS = None
        self._DomainPkg = None
        self._AppId = None
        self._Edition = None
        self._FraudPkg = None
        self._BotPkg = None
        self._BotQPS = None
        self._ElasticBilling = None
        self._AttackLogPost = None
        self._MaxBandwidth = None
        self._APISecurity = None
        self._QpsStandard = None
        self._BandwidthStandard = None
        self._Status = None
        self._SandboxQps = None
        self._IsAPISecurityTrial = None
        self._MajorEventsPkg = None
        self._HybridPkg = None
        self._ApiPkg = None
        self._MiniPkg = None
        self._MiniQpsStandard = None
        self._MiniMaxQPS = None
        self._LastQpsExceedTime = None
        self._MiniExtendPkg = None
        self._BillingItem = None
        self._FreeDelayFlag = None
        self._Last3MaxQPS = None
        self._Last3MaxBandwidth = None
        self._MajorEventsProPkg = None
        self._BasicFlag = None
        self._NetworkConfig = None
        self._RCEPkg = None
        self._ExceedPolicy = None
        self._LLMPkg = None
        self._ElasticResourceId = None
        self._LLMMonPkg = None
        self._RegionId = None

    @property
    def InstanceId(self):
        r"""实例唯一ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def InstanceName(self):
        r"""实例名称
        :rtype: str
        """
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def ResourceIds(self):
        r"""实例对应资源ID，计费使用
        :rtype: str
        """
        return self._ResourceIds

    @ResourceIds.setter
    def ResourceIds(self, ResourceIds):
        self._ResourceIds = ResourceIds

    @property
    def Region(self):
        r"""实例所属地域
        :rtype: str
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def PayMode(self):
        r"""付费模式
        :rtype: int
        """
        return self._PayMode

    @PayMode.setter
    def PayMode(self, PayMode):
        self._PayMode = PayMode

    @property
    def RenewFlag(self):
        r"""自动续费标识。
0：关闭
1：开启
        :rtype: int
        """
        return self._RenewFlag

    @RenewFlag.setter
    def RenewFlag(self, RenewFlag):
        self._RenewFlag = RenewFlag

    @property
    def Mode(self):
        r"""弹性计费开关。
0：关闭
1：开启
        :rtype: int
        """
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode

    @property
    def Level(self):
        r"""实例套餐版本。
101：小微版
102：超轻版
2：高级版
3：企业版
4：旗舰版
6：独享版
        :rtype: int
        """
        return self._Level

    @Level.setter
    def Level(self, Level):
        self._Level = Level

    @property
    def ValidTime(self):
        r"""实例过期时间
        :rtype: str
        """
        return self._ValidTime

    @ValidTime.setter
    def ValidTime(self, ValidTime):
        self._ValidTime = ValidTime

    @property
    def BeginTime(self):
        r"""实例开始时间
        :rtype: str
        """
        return self._BeginTime

    @BeginTime.setter
    def BeginTime(self, BeginTime):
        self._BeginTime = BeginTime

    @property
    def DomainCount(self):
        r"""已配置域名个数
        :rtype: int
        """
        return self._DomainCount

    @DomainCount.setter
    def DomainCount(self, DomainCount):
        self._DomainCount = DomainCount

    @property
    def SubDomainLimit(self):
        r"""域名数量上限
        :rtype: int
        """
        return self._SubDomainLimit

    @SubDomainLimit.setter
    def SubDomainLimit(self, SubDomainLimit):
        self._SubDomainLimit = SubDomainLimit

    @property
    def MainDomainCount(self):
        r"""已配置主域名个数
        :rtype: int
        """
        return self._MainDomainCount

    @MainDomainCount.setter
    def MainDomainCount(self, MainDomainCount):
        self._MainDomainCount = MainDomainCount

    @property
    def MainDomainLimit(self):
        r"""主域名数量上限
        :rtype: int
        """
        return self._MainDomainLimit

    @MainDomainLimit.setter
    def MainDomainLimit(self, MainDomainLimit):
        self._MainDomainLimit = MainDomainLimit

    @property
    def MaxQPS(self):
        r"""实例30天内QPS峰值
        :rtype: int
        """
        return self._MaxQPS

    @MaxQPS.setter
    def MaxQPS(self, MaxQPS):
        self._MaxQPS = MaxQPS

    @property
    def QPS(self):
        r"""qps扩展包信息
        :rtype: :class:`tencentcloud.waf.v20180125.models.QPSPackageNew`
        """
        return self._QPS

    @QPS.setter
    def QPS(self, QPS):
        self._QPS = QPS

    @property
    def DomainPkg(self):
        r"""域名扩展包信息
        :rtype: :class:`tencentcloud.waf.v20180125.models.DomainPackageNew`
        """
        return self._DomainPkg

    @DomainPkg.setter
    def DomainPkg(self, DomainPkg):
        self._DomainPkg = DomainPkg

    @property
    def AppId(self):
        r"""用户appid
        :rtype: int
        """
        return self._AppId

    @AppId.setter
    def AppId(self, AppId):
        self._AppId = AppId

    @property
    def Edition(self):
        r"""clb或saas
        :rtype: str
        """
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition

    @property
    def FraudPkg(self):
        r"""业务安全包
        :rtype: :class:`tencentcloud.waf.v20180125.models.FraudPkg`
        """
        return self._FraudPkg

    @FraudPkg.setter
    def FraudPkg(self, FraudPkg):
        self._FraudPkg = FraudPkg

    @property
    def BotPkg(self):
        r"""Bot资源包
        :rtype: :class:`tencentcloud.waf.v20180125.models.BotPkg`
        """
        return self._BotPkg

    @BotPkg.setter
    def BotPkg(self, BotPkg):
        self._BotPkg = BotPkg

    @property
    def BotQPS(self):
        r"""bot的qps详情
        :rtype: :class:`tencentcloud.waf.v20180125.models.BotQPS`
        """
        return self._BotQPS

    @BotQPS.setter
    def BotQPS(self, BotQPS):
        self._BotQPS = BotQPS

    @property
    def ElasticBilling(self):
        r"""qps弹性计费上限
        :rtype: int
        """
        return self._ElasticBilling

    @ElasticBilling.setter
    def ElasticBilling(self, ElasticBilling):
        self._ElasticBilling = ElasticBilling

    @property
    def AttackLogPost(self):
        r"""攻击日志投递开关
        :rtype: int
        """
        return self._AttackLogPost

    @AttackLogPost.setter
    def AttackLogPost(self, AttackLogPost):
        self._AttackLogPost = AttackLogPost

    @property
    def MaxBandwidth(self):
        r"""带宽峰值，单位为B/s(字节每秒)
        :rtype: int
        """
        return self._MaxBandwidth

    @MaxBandwidth.setter
    def MaxBandwidth(self, MaxBandwidth):
        self._MaxBandwidth = MaxBandwidth

    @property
    def APISecurity(self):
        r"""api安全是否购买
        :rtype: int
        """
        return self._APISecurity

    @APISecurity.setter
    def APISecurity(self, APISecurity):
        self._APISecurity = APISecurity

    @property
    def QpsStandard(self):
        r"""购买的qps规格
        :rtype: int
        """
        return self._QpsStandard

    @QpsStandard.setter
    def QpsStandard(self, QpsStandard):
        self._QpsStandard = QpsStandard

    @property
    def BandwidthStandard(self):
        r"""购买的带宽规格
        :rtype: int
        """
        return self._BandwidthStandard

    @BandwidthStandard.setter
    def BandwidthStandard(self, BandwidthStandard):
        self._BandwidthStandard = BandwidthStandard

    @property
    def Status(self):
        r"""实例状态
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def SandboxQps(self):
        r"""实例沙箱qps值
        :rtype: int
        """
        return self._SandboxQps

    @SandboxQps.setter
    def SandboxQps(self, SandboxQps):
        self._SandboxQps = SandboxQps

    @property
    def IsAPISecurityTrial(self):
        r"""是否api 安全试用
        :rtype: int
        """
        return self._IsAPISecurityTrial

    @IsAPISecurityTrial.setter
    def IsAPISecurityTrial(self, IsAPISecurityTrial):
        self._IsAPISecurityTrial = IsAPISecurityTrial

    @property
    def MajorEventsPkg(self):
        r"""重保包
        :rtype: :class:`tencentcloud.waf.v20180125.models.MajorEventsPkg`
        """
        return self._MajorEventsPkg

    @MajorEventsPkg.setter
    def MajorEventsPkg(self, MajorEventsPkg):
        self._MajorEventsPkg = MajorEventsPkg

    @property
    def HybridPkg(self):
        r"""混合云子节点包
        :rtype: :class:`tencentcloud.waf.v20180125.models.HybridPkg`
        """
        return self._HybridPkg

    @HybridPkg.setter
    def HybridPkg(self, HybridPkg):
        self._HybridPkg = HybridPkg

    @property
    def ApiPkg(self):
        r"""API安全资源包
        :rtype: :class:`tencentcloud.waf.v20180125.models.ApiPkg`
        """
        return self._ApiPkg

    @ApiPkg.setter
    def ApiPkg(self, ApiPkg):
        self._ApiPkg = ApiPkg

    @property
    def MiniPkg(self):
        r"""小程序安全加速包
        :rtype: :class:`tencentcloud.waf.v20180125.models.MiniPkg`
        """
        return self._MiniPkg

    @MiniPkg.setter
    def MiniPkg(self, MiniPkg):
        self._MiniPkg = MiniPkg

    @property
    def MiniQpsStandard(self):
        r"""小程序qps规格
        :rtype: int
        """
        return self._MiniQpsStandard

    @MiniQpsStandard.setter
    def MiniQpsStandard(self, MiniQpsStandard):
        self._MiniQpsStandard = MiniQpsStandard

    @property
    def MiniMaxQPS(self):
        r"""小程序qps峰值
        :rtype: int
        """
        return self._MiniMaxQPS

    @MiniMaxQPS.setter
    def MiniMaxQPS(self, MiniMaxQPS):
        self._MiniMaxQPS = MiniMaxQPS

    @property
    def LastQpsExceedTime(self):
        r"""最近一次超量时间
        :rtype: str
        """
        return self._LastQpsExceedTime

    @LastQpsExceedTime.setter
    def LastQpsExceedTime(self, LastQpsExceedTime):
        self._LastQpsExceedTime = LastQpsExceedTime

    @property
    def MiniExtendPkg(self):
        r"""小程序安全接入ID数量扩张包
        :rtype: :class:`tencentcloud.waf.v20180125.models.MiniExtendPkg`
        """
        return self._MiniExtendPkg

    @MiniExtendPkg.setter
    def MiniExtendPkg(self, MiniExtendPkg):
        self._MiniExtendPkg = MiniExtendPkg

    @property
    def BillingItem(self):
        r"""计费项
        :rtype: str
        """
        return self._BillingItem

    @BillingItem.setter
    def BillingItem(self, BillingItem):
        self._BillingItem = BillingItem

    @property
    def FreeDelayFlag(self):
        r"""实例延期释放标识
        :rtype: int
        """
        return self._FreeDelayFlag

    @FreeDelayFlag.setter
    def FreeDelayFlag(self, FreeDelayFlag):
        self._FreeDelayFlag = FreeDelayFlag

    @property
    def Last3MaxQPS(self):
        r"""最近3天最大qps
        :rtype: int
        """
        return self._Last3MaxQPS

    @Last3MaxQPS.setter
    def Last3MaxQPS(self, Last3MaxQPS):
        self._Last3MaxQPS = Last3MaxQPS

    @property
    def Last3MaxBandwidth(self):
        r"""最近3天最大带宽
        :rtype: int
        """
        return self._Last3MaxBandwidth

    @Last3MaxBandwidth.setter
    def Last3MaxBandwidth(self, Last3MaxBandwidth):
        self._Last3MaxBandwidth = Last3MaxBandwidth

    @property
    def MajorEventsProPkg(self):
        r"""重保增强包
        :rtype: :class:`tencentcloud.waf.v20180125.models.MajorEventsProPkg`
        """
        return self._MajorEventsProPkg

    @MajorEventsProPkg.setter
    def MajorEventsProPkg(self, MajorEventsProPkg):
        self._MajorEventsProPkg = MajorEventsProPkg

    @property
    def BasicFlag(self):
        r"""1是基础2025版本；0不是
        :rtype: int
        """
        return self._BasicFlag

    @BasicFlag.setter
    def BasicFlag(self, BasicFlag):
        self._BasicFlag = BasicFlag

    @property
    def NetworkConfig(self):
        r"""实例的网络配置
        :rtype: :class:`tencentcloud.waf.v20180125.models.NetworkConfig`
        """
        return self._NetworkConfig

    @NetworkConfig.setter
    def NetworkConfig(self, NetworkConfig):
        self._NetworkConfig = NetworkConfig

    @property
    def RCEPkg(self):
        r"""RCE设备安全信息包
        :rtype: :class:`tencentcloud.waf.v20180125.models.RCEPkg`
        """
        return self._RCEPkg

    @RCEPkg.setter
    def RCEPkg(self, RCEPkg):
        self._RCEPkg = RCEPkg

    @property
    def ExceedPolicy(self):
        r"""超量策略。0：超量沙箱
1：超量限流
        :rtype: int
        """
        return self._ExceedPolicy

    @ExceedPolicy.setter
    def ExceedPolicy(self, ExceedPolicy):
        self._ExceedPolicy = ExceedPolicy

    @property
    def LLMPkg(self):
        r"""大模型安全信息包
        :rtype: :class:`tencentcloud.waf.v20180125.models.LLMPkg`
        """
        return self._LLMPkg

    @LLMPkg.setter
    def LLMPkg(self, LLMPkg):
        self._LLMPkg = LLMPkg

    @property
    def ElasticResourceId(self):
        r"""弹性资源Id
        :rtype: str
        """
        return self._ElasticResourceId

    @ElasticResourceId.setter
    def ElasticResourceId(self, ElasticResourceId):
        self._ElasticResourceId = ElasticResourceId

    @property
    def LLMMonPkg(self):
        r"""预付费大模型安全信息包
        :rtype: :class:`tencentcloud.waf.v20180125.models.LLMMonPkg`
        """
        return self._LLMMonPkg

    @LLMMonPkg.setter
    def LLMMonPkg(self, LLMMonPkg):
        self._LLMMonPkg = LLMMonPkg

    @property
    def RegionId(self):
        r"""地域id
        :rtype: int
        """
        return self._RegionId

    @RegionId.setter
    def RegionId(self, RegionId):
        self._RegionId = RegionId


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._InstanceName = params.get("InstanceName")
        self._ResourceIds = params.get("ResourceIds")
        self._Region = params.get("Region")
        self._PayMode = params.get("PayMode")
        self._RenewFlag = params.get("RenewFlag")
        self._Mode = params.get("Mode")
        self._Level = params.get("Level")
        self._ValidTime = params.get("ValidTime")
        self._BeginTime = params.get("BeginTime")
        self._DomainCount = params.get("DomainCount")
        self._SubDomainLimit = params.get("SubDomainLimit")
        self._MainDomainCount = params.get("MainDomainCount")
        self._MainDomainLimit = params.get("MainDomainLimit")
        self._MaxQPS = params.get("MaxQPS")
        if params.get("QPS") is not None:
            self._QPS = QPSPackageNew()
            self._QPS._deserialize(params.get("QPS"))
        if params.get("DomainPkg") is not None:
            self._DomainPkg = DomainPackageNew()
            self._DomainPkg._deserialize(params.get("DomainPkg"))
        self._AppId = params.get("AppId")
        self._Edition = params.get("Edition")
        if params.get("FraudPkg") is not None:
            self._FraudPkg = FraudPkg()
            self._FraudPkg._deserialize(params.get("FraudPkg"))
        if params.get("BotPkg") is not None:
            self._BotPkg = BotPkg()
            self._BotPkg._deserialize(params.get("BotPkg"))
        if params.get("BotQPS") is not None:
            self._BotQPS = BotQPS()
            self._BotQPS._deserialize(params.get("BotQPS"))
        self._ElasticBilling = params.get("ElasticBilling")
        self._AttackLogPost = params.get("AttackLogPost")
        self._MaxBandwidth = params.get("MaxBandwidth")
        self._APISecurity = params.get("APISecurity")
        self._QpsStandard = params.get("QpsStandard")
        self._BandwidthStandard = params.get("BandwidthStandard")
        self._Status = params.get("Status")
        self._SandboxQps = params.get("SandboxQps")
        self._IsAPISecurityTrial = params.get("IsAPISecurityTrial")
        if params.get("MajorEventsPkg") is not None:
            self._MajorEventsPkg = MajorEventsPkg()
            self._MajorEventsPkg._deserialize(params.get("MajorEventsPkg"))
        if params.get("HybridPkg") is not None:
            self._HybridPkg = HybridPkg()
            self._HybridPkg._deserialize(params.get("HybridPkg"))
        if params.get("ApiPkg") is not None:
            self._ApiPkg = ApiPkg()
            self._ApiPkg._deserialize(params.get("ApiPkg"))
        if params.get("MiniPkg") is not None:
            self._MiniPkg = MiniPkg()
            self._MiniPkg._deserialize(params.get("MiniPkg"))
        self._MiniQpsStandard = params.get("MiniQpsStandard")
        self._MiniMaxQPS = params.get("MiniMaxQPS")
        self._LastQpsExceedTime = params.get("LastQpsExceedTime")
        if params.get("MiniExtendPkg") is not None:
            self._MiniExtendPkg = MiniExtendPkg()
            self._MiniExtendPkg._deserialize(params.get("MiniExtendPkg"))
        self._BillingItem = params.get("BillingItem")
        self._FreeDelayFlag = params.get("FreeDelayFlag")
        self._Last3MaxQPS = params.get("Last3MaxQPS")
        self._Last3MaxBandwidth = params.get("Last3MaxBandwidth")
        if params.get("MajorEventsProPkg") is not None:
            self._MajorEventsProPkg = MajorEventsProPkg()
            self._MajorEventsProPkg._deserialize(params.get("MajorEventsProPkg"))
        self._BasicFlag = params.get("BasicFlag")
        if params.get("NetworkConfig") is not None:
            self._NetworkConfig = NetworkConfig()
            self._NetworkConfig._deserialize(params.get("NetworkConfig"))
        if params.get("RCEPkg") is not None:
            self._RCEPkg = RCEPkg()
            self._RCEPkg._deserialize(params.get("RCEPkg"))
        self._ExceedPolicy = params.get("ExceedPolicy")
        if params.get("LLMPkg") is not None:
            self._LLMPkg = LLMPkg()
            self._LLMPkg._deserialize(params.get("LLMPkg"))
        self._ElasticResourceId = params.get("ElasticResourceId")
        if params.get("LLMMonPkg") is not None:
            self._LLMMonPkg = LLMMonPkg()
            self._LLMMonPkg._deserialize(params.get("LLMMonPkg"))
        self._RegionId = params.get("RegionId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class IpAccessControlData(AbstractModel):
    r"""数据封装

    """

    def __init__(self):
        r"""
        :param _Res: ip黑白名单
        :type Res: list of IpAccessControlItem
        :param _TotalCount: 计数
        :type TotalCount: int
        """
        self._Res = None
        self._TotalCount = None

    @property
    def Res(self):
        r"""ip黑白名单
        :rtype: list of IpAccessControlItem
        """
        return self._Res

    @Res.setter
    def Res(self, Res):
        self._Res = Res

    @property
    def TotalCount(self):
        r"""计数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount


    def _deserialize(self, params):
        if params.get("Res") is not None:
            self._Res = []
            for item in params.get("Res"):
                obj = IpAccessControlItem()
                obj._deserialize(item)
                self._Res.append(obj)
        self._TotalCount = params.get("TotalCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class IpAccessControlItem(AbstractModel):
    r"""ip黑白名单

    """

    def __init__(self):
        r"""
        :param _Id: mongo表自增Id
        :type Id: str
        :param _ActionType: 动作
        :type ActionType: int
        :param _Ip: ip
        :type Ip: str
        :param _Note: 备注
        :type Note: str
        :param _Source: 来源
        :type Source: str
        :param _TsVersion: 更新时间戳
        :type TsVersion: int
        :param _ValidTs: 有效截止时间戳
        :type ValidTs: int
        :param _ValidStatus: 生效状态
        :type ValidStatus: int
        :param _RuleId: 55000001
        :type RuleId: int
        :param _IpList: IP列表
        :type IpList: list of str
        :param _CreateTime: 规则创建时间
        :type CreateTime: int
        :param _JobType: 定时任务类型
        :type JobType: str
        :param _CronType: 周期任务类型
        :type CronType: str
        :param _JobDateTime: 定时任务配置详情
        :type JobDateTime: :class:`tencentcloud.waf.v20180125.models.JobDateTime`
        """
        self._Id = None
        self._ActionType = None
        self._Ip = None
        self._Note = None
        self._Source = None
        self._TsVersion = None
        self._ValidTs = None
        self._ValidStatus = None
        self._RuleId = None
        self._IpList = None
        self._CreateTime = None
        self._JobType = None
        self._CronType = None
        self._JobDateTime = None

    @property
    def Id(self):
        r"""mongo表自增Id
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def ActionType(self):
        r"""动作
        :rtype: int
        """
        return self._ActionType

    @ActionType.setter
    def ActionType(self, ActionType):
        self._ActionType = ActionType

    @property
    def Ip(self):
        r"""ip
        :rtype: str
        """
        return self._Ip

    @Ip.setter
    def Ip(self, Ip):
        self._Ip = Ip

    @property
    def Note(self):
        r"""备注
        :rtype: str
        """
        return self._Note

    @Note.setter
    def Note(self, Note):
        self._Note = Note

    @property
    def Source(self):
        r"""来源
        :rtype: str
        """
        return self._Source

    @Source.setter
    def Source(self, Source):
        self._Source = Source

    @property
    def TsVersion(self):
        r"""更新时间戳
        :rtype: int
        """
        return self._TsVersion

    @TsVersion.setter
    def TsVersion(self, TsVersion):
        self._TsVersion = TsVersion

    @property
    def ValidTs(self):
        r"""有效截止时间戳
        :rtype: int
        """
        return self._ValidTs

    @ValidTs.setter
    def ValidTs(self, ValidTs):
        self._ValidTs = ValidTs

    @property
    def ValidStatus(self):
        r"""生效状态
        :rtype: int
        """
        return self._ValidStatus

    @ValidStatus.setter
    def ValidStatus(self, ValidStatus):
        self._ValidStatus = ValidStatus

    @property
    def RuleId(self):
        r"""55000001
        :rtype: int
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def IpList(self):
        r"""IP列表
        :rtype: list of str
        """
        return self._IpList

    @IpList.setter
    def IpList(self, IpList):
        self._IpList = IpList

    @property
    def CreateTime(self):
        r"""规则创建时间
        :rtype: int
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def JobType(self):
        r"""定时任务类型
        :rtype: str
        """
        return self._JobType

    @JobType.setter
    def JobType(self, JobType):
        self._JobType = JobType

    @property
    def CronType(self):
        r"""周期任务类型
        :rtype: str
        """
        return self._CronType

    @CronType.setter
    def CronType(self, CronType):
        self._CronType = CronType

    @property
    def JobDateTime(self):
        r"""定时任务配置详情
        :rtype: :class:`tencentcloud.waf.v20180125.models.JobDateTime`
        """
        return self._JobDateTime

    @JobDateTime.setter
    def JobDateTime(self, JobDateTime):
        self._JobDateTime = JobDateTime


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._ActionType = params.get("ActionType")
        self._Ip = params.get("Ip")
        self._Note = params.get("Note")
        self._Source = params.get("Source")
        self._TsVersion = params.get("TsVersion")
        self._ValidTs = params.get("ValidTs")
        self._ValidStatus = params.get("ValidStatus")
        self._RuleId = params.get("RuleId")
        self._IpList = params.get("IpList")
        self._CreateTime = params.get("CreateTime")
        self._JobType = params.get("JobType")
        self._CronType = params.get("CronType")
        if params.get("JobDateTime") is not None:
            self._JobDateTime = JobDateTime()
            self._JobDateTime._deserialize(params.get("JobDateTime"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class IpAccessControlParam(AbstractModel):
    r"""IP黑白名单参数结构体，主要用于IP黑白名单的导入。

    """

    def __init__(self):
        r"""
        :param _IpList: IP列表
        :type IpList: list of str
        :param _ValidTs: valid_ts为有效日期，值为秒级时间戳（（如1680570420代表2023-04-04 09:07:00））
        :type ValidTs: int
        :param _ActionType: 42为黑名单，40为白名单
        :type ActionType: int
        :param _Note: 备注
        :type Note: str
        """
        self._IpList = None
        self._ValidTs = None
        self._ActionType = None
        self._Note = None

    @property
    def IpList(self):
        r"""IP列表
        :rtype: list of str
        """
        return self._IpList

    @IpList.setter
    def IpList(self, IpList):
        self._IpList = IpList

    @property
    def ValidTs(self):
        r"""valid_ts为有效日期，值为秒级时间戳（（如1680570420代表2023-04-04 09:07:00））
        :rtype: int
        """
        return self._ValidTs

    @ValidTs.setter
    def ValidTs(self, ValidTs):
        self._ValidTs = ValidTs

    @property
    def ActionType(self):
        r"""42为黑名单，40为白名单
        :rtype: int
        """
        return self._ActionType

    @ActionType.setter
    def ActionType(self, ActionType):
        self._ActionType = ActionType

    @property
    def Note(self):
        r"""备注
        :rtype: str
        """
        return self._Note

    @Note.setter
    def Note(self, Note):
        self._Note = Note


    def _deserialize(self, params):
        self._IpList = params.get("IpList")
        self._ValidTs = params.get("ValidTs")
        self._ActionType = params.get("ActionType")
        self._Note = params.get("Note")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class IpHitItem(AbstractModel):
    r"""ip封堵状态数据

    """

    def __init__(self):
        r"""
        :param _Action: 动作
        :type Action: int
        :param _Category: 类别
        :type Category: str
        :param _Ip: ip
        :type Ip: str
        :param _Name: 规则名称
        :type Name: str
        :param _TsVersion: 时间戳
        :type TsVersion: int
        :param _ValidTs: 有效截止时间戳
        :type ValidTs: int
        """
        self._Action = None
        self._Category = None
        self._Ip = None
        self._Name = None
        self._TsVersion = None
        self._ValidTs = None

    @property
    def Action(self):
        r"""动作
        :rtype: int
        """
        return self._Action

    @Action.setter
    def Action(self, Action):
        self._Action = Action

    @property
    def Category(self):
        r"""类别
        :rtype: str
        """
        return self._Category

    @Category.setter
    def Category(self, Category):
        self._Category = Category

    @property
    def Ip(self):
        r"""ip
        :rtype: str
        """
        return self._Ip

    @Ip.setter
    def Ip(self, Ip):
        self._Ip = Ip

    @property
    def Name(self):
        r"""规则名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def TsVersion(self):
        r"""时间戳
        :rtype: int
        """
        return self._TsVersion

    @TsVersion.setter
    def TsVersion(self, TsVersion):
        self._TsVersion = TsVersion

    @property
    def ValidTs(self):
        r"""有效截止时间戳
        :rtype: int
        """
        return self._ValidTs

    @ValidTs.setter
    def ValidTs(self, ValidTs):
        self._ValidTs = ValidTs


    def _deserialize(self, params):
        self._Action = params.get("Action")
        self._Category = params.get("Category")
        self._Ip = params.get("Ip")
        self._Name = params.get("Name")
        self._TsVersion = params.get("TsVersion")
        self._ValidTs = params.get("ValidTs")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class IpHitItemsData(AbstractModel):
    r"""封装参数

    """

    def __init__(self):
        r"""
        :param _Res: 数组封装
        :type Res: list of IpHitItem
        :param _TotalCount: 总数目
        :type TotalCount: int
        """
        self._Res = None
        self._TotalCount = None

    @property
    def Res(self):
        r"""数组封装
        :rtype: list of IpHitItem
        """
        return self._Res

    @Res.setter
    def Res(self, Res):
        self._Res = Res

    @property
    def TotalCount(self):
        r"""总数目
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount


    def _deserialize(self, params):
        if params.get("Res") is not None:
            self._Res = []
            for item in params.get("Res"):
                obj = IpHitItem()
                obj._deserialize(item)
                self._Res.append(obj)
        self._TotalCount = params.get("TotalCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class JWTConfig(AbstractModel):
    r"""当用户选择JWS/JWE会话管理方式的时候，上传的配置信息以及校验规则

    """

    def __init__(self):
        r"""
        :param _SecretInfo: 密钥信息
        :type SecretInfo: :class:`tencentcloud.waf.v20180125.models.SecretInfo`
        :param _PayloadRule: Payload校验规则集合
        :type PayloadRule: list of TokenRuleEntry
        """
        self._SecretInfo = None
        self._PayloadRule = None

    @property
    def SecretInfo(self):
        r"""密钥信息
        :rtype: :class:`tencentcloud.waf.v20180125.models.SecretInfo`
        """
        return self._SecretInfo

    @SecretInfo.setter
    def SecretInfo(self, SecretInfo):
        self._SecretInfo = SecretInfo

    @property
    def PayloadRule(self):
        r"""Payload校验规则集合
        :rtype: list of TokenRuleEntry
        """
        return self._PayloadRule

    @PayloadRule.setter
    def PayloadRule(self, PayloadRule):
        self._PayloadRule = PayloadRule


    def _deserialize(self, params):
        if params.get("SecretInfo") is not None:
            self._SecretInfo = SecretInfo()
            self._SecretInfo._deserialize(params.get("SecretInfo"))
        if params.get("PayloadRule") is not None:
            self._PayloadRule = []
            for item in params.get("PayloadRule"):
                obj = TokenRuleEntry()
                obj._deserialize(item)
                self._PayloadRule.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class JobDateTime(AbstractModel):
    r"""规则执行的时间结构体

    """

    def __init__(self):
        r"""
        :param _Timed: 定时执行的时间参数
        :type Timed: list of TimedJob
        :param _Cron: 周期执行的时间参数
        :type Cron: list of CronJob
        :param _TimeTZone: 时区
        :type TimeTZone: str
        """
        self._Timed = None
        self._Cron = None
        self._TimeTZone = None

    @property
    def Timed(self):
        r"""定时执行的时间参数
        :rtype: list of TimedJob
        """
        return self._Timed

    @Timed.setter
    def Timed(self, Timed):
        self._Timed = Timed

    @property
    def Cron(self):
        r"""周期执行的时间参数
        :rtype: list of CronJob
        """
        return self._Cron

    @Cron.setter
    def Cron(self, Cron):
        self._Cron = Cron

    @property
    def TimeTZone(self):
        r"""时区
        :rtype: str
        """
        return self._TimeTZone

    @TimeTZone.setter
    def TimeTZone(self, TimeTZone):
        self._TimeTZone = TimeTZone


    def _deserialize(self, params):
        if params.get("Timed") is not None:
            self._Timed = []
            for item in params.get("Timed"):
                obj = TimedJob()
                obj._deserialize(item)
                self._Timed.append(obj)
        if params.get("Cron") is not None:
            self._Cron = []
            for item in params.get("Cron"):
                obj = CronJob()
                obj._deserialize(item)
                self._Cron.append(obj)
        self._TimeTZone = params.get("TimeTZone")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class KVInt(AbstractModel):
    r"""Key-Value的形式，Value为Int

    """

    def __init__(self):
        r"""
        :param _Key: Key
        :type Key: str
        :param _Value: Value
        :type Value: int
        """
        self._Key = None
        self._Value = None

    @property
    def Key(self):
        r"""Key
        :rtype: str
        """
        return self._Key

    @Key.setter
    def Key(self, Key):
        self._Key = Key

    @property
    def Value(self):
        r"""Value
        :rtype: int
        """
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value


    def _deserialize(self, params):
        self._Key = params.get("Key")
        self._Value = params.get("Value")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LLMMonPkg(AbstractModel):
    r"""有效预付费大模型安全包信息

    """

    def __init__(self):
        r"""
        :param _ResourceIds: 资源id
        :type ResourceIds: str
        :param _Status: 状态
        :type Status: int
        :param _Region: 地域
        :type Region: int
        :param _BeginTime: 开始时间
        :type BeginTime: str
        :param _EndTime: 结束时间
        :type EndTime: str
        :param _InquireKey: 计费项
        :type InquireKey: str
        :param _RenewFlag: 预付费大模型安全续费标识
0 手动续费；1自动续费；2 到期不续
        :type RenewFlag: int
        :param _UseToken: 大模型安全Token使用量
        :type UseToken: int
        :param _InstanceId: 实例id
        :type InstanceId: str
        """
        self._ResourceIds = None
        self._Status = None
        self._Region = None
        self._BeginTime = None
        self._EndTime = None
        self._InquireKey = None
        self._RenewFlag = None
        self._UseToken = None
        self._InstanceId = None

    @property
    def ResourceIds(self):
        r"""资源id
        :rtype: str
        """
        return self._ResourceIds

    @ResourceIds.setter
    def ResourceIds(self, ResourceIds):
        self._ResourceIds = ResourceIds

    @property
    def Status(self):
        r"""状态
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Region(self):
        r"""地域
        :rtype: int
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def BeginTime(self):
        r"""开始时间
        :rtype: str
        """
        return self._BeginTime

    @BeginTime.setter
    def BeginTime(self, BeginTime):
        self._BeginTime = BeginTime

    @property
    def EndTime(self):
        r"""结束时间
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def InquireKey(self):
        r"""计费项
        :rtype: str
        """
        return self._InquireKey

    @InquireKey.setter
    def InquireKey(self, InquireKey):
        self._InquireKey = InquireKey

    @property
    def RenewFlag(self):
        r"""预付费大模型安全续费标识
0 手动续费；1自动续费；2 到期不续
        :rtype: int
        """
        return self._RenewFlag

    @RenewFlag.setter
    def RenewFlag(self, RenewFlag):
        self._RenewFlag = RenewFlag

    @property
    def UseToken(self):
        r"""大模型安全Token使用量
        :rtype: int
        """
        return self._UseToken

    @UseToken.setter
    def UseToken(self, UseToken):
        self._UseToken = UseToken

    @property
    def InstanceId(self):
        r"""实例id
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId


    def _deserialize(self, params):
        self._ResourceIds = params.get("ResourceIds")
        self._Status = params.get("Status")
        self._Region = params.get("Region")
        self._BeginTime = params.get("BeginTime")
        self._EndTime = params.get("EndTime")
        self._InquireKey = params.get("InquireKey")
        self._RenewFlag = params.get("RenewFlag")
        self._UseToken = params.get("UseToken")
        self._InstanceId = params.get("InstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LLMPkg(AbstractModel):
    r"""有效大模型安全包信息

    """

    def __init__(self):
        r"""
        :param _ResourceIds: 资源id
        :type ResourceIds: str
        :param _Status: 状态
        :type Status: int
        :param _Region: 地域
        :type Region: int
        :param _BeginTime: 开始时间
        :type BeginTime: str
        :param _EndTime: 结束时间
        :type EndTime: str
        :param _InquireKey: 计费项
        :type InquireKey: str
        """
        self._ResourceIds = None
        self._Status = None
        self._Region = None
        self._BeginTime = None
        self._EndTime = None
        self._InquireKey = None

    @property
    def ResourceIds(self):
        r"""资源id
        :rtype: str
        """
        return self._ResourceIds

    @ResourceIds.setter
    def ResourceIds(self, ResourceIds):
        self._ResourceIds = ResourceIds

    @property
    def Status(self):
        r"""状态
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Region(self):
        r"""地域
        :rtype: int
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def BeginTime(self):
        r"""开始时间
        :rtype: str
        """
        return self._BeginTime

    @BeginTime.setter
    def BeginTime(self, BeginTime):
        self._BeginTime = BeginTime

    @property
    def EndTime(self):
        r"""结束时间
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def InquireKey(self):
        r"""计费项
        :rtype: str
        """
        return self._InquireKey

    @InquireKey.setter
    def InquireKey(self, InquireKey):
        self._InquireKey = InquireKey


    def _deserialize(self, params):
        self._ResourceIds = params.get("ResourceIds")
        self._Status = params.get("Status")
        self._Region = params.get("Region")
        self._BeginTime = params.get("BeginTime")
        self._EndTime = params.get("EndTime")
        self._InquireKey = params.get("InquireKey")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LoadBalancer(AbstractModel):
    r"""负载均衡的监听器

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: 负载均衡LD的ID
        :type LoadBalancerId: str
        :param _LoadBalancerName: 负载均衡LD的名称
        :type LoadBalancerName: str
        :param _ListenerId: 负载均衡监听器的ID
        :type ListenerId: str
        :param _ListenerName: 负载均衡监听器的名称
        :type ListenerName: str
        :param _Vport: 负载均衡实例的端口
        :type Vport: int
        :param _Region: 负载均衡LD的地域
        :type Region: str
        :param _Protocol: 监听器协议，http、https
        :type Protocol: str
        :param _Zone: 负载均衡监听器所在的zone
        :type Zone: str
        :param _Vip: 负载均衡实例的IP。域名化CLB VIP可填空。
        :type Vip: str
        :param _NumericalVpcId: 负载均衡的VPCID，公网为-1，内网按实际填写
        :type NumericalVpcId: int
        :param _LoadBalancerType: 负载均衡的网络类型。OPEN： 公网 INTERNAL ：内网
        :type LoadBalancerType: str
        :param _LoadBalancerDomain: 负载均衡的域名
        :type LoadBalancerDomain: str
        """
        self._LoadBalancerId = None
        self._LoadBalancerName = None
        self._ListenerId = None
        self._ListenerName = None
        self._Vport = None
        self._Region = None
        self._Protocol = None
        self._Zone = None
        self._Vip = None
        self._NumericalVpcId = None
        self._LoadBalancerType = None
        self._LoadBalancerDomain = None

    @property
    def LoadBalancerId(self):
        r"""负载均衡LD的ID
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def LoadBalancerName(self):
        r"""负载均衡LD的名称
        :rtype: str
        """
        return self._LoadBalancerName

    @LoadBalancerName.setter
    def LoadBalancerName(self, LoadBalancerName):
        self._LoadBalancerName = LoadBalancerName

    @property
    def ListenerId(self):
        r"""负载均衡监听器的ID
        :rtype: str
        """
        return self._ListenerId

    @ListenerId.setter
    def ListenerId(self, ListenerId):
        self._ListenerId = ListenerId

    @property
    def ListenerName(self):
        r"""负载均衡监听器的名称
        :rtype: str
        """
        return self._ListenerName

    @ListenerName.setter
    def ListenerName(self, ListenerName):
        self._ListenerName = ListenerName

    @property
    def Vport(self):
        r"""负载均衡实例的端口
        :rtype: int
        """
        return self._Vport

    @Vport.setter
    def Vport(self, Vport):
        self._Vport = Vport

    @property
    def Region(self):
        r"""负载均衡LD的地域
        :rtype: str
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def Protocol(self):
        r"""监听器协议，http、https
        :rtype: str
        """
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol

    @property
    def Zone(self):
        r"""负载均衡监听器所在的zone
        :rtype: str
        """
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def Vip(self):
        r"""负载均衡实例的IP。域名化CLB VIP可填空。
        :rtype: str
        """
        return self._Vip

    @Vip.setter
    def Vip(self, Vip):
        self._Vip = Vip

    @property
    def NumericalVpcId(self):
        r"""负载均衡的VPCID，公网为-1，内网按实际填写
        :rtype: int
        """
        return self._NumericalVpcId

    @NumericalVpcId.setter
    def NumericalVpcId(self, NumericalVpcId):
        self._NumericalVpcId = NumericalVpcId

    @property
    def LoadBalancerType(self):
        r"""负载均衡的网络类型。OPEN： 公网 INTERNAL ：内网
        :rtype: str
        """
        return self._LoadBalancerType

    @LoadBalancerType.setter
    def LoadBalancerType(self, LoadBalancerType):
        self._LoadBalancerType = LoadBalancerType

    @property
    def LoadBalancerDomain(self):
        r"""负载均衡的域名
        :rtype: str
        """
        return self._LoadBalancerDomain

    @LoadBalancerDomain.setter
    def LoadBalancerDomain(self, LoadBalancerDomain):
        self._LoadBalancerDomain = LoadBalancerDomain


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        self._LoadBalancerName = params.get("LoadBalancerName")
        self._ListenerId = params.get("ListenerId")
        self._ListenerName = params.get("ListenerName")
        self._Vport = params.get("Vport")
        self._Region = params.get("Region")
        self._Protocol = params.get("Protocol")
        self._Zone = params.get("Zone")
        self._Vip = params.get("Vip")
        self._NumericalVpcId = params.get("NumericalVpcId")
        self._LoadBalancerType = params.get("LoadBalancerType")
        self._LoadBalancerDomain = params.get("LoadBalancerDomain")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LoadBalancerPackageNew(AbstractModel):
    r"""负载均衡器

    """

    def __init__(self):
        r"""
        :param _ListenerId: 监听id
        :type ListenerId: str
        :param _ListenerName: 监听名
        :type ListenerName: str
        :param _LoadBalancerId: 负载均衡id
        :type LoadBalancerId: str
        :param _LoadBalancerName: 负载均衡名
        :type LoadBalancerName: str
        :param _Protocol: 协议
        :type Protocol: str
        :param _Region: 地区
    "多伦多": "ca",
    "广州": "gz",
    "成都": "cd",
    "福州": "fzec",
    "深圳": "szx",
    "印度": "in",
    "济南": "jnec",
    "重庆": "cq",
    "天津": "tsn",
    "欧洲东北": "ru",
    "南京": "nj",
    "美国硅谷": "usw",
    "泰国": "th",
    "广州Open": "gzopen",
    "深圳金融": "szjr",
    "法兰克福": "de",
    "日本": "jp",
    "弗吉尼亚": "use",
    "北京": "bj",
    "中国香港": "hk",
    "杭州": "hzec",
    "北京金融": "bjjr",
    "上海金融": "shjr",
    "台北": "tpe",
    "首尔": "kr",
    "上海": "sh",
    "新加坡": "sg",
    "清远": "qy",
    "雅加达": "jkt"
        :type Region: str
        :param _Vip: 接入IP
        :type Vip: str
        :param _Vport: 接入端口
        :type Vport: int
        :param _Zone: 地域
        :type Zone: str
        :param _NumericalVpcId: VPCID
        :type NumericalVpcId: int
        :param _LoadBalancerType: CLB类型
        :type LoadBalancerType: str
        :param _LoadBalancerDomain: 负载均衡器的域名
        :type LoadBalancerDomain: str
        """
        self._ListenerId = None
        self._ListenerName = None
        self._LoadBalancerId = None
        self._LoadBalancerName = None
        self._Protocol = None
        self._Region = None
        self._Vip = None
        self._Vport = None
        self._Zone = None
        self._NumericalVpcId = None
        self._LoadBalancerType = None
        self._LoadBalancerDomain = None

    @property
    def ListenerId(self):
        r"""监听id
        :rtype: str
        """
        return self._ListenerId

    @ListenerId.setter
    def ListenerId(self, ListenerId):
        self._ListenerId = ListenerId

    @property
    def ListenerName(self):
        r"""监听名
        :rtype: str
        """
        return self._ListenerName

    @ListenerName.setter
    def ListenerName(self, ListenerName):
        self._ListenerName = ListenerName

    @property
    def LoadBalancerId(self):
        r"""负载均衡id
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def LoadBalancerName(self):
        r"""负载均衡名
        :rtype: str
        """
        return self._LoadBalancerName

    @LoadBalancerName.setter
    def LoadBalancerName(self, LoadBalancerName):
        self._LoadBalancerName = LoadBalancerName

    @property
    def Protocol(self):
        r"""协议
        :rtype: str
        """
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol

    @property
    def Region(self):
        r"""地区
    "多伦多": "ca",
    "广州": "gz",
    "成都": "cd",
    "福州": "fzec",
    "深圳": "szx",
    "印度": "in",
    "济南": "jnec",
    "重庆": "cq",
    "天津": "tsn",
    "欧洲东北": "ru",
    "南京": "nj",
    "美国硅谷": "usw",
    "泰国": "th",
    "广州Open": "gzopen",
    "深圳金融": "szjr",
    "法兰克福": "de",
    "日本": "jp",
    "弗吉尼亚": "use",
    "北京": "bj",
    "中国香港": "hk",
    "杭州": "hzec",
    "北京金融": "bjjr",
    "上海金融": "shjr",
    "台北": "tpe",
    "首尔": "kr",
    "上海": "sh",
    "新加坡": "sg",
    "清远": "qy",
    "雅加达": "jkt"
        :rtype: str
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def Vip(self):
        r"""接入IP
        :rtype: str
        """
        return self._Vip

    @Vip.setter
    def Vip(self, Vip):
        self._Vip = Vip

    @property
    def Vport(self):
        r"""接入端口
        :rtype: int
        """
        return self._Vport

    @Vport.setter
    def Vport(self, Vport):
        self._Vport = Vport

    @property
    def Zone(self):
        r"""地域
        :rtype: str
        """
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def NumericalVpcId(self):
        r"""VPCID
        :rtype: int
        """
        return self._NumericalVpcId

    @NumericalVpcId.setter
    def NumericalVpcId(self, NumericalVpcId):
        self._NumericalVpcId = NumericalVpcId

    @property
    def LoadBalancerType(self):
        r"""CLB类型
        :rtype: str
        """
        return self._LoadBalancerType

    @LoadBalancerType.setter
    def LoadBalancerType(self, LoadBalancerType):
        self._LoadBalancerType = LoadBalancerType

    @property
    def LoadBalancerDomain(self):
        r"""负载均衡器的域名
        :rtype: str
        """
        return self._LoadBalancerDomain

    @LoadBalancerDomain.setter
    def LoadBalancerDomain(self, LoadBalancerDomain):
        self._LoadBalancerDomain = LoadBalancerDomain


    def _deserialize(self, params):
        self._ListenerId = params.get("ListenerId")
        self._ListenerName = params.get("ListenerName")
        self._LoadBalancerId = params.get("LoadBalancerId")
        self._LoadBalancerName = params.get("LoadBalancerName")
        self._Protocol = params.get("Protocol")
        self._Region = params.get("Region")
        self._Vip = params.get("Vip")
        self._Vport = params.get("Vport")
        self._Zone = params.get("Zone")
        self._NumericalVpcId = params.get("NumericalVpcId")
        self._LoadBalancerType = params.get("LoadBalancerType")
        self._LoadBalancerDomain = params.get("LoadBalancerDomain")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LogHistogramInfo(AbstractModel):
    r"""攻击日志统计详情

    """

    def __init__(self):
        r"""
        :param _Count: 日志条数
        :type Count: int
        :param _TimeStamp: 时间戳
        :type TimeStamp: int
        """
        self._Count = None
        self._TimeStamp = None

    @property
    def Count(self):
        r"""日志条数
        :rtype: int
        """
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def TimeStamp(self):
        r"""时间戳
        :rtype: int
        """
        return self._TimeStamp

    @TimeStamp.setter
    def TimeStamp(self, TimeStamp):
        self._TimeStamp = TimeStamp


    def _deserialize(self, params):
        self._Count = params.get("Count")
        self._TimeStamp = params.get("TimeStamp")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LogInfo(AbstractModel):
    r"""日志结果信息

    """

    def __init__(self):
        r"""
        :param _Time: 日志时间，单位ms
        :type Time: int
        :param _TopicId: 日志主题ID
        :type TopicId: str
        :param _TopicName: 日志主题名称
        :type TopicName: str
        :param _Source: 日志来源IP
        :type Source: str
        :param _FileName: 日志文件名称
        :type FileName: str
        :param _PkgId: 日志上报请求包的ID
        :type PkgId: str
        :param _PkgLogId: 请求包内日志的ID
        :type PkgLogId: str
        :param _LogJson: 日志内容的Json序列化字符串
注意：此字段可能返回 null，表示取不到有效值。
        :type LogJson: str
        :param _HostName: 日志来源主机名称
注意：此字段可能返回 null，表示取不到有效值。
        :type HostName: str
        :param _RawLog: 原始日志(仅在日志创建索引异常时有值)
注意：此字段可能返回 null，表示取不到有效值。
        :type RawLog: str
        :param _IndexStatus: 日志创建索引异常原因(仅在日志创建索引异常时有值)
注意：此字段可能返回 null，表示取不到有效值。
        :type IndexStatus: str
        """
        self._Time = None
        self._TopicId = None
        self._TopicName = None
        self._Source = None
        self._FileName = None
        self._PkgId = None
        self._PkgLogId = None
        self._LogJson = None
        self._HostName = None
        self._RawLog = None
        self._IndexStatus = None

    @property
    def Time(self):
        r"""日志时间，单位ms
        :rtype: int
        """
        return self._Time

    @Time.setter
    def Time(self, Time):
        self._Time = Time

    @property
    def TopicId(self):
        r"""日志主题ID
        :rtype: str
        """
        return self._TopicId

    @TopicId.setter
    def TopicId(self, TopicId):
        self._TopicId = TopicId

    @property
    def TopicName(self):
        r"""日志主题名称
        :rtype: str
        """
        return self._TopicName

    @TopicName.setter
    def TopicName(self, TopicName):
        self._TopicName = TopicName

    @property
    def Source(self):
        r"""日志来源IP
        :rtype: str
        """
        return self._Source

    @Source.setter
    def Source(self, Source):
        self._Source = Source

    @property
    def FileName(self):
        r"""日志文件名称
        :rtype: str
        """
        return self._FileName

    @FileName.setter
    def FileName(self, FileName):
        self._FileName = FileName

    @property
    def PkgId(self):
        r"""日志上报请求包的ID
        :rtype: str
        """
        return self._PkgId

    @PkgId.setter
    def PkgId(self, PkgId):
        self._PkgId = PkgId

    @property
    def PkgLogId(self):
        r"""请求包内日志的ID
        :rtype: str
        """
        return self._PkgLogId

    @PkgLogId.setter
    def PkgLogId(self, PkgLogId):
        self._PkgLogId = PkgLogId

    @property
    def LogJson(self):
        r"""日志内容的Json序列化字符串
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._LogJson

    @LogJson.setter
    def LogJson(self, LogJson):
        self._LogJson = LogJson

    @property
    def HostName(self):
        r"""日志来源主机名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._HostName

    @HostName.setter
    def HostName(self, HostName):
        self._HostName = HostName

    @property
    def RawLog(self):
        r"""原始日志(仅在日志创建索引异常时有值)
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._RawLog

    @RawLog.setter
    def RawLog(self, RawLog):
        self._RawLog = RawLog

    @property
    def IndexStatus(self):
        r"""日志创建索引异常原因(仅在日志创建索引异常时有值)
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._IndexStatus

    @IndexStatus.setter
    def IndexStatus(self, IndexStatus):
        self._IndexStatus = IndexStatus


    def _deserialize(self, params):
        self._Time = params.get("Time")
        self._TopicId = params.get("TopicId")
        self._TopicName = params.get("TopicName")
        self._Source = params.get("Source")
        self._FileName = params.get("FileName")
        self._PkgId = params.get("PkgId")
        self._PkgLogId = params.get("PkgLogId")
        self._LogJson = params.get("LogJson")
        self._HostName = params.get("HostName")
        self._RawLog = params.get("RawLog")
        self._IndexStatus = params.get("IndexStatus")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LogItem(AbstractModel):
    r"""日志中的KV对

    """

    def __init__(self):
        r"""
        :param _Key: 日志Key
        :type Key: str
        :param _Value: 日志Value
        :type Value: str
        """
        self._Key = None
        self._Value = None

    @property
    def Key(self):
        r"""日志Key
        :rtype: str
        """
        return self._Key

    @Key.setter
    def Key(self, Key):
        self._Key = Key

    @property
    def Value(self):
        r"""日志Value
        :rtype: str
        """
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value


    def _deserialize(self, params):
        self._Key = params.get("Key")
        self._Value = params.get("Value")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LogItems(AbstractModel):
    r"""LogItem的数组

    """

    def __init__(self):
        r"""
        :param _Data: 分析结果返回的KV数据对
        :type Data: list of LogItem
        """
        self._Data = None

    @property
    def Data(self):
        r"""分析结果返回的KV数据对
        :rtype: list of LogItem
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = LogItem()
                obj._deserialize(item)
                self._Data.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MajorEventsPkg(AbstractModel):
    r"""重保防护资源信息

    """

    def __init__(self):
        r"""
        :param _ResourceIds: 资源id
        :type ResourceIds: str
        :param _Status: 状态
        :type Status: int
        :param _Region: 地域
        :type Region: int
        :param _BeginTime: 开始时间
        :type BeginTime: str
        :param _EndTime: 结束时间
        :type EndTime: str
        :param _InquireNum: 申请数量
        :type InquireNum: int
        :param _UsedNum: 使用数量
        :type UsedNum: int
        :param _RenewFlag: 续费标志
        :type RenewFlag: int
        :param _BillingItem: 计费项
        :type BillingItem: str
        :param _HWState: 护网包状态
        :type HWState: int
        """
        self._ResourceIds = None
        self._Status = None
        self._Region = None
        self._BeginTime = None
        self._EndTime = None
        self._InquireNum = None
        self._UsedNum = None
        self._RenewFlag = None
        self._BillingItem = None
        self._HWState = None

    @property
    def ResourceIds(self):
        r"""资源id
        :rtype: str
        """
        return self._ResourceIds

    @ResourceIds.setter
    def ResourceIds(self, ResourceIds):
        self._ResourceIds = ResourceIds

    @property
    def Status(self):
        r"""状态
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Region(self):
        r"""地域
        :rtype: int
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def BeginTime(self):
        r"""开始时间
        :rtype: str
        """
        return self._BeginTime

    @BeginTime.setter
    def BeginTime(self, BeginTime):
        self._BeginTime = BeginTime

    @property
    def EndTime(self):
        r"""结束时间
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def InquireNum(self):
        r"""申请数量
        :rtype: int
        """
        return self._InquireNum

    @InquireNum.setter
    def InquireNum(self, InquireNum):
        self._InquireNum = InquireNum

    @property
    def UsedNum(self):
        r"""使用数量
        :rtype: int
        """
        return self._UsedNum

    @UsedNum.setter
    def UsedNum(self, UsedNum):
        self._UsedNum = UsedNum

    @property
    def RenewFlag(self):
        r"""续费标志
        :rtype: int
        """
        return self._RenewFlag

    @RenewFlag.setter
    def RenewFlag(self, RenewFlag):
        self._RenewFlag = RenewFlag

    @property
    def BillingItem(self):
        r"""计费项
        :rtype: str
        """
        return self._BillingItem

    @BillingItem.setter
    def BillingItem(self, BillingItem):
        self._BillingItem = BillingItem

    @property
    def HWState(self):
        r"""护网包状态
        :rtype: int
        """
        return self._HWState

    @HWState.setter
    def HWState(self, HWState):
        self._HWState = HWState


    def _deserialize(self, params):
        self._ResourceIds = params.get("ResourceIds")
        self._Status = params.get("Status")
        self._Region = params.get("Region")
        self._BeginTime = params.get("BeginTime")
        self._EndTime = params.get("EndTime")
        self._InquireNum = params.get("InquireNum")
        self._UsedNum = params.get("UsedNum")
        self._RenewFlag = params.get("RenewFlag")
        self._BillingItem = params.get("BillingItem")
        self._HWState = params.get("HWState")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MajorEventsProPkg(AbstractModel):
    r"""重保防护资源信息

    """

    def __init__(self):
        r"""
        :param _ResourceIds: 资源id
        :type ResourceIds: str
        :param _Status: 状态
        :type Status: int
        :param _Region: 地域
        :type Region: int
        :param _BeginTime: 开始时间
        :type BeginTime: str
        :param _EndTime: 结束时间
        :type EndTime: str
        :param _InquireNum: 申请数量
        :type InquireNum: int
        :param _UsedNum: 使用数量
        :type UsedNum: int
        :param _RenewFlag: 续费标志
        :type RenewFlag: int
        :param _BillingItem: 计费项
        :type BillingItem: str
        """
        self._ResourceIds = None
        self._Status = None
        self._Region = None
        self._BeginTime = None
        self._EndTime = None
        self._InquireNum = None
        self._UsedNum = None
        self._RenewFlag = None
        self._BillingItem = None

    @property
    def ResourceIds(self):
        r"""资源id
        :rtype: str
        """
        return self._ResourceIds

    @ResourceIds.setter
    def ResourceIds(self, ResourceIds):
        self._ResourceIds = ResourceIds

    @property
    def Status(self):
        r"""状态
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Region(self):
        r"""地域
        :rtype: int
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def BeginTime(self):
        r"""开始时间
        :rtype: str
        """
        return self._BeginTime

    @BeginTime.setter
    def BeginTime(self, BeginTime):
        self._BeginTime = BeginTime

    @property
    def EndTime(self):
        r"""结束时间
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def InquireNum(self):
        r"""申请数量
        :rtype: int
        """
        return self._InquireNum

    @InquireNum.setter
    def InquireNum(self, InquireNum):
        self._InquireNum = InquireNum

    @property
    def UsedNum(self):
        r"""使用数量
        :rtype: int
        """
        return self._UsedNum

    @UsedNum.setter
    def UsedNum(self, UsedNum):
        self._UsedNum = UsedNum

    @property
    def RenewFlag(self):
        r"""续费标志
        :rtype: int
        """
        return self._RenewFlag

    @RenewFlag.setter
    def RenewFlag(self, RenewFlag):
        self._RenewFlag = RenewFlag

    @property
    def BillingItem(self):
        r"""计费项
        :rtype: str
        """
        return self._BillingItem

    @BillingItem.setter
    def BillingItem(self, BillingItem):
        self._BillingItem = BillingItem


    def _deserialize(self, params):
        self._ResourceIds = params.get("ResourceIds")
        self._Status = params.get("Status")
        self._Region = params.get("Region")
        self._BeginTime = params.get("BeginTime")
        self._EndTime = params.get("EndTime")
        self._InquireNum = params.get("InquireNum")
        self._UsedNum = params.get("UsedNum")
        self._RenewFlag = params.get("RenewFlag")
        self._BillingItem = params.get("BillingItem")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MiniExtendPkg(AbstractModel):
    r"""小程序安全接入ID扩展资源信息

    """

    def __init__(self):
        r"""
        :param _ResourceIds: 资源id
        :type ResourceIds: str
        :param _Status: 状态
        :type Status: int
        :param _Region: 地域
        :type Region: int
        :param _BeginTime: 开始时间
        :type BeginTime: str
        :param _EndTime: 结束时间
        :type EndTime: str
        :param _Count: 购买数量
        :type Count: int
        :param _RenewFlag: 续费标志
        :type RenewFlag: int
        :param _BillingItem: 计费项
        :type BillingItem: str
        """
        self._ResourceIds = None
        self._Status = None
        self._Region = None
        self._BeginTime = None
        self._EndTime = None
        self._Count = None
        self._RenewFlag = None
        self._BillingItem = None

    @property
    def ResourceIds(self):
        r"""资源id
        :rtype: str
        """
        return self._ResourceIds

    @ResourceIds.setter
    def ResourceIds(self, ResourceIds):
        self._ResourceIds = ResourceIds

    @property
    def Status(self):
        r"""状态
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Region(self):
        r"""地域
        :rtype: int
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def BeginTime(self):
        r"""开始时间
        :rtype: str
        """
        return self._BeginTime

    @BeginTime.setter
    def BeginTime(self, BeginTime):
        self._BeginTime = BeginTime

    @property
    def EndTime(self):
        r"""结束时间
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Count(self):
        r"""购买数量
        :rtype: int
        """
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def RenewFlag(self):
        r"""续费标志
        :rtype: int
        """
        return self._RenewFlag

    @RenewFlag.setter
    def RenewFlag(self, RenewFlag):
        self._RenewFlag = RenewFlag

    @property
    def BillingItem(self):
        r"""计费项
        :rtype: str
        """
        return self._BillingItem

    @BillingItem.setter
    def BillingItem(self, BillingItem):
        self._BillingItem = BillingItem


    def _deserialize(self, params):
        self._ResourceIds = params.get("ResourceIds")
        self._Status = params.get("Status")
        self._Region = params.get("Region")
        self._BeginTime = params.get("BeginTime")
        self._EndTime = params.get("EndTime")
        self._Count = params.get("Count")
        self._RenewFlag = params.get("RenewFlag")
        self._BillingItem = params.get("BillingItem")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MiniPkg(AbstractModel):
    r"""小程序安全资源信息

    """

    def __init__(self):
        r"""
        :param _ResourceIds: 资源id
        :type ResourceIds: str
        :param _Status: 状态
        :type Status: int
        :param _Region: 地域
        :type Region: int
        :param _BeginTime: 开始时间
        :type BeginTime: str
        :param _EndTime: 结束时间
        :type EndTime: str
        :param _Count: 购买数量
        :type Count: int
        :param _RenewFlag: 续费标志
        :type RenewFlag: int
        :param _BillingItem: 计费项
        :type BillingItem: str
        """
        self._ResourceIds = None
        self._Status = None
        self._Region = None
        self._BeginTime = None
        self._EndTime = None
        self._Count = None
        self._RenewFlag = None
        self._BillingItem = None

    @property
    def ResourceIds(self):
        r"""资源id
        :rtype: str
        """
        return self._ResourceIds

    @ResourceIds.setter
    def ResourceIds(self, ResourceIds):
        self._ResourceIds = ResourceIds

    @property
    def Status(self):
        r"""状态
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Region(self):
        r"""地域
        :rtype: int
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def BeginTime(self):
        r"""开始时间
        :rtype: str
        """
        return self._BeginTime

    @BeginTime.setter
    def BeginTime(self, BeginTime):
        self._BeginTime = BeginTime

    @property
    def EndTime(self):
        r"""结束时间
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Count(self):
        r"""购买数量
        :rtype: int
        """
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def RenewFlag(self):
        r"""续费标志
        :rtype: int
        """
        return self._RenewFlag

    @RenewFlag.setter
    def RenewFlag(self, RenewFlag):
        self._RenewFlag = RenewFlag

    @property
    def BillingItem(self):
        r"""计费项
        :rtype: str
        """
        return self._BillingItem

    @BillingItem.setter
    def BillingItem(self, BillingItem):
        self._BillingItem = BillingItem


    def _deserialize(self, params):
        self._ResourceIds = params.get("ResourceIds")
        self._Status = params.get("Status")
        self._Region = params.get("Region")
        self._BeginTime = params.get("BeginTime")
        self._EndTime = params.get("EndTime")
        self._Count = params.get("Count")
        self._RenewFlag = params.get("RenewFlag")
        self._BillingItem = params.get("BillingItem")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyAntiFakeUrlRequest(AbstractModel):
    r"""ModifyAntiFakeUrl请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _Name: 名称
        :type Name: str
        :param _Uri: uri
        :type Uri: str
        :param _Id: ID
        :type Id: int
        """
        self._Domain = None
        self._Name = None
        self._Uri = None
        self._Id = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Name(self):
        r"""名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Uri(self):
        r"""uri
        :rtype: str
        """
        return self._Uri

    @Uri.setter
    def Uri(self, Uri):
        self._Uri = Uri

    @property
    def Id(self):
        r"""ID
        :rtype: int
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Name = params.get("Name")
        self._Uri = params.get("Uri")
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyAntiFakeUrlResponse(AbstractModel):
    r"""ModifyAntiFakeUrl返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 结果
        :type Result: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        r"""结果
        :rtype: str
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class ModifyAntiFakeUrlStatusRequest(AbstractModel):
    r"""ModifyAntiFakeUrlStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _Status: 状态
        :type Status: int
        :param _Ids: Id列表
        :type Ids: list of int non-negative
        """
        self._Domain = None
        self._Status = None
        self._Ids = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Status(self):
        r"""状态
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Ids(self):
        r"""Id列表
        :rtype: list of int non-negative
        """
        return self._Ids

    @Ids.setter
    def Ids(self, Ids):
        self._Ids = Ids


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Status = params.get("Status")
        self._Ids = params.get("Ids")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyAntiFakeUrlStatusResponse(AbstractModel):
    r"""ModifyAntiFakeUrlStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyAntiInfoLeakRuleStatusRequest(AbstractModel):
    r"""ModifyAntiInfoLeakRuleStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _RuleId: 规则
        :type RuleId: int
        :param _Status: 状态
        :type Status: int
        """
        self._Domain = None
        self._RuleId = None
        self._Status = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def RuleId(self):
        r"""规则
        :rtype: int
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def Status(self):
        r"""状态
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._RuleId = params.get("RuleId")
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyAntiInfoLeakRuleStatusResponse(AbstractModel):
    r"""ModifyAntiInfoLeakRuleStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyAntiInfoLeakRulesRequest(AbstractModel):
    r"""ModifyAntiInfoLeakRules请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleId: 规则ID
        :type RuleId: int
        :param _Name: 规则名称
        :type Name: str
        :param _Domain: 域名
        :type Domain: str
        :param _ActionType: Action 值
        :type ActionType: int
        :param _Strategies: 策略数组
        :type Strategies: list of StrategyForAntiInfoLeak
        """
        self._RuleId = None
        self._Name = None
        self._Domain = None
        self._ActionType = None
        self._Strategies = None

    @property
    def RuleId(self):
        r"""规则ID
        :rtype: int
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def Name(self):
        r"""规则名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def ActionType(self):
        r"""Action 值
        :rtype: int
        """
        return self._ActionType

    @ActionType.setter
    def ActionType(self, ActionType):
        self._ActionType = ActionType

    @property
    def Strategies(self):
        r"""策略数组
        :rtype: list of StrategyForAntiInfoLeak
        """
        return self._Strategies

    @Strategies.setter
    def Strategies(self, Strategies):
        self._Strategies = Strategies


    def _deserialize(self, params):
        self._RuleId = params.get("RuleId")
        self._Name = params.get("Name")
        self._Domain = params.get("Domain")
        self._ActionType = params.get("ActionType")
        if params.get("Strategies") is not None:
            self._Strategies = []
            for item in params.get("Strategies"):
                obj = StrategyForAntiInfoLeak()
                obj._deserialize(item)
                self._Strategies.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyAntiInfoLeakRulesResponse(AbstractModel):
    r"""ModifyAntiInfoLeakRules返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyApiAnalyzeStatusRequest(AbstractModel):
    r"""ModifyApiAnalyzeStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Status: 开关状态
        :type Status: int
        :param _Domain: 域名
        :type Domain: str
        :param _InstanceId: 实例id
        :type InstanceId: str
        :param _TargetList: 需要批量开启的实体列表
        :type TargetList: list of TargetEntity
        """
        self._Status = None
        self._Domain = None
        self._InstanceId = None
        self._TargetList = None

    @property
    def Status(self):
        r"""开关状态
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def InstanceId(self):
        r"""实例id
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def TargetList(self):
        r"""需要批量开启的实体列表
        :rtype: list of TargetEntity
        """
        return self._TargetList

    @TargetList.setter
    def TargetList(self, TargetList):
        self._TargetList = TargetList


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._Domain = params.get("Domain")
        self._InstanceId = params.get("InstanceId")
        if params.get("TargetList") is not None:
            self._TargetList = []
            for item in params.get("TargetList"):
                obj = TargetEntity()
                obj._deserialize(item)
                self._TargetList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyApiAnalyzeStatusResponse(AbstractModel):
    r"""ModifyApiAnalyzeStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Count: 已经开启的数量,如果返回值为3（大于支持的域名开启数量），则表示开启失败
        :type Count: int
        :param _UnSupportedList: 不支持开启的域名列表
        :type UnSupportedList: list of str
        :param _FailDomainList: 开启/关闭失败的域名列表
        :type FailDomainList: list of str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Count = None
        self._UnSupportedList = None
        self._FailDomainList = None
        self._RequestId = None

    @property
    def Count(self):
        r"""已经开启的数量,如果返回值为3（大于支持的域名开启数量），则表示开启失败
        :rtype: int
        """
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def UnSupportedList(self):
        r"""不支持开启的域名列表
        :rtype: list of str
        """
        return self._UnSupportedList

    @UnSupportedList.setter
    def UnSupportedList(self, UnSupportedList):
        self._UnSupportedList = UnSupportedList

    @property
    def FailDomainList(self):
        r"""开启/关闭失败的域名列表
        :rtype: list of str
        """
        return self._FailDomainList

    @FailDomainList.setter
    def FailDomainList(self, FailDomainList):
        self._FailDomainList = FailDomainList

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Count = params.get("Count")
        self._UnSupportedList = params.get("UnSupportedList")
        self._FailDomainList = params.get("FailDomainList")
        self._RequestId = params.get("RequestId")


class ModifyApiSecEventChangeRequest(AbstractModel):
    r"""ModifyApiSecEventChange请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Mode: 变更状态，1:新发现，2，确认中，3，已确认，4，已下线，5，已忽略
        :type Mode: str
        :param _UserName: 处理人
        :type UserName: str
        :param _Remark: 备注，有长度显示1k
        :type Remark: str
        :param _EventIdList: 批量操作的事件列表
        :type EventIdList: list of str
        :param _ApiNameList: 批量操作的api列表
        :type ApiNameList: list of ApiSecKey
        :param _IsDelete: 判断是否删除，包括删除事件和删除资产
        :type IsDelete: bool
        :param _UpdateApiRemark: 判断是否是更新api的备注，更新api备注的时候，为true
        :type UpdateApiRemark: bool
        """
        self._Mode = None
        self._UserName = None
        self._Remark = None
        self._EventIdList = None
        self._ApiNameList = None
        self._IsDelete = None
        self._UpdateApiRemark = None

    @property
    def Mode(self):
        r"""变更状态，1:新发现，2，确认中，3，已确认，4，已下线，5，已忽略
        :rtype: str
        """
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode

    @property
    def UserName(self):
        r"""处理人
        :rtype: str
        """
        return self._UserName

    @UserName.setter
    def UserName(self, UserName):
        self._UserName = UserName

    @property
    def Remark(self):
        r"""备注，有长度显示1k
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def EventIdList(self):
        r"""批量操作的事件列表
        :rtype: list of str
        """
        return self._EventIdList

    @EventIdList.setter
    def EventIdList(self, EventIdList):
        self._EventIdList = EventIdList

    @property
    def ApiNameList(self):
        r"""批量操作的api列表
        :rtype: list of ApiSecKey
        """
        return self._ApiNameList

    @ApiNameList.setter
    def ApiNameList(self, ApiNameList):
        self._ApiNameList = ApiNameList

    @property
    def IsDelete(self):
        r"""判断是否删除，包括删除事件和删除资产
        :rtype: bool
        """
        return self._IsDelete

    @IsDelete.setter
    def IsDelete(self, IsDelete):
        self._IsDelete = IsDelete

    @property
    def UpdateApiRemark(self):
        r"""判断是否是更新api的备注，更新api备注的时候，为true
        :rtype: bool
        """
        return self._UpdateApiRemark

    @UpdateApiRemark.setter
    def UpdateApiRemark(self, UpdateApiRemark):
        self._UpdateApiRemark = UpdateApiRemark


    def _deserialize(self, params):
        self._Mode = params.get("Mode")
        self._UserName = params.get("UserName")
        self._Remark = params.get("Remark")
        self._EventIdList = params.get("EventIdList")
        if params.get("ApiNameList") is not None:
            self._ApiNameList = []
            for item in params.get("ApiNameList"):
                obj = ApiSecKey()
                obj._deserialize(item)
                self._ApiNameList.append(obj)
        self._IsDelete = params.get("IsDelete")
        self._UpdateApiRemark = params.get("UpdateApiRemark")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyApiSecEventChangeResponse(AbstractModel):
    r"""ModifyApiSecEventChange返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyAreaBanAreasRequest(AbstractModel):
    r"""ModifyAreaBanAreas请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 需要修改的域名
        :type Domain: str
        :param _Areas: 需要调整的地域信息，一个字符串数组
        :type Areas: list of str
        :param _JobType: 规则执行的方式，TimedJob为定时执行，CronJob为周期执行
        :type JobType: str
        :param _JobDateTime: 定时任务配置
        :type JobDateTime: :class:`tencentcloud.waf.v20180125.models.JobDateTime`
        """
        self._Domain = None
        self._Areas = None
        self._JobType = None
        self._JobDateTime = None

    @property
    def Domain(self):
        r"""需要修改的域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Areas(self):
        r"""需要调整的地域信息，一个字符串数组
        :rtype: list of str
        """
        return self._Areas

    @Areas.setter
    def Areas(self, Areas):
        self._Areas = Areas

    @property
    def JobType(self):
        r"""规则执行的方式，TimedJob为定时执行，CronJob为周期执行
        :rtype: str
        """
        return self._JobType

    @JobType.setter
    def JobType(self, JobType):
        self._JobType = JobType

    @property
    def JobDateTime(self):
        r"""定时任务配置
        :rtype: :class:`tencentcloud.waf.v20180125.models.JobDateTime`
        """
        return self._JobDateTime

    @JobDateTime.setter
    def JobDateTime(self, JobDateTime):
        self._JobDateTime = JobDateTime


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Areas = params.get("Areas")
        self._JobType = params.get("JobType")
        if params.get("JobDateTime") is not None:
            self._JobDateTime = JobDateTime()
            self._JobDateTime._deserialize(params.get("JobDateTime"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyAreaBanAreasResponse(AbstractModel):
    r"""ModifyAreaBanAreas返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyAreaBanRuleRequest(AbstractModel):
    r"""ModifyAreaBanRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 需要修改的域名
        :type Domain: str
        :param _Areas: 需要新增的封禁地域
        :type Areas: list of Area
        :param _JobType: 规则执行的方式，TimedJob为定时执行，CronJob为周期执行
        :type JobType: str
        :param _JobDateTime: 定时任务配置
        :type JobDateTime: :class:`tencentcloud.waf.v20180125.models.JobDateTime`
        :param _Lang: 地域信息的语言，支持cn、en，默认为中文cn
        :type Lang: str
        """
        self._Domain = None
        self._Areas = None
        self._JobType = None
        self._JobDateTime = None
        self._Lang = None

    @property
    def Domain(self):
        r"""需要修改的域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Areas(self):
        r"""需要新增的封禁地域
        :rtype: list of Area
        """
        return self._Areas

    @Areas.setter
    def Areas(self, Areas):
        self._Areas = Areas

    @property
    def JobType(self):
        r"""规则执行的方式，TimedJob为定时执行，CronJob为周期执行
        :rtype: str
        """
        return self._JobType

    @JobType.setter
    def JobType(self, JobType):
        self._JobType = JobType

    @property
    def JobDateTime(self):
        r"""定时任务配置
        :rtype: :class:`tencentcloud.waf.v20180125.models.JobDateTime`
        """
        return self._JobDateTime

    @JobDateTime.setter
    def JobDateTime(self, JobDateTime):
        self._JobDateTime = JobDateTime

    @property
    def Lang(self):
        r"""地域信息的语言，支持cn、en，默认为中文cn
        :rtype: str
        """
        return self._Lang

    @Lang.setter
    def Lang(self, Lang):
        self._Lang = Lang


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        if params.get("Areas") is not None:
            self._Areas = []
            for item in params.get("Areas"):
                obj = Area()
                obj._deserialize(item)
                self._Areas.append(obj)
        self._JobType = params.get("JobType")
        if params.get("JobDateTime") is not None:
            self._JobDateTime = JobDateTime()
            self._JobDateTime._deserialize(params.get("JobDateTime"))
        self._Lang = params.get("Lang")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyAreaBanRuleResponse(AbstractModel):
    r"""ModifyAreaBanRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyAreaBanStatusRequest(AbstractModel):
    r"""ModifyAreaBanStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 需要修改的域名
        :type Domain: str
        :param _Status: 状态值，0表示关闭，1表示开启
        :type Status: int
        """
        self._Domain = None
        self._Status = None

    @property
    def Domain(self):
        r"""需要修改的域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Status(self):
        r"""状态值，0表示关闭，1表示开启
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyAreaBanStatusResponse(AbstractModel):
    r"""ModifyAreaBanStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyAttackWhiteRuleRequest(AbstractModel):
    r"""ModifyAttackWhiteRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleId: 规则序号
        :type RuleId: int
        :param _Domain: 域名
        :type Domain: str
        :param _Status: 规则状态
        :type Status: int
        :param _Rules: 匹配规则项列表
        :type Rules: list of UserWhiteRuleItem
        :param _SignatureId: 规则Id
        :type SignatureId: str
        :param _SignatureIds: 编辑的加白的规则ID列表
        :type SignatureIds: list of str
        :param _TypeIds: 加白的大类规则ID
        :type TypeIds: list of str
        :param _Mode: 0表示按照特定规则ID加白, 1表示按照规则类型加白
        :type Mode: int
        :param _Name: 规则名
        :type Name: str
        """
        self._RuleId = None
        self._Domain = None
        self._Status = None
        self._Rules = None
        self._SignatureId = None
        self._SignatureIds = None
        self._TypeIds = None
        self._Mode = None
        self._Name = None

    @property
    def RuleId(self):
        r"""规则序号
        :rtype: int
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Status(self):
        r"""规则状态
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Rules(self):
        r"""匹配规则项列表
        :rtype: list of UserWhiteRuleItem
        """
        return self._Rules

    @Rules.setter
    def Rules(self, Rules):
        self._Rules = Rules

    @property
    def SignatureId(self):
        r"""规则Id
        :rtype: str
        """
        return self._SignatureId

    @SignatureId.setter
    def SignatureId(self, SignatureId):
        self._SignatureId = SignatureId

    @property
    def SignatureIds(self):
        r"""编辑的加白的规则ID列表
        :rtype: list of str
        """
        return self._SignatureIds

    @SignatureIds.setter
    def SignatureIds(self, SignatureIds):
        self._SignatureIds = SignatureIds

    @property
    def TypeIds(self):
        r"""加白的大类规则ID
        :rtype: list of str
        """
        return self._TypeIds

    @TypeIds.setter
    def TypeIds(self, TypeIds):
        self._TypeIds = TypeIds

    @property
    def Mode(self):
        r"""0表示按照特定规则ID加白, 1表示按照规则类型加白
        :rtype: int
        """
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode

    @property
    def Name(self):
        r"""规则名
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._RuleId = params.get("RuleId")
        self._Domain = params.get("Domain")
        self._Status = params.get("Status")
        if params.get("Rules") is not None:
            self._Rules = []
            for item in params.get("Rules"):
                obj = UserWhiteRuleItem()
                obj._deserialize(item)
                self._Rules.append(obj)
        self._SignatureId = params.get("SignatureId")
        self._SignatureIds = params.get("SignatureIds")
        self._TypeIds = params.get("TypeIds")
        self._Mode = params.get("Mode")
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyAttackWhiteRuleResponse(AbstractModel):
    r"""ModifyAttackWhiteRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleId: 规则总数
        :type RuleId: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RuleId = None
        self._RequestId = None

    @property
    def RuleId(self):
        r"""规则总数
        :rtype: int
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RuleId = params.get("RuleId")
        self._RequestId = params.get("RequestId")


class ModifyBatchIpAccessControlRequest(AbstractModel):
    r"""ModifyBatchIpAccessControl请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleId: 编辑的批量规则ID
        :type RuleId: int
        :param _IpList: IP参数列表
        :type IpList: list of str
        :param _JobType: 规则执行的方式，TimedJob为定时执行，CronJob为周期执行
        :type JobType: str
        :param _JobDateTime: 定时任务配置
        :type JobDateTime: :class:`tencentcloud.waf.v20180125.models.JobDateTime`
        :param _ActionType: 42为黑名单，40为白名单
        :type ActionType: int
        :param _GroupIds: 防护对象组ID列表，如果绑定的是防护对象组，和Domains参数二选一
        :type GroupIds: list of int non-negative
        :param _Domains: 域名列表，如果绑定的是批量域名，和GroupIds参数二选一
        :type Domains: list of str
        :param _Note: 备注
        :type Note: str
        """
        self._RuleId = None
        self._IpList = None
        self._JobType = None
        self._JobDateTime = None
        self._ActionType = None
        self._GroupIds = None
        self._Domains = None
        self._Note = None

    @property
    def RuleId(self):
        r"""编辑的批量规则ID
        :rtype: int
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def IpList(self):
        r"""IP参数列表
        :rtype: list of str
        """
        return self._IpList

    @IpList.setter
    def IpList(self, IpList):
        self._IpList = IpList

    @property
    def JobType(self):
        r"""规则执行的方式，TimedJob为定时执行，CronJob为周期执行
        :rtype: str
        """
        return self._JobType

    @JobType.setter
    def JobType(self, JobType):
        self._JobType = JobType

    @property
    def JobDateTime(self):
        r"""定时任务配置
        :rtype: :class:`tencentcloud.waf.v20180125.models.JobDateTime`
        """
        return self._JobDateTime

    @JobDateTime.setter
    def JobDateTime(self, JobDateTime):
        self._JobDateTime = JobDateTime

    @property
    def ActionType(self):
        r"""42为黑名单，40为白名单
        :rtype: int
        """
        return self._ActionType

    @ActionType.setter
    def ActionType(self, ActionType):
        self._ActionType = ActionType

    @property
    def GroupIds(self):
        r"""防护对象组ID列表，如果绑定的是防护对象组，和Domains参数二选一
        :rtype: list of int non-negative
        """
        return self._GroupIds

    @GroupIds.setter
    def GroupIds(self, GroupIds):
        self._GroupIds = GroupIds

    @property
    def Domains(self):
        r"""域名列表，如果绑定的是批量域名，和GroupIds参数二选一
        :rtype: list of str
        """
        return self._Domains

    @Domains.setter
    def Domains(self, Domains):
        self._Domains = Domains

    @property
    def Note(self):
        r"""备注
        :rtype: str
        """
        return self._Note

    @Note.setter
    def Note(self, Note):
        self._Note = Note


    def _deserialize(self, params):
        self._RuleId = params.get("RuleId")
        self._IpList = params.get("IpList")
        self._JobType = params.get("JobType")
        if params.get("JobDateTime") is not None:
            self._JobDateTime = JobDateTime()
            self._JobDateTime._deserialize(params.get("JobDateTime"))
        self._ActionType = params.get("ActionType")
        self._GroupIds = params.get("GroupIds")
        self._Domains = params.get("Domains")
        self._Note = params.get("Note")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyBatchIpAccessControlResponse(AbstractModel):
    r"""ModifyBatchIpAccessControl返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Failed: 编辑失败的域名列表，如果非空则表示有域名编辑失败，整个批量规则编辑失败，否则则表示批量规则编辑成功。
        :type Failed: list of BatchDomainResult
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Failed = None
        self._RequestId = None

    @property
    def Failed(self):
        r"""编辑失败的域名列表，如果非空则表示有域名编辑失败，整个批量规则编辑失败，否则则表示批量规则编辑成功。
        :rtype: list of BatchDomainResult
        """
        return self._Failed

    @Failed.setter
    def Failed(self, Failed):
        self._Failed = Failed

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Failed") is not None:
            self._Failed = []
            for item in params.get("Failed"):
                obj = BatchDomainResult()
                obj._deserialize(item)
                self._Failed.append(obj)
        self._RequestId = params.get("RequestId")


class ModifyBotSceneStatusRequest(AbstractModel):
    r"""ModifyBotSceneStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _SceneId: 场景ID
        :type SceneId: str
        :param _Status: true-开启 false-关闭
        :type Status: bool
        """
        self._Domain = None
        self._SceneId = None
        self._Status = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def SceneId(self):
        r"""场景ID
        :rtype: str
        """
        return self._SceneId

    @SceneId.setter
    def SceneId(self, SceneId):
        self._SceneId = SceneId

    @property
    def Status(self):
        r"""true-开启 false-关闭
        :rtype: bool
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._SceneId = params.get("SceneId")
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyBotSceneStatusResponse(AbstractModel):
    r"""ModifyBotSceneStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyBotSceneUCBRuleRequest(AbstractModel):
    r"""ModifyBotSceneUCBRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _SceneId: 1.BOT全局白名单处调用时，传"global";2.BOT场景配置时，传具体的场景ID
        :type SceneId: str
        :param _Rule: 规则内容, 增加编码SceneId信息,1.BOT全局白名单处调用时，SceneId为"global", RuleType传10, Action为"permit";2.BOT场景配置时，SceneId为场景ID
        :type Rule: :class:`tencentcloud.waf.v20180125.models.InOutputBotUCBRule`
        :param _BatchRules: 530改批量操作
        :type BatchRules: list of InOutputBotUCBRule
        """
        self._Domain = None
        self._SceneId = None
        self._Rule = None
        self._BatchRules = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def SceneId(self):
        r"""1.BOT全局白名单处调用时，传"global";2.BOT场景配置时，传具体的场景ID
        :rtype: str
        """
        return self._SceneId

    @SceneId.setter
    def SceneId(self, SceneId):
        self._SceneId = SceneId

    @property
    def Rule(self):
        r"""规则内容, 增加编码SceneId信息,1.BOT全局白名单处调用时，SceneId为"global", RuleType传10, Action为"permit";2.BOT场景配置时，SceneId为场景ID
        :rtype: :class:`tencentcloud.waf.v20180125.models.InOutputBotUCBRule`
        """
        return self._Rule

    @Rule.setter
    def Rule(self, Rule):
        self._Rule = Rule

    @property
    def BatchRules(self):
        r"""530改批量操作
        :rtype: list of InOutputBotUCBRule
        """
        return self._BatchRules

    @BatchRules.setter
    def BatchRules(self, BatchRules):
        self._BatchRules = BatchRules


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._SceneId = params.get("SceneId")
        if params.get("Rule") is not None:
            self._Rule = InOutputBotUCBRule()
            self._Rule._deserialize(params.get("Rule"))
        if params.get("BatchRules") is not None:
            self._BatchRules = []
            for item in params.get("BatchRules"):
                obj = InOutputBotUCBRule()
                obj._deserialize(item)
                self._BatchRules.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyBotSceneUCBRuleResponse(AbstractModel):
    r"""ModifyBotSceneUCBRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 正常情况下为null
        :type Data: str
        :param _RuleIdList: ["1231"]
        :type RuleIdList: list of str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RuleIdList = None
        self._RequestId = None

    @property
    def Data(self):
        r"""正常情况下为null
        :rtype: str
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RuleIdList(self):
        r"""["1231"]
        :rtype: list of str
        """
        return self._RuleIdList

    @RuleIdList.setter
    def RuleIdList(self, RuleIdList):
        self._RuleIdList = RuleIdList

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RuleIdList = params.get("RuleIdList")
        self._RequestId = params.get("RequestId")


class ModifyBotStatusRequest(AbstractModel):
    r"""ModifyBotStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Category: 类别
        :type Category: str
        :param _Status: 状态
        :type Status: str
        :param _Domain: 域名
        :type Domain: str
        :param _InstanceID: 实例id
        :type InstanceID: str
        :param _IsVersionFour: 是否是bot4.0版本
        :type IsVersionFour: bool
        :param _BotVersion: 传入Bot版本号，场景化版本为"4.1.0"
        :type BotVersion: str
        :param _DomainList: 批量开启BOT开关的域名列表
        :type DomainList: list of str
        """
        self._Category = None
        self._Status = None
        self._Domain = None
        self._InstanceID = None
        self._IsVersionFour = None
        self._BotVersion = None
        self._DomainList = None

    @property
    def Category(self):
        r"""类别
        :rtype: str
        """
        return self._Category

    @Category.setter
    def Category(self, Category):
        self._Category = Category

    @property
    def Status(self):
        r"""状态
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def InstanceID(self):
        r"""实例id
        :rtype: str
        """
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID

    @property
    def IsVersionFour(self):
        r"""是否是bot4.0版本
        :rtype: bool
        """
        return self._IsVersionFour

    @IsVersionFour.setter
    def IsVersionFour(self, IsVersionFour):
        self._IsVersionFour = IsVersionFour

    @property
    def BotVersion(self):
        r"""传入Bot版本号，场景化版本为"4.1.0"
        :rtype: str
        """
        return self._BotVersion

    @BotVersion.setter
    def BotVersion(self, BotVersion):
        self._BotVersion = BotVersion

    @property
    def DomainList(self):
        r"""批量开启BOT开关的域名列表
        :rtype: list of str
        """
        return self._DomainList

    @DomainList.setter
    def DomainList(self, DomainList):
        self._DomainList = DomainList


    def _deserialize(self, params):
        self._Category = params.get("Category")
        self._Status = params.get("Status")
        self._Domain = params.get("Domain")
        self._InstanceID = params.get("InstanceID")
        self._IsVersionFour = params.get("IsVersionFour")
        self._BotVersion = params.get("BotVersion")
        self._DomainList = params.get("DomainList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyBotStatusResponse(AbstractModel):
    r"""ModifyBotStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 正常情况为null
        :type Data: str
        :param _UnSupportedList: 未购买BOT的域名列表
        :type UnSupportedList: list of str
        :param _FailDomainList: 已购买但操作失败的域名列表
        :type FailDomainList: list of str
        :param _Count: 成功数目
        :type Count: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._UnSupportedList = None
        self._FailDomainList = None
        self._Count = None
        self._RequestId = None

    @property
    def Data(self):
        r"""正常情况为null
        :rtype: str
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def UnSupportedList(self):
        r"""未购买BOT的域名列表
        :rtype: list of str
        """
        return self._UnSupportedList

    @UnSupportedList.setter
    def UnSupportedList(self, UnSupportedList):
        self._UnSupportedList = UnSupportedList

    @property
    def FailDomainList(self):
        r"""已购买但操作失败的域名列表
        :rtype: list of str
        """
        return self._FailDomainList

    @FailDomainList.setter
    def FailDomainList(self, FailDomainList):
        self._FailDomainList = FailDomainList

    @property
    def Count(self):
        r"""成功数目
        :rtype: int
        """
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._UnSupportedList = params.get("UnSupportedList")
        self._FailDomainList = params.get("FailDomainList")
        self._Count = params.get("Count")
        self._RequestId = params.get("RequestId")


class ModifyCustomRuleRequest(AbstractModel):
    r"""ModifyCustomRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 编辑的域名
        :type Domain: str
        :param _RuleId: 编辑的规则ID
        :type RuleId: int
        :param _RuleName: 编辑的规则名称
        :type RuleName: str
        :param _RuleAction: 动作类型，1代表阻断，2代表人机识别，3代表观察，4代表重定向，5代表JS校验
        :type RuleAction: str
        :param _Strategies: 匹配条件数组
        :type Strategies: list of Strategy
        :param _Edition: WAF的版本，clb-waf代表负载均衡WAF、sparta-waf代表SaaS WAF，默认是sparta-waf。
        :type Edition: str
        :param _Redirect: 动作为重定向的时候重定向URL，默认为"/"
        :type Redirect: str
        :param _Bypass: 放行时是否继续执行其它检查逻辑，继续执行地域封禁防护：geoip、继续执行CC策略防护：cc、继续执行WEB应用防护：owasp、继续执行AI引擎防护：ai、继续执行信息防泄漏防护：antileakage。如果多个勾选那么以,串接。
默认是"geoip,cc,owasp,ai,antileakage"
        :type Bypass: str
        :param _SortId: 优先级，1~100的整数，数字越小，代表这条规则的执行优先级越高。
默认是100
        :type SortId: int
        :param _ExpireTime: 规则生效截止时间，0：永久生效，其它值为对应时间的时间戳。
默认是0
        :type ExpireTime: int
        :param _JobType: 规则执行的方式，TimedJob为定时执行，CronJob为周期执行
        :type JobType: str
        :param _JobDateTime: 定时任务配置
        :type JobDateTime: :class:`tencentcloud.waf.v20180125.models.JobDateTime`
        :param _Source: 规则来源，判断是不是小程序的
        :type Source: str
        :param _Status: 开关状态，小程序风控规则的时候传该值
        :type Status: int
        :param _PageId: 拦截页面id
        :type PageId: str
        :param _LogicalOp: 匹配条件的逻辑关系，支持and、or，分别表示多个逻辑匹配条件是与、或的关系
        :type LogicalOp: str
        :param _ActionRatio: 规则生效比例
        :type ActionRatio: int
        """
        self._Domain = None
        self._RuleId = None
        self._RuleName = None
        self._RuleAction = None
        self._Strategies = None
        self._Edition = None
        self._Redirect = None
        self._Bypass = None
        self._SortId = None
        self._ExpireTime = None
        self._JobType = None
        self._JobDateTime = None
        self._Source = None
        self._Status = None
        self._PageId = None
        self._LogicalOp = None
        self._ActionRatio = None

    @property
    def Domain(self):
        r"""编辑的域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def RuleId(self):
        r"""编辑的规则ID
        :rtype: int
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def RuleName(self):
        r"""编辑的规则名称
        :rtype: str
        """
        return self._RuleName

    @RuleName.setter
    def RuleName(self, RuleName):
        self._RuleName = RuleName

    @property
    def RuleAction(self):
        r"""动作类型，1代表阻断，2代表人机识别，3代表观察，4代表重定向，5代表JS校验
        :rtype: str
        """
        return self._RuleAction

    @RuleAction.setter
    def RuleAction(self, RuleAction):
        self._RuleAction = RuleAction

    @property
    def Strategies(self):
        r"""匹配条件数组
        :rtype: list of Strategy
        """
        return self._Strategies

    @Strategies.setter
    def Strategies(self, Strategies):
        self._Strategies = Strategies

    @property
    def Edition(self):
        r"""WAF的版本，clb-waf代表负载均衡WAF、sparta-waf代表SaaS WAF，默认是sparta-waf。
        :rtype: str
        """
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition

    @property
    def Redirect(self):
        r"""动作为重定向的时候重定向URL，默认为"/"
        :rtype: str
        """
        return self._Redirect

    @Redirect.setter
    def Redirect(self, Redirect):
        self._Redirect = Redirect

    @property
    def Bypass(self):
        warnings.warn("parameter `Bypass` is deprecated", DeprecationWarning) 

        r"""放行时是否继续执行其它检查逻辑，继续执行地域封禁防护：geoip、继续执行CC策略防护：cc、继续执行WEB应用防护：owasp、继续执行AI引擎防护：ai、继续执行信息防泄漏防护：antileakage。如果多个勾选那么以,串接。
默认是"geoip,cc,owasp,ai,antileakage"
        :rtype: str
        """
        return self._Bypass

    @Bypass.setter
    def Bypass(self, Bypass):
        warnings.warn("parameter `Bypass` is deprecated", DeprecationWarning) 

        self._Bypass = Bypass

    @property
    def SortId(self):
        r"""优先级，1~100的整数，数字越小，代表这条规则的执行优先级越高。
默认是100
        :rtype: int
        """
        return self._SortId

    @SortId.setter
    def SortId(self, SortId):
        self._SortId = SortId

    @property
    def ExpireTime(self):
        r"""规则生效截止时间，0：永久生效，其它值为对应时间的时间戳。
默认是0
        :rtype: int
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def JobType(self):
        r"""规则执行的方式，TimedJob为定时执行，CronJob为周期执行
        :rtype: str
        """
        return self._JobType

    @JobType.setter
    def JobType(self, JobType):
        self._JobType = JobType

    @property
    def JobDateTime(self):
        r"""定时任务配置
        :rtype: :class:`tencentcloud.waf.v20180125.models.JobDateTime`
        """
        return self._JobDateTime

    @JobDateTime.setter
    def JobDateTime(self, JobDateTime):
        self._JobDateTime = JobDateTime

    @property
    def Source(self):
        r"""规则来源，判断是不是小程序的
        :rtype: str
        """
        return self._Source

    @Source.setter
    def Source(self, Source):
        self._Source = Source

    @property
    def Status(self):
        r"""开关状态，小程序风控规则的时候传该值
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def PageId(self):
        r"""拦截页面id
        :rtype: str
        """
        return self._PageId

    @PageId.setter
    def PageId(self, PageId):
        self._PageId = PageId

    @property
    def LogicalOp(self):
        r"""匹配条件的逻辑关系，支持and、or，分别表示多个逻辑匹配条件是与、或的关系
        :rtype: str
        """
        return self._LogicalOp

    @LogicalOp.setter
    def LogicalOp(self, LogicalOp):
        self._LogicalOp = LogicalOp

    @property
    def ActionRatio(self):
        r"""规则生效比例
        :rtype: int
        """
        return self._ActionRatio

    @ActionRatio.setter
    def ActionRatio(self, ActionRatio):
        self._ActionRatio = ActionRatio


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._RuleId = params.get("RuleId")
        self._RuleName = params.get("RuleName")
        self._RuleAction = params.get("RuleAction")
        if params.get("Strategies") is not None:
            self._Strategies = []
            for item in params.get("Strategies"):
                obj = Strategy()
                obj._deserialize(item)
                self._Strategies.append(obj)
        self._Edition = params.get("Edition")
        self._Redirect = params.get("Redirect")
        self._Bypass = params.get("Bypass")
        self._SortId = params.get("SortId")
        self._ExpireTime = params.get("ExpireTime")
        self._JobType = params.get("JobType")
        if params.get("JobDateTime") is not None:
            self._JobDateTime = JobDateTime()
            self._JobDateTime._deserialize(params.get("JobDateTime"))
        self._Source = params.get("Source")
        self._Status = params.get("Status")
        self._PageId = params.get("PageId")
        self._LogicalOp = params.get("LogicalOp")
        self._ActionRatio = params.get("ActionRatio")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyCustomRuleResponse(AbstractModel):
    r"""ModifyCustomRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Success: 操作的状态码，如果所有的资源操作成功则返回的是成功的状态码，如果有资源操作失败则需要解析Message的内容来查看哪个资源失败
        :type Success: :class:`tencentcloud.waf.v20180125.models.ResponseCode`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Success = None
        self._RequestId = None

    @property
    def Success(self):
        r"""操作的状态码，如果所有的资源操作成功则返回的是成功的状态码，如果有资源操作失败则需要解析Message的内容来查看哪个资源失败
        :rtype: :class:`tencentcloud.waf.v20180125.models.ResponseCode`
        """
        return self._Success

    @Success.setter
    def Success(self, Success):
        self._Success = Success

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Success") is not None:
            self._Success = ResponseCode()
            self._Success._deserialize(params.get("Success"))
        self._RequestId = params.get("RequestId")


class ModifyCustomRuleStatusRequest(AbstractModel):
    r"""ModifyCustomRuleStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _RuleId: 规则ID
        :type RuleId: int
        :param _Status: 开关的状态，1是开启、0是关闭
        :type Status: int
        :param _Edition: WAF的版本，clb-waf代表负载均衡WAF、sparta-waf代表SaaS WAF，默认是sparta-waf。
        :type Edition: str
        :param _DomainRuleIdList: 规则id
        :type DomainRuleIdList: list of DomainRuleId
        """
        self._Domain = None
        self._RuleId = None
        self._Status = None
        self._Edition = None
        self._DomainRuleIdList = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def RuleId(self):
        r"""规则ID
        :rtype: int
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def Status(self):
        r"""开关的状态，1是开启、0是关闭
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Edition(self):
        r"""WAF的版本，clb-waf代表负载均衡WAF、sparta-waf代表SaaS WAF，默认是sparta-waf。
        :rtype: str
        """
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition

    @property
    def DomainRuleIdList(self):
        r"""规则id
        :rtype: list of DomainRuleId
        """
        return self._DomainRuleIdList

    @DomainRuleIdList.setter
    def DomainRuleIdList(self, DomainRuleIdList):
        self._DomainRuleIdList = DomainRuleIdList


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._RuleId = params.get("RuleId")
        self._Status = params.get("Status")
        self._Edition = params.get("Edition")
        if params.get("DomainRuleIdList") is not None:
            self._DomainRuleIdList = []
            for item in params.get("DomainRuleIdList"):
                obj = DomainRuleId()
                obj._deserialize(item)
                self._DomainRuleIdList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyCustomRuleStatusResponse(AbstractModel):
    r"""ModifyCustomRuleStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Success: 操作的状态码，如果所有的资源操作成功则返回的是成功的状态码，如果有资源操作失败则需要解析Message的内容来查看哪个资源失败
        :type Success: :class:`tencentcloud.waf.v20180125.models.ResponseCode`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Success = None
        self._RequestId = None

    @property
    def Success(self):
        r"""操作的状态码，如果所有的资源操作成功则返回的是成功的状态码，如果有资源操作失败则需要解析Message的内容来查看哪个资源失败
        :rtype: :class:`tencentcloud.waf.v20180125.models.ResponseCode`
        """
        return self._Success

    @Success.setter
    def Success(self, Success):
        self._Success = Success

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Success") is not None:
            self._Success = ResponseCode()
            self._Success._deserialize(params.get("Success"))
        self._RequestId = params.get("RequestId")


class ModifyCustomWhiteRuleRequest(AbstractModel):
    r"""ModifyCustomWhiteRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 编辑的域名
        :type Domain: str
        :param _RuleId: 编辑的规则ID
        :type RuleId: int
        :param _RuleName: 编辑的规则名称
        :type RuleName: str
        :param _Bypass: 放行时是否继续执行其它检查逻辑，继续执行地域封禁防护：geoip、继续执行CC策略防护：cc、继续执行WEB应用防护：owasp、继续执行AI引擎防护：ai、继续执行信息防泄漏防护：antileakage。如果勾选多个，则以“，”串接。
        :type Bypass: str
        :param _SortId: 优先级，1~100的整数，数字越小，代表这条规则的执行优先级越高。
        :type SortId: int
        :param _ExpireTime: 如果没有设置JobDateTime字段则用此字段，0表示永久生效，其它表示定时生效的截止时间（单位为秒）
        :type ExpireTime: int
        :param _Strategies: 匹配条件数组
        :type Strategies: list of Strategy
        :param _JobType: 规则执行的方式，TimedJob为定时执行，CronJob为周期执行
        :type JobType: str
        :param _JobDateTime: 定时任务配置
        :type JobDateTime: :class:`tencentcloud.waf.v20180125.models.JobDateTime`
        :param _LogicalOp: 匹配条件的逻辑关系，支持and、or，分别表示多个逻辑匹配条件是与、或的关系
        :type LogicalOp: str
        """
        self._Domain = None
        self._RuleId = None
        self._RuleName = None
        self._Bypass = None
        self._SortId = None
        self._ExpireTime = None
        self._Strategies = None
        self._JobType = None
        self._JobDateTime = None
        self._LogicalOp = None

    @property
    def Domain(self):
        r"""编辑的域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def RuleId(self):
        r"""编辑的规则ID
        :rtype: int
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def RuleName(self):
        r"""编辑的规则名称
        :rtype: str
        """
        return self._RuleName

    @RuleName.setter
    def RuleName(self, RuleName):
        self._RuleName = RuleName

    @property
    def Bypass(self):
        r"""放行时是否继续执行其它检查逻辑，继续执行地域封禁防护：geoip、继续执行CC策略防护：cc、继续执行WEB应用防护：owasp、继续执行AI引擎防护：ai、继续执行信息防泄漏防护：antileakage。如果勾选多个，则以“，”串接。
        :rtype: str
        """
        return self._Bypass

    @Bypass.setter
    def Bypass(self, Bypass):
        self._Bypass = Bypass

    @property
    def SortId(self):
        r"""优先级，1~100的整数，数字越小，代表这条规则的执行优先级越高。
        :rtype: int
        """
        return self._SortId

    @SortId.setter
    def SortId(self, SortId):
        self._SortId = SortId

    @property
    def ExpireTime(self):
        r"""如果没有设置JobDateTime字段则用此字段，0表示永久生效，其它表示定时生效的截止时间（单位为秒）
        :rtype: int
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def Strategies(self):
        r"""匹配条件数组
        :rtype: list of Strategy
        """
        return self._Strategies

    @Strategies.setter
    def Strategies(self, Strategies):
        self._Strategies = Strategies

    @property
    def JobType(self):
        r"""规则执行的方式，TimedJob为定时执行，CronJob为周期执行
        :rtype: str
        """
        return self._JobType

    @JobType.setter
    def JobType(self, JobType):
        self._JobType = JobType

    @property
    def JobDateTime(self):
        r"""定时任务配置
        :rtype: :class:`tencentcloud.waf.v20180125.models.JobDateTime`
        """
        return self._JobDateTime

    @JobDateTime.setter
    def JobDateTime(self, JobDateTime):
        self._JobDateTime = JobDateTime

    @property
    def LogicalOp(self):
        r"""匹配条件的逻辑关系，支持and、or，分别表示多个逻辑匹配条件是与、或的关系
        :rtype: str
        """
        return self._LogicalOp

    @LogicalOp.setter
    def LogicalOp(self, LogicalOp):
        self._LogicalOp = LogicalOp


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._RuleId = params.get("RuleId")
        self._RuleName = params.get("RuleName")
        self._Bypass = params.get("Bypass")
        self._SortId = params.get("SortId")
        self._ExpireTime = params.get("ExpireTime")
        if params.get("Strategies") is not None:
            self._Strategies = []
            for item in params.get("Strategies"):
                obj = Strategy()
                obj._deserialize(item)
                self._Strategies.append(obj)
        self._JobType = params.get("JobType")
        if params.get("JobDateTime") is not None:
            self._JobDateTime = JobDateTime()
            self._JobDateTime._deserialize(params.get("JobDateTime"))
        self._LogicalOp = params.get("LogicalOp")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyCustomWhiteRuleResponse(AbstractModel):
    r"""ModifyCustomWhiteRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Success: 操作的状态码，如果所有的资源操作成功则返回的是成功的状态码，如果有资源操作失败则需要解析Message的内容来查看哪个资源失败
        :type Success: :class:`tencentcloud.waf.v20180125.models.ResponseCode`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Success = None
        self._RequestId = None

    @property
    def Success(self):
        r"""操作的状态码，如果所有的资源操作成功则返回的是成功的状态码，如果有资源操作失败则需要解析Message的内容来查看哪个资源失败
        :rtype: :class:`tencentcloud.waf.v20180125.models.ResponseCode`
        """
        return self._Success

    @Success.setter
    def Success(self, Success):
        self._Success = Success

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Success") is not None:
            self._Success = ResponseCode()
            self._Success._deserialize(params.get("Success"))
        self._RequestId = params.get("RequestId")


class ModifyCustomWhiteRuleStatusRequest(AbstractModel):
    r"""ModifyCustomWhiteRuleStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _RuleId: 规则ID
        :type RuleId: int
        :param _Status: 开关的状态，1是开启、0是关闭
        :type Status: int
        """
        self._Domain = None
        self._RuleId = None
        self._Status = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def RuleId(self):
        r"""规则ID
        :rtype: int
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def Status(self):
        r"""开关的状态，1是开启、0是关闭
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._RuleId = params.get("RuleId")
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyCustomWhiteRuleStatusResponse(AbstractModel):
    r"""ModifyCustomWhiteRuleStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Success: 操作的状态码，如果所有的资源操作成功则返回的是成功的状态码，如果有资源操作失败则需要解析Message的内容来查看哪个资源失败
        :type Success: :class:`tencentcloud.waf.v20180125.models.ResponseCode`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Success = None
        self._RequestId = None

    @property
    def Success(self):
        r"""操作的状态码，如果所有的资源操作成功则返回的是成功的状态码，如果有资源操作失败则需要解析Message的内容来查看哪个资源失败
        :rtype: :class:`tencentcloud.waf.v20180125.models.ResponseCode`
        """
        return self._Success

    @Success.setter
    def Success(self, Success):
        self._Success = Success

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Success") is not None:
            self._Success = ResponseCode()
            self._Success._deserialize(params.get("Success"))
        self._RequestId = params.get("RequestId")


class ModifyDomainIpv6StatusRequest(AbstractModel):
    r"""ModifyDomainIpv6Status请求参数结构体

    """

    def __init__(self):
        r"""
        :param _InstanceId: 需要修改的域名所属的实例ID
        :type InstanceId: str
        :param _Domain: 需要修改的域名
        :type Domain: str
        :param _DomainId: 需要修改的域名ID
        :type DomainId: str
        :param _Status: 修改域名的Ipv6开关为Status （1:开启 2:关闭）
        :type Status: int
        """
        self._InstanceId = None
        self._Domain = None
        self._DomainId = None
        self._Status = None

    @property
    def InstanceId(self):
        r"""需要修改的域名所属的实例ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Domain(self):
        r"""需要修改的域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def DomainId(self):
        r"""需要修改的域名ID
        :rtype: str
        """
        return self._DomainId

    @DomainId.setter
    def DomainId(self, DomainId):
        self._DomainId = DomainId

    @property
    def Status(self):
        r"""修改域名的Ipv6开关为Status （1:开启 2:关闭）
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Domain = params.get("Domain")
        self._DomainId = params.get("DomainId")
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyDomainIpv6StatusResponse(AbstractModel):
    r"""ModifyDomainIpv6Status返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Ipv6Status: 返回的状态 （0: 操作失败 1:操作成功 2:企业版以上不支持 3:企业版以下不支持 ）
        :type Ipv6Status: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Ipv6Status = None
        self._RequestId = None

    @property
    def Ipv6Status(self):
        r"""返回的状态 （0: 操作失败 1:操作成功 2:企业版以上不支持 3:企业版以下不支持 ）
        :rtype: int
        """
        return self._Ipv6Status

    @Ipv6Status.setter
    def Ipv6Status(self, Ipv6Status):
        self._Ipv6Status = Ipv6Status

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Ipv6Status = params.get("Ipv6Status")
        self._RequestId = params.get("RequestId")


class ModifyDomainPostActionRequest(AbstractModel):
    r"""ModifyDomainPostAction请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _PostCLSAction: 0-关闭投递，1-开启投递
        :type PostCLSAction: int
        :param _PostCKafkaAction: 0-关闭投递，1-开启投递
        :type PostCKafkaAction: int
        """
        self._Domain = None
        self._PostCLSAction = None
        self._PostCKafkaAction = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def PostCLSAction(self):
        r"""0-关闭投递，1-开启投递
        :rtype: int
        """
        return self._PostCLSAction

    @PostCLSAction.setter
    def PostCLSAction(self, PostCLSAction):
        self._PostCLSAction = PostCLSAction

    @property
    def PostCKafkaAction(self):
        r"""0-关闭投递，1-开启投递
        :rtype: int
        """
        return self._PostCKafkaAction

    @PostCKafkaAction.setter
    def PostCKafkaAction(self, PostCKafkaAction):
        self._PostCKafkaAction = PostCKafkaAction


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._PostCLSAction = params.get("PostCLSAction")
        self._PostCKafkaAction = params.get("PostCKafkaAction")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyDomainPostActionResponse(AbstractModel):
    r"""ModifyDomainPostAction返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyDomainWhiteRuleRequest(AbstractModel):
    r"""ModifyDomainWhiteRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 需要更改的规则的域名
        :type Domain: str
        :param _Id: 白名单id
        :type Id: int
        :param _Rules: 规则的id列表
        :type Rules: list of int non-negative
        :param _Url: 规则匹配路径
        :type Url: str
        :param _Function: 规则匹配方法
        :type Function: str
        :param _Status: 规则的开关状态，0表示关闭开关，1表示打开开关
        :type Status: int
        """
        self._Domain = None
        self._Id = None
        self._Rules = None
        self._Url = None
        self._Function = None
        self._Status = None

    @property
    def Domain(self):
        r"""需要更改的规则的域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Id(self):
        r"""白名单id
        :rtype: int
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Rules(self):
        r"""规则的id列表
        :rtype: list of int non-negative
        """
        return self._Rules

    @Rules.setter
    def Rules(self, Rules):
        self._Rules = Rules

    @property
    def Url(self):
        r"""规则匹配路径
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def Function(self):
        r"""规则匹配方法
        :rtype: str
        """
        return self._Function

    @Function.setter
    def Function(self, Function):
        self._Function = Function

    @property
    def Status(self):
        r"""规则的开关状态，0表示关闭开关，1表示打开开关
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Id = params.get("Id")
        self._Rules = params.get("Rules")
        self._Url = params.get("Url")
        self._Function = params.get("Function")
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyDomainWhiteRuleResponse(AbstractModel):
    r"""ModifyDomainWhiteRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyDomainsCLSStatusRequest(AbstractModel):
    r"""ModifyDomainsCLSStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domains: 需要修改的域名列表
        :type Domains: list of DomainURI
        :param _Status: 修改域名的访问日志开关为Status
        :type Status: int
        """
        self._Domains = None
        self._Status = None

    @property
    def Domains(self):
        r"""需要修改的域名列表
        :rtype: list of DomainURI
        """
        return self._Domains

    @Domains.setter
    def Domains(self, Domains):
        self._Domains = Domains

    @property
    def Status(self):
        r"""修改域名的访问日志开关为Status
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        if params.get("Domains") is not None:
            self._Domains = []
            for item in params.get("Domains"):
                obj = DomainURI()
                obj._deserialize(item)
                self._Domains.append(obj)
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyDomainsCLSStatusResponse(AbstractModel):
    r"""ModifyDomainsCLSStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyGenerateDealsRequest(AbstractModel):
    r"""ModifyGenerateDeals请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Goods: 计费下单入参
        :type Goods: list of Goods
        """
        self._Goods = None

    @property
    def Goods(self):
        r"""计费下单入参
        :rtype: list of Goods
        """
        return self._Goods

    @Goods.setter
    def Goods(self, Goods):
        self._Goods = Goods


    def _deserialize(self, params):
        if params.get("Goods") is not None:
            self._Goods = []
            for item in params.get("Goods"):
                obj = Goods()
                obj._deserialize(item)
                self._Goods.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyGenerateDealsResponse(AbstractModel):
    r"""ModifyGenerateDeals返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 计费下单响应结构体
        :type Data: :class:`tencentcloud.waf.v20180125.models.DealData`
        :param _Status: 1:成功，0:失败
        :type Status: int
        :param _ReturnMessage: 返回message
        :type ReturnMessage: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._Status = None
        self._ReturnMessage = None
        self._RequestId = None

    @property
    def Data(self):
        r"""计费下单响应结构体
        :rtype: :class:`tencentcloud.waf.v20180125.models.DealData`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def Status(self):
        r"""1:成功，0:失败
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ReturnMessage(self):
        r"""返回message
        :rtype: str
        """
        return self._ReturnMessage

    @ReturnMessage.setter
    def ReturnMessage(self, ReturnMessage):
        self._ReturnMessage = ReturnMessage

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DealData()
            self._Data._deserialize(params.get("Data"))
        self._Status = params.get("Status")
        self._ReturnMessage = params.get("ReturnMessage")
        self._RequestId = params.get("RequestId")


class ModifyHostFlowModeRequest(AbstractModel):
    r"""ModifyHostFlowMode请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _DomainId: 域名ID
        :type DomainId: str
        :param _FlowMode: WAF流量模式。
0：镜像模式（默认）
1：清洗模式
        :type FlowMode: int
        :param _InstanceID: 实例ID
        :type InstanceID: str
        """
        self._Domain = None
        self._DomainId = None
        self._FlowMode = None
        self._InstanceID = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def DomainId(self):
        r"""域名ID
        :rtype: str
        """
        return self._DomainId

    @DomainId.setter
    def DomainId(self, DomainId):
        self._DomainId = DomainId

    @property
    def FlowMode(self):
        r"""WAF流量模式。
0：镜像模式（默认）
1：清洗模式
        :rtype: int
        """
        return self._FlowMode

    @FlowMode.setter
    def FlowMode(self, FlowMode):
        self._FlowMode = FlowMode

    @property
    def InstanceID(self):
        r"""实例ID
        :rtype: str
        """
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._DomainId = params.get("DomainId")
        self._FlowMode = params.get("FlowMode")
        self._InstanceID = params.get("InstanceID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyHostFlowModeResponse(AbstractModel):
    r"""ModifyHostFlowMode返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Success: 成功的状态码
        :type Success: :class:`tencentcloud.waf.v20180125.models.ResponseCode`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Success = None
        self._RequestId = None

    @property
    def Success(self):
        r"""成功的状态码
        :rtype: :class:`tencentcloud.waf.v20180125.models.ResponseCode`
        """
        return self._Success

    @Success.setter
    def Success(self, Success):
        self._Success = Success

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Success") is not None:
            self._Success = ResponseCode()
            self._Success._deserialize(params.get("Success"))
        self._RequestId = params.get("RequestId")


class ModifyHostModeRequest(AbstractModel):
    r"""ModifyHostMode请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _DomainId: 域名ID
        :type DomainId: str
        :param _Mode: 防护状态：
10：规则观察&&AI关闭模式，11：规则观察&&AI观察模式，12：规则观察&&AI拦截模式
20：规则拦截&&AI关闭模式，21：规则拦截&&AI观察模式，22：规则拦截&&AI拦截模式
        :type Mode: int
        :param _Type: 0:修改防护模式，1:修改AI
        :type Type: int
        :param _InstanceID: 实例ID
        :type InstanceID: str
        :param _Edition: 实例类型
        :type Edition: str
        """
        self._Domain = None
        self._DomainId = None
        self._Mode = None
        self._Type = None
        self._InstanceID = None
        self._Edition = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def DomainId(self):
        r"""域名ID
        :rtype: str
        """
        return self._DomainId

    @DomainId.setter
    def DomainId(self, DomainId):
        self._DomainId = DomainId

    @property
    def Mode(self):
        r"""防护状态：
10：规则观察&&AI关闭模式，11：规则观察&&AI观察模式，12：规则观察&&AI拦截模式
20：规则拦截&&AI关闭模式，21：规则拦截&&AI观察模式，22：规则拦截&&AI拦截模式
        :rtype: int
        """
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode

    @property
    def Type(self):
        r"""0:修改防护模式，1:修改AI
        :rtype: int
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def InstanceID(self):
        r"""实例ID
        :rtype: str
        """
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID

    @property
    def Edition(self):
        r"""实例类型
        :rtype: str
        """
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._DomainId = params.get("DomainId")
        self._Mode = params.get("Mode")
        self._Type = params.get("Type")
        self._InstanceID = params.get("InstanceID")
        self._Edition = params.get("Edition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyHostModeResponse(AbstractModel):
    r"""ModifyHostMode返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Success: 操作的状态码，如果所有的资源操作成功则返回的是成功的状态码，如果有资源操作失败则需要解析Message的内容来查看哪个资源失败
        :type Success: :class:`tencentcloud.waf.v20180125.models.ResponseCode`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Success = None
        self._RequestId = None

    @property
    def Success(self):
        r"""操作的状态码，如果所有的资源操作成功则返回的是成功的状态码，如果有资源操作失败则需要解析Message的内容来查看哪个资源失败
        :rtype: :class:`tencentcloud.waf.v20180125.models.ResponseCode`
        """
        return self._Success

    @Success.setter
    def Success(self, Success):
        self._Success = Success

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Success") is not None:
            self._Success = ResponseCode()
            self._Success._deserialize(params.get("Success"))
        self._RequestId = params.get("RequestId")


class ModifyHostRequest(AbstractModel):
    r"""ModifyHost请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Host: 编辑的域名配置信息
        :type Host: :class:`tencentcloud.waf.v20180125.models.HostRecord`
        :param _InstanceID: 实例唯一ID
        :type InstanceID: str
        """
        self._Host = None
        self._InstanceID = None

    @property
    def Host(self):
        r"""编辑的域名配置信息
        :rtype: :class:`tencentcloud.waf.v20180125.models.HostRecord`
        """
        return self._Host

    @Host.setter
    def Host(self, Host):
        self._Host = Host

    @property
    def InstanceID(self):
        r"""实例唯一ID
        :rtype: str
        """
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID


    def _deserialize(self, params):
        if params.get("Host") is not None:
            self._Host = HostRecord()
            self._Host._deserialize(params.get("Host"))
        self._InstanceID = params.get("InstanceID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyHostResponse(AbstractModel):
    r"""ModifyHost返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DomainId: 编辑的域名ID
        :type DomainId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DomainId = None
        self._RequestId = None

    @property
    def DomainId(self):
        r"""编辑的域名ID
        :rtype: str
        """
        return self._DomainId

    @DomainId.setter
    def DomainId(self, DomainId):
        self._DomainId = DomainId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DomainId = params.get("DomainId")
        self._RequestId = params.get("RequestId")


class ModifyHostStatusRequest(AbstractModel):
    r"""ModifyHostStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _HostsStatus: 域名状态列表
        :type HostsStatus: list of HostStatus
        """
        self._HostsStatus = None

    @property
    def HostsStatus(self):
        r"""域名状态列表
        :rtype: list of HostStatus
        """
        return self._HostsStatus

    @HostsStatus.setter
    def HostsStatus(self, HostsStatus):
        self._HostsStatus = HostsStatus


    def _deserialize(self, params):
        if params.get("HostsStatus") is not None:
            self._HostsStatus = []
            for item in params.get("HostsStatus"):
                obj = HostStatus()
                obj._deserialize(item)
                self._HostsStatus.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyHostStatusResponse(AbstractModel):
    r"""ModifyHostStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Success: 成功的状态码，需要JSON解码后再使用，返回的格式是{"域名":"状态"}，成功的状态码为Success，其它的为失败的状态码（yunapi定义的错误码）
        :type Success: :class:`tencentcloud.waf.v20180125.models.ResponseCode`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Success = None
        self._RequestId = None

    @property
    def Success(self):
        r"""成功的状态码，需要JSON解码后再使用，返回的格式是{"域名":"状态"}，成功的状态码为Success，其它的为失败的状态码（yunapi定义的错误码）
        :rtype: :class:`tencentcloud.waf.v20180125.models.ResponseCode`
        """
        return self._Success

    @Success.setter
    def Success(self, Success):
        self._Success = Success

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Success") is not None:
            self._Success = ResponseCode()
            self._Success._deserialize(params.get("Success"))
        self._RequestId = params.get("RequestId")


class ModifyInstanceAttackLogPostRequest(AbstractModel):
    r"""ModifyInstanceAttackLogPost请求参数结构体

    """

    def __init__(self):
        r"""
        :param _InstanceId: 实例ID
        :type InstanceId: str
        :param _AttackLogPost: 攻击日志投递开关
        :type AttackLogPost: int
        """
        self._InstanceId = None
        self._AttackLogPost = None

    @property
    def InstanceId(self):
        r"""实例ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def AttackLogPost(self):
        r"""攻击日志投递开关
        :rtype: int
        """
        return self._AttackLogPost

    @AttackLogPost.setter
    def AttackLogPost(self, AttackLogPost):
        self._AttackLogPost = AttackLogPost


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._AttackLogPost = params.get("AttackLogPost")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyInstanceAttackLogPostResponse(AbstractModel):
    r"""ModifyInstanceAttackLogPost返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyInstanceElasticModeRequest(AbstractModel):
    r"""ModifyInstanceElasticMode请求参数结构体

    """

    def __init__(self):
        r"""
        :param _InstanceId: 实例ID
        :type InstanceId: str
        :param _Mode: 弹性计费开关
        :type Mode: int
        """
        self._InstanceId = None
        self._Mode = None

    @property
    def InstanceId(self):
        r"""实例ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Mode(self):
        r"""弹性计费开关
        :rtype: int
        """
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Mode = params.get("Mode")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyInstanceElasticModeResponse(AbstractModel):
    r"""ModifyInstanceElasticMode返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyInstanceNameRequest(AbstractModel):
    r"""ModifyInstanceName请求参数结构体

    """

    def __init__(self):
        r"""
        :param _InstanceName: 新名称
        :type InstanceName: str
        :param _InstanceID: 实例id
        :type InstanceID: str
        :param _Edition: 实例版本，支持clb-waf、sparta-waf
        :type Edition: str
        """
        self._InstanceName = None
        self._InstanceID = None
        self._Edition = None

    @property
    def InstanceName(self):
        r"""新名称
        :rtype: str
        """
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def InstanceID(self):
        r"""实例id
        :rtype: str
        """
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID

    @property
    def Edition(self):
        r"""实例版本，支持clb-waf、sparta-waf
        :rtype: str
        """
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition


    def _deserialize(self, params):
        self._InstanceName = params.get("InstanceName")
        self._InstanceID = params.get("InstanceID")
        self._Edition = params.get("Edition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyInstanceNameResponse(AbstractModel):
    r"""ModifyInstanceName返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ModifyCode: 修改状态：0为成功
        :type ModifyCode: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ModifyCode = None
        self._RequestId = None

    @property
    def ModifyCode(self):
        r"""修改状态：0为成功
        :rtype: int
        """
        return self._ModifyCode

    @ModifyCode.setter
    def ModifyCode(self, ModifyCode):
        self._ModifyCode = ModifyCode

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ModifyCode = params.get("ModifyCode")
        self._RequestId = params.get("RequestId")


class ModifyInstanceQpsLimitRequest(AbstractModel):
    r"""ModifyInstanceQpsLimit请求参数结构体

    """

    def __init__(self):
        r"""
        :param _InstanceId: 套餐实例id
        :type InstanceId: str
        :param _QpsLimit: qps上限
        :type QpsLimit: int
        """
        self._InstanceId = None
        self._QpsLimit = None

    @property
    def InstanceId(self):
        r"""套餐实例id
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def QpsLimit(self):
        r"""qps上限
        :rtype: int
        """
        return self._QpsLimit

    @QpsLimit.setter
    def QpsLimit(self, QpsLimit):
        self._QpsLimit = QpsLimit


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._QpsLimit = params.get("QpsLimit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyInstanceQpsLimitResponse(AbstractModel):
    r"""ModifyInstanceQpsLimit返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyInstanceRenewFlagRequest(AbstractModel):
    r"""ModifyInstanceRenewFlag请求参数结构体

    """

    def __init__(self):
        r"""
        :param _InstanceId: 实例ID
        :type InstanceId: str
        :param _RenewFlag: 续费开关
        :type RenewFlag: int
        """
        self._InstanceId = None
        self._RenewFlag = None

    @property
    def InstanceId(self):
        r"""实例ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def RenewFlag(self):
        r"""续费开关
        :rtype: int
        """
        return self._RenewFlag

    @RenewFlag.setter
    def RenewFlag(self, RenewFlag):
        self._RenewFlag = RenewFlag


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._RenewFlag = params.get("RenewFlag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyInstanceRenewFlagResponse(AbstractModel):
    r"""ModifyInstanceRenewFlag返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyIpAccessControlRequest(AbstractModel):
    r"""ModifyIpAccessControl请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 具体域名如：test.qcloudwaf.com
全局域名为：global
        :type Domain: str
        :param _IpList: ip参数列表
        :type IpList: list of str
        :param _ActionType: 42为黑名单，40为白名单
        :type ActionType: int
        :param _RuleId: 规则ID
        :type RuleId: int
        :param _ValidTS: valid_ts为有效日期，值为秒级时间戳（（如1680570420代表2023-04-04 09:07:00））
        :type ValidTS: int
        :param _InstanceId: 实例Id
        :type InstanceId: str
        :param _Edition: WAF实例类型，sparta-waf表示SAAS型WAF，clb-waf表示负载均衡型WAF
        :type Edition: str
        :param _SourceType: 是否为批量防护IP黑白名单，当为批量防护IP黑白名单时，取值为batch，否则为空
        :type SourceType: str
        :param _Note: 备注
        :type Note: str
        :param _JobType: 规则执行的方式，TimedJob为定时执行，CronJob为周期执行
        :type JobType: str
        :param _JobDateTime: 定时配置详情
        :type JobDateTime: :class:`tencentcloud.waf.v20180125.models.JobDateTime`
        """
        self._Domain = None
        self._IpList = None
        self._ActionType = None
        self._RuleId = None
        self._ValidTS = None
        self._InstanceId = None
        self._Edition = None
        self._SourceType = None
        self._Note = None
        self._JobType = None
        self._JobDateTime = None

    @property
    def Domain(self):
        r"""具体域名如：test.qcloudwaf.com
全局域名为：global
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def IpList(self):
        r"""ip参数列表
        :rtype: list of str
        """
        return self._IpList

    @IpList.setter
    def IpList(self, IpList):
        self._IpList = IpList

    @property
    def ActionType(self):
        r"""42为黑名单，40为白名单
        :rtype: int
        """
        return self._ActionType

    @ActionType.setter
    def ActionType(self, ActionType):
        self._ActionType = ActionType

    @property
    def RuleId(self):
        r"""规则ID
        :rtype: int
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def ValidTS(self):
        warnings.warn("parameter `ValidTS` is deprecated", DeprecationWarning) 

        r"""valid_ts为有效日期，值为秒级时间戳（（如1680570420代表2023-04-04 09:07:00））
        :rtype: int
        """
        return self._ValidTS

    @ValidTS.setter
    def ValidTS(self, ValidTS):
        warnings.warn("parameter `ValidTS` is deprecated", DeprecationWarning) 

        self._ValidTS = ValidTS

    @property
    def InstanceId(self):
        r"""实例Id
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Edition(self):
        r"""WAF实例类型，sparta-waf表示SAAS型WAF，clb-waf表示负载均衡型WAF
        :rtype: str
        """
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition

    @property
    def SourceType(self):
        r"""是否为批量防护IP黑白名单，当为批量防护IP黑白名单时，取值为batch，否则为空
        :rtype: str
        """
        return self._SourceType

    @SourceType.setter
    def SourceType(self, SourceType):
        self._SourceType = SourceType

    @property
    def Note(self):
        r"""备注
        :rtype: str
        """
        return self._Note

    @Note.setter
    def Note(self, Note):
        self._Note = Note

    @property
    def JobType(self):
        r"""规则执行的方式，TimedJob为定时执行，CronJob为周期执行
        :rtype: str
        """
        return self._JobType

    @JobType.setter
    def JobType(self, JobType):
        self._JobType = JobType

    @property
    def JobDateTime(self):
        r"""定时配置详情
        :rtype: :class:`tencentcloud.waf.v20180125.models.JobDateTime`
        """
        return self._JobDateTime

    @JobDateTime.setter
    def JobDateTime(self, JobDateTime):
        self._JobDateTime = JobDateTime


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._IpList = params.get("IpList")
        self._ActionType = params.get("ActionType")
        self._RuleId = params.get("RuleId")
        self._ValidTS = params.get("ValidTS")
        self._InstanceId = params.get("InstanceId")
        self._Edition = params.get("Edition")
        self._SourceType = params.get("SourceType")
        self._Note = params.get("Note")
        self._JobType = params.get("JobType")
        if params.get("JobDateTime") is not None:
            self._JobDateTime = JobDateTime()
            self._JobDateTime._deserialize(params.get("JobDateTime"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyIpAccessControlResponse(AbstractModel):
    r"""ModifyIpAccessControl返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyModuleStatusRequest(AbstractModel):
    r"""ModifyModuleStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 需要设置的domain
        :type Domain: str
        :param _WebSecurity: Web 安全模块开关，0或1
        :type WebSecurity: int
        :param _AccessControl: 访问控制模块开关，0或者1
        :type AccessControl: int
        :param _CcProtection: CC模块开关，0或者1
        :type CcProtection: int
        :param _ApiProtection: API安全模块开关，0或者1
        :type ApiProtection: int
        :param _AntiTamper: 防篡改模块开关，0或者1
        :type AntiTamper: int
        :param _AntiLeakage: 防泄漏模块开关，0或者1
        :type AntiLeakage: int
        :param _RateLimit: 限流模块开关，0或1
        :type RateLimit: int
        :param _GzipAnalysis: gzip 开关
        :type GzipAnalysis: int
        """
        self._Domain = None
        self._WebSecurity = None
        self._AccessControl = None
        self._CcProtection = None
        self._ApiProtection = None
        self._AntiTamper = None
        self._AntiLeakage = None
        self._RateLimit = None
        self._GzipAnalysis = None

    @property
    def Domain(self):
        r"""需要设置的domain
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def WebSecurity(self):
        r"""Web 安全模块开关，0或1
        :rtype: int
        """
        return self._WebSecurity

    @WebSecurity.setter
    def WebSecurity(self, WebSecurity):
        self._WebSecurity = WebSecurity

    @property
    def AccessControl(self):
        r"""访问控制模块开关，0或者1
        :rtype: int
        """
        return self._AccessControl

    @AccessControl.setter
    def AccessControl(self, AccessControl):
        self._AccessControl = AccessControl

    @property
    def CcProtection(self):
        r"""CC模块开关，0或者1
        :rtype: int
        """
        return self._CcProtection

    @CcProtection.setter
    def CcProtection(self, CcProtection):
        self._CcProtection = CcProtection

    @property
    def ApiProtection(self):
        r"""API安全模块开关，0或者1
        :rtype: int
        """
        return self._ApiProtection

    @ApiProtection.setter
    def ApiProtection(self, ApiProtection):
        self._ApiProtection = ApiProtection

    @property
    def AntiTamper(self):
        r"""防篡改模块开关，0或者1
        :rtype: int
        """
        return self._AntiTamper

    @AntiTamper.setter
    def AntiTamper(self, AntiTamper):
        self._AntiTamper = AntiTamper

    @property
    def AntiLeakage(self):
        r"""防泄漏模块开关，0或者1
        :rtype: int
        """
        return self._AntiLeakage

    @AntiLeakage.setter
    def AntiLeakage(self, AntiLeakage):
        self._AntiLeakage = AntiLeakage

    @property
    def RateLimit(self):
        r"""限流模块开关，0或1
        :rtype: int
        """
        return self._RateLimit

    @RateLimit.setter
    def RateLimit(self, RateLimit):
        self._RateLimit = RateLimit

    @property
    def GzipAnalysis(self):
        r"""gzip 开关
        :rtype: int
        """
        return self._GzipAnalysis

    @GzipAnalysis.setter
    def GzipAnalysis(self, GzipAnalysis):
        self._GzipAnalysis = GzipAnalysis


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._WebSecurity = params.get("WebSecurity")
        self._AccessControl = params.get("AccessControl")
        self._CcProtection = params.get("CcProtection")
        self._ApiProtection = params.get("ApiProtection")
        self._AntiTamper = params.get("AntiTamper")
        self._AntiLeakage = params.get("AntiLeakage")
        self._RateLimit = params.get("RateLimit")
        self._GzipAnalysis = params.get("GzipAnalysis")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyModuleStatusResponse(AbstractModel):
    r"""ModifyModuleStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyObjectRequest(AbstractModel):
    r"""ModifyObject请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ObjectId: 修改对象标识
        :type ObjectId: str
        :param _OpType: 改动作类型:Status修改开关，InstanceId绑定实例, Proxy设置代理状态
        :type OpType: str
        :param _Status: 新的Waf开关状态，如果和已有状态相同认为修改成功
        :type Status: int
        :param _InstanceId: 新的实例ID，如果和已绑定的实例相同认为修改成功
        :type InstanceId: str
        :param _Proxy: 是否开启代理，0:不开启,1:以XFF的第一个IP地址作为客户端IP,2:以remote_addr作为客户端IP,3:从指定的头部字段获取客户端IP，字段通过IpHeaders字段给出(OpType为Status或Proxy时，该值有效)
        :type Proxy: int
        :param _IpHeaders: IsCdn=3时，需要填此参数，表示自定义header(OpType为Status或Proxy时，该值有效)
        :type IpHeaders: list of str
        """
        self._ObjectId = None
        self._OpType = None
        self._Status = None
        self._InstanceId = None
        self._Proxy = None
        self._IpHeaders = None

    @property
    def ObjectId(self):
        r"""修改对象标识
        :rtype: str
        """
        return self._ObjectId

    @ObjectId.setter
    def ObjectId(self, ObjectId):
        self._ObjectId = ObjectId

    @property
    def OpType(self):
        r"""改动作类型:Status修改开关，InstanceId绑定实例, Proxy设置代理状态
        :rtype: str
        """
        return self._OpType

    @OpType.setter
    def OpType(self, OpType):
        self._OpType = OpType

    @property
    def Status(self):
        r"""新的Waf开关状态，如果和已有状态相同认为修改成功
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def InstanceId(self):
        r"""新的实例ID，如果和已绑定的实例相同认为修改成功
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Proxy(self):
        r"""是否开启代理，0:不开启,1:以XFF的第一个IP地址作为客户端IP,2:以remote_addr作为客户端IP,3:从指定的头部字段获取客户端IP，字段通过IpHeaders字段给出(OpType为Status或Proxy时，该值有效)
        :rtype: int
        """
        return self._Proxy

    @Proxy.setter
    def Proxy(self, Proxy):
        self._Proxy = Proxy

    @property
    def IpHeaders(self):
        r"""IsCdn=3时，需要填此参数，表示自定义header(OpType为Status或Proxy时，该值有效)
        :rtype: list of str
        """
        return self._IpHeaders

    @IpHeaders.setter
    def IpHeaders(self, IpHeaders):
        self._IpHeaders = IpHeaders


    def _deserialize(self, params):
        self._ObjectId = params.get("ObjectId")
        self._OpType = params.get("OpType")
        self._Status = params.get("Status")
        self._InstanceId = params.get("InstanceId")
        self._Proxy = params.get("Proxy")
        self._IpHeaders = params.get("IpHeaders")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyObjectResponse(AbstractModel):
    r"""ModifyObject返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyOwaspRuleStatusRequest(AbstractModel):
    r"""ModifyOwaspRuleStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _RuleStatus: 规则开关，0：关闭、1：开启、2：只观察
        :type RuleStatus: int
        :param _SelectAll: 是否全选
        :type SelectAll: bool
        :param _RuleIDs: 规则ID列表
        :type RuleIDs: list of str
        :param _TypeId: 如果反转需要传入类型
        :type TypeId: int
        :param _Reason: 修改原因 0：无(兼容记录为空) 1：业务自身特性误报避免 2：规则误报上报 3：核心业务规则灰度 4：其它
        :type Reason: int
        """
        self._Domain = None
        self._RuleStatus = None
        self._SelectAll = None
        self._RuleIDs = None
        self._TypeId = None
        self._Reason = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def RuleStatus(self):
        r"""规则开关，0：关闭、1：开启、2：只观察
        :rtype: int
        """
        return self._RuleStatus

    @RuleStatus.setter
    def RuleStatus(self, RuleStatus):
        self._RuleStatus = RuleStatus

    @property
    def SelectAll(self):
        r"""是否全选
        :rtype: bool
        """
        return self._SelectAll

    @SelectAll.setter
    def SelectAll(self, SelectAll):
        self._SelectAll = SelectAll

    @property
    def RuleIDs(self):
        r"""规则ID列表
        :rtype: list of str
        """
        return self._RuleIDs

    @RuleIDs.setter
    def RuleIDs(self, RuleIDs):
        self._RuleIDs = RuleIDs

    @property
    def TypeId(self):
        r"""如果反转需要传入类型
        :rtype: int
        """
        return self._TypeId

    @TypeId.setter
    def TypeId(self, TypeId):
        self._TypeId = TypeId

    @property
    def Reason(self):
        r"""修改原因 0：无(兼容记录为空) 1：业务自身特性误报避免 2：规则误报上报 3：核心业务规则灰度 4：其它
        :rtype: int
        """
        return self._Reason

    @Reason.setter
    def Reason(self, Reason):
        self._Reason = Reason


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._RuleStatus = params.get("RuleStatus")
        self._SelectAll = params.get("SelectAll")
        self._RuleIDs = params.get("RuleIDs")
        self._TypeId = params.get("TypeId")
        self._Reason = params.get("Reason")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyOwaspRuleStatusResponse(AbstractModel):
    r"""ModifyOwaspRuleStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyOwaspRuleTypeActionRequest(AbstractModel):
    r"""ModifyOwaspRuleTypeAction请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _TypeIDs: 规则类型ID列表
        :type TypeIDs: list of str
        :param _RuleTypeAction: 规则类型的防护模式，0：观察、1：拦截
        :type RuleTypeAction: int
        """
        self._Domain = None
        self._TypeIDs = None
        self._RuleTypeAction = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def TypeIDs(self):
        r"""规则类型ID列表
        :rtype: list of str
        """
        return self._TypeIDs

    @TypeIDs.setter
    def TypeIDs(self, TypeIDs):
        self._TypeIDs = TypeIDs

    @property
    def RuleTypeAction(self):
        r"""规则类型的防护模式，0：观察、1：拦截
        :rtype: int
        """
        return self._RuleTypeAction

    @RuleTypeAction.setter
    def RuleTypeAction(self, RuleTypeAction):
        self._RuleTypeAction = RuleTypeAction


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._TypeIDs = params.get("TypeIDs")
        self._RuleTypeAction = params.get("RuleTypeAction")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyOwaspRuleTypeActionResponse(AbstractModel):
    r"""ModifyOwaspRuleTypeAction返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyOwaspRuleTypeLevelRequest(AbstractModel):
    r"""ModifyOwaspRuleTypeLevel请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _TypeIDs: 规则类型ID列表
        :type TypeIDs: list of str
        :param _RuleTypeLevel: 规则的防护等级，100：宽松、200：正常、300：严格、400：超严格
        :type RuleTypeLevel: int
        """
        self._Domain = None
        self._TypeIDs = None
        self._RuleTypeLevel = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def TypeIDs(self):
        r"""规则类型ID列表
        :rtype: list of str
        """
        return self._TypeIDs

    @TypeIDs.setter
    def TypeIDs(self, TypeIDs):
        self._TypeIDs = TypeIDs

    @property
    def RuleTypeLevel(self):
        r"""规则的防护等级，100：宽松、200：正常、300：严格、400：超严格
        :rtype: int
        """
        return self._RuleTypeLevel

    @RuleTypeLevel.setter
    def RuleTypeLevel(self, RuleTypeLevel):
        self._RuleTypeLevel = RuleTypeLevel


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._TypeIDs = params.get("TypeIDs")
        self._RuleTypeLevel = params.get("RuleTypeLevel")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyOwaspRuleTypeLevelResponse(AbstractModel):
    r"""ModifyOwaspRuleTypeLevel返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyOwaspRuleTypeStatusRequest(AbstractModel):
    r"""ModifyOwaspRuleTypeStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _TypeIDs: 规则类型ID列表
        :type TypeIDs: list of str
        :param _RuleTypeStatus: 规则类型的开关状态，0：关闭、1：开启
        :type RuleTypeStatus: int
        """
        self._Domain = None
        self._TypeIDs = None
        self._RuleTypeStatus = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def TypeIDs(self):
        r"""规则类型ID列表
        :rtype: list of str
        """
        return self._TypeIDs

    @TypeIDs.setter
    def TypeIDs(self, TypeIDs):
        self._TypeIDs = TypeIDs

    @property
    def RuleTypeStatus(self):
        r"""规则类型的开关状态，0：关闭、1：开启
        :rtype: int
        """
        return self._RuleTypeStatus

    @RuleTypeStatus.setter
    def RuleTypeStatus(self, RuleTypeStatus):
        self._RuleTypeStatus = RuleTypeStatus


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._TypeIDs = params.get("TypeIDs")
        self._RuleTypeStatus = params.get("RuleTypeStatus")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyOwaspRuleTypeStatusResponse(AbstractModel):
    r"""ModifyOwaspRuleTypeStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyOwaspWhiteRuleRequest(AbstractModel):
    r"""ModifyOwaspWhiteRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleId: 规则ID
        :type RuleId: int
        :param _Name: 规则名称
        :type Name: str
        :param _Domain: 域名
        :type Domain: str
        :param _Strategies: 规则匹配策略列表
        :type Strategies: list of Strategy
        :param _Ids: 加白的规则ID列表
        :type Ids: list of int non-negative
        :param _Type: 加白的类型，0:按照特定规则ID加白, 1:按照规则类型加白
        :type Type: int
        :param _JobType: 规则执行的方式，TimedJob为定时执行，CronJob为周期执行
        :type JobType: str
        :param _JobDateTime: 定时任务配置
        :type JobDateTime: :class:`tencentcloud.waf.v20180125.models.JobDateTime`
        :param _ExpireTime: 如果没有设置JobDateTime字段则用此字段，0表示永久生效，其它表示定时生效的截止时间（单位为秒）
        :type ExpireTime: int
        :param _Status: 规则状态，0：关闭、1：开启，默认为开启
        :type Status: int
        :param _LogicalOp: 匹配条件的逻辑关系，支持and、or，分别表示多个逻辑匹配条件是与、或的关系
        :type LogicalOp: str
        """
        self._RuleId = None
        self._Name = None
        self._Domain = None
        self._Strategies = None
        self._Ids = None
        self._Type = None
        self._JobType = None
        self._JobDateTime = None
        self._ExpireTime = None
        self._Status = None
        self._LogicalOp = None

    @property
    def RuleId(self):
        r"""规则ID
        :rtype: int
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def Name(self):
        r"""规则名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Strategies(self):
        r"""规则匹配策略列表
        :rtype: list of Strategy
        """
        return self._Strategies

    @Strategies.setter
    def Strategies(self, Strategies):
        self._Strategies = Strategies

    @property
    def Ids(self):
        r"""加白的规则ID列表
        :rtype: list of int non-negative
        """
        return self._Ids

    @Ids.setter
    def Ids(self, Ids):
        self._Ids = Ids

    @property
    def Type(self):
        r"""加白的类型，0:按照特定规则ID加白, 1:按照规则类型加白
        :rtype: int
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def JobType(self):
        r"""规则执行的方式，TimedJob为定时执行，CronJob为周期执行
        :rtype: str
        """
        return self._JobType

    @JobType.setter
    def JobType(self, JobType):
        self._JobType = JobType

    @property
    def JobDateTime(self):
        r"""定时任务配置
        :rtype: :class:`tencentcloud.waf.v20180125.models.JobDateTime`
        """
        return self._JobDateTime

    @JobDateTime.setter
    def JobDateTime(self, JobDateTime):
        self._JobDateTime = JobDateTime

    @property
    def ExpireTime(self):
        r"""如果没有设置JobDateTime字段则用此字段，0表示永久生效，其它表示定时生效的截止时间（单位为秒）
        :rtype: int
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def Status(self):
        r"""规则状态，0：关闭、1：开启，默认为开启
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def LogicalOp(self):
        r"""匹配条件的逻辑关系，支持and、or，分别表示多个逻辑匹配条件是与、或的关系
        :rtype: str
        """
        return self._LogicalOp

    @LogicalOp.setter
    def LogicalOp(self, LogicalOp):
        self._LogicalOp = LogicalOp


    def _deserialize(self, params):
        self._RuleId = params.get("RuleId")
        self._Name = params.get("Name")
        self._Domain = params.get("Domain")
        if params.get("Strategies") is not None:
            self._Strategies = []
            for item in params.get("Strategies"):
                obj = Strategy()
                obj._deserialize(item)
                self._Strategies.append(obj)
        self._Ids = params.get("Ids")
        self._Type = params.get("Type")
        self._JobType = params.get("JobType")
        if params.get("JobDateTime") is not None:
            self._JobDateTime = JobDateTime()
            self._JobDateTime._deserialize(params.get("JobDateTime"))
        self._ExpireTime = params.get("ExpireTime")
        self._Status = params.get("Status")
        self._LogicalOp = params.get("LogicalOp")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyOwaspWhiteRuleResponse(AbstractModel):
    r"""ModifyOwaspWhiteRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyProtectionLevelRequest(AbstractModel):
    r"""ModifyProtectionLevel请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 客户域名
        :type Domain: str
        :param _Level: 防护等级,100,200,300
        :type Level: int
        """
        self._Domain = None
        self._Level = None

    @property
    def Domain(self):
        r"""客户域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Level(self):
        r"""防护等级,100,200,300
        :rtype: int
        """
        return self._Level

    @Level.setter
    def Level(self, Level):
        self._Level = Level


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Level = params.get("Level")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyProtectionLevelResponse(AbstractModel):
    r"""ModifyProtectionLevel返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyProtectionStatusRequest(AbstractModel):
    r"""ModifyProtectionStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _Status: 1：开启WAF开关，0：关闭WAF开关
        :type Status: int
        :param _Edition: WAF的版本，clb-waf代表负载均衡WAF、sparta-waf代表SaaS WAF，默认是sparta-waf。
        :type Edition: str
        """
        self._Domain = None
        self._Status = None
        self._Edition = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Status(self):
        r"""1：开启WAF开关，0：关闭WAF开关
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Edition(self):
        r"""WAF的版本，clb-waf代表负载均衡WAF、sparta-waf代表SaaS WAF，默认是sparta-waf。
        :rtype: str
        """
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Status = params.get("Status")
        self._Edition = params.get("Edition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyProtectionStatusResponse(AbstractModel):
    r"""ModifyProtectionStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifySpartaProtectionModeRequest(AbstractModel):
    r"""ModifySpartaProtectionMode请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _Mode: 防护状态：
10：规则观察&&AI关闭模式，11：规则观察&&AI观察模式，12：规则观察&&AI拦截模式
20：规则拦截&&AI关闭模式，21：规则拦截&&AI观察模式，22：规则拦截&&AI拦截模式
        :type Mode: int
        :param _Edition: WAF的版本，clb-waf代表负载均衡WAF、sparta-waf代表SaaS WAF，默认是sparta-waf。
        :type Edition: str
        :param _Type: 0是修改规则引擎状态，1是修改AI的状态
        :type Type: int
        :param _InstanceID: 实例id
        :type InstanceID: str
        """
        self._Domain = None
        self._Mode = None
        self._Edition = None
        self._Type = None
        self._InstanceID = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Mode(self):
        r"""防护状态：
10：规则观察&&AI关闭模式，11：规则观察&&AI观察模式，12：规则观察&&AI拦截模式
20：规则拦截&&AI关闭模式，21：规则拦截&&AI观察模式，22：规则拦截&&AI拦截模式
        :rtype: int
        """
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode

    @property
    def Edition(self):
        r"""WAF的版本，clb-waf代表负载均衡WAF、sparta-waf代表SaaS WAF，默认是sparta-waf。
        :rtype: str
        """
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition

    @property
    def Type(self):
        r"""0是修改规则引擎状态，1是修改AI的状态
        :rtype: int
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def InstanceID(self):
        r"""实例id
        :rtype: str
        """
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Mode = params.get("Mode")
        self._Edition = params.get("Edition")
        self._Type = params.get("Type")
        self._InstanceID = params.get("InstanceID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifySpartaProtectionModeResponse(AbstractModel):
    r"""ModifySpartaProtectionMode返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifySpartaProtectionRequest(AbstractModel):
    r"""ModifySpartaProtection请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 域名
        :type Domain: str
        :param _DomainId: 必填项。域名唯一ID
        :type DomainId: str
        :param _InstanceID: 必填项。域名所属实例id
        :type InstanceID: str
        :param _CertType: 证书类型。0：仅配置HTTP监听端口，没有证书1：证书来源为自有证书2：证书来源为托管证书
        :type CertType: int
        :param _Cert: CertType为1时，需要填充此参数，表示自有证书的证书链
        :type Cert: str
        :param _PrivateKey: CertType为1时，需要填充此参数，表示自有证书的私钥
        :type PrivateKey: str
        :param _SSLId: CertType为2时，需要填充此参数，表示腾讯云SSL平台托管的证书id
        :type SSLId: str
        :param _IsCdn: waf前是否部署有七层代理服务。0：没有部署代理服务1：有部署代理服务，waf将使用XFF获取客户端IP2：有部署代理服务，waf将使用remote_addr获取客户端IP3：有部署代理服务，waf将使用ip_headers中的自定义header获取客户端IP
        :type IsCdn: int
        :param _UpstreamScheme: 服务配置有HTTPS端口时，HTTPS的回源协议。
http：使用http协议回源，和HttpsUpstreamPort配合使用
https：使用https协议回源
        :type UpstreamScheme: str
        :param _HttpsUpstreamPort: HTTPS回源端口,仅UpstreamScheme为http时需要填当前字段
        :type HttpsUpstreamPort: str
        :param _HttpsRewrite: 是否开启HTTP强制跳转到HTTPS。0：不强制跳转1：开启强制跳转
        :type HttpsRewrite: int
        :param _UpstreamType: 回源类型。0：通过IP回源1：通过域名回源
        :type UpstreamType: int
        :param _UpstreamDomain: 域名回源时的回源域名。UpstreamType为1时，需要填充此字段
        :type UpstreamDomain: str
        :param _SrcList: IP回源时的回源IP列表。UpstreamType为0时，需要填充此字段
        :type SrcList: list of str
        :param _IsHttp2: 是否开启HTTP2，需要开启HTTPS协议支持。0：关闭1：开启
        :type IsHttp2: int
        :param _IsWebsocket: 是否开启WebSocket支持。0：关闭1：开启
        :type IsWebsocket: int
        :param _LoadBalance: 回源负载均衡策略。0：轮询1：IP hash2：加权轮询
        :type LoadBalance: int
        :param _IsGray: 是否开启灰度，0表示不开启灰度。
        :type IsGray: int
        :param _Edition: 域名所属实例类型
        :type Edition: str
        :param _Ports: 端口信息，可通过DescribeDomains接口获取具体参数信息。
        :type Ports: list of SpartaProtectionPort
        :param _IsKeepAlive: 是否开启长连接。0： 短连接1： 长连接
        :type IsKeepAlive: str
        :param _Anycast: 目前填0即可。anycast IP类型开关： 0 普通IP 1 Anycast IP
        :type Anycast: int
        :param _Weights: 回源IP列表各IP的权重，和SrcList一一对应。当且仅当UpstreamType为0，并且SrcList有多个IP，并且LoadBalance为2时需要填写，否则填 []
        :type Weights: list of int
        :param _ActiveCheck: 是否开启主动健康检测。0：不开启1：开启
        :type ActiveCheck: int
        :param _TLSVersion: TLS版本信息
        :type TLSVersion: int
        :param _Ciphers: 加密套件信息
        :type Ciphers: list of int
        :param _CipherTemplate: 加密套件模板。0：不支持选择，使用默认模板  1：通用型模板 2：安全型模板3：自定义模板
        :type CipherTemplate: int
        :param _ProxyConnectTimeout: WAF与源站的连接超时时间，默认10s。
        :type ProxyConnectTimeout: int
        :param _ProxyReadTimeout: WAF与源站的读超时时间，默认300s。
        :type ProxyReadTimeout: int
        :param _ProxySendTimeout: WAF与源站的写超时时间，默认300s。
        :type ProxySendTimeout: int
        :param _SniType: WAF回源时的SNI类型。
0：关闭SNI，不配置client_hello中的server_name
1：开启SNI，client_hello中的server_name为防护域名
2：开启SNI，SNI为域名回源时的源站域名
3：开启SNI，SNI为自定义域名
        :type SniType: int
        :param _SniHost: SniType为3时，需要填此参数，表示自定义的SNI；
        :type SniHost: str
        :param _IpHeaders: IsCdn=3时，需要填此参数，表示自定义header
        :type IpHeaders: list of str
        :param _XFFReset: 是否开启XFF重置。0：关闭1：开启
        :type XFFReset: int
        :param _Note: 域名备注信息
        :type Note: str
        :param _UpstreamHost: 自定义回源Host。默认为空字符串，表示使用防护域名作为回源Host。
        :type UpstreamHost: str
        :param _ProxyBuffer: 是否开启缓存。 0：关闭 1：开启
        :type ProxyBuffer: int
        :param _ProbeStatus: 是否开启拨测。 0: 禁用拨测 1: 启用拨测。默认启用拨测
        :type ProbeStatus: int
        :param _GmType: 国密选项。0：不开启国密 1：在原有TLS选项的基础上追加支持国密 2：开启国密并仅支持国密客户端访问
        :type GmType: int
        :param _GmCertType: 国密证书类型。0：无国密证书 1：证书来源为自有国密证书 2：证书来源为托管国密证书
        :type GmCertType: int
        :param _GmCert: GmCertType为1时，需要填充此参数，表示自有国密证书的证书链
        :type GmCert: str
        :param _GmPrivateKey: GmCertType为1时，需要填充此参数，表示自有国密证书的私钥
        :type GmPrivateKey: str
        :param _GmEncCert: GmCertType为1时，需要填充此参数，表示自有国密证书的加密证书
        :type GmEncCert: str
        :param _GmEncPrivateKey: GmCertType为1时，需要填充此参数，表示自有国密证书的加密证书的私钥
        :type GmEncPrivateKey: str
        :param _GmSSLId: GmCertType为2时，需要填充此参数，表示腾讯云SSL平台托管的证书id
        :type GmSSLId: str
        :param _UpstreamPolicy: 回源策略，支持负载均衡回源和分流回源两种方式。0：默认值，负载均衡回源；1：分流回源
        :type UpstreamPolicy: int
        :param _UpstreamRules: 分流回源时生效，分流回源的规则。
        :type UpstreamRules: list of UpstreamRule
        :param _UseCase: 业务场景。0：默认值，表示常规业务场景 1：大模型业务场景
        :type UseCase: int
        :param _Gzip: gzip开关。0：关闭 1：默认值，打开
        :type Gzip: int
        """
        self._Domain = None
        self._DomainId = None
        self._InstanceID = None
        self._CertType = None
        self._Cert = None
        self._PrivateKey = None
        self._SSLId = None
        self._IsCdn = None
        self._UpstreamScheme = None
        self._HttpsUpstreamPort = None
        self._HttpsRewrite = None
        self._UpstreamType = None
        self._UpstreamDomain = None
        self._SrcList = None
        self._IsHttp2 = None
        self._IsWebsocket = None
        self._LoadBalance = None
        self._IsGray = None
        self._Edition = None
        self._Ports = None
        self._IsKeepAlive = None
        self._Anycast = None
        self._Weights = None
        self._ActiveCheck = None
        self._TLSVersion = None
        self._Ciphers = None
        self._CipherTemplate = None
        self._ProxyConnectTimeout = None
        self._ProxyReadTimeout = None
        self._ProxySendTimeout = None
        self._SniType = None
        self._SniHost = None
        self._IpHeaders = None
        self._XFFReset = None
        self._Note = None
        self._UpstreamHost = None
        self._ProxyBuffer = None
        self._ProbeStatus = None
        self._GmType = None
        self._GmCertType = None
        self._GmCert = None
        self._GmPrivateKey = None
        self._GmEncCert = None
        self._GmEncPrivateKey = None
        self._GmSSLId = None
        self._UpstreamPolicy = None
        self._UpstreamRules = None
        self._UseCase = None
        self._Gzip = None

    @property
    def Domain(self):
        r"""域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def DomainId(self):
        r"""必填项。域名唯一ID
        :rtype: str
        """
        return self._DomainId

    @DomainId.setter
    def DomainId(self, DomainId):
        self._DomainId = DomainId

    @property
    def InstanceID(self):
        r"""必填项。域名所属实例id
        :rtype: str
        """
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID

    @property
    def CertType(self):
        r"""证书类型。0：仅配置HTTP监听端口，没有证书1：证书来源为自有证书2：证书来源为托管证书
        :rtype: int
        """
        return self._CertType

    @CertType.setter
    def CertType(self, CertType):
        self._CertType = CertType

    @property
    def Cert(self):
        r"""CertType为1时，需要填充此参数，表示自有证书的证书链
        :rtype: str
        """
        return self._Cert

    @Cert.setter
    def Cert(self, Cert):
        self._Cert = Cert

    @property
    def PrivateKey(self):
        r"""CertType为1时，需要填充此参数，表示自有证书的私钥
        :rtype: str
        """
        return self._PrivateKey

    @PrivateKey.setter
    def PrivateKey(self, PrivateKey):
        self._PrivateKey = PrivateKey

    @property
    def SSLId(self):
        r"""CertType为2时，需要填充此参数，表示腾讯云SSL平台托管的证书id
        :rtype: str
        """
        return self._SSLId

    @SSLId.setter
    def SSLId(self, SSLId):
        self._SSLId = SSLId

    @property
    def IsCdn(self):
        r"""waf前是否部署有七层代理服务。0：没有部署代理服务1：有部署代理服务，waf将使用XFF获取客户端IP2：有部署代理服务，waf将使用remote_addr获取客户端IP3：有部署代理服务，waf将使用ip_headers中的自定义header获取客户端IP
        :rtype: int
        """
        return self._IsCdn

    @IsCdn.setter
    def IsCdn(self, IsCdn):
        self._IsCdn = IsCdn

    @property
    def UpstreamScheme(self):
        r"""服务配置有HTTPS端口时，HTTPS的回源协议。
http：使用http协议回源，和HttpsUpstreamPort配合使用
https：使用https协议回源
        :rtype: str
        """
        return self._UpstreamScheme

    @UpstreamScheme.setter
    def UpstreamScheme(self, UpstreamScheme):
        self._UpstreamScheme = UpstreamScheme

    @property
    def HttpsUpstreamPort(self):
        r"""HTTPS回源端口,仅UpstreamScheme为http时需要填当前字段
        :rtype: str
        """
        return self._HttpsUpstreamPort

    @HttpsUpstreamPort.setter
    def HttpsUpstreamPort(self, HttpsUpstreamPort):
        self._HttpsUpstreamPort = HttpsUpstreamPort

    @property
    def HttpsRewrite(self):
        r"""是否开启HTTP强制跳转到HTTPS。0：不强制跳转1：开启强制跳转
        :rtype: int
        """
        return self._HttpsRewrite

    @HttpsRewrite.setter
    def HttpsRewrite(self, HttpsRewrite):
        self._HttpsRewrite = HttpsRewrite

    @property
    def UpstreamType(self):
        r"""回源类型。0：通过IP回源1：通过域名回源
        :rtype: int
        """
        return self._UpstreamType

    @UpstreamType.setter
    def UpstreamType(self, UpstreamType):
        self._