# coding: utf-8

"""
    NeoLoad API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from openapi_client.api_client import ApiClient
from openapi_client.exceptions import (
    ApiTypeError,
    ApiValueError
)


class ResultsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_test(self, test_id, **kwargs):  # noqa: E501
        """Deletes a test result  # noqa: E501

        Deletes a test result and all the associated statistics. This action cannot be undone.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_test(test_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str test_id: Unique identifier representing a specific test result. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_test_with_http_info(test_id, **kwargs)  # noqa: E501

    def delete_test_with_http_info(self, test_id, **kwargs):  # noqa: E501
        """Deletes a test result  # noqa: E501

        Deletes a test result and all the associated statistics. This action cannot be undone.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_test_with_http_info(test_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str test_id: Unique identifier representing a specific test result. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['test_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_test" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'test_id' is set
        if self.api_client.client_side_validation and ('test_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['test_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `test_id` when calling `delete_test`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'test_id' in local_var_params:
            path_params['testId'] = local_var_params['test_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['NeoloadAuthorizer']  # noqa: E501

        return self.api_client.call_api(
            '/tests/{testId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_test(self, test_id, **kwargs):  # noqa: E501
        """Test result description  # noqa: E501

        Provides a test result description using a unique test result identifier. Provides name, dates, owner ...  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_test(test_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str test_id: Unique identifier representing a specific test result. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TestDefinition
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_test_with_http_info(test_id, **kwargs)  # noqa: E501

    def get_test_with_http_info(self, test_id, **kwargs):  # noqa: E501
        """Test result description  # noqa: E501

        Provides a test result description using a unique test result identifier. Provides name, dates, owner ...  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_test_with_http_info(test_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str test_id: Unique identifier representing a specific test result. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TestDefinition, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['test_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_test" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'test_id' is set
        if self.api_client.client_side_validation and ('test_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['test_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `test_id` when calling `get_test`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'test_id' in local_var_params:
            path_params['testId'] = local_var_params['test_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['NeoloadAuthorizer']  # noqa: E501

        return self.api_client.call_api(
            '/tests/{testId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TestDefinition',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_test_element_definition(self, test_id, element_id, **kwargs):  # noqa: E501
        """Test result element definition  # noqa: E501

        Provides a test result element definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_test_element_definition(test_id, element_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str test_id: Unique identifier representing a specific test result. (required)
        :param str element_id: Unique identifier representing a specific element. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ElementDefinition
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_test_element_definition_with_http_info(test_id, element_id, **kwargs)  # noqa: E501

    def get_test_element_definition_with_http_info(self, test_id, element_id, **kwargs):  # noqa: E501
        """Test result element definition  # noqa: E501

        Provides a test result element definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_test_element_definition_with_http_info(test_id, element_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str test_id: Unique identifier representing a specific test result. (required)
        :param str element_id: Unique identifier representing a specific element. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ElementDefinition, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['test_id', 'element_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_test_element_definition" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'test_id' is set
        if self.api_client.client_side_validation and ('test_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['test_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `test_id` when calling `get_test_element_definition`")  # noqa: E501
        # verify the required parameter 'element_id' is set
        if self.api_client.client_side_validation and ('element_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['element_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `element_id` when calling `get_test_element_definition`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'test_id' in local_var_params:
            path_params['testId'] = local_var_params['test_id']  # noqa: E501
        if 'element_id' in local_var_params:
            path_params['elementId'] = local_var_params['element_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['NeoloadAuthorizer']  # noqa: E501

        return self.api_client.call_api(
            '/tests/{testId}/elements/{elementId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ElementDefinition',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_test_elements(self, test_id, category, **kwargs):  # noqa: E501
        """Test elements  # noqa: E501

        Provides the tests elements of a test result. The elements type must be provided.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_test_elements(test_id, category, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str test_id: Unique identifier representing a specific test result. (required)
        :param str category: Category of the elements to return. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[ElementDefinition]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_test_elements_with_http_info(test_id, category, **kwargs)  # noqa: E501

    def get_test_elements_with_http_info(self, test_id, category, **kwargs):  # noqa: E501
        """Test elements  # noqa: E501

        Provides the tests elements of a test result. The elements type must be provided.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_test_elements_with_http_info(test_id, category, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str test_id: Unique identifier representing a specific test result. (required)
        :param str category: Category of the elements to return. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[ElementDefinition], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['test_id', 'category']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_test_elements" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'test_id' is set
        if self.api_client.client_side_validation and ('test_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['test_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `test_id` when calling `get_test_elements`")  # noqa: E501
        # verify the required parameter 'category' is set
        if self.api_client.client_side_validation and ('category' not in local_var_params or  # noqa: E501
                                                        local_var_params['category'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `category` when calling `get_test_elements`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'test_id' in local_var_params:
            path_params['testId'] = local_var_params['test_id']  # noqa: E501

        query_params = []
        if 'category' in local_var_params and local_var_params['category'] is not None:  # noqa: E501
            query_params.append(('category', local_var_params['category']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['NeoloadAuthorizer']  # noqa: E501

        return self.api_client.call_api(
            '/tests/{testId}/elements', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ElementDefinition]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_test_elements_percentiles(self, test_id, element_id, **kwargs):  # noqa: E501
        """Test result percentiles transaction since the beginning of the test result  # noqa: E501

        Provides the percentiles of a test result transaction.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_test_elements_percentiles(test_id, element_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str test_id: Unique identifier representing a specific test result. (required)
        :param str element_id: Unique identifier representing a specific element. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[PercentilesPoints]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_test_elements_percentiles_with_http_info(test_id, element_id, **kwargs)  # noqa: E501

    def get_test_elements_percentiles_with_http_info(self, test_id, element_id, **kwargs):  # noqa: E501
        """Test result percentiles transaction since the beginning of the test result  # noqa: E501

        Provides the percentiles of a test result transaction.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_test_elements_percentiles_with_http_info(test_id, element_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str test_id: Unique identifier representing a specific test result. (required)
        :param str element_id: Unique identifier representing a specific element. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[PercentilesPoints], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['test_id', 'element_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_test_elements_percentiles" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'test_id' is set
        if self.api_client.client_side_validation and ('test_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['test_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `test_id` when calling `get_test_elements_percentiles`")  # noqa: E501
        # verify the required parameter 'element_id' is set
        if self.api_client.client_side_validation and ('element_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['element_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `element_id` when calling `get_test_elements_percentiles`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'test_id' in local_var_params:
            path_params['testId'] = local_var_params['test_id']  # noqa: E501
        if 'element_id' in local_var_params:
            path_params['elementId'] = local_var_params['element_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['NeoloadAuthorizer']  # noqa: E501

        return self.api_client.call_api(
            '/tests/{testId}/elements/{elementId}/percentiles', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PercentilesPoints]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_test_elements_points(self, test_id, element_id, statistics, **kwargs):  # noqa: E501
        """Test results elements points since the beginning of the test result  # noqa: E501

        Provides all the points of a test result element for the selected statistics.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_test_elements_points(test_id, element_id, statistics, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str test_id: Unique identifier representing a specific test result. (required)
        :param str element_id: Unique identifier representing a specific element. (required)
        :param str statistics: Comma-separated list of statistics to get. Available statistics are: AVG_DURATION (ms), MIN_DURATION (ms), MAX_DURATION (ms), COUNT, THROUGHPUT (Byte/s), ELEMENTS_PER_SECOND, ERRORS, ERRORS_PER_SECOND, ERROR_RATE (%), AVG_TTFB (ms), MIN_TTFB (ms), MAX_TTFB (ms).<br/> Example: AVG_DURATION,ELEMENTS_PER_SECOND (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Point]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_test_elements_points_with_http_info(test_id, element_id, statistics, **kwargs)  # noqa: E501

    def get_test_elements_points_with_http_info(self, test_id, element_id, statistics, **kwargs):  # noqa: E501
        """Test results elements points since the beginning of the test result  # noqa: E501

        Provides all the points of a test result element for the selected statistics.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_test_elements_points_with_http_info(test_id, element_id, statistics, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str test_id: Unique identifier representing a specific test result. (required)
        :param str element_id: Unique identifier representing a specific element. (required)
        :param str statistics: Comma-separated list of statistics to get. Available statistics are: AVG_DURATION (ms), MIN_DURATION (ms), MAX_DURATION (ms), COUNT, THROUGHPUT (Byte/s), ELEMENTS_PER_SECOND, ERRORS, ERRORS_PER_SECOND, ERROR_RATE (%), AVG_TTFB (ms), MIN_TTFB (ms), MAX_TTFB (ms).<br/> Example: AVG_DURATION,ELEMENTS_PER_SECOND (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[Point], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['test_id', 'element_id', 'statistics']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_test_elements_points" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'test_id' is set
        if self.api_client.client_side_validation and ('test_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['test_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `test_id` when calling `get_test_elements_points`")  # noqa: E501
        # verify the required parameter 'element_id' is set
        if self.api_client.client_side_validation and ('element_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['element_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `element_id` when calling `get_test_elements_points`")  # noqa: E501
        # verify the required parameter 'statistics' is set
        if self.api_client.client_side_validation and ('statistics' not in local_var_params or  # noqa: E501
                                                        local_var_params['statistics'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `statistics` when calling `get_test_elements_points`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'test_id' in local_var_params:
            path_params['testId'] = local_var_params['test_id']  # noqa: E501
        if 'element_id' in local_var_params:
            path_params['elementId'] = local_var_params['element_id']  # noqa: E501

        query_params = []
        if 'statistics' in local_var_params and local_var_params['statistics'] is not None:  # noqa: E501
            query_params.append(('statistics', local_var_params['statistics']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['NeoloadAuthorizer']  # noqa: E501

        return self.api_client.call_api(
            '/tests/{testId}/elements/{elementId}/points', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Point]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_test_elements_sla(self, test_id, element_id, **kwargs):  # noqa: E501
        """Test result elements SLA status since the beginning of the test result  # noqa: E501

        Provides the SLA status of a test result element.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_test_elements_sla(test_id, element_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str test_id: Unique identifier representing a specific test result. (required)
        :param str element_id: Unique identifier representing a specific element. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Sla
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_test_elements_sla_with_http_info(test_id, element_id, **kwargs)  # noqa: E501

    def get_test_elements_sla_with_http_info(self, test_id, element_id, **kwargs):  # noqa: E501
        """Test result elements SLA status since the beginning of the test result  # noqa: E501

        Provides the SLA status of a test result element.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_test_elements_sla_with_http_info(test_id, element_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str test_id: Unique identifier representing a specific test result. (required)
        :param str element_id: Unique identifier representing a specific element. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Sla, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['test_id', 'element_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_test_elements_sla" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'test_id' is set
        if self.api_client.client_side_validation and ('test_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['test_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `test_id` when calling `get_test_elements_sla`")  # noqa: E501
        # verify the required parameter 'element_id' is set
        if self.api_client.client_side_validation and ('element_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['element_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `element_id` when calling `get_test_elements_sla`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'test_id' in local_var_params:
            path_params['testId'] = local_var_params['test_id']  # noqa: E501
        if 'element_id' in local_var_params:
            path_params['elementId'] = local_var_params['element_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['NeoloadAuthorizer']  # noqa: E501

        return self.api_client.call_api(
            '/tests/{testId}/elements/{elementId}/sla', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Sla',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_test_elements_values(self, test_id, element_id, **kwargs):  # noqa: E501
        """Test result elements values  # noqa: E501

        Provides the values of a test result element.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_test_elements_values(test_id, element_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str test_id: Unique identifier representing a specific test result. (required)
        :param str element_id: Unique identifier representing a specific element. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ElementValues
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_test_elements_values_with_http_info(test_id, element_id, **kwargs)  # noqa: E501

    def get_test_elements_values_with_http_info(self, test_id, element_id, **kwargs):  # noqa: E501
        """Test result elements values  # noqa: E501

        Provides the values of a test result element.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_test_elements_values_with_http_info(test_id, element_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str test_id: Unique identifier representing a specific test result. (required)
        :param str element_id: Unique identifier representing a specific element. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ElementValues, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['test_id', 'element_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_test_elements_values" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'test_id' is set
        if self.api_client.client_side_validation and ('test_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['test_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `test_id` when calling `get_test_elements_values`")  # noqa: E501
        # verify the required parameter 'element_id' is set
        if self.api_client.client_side_validation and ('element_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['element_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `element_id` when calling `get_test_elements_values`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'test_id' in local_var_params:
            path_params['testId'] = local_var_params['test_id']  # noqa: E501
        if 'element_id' in local_var_params:
            path_params['elementId'] = local_var_params['element_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['NeoloadAuthorizer']  # noqa: E501

        return self.api_client.call_api(
            '/tests/{testId}/elements/{elementId}/values', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ElementValues',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_test_events(self, test_id, **kwargs):  # noqa: E501
        """Test result events  # noqa: E501

        List the events of the specified test result according to the method parameters. ___ *Sortable fields :*   - offset   - fullname   - code   - source   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_test_events(test_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str test_id: Unique identifier representing a specific test result. (required)
        :param list[EventType] types: The types of the events you expect to get. It will return all the types if the field is left empty. (Ctrl+click to select multiple values) 
        :param int limit: The maximum number of elements returned by this call. The maximum must be less than or equal to 200.
        :param int offset: The offset of the first element to return. Starting at this offset, the query will return a maximum of 'limit' elements.
        :param str sort: The key to sort the elements on. It may begin with a '+' or a '-' to specify an ascending or descending sort order. The list of available keys can be found in the endpoint description.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[EventDefinition]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_test_events_with_http_info(test_id, **kwargs)  # noqa: E501

    def get_test_events_with_http_info(self, test_id, **kwargs):  # noqa: E501
        """Test result events  # noqa: E501

        List the events of the specified test result according to the method parameters. ___ *Sortable fields :*   - offset   - fullname   - code   - source   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_test_events_with_http_info(test_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str test_id: Unique identifier representing a specific test result. (required)
        :param list[EventType] types: The types of the events you expect to get. It will return all the types if the field is left empty. (Ctrl+click to select multiple values) 
        :param int limit: The maximum number of elements returned by this call. The maximum must be less than or equal to 200.
        :param int offset: The offset of the first element to return. Starting at this offset, the query will return a maximum of 'limit' elements.
        :param str sort: The key to sort the elements on. It may begin with a '+' or a '-' to specify an ascending or descending sort order. The list of available keys can be found in the endpoint description.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[EventDefinition], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['test_id', 'types', 'limit', 'offset', 'sort']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_test_events" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'test_id' is set
        if self.api_client.client_side_validation and ('test_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['test_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `test_id` when calling `get_test_events`")  # noqa: E501

        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] > 200:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `get_test_events`, must be a value less than or equal to `200`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'test_id' in local_var_params:
            path_params['testId'] = local_var_params['test_id']  # noqa: E501

        query_params = []
        if 'types' in local_var_params and local_var_params['types'] is not None:  # noqa: E501
            query_params.append(('types', local_var_params['types']))  # noqa: E501
            collection_formats['types'] = 'csv'  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['NeoloadAuthorizer']  # noqa: E501

        return self.api_client.call_api(
            '/tests/{testId}/events', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[EventDefinition]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_test_graph(self, test_id, **kwargs):  # noqa: E501
        """Test result Graph  # noqa: E501

        Provides a graph from some stats of a test result.  Element statistics can be mixed with monitor statistics. Only limitation is around PERCENTILES_DURATION element statistic that cannot be mixed with other element statistics neither with monitor statistics.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_test_graph(test_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str test_id: Unique identifier representing a specific test result. (required)
        :param TestRasterConfiguration test_raster_configuration:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_test_graph_with_http_info(test_id, **kwargs)  # noqa: E501

    def get_test_graph_with_http_info(self, test_id, **kwargs):  # noqa: E501
        """Test result Graph  # noqa: E501

        Provides a graph from some stats of a test result.  Element statistics can be mixed with monitor statistics. Only limitation is around PERCENTILES_DURATION element statistic that cannot be mixed with other element statistics neither with monitor statistics.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_test_graph_with_http_info(test_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str test_id: Unique identifier representing a specific test result. (required)
        :param TestRasterConfiguration test_raster_configuration:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['test_id', 'test_raster_configuration']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_test_graph" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'test_id' is set
        if self.api_client.client_side_validation and ('test_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['test_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `test_id` when calling `get_test_graph`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'test_id' in local_var_params:
            path_params['testId'] = local_var_params['test_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'test_raster_configuration' in local_var_params:
            body_params = local_var_params['test_raster_configuration']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['image/png', 'image/jpeg', 'image/tiff', 'application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['NeoloadAuthorizer']  # noqa: E501

        return self.api_client.call_api(
            '/tests/{testId}/graph', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_test_monitor_definition(self, test_id, counter_id, **kwargs):  # noqa: E501
        """Test result counter definition  # noqa: E501

        Provides the definition of a test result counter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_test_monitor_definition(test_id, counter_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str test_id: Unique identifier representing a specific test result. (required)
        :param str counter_id: Unique identifier representing a specific counter. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CounterDefinition
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_test_monitor_definition_with_http_info(test_id, counter_id, **kwargs)  # noqa: E501

    def get_test_monitor_definition_with_http_info(self, test_id, counter_id, **kwargs):  # noqa: E501
        """Test result counter definition  # noqa: E501

        Provides the definition of a test result counter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_test_monitor_definition_with_http_info(test_id, counter_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str test_id: Unique identifier representing a specific test result. (required)
        :param str counter_id: Unique identifier representing a specific counter. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CounterDefinition, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['test_id', 'counter_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_test_monitor_definition" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'test_id' is set
        if self.api_client.client_side_validation and ('test_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['test_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `test_id` when calling `get_test_monitor_definition`")  # noqa: E501
        # verify the required parameter 'counter_id' is set
        if self.api_client.client_side_validation and ('counter_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['counter_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `counter_id` when calling `get_test_monitor_definition`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'test_id' in local_var_params:
            path_params['testId'] = local_var_params['test_id']  # noqa: E501
        if 'counter_id' in local_var_params:
            path_params['counterId'] = local_var_params['counter_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['NeoloadAuthorizer']  # noqa: E501

        return self.api_client.call_api(
            '/tests/{testId}/monitors/{counterId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CounterDefinition',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_test_monitors(self, test_id, **kwargs):  # noqa: E501
        """Test result monitors  # noqa: E501

        Provides all the test result counters of all monitors for a test result.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_test_monitors(test_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str test_id: Unique identifier representing a specific test result. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[CounterDefinition]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_test_monitors_with_http_info(test_id, **kwargs)  # noqa: E501

    def get_test_monitors_with_http_info(self, test_id, **kwargs):  # noqa: E501
        """Test result monitors  # noqa: E501

        Provides all the test result counters of all monitors for a test result.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_test_monitors_with_http_info(test_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str test_id: Unique identifier representing a specific test result. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[CounterDefinition], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['test_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_test_monitors" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'test_id' is set
        if self.api_client.client_side_validation and ('test_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['test_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `test_id` when calling `get_test_monitors`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'test_id' in local_var_params:
            path_params['testId'] = local_var_params['test_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['NeoloadAuthorizer']  # noqa: E501

        return self.api_client.call_api(
            '/tests/{testId}/monitors', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[CounterDefinition]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_test_monitors_points(self, test_id, counter_id, **kwargs):  # noqa: E501
        """Test result monitors points  # noqa: E501

        Provides all the points of a test result counter. The values are the average on the specified interval.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_test_monitors_points(test_id, counter_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str test_id: Unique identifier representing a specific test result. (required)
        :param str counter_id: Unique identifier representing a specific counter. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Point]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_test_monitors_points_with_http_info(test_id, counter_id, **kwargs)  # noqa: E501

    def get_test_monitors_points_with_http_info(self, test_id, counter_id, **kwargs):  # noqa: E501
        """Test result monitors points  # noqa: E501

        Provides all the points of a test result counter. The values are the average on the specified interval.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_test_monitors_points_with_http_info(test_id, counter_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str test_id: Unique identifier representing a specific test result. (required)
        :param str counter_id: Unique identifier representing a specific counter. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[Point], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['test_id', 'counter_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_test_monitors_points" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'test_id' is set
        if self.api_client.client_side_validation and ('test_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['test_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `test_id` when calling `get_test_monitors_points`")  # noqa: E501
        # verify the required parameter 'counter_id' is set
        if self.api_client.client_side_validation and ('counter_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['counter_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `counter_id` when calling `get_test_monitors_points`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'test_id' in local_var_params:
            path_params['testId'] = local_var_params['test_id']  # noqa: E501
        if 'counter_id' in local_var_params:
            path_params['counterId'] = local_var_params['counter_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['NeoloadAuthorizer']  # noqa: E501

        return self.api_client.call_api(
            '/tests/{testId}/monitors/{counterId}/points', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Point]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_test_monitors_values(self, test_id, counter_id, **kwargs):  # noqa: E501
        """Test result monitors values  # noqa: E501

        Provides the values of a test result counter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_test_monitors_values(test_id, counter_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str test_id: Unique identifier representing a specific test result. (required)
        :param str counter_id: Unique identifier representing a specific counter. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CounterValues
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_test_monitors_values_with_http_info(test_id, counter_id, **kwargs)  # noqa: E501

    def get_test_monitors_values_with_http_info(self, test_id, counter_id, **kwargs):  # noqa: E501
        """Test result monitors values  # noqa: E501

        Provides the values of a test result counter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_test_monitors_values_with_http_info(test_id, counter_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str test_id: Unique identifier representing a specific test result. (required)
        :param str counter_id: Unique identifier representing a specific counter. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CounterValues, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['test_id', 'counter_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_test_monitors_values" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'test_id' is set
        if self.api_client.client_side_validation and ('test_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['test_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `test_id` when calling `get_test_monitors_values`")  # noqa: E501
        # verify the required parameter 'counter_id' is set
        if self.api_client.client_side_validation and ('counter_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['counter_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `counter_id` when calling `get_test_monitors_values`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'test_id' in local_var_params:
            path_params['testId'] = local_var_params['test_id']  # noqa: E501
        if 'counter_id' in local_var_params:
            path_params['counterId'] = local_var_params['counter_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['NeoloadAuthorizer']  # noqa: E501

        return self.api_client.call_api(
            '/tests/{testId}/monitors/{counterId}/values', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CounterValues',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_test_multi_graph(self, **kwargs):  # noqa: E501
        """Test results MultiGraph  # noqa: E501

        Provides a graph from some stats of some tests result.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_test_multi_graph(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param TestRasterMultiConfiguration test_raster_multi_configuration:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_test_multi_graph_with_http_info(**kwargs)  # noqa: E501

    def get_test_multi_graph_with_http_info(self, **kwargs):  # noqa: E501
        """Test results MultiGraph  # noqa: E501

        Provides a graph from some stats of some tests result.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_test_multi_graph_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param TestRasterMultiConfiguration test_raster_multi_configuration:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['test_raster_multi_configuration']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_test_multi_graph" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'test_raster_multi_configuration' in local_var_params:
            body_params = local_var_params['test_raster_multi_configuration']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['image/png', 'image/jpeg', 'image/tiff', 'application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['NeoloadAuthorizer']  # noqa: E501

        return self.api_client.call_api(
            '/tests/graph', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_test_sla_global_indicators(self, test_id, **kwargs):  # noqa: E501
        """SLAs global indicators  # noqa: E501

        Provides the SLAs global indicators of the test result.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_test_sla_global_indicators(test_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str test_id: Unique identifier representing a specific test result. (required)
        :param str status: The status of the element you expect to get the SLA for. It will return all the statuses if the field is left empty.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[SLAGlobalIndicatorDefinition]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_test_sla_global_indicators_with_http_info(test_id, **kwargs)  # noqa: E501

    def get_test_sla_global_indicators_with_http_info(self, test_id, **kwargs):  # noqa: E501
        """SLAs global indicators  # noqa: E501

        Provides the SLAs global indicators of the test result.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_test_sla_global_indicators_with_http_info(test_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str test_id: Unique identifier representing a specific test result. (required)
        :param str status: The status of the element you expect to get the SLA for. It will return all the statuses if the field is left empty.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[SLAGlobalIndicatorDefinition], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['test_id', 'status']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_test_sla_global_indicators" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'test_id' is set
        if self.api_client.client_side_validation and ('test_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['test_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `test_id` when calling `get_test_sla_global_indicators`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'test_id' in local_var_params:
            path_params['testId'] = local_var_params['test_id']  # noqa: E501

        query_params = []
        if 'status' in local_var_params and local_var_params['status'] is not None:  # noqa: E501
            query_params.append(('status', local_var_params['status']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['NeoloadAuthorizer']  # noqa: E501

        return self.api_client.call_api(
            '/tests/{testId}/slas/statistics', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[SLAGlobalIndicatorDefinition]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_test_sla_per_interval(self, test_id, **kwargs):  # noqa: E501
        """SLAs per time interval  # noqa: E501

        Provides the SLAs per time interval of a specific test result.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_test_sla_per_interval(test_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str test_id: Unique identifier representing a specific test result. (required)
        :param str status: The status of the element you expect to get the SLA for. It will return all the statuses if the field is left empty.
        :param str category: The category of the element you expect to get the SLA for. It will return all the categories if the field is left empty.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[SLAPerIntervalDefinition]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_test_sla_per_interval_with_http_info(test_id, **kwargs)  # noqa: E501

    def get_test_sla_per_interval_with_http_info(self, test_id, **kwargs):  # noqa: E501
        """SLAs per time interval  # noqa: E501

        Provides the SLAs per time interval of a specific test result.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_test_sla_per_interval_with_http_info(test_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str test_id: Unique identifier representing a specific test result. (required)
        :param str status: The status of the element you expect to get the SLA for. It will return all the statuses if the field is left empty.
        :param str category: The category of the element you expect to get the SLA for. It will return all the categories if the field is left empty.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[SLAPerIntervalDefinition], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['test_id', 'status', 'category']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_test_sla_per_interval" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'test_id' is set
        if self.api_client.client_side_validation and ('test_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['test_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `test_id` when calling `get_test_sla_per_interval`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'test_id' in local_var_params:
            path_params['testId'] = local_var_params['test_id']  # noqa: E501

        query_params = []
        if 'status' in local_var_params and local_var_params['status'] is not None:  # noqa: E501
            query_params.append(('status', local_var_params['status']))  # noqa: E501
        if 'category' in local_var_params and local_var_params['category'] is not None:  # noqa: E501
            query_params.append(('category', local_var_params['category']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['NeoloadAuthorizer']  # noqa: E501

        return self.api_client.call_api(
            '/tests/{testId}/slas/per-interval', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[SLAPerIntervalDefinition]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_test_sla_per_test(self, test_id, **kwargs):  # noqa: E501
        """SLAs per test  # noqa: E501

        Provides the SLAs per test of a specific test result.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_test_sla_per_test(test_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str test_id: Unique identifier representing a specific test result. (required)
        :param str status: The status of the element you expect to get the SLA for. It will return all the statuses if the field is left empty.
        :param str category: The category of the element you expect to get the SLA for. It will return all the categories if the field is left empty.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[SLAPerTestDefinition]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_test_sla_per_test_with_http_info(test_id, **kwargs)  # noqa: E501

    def get_test_sla_per_test_with_http_info(self, test_id, **kwargs):  # noqa: E501
        """SLAs per test  # noqa: E501

        Provides the SLAs per test of a specific test result.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_test_sla_per_test_with_http_info(test_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str test_id: Unique identifier representing a specific test result. (required)
        :param str status: The status of the element you expect to get the SLA for. It will return all the statuses if the field is left empty.
        :param str category: The category of the element you expect to get the SLA for. It will return all the categories if the field is left empty.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[SLAPerTestDefinition], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['test_id', 'status', 'category']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_test_sla_per_test" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'test_id' is set
        if self.api_client.client_side_validation and ('test_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['test_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `test_id` when calling `get_test_sla_per_test`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'test_id' in local_var_params:
            path_params['testId'] = local_var_params['test_id']  # noqa: E501

        query_params = []
        if 'status' in local_var_params and local_var_params['status'] is not None:  # noqa: E501
            query_params.append(('status', local_var_params['status']))  # noqa: E501
        if 'category' in local_var_params and local_var_params['category'] is not None:  # noqa: E501
            query_params.append(('category', local_var_params['category']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['NeoloadAuthorizer']  # noqa: E501

        return self.api_client.call_api(
            '/tests/{testId}/slas/per-test', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[SLAPerTestDefinition]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_test_statistics(self, test_id, **kwargs):  # noqa: E501
        """Test result main statistics  # noqa: E501

        Provides the main statistics of a test result. For a runnning test, these statistics are live, for a test result, those are average for the all test result.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_test_statistics(test_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str test_id: Unique identifier representing a specific test result. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TestStatistics
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_test_statistics_with_http_info(test_id, **kwargs)  # noqa: E501

    def get_test_statistics_with_http_info(self, test_id, **kwargs):  # noqa: E501
        """Test result main statistics  # noqa: E501

        Provides the main statistics of a test result. For a runnning test, these statistics are live, for a test result, those are average for the all test result.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_test_statistics_with_http_info(test_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str test_id: Unique identifier representing a specific test result. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TestStatistics, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['test_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_test_statistics" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'test_id' is set
        if self.api_client.client_side_validation and ('test_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['test_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `test_id` when calling `get_test_statistics`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'test_id' in local_var_params:
            path_params['testId'] = local_var_params['test_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['NeoloadAuthorizer']  # noqa: E501

        return self.api_client.call_api(
            '/tests/{testId}/statistics', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TestStatistics',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tests(self, **kwargs):  # noqa: E501
        """Lists test results  # noqa: E501

        Lists the test results of the Account according to the method parameters. ___ *Sortable fields :*   - name   - project   - startDate   - qualityStatus   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tests(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str status: Returns only the test results with the specified status.
        :param str project: Project name. Returns only the test results of the specified project.
        :param str author: The author of the test result. Returns only the test results launched by the specified author.
        :param int limit: The maximum number of elements returned by this call. The maximum must be less than or equal to 200.
        :param int offset: The offset of the first element to return. Starting at this offset, the query will return a maximum of 'limit' elements.
        :param str sort: The key to sort the elements on. It may begin with a '+' or a '-' to specify an ascending or descending sort order. The list of available keys can be found in the endpoint description.
        :param str fields: Comma-separated list of fields to include in the json test result definition.
        :param bool pretty: If true the Json returned is human readable.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[TestDefinition]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_tests_with_http_info(**kwargs)  # noqa: E501

    def get_tests_with_http_info(self, **kwargs):  # noqa: E501
        """Lists test results  # noqa: E501

        Lists the test results of the Account according to the method parameters. ___ *Sortable fields :*   - name   - project   - startDate   - qualityStatus   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tests_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str status: Returns only the test results with the specified status.
        :param str project: Project name. Returns only the test results of the specified project.
        :param str author: The author of the test result. Returns only the test results launched by the specified author.
        :param int limit: The maximum number of elements returned by this call. The maximum must be less than or equal to 200.
        :param int offset: The offset of the first element to return. Starting at this offset, the query will return a maximum of 'limit' elements.
        :param str sort: The key to sort the elements on. It may begin with a '+' or a '-' to specify an ascending or descending sort order. The list of available keys can be found in the endpoint description.
        :param str fields: Comma-separated list of fields to include in the json test result definition.
        :param bool pretty: If true the Json returned is human readable.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[TestDefinition], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['status', 'project', 'author', 'limit', 'offset', 'sort', 'fields', 'pretty']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tests" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] > 200:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `get_tests`, must be a value less than or equal to `200`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'status' in local_var_params and local_var_params['status'] is not None:  # noqa: E501
            query_params.append(('status', local_var_params['status']))  # noqa: E501
        if 'project' in local_var_params and local_var_params['project'] is not None:  # noqa: E501
            query_params.append(('project', local_var_params['project']))  # noqa: E501
        if 'author' in local_var_params and local_var_params['author'] is not None:  # noqa: E501
            query_params.append(('author', local_var_params['author']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if 'fields' in local_var_params and local_var_params['fields'] is not None:  # noqa: E501
            query_params.append(('fields', local_var_params['fields']))  # noqa: E501
        if 'pretty' in local_var_params and local_var_params['pretty'] is not None:  # noqa: E501
            query_params.append(('pretty', local_var_params['pretty']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['NeoloadAuthorizer']  # noqa: E501

        return self.api_client.call_api(
            '/tests', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[TestDefinition]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_test_monitors(self, test_id, monitor_post_request, **kwargs):  # noqa: E501
        """Create custom monitors  # noqa: E501

        Pushes monitoring data (external data) for a given running test. <br/><br/> <b>Resolution limitation</b>: <ul>   <li>Maximum resolution for a monitor value is <b>1 per second</b>, otherwise <b>the first value is kept</b>.</li> </ul> <b>Maximum paths and monitors</b>: <ul>   <li>Maximum 100 different <b>unique</b> paths.</li>   <li>Maximum 50 different monitors for a given path.</li>   <li>Maximum length is 10 for a path.</li> </ul> <b>Other requirements</b>: <ul>   <li>'/' character is not allowed in path element.</li>   <li>The test must be <b>running</b> while pushing the data.</li>   <li>For a given timestamp, all monitors relative to a path must be sent in the same request.</li>   <li>These elements must not be empty: <b>monitor name</b>, <b>a path element</b> and <b>values</b>.</li> </ul>   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_test_monitors(test_id, monitor_post_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str test_id: Unique identifier representing a specific test result. (required)
        :param MonitorPostRequest monitor_post_request: List of custom monitors (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.post_test_monitors_with_http_info(test_id, monitor_post_request, **kwargs)  # noqa: E501

    def post_test_monitors_with_http_info(self, test_id, monitor_post_request, **kwargs):  # noqa: E501
        """Create custom monitors  # noqa: E501

        Pushes monitoring data (external data) for a given running test. <br/><br/> <b>Resolution limitation</b>: <ul>   <li>Maximum resolution for a monitor value is <b>1 per second</b>, otherwise <b>the first value is kept</b>.</li> </ul> <b>Maximum paths and monitors</b>: <ul>   <li>Maximum 100 different <b>unique</b> paths.</li>   <li>Maximum 50 different monitors for a given path.</li>   <li>Maximum length is 10 for a path.</li> </ul> <b>Other requirements</b>: <ul>   <li>'/' character is not allowed in path element.</li>   <li>The test must be <b>running</b> while pushing the data.</li>   <li>For a given timestamp, all monitors relative to a path must be sent in the same request.</li>   <li>These elements must not be empty: <b>monitor name</b>, <b>a path element</b> and <b>values</b>.</li> </ul>   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_test_monitors_with_http_info(test_id, monitor_post_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str test_id: Unique identifier representing a specific test result. (required)
        :param MonitorPostRequest monitor_post_request: List of custom monitors (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['test_id', 'monitor_post_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_test_monitors" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'test_id' is set
        if self.api_client.client_side_validation and ('test_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['test_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `test_id` when calling `post_test_monitors`")  # noqa: E501
        # verify the required parameter 'monitor_post_request' is set
        if self.api_client.client_side_validation and ('monitor_post_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['monitor_post_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `monitor_post_request` when calling `post_test_monitors`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'test_id' in local_var_params:
            path_params['testId'] = local_var_params['test_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'monitor_post_request' in local_var_params:
            body_params = local_var_params['monitor_post_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['NeoloadAuthorizer']  # noqa: E501

        return self.api_client.call_api(
            '/tests/{testId}/monitors', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_test(self, test_id, test_update_request, **kwargs):  # noqa: E501
        """Update a test result  # noqa: E501

        Updates a test result with new name, description or quality status.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_test(test_id, test_update_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str test_id: Unique identifier representing a specific test result. (required)
        :param TestUpdateRequest test_update_request: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TestDefinition
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_test_with_http_info(test_id, test_update_request, **kwargs)  # noqa: E501

    def update_test_with_http_info(self, test_id, test_update_request, **kwargs):  # noqa: E501
        """Update a test result  # noqa: E501

        Updates a test result with new name, description or quality status.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_test_with_http_info(test_id, test_update_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str test_id: Unique identifier representing a specific test result. (required)
        :param TestUpdateRequest test_update_request: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TestDefinition, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['test_id', 'test_update_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_test" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'test_id' is set
        if self.api_client.client_side_validation and ('test_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['test_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `test_id` when calling `update_test`")  # noqa: E501
        # verify the required parameter 'test_update_request' is set
        if self.api_client.client_side_validation and ('test_update_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['test_update_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `test_update_request` when calling `update_test`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'test_id' in local_var_params:
            path_params['testId'] = local_var_params['test_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'test_update_request' in local_var_params:
            body_params = local_var_params['test_update_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['NeoloadAuthorizer']  # noqa: E501

        return self.api_client.call_api(
            '/tests/{testId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TestDefinition',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
