---
pretty_name: Evidence Infer Treatment
annotations_creators:
- expert-generated
language_creators:
- expert-generated
language:
- en
license:
- mit
multilinguality:
- monolingual
size_categories:
- 1K<n<10K
source_datasets:
- original
task_categories:
- text-retrieval
task_ids:
- fact-checking-retrieval
paperswithcode_id: null
---
# Dataset Card for Evidence Infer

## Table of Contents
- [Dataset Description](#dataset-description)
  - [Dataset Summary](#dataset-summary)
  - [Supported Tasks and Leaderboards](#supported-tasks-and-leaderboards)
  - [Languages](#languages)
- [Dataset Structure](#dataset-structure)
  - [Data Instances](#data-instances)
  - [Data Fields](#data-fields)
  - [Data Splits](#data-splits)
- [Dataset Creation](#dataset-creation)
  - [Curation Rationale](#curation-rationale)
  - [Source Data](#source-data)
  - [Annotations](#annotations)
  - [Personal and Sensitive Information](#personal-and-sensitive-information)
- [Considerations for Using the Data](#considerations-for-using-the-data)
  - [Social Impact of Dataset](#social-impact-of-dataset)
  - [Discussion of Biases](#discussion-of-biases)
  - [Other Known Limitations](#other-known-limitations)
- [Additional Information](#additional-information)
  - [Dataset Curators](#dataset-curators)
  - [Licensing Information](#licensing-information)
  - [Citation Information](#citation-information)
  - [Contributions](#contributions)

## Dataset Description

- **Homepage:** http://evidence-inference.ebm-nlp.com/
- **Repository:** https://github.com/jayded/evidence-inference
- **Paper:** [Evidence Inference 2.0: More Data, Better Models](https://arxiv.org/abs/2005.04177)
- **Leaderboard:** http://evidence-inference.ebm-nlp.com/leaderboard/
- **Point of Contact:** []()

### Dataset Summary

Data and code from our "Inferring Which Medical Treatments Work from Reports of Clinical Trials", NAACL 2019. This work concerns inferring the results reported in clinical trials from text.

The dataset consists of biomedical articles describing randomized control trials (RCTs) that compare multiple treatments. Each of these articles will have multiple questions, or 'prompts' associated with them. These prompts will ask about the relationship between an intervention and comparator with respect to an outcome, as reported in the trial. For example, a prompt may ask about the reported effects of aspirin as compared to placebo on the duration of headaches. For the sake of this task, we assume that a particular article will report that the intervention of interest either significantly increased, significantly decreased or had significant effect on the outcome, relative to the comparator.

The dataset could be used for automatic data extraction of the results of a given RCT. This would enable readers to discover the effectiveness of different treatments without needing to read the paper.

We have recently collected additional data for this task (https://arxiv.org/abs/2005.04177), which we will present at BioNLP 2020.

### Supported Tasks and Leaderboards

[More Information Needed]

### Languages

- English (`en`).

## Dataset Structure

### Data Instances

```
{'Text': "TITLE: Liraglutide, a once-daily human GLP-1 analogue, added to a sulphonylurea over 26 weeks produces greater improvements in glycaemic and weight control compared with adding rosiglitazone or placebo in subjects with Type 2 diabetes (LEAD-1 SU)\n\n  ABSTRACT.AIM:\nTo compare the effects of combining liraglutide (0.6, 1.2 or 1.8 mg/day) or rosiglitazone 4 mg/day (all n ≥ 228) or placebo (n = 114) with glimepiride (2–4 mg/day) on glycaemic control, body weight and safety in Type 2 diabetes.\n\nABSTRACT.METHODS:\nIn total, 1041 adults (mean ± sd), age 56 ± 10 years, weight 82 ± 17 kg and glycated haemoglobin (HbA1c) 8.4 ± 1.0% at 116 sites in 21 countries were stratified based on previous oral glucose-lowering mono : combination therapies (30 : 70%) to participate in a five-arm, 26-week, double-dummy, randomized study.\n\nABSTRACT.RESULTS:\nLiraglutide (1.2 or 1.8 mg) produced greater reductions in HbA1c from baseline, (−1.1%, baseline 8.5%) compared with placebo (+0.2%, P < 0.0001, baseline 8.4%) or rosiglitazone (−0.4%, P < 0.0001, baseline 8.4%) when added to glimepiride. Liraglutide 0.6 mg was less effective (−0.6%, baseline 8.4%). Fasting plasma glucose decreased by week 2, with a 1.6 mmol/l decrease from baseline at week 26 with liraglutide 1.2 mg (baseline 9.8 mmol/l) or 1.8 mg (baseline 9.7 mmol/l) compared with a 0.9 mmol/l increase (placebo, P < 0.0001, baseline 9.5 mmol/l) or 1.0 mmol/l decrease (rosiglitazone, P < 0.006, baseline 9.9 mmol/l). Decreases in postprandial plasma glucose from baseline were greater with liraglutide 1.2 or 1.8 mg [−2.5 to −2.7 mmol/l (baseline 12.9 mmol/l for both)] compared with placebo (−0.4 mmol/l, P < 0.0001, baseline 12.7 mmol/l) or rosiglitazone (−1.8 mmol/l, P < 0.05, baseline 13.0 mmol/l). Changes in body weight with liraglutide 1.8 mg (−0.2 kg, baseline 83.0 kg), 1.2 mg (+0.3 kg, baseline 80.0 kg) or placebo (−0.1 kg, baseline 81.9 kg) were less than with rosiglitazone (+2.1 kg, P < 0.0001, baseline 80.6 kg). Main adverse events for all treatments were minor hypoglycaemia (< 10%), nausea (< 11%), vomiting (< 5%) and diarrhoea (< 8%).\n\nABSTRACT.CONCLUSIONS:\nLiraglutide added to glimepiride was well tolerated and provided improved glycaemic control and favourable weight profile.\n\nBODY.INTRODUCTION:\nMost drugs that target Type 2 diabetes (T2D) also cause weight gain or hypoglycaemia, or both, with the risk increasing with combination therapy. Glucagon-like peptide-1 (GLP-1)-based therapies stimulate insulin secretion and reduce glucagon secretion only during hyperglycaemia. GLP-1 also slows gastric emptying and reduces appetite [1].  Although American Diabetes Association (ADA)/European Association for the Study of Diabetes (EASD) guidelines recommend lifestyle and metformin as initial therapy for T2D [2], sulphonylureas are used widely, particularly when metformin or thiazolidinediones are not tolerated. Glycaemic control eventually deteriorates with sulphonylureas while hypoglycaemia and weight gain are common [3]. Incretin therapy improves glycaemic control with low hypoglycaemic risk, while delayed gastric emptying and reduced appetite can reduce weight [1,4].  Liraglutide is a once-daily human GLP-1 analogue with 97% linear amino-acid sequence homology to human GLP-1 [5] and half-life of 13 h after subcutaneous administration that produces 24-h blood glucose control [6]. Liraglutide monotherapy for 14 weeks reduced glycated haemoglobin (HbA1c) by 1.7% and fasting plasma glucose (FPG) by 3.4 mmol/l without causing hypoglycaemia, along with weight loss (∼3 kg) compared with placebo [7]. Improvements in pancreatic B-cell function [7–9] and blood pressure [7], along with decreased glucagon secretion [7,10], also occurred. As part of the phase 3 programme [the Liraglutide Effect and Action in Diabetes (LEAD) programme] with liraglutide in > 4000 subjects with T2D as monotherapy or in combination therapy, this 26-week trial examined liraglutide plus glimepiride compared with either placebo or rosiglitazone added to glimepiride on glycaemic control and body weight.\n\nBODY.SUBJECTS AND METHODS.STUDY PARTICIPANTS:\nInclusion criteria: T2D treated with oral glucose-lowering agents (OGLAs) for ≥ 3 months; 18–80 years of age; HbA1c 7.0–11.0% (previous OGLA monotherapy) or 7.0–10.0% (previous OGLA combination therapy); body mass index (BMI) ≤ 45.0 kg/m2. Exclusion criteria: used insulin within 3 months, impaired liver or renal function, uncontrolled hypertension (≥ 180/100 mmHg), cancer or used any drugs apart from OGLAs likely to affect glucose concentrations. Subjects provided written informed consent. The study was conducted in accordance with good clinical practice guidelines and approved by independent ethics committees.\n\nBODY.SUBJECTS AND METHODS.STUDY DESIGN:\nThe study was a 26-week, double-blind, double-dummy, randomized, active-control, five-armed parallel (116 sites in 21 countries, primarily Europe and Asia) trial enrolling 1041 subjects (1–37 subjects per centre), all receiving glimepiride (2–4 mg/day) in combination with (Fig. 1):  FIGURE 1Overview of trial design and treatment arms.  one of three liraglutide doses [0.6, 1.2 or 1.8 mg, injected subcutaneously (Novo Nordisk, Bagsvaerd, Denmark) and rosiglitazone placebo];liraglutide placebo and rosiglitazone placebo;liraglutide placebo and rosiglitazone 4 mg/day (rosiglitazone; AvandiaTM; GlaxoSmithKline, London, UK).  The doses of rosiglitazone and glimepiride used were determined by the highest doses approved in all participating counties. After discontinuing previous OGLAs except glimepiride, separate 2-week titration and maintenance periods with glimepiride (open-label) preceded randomization (Fig. 1). Subjects were stratified according to previous treatment (monotherapy or combination therapy). After randomization, 2-week treatment titration and 24-week treatment (maintenance) phases (Fig. 1) were completed. Liraglutide was up-titrated weekly in 0.6-mg increments until allocated doses were reached. Glimepiride could be adjusted between 2 and 4 mg/day in case of hypoglycaemia or other adverse events (AEs), while other drug doses were fixed. Liraglutide (active and placebo) was supplied in 3-ml pre-filled pens with 31G needles (Novo Nordisk). Subjects were encouraged to inject liraglutide into the upper arm, thigh or abdomen at the same time each day. Rosiglitazone and glimepiride were taken in the morning or with the first meal.\n\nBODY.SUBJECTS AND METHODS.STUDY MEASUREMENTS.EFFICACY:\nThe primary endpoint was change from baseline HbA1c after 26 weeks of treatment. Secondary endpoints included: percentages of subjects reaching HbA1c (< 7.0%, ≤ 6.5%), FPG (5.0 to ≤ 7.2 mmol/l) and postprandial plasma glucose (PPG; 10.0 mmol/l) targets [11–13]; changes in body weight, FPG, mean PPG, indices of pancreatic B-cell function [pro-insulin : insulin ratio and homeostasis model assessment (HOMA)-B], HOMA-insulin resistance (HOMA-IR) and blood pressure (BP).  HbA1c was measured centrally (MDS Pharma Services, King of Prussia, PA, USA) by high performance liquid chromatography while plasma glucose (PG) was self-measured using MediSense® glucose meters (Abbott Diagnostics Inc., Abbott Park, IL, USA). Insulin and C-peptide were measured by chemiluminescence, proinsulin by ELISA, while glucagon was measured in aprotinin-treated plasma by radioimmunoassay. The proinsulin : insulin ratio was calculated from fasting insulin and fasting proinsulin. HOMA-B and HOMA-IR were both calculated from FPG and fasting insulin. Samples measured centrally were collected and transported according to detailed procedures in the MDS Pharma Services manual. Samples stored at ambient temperature were shipped by courier to the central laboratory on the same day as collection, while frozen samples were shipped every 3 weeks.\n\nBODY.SUBJECTS AND METHODS.STUDY MEASUREMENTS.SAFETY:\nSafety variables included hypoglycaemic episodes based on PG levels (< 3.1 mmol/l), liraglutide antibodies including cross-reacting and neutralizing antibodies, tolerability (gastrointestinal complaints) and pulse. AEs, vital signs, electrocardiogram (ECG), biochemical and haematology measures including calcitonin were also monitored. Self-treated hypoglycaemic episodes were classified as minor, while those requiring third-party assistance were considered major. Serum antibodies against liraglutide were measured by radioimmunoprecipitation assay.\n\nBODY.SUBJECTS AND METHODS.STATISTICAL ANALYSES:\nAll efficacy and safety analyses were based on intent-to-treat criteria, defined as subjects who were exposed to ≥ 1 dose of trial product(s). Efficacy endpoints were analysed by ancova with treatment, country and previous glucose-lowering treatment as fixed effects and baseline values as covariates. Missing data were imputed by last observation carried forward (LOCF). Sample size calculations were based on predicted HbA1c and body weight after trial completion. As the three liraglutide + glimepiride groups were to be compared with both rosiglitazone + glimepiride and glimepiride monotherapy, two calculations were performed. These sample size calculations assumed a standard deviation of 1.2% of HbA1c, the non-inferiority/superiority margin vs. active control was set to 0.4% and the difference to detect (superiority vs. placebo) was set to 0.5%. For body weight, a coefficient of variation of 3% (based on phase 2a trials for liraglutide) and a difference to detect of 3% were assumed. A combined power (calculated as the product of the marginal powers for HbA1c and body weight) of at least 85% was required. These calculations indicated that at least 168 and 81 patients completing the study would be needed for the combination and glimepiride monotherapy groups, respectively. Assuming a drop-out rate of 25%, targets for randomization were 228 in each of the combination therapy groups and 114 in the placebo group (total n = 1026).  To protect against Type 1 errors, HbA1c was analysed using hierarchical testing for descending doses of liraglutide. First, superiority of liraglutide 1.8 mg to placebo was tested and, only if superior to placebo, non-inferiority to rosiglitazone was tested. If non-inferiority was obtained, superiority to rosiglitazone for liraglutide 1.8 mg was tested and superiority to placebo for liraglutide 1.2 mg was tested. If superiority was confirmed, non-inferiority to rosiglitazone would be tested and so on (i.e. testing sequence was stopped when hypotheses could not be rejected). Superiority was concluded when upper limits of two-sided 95% confidence intervals (CIs) for treatment differences were below 0%; non-inferiority was concluded if these values were < 0.4%; for secondary endpoints, Type 1 errors were controlled by estimating simultaneous CIs using Dunnett's method.  Proportions of subjects achieving HbA1c (HbA1c < 7.0%, and ≤ 6.5%) and FPG (5.0 ≤ FPG ≤ 7.2 mmol/l) targets [13] were compared between treatments using logistic regression with allocated treatment and baseline values as covariates. Chi-square analyses assessed differences in treatments for percentages of subjects achieving no, one, two or three PPG values < 10 mmol/l [13]. Hypoglycaemic episodes were analysed under the assumption that number per subject were negatively binomially distributed using a generalized linear model, including treatment and country as fixed effects. Other safety data were compared by descriptive statistics. Values for descriptive statistics are expressed as means ± sd, while ancova results are expressed as least square means ± SEM or with 95% CI unless otherwise noted. Significance levels were set to 5% for two-sided tests and 2.5% for one-sided tests.\n\nBODY.RESULTS.DISPOSITION AND DEMOGRAPHICS:\nThe treatment groups were well balanced (Table 1). Of 1712 subjects screened, 1041 were randomized and 1040 were exposed to trial drugs; 147 subjects (14.1%) withdrew (Fig. 2). Withdrawals were higher with placebo (27%) and rosiglitazone treatment (16%) compared with liraglutide 0.6 mg (11%), liraglutide 1.2 mg (14%) and liraglutide 1.8 mg (9%) treatment. Thirty-eight subjects (3.7%) withdrew as a result of AEs (Fig. 2).   Table 1 Demographic characteristics of study participants Liraglutide 0.6 mg ( n  = 233) Liraglutide 1.2 mg ( n  = 228) Liraglutide 1.8 mg ( n  = 234) Placebo ( n  = 114) Rosiglitazone ( n  = 232) Male : female (%) 54 : 46 45 : 55 53 : 47 47 : 53 47 : 53 Age (years) 55.7 ± 9.9 57.7 ± 9.0 55.6 ± 10.0 54.7 ± 10.0 56.0 ± 9.8 Duration of diabetes (years) 6.5 (4.0,10.2) 6.7 (4.0,10.7) 6.5 (3.7,10.5) 6.5 (4.5,10.6) 6.6 (4.3,10.7) Previous on mono : combi (%) 30 : 70 31 : 69 27 : 73 32 : 68 32 : 68 FPG (mmol/l) 10.0 ± 2.4 9.8 ± 2.7 9.7 ± 2.4 9.5 ± 2.0 9.9 ± 2.5 HbA 1c  (%) 8.4 ± 1.0 8.5 ± 1.1 8.5 ± 0.9 8.4 ± 1.0 8.4 ± 1.0 Diabetic retinopathy (%) 17.2 14.9 12.0 13.2 16.4 Hypertension (%) 69.1 68.0 69.7 64.9 66.8 BMI (kg/m 2 ) 30.0 ± 5.0 29.8 ± 5.1 30.0 ± 5.1 30.3 ± 5.4 29.4 ± 4.8 Weight (kg) 82.6 ± 17.7 80.0 ± 17.1 83.0 ± 18.1 81.9 ± 17.1 80.6 ± 17.0 Systolic blood pressure (mmHg) 131 ± 16 133 ± 15 132 ± 16 131 ± 15.3 133 ± 15 Data are mean ±  sd  and percentages, except for duration of diabetes, where data are median, 25th and 75th percentile. BMI, body mass index; FPG, fasting plasma glucose; HbA 1c , glycated haemoglobin; mono : combi, previous treatment with either monotherapy or combination therapy;  sd , standard deviation.   FIGURE 2Flow of patients through the study.\n\nBODY.RESULTS.EFFICACY.HBA:\nHbA1c decreased rapidly with all doses of liraglutide when added to glimepiride compared with either rosiglitazone or placebo (i.e. glimepiride monotherapy), irrespective of previous therapy. The greatest decreases occurred with liraglutide 1.2 and 1.8 mg (Fig. 3a–c). After 26 weeks, HbA1c decreased by 1.1% from baseline (primary endpoint) with either liraglutide 1.2 or 1.8 mg, respectively, compared with either placebo (+0.2%) or rosiglitazone (−0.4%) (Fig. 3d). Estimated treatment differences and 95% CIs to placebo were: liraglutide 1.8 mg: −1.4% (1.6, −1.1); liraglutide 1.2 mg: −1.3% (1.5, −1.1); liraglutide 0.6 mg: −0.8% (−1.1, −0.6); rosiglitazone: −0.7% (−0.9, −0.4). All liraglutide doses were superior to placebo (P < 0.0001), while the two higher liraglutide doses were superior to rosiglitazone (P < 0.0001). Liraglutide 0.6 mg was non-inferior to rosiglitazone. Rosiglitazone also was superior to placebo (P < 0.0001).  FIGURE 3Mean glycated haemoglobin (HbA1c) by treatment and week (intent-to-treat population with last observation carried forward): (a) overall population; (b) previously on monotherapy; or (c) previously on combination therapy; (d) mean changes in HbA1c from baseline after 26 weeks of treatment. Keys: (a–c) liraglutide 0.6 mg: grey dotted line with squares; liraglutide 1.2 mg: black solid line with triangles; liraglutide 1.8 mg: black dotted line with squares; rosiglitazone: grey solid line with circles; placebo: black solid line with circles. (d) liraglutide 0.6 mg: black stripes on white; liraglutide 1.2 mg: white stripes on black, liraglutide 1.8 mg: grey tint; rosiglitazone: white; placebo: black. ****P < 0.0001 compared with placebo; ††††P < 0.0001 compared with rosiglitazone.  HbA1c decreases were greater for subjects who entered from monotherapy compared with combination therapy (Fig. 3d). However, because the increase with placebo was higher for individuals entering on combination therapy (0.7 vs. 0.23%), the differences between treatment groups in favour of liraglutide were similar irrespective of whether subjects were treated previously with monotherapy or combination therapy. Neither age, gender nor BMI affected these trends.\n\nBODY.RESULTS.EFFICACY.PERCENTAGE REACHING AN HBA:\nThe percentage of subjects reaching ADA [2] and International Diabetes Federation (IDF)/American Association of Clinical Endocrinologists (AACE) [11,12] treatment HbA1c goals with liraglutide was dose dependent (Fig. 4). At week 26, 42% and 21% of subjects treated with liraglutide 1.8 mg reached an HbA1c < 7.0% and ≤ 6.5%, respectively, compared with 8% and 4% for placebo (Fig. 4). The estimated proportion of subjects treated with either liraglutide 1.2 or 1.8 mg reaching ADA/EASD and IDF/AACE HbA1c targets was substantially greater compared with either placebo (P < 0.0001) or rosiglitazone (Fig. 4; P ≤ 0.0003), with more patients reaching < 7.0% with liraglutide 1.8 mg compared with 1.2 mg (P = 0.018).  FIGURE 4Subjects achieving specified glycated haemoglobin (HbA1c) levels: (a) percentage reaching HbA1c < 7.0% (American Diabetes Association/European Association for the Study of Diabetes target); (b) percentage reaching HbA1c < 6.5% (International Diabetes Federation/American Association of Clinical Endocrinologists targets); (c) cumulative distribution of HbA1c at 26 weeks for the intent-to-treat (ITT) population; and (d) for the ITT last observation carried forward (LOCF) population. Keys: (a, b) liraglutide 0.6 mg: black stripes on white; liraglutide 1.2 mg: white stripes on black, liraglutide 1.8 mg: grey tint; rosiglitazone: white; placebo: black. (c, d) liraglutide 0.6 mg: pale grey solid line; liraglutide 1.2 mg: grey solid line, liraglutide 1.8 mg: black solid line; rosiglitazone: dotted black line; placebo: dotted grey line; baseline visit: long dashed black line. ****P < 0.0001 or **P < 0.01 compared with placebo; ††††P < 0.0001 or †††P = 0.0005 compared with rosiglitazone.\n\nBODY.RESULTS.EFFICACY.FASTING PLASMA GLUCOSE:\nBy week 2, subjects treated with liraglutide had rapid and larger decreases in FPG vs. comparator treatment. At week 26, all doses of liraglutide decreased FPG more than did placebo (Fig. 5; P < 0.0001), while only liraglutide 1.2 or 1.8 mg produced greater reductions than rosiglitazone. FPG treatment differences to placebo were 1.7 mmol/l for liraglutide 0.6 mg and 2.6 mmol/l for both liraglutide 1.2 and 1.8 mg. An 0.7-mmol/l greater reduction in FPG was achieved with either liraglutide 1.2 or 1.8 mg compared with rosiglitazone (P ≤ 0.006) after 26 weeks.  FIGURE 5Mean changes from baseline in fasting plasma glucose after 26 weeks of treatment. ****P < 0.0001 compared with placebo; ††P < 0.01 compared with rosiglitazone.  The percentage of subjects achieving FPG values between 5.0 mmol/l and ≤ 7.2 mmol/l (ADA target) after 26 weeks was higher with liraglutide: 0.6 mg (19%; P = 0.002); 1.2 mg (37%; P < 0.001); and 1.8 mg (38%;P < 0.001) compared with placebo (7%). The liraglutide 1.2 and 1.8 mg treatment groups also had more subjects achieving the same FPG target at end of treatment compared with rosiglitazone (26%) (P = 0.007 and P = 0.01, respectively).\n\nBODY.RESULTS.EFFICACY.POSTPRANDIAL PLASMA GLUCOSE:\nPPG was reduced similarly after each meal. The greatest reductions in mean PPG values from baseline (average of values obtained 90 min after breakfast, lunch and evening meal) occurred with liraglutide 1.2 mg (2.5 mmol/l) and liraglutide 1.8 mg (2.7 mmol/l). By comparison, the reduction from baseline in mean PPG values was 1.8 mmol/l for rosiglitazone and liraglutide 0.6 mg and 0.4 mmol/l for placebo. Treatment differences for PPG were greater with all doses of liraglutide compared with placebo (1.5–2.4 mmol/l; P < 0.0001) and greater with liraglutide 1.2 mg (0.64 mmol/l; P = 0.043) and 1.8 mg (0.87 mmol/l;P = 0.0022) compared with rosiglitazone.\n\nBODY.RESULTS.EFFICACY.PPG MEASUREMENTS < 10.0 MMOL/L:\nThe percentage of subjects with one, two or three PPG measurements < 10.0 mmol/l (ADA target) were greater for all doses of liraglutide compared with placebo (P < 0.05) but not rosiglitazone.\n\nBODY.RESULTS.BODY WEIGHT:\nMean weight at baseline was 81.6 kg. Mean reductions in weight from baseline to end of treatment were 0.2 kg with liraglutide 1.8 mg and 0.1 kg with placebo treatment, while increases occurred with either liraglutide 0.6 mg (0.7 kg), liraglutide 1.2 mg (0.3 kg) or rosiglitazone (2.1 kg) (Fig. 6). Unlike rosiglitazone, weight did not increase substantially with liraglutide and the differences between rosiglitazone and liraglutide were statistically significant (−2.3 to −1.4 kg; P < 0.0001), although there were no significant differences compared with placebo. Gender appeared to have no influence on the results, as indicated when added as a fixed effect in the ancova model.  FIGURE 6Mean changes in body weight from baseline after 26 weeks of treatment. *P < 0.05 compared with placebo; ††††P < 0.0001 compared with rosiglitazone.\n\nBODY.RESULTS.INDICES OF PANCREATIC B-CELL FUNCTION AND INSULIN RESISTANCE:\nReductions in the proinsulin : insulin ratio were greater with both liraglutide 1.2 and 1.8 mg compared with either rosiglitazone or placebo (Table 2; P ≤ 0.02). HOMA-B increased with liraglutide (1.8 or 1.2 mg) compared with rosiglitazone (P < 0.05), while this increase was only different to placebo with liraglutide 1.2 mg (P = 0.01) and not liraglutide 1.8 mg (P = 0.051). There were no significant differences between treatments for HOMA-IR.   Table 2 Selected indices of pancreatic B-cell function Variable Treatment Baseline Week 26 (LOCF) Least square difference from placebo (95% CI) Least square difference from rosiglitazone (95% CI) Proinsulin : insulin ratio Liraglutide 0.6 mg 0.42 ± 0.22 0.38 ± 0.24 −0.05 (−0.11; 0.00) −0.02 (−0.06; 0.03) Liraglutide 1.2 mg 0.45 ± 0.31 0.33 ± 0.20 −0.10 (−0.16; −0.05) † −0.07 (−0.11; −0.02) * Liraglutide 1.8 mg 0.48 ± 0.33 0.36 ± 0.20 −0.09 (−0.15; −0.03) * −0.05 (−0.10; −0.01) * Placebo 0.44 ± 0.27 0.46 ± 0.29 Rosiglitazone 0.45 ± 0.29 0.40 ± 0.20 HOMA-B (%) Liraglutide 0.6 mg 51 ± 43.3 70 ± 88.6 15 (−19.10; 49.0) 11 (−16.7; 39.0) Liraglutide 1.2 mg 71 ± 254.3 99 ± 184.3 43 (8.10; 76.9) * 39 (10.3; 67.0) * Liraglutide 1.8 mg 56 ± 84.6 91 ± 108.2 34 (−0.23; 68.5) 30 (2.00; 58.6) * Placebo 56 ± 103.3 52 ± 107.3 Rosiglitazone 46 ± 36.2 59 ± 63.3 * P ≤ 0.05; † P  < 0.0001. CI, confidence interval; HOMA, homeostatis model assessment; LOCF, last observation carried forward. \n\nBODY.RESULTS.BLOOD PRESSURE AND PULSE:\nAlthough decreases in systolic blood pressure occurred with either liraglutide 1.2 or 1.8 mg (2.6–2.8 mmHg), they were not significantly different from placebo or rosiglitazone (0.9–2.3 mmHg). Reductions in diastolic blood pressure also occurred with all treatments (0.7–1.4 mmHg), with no significant differences between treatments. Pulse increases above baseline ranged from 2 to 4 beats/min with the three doses of liraglutide and 1 beat/min with rosiglitazone, while pulse decreased by 1 beat/min with placebo. Changes in pulse for all doses of liraglutide were significant vs. placebo (P ≤ 0.002). This also was true with either liraglutide 1.8 or 1.2 mg compared with rosiglitazone (P < 0.01).\n\nBODY.RESULTS.SAFETY:\nThe most common treatment-emergent AEs that were considered by investigators to be either possibly or probably related to liraglutide were gastrointestinal (diarrhoea, nausea, dyspepsia and constipation) and nervous system disorders (headache and dizziness), particularly during the first 4 weeks. Nausea was highest with liraglutide 1.2 mg (10.5%) and lowest with placebo (1.8%). Vomiting (4.4%) and diarrhoea (7.9%) were also higher with liraglutide 1.2 mg. Withdrawals because of nausea ranged from 0.9–2.2%, vomiting 0.4–0.9% and diarrhoea 0–1.3%.  Nausea was more common with liraglutide compared with placebo and rosiglitazone, particularly during the first 4 weeks (Fig. 7). Frequency of nausea was less in the liraglutide 0.6 mg treatment group compared with the higher doses of liraglutide. Generally, the occurrence of nausea dissipated from 4 to 26 weeks of treatment in all groups using liraglutide (Fig. 7).  FIGURE 7Percentage of subjects experiencing nausea over the course of the study. Key: liraglutide 0.6 mg with glimepiride: black line with filled circles; liraglutide 1.2 mg with glimepiride: black line with filled triangles; liraglutide 1.8 mg with glimepiride: grey line with hollow circles; glimepiride grey lines with filled squares; rosiglitazone and glimepiride: grey line with hollow triangles.  The incidence of serious AEs ranged between 3 and 5%: placebo (3%), rosiglitazone (3%), liraglutide 0.6 mg (3%), liraglutide 1.2 mg (4%) and liraglutide 1.8 mg (5%). Most treatment-emergent serious AEs were judged by investigators to be unlikely to be related to trial products. No deaths were reported during the trial. One subject developed chronic pancreatitis whilst taking liraglutide 0.6 mg; the person had no reported previous history of pancreatitis. The subject continued on liraglutide therapy and completed the trial. At screening, five patients had been previously diagnosed with pancreatitis. As pancreatitis was not an exclusion criterion, these patients were randomized as follows: one to liraglutide 0.6 mg, one to liraglutide 1.2 mg, two to liraglutide 1.8 mg and one to rosiglitazone + glimepiride. All five patients completed the trial without reporting pancreatitis as an adverse event.  Hypoglycaemia was infrequent with all treatments. One major hypoglycaemic episode (self-measured blood glucose = 3.0 mmol/l) occurred 9 days after treatment started in a subject receiving liraglutide 1.8 mg in combination with glimepiride. Although medical assistance was not needed, the subject required third-party assistance. The investigator judged the episode as likely to be related to glimepiride and reduced the dose from 4 to 3 mg after the incident.  Minor hypoglycaemia occurred in < 10% of subjects for any treatment. The proportion of subjects experiencing minor hypoglycaemia during the trial was lowest with placebo (i.e. glimepiride monotherapy 2.6%; 0.17 events/subject-year), comparable with liraglutide 0.6 mg (5.2%, 0.17 events/subject-year) and rosiglitazone (4.3%, 0.12 events/subject-year) groups and similar between the liraglutide 1.2 mg (9.2%, 0.51 events/subject-year) and liraglutide 1.8 mg (8.1%, 0.47 events/subject-year) treatment groups. Incidence was higher with liraglutide 1.2 mg (P = 0.0024) and 1.8 mg (P = 0.0065) compared with rosiglitazone and liraglutide 1.2 mg compared with placebo (P = 0.048), occurring in the setting of lower mean HbA1c values.  Antibodies to liraglutide were found in 9–13% of subjects treated with liraglutide. No significant effects of these antibodies on HbA1c were found in pooled analyses of four trials including the current study. There were no clinically relevant changes in ophthalmoscopy, biochemistry, urinalysis, haematology or ECG assessments. No significant differences in calcitonin were found between the three groups treated with liraglutide when compared with either placebo or rosiglitazone at the end of the trial at week 26.\n\nBODY.DISCUSSION:\nTreatment with liraglutide plus glimepiride was superior to glimepiride monotherapy at all doses of liraglutide and superior to rosiglitazone plus glimepiride for the two higher liraglutide doses for improving HbA1c. Similar findings for reductions in FPG and PPG highlight improved 24-h glucose control with once-daily liraglutide, with substantially more subjects reaching glycaemic targets, particularly with liraglutide 1.8 mg. Improvements in pancreatic B-cell function were larger with liraglutide 1.2 and 1.8 mg compared with rosiglitazone. Liraglutide was well tolerated and occurrence of gastrointestinal AEs was low overall, particularly after week 4.  Although rates of hypoglycaemia were low in all treatment groups (< 10%), minor hypoglycaemic events occurred more often in patients treated with glimepiride plus liraglutide 1.2 or 1.8 mg than with glimepiride alone. It should be noted, however, that patients treated with liraglutide 1.2 or 1.8 mg achieved a lower HbA1c than those receiving glimepiride monotherapy. At lower HbA1c levels, sulphonylureas are known to elicit hypoglycaemia more readily than at higher levels. In clinical practice it may be possible to reduce the dose of sulphonylurea (when used with liraglutide) to minimize risk of hypoglycaemia and maintain HbA1cimprovements.  Although weight effects were modest, liraglutide produced more favourable weight effects compared with rosiglitazone, which produced substantial weight gain. In other studies with liraglutide, subjects adding a 1.8-mg dose to metformin lost 2.8 kg [14], while those adding both metformin and glimepiride lost 1.8 kg compared with placebo [15] (both over 26 weeks) and those on liraglutide monotherapy (1.8 mg) lost 2.45 kg over 52 weeks [16]. In our study, because sulphonylureas usually cause weight gain, inclusion or optimization of glimepiride but not metformin may have mitigated the weight benefits typically associated with liraglutide. Lack of weight effects could be secondary to lower baseline body weight, withdrawal of previous metformin treatment or defensive snacking to minimize risk of hypoglycaemia.  It might have been expected that the greater weight gain with rosiglitazone compared with liraglutide 1.8 mg would be associated with a concurrent increase in insulin resistance with rosiglitazone. The absence of this effect could reflect the insulin-sensitizing nature of rosiglitazone. Improvements in pancreatic B-cell function associated with liraglutide are consistent with other studies [7–9].  Study strengths include inclusion of both placebo and active (rosiglitazone) comparators and that OGLAs were optimized (not maximized) before randomization to minimize risk of hypoglycaemia. Limitations of the study include short duration of the trial and restriction on glimepiride and rosiglitazone in some countries that precluded maximal dosing.  The impact of using other GLP-1-based treatments [such as exenatide, or the dipeptidyl peptidase-4 (DPP-4) inhibitor, sitagliptin] with sulphonylureas in subjects with T2D has been studied. In a 30-week American trial where exenatide twice a day was added to sulphonylureas, HbA1c was reduced by 0.46% from baseline with 5 μg and 0.86% with 10 μg [17] compared with 1.1% with liraglutide 1.8 or 1.2 mg. This reduction in HbA1c with liraglutide is consistent with other LEAD trials investigating liraglutide as monotherapy or in combination with various OGLA drugs. In these trials, HbA1c was reduced by 1–1.5%[14,16,18–20]. Reductions in FPG with exenatide were 0.3 and 0.6 mmol/l from baseline with 5 μg and 10 μg, respectively, compared with 1.4 mmol/l with liraglutide 1.8 mg; weight loss of 1.6 kg occurred with exenatide 10 μg compared with 0.2 kg for liraglutide 1.8 mg [17]. Differences in weight effects may be as a result of lower baseline weight in this trial (82 kg) compared with exenatide (96 kg) and discontinuation of previous metformin therapy, unlike the exenatide trial where exenatide was added to previous sulphonylurea monotherapy [17]. Other large-scale trials with liraglutide in combination with sulphonylureas have demonstrated weight loss of 2–3 kg [18,20]. Withdrawals from exenatide trials ranged from 24–30% compared with 9–14% with liraglutide in this study. Nausea with exenatide ranged from 39% with 5 μg to 51% with 10 μg [17] compared with 10.5% for liraglutide. Furthermore, 41% were positive for anti-exenatide antibodies compared with 9–13% with anti-liraglutide antibodies.  With sitagliptin 100 mg once daily for 24 weeks, HbA1c decreased by 0.3% from baseline in subjects receiving glimepiride, with 11% achieving an HbA1c < 7.0%[21]. Reductions in FPG and PPG from baseline were 0.05 and 1.4 mmol/l, respectively, while weight increased by 0.8 kg and the prevalence of nausea was < 1%.  Although head-to-head trials are required to test true differences between these agents, the marked effects of liraglutide on FPG may be as a result of consistent blood levels of liraglutide maintained over 24 h compared with exenatide which has to be administered 60 min before breakfast and dinner and has a half-life of 1.5–3.6 h [22]. In a recent 26-week head-to-head trial comparing liraglutide with exenatide, liraglutide produced a 0.3% greater decrease on HbA1c (P < 0.0001) [20]. Because DPP-4 inhibitors inhibit the degradation of GLP-1, the efficacy of sitagliptin is dependent on levels of endogenous GLP-1 which is physiologically low compared with the much higher pharmacological levels of liraglutide. Pharmacological levels may be needed to induce satiety, weight loss and possibly larger HbA1c reductions.  Liraglutide is an effective and well-tolerated once-daily human GLP-1 analogue that improves overall glycaemic control and indices of pancreatic B-cell function with minimal weight gain and risk of hypoglycaemia when used in combination with a sulphonylurea for T2D.\n\nBODY.COMPETING INTERESTS:\nThe study was funded by Novo Nordisk, the manufacturer of liraglutide. In collaboration with the investigators, Novo Nordisk was responsible for the study design, protocol, statistical analysis plans, oversight, analysis and reporting of the results. Data were recorded at the clinical centres and maintained by the sponsor. The LEAD-1 SU study group had full access to the data. Final responsibility for the decision to submit the manuscript for publication was the authors. MM has received lecture fees from Novo Nordisk, Servier, MSD; JS has received honoraria, grants and lecture fees from Novo Nordisk; MB, WMWB and NAK have no conflicts to declare; JS has received lecture fees from Novo Nordisk; MZ is employed by, and holds stock in, Novo Nordisk; TLT is employed by Novo Nordisk; SC is a member of the international advisory board on liraglutide for Novo Nordisk and has received lecture fees from Novo Nordisk.",
 'PMCID': 2871176,
 'Prompts': {'PromptID': [150,
   113,
   140,
   106,
   142,
   149,
   148,
   152,
   154,
   125,
   121,
   124,
   107,
   105,
   133,
   103,
   126,
   118,
   132,
   122,
   141,
   151,
   112,
   153,
   102,
   129,
   104,
   116,
   136,
   123,
   135,
   139,
   101,
   99,
   144,
   145,
   147,
   117,
   143,
   111,
   137,
   114,
   108,
   128,
   134,
   115,
   127,
   131,
   109,
   146,
   110,
   100,
   138,
   119,
   130],
  'PMCID': [2871176,
   2871176,
   2871176,
   2871176,
   2871176,
   2871176,
   2871176,
   2871176,
   2871176,
   2871176,
   2871176,
   2871176,
   2871176,
   2871176,
   2871176,
   2871176,
   2871176,
   2871176,
   2871176,
   2871176,
   2871176,
   2871176,
   2871176,
   2871176,
   2871176,
   2871176,
   2871176,
   2871176,
   2871176,
   2871176,
   2871176,
   2871176,
   2871176,
   2871176,
   2871176,
   2871176,
   2871176,
   2871176,
   2871176,
   2871176,
   2871176,
   2871176,
   2871176,
   2871176,
   2871176,
   2871176,
   2871176,
   2871176,
   2871176,
   2871176,
   2871176,
   2871176,
   2871176,
   2871176,
   2871176],
  'Outcome': ['Incidence of minor hypoglycaemia',
   'Patients reaching HbA1c goals less than 7.0% and equal or less than 6.5%',
   'HOMA-IR',
   'HbA1c level at 26 weeks',
   'Reductions in systolic blood pressure',
   'Pulse variations',
   'Pulse variations',
   'Incidence of minor hypoglycaemia',
   'Changes in calcitonin at week 26',
   'Postprandial plasma glucose',
   'ADA fasting plasma glucose goals between 5.0 mmol/l and less than 7.2 mmol/l',
   'Postprandial plasma glucose',
   'HbA1c level at 26 weeks',
   'HbA1c level at 26 weeks',
   'Proinsulin : insulin ratio',
   'Postprandial plasma glucose',
   'ADA postprandial plasma glucose goals less than 10.0 mmol/l',
   'ADA fasting plasma glucose goals between 5.0 mmol/l and less than 7.2 mmol/l',
   'Proinsulin : insulin ratio',
   'ADA fasting plasma glucose goals between 5.0 mmol/l and less than 7.2 mmol/l',
   'Reductions in systolic blood pressure',
   'Incidence of minor hypoglycaemia',
   'Patients reaching HbA1c goals less than 7.0% and equal or less than 6.5%',
   'Changes in calcitonin at week 26',
   'Fasting plasma glucose at week 26',
   'ADA postprandial plasma glucose goals less than 10.0 mmol/l',
   'Postprandial plasma glucose',
   'Fasting plasma glucose at week 26',
   'HOMA-B',
   'Postprandial plasma glucose',
   'HOMA-B',
   'HOMA-IR',
   'Fasting plasma glucose at week 26',
   'HbA1c level at 26 weeks',
   'Reductions in systolic blood pressure',
   'Decreases in diastolic blood pressure',
   'Pulse variations',
   'Fasting plasma glucose at week 26',
   'Reductions in systolic blood pressure',
   'Patients reaching HbA1c goals less than 7.0% and equal or less than 6.5%',
   'HOMA-B',
   'Patients reaching HbA1c goals less than 7.0% ',
   'HbA1c level at 26 weeks',
   'ADA postprandial plasma glucose goals less than 10.0 mmol/l',
   'Proinsulin : insulin ratio',
   'Fasting plasma glucose at week 26',
   'ADA postprandial plasma glucose goals less than 10.0 mmol/l',
   'Proinsulin : insulin ratio',
   'HbA1c level at 26 weeks',
   'Decreases in diastolic blood pressure',
   'Patients reaching HbA1c goals less than 7.0% and equal or less than 6.5%',
   'HbA1c level at 26 weeks',
   'HOMA-B',
   'ADA fasting plasma glucose goals between 5.0 mmol/l and less than 7.2 mmol/l',
   'Weight gain'],
  'Intervention': ['Liraglutide (1.2 mg) plus glimepiride',
   'Liraglutide (1.8 mg) plus glimepiride',
   'Liraglutide (all doses) plus glimepiride',
   'Liraglutide (0.6 mg) plus glimepiride',
   'Liraglutide (1.8 mg) plus glimepiride ',
   'Liraglutide (1.8 mg) plus glimepiride',
   'Liraglutide (1.2 mg) plus glimepiride',
   'Liraglutide (1.2 mg) plus glimepiride',
   'Liraglutide (all doses) plus glimepiride',
   'Liraglutide (1.8 mg) plus glimepiride',
   'Liraglutide (1.2 mg) plus glimepiride',
   'Liraglutide (0.6 mg) plus glimepiride',
   'Liraglutide (1.8 mg) plus glimepiride',
   'Liraglutide (1.8 mg) plus glimepiride',
   'Liraglutide (1.8 mg) plus glimepiride ',
   'Liraglutide (1.2 mg) plus glimepiride',
   'Liraglutide (0.6 mg) plus glimepiride',
   'Liraglutide (0.6 mg) plus glimepiride',
   'Liraglutide (1.2 mg) plus glimepiride ',
   'Liraglutide (1.8 mg) plus glimepiride',
   'Liraglutide (1.2 mg) plus glimepiride ',
   'Liraglutide (1.8 mg) plus glimepiride',
   'Liraglutide (1.2 mg) plus glimepiride',
   'Liraglutide (all doses) plus glimepiride',
   'Liraglutide (1.2 mg) plus glimepiride',
   'Liraglutide (all doses) plus glimepiride',
   'Liraglutide (1.2 mg) plus glimepiride',
   'Liraglutide (0.6 mg) plus glimepiride',
   'Liraglutide (1.8 mg) plus glimepiride ',
   'Liraglutide (1.8 mg) plus glimepiride',
   'Liraglutide (1.2 mg) plus glimepiride ',
   'Liraglutide (all doses) plus glimepiride',
   'Liraglutide (1.2 mg) plus glimepiride',
   'Liraglutide (1.2 mg) plus glimepiride',
   'Liraglutide (1.8 mg) plus glimepiride ',
   'Liraglutide (all doses) plus glimepiride',
   'Liraglutide (all doses) plus glimepiride',
   'Liraglutide (1.8 mg) plus glimepiride',
   'Liraglutide (1.2 mg) plus glimepiride ',
   'Liraglutide (1.8 mg) plus glimepiride',
   'Liraglutide (1.2 mg) plus glimepiride ',
   'Liraglutide (1.8 mg) plus glimepiride',
   'Liraglutide (0.6 mg) plus glimepiride',
   'Liraglutide (1.8 mg) plus glimepiride',
   'Liraglutide (1.8 mg) plus glimepiride ',
   'Liraglutide (1.8 mg) plus glimepiride',
   'Liraglutide (1.2 mg) plus glimepiride',
   'Liraglutide (1.2 mg) plus glimepiride ',
   'Rosiglitazone plus glimepiride',
   'Liraglutide (all doses) plus glimepiride',
   'Liraglutide (1.2 mg) plus glimepiride',
   'Liraglutide (1.2 mg) plus glimepiride',
   'Liraglutide (1.8 mg) plus glimepiride ',
   'Liraglutide (1.2 mg) plus glimepiride',
   'Rosiglitazone plus glimepiride'],
  'Comparator': ['Rosiglitazone plus glimepiride',
   'Rosiglitazone plus glimepiride',
   'Rosiglitazone plus glimepiride',
   'Placebo plus glimepiride',
   'Placebo plus glimepiride ',
   'Rosiglitazone plus glimepiride',
   'Rosiglitazone plus glimepiride',
   'Placebo plus glimepiride',
   'Placebo plus glimepiride',
   'Rosiglitazone plus glimepiride',
   'Rosiglitazone plus glimepiride',
   'Placebo plus glimepiride',
   'Rosiglitazone plus glimepiride',
   'Placebo plus glimepiride',
   'Rosiglitazone plus glimepiride ',
   'Placebo plus glimepiride',
   'Placebo plus glimepiride',
   'Placebo plus glimepiride',
   'Placebo plus glimepiride ',
   'Rosiglitazone plus glimepiride',
   'Placebo plus glimepiride ',
   'Rosiglitazone plus glimepiride',
   'Rosiglitazone plus glimepiride',
   'Rosiglitazone plus glimepiride',
   'Rosiglitazone plus glimepiride',
   'Rosiglitazone plus glimepiride',
   'Rosiglitazone plus glimepiride',
   'Placebo plus glimepiride',
   'Rosiglitazone plus glimepiride ',
   'Placebo plus glimepiride',
   'Rosiglitazone plus glimepiride ',
   'Placebo plus glimepiride',
   'Placebo plus glimepiride',
   'Placebo plus glimepiride',
   'Rosiglitazone plus glimepiride ',
   'Placebo plus glimepiride',
   'Placebo plus glimepiride',
   'Rosiglitazone plus glimepiride',
   'Rosiglitazone plus glimepiride ',
   'Placebo plus glimepiride',
   'Placebo plus glimepiride ',
   'Liraglutide (1.2 mg) plus glimepiride',
   'Rosiglitazone plus glimepiride',
   'Placebo plus glimepiride',
   'Placebo plus glimepiride ',
   'Placebo plus glimepiride',
   'Placebo plus glimepiride',
   'Rosiglitazone plus glimepiride ',
   'Placebo plus glimepiride',
   'Rosiglitazone plus glimepiride',
   'Placebo plus glimepiride',
   'Rosiglitazone plus glimepiride',
   'Placebo plus glimepiride ',
   'Placebo plus glimepiride',
   'Liraglutide plus glimepiride'],
  'Annotations': [{'UserID': [0, 3, 2],
    'PromptID': [150, 150, 150],
    'PMCID': [2871176, 2871176, 2871176],
    'Valid Label': [True, True, True],
    'Valid Reasoning': [True, True, True],
    'Label': ['significantly increased',
     'significantly increased',
     'significantly increased'],
    'Annotations': ['The proportion of subjects experiencing minor hypoglycaemia during the trial was lowest with placebo (i.e. glimepiride monotherapy 2.6%; 0.17 events/subject-year), comparable with liraglutide 0.6 mg (5.2%, 0.17 events/subject-year) and rosiglitazone (4.3%, 0.12 events/subject-year) groups and similar between the liraglutide 1.2 mg (9.2%, 0.51 events/subject-year) and liraglutide 1.8 mg (8.1%, 0.47 events/subject-year) treatment groups. Incidence was higher with liraglutide 1.2 mg (P = 0.0024) and 1.8 mg (P = 0.0065) compared with rosiglitazone and liraglutide 1.2 mg compared with placebo (P = 0.048), occurring in the setting of lower mean HbA1c values.',
     'Incidence was higher with liraglutide 1.2 mg (P = 0.0024) and 1.8 mg (P = 0.0065) compared with rosiglitazone',
     'Incidence was higher with liraglutide 1.2 mg (P = 0.0024) and 1.8 mg (P = 0.0065) compared with rosiglitazone and liraglutide 1.2 mg compared with placebo (P = 0.048), occurring in the setting of lower mean HbA1c values.'],
    'Label Code': [1, 1, 1],
    'In Abstract': [True, True, True],
    'Evidence Start': [25524, 25964, 25964],
    'Evidence End': [26184, 26073, 26184]},
   {'UserID': [0, 1, 3, 2],
    'PromptID': [113, 113, 113, 113],
    'PMCID': [2871176, 2871176, 2871176, 2871176],
    'Valid Label': [True, True, True, True],
    'Valid Reasoning': [True, True, True, True],
    'Label': ['significantly increased',
     'significantly increased',
     'significantly increased',
     'significantly increased'],
    'Annotations': ['The estimated proportion of subjects treated with either liraglutide 1.2 or 1.8 mg reaching ADA/EASD and IDF/AACE HbA1c targets was substantially greater compared with either placebo (P < 0.0001) or rosiglitazone (Fig. 4; P ≤ 0.0003)',
     'he estimated proportion of subjects treated with either liraglutide 1.2 or 1.8 mg reaching ADA/EASD and IDF/AACE HbA1c targets was substantially greater compared with either placebo (P < 0.0001) or rosiglitazone (Fig. 4; P ≤ 0.0003), with more patients reaching < 7.0% with liraglutide 1.8 mg compared with 1.2 mg (P = 0.018).  ',
     'The estimated proportion of subjects treated with either liraglutide 1.2 or 1.8 mg reaching ADA/EASD and IDF/AACE HbA1c targets was substantially greater compared with either placebo (P < 0.0001) or rosiglitazone (Fig. 4; P ≤ 0.0003), ',
     'The estimated proportion of subjects treated with either liraglutide 1.2 or 1.8 mg reaching ADA/EASD and IDF/AACE HbA1c targets was substantially greater compared with either placebo (P < 0.0001) or rosiglitazone (Fig. 4; P ≤ 0.0003), with more patients reaching < 7.0% with liraglutide 1.8 mg compared with 1.2 mg (P = 0.018).  '],
    'Label Code': [1, 1, 1, 1],
    'In Abstract': [True, True, True, True],
    'Evidence Start': [16120, 16121, 16120, 16120],
    'Evidence End': [16353, 16449, 16355, 16449]},
   {'UserID': [0, 1, 3, 2],
    'PromptID': [140, 140, 140, 140],
    'PMCID': [2871176, 2871176, 2871176, 2871176],
    'Valid Label': [True, True, True, True],
    'Valid Reasoning': [True, True, True, True],
    'Label': ['no significant difference',
     'no significant difference',
     'no significant difference',
     'no significant difference'],
    'Annotations': ['There were no significant differences between treatments for HOMA-IR.',
     'There were no significant differences between treatments for HOMA-IR.',
     'There were no significant differences between treatments for HOMA-IR.',
     'There were no significant differences between treatments for HOMA-IR.'],
    'Label Code': [0, 0, 0, 0],
    'In Abstract': [True, True, True, True],
    'Evidence Start': [20943, 20943, 20943, 20943],
    'Evidence End': [21012, 21012, 21012, 21012]},
   {'UserID': [0, 1, 3, 2],
    'PromptID': [106, 106, 106, 106],
    'PMCID': [2871176, 2871176, 2871176, 2871176],
    'Valid Label': [True, True, True, True],
    'Valid Reasoning': [True, True, True, True],
    'Label': ['significantly decreased',
     'significantly decreased',
     'significantly decreased',
     'significantly decreased'],
    'Annotations': ['All liraglutide doses were superior to placebo (P < 0.0001)',
     'Estimated treatment differences and 95% CIs to placebo were: liraglutide 1.8 mg: −1.4% (1.6, −1.1); liraglutide 1.2 mg: −1.3% (1.5, −1.1); liraglutide 0.6 mg: −0.8% (−1.1, −0.6); rosiglitazone: −0.7% (−0.9, −0.4). All liraglutide doses were superior to placebo (P < 0.0001), while the two higher liraglutide doses were superior to rosiglitazone (P < 0.0001). ',
     'All liraglutide doses were superior to placebo (P < 0.0001),',
     'All liraglutide doses were superior to placebo (P < 0.0001), while the two higher liraglutide doses were superior to rosiglitazone (P < 0.0001).'],
    'Label Code': [-1, -1, -1, -1],
    'In Abstract': [True, True, True, True],
    'Evidence Start': [14169, 13955, 14169, 14169],
    'Evidence End': [14228, 14314, 14229, 14313]},
   {'UserID': [0, 1, 3, 2],
    'PromptID': [142, 142, 142, 142],
    'PMCID': [2871176, 2871176, 2871176, 2871176],
    'Valid Label': [True, True, True, True],
    'Valid Reasoning': [True, True, True, True],
    'Label': ['no significant difference',
     'no significant difference',
     'no significant difference',
     'no significant difference'],
    'Annotations': ['Although decreases in systolic blood pressure occurred with either liraglutide 1.2 or 1.8 mg (2.6–2.8 mmHg), they were not significantly different from placebo or rosiglitazone (0.9–2.3 mmHg)',
     'Although decreases in systolic blood pressure occurred with either liraglutide 1.2 or 1.8 mg (2.6–2.8 mmHg), they were not significantly different from placebo or rosiglitazone (0.9–2.3 mmHg). ',
     'Although decreases in systolic blood pressure occurred with either liraglutide 1.2 or 1.8 mg (2.6–2.8 mmHg), they were not significantly different from placebo or rosiglitazone (0.9–2.3 mmHg)',
     'Although decreases in systolic blood pressure occurred with either liraglutide 1.2 or 1.8 mg (2.6–2.8 mmHg), they were not significantly different from placebo or rosiglitazone (0.9–2.3 mmHg). '],
    'Label Code': [0, 0, 0, 0],
    'In Abstract': [True, True, True, True],
    'Evidence Start': [22039, 22039, 22039, 22039],
    'Evidence End': [22230, 22232, 22230, 22232]},
   {'UserID': [0, 1, 3, 2],
    'PromptID': [149, 149, 149, 149],
    'PMCID': [2871176, 2871176, 2871176, 2871176],
    'Valid Label': [True, True, True, True],
    'Valid Reasoning': [True, True, True, True],
    'Label': ['significantly increased',
     'significantly increased',
     'significantly increased',
     'significantly increased'],
    'Annotations': ['Changes in pulse for all doses of liraglutide were significant vs. placebo (P ≤ 0.002). This also was true with either liraglutide 1.8 or 1.2 mg compared with rosiglitazone (P < 0.01).',
     'Changes in pulse for all doses of liraglutide were significant vs. placebo (P ≤ 0.002). This also was true with either liraglutide 1.8 or 1.2 mg compared with rosiglitazone (P < 0.01).',
     'Pulse increases above baseline ranged from 2 to 4 beats/min with the three doses of liraglutide and 1 beat/min with rosiglitazone, while pulse decreased by 1 beat/min with placebo. Changes in pulse for all doses of liraglutide were significant vs. placebo (P ≤ 0.002)',
     'Changes in pulse for all doses of liraglutide were significant vs. placebo (P ≤ 0.002). This also was true with either liraglutide 1.8 or 1.2 mg compared with rosiglitazone (P < 0.01).'],
    'Label Code': [1, 1, 1, 1],
    'In Abstract': [True, True, True, True],
    'Evidence Start': [22554, 22554, 22373, 22554],
    'Evidence End': [22738, 22738, 22640, 22738]},
   {'UserID': [0, 1, 3, 2],
    'PromptID': [148, 148, 148, 148],
    'PMCID': [2871176, 2871176, 2871176, 2871176],
    'Valid Label': [True, True, True, True],
    'Valid Reasoning': [True, True, True, True],
    'Label': ['significantly increased',
     'significantly increased',
     'significantly increased',
     'significantly increased'],
    'Annotations': ['Changes in pulse for all doses of liraglutide were significant vs. placebo (P ≤ 0.002). This also was true with either liraglutide 1.8 or 1.2 mg compared with rosiglitazone (P < 0.01).',
     'Changes in pulse for all doses of liraglutide were significant vs. placebo (P ≤ 0.002)',
     'Changes in pulse for all doses of liraglutide were significant vs. placebo (P ≤ 0.002). This also was true with either liraglutide 1.8 or 1.2 mg compared with rosiglitazone (P < 0.01).',
     'Pulse increases above baseline ranged from 2 to 4 beats/min with the three doses of liraglutide and 1 beat/min with rosiglitazone, while pulse decreased by 1 beat/min with placebo. Changes in pulse for all doses of liraglutide were significant vs. placebo (P ≤ 0.002). This also was true with either liraglutide 1.8 or 1.2 mg compared with rosiglitazone (P < 0.01).'],
    'Label Code': [1, 1, 1, 1],
    'In Abstract': [True, True, True, True],
    'Evidence Start': [22554, 22554, 22554, 22373],
    'Evidence End': [22738, 22640, 22738, 22738]},
   {'UserID': [0, 1, 3, 2],
    'PromptID': [152, 152, 152, 152],
    'PMCID': [2871176, 2871176, 2871176, 2871176],
    'Valid Label': [True, True, True, True],
    'Valid Reasoning': [True, True, True, True],
    'Label': ['significantly increased',
     'significantly increased',
     'significantly increased',
     'significantly increased'],
    'Annotations': ['The proportion of subjects experiencing minor hypoglycaemia during the trial was lowest with placebo (i.e. glimepiride monotherapy 2.6%; 0.17 events/subject-year), comparable with liraglutide 0.6 mg (5.2%, 0.17 events/subject-year) and rosiglitazone (4.3%, 0.12 events/subject-year) groups and similar between the liraglutide 1.2 mg (9.2%, 0.51 events/subject-year) and liraglutide 1.8 mg (8.1%, 0.47 events/subject-year) treatment groups. Incidence was higher with liraglutide 1.2 mg (P = 0.0024) and 1.8 mg (P = 0.0065) compared with rosiglitazone and liraglutide 1.2 mg compared with placebo (P = 0.048), occurring in the setting of lower mean HbA1c values.',
     'Incidence was higher with liraglutide 1.2 mg (P = 0.0024) and 1.8 mg (P = 0.0065) compared with rosiglitazone and liraglutide 1.2 mg compared with placebo (P = 0.048), occurring in the setting of lower mean HbA1c values.',
     'Incidence was higher with liraglutide 1.2 mg (P = 0.0024) and 1.8 mg (P = 0.0065) compared with rosiglitazone and liraglutide 1.2 mg compared with placebo (P = 0.048),',
     'Incidence was higher with liraglutide 1.2 mg (P = 0.0024) and 1.8 mg (P = 0.0065) compared with rosiglitazone and liraglutide 1.2 mg compared with placebo (P = 0.048), occurring in the setting of lower mean HbA1c values.'],
    'Label Code': [1, 1, 1, 1],
    'In Abstract': [True, True, True, True],
    'Evidence Start': [25524, 25964, 25964, 25964],
    'Evidence End': [26184, 26184, 26131, 26184]},
   {'UserID': [0, 1, 3, 2],
    'PromptID': [154, 154, 154, 154],
    'PMCID': [2871176, 2871176, 2871176, 2871176],
    'Valid Label': [True, True, True, True],
    'Valid Reasoning': [True, True, True, True],
    'Label': ['no significant difference',
     'no significant difference',
     'no significant difference',
     'no significant difference'],
    'Annotations': ['No significant differences in calcitonin were found between the three groups treated with liraglutide when compared with either placebo or rosiglitazone at the end of the trial at week 26.',
     'No significant differences in calcitonin were found between the three groups treated with liraglutide when compared with either placebo or rosiglitazone at the end of the trial at week 26.',
     'No significant differences in calcitonin were found between the three groups treated with liraglutide when compared with either placebo or rosiglitazone at the end of the trial at week 26.',
     'No significant differences in calcitonin were found between the three groups treated with liraglutide when compared with either placebo or rosiglitazone at the end of the trial at week 26.'],
    'Label Code': [0, 0, 0, 0],
    'In Abstract': [True, True, True, True],
    'Evidence Start': [26515, 26515, 26515, 26515],
    'Evidence End': [26703, 26703, 26703, 26703]},
   {'UserID': [0, 1, 3, 2],
    'PromptID': [125, 125, 125, 125],
    'PMCID': [2871176, 2871176, 2871176, 2871176],
    'Valid Label': [True, True, True, True],
    'Valid Reasoning': [True, True, True, True],
    'Label': ['significantly decreased',
     'significantly decreased',
     'significantly decreased',
     'significantly decreased'],
    'Annotations': ['Treatment differences for PPG were greater with all doses of liraglutide compared with placebo (1.5–2.4 mmol/l; P < 0.0001) and greater with liraglutide 1.2 mg (0.64 mmol/l; P = 0.043) and 1.8 mg (0.87 mmol/l;P = 0.0022) compared with rosiglitazone.',
     'Decreases in postprandial plasma glucose from baseline were greater with liraglutide 1.2 or 1.8 mg [−2.5 to −2.7 mmol/l (baseline 12.9 mmol/l for both)] compared with placebo (−0.4 mmol/l, P < 0.0001, baseline 12.7 mmol/l) or rosiglitazone (−1.8 mmol/l, P < 0.05, baseline 13.0 mmol/l). ',
     'Decreases in postprandial plasma glucose from baseline were greater with liraglutide 1.2 or 1.8 mg [−2.5 to −2.7 mmol/l (baseline 12.9 mmol/l for both)] compared with placebo (−0.4 mmol/l, P < 0.0001, baseline 12.7 mmol/l) or rosiglitazone (−1.8 mmol/l, P < 0.05, baseline 13.0 mmol/l). ',
     'Decreases in postprandial plasma glucose from baseline were greater with liraglutide 1.2 or 1.8 mg [−2.5 to −2.7 mmol/l (baseline 12.9 mmol/l for both)] compared with placebo (−0.4 mmol/l, P < 0.0001, baseline 12.7 mmol/l) or rosiglitazone (−1.8 mmol/l, P < 0.05, baseline 13.0 mmol/l). '],
    'Label Code': [-1, -1, -1, -1],
    'In Abstract': [True, True, True, True],
    'Evidence Start': [19128, 1469, 1469, 1469],
    'Evidence End': [19377, 1756, 1756, 1756]},
   {'UserID': [0, 3],
    'PromptID': [121, 121],
    'PMCID': [2871176, 2871176],
    'Valid Label': [True, True],
    'Valid Reasoning': [True, True],
    'Label': ['significantly increased', 'significantly increased'],
    'Annotations': ['The percentage of subjects achieving FPG values between 5.0 mmol/l and ≤ 7.2 mmol/l (ADA target) after 26 weeks was higher with liraglutide: 0.6 mg (19%; P = 0.002); 1.2 mg (37%; P < 0.001); and 1.8 mg (38%;P < 0.001) compared with placebo (7%). The liraglutide 1.2 and 1.8 mg treatment groups also had more subjects achieving the same FPG target at end of treatment compared with rosiglitazone (26%) (P = 0.007 and P = 0.01, respectively).',
     'The percentage of subjects achieving FPG values between 5.0 mmol/l and ≤ 7.2 mmol/l (ADA target) after 26 weeks was higher with liraglutide: 0.6 mg (19%; P = 0.002); 1.2 mg (37%; P < 0.001); and 1.8 mg (38%;P < 0.001) compared with placebo (7%). '],
    'Label Code': [1, 1],
    'In Abstract': [True, True],
    'Evidence Start': [18230, 18230],
    'Evidence End': [18670, 18476]},
   {'UserID': [0, 1, 3, 2],
    'PromptID': [124, 124, 124, 124],
    'PMCID': [2871176, 2871176, 2871176, 2871176],
    'Valid Label': [True, True, True, True],
    'Valid Reasoning': [True, True, True, True],
    'Label': ['significantly decreased',
     'significantly decreased',
     'significantly decreased',
     'significantly decreased'],
    'Annotations': ['Treatment differences for PPG were greater with all doses of liraglutide compared with placebo (1.5–2.4 mmol/l; P < 0.0001)',
     'reatment differences for PPG were greater with all doses of liraglutide compared with placebo (1.5–2.4 mmol/l; P < 0.0001) and greater with liraglutide 1.2 mg (0.64 mmol/l; P = 0.043) and 1.8 mg (0.87 mmol/l;P = 0.0022) compared with rosiglitazone.',
     'Treatment differences for PPG were greater with all doses of liraglutide compared with placebo (1.5–2.4 mmol/l; P < 0.0001) ',
     'Treatment differences for PPG were greater with all doses of liraglutide compared with placebo (1.5–2.4 mmol/l; P < 0.0001) and greater with liraglutide 1.2 mg (0.64 mmol/l; P = 0.043) and 1.8 mg (0.87 mmol/l;P = 0.0022) compared with rosiglitazone.'],
    'Label Code': [-1, -1, -1, -1],
    'In Abstract': [True, True, True, True],
    'Evidence Start': [19128, 19129, 19128, 19128],
    'Evidence End': [19251, 19377, 19252, 19377]},
   {'UserID': [0, 1, 3, 2],
    'PromptID': [107, 107, 107, 107],
    'PMCID': [2871176, 2871176, 2871176, 2871176],
    'Valid Label': [True, True, True, True],
    'Valid Reasoning': [True, True, True, True],
    'Label': ['significantly decreased',
     'significantly decreased',
     'significantly decreased',
     'significantly decreased'],
    'Annotations': ['Liraglutide (1.2 or 1.8 mg) produced greater reductions in HbA1c from baseline, (−1.1%, baseline 8.5%) compared with placebo (+0.2%, P < 0.0001, baseline 8.4%) or rosiglitazone (−0.4%, P < 0.0001, baseline 8.4%) when added to glimepiride.',
     'After 26 weeks, HbA1c decreased by 1.1% from baseline (primary endpoint) with either liraglutide 1.2 or 1.8 mg, respectively, compared with either placebo (+0.2%) or rosiglitazone (−0.4%) (Fig. 3d). ',
     'Liraglutide (1.2 or 1.8 mg) produced greater reductions in HbA1c from baseline, (−1.1%, baseline 8.5%) compared with placebo (+0.2%, P < 0.0001, baseline 8.4%) or rosiglitazone (−0.4%, P < 0.0001, baseline 8.4%) when added to glimepiride. ',
     'After 26 weeks, HbA1c decreased by 1.1% from baseline (primary endpoint) with either liraglutide 1.2 or 1.8 mg, respectively, compared with either placebo (+0.2%) or rosiglitazone (−0.4%) (Fig. 3d). Estimated treatment differences and 95% CIs to placebo were: liraglutide 1.8 mg: −1.4% (1.6, −1.1); liraglutide 1.2 mg: −1.3% (1.5, −1.1); liraglutide 0.6 mg: −0.8% (−1.1, −0.6); rosiglitazone: −0.7% (−0.9, −0.4). All liraglutide doses were superior to placebo (P < 0.0001), while the two higher liraglutide doses were superior to rosiglitazone (P < 0.0001). Liraglutide 0.6 mg was non-inferior to rosiglitazone. Rosiglitazone also was superior to placebo (P < 0.0001).  '],
    'Label Code': [-1, -1, -1, -1],
    'In Abstract': [True, True, True, True],
    'Evidence Start': [843, 13756, 843, 13756],
    'Evidence End': [1081, 13955, 1082, 14426]},
   {'UserID': [0, 1, 3, 2],
    'PromptID': [105, 105, 105, 105],
    'PMCID': [2871176, 2871176, 2871176, 2871176],
    'Valid Label': [True, True, True, True],
    'Valid Reasoning': [True, True, True, True],
    'Label': ['significantly decreased',
     'significantly decreased',
     'significantly decreased',
     'significantly decreased'],
    'Annotations': ['Liraglutide (1.2 or 1.8 mg) produced greater reductions in HbA1c from baseline, (−1.1%, baseline 8.5%) compared with placebo (+0.2%, P < 0.0001, baseline 8.4%) or rosiglitazone (−0.4%, P < 0.0001, baseline 8.4%) when added to glimepiride.',
     'After 26 weeks, HbA1c decreased by 1.1% from baseline (primary endpoint) with either liraglutide 1.2 or 1.8 mg, respectively, compared with either placebo (+0.2%) or rosiglitazone (−0.4%) (Fig. 3d). ',
     'All liraglutide doses were superior to placebo (P < 0.0001),',
     'All liraglutide doses were superior to placebo (P < 0.0001), while the two higher liraglutide doses were superior to rosiglitazone (P < 0.0001).'],
    'Label Code': [-1, -1, -1, -1],
    'In Abstract': [True, True, True, True],
    'Evidence Start': [843, 13756, 14169, 14169],
    'Evidence End': [1081, 13955, 14229, 14313]},
   {'UserID': [0, 1, 3, 2],
    'PromptID': [133, 133, 133, 133],
    'PMCID': [2871176, 2871176, 2871176, 2871176],
    'Valid Label': [True, True, True, True],
    'Valid Reasoning': [True, True, True, True],
    'Label': ['significantly decreased',
     'significantly decreased',
     'significantly decreased',
     'significantly decreased'],
    'Annotations': ['Reductions in the proinsulin : insulin ratio were greater with both liraglutide 1.2 and 1.8 mg compared with either rosiglitazone or placebo (Table 2; P ≤ 0.02)',
     'Reductions in the proinsulin : insulin ratio were greater with both liraglutide 1.2 and 1.8 mg compared with either rosiglitazone or placebo (Table 2; P ≤ 0.02). ',
     'Reductions in the proinsulin : insulin ratio were greater with both liraglutide 1.2 and 1.8 mg compared with either rosiglitazone or placebo (Table 2; P ≤ 0.02)',
     'Reductions in the proinsulin : insulin ratio were greater with both liraglutide 1.2 and 1.8 mg compared with either rosiglitazone or placebo (Table 2; P ≤ 0.02). '],
    'Label Code': [-1, -1, -1, -1],
    'In Abstract': [True, True, True, True],
    'Evidence Start': [20566, 20566, 20566, 20566],
    'Evidence End': [20726, 20728, 20726, 20728]},
   {'UserID': [0, 1, 3, 2],
    'PromptID': [103, 103, 103, 103],
    'PMCID': [2871176, 2871176, 2871176, 2871176],
    'Valid Label': [True, True, True, True],
    'Valid Reasoning': [True, True, True, True],
    'Label': ['significantly decreased',
     'significantly decreased',
     'significantly decreased',
     'significantly decreased'],
    'Annotations': ['Decreases in postprandial plasma glucose from baseline were greater with liraglutide 1.2 or 1.8 mg [−2.5 to −2.7 mmol/l (baseline 12.9 mmol/l for both)] compared with placebo (−0.4 mmol/l, P < 0.0001, baseline 12.7 mmol/l)',
     'Decreases in postprandial plasma glucose from baseline were greater with liraglutide 1.2 or 1.8 mg [−2.5 to −2.7 mmol/l (baseline 12.9 mmol/l for both)] compared with placebo (−0.4 mmol/l, P < 0.0001, baseline 12.7 mmol/l) or rosiglitazone (−1.8 mmol/l, P < 0.05, baseline 13.0 mmol/l). ',
     'Decreases in postprandial plasma glucose from baseline were greater with liraglutide 1.2 or 1.8 mg [−2.5 to −2.7 mmol/l (baseline 12.9 mmol/l for both)] compared with placebo (−0.4 mmol/l, P < 0.0001, baseline 12.7 mmol/l) ',
     'Decreases in postprandial plasma glucose from baseline were greater with liraglutide 1.2 or 1.8 mg [−2.5 to −2.7 mmol/l (baseline 12.9 mmol/l for both)] compared with placebo (−0.4 mmol/l, P < 0.0001, baseline 12.7 mmol/l) or rosiglitazone (−1.8 mmol/l, P < 0.05, baseline 13.0 mmol/l). '],
    'Label Code': [-1, -1, -1, -1],
    'In Abstract': [True, True, True, True],
    'Evidence Start': [1469, 1469, 1469, 1469],
    'Evidence End': [1691, 1756, 1692, 1756]},
   {'UserID': [0, 1, 3, 2],
    'PromptID': [126, 126, 126, 126],
    'PMCID': [2871176, 2871176, 2871176, 2871176],
    'Valid Label': [True, True, True, True],
    'Valid Reasoning': [True, True, True, True],
    'Label': ['significantly increased',
     'significantly increased',
     'significantly increased',
     'significantly increased'],
    'Annotations': ['The percentage of subjects with one, two or three PPG measurements < 10.0 mmol/l (ADA target) were greater for all doses of liraglutide compared with placebo (P < 0.05) but not rosiglitazone',
     'The percentage of subjects with one, two or three PPG measurements < 10.0 mmol/l (ADA target) were greater for all doses of liraglutide compared with placebo (P < 0.05) but not rosiglitazone.',
     'The percentage of subjects with one, two or three PPG measurements < 10.0 mmol/l (ADA target) were greater for all doses of liraglutide compared with placebo (P < 0.05)',
     'The percentage of subjects with one, two or three PPG measurements < 10.0 mmol/l (ADA target) were greater for all doses of liraglutide compared with placebo (P < 0.05) but not rosiglitazone.'],
    'Label Code': [1, 1, 1, 1],
    'In Abstract': [True, True, True, True],
    'Evidence Start': [19433, 19433, 19433, 19433],
    'Evidence End': [19623, 19624, 19601, 19624]},
   {'UserID': [0, 1, 3, 2],
    'PromptID': [118, 118, 118, 118],
    'PMCID': [2871176, 2871176, 2871176, 2871176],
    'Valid Label': [True, True, True, True],
    'Valid Reasoning': [True, True, True, True],
    'Label': ['significantly increased',
     'significantly increased',
     'significantly increased',
     'significantly increased'],
    'Annotations': ['The percentage of subjects achieving FPG values between 5.0 mmol/l and ≤ 7.2 mmol/l (ADA target) after 26 weeks was higher with liraglutide: 0.6 mg (19%; P = 0.002); 1.2 mg (37%; P < 0.001); and 1.8 mg (38%;P < 0.001) compared with placebo (7%).',
     'The percentage of subjects achieving FPG values between 5.0 mmol/l and ≤ 7.2 mmol/l (ADA target) after 26 weeks was higher with liraglutide: 0.6 mg (19%; P = 0.002); 1.2 mg (37%; P < 0.001); and 1.8 mg (38%;P < 0.001) compared with placebo (7%). ',
     'The percentage of subjects achieving FPG values between 5.0 mmol/l and ≤ 7.2 mmol/l (ADA target) after 26 weeks was higher with liraglutide: 0.6 mg (19%; P = 0.002); 1.2 mg (37%; P < 0.001); and 1.8 mg (38%;P < 0.001) compared with placebo (7%)',
     'The percentage of subjects achieving FPG values between 5.0 mmol/l and ≤ 7.2 mmol/l (ADA target) after 26 weeks was higher with liraglutide: 0.6 mg (19%; P = 0.002); 1.2 mg (37%; P < 0.001); and 1.8 mg (38%;P < 0.001) compared with placebo (7%). '],
    'Label Code': [1, 1, 1, 1],
    'In Abstract': [True, True, True, True],
    'Evidence Start': [18230, 18230, 18230, 18230],
    'Evidence End': [18475, 18476, 18474, 18476]},
   {'UserID': [0, 1, 2],
    'PromptID': [132, 132, 132],
    'PMCID': [2871176, 2871176, 2871176],
    'Valid Label': [True, True, True],
    'Valid Reasoning': [True, True, True],
    'Label': ['significantly decreased',
     'significantly decreased',
     'significantly decreased'],
    'Annotations': ['Reductions in the proinsulin : insulin ratio were greater with both liraglutide 1.2 and 1.8 mg compared with either rosiglitazone or placebo (Table 2; P ≤ 0.02)',
     'Reductions in the proinsulin : insulin ratio were greater with both liraglutide 1.2 and 1.8 mg compared with either rosiglitazone or placebo (Table 2; P ≤ 0.02). ',
     'Reductions in the proinsulin : insulin ratio were greater with both liraglutide 1.2 and 1.8 mg compared with either rosiglitazone or placebo (Table 2; P ≤ 0.02). '],
    'Label Code': [-1, -1, -1],
    'In Abstract': [True, True, True],
    'Evidence Start': [20566, 20566, 20566],
    'Evidence End': [20726, 20728, 20728]},
   {'UserID': [0, 1, 1, 2],
    'PromptID': [122, 122, 122, 122],
    'PMCID': [2871176, 2871176, 2871176, 2871176],
    'Valid Label': [True, True, True, True],
    'Valid Reasoning': [True, True, True, True],
    'Label': ['significantly increased',
     'significantly increased',
     'significantly increased',
     'significantly increased'],
    'Annotations': ['The percentage of subjects achieving FPG values between 5.0 mmol/l and ≤ 7.2 mmol/l (ADA target) after 26 weeks was higher with liraglutide: 0.6 mg (19%; P = 0.002); 1.2 mg (37%; P < 0.001); and 1.8 mg (38%;P < 0.001) compared with placebo (7%). The liraglutide 1.2 and 1.8 mg treatment groups also had more subjects achieving the same FPG target at end of treatment compared with rosiglitazone (26%) (P = 0.007 and P = 0.01, respectively).',
     'The percentage of subjects achieving FPG values between 5.0 mmol/l and ≤ 7.2 mmol/l (ADA target) after 26 weeks was higher with liraglutide: 0.6 mg (19%; P = 0.002); 1.2 mg (37%; P < 0.001); and 1.8 mg (38%;P < 0.001) compared with placebo (7%). ',
     'The liraglutide 1.2 and 1.8 mg treatment groups also had more subjects achieving the same FPG target at end of treatment compared with rosiglitazone (26%) (P = 0.007 and P = 0.01, respectively).',
     'The percentage of subjects achieving FPG values between 5.0 mmol/l and ≤ 7.2 mmol/l (ADA target) after 26 weeks was higher with liraglutide: 0.6 mg (19%; P = 0.002); 1.2 mg (37%; P < 0.001); and 1.8 mg (38%;P < 0.001) compared with placebo (7%). The liraglutide 1.2 and 1.8 mg treatment groups also had more subjects achieving the same FPG target at end of treatment compared with rosiglitazone (26%) (P = 0.007 and P = 0.01, respectively).'],
    'Label Code': [1, 1, 1, 1],
    'In Abstract': [True, True, True, True],
    'Evidence Start': [18230, 18230, 18476, 18230],
    'Evidence End': [18670, 18476, 18670, 18670]},
   {'UserID': [0, 1, 3, 2],
    'PromptID': [141, 141, 141, 141],
    'PMCID': [2871176, 2871176, 2871176, 2871176],
    'Valid Label': [True, True, True, True],
    'Valid Reasoning': [True, True, True, True],
    'Label': ['no significant difference',
     'no significant difference',
     'no significant difference',
     'no significant difference'],
    'Annotations': ['Although decreases in systolic blood pressure occurred with either liraglutide 1.2 or 1.8 mg (2.6–2.8 mmHg), they were not significantly different from placebo or rosiglitazone (0.9–2.3 mmHg)',
     'Although decreases in systolic blood pressure occurred with either liraglutide 1.2 or 1.8 mg (2.6–2.8 mmHg), they were not significantly different from placebo or rosiglitazone (0.9–2.3 mmHg). ',
     'Although decreases in systolic blood pressure occurred with either liraglutide 1.2 or 1.8 mg (2.6–2.8 mmHg), they were not significantly different from placebo ',
     'Although decreases in systolic blood pressure occurred with either liraglutide 1.2 or 1.8 mg (2.6–2.8 mmHg), they were not significantly different from placebo or rosiglitazone (0.9–2.3 mmHg). '],
    'Label Code': [0, 0, 0, 0],
    'In Abstract': [True, True, True, True],
    'Evidence Start': [22039, 22039, 22039, 22039],
    'Evidence End': [22230, 22232, 22199, 22232]},
   {'UserID': [0, 1, 3, 2],
    'PromptID': [151, 151, 151, 151],
    'PMCID': [2871176, 2871176, 2871176, 2871176],
    'Valid Label': [True, True, True, True],
    'Valid Reasoning': [True, True, True, True],
    'Label': ['significantly increased',
     'significantly increased',
     'significantly increased',
     'significantly increased'],
    'Annotations': ['The proportion of subjects experiencing minor hypoglycaemia during the trial was lowest with placebo (i.e. glimepiride monotherapy 2.6%; 0.17 events/subject-year), comparable with liraglutide 0.6 mg (5.2%, 0.17 events/subject-year) and rosiglitazone (4.3%, 0.12 events/subject-year) groups and similar between the liraglutide 1.2 mg (9.2%, 0.51 events/subject-year) and liraglutide 1.8 mg (8.1%, 0.47 events/subject-year) treatment groups. Incidence was higher with liraglutide 1.2 mg (P = 0.0024) and 1.8 mg (P = 0.0065) compared with rosiglitazone and liraglutide 1.2 mg compared with placebo (P = 0.048), occurring in the setting of lower mean HbA1c values.',
     'Incidence was higher with liraglutide 1.2 mg (P = 0.0024) and 1.8 mg (P = 0.0065) compared with rosiglitazone and liraglutide 1.2 mg compared with placebo (P = 0.048), occurring in the setting of lower mean HbA1c values.',
     'Incidence was higher with liraglutide 1.2 mg (P = 0.0024) and 1.8 mg (P = 0.0065) compared with rosiglitazone',
     'Incidence was higher with liraglutide 1.2 mg (P = 0.0024) and 1.8 mg (P = 0.0065) compared with rosiglitazone and liraglutide 1.2 mg compared with placebo (P = 0.048), occurring in the setting of lower mean HbA1c values.'],
    'Label Code': [1, 1, 1, 1],
    'In Abstract': [True, True, True, True],
    'Evidence Start': [25524, 25964, 25964, 25964],
    'Evidence End': [26184, 26184, 26073, 26184]},
   {'UserID': [0, 1, 3, 2],
    'PromptID': [112, 112, 112, 112],
    'PMCID': [2871176, 2871176, 2871176, 2871176],
    'Valid Label': [True, True, True, True],
    'Valid Reasoning': [True, True, True, True],
    'Label': ['significantly increased',
     'significantly increased',
     'significantly increased',
     'significantly increased'],
    'Annotations': ['The estimated proportion of subjects treated with either liraglutide 1.2 or 1.8 mg reaching ADA/EASD and IDF/AACE HbA1c targets was substantially greater compared with either placebo (P < 0.0001) or rosiglitazone (Fig. 4; P ≤ 0.0003)',
     'At week 26, 42% and 21% of subjects treated with liraglutide 1.8 mg reached an HbA1c < 7.0% and ≤ 6.5%, respectively, compared with 8% and 4% for placebo (Fig. 4). The estimated proportion of subjects treated with either liraglutide 1.2 or 1.8 mg reaching ADA/EASD and IDF/AACE HbA1c targets was substantially greater compared with either placebo (P < 0.0001) or rosiglitazone (Fig. 4; P ≤ 0.0003), with more patients reaching < 7.0% with liraglutide 1.8 mg compared with 1.2 mg (P = 0.018).  ',
     'The estimated proportion of subjects treated with either liraglutide 1.2 or 1.8 mg reaching ADA/EASD and IDF/AACE HbA1c targets was substantially greater compared with either placebo (P < 0.0001) or rosiglitazone (Fig. 4; P ≤ 0.0003), with more patients reaching < 7.0% with liraglutide 1.8 mg compared with 1.2 mg (P = 0.018).  ',
     'The percentage of subjects reaching ADA [2] and International Diabetes Federation (IDF)/American Association of Clinical Endocrinologists (AACE) [11,12] treatment HbA1c goals with liraglutide was dose dependent (Fig. 4). At week 26, 42% and 21% of subjects treated with liraglutide 1.8 mg reached an HbA1c < 7.0% and ≤ 6.5%, respectively, compared with 8% and 4% for placebo (Fig. 4). The estimated proportion of subjects treated with either liraglutide 1.2 or 1.8 mg reaching ADA/EASD and IDF/AACE HbA1c targets was substantially greater compared with either placebo (P < 0.0001) or rosiglitazone (Fig. 4; P ≤ 0.0003), with more patients reaching < 7.0% with liraglutide 1.8 mg compared with 1.2 mg (P = 0.018).  '],
    'Label Code': [1, 1, 1, 1],
    'In Abstract': [True, True, True, True],
    'Evidence Start': [16120, 15956, 16120, 15735],
    'Evidence End': [16353, 16449, 16449, 16449]},
   {'UserID': [0, 1, 3, 2],
    'PromptID': [153, 153, 153, 153],
    'PMCID': [2871176, 2871176, 2871176, 2871176],
    'Valid Label': [True, True, True, True],
    'Valid Reasoning': [True, True, True, True],
    'Label': ['no significant difference',
     'no significant difference',
     'no significant difference',
     'no significant difference'],
    'Annotations': ['No significant differences in calcitonin were found between the three groups treated with liraglutide when compared with either placebo or rosiglitazone at the end of the trial at week 26.',
     'No significant differences in calcitonin were found between the three groups treated with liraglutide when compared with either placebo or rosiglitazone at the end of the trial at week 26.',
     'No significant differences in calcitonin were found between the three groups treated with liraglutide when compared with either placebo or rosiglitazone at the end of the trial at week 26.',
     'No significant differences in calcitonin were found between the three groups treated with liraglutide when compared with either placebo or rosiglitazone at the end of the trial at week 26.'],
    'Label Code': [0, 0, 0, 0],
    'In Abstract': [True, True, True, True],
    'Evidence Start': [26515, 26515, 26515, 26515],
    'Evidence End': [26703, 26703, 26703, 26703]},
   {'UserID': [0, 1, 3, 2],
    'PromptID': [102, 102, 102, 102],
    'PMCID': [2871176, 2871176, 2871176, 2871176],
    'Valid Label': [True, True, True, True],
    'Valid Reasoning': [True, True, True, True],
    'Label': ['significantly decreased',
     'significantly decreased',
     'significantly decreased',
     'significantly decreased'],
    'Annotations': ['Fasting plasma glucose decreased by week 2, with a 1.6 mmol/l decrease from baseline at week 26 with liraglutide 1.2 mg (baseline 9.8 mmol/l) or 1.8 mg (baseline 9.7 mmol/l) compared with a 0.9 mmol/l increase (placebo, P < 0.0001, baseline 9.5 mmol/l) or 1.0 mmol/l decrease (rosiglitazone, P < 0.006, baseline 9.9 mmol/l).',
     'Fasting plasma glucose decreased by week 2, with a 1.6 mmol/l decrease from baseline at week 26 with liraglutide 1.2 mg (baseline 9.8 mmol/l) or 1.8 mg (baseline 9.7 mmol/l) compared with a 0.9 mmol/l increase (placebo, P < 0.0001, baseline 9.5 mmol/l) or 1.0 mmol/l decrease (rosiglitazone, P < 0.006, baseline 9.9 mmol/l).',
     'An 0.7-mmol/l greater reduction in FPG was achieved with either liraglutide 1.2 or 1.8 mg compared with rosiglitazone (P ≤ 0.006) after 26 weeks.  ',
     'Fasting plasma glucose decreased by week 2, with a 1.6 mmol/l decrease from baseline at week 26 with liraglutide 1.2 mg (baseline 9.8 mmol/l) or 1.8 mg (baseline 9.7 mmol/l) compared with a 0.9 mmol/l increase (placebo, P < 0.0001, baseline 9.5 mmol/l) or 1.0 mmol/l decrease (rosiglitazone, P < 0.006, baseline 9.9 mmol/l).'],
    'Label Code': [-1, -1, -1, -1],
    'In Abstract': [True, True, True, True],
    'Evidence Start': [1144, 1144, 17914, 1144],
    'Evidence End': [1468, 1468, 18061, 1468]},
   {'UserID': [0, 1, 3, 2],
    'PromptID': [129, 129, 129, 129],
    'PMCID': [2871176, 2871176, 2871176, 2871176],
    'Valid Label': [True, True, True, True],
    'Valid Reasoning': [True, True, True, True],
    'Label': ['no significant difference',
     'no significant difference',
     'no significant difference',
     'no significant difference'],
    'Annotations': ['The percentage of subjects with one, two or three PPG measurements < 10.0 mmol/l (ADA target) were greater for all doses of liraglutide compared with placebo (P < 0.05) but not rosiglitazone.',
     'The percentage of subjects with one, two or three PPG measurements < 10.0 mmol/l (ADA target) were greater for all doses of liraglutide compared with placebo (P < 0.05) but not rosiglitazone.',
     'The percentage of subjects with one, two or three PPG measurements < 10.0 mmol/l (ADA target) were greater for all doses of liraglutide compared with placebo (P < 0.05) but not rosiglitazone.',
     'The percentage of subjects with one, two or three PPG measurements < 10.0 mmol/l (ADA target) were greater for all doses of liraglutide compared with placebo (P < 0.05) but not rosiglitazone.'],
    'Label Code': [0, 0, 0, 0],
    'In Abstract': [True, True, True, True],
    'Evidence Start': [19433, 19433, 19433, 19433],
    'Evidence End': [19624, 19624, 19624, 19624]},
   {'UserID': [1, 2],
    'PromptID': [104, 104],
    'PMCID': [2871176, 2871176],
    'Valid Label': [True, True],
    'Valid Reasoning': [True, True],
    'Label': ['significantly decreased', 'significantly decreased'],
    'Annotations': ['Decreases in postprandial plasma glucose from baseline were greater with liraglutide 1.2 or 1.8 mg [−2.5 to −2.7 mmol/l (baseline 12.9 mmol/l for both)] compared with placebo (−0.4 mmol/l, P < 0.0001, baseline 12.7 mmol/l) or rosiglitazone (−1.8 mmol/l, P < 0.05, baseline 13.0 mmol/l). ',
     'Decreases in postprandial plasma glucose from baseline were greater with liraglutide 1.2 or 1.8 mg [−2.5 to −2.7 mmol/l (baseline 12.9 mmol/l for both)] compared with placebo (−0.4 mmol/l, P < 0.0001, baseline 12.7 mmol/l) or rosiglitazone (−1.8 mmol/l, P < 0.05, baseline 13.0 mmol/l). '],
    'Label Code': [-1, -1],
    'In Abstract': [True, True],
    'Evidence Start': [1469, 1469],
    'Evidence End': [1756, 1756]},
   {'UserID': [0, 1, 3, 2],
    'PromptID': [116, 116, 116, 116],
    'PMCID': [2871176, 2871176, 2871176, 2871176],
    'Valid Label': [True, True, True, True],
    'Valid Reasoning': [True, True, True, True],
    'Label': ['significantly decreased',
     'significantly decreased',
     'significantly decreased',
     'significantly decreased'],
    'Annotations': ['At week 26, all doses of liraglutide decreased FPG more than did placebo (Fig. 5; P < 0.0001)',
     'By week 2, subjects treated with liraglutide had rapid and larger decreases in FPG vs. comparator treatment. At week 26, all doses of liraglutide decreased FPG more than did placebo (Fig. 5; P < 0.0001), while only liraglutide 1.2 or 1.8 mg produced greater reductions than rosiglitazone. FPG treatment differences to placebo were 1.7 mmol/l for liraglutide 0.6 mg and 2.6 mmol/l for both liraglutide 1.2 and 1.8 mg.',
     'At week 26, all doses of liraglutide decreased FPG more than did placebo (Fig. 5; P < 0.0001),',
     'At week 26, all doses of liraglutide decreased FPG more than did placebo (Fig. 5; P < 0.0001), while only liraglutide 1.2 or 1.8 mg produced greater reductions than rosiglitazone.'],
    'Label Code': [-1, -1, -1, -1],
    'In Abstract': [True, True, True, True],
    'Evidence Start': [17606, 17497, 17606, 17606],
    'Evidence End': [17699, 17913, 17700, 17785]},
   {'UserID': [0, 1, 3, 2],
    'PromptID': [136, 136, 136, 136],
    'PMCID': [2871176, 2871176, 2871176, 2871176],
    'Valid Label': [True, True, True, True],
    'Valid Reasoning': [True, True, True, True],
    'Label': ['significantly increased',
     'significantly increased',
     'significantly increased',
     'significantly increased'],
    'Annotations': ['HOMA-B increased with liraglutide (1.8 or 1.2 mg) compared with rosiglitazone (P < 0.05)',
     'HOMA-B increased with liraglutide (1.8 or 1.2 mg) compared with rosiglitazone (P < 0.05), while this increase was only different to placebo with liraglutide 1.2 mg (P = 0.01) and not liraglutide 1.8 mg (P = 0.051).',
     'HOMA-B increased with liraglutide (1.8 or 1.2 mg) compared with rosiglitazone (P < 0.05),',
     'HOMA-B increased with liraglutide (1.8 or 1.2 mg) compared with rosiglitazone (P < 0.05), while this increase was only different to placebo with liraglutide 1.2 mg (P = 0.01) and not liraglutide 1.8 mg (P = 0.051).'],
    'Label Code': [1, 1, 1, 1],
    'In Abstract': [True, True, True, True],
    'Evidence Start': [20728, 20728, 20728, 20728],
    'Evidence End': [20816, 20942, 20817, 20942]},
   {'UserID': [0, 1, 3, 2],
    'PromptID': [123, 123, 123, 123],
    'PMCID': [2871176, 2871176, 2871176, 2871176],
    'Valid Label': [True, True, True, True],
    'Valid Reasoning': [True, True, True, True],
    'Label': ['significantly decreased',
     'significantly decreased',
     'significantly decreased',
     'significantly decreased'],
    'Annotations': ['Decreases in postprandial plasma glucose from baseline were greater with liraglutide 1.2 or 1.8 mg [−2.5 to −2.7 mmol/l (baseline 12.9 mmol/l for both)] compared with placebo (−0.4 mmol/l, P < 0.0001, baseline 12.7 mmol/l)',
     'Decreases in postprandial plasma glucose from baseline were greater with liraglutide 1.2 or 1.8 mg [−2.5 to −2.7 mmol/l (baseline 12.9 mmol/l for both)] compared with placebo (−0.4 mmol/l, P < 0.0001, baseline 12.7 mmol/l) or rosiglitazone (−1.8 mmol/l, P < 0.05, baseline 13.0 mmol/l). ',
     'Decreases in postprandial plasma glucose from baseline were greater with liraglutide 1.2 or 1.8 mg [−2.5 to −2.7 mmol/l (baseline 12.9 mmol/l for both)] compared with placebo (−0.4 mmol/l, P < 0.0001, baseline 12.7 mmol/l) ',
     'Decreases in postprandial plasma glucose from baseline were greater with liraglutide 1.2 or 1.8 mg [−2.5 to −2.7 mmol/l (baseline 12.9 mmol/l for both)] compared with placebo (−0.4 mmol/l, P < 0.0001, baseline 12.7 mmol/l) or rosiglitazone (−1.8 mmol/l, P < 0.05, baseline 13.0 mmol/l). '],
    'Label Code': [-1, -1, -1, -1],
    'In Abstract': [True, True, True, True],
    'Evidence Start': [1469, 1469, 1469, 1469],
    'Evidence End': [1691, 1756, 1692, 1756]},
   {'UserID': [0, 1, 3, 2],
    'PromptID': [135, 135, 135, 135],
    'PMCID': [2871176, 2871176, 2871176, 2871176],
    'Valid Label': [True, True, True, True],
    'Valid Reasoning': [True, True, True, True],
    'Label': ['significantly increased',
     'significantly increased',
     'significantly increased',
     'significantly increased'],
    'Annotations': ['HOMA-B increased with liraglutide (1.8 or 1.2 mg) compared with rosiglitazone (P < 0.05)',
     'HOMA-B increased with liraglutide (1.8 or 1.2 mg) compared with rosiglitazone (P < 0.05), while this increase was only different to placebo with liraglutide 1.2 mg (P = 0.01) and not liraglutide 1.8 mg (P = 0.051).',
     'HOMA-B increased with liraglutide (1.8 or 1.2 mg) compared with rosiglitazone (P < 0.05),',
     'HOMA-B increased with liraglutide (1.8 or 1.2 mg) compared with rosiglitazone (P < 0.05), while this increase was only different to placebo with liraglutide 1.2 mg (P = 0.01) and not liraglutide 1.8 mg (P = 0.051)'],
    'Label Code': [1, 1, 1, 1],
    'In Abstract': [True, True, True, True],
    'Evidence Start': [20728, 20728, 20728, 20728],
    'Evidence End': [20816, 20942, 20817, 20941]},
   {'UserID': [0, 1, 3, 2],
    'PromptID': [139, 139, 139, 139],
    'PMCID': [2871176, 2871176, 2871176, 2871176],
    'Valid Label': [True, True, True, True],
    'Valid Reasoning': [True, True, True, True],
    'Label': ['no significant difference',
     'no significant difference',
     'no significant difference',
     'no significant difference'],
    'Annotations': ['There were no significant differences between treatments for HOMA-IR.',
     'There were no significant differences between treatments for HOMA-IR.\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nTable 2',
     'There were no significant differences between treatments for HOMA-IR.',
     'There were no significant differences between treatments for HOMA-IR.'],
    'Label Code': [0, 0, 0, 0],
    'In Abstract': [True, True, True, True],
    'Evidence Start': [20943, -1, 20943, 20943],
    'Evidence End': [21012, -1, 21012, 21012]},
   {'UserID': [0, 1, 3, 2],
    'PromptID': [101, 101, 101, 101],
    'PMCID': [2871176, 2871176, 2871176, 2871176],
    'Valid Label': [True, True, True, True],
    'Valid Reasoning': [True, True, True, True],
    'Label': ['significantly decreased',
     'significantly decreased',
     'significantly decreased',
     'significantly decreased'],
    'Annotations': ['Fasting plasma glucose decreased by week 2, with a 1.6 mmol/l decrease from baseline at week 26 with liraglutide 1.2 mg (baseline 9.8 mmol/l) or 1.8 mg (baseline 9.7 mmol/l) compared with a 0.9 mmol/l increase (placebo, P < 0.0001, baseline 9.5 mmol/l)',
     'Fasting plasma glucose decreased by week 2, with a 1.6 mmol/l decrease from baseline at week 26 with liraglutide 1.2 mg (baseline 9.8 mmol/l) or 1.8 mg (baseline 9.7 mmol/l) compared with a 0.9 mmol/l increase (placebo, P < 0.0001, baseline 9.5 mmol/l) or 1.0 mmol/l decrease (rosiglitazone, P < 0.006, baseline 9.9 mmol/l).',
     'At week 26, all doses of liraglutide decreased FPG more than did placebo (Fig. 5; P < 0.0001)',
     'Fasting plasma glucose decreased by week 2, with a 1.6 mmol/l decrease from baseline at week 26 with liraglutide 1.2 mg (baseline 9.8 mmol/l) or 1.8 mg (baseline 9.7 mmol/l) compared with a 0.9 mmol/l increase (placebo, P < 0.0001, baseline 9.5 mmol/l) or 1.0 mmol/l decrease (rosiglitazone, P < 0.006, baseline 9.9 mmol/l).'],
    'Label Code': [-1, -1, -1, -1],
    'In Abstract': [True, True, True, True],
    'Evidence Start': [1144, 1144, 17606, 1144],
    'Evidence End': [1396, 1468, 17699, 1468]},
   {'UserID': [0, 1, 3, 2],
    'PromptID': [99, 99, 99, 99],
    'PMCID': [2871176, 2871176, 2871176, 2871176],
    'Valid Label': [True, True, True, True],
    'Valid Reasoning': [True, True, True, True],
    'Label': ['significantly decreased',
     'significantly decreased',
     'significantly decreased',
     'significantly decreased'],
    'Annotations': ['Liraglutide (1.2 or 1.8 mg) produced greater reductions in HbA1c from baseline, (−1.1%, baseline 8.5%) compared with placebo (+0.2%, P < 0.0001, baseline 8.4%)',
     'After 26 weeks, HbA1c decreased by 1.1% from baseline (primary endpoint) with either liraglutide 1.2 or 1.8 mg, respectively, compared with either placebo (+0.2%) or rosiglitazone (−0.4%) (Fig. 3d). ',
     'Liraglutide (1.2 or 1.8 mg) produced greater reductions in HbA1c from baseline, (−1.1%, baseline 8.5%) compared with placebo (+0.2%, P < 0.0001, baseline 8.4%) ',
     'After 26 weeks, HbA1c decreased by 1.1% from baseline (primary endpoint) with either liraglutide 1.2 or 1.8 mg, respectively, compared with either placebo (+0.2%) or rosiglitazone (−0.4%) (Fig. 3d). Estimated treatment differences and 95% CIs to placebo were: liraglutide 1.8 mg: −1.4% (1.6, −1.1); liraglutide 1.2 mg: −1.3% (1.5, −1.1); liraglutide 0.6 mg: −0.8% (−1.1, −0.6); rosiglitazone: −0.7% (−0.9, −0.4). All liraglutide doses were superior to placebo (P < 0.0001), while the two higher liraglutide doses were superior to rosiglitazone (P < 0.0001)'],
    'Label Code': [-1, -1, -1, -1],
    'In Abstract': [True, True, True, True],
    'Evidence Start': [843, 13756, 843, 13756],
    'Evidence End': [1002, 13955, 1003, 14312]},
   {'UserID': [0, 1, 3, 2],
    'PromptID': [144, 144, 144, 144],
    'PMCID': [2871176, 2871176, 2871176, 2871176],
    'Valid Label': [True, True, True, True],
    'Valid Reasoning': [True, True, True, True],
    'Label': ['no significant difference',
     'no significant difference',
     'no significant difference',
     'no significant difference'],
    'Annotations': ['Although decreases in systolic blood pressure occurred with either liraglutide 1.2 or 1.8 mg (2.6–2.8 mmHg), they were not significantly different from placebo or rosiglitazone (0.9–2.3 mmHg).',
     'Although decreases in systolic blood pressure occurred with either liraglutide 1.2 or 1.8 mg (2.6–2.8 mmHg), they were not significantly different from placebo or rosiglitazone (0.9–2.3 mmHg). ',
     'Although decreases in systolic blood pressure occurred with either liraglutide 1.2 or 1.8 mg (2.6–2.8 mmHg), they were not significantly different from placebo or rosiglitazone (0.9–2.3 mmHg). ',
     'Although decreases in systolic blood pressure occurred with either liraglutide 1.2 or 1.8 mg (2.6–2.8 mmHg), they were not significantly different from placebo or rosiglitazone (0.9–2.3 mmHg). '],
    'Label Code': [0, 0, 0, 0],
    'In Abstract': [True, True, True, True],
    'Evidence Start': [22039, 22039, 22039, 22039],
    'Evidence End': [22231, 22232, 22232, 22232]},
   {'UserID': [0, 1, 3, 2],
    'PromptID': [145, 145, 145, 145],
    'PMCID': [2871176, 2871176, 2871176, 2871176],
    'Valid Label': [True, True, True, True],
    'Valid Reasoning': [True, True, True, True],
    'Label': ['no significant difference',
     'no significant difference',
     'no significant difference',
     'no significant difference'],
    'Annotations': ['Reductions in diastolic blood pressure also occurred with all treatments (0.7–1.4 mmHg), with no significant differences between treatments.',
     'Reductions in diastolic blood pressure also occurred with all treatments (0.7–1.4 mmHg), with no significant differences between treatments. ',
     'Reductions in diastolic blood pressure also occurred with all treatments (0.7–1.4 mmHg), with no significant differences between treatments. ',
     'Reductions in diastolic blood pressure also occurred with all treatments (0.7–1.4 mmHg), with no significant differences between treatments. '],
    'Label Code': [0, 0, 0, 0],
    'In Abstract': [True, True, True, True],
    'Evidence Start': [22232, 22232, 22232, 22232],
    'Evidence End': [22372, 22373, 22373, 22373]},
   {'UserID': [0, 1, 2],
    'PromptID': [147, 147, 147],
    'PMCID': [2871176, 2871176, 2871176],
    'Valid Label': [True, True, True],
    'Valid Reasoning': [True, True, True],
    'Label': ['significantly increased',
     'significantly increased',
     'significantly increased'],
    'Annotations': ['Changes in pulse for all doses of liraglutide were significant vs. placebo (P ≤ 0.002). This also was true with either liraglutide 1.8 or 1.2 mg compared with rosiglitazone (P < 0.01).',
     'Changes in pulse for all doses of liraglutide were significant vs. placebo (P ≤ 0.002). ',
     'Changes in pulse for all doses of liraglutide were significant vs. placebo (P ≤ 0.002). '],
    'Label Code': [1, 1, 1],
    'In Abstract': [True, True, True],
    'Evidence Start': [22554, 22554, 22554],
    'Evidence End': [22738, 22642, 22642]},
   {'UserID': [0, 1, 3, 2],
    'PromptID': [117, 117, 117, 117],
    'PMCID': [2871176, 2871176, 2871176, 2871176],
    'Valid Label': [True, True, True, True],
    'Valid Reasoning': [True, True, True, True],
    'Label': ['significantly decreased',
     'significantly decreased',
     'significantly decreased',
     'significantly decreased'],
    'Annotations': ['Fasting plasma glucose decreased by week 2, with a 1.6 mmol/l decrease from baseline at week 26 with liraglutide 1.2 mg (baseline 9.8 mmol/l) or 1.8 mg (baseline 9.7 mmol/l) compared with a 0.9 mmol/l increase (placebo, P < 0.0001, baseline 9.5 mmol/l) or 1.0 mmol/l decrease (rosiglitazone, P < 0.006, baseline 9.9 mmol/l).',
     'Fasting plasma glucose decreased by week 2, with a 1.6 mmol/l decrease from baseline at week 26 with liraglutide 1.2 mg (baseline 9.8 mmol/l) or 1.8 mg (baseline 9.7 mmol/l) compared with a 0.9 mmol/l increase (placebo, P < 0.0001, baseline 9.5 mmol/l) or 1.0 mmol/l decrease (rosiglitazone, P < 0.006, baseline 9.9 mmol/l).',
     'Fasting plasma glucose decreased by week 2, with a 1.6 mmol/l decrease from baseline at week 26 with liraglutide 1.2 mg (baseline 9.8 mmol/l) or 1.8 mg (baseline 9.7 mmol/l) compared with a 0.9 mmol/l increase (placebo, P < 0.0001, baseline 9.5 mmol/l) or 1.0 mmol/l decrease (rosiglitazone, P < 0.006, baseline 9.9 mmol/l).',
     'By week 2, subjects treated with liraglutide had rapid and larger decreases in FPG vs. comparator treatment. At week 26, all doses of liraglutide decreased FPG more than did placebo (Fig. 5; P < 0.0001), while only liraglutide 1.2 or 1.8 mg produced greater reductions than rosiglitazone. FPG treatment differences to placebo were 1.7 mmol/l for liraglutide 0.6 mg and 2.6 mmol/l for both liraglutide 1.2 and 1.8 mg. An 0.7-mmol/l greater reduction in FPG was achieved with either liraglutide 1.2 or 1.8 mg compared with rosiglitazone (P ≤ 0.006) after 26 weeks.  '],
    'Label Code': [-1, -1, -1, -1],
    'In Abstract': [True, True, True, True],
    'Evidence Start': [1144, 1144, 1144, 17497],
    'Evidence End': [1468, 1468, 1468, 18061]},
   {'UserID': [0, 1, 3, 2],
    'PromptID': [143, 143, 143, 143],
    'PMCID': [2871176, 2871176, 2871176, 2871176],
    'Valid Label': [True, True, True, True],
    'Valid Reasoning': [True, True, True, True],
    'Label': ['no significant difference',
     'no significant difference',
     'no significant difference',
     'no significant difference'],
    'Annotations': ['Although decreases in systolic blood pressure occurred with either liraglutide 1.2 or 1.8 mg (2.6–2.8 mmHg), they were not significantly different from placebo or rosiglitazone (0.9–2.3 mmHg).',
     'Although decreases in systolic blood pressure occurred with either liraglutide 1.2 or 1.8 mg (2.6–2.8 mmHg), they were not significantly different from placebo or rosiglitazone (0.9–2.3 mmHg). ',
     'Although decreases in systolic blood pressure occurred with either liraglutide 1.2 or 1.8 mg (2.6–2.8 mmHg), they were not significantly different from placebo or rosiglitazone (0.9–2.3 mmHg). ',
     'Although decreases in systolic blood pressure occurred with either liraglutide 1.2 or 1.8 mg (2.6–2.8 mmHg), they were not significantly different from placebo or rosiglitazone (0.9–2.3 mmHg). '],
    'Label Code': [0, 0, 0, 0],
    'In Abstract': [True, True, True, True],
    'Evidence Start': [22039, 22039, 22039, 22039],
    'Evidence End': [22231, 22232, 22232, 22232]},
   {'UserID': [0, 1, 3, 2],
    'PromptID': [111, 111, 111, 111],
    'PMCID': [2871176, 2871176, 2871176, 2871176],
    'Valid Label': [True, True, True, True],
    'Valid Reasoning': [True, True, True, True],
    'Label': ['significantly increased',
     'significantly increased',
     'significantly increased',
     'significantly increased'],
    'Annotations': ['The estimated proportion of subjects treated with either liraglutide 1.2 or 1.8 mg reaching ADA/EASD and IDF/AACE HbA1c targets was substantially greater compared with either placebo (P < 0.0001)',
     ' The estimated proportion of subjects treated with either liraglutide 1.2 or 1.8 mg reaching ADA/EASD and IDF/AACE HbA1c targets was substantially greater compared with either placebo (P < 0.0001) or rosiglitazone (Fig. 4; P ≤ 0.0003), with more patients reaching < 7.0% with liraglutide 1.8 mg compared with 1.2 mg (P = 0.018).  FIGURE 4',
     'At week 26, 42% and 21% of subjects treated with liraglutide 1.8 mg reached an HbA1c < 7.0% and ≤ 6.5%, respectively, compared with 8% and 4% for placebo ',
     'The estimated proportion of subjects treated with either liraglutide 1.2 or 1.8 mg reaching ADA/EASD and IDF/AACE HbA1c targets was substantially greater compared with either placebo (P < 0.0001) or rosiglitazone (Fig. 4; P ≤ 0.0003), with more patients reaching < 7.0% with liraglutide 1.8 mg compared with 1.2 mg (P = 0.018).  '],
    'Label Code': [1, 1, 1, 1],
    'In Abstract': [True, True, True, True],
    'Evidence Start': [16120, 16119, 15956, 16120],
    'Evidence End': [16315, 16457, 16110, 16449]},
   {'UserID': [0, 1, 3, 2],
    'PromptID': [137, 137, 137, 137],
    'PMCID': [2871176, 2871176, 2871176, 2871176],
    'Valid Label': [True, True, True, True],
    'Valid Reasoning': [True, True, True, True],
    'Label': ['significantly increased',
     'significantly increased',
     'significantly increased',
     'significantly increased'],
    'Annotations': ['HOMA-B increased with liraglutide (1.8 or 1.2 mg) compared with rosiglitazone (P < 0.05), while this increase was only different to placebo with liraglutide 1.2 mg (P = 0.01) and not liraglutide 1.8 mg (P = 0.051)',
     'HOMA-B increased with liraglutide (1.8 or 1.2 mg) compared with rosiglitazone (P < 0.05), while this increase was only different to placebo with liraglutide 1.2 mg (P = 0.01) and not liraglutide 1.8 mg (P = 0.051).',
     'HOMA-B increased with liraglutide (1.8 or 1.2 mg) compared with rosiglitazone (P < 0.05), while this increase was only different to placebo with liraglutide 1.2 mg (P = 0.01)',
     'HOMA-B increased with liraglutide (1.8 or 1.2 mg) compared with rosiglitazone (P < 0.05), while this increase was only different to placebo with liraglutide 1.2 mg (P = 0.01) and not liraglutide 1.8 mg (P = 0.051).'],
    'Label Code': [1, 1, 1, 1],
    'In Abstract': [True, True, True, True],
    'Evidence Start': [20728, 20728, 20728, 20728],
    'Evidence End': [20941, 20942, 20902, 20942]},
   {'UserID': [0, 1],
    'PromptID': [114, 114],
    'PMCID': [2871176, 2871176],
    'Valid Label': [True, True],
    'Valid Reasoning': [True, True],
    'Label': ['significantly increased', 'significantly increased'],
    'Annotations': ['The estimated proportion of subjects treated with either liraglutide 1.2 or 1.8 mg reaching ADA/EASD and IDF/AACE HbA1c targets was substantially greater compared with either placebo (P < 0.0001) or rosiglitazone (Fig. 4; P ≤ 0.0003), with more patients reaching < 7.0% with liraglutide 1.8 mg compared with 1.2 mg (P = 0.018).',
     'At week 26, 42% and 21% of subjects treated with liraglutide 1.8 mg reached an HbA1c < 7.0% and ≤ 6.5%, respectively, compared with 8% and 4% for placebo (Fig. 4). The estimated proportion of subjects treated with either liraglutide 1.2 or 1.8 mg reaching ADA/EASD and IDF/AACE HbA1c targets was substantially greater compared with either placebo (P < 0.0001) or rosiglitazone (Fig. 4; P ≤ 0.0003), with more patients reaching < 7.0% with liraglutide 1.8 mg compared with 1.2 mg (P = 0.018).  '],
    'Label Code': [1, 1],
    'In Abstract': [True, True],
    'Evidence Start': [16120, 15956],
    'Evidence End': [16447, 16449]},
   {'UserID': [0, 1, 3, 2],
    'PromptID': [108, 108, 108, 108],
    'PMCID': [2871176, 2871176, 2871176, 2871176],
    'Valid Label': [True, True, True, True],
    'Valid Reasoning': [True, True, True, True],
    'Label': ['no significant difference',
     'no significant difference',
     'no significant difference',
     'no significant difference'],
    'Annotations': ['Liraglutide 0.6 mg was non-inferior to rosiglitazone',
     'All liraglutide doses were superior to placebo (P < 0.0001), while the two higher liraglutide doses were superior to rosiglitazone (P < 0.0001). Liraglutide 0.6 mg was non-inferior to rosiglitazone.',
     'Liraglutide 0.6 mg was non-inferior to rosiglitazone',
     '. All liraglutide doses were superior to placebo (P < 0.0001), while the two higher liraglutide doses were superior to rosiglitazone (P < 0.0001). Liraglutide 0.6 mg was non-inferior to rosiglitazone.'],
    'Label Code': [0, 0, 0, 0],
    'In Abstract': [True, True, True, True],
    'Evidence Start': [14314, 14169, 14314, 14167],
    'Evidence End': [14366, 14367, 14366, 14367]},
   {'UserID': [0],
    'PromptID': [128],
    'PMCID': [2871176],
    'Valid Label': [True],
    'Valid Reasoning': [True],
    'Label': ['significantly increased'],
    'Annotations': ['The percentage of subjects with one, two or three PPG measurements < 10.0 mmol/l (ADA target) were greater for all doses of liraglutide compared with placebo (P < 0.05) but not rosiglitazone'],
    'Label Code': [1],
    'In Abstract': [True],
    'Evidence Start': [19433],
    'Evidence End': [19623]},
   {'UserID': [0, 1, 2],
    'PromptID': [134, 134, 134],
    'PMCID': [2871176, 2871176, 2871176],
    'Valid Label': [True, True, True],
    'Valid Reasoning': [True, True, True],
    'Label': ['significantly decreased',
     'significantly decreased',
     'significantly decreased'],
    'Annotations': ['Reductions in the proinsulin : insulin ratio were greater with both liraglutide 1.2 and 1.8 mg compared with either rosiglitazone or placebo (Table 2; P ≤ 0.02)',
     'Reductions in the proinsulin : insulin ratio were greater with both liraglutide 1.2 and 1.8 mg compared with either rosiglitazone or placebo (Table 2; P ≤ 0.02). ',
     'Reductions in the proinsulin : insulin ratio were greater with both liraglutide 1.2 and 1.8 mg compared with either rosiglitazone or placebo (Table 2; P ≤ 0.02). HOMA-B increased with liraglutide (1.8 or 1.2 mg) compared with rosiglitazone (P < 0.05), '],
    'Label Code': [-1, -1, -1],
    'In Abstract': [True, True, True],
    'Evidence Start': [20566, 20566, 20566],
    'Evidence End': [20726, 20728, 20818]},
   {'UserID': [0, 1, 3, 2],
    'PromptID': [115, 115, 115, 115],
    'PMCID': [2871176, 2871176, 2871176, 2871176],
    'Valid Label': [True, True, True, True],
    'Valid Reasoning': [True, True, True, True],
    'Label': ['significantly decreased',
     'significantly decreased',
     'significantly decreased',
     'significantly decreased'],
    'Annotations': ['Fasting plasma glucose decreased by week 2, with a 1.6 mmol/l decrease from baseline at week 26 with liraglutide 1.2 mg (baseline 9.8 mmol/l) or 1.8 mg (baseline 9.7 mmol/l) compared with a 0.9 mmol/l increase (placebo, P < 0.0001, baseline 9.5 mmol/l)',
     'Fasting plasma glucose decreased by week 2, with a 1.6 mmol/l decrease from baseline at week 26 with liraglutide 1.2 mg (baseline 9.8 mmol/l) or 1.8 mg (baseline 9.7 mmol/l) compared with a 0.9 mmol/l increase (placebo, P < 0.0001, baseline 9.5 mmol/l) or 1.0 mmol/l decrease (rosiglitazone, P < 0.006, baseline 9.9 mmol/l).',
     'At week 26, all doses of liraglutide decreased FPG more than did placebo (Fig. 5; P < 0.0001)',
     'Fasting plasma glucose decreased by week 2, with a 1.6 mmol/l decrease from baseline at week 26 with liraglutide 1.2 mg (baseline 9.8 mmol/l) or 1.8 mg (baseline 9.7 mmol/l) compared with a 0.9 mmol/l increase (placebo, P < 0.0001, baseline 9.5 mmol/l) or 1.0 mmol/l decrease (rosiglitazone, P < 0.006, baseline 9.9 mmol/l).'],
    'Label Code': [-1, -1, -1, -1],
    'In Abstract': [True, True, True, True],
    'Evidence Start': [1144, 1144, 17606, 1144],
    'Evidence End': [1396, 1468, 17699, 1468]},
   {'UserID': [0, 1, 2],
    'PromptID': [127, 127, 127],
    'PMCID': [2871176, 2871176, 2871176],
    'Valid Label': [True, True, True],
    'Valid Reasoning': [True, True, True],
    'Label': ['significantly increased',
     'significantly increased',
     'significantly increased'],
    'Annotations': ['The percentage of subjects with one, two or three PPG measurements < 10.0 mmol/l (ADA target) were greater for all doses of liraglutide compared with placebo (P < 0.05) but not rosiglitazone',
     'he percentage of subjects with one, two or three PPG measurements < 10.0 mmol/l (ADA target) were greater for all doses of liraglutide compared with placebo (P < 0.05) but not rosiglitazone.',
     'The percentage of subjects with one, two or three PPG measurements < 10.0 mmol/l (ADA target) were greater for all doses of liraglutide compared with placebo (P < 0.05) but not rosiglitazone.'],
    'Label Code': [1, 1, 1],
    'In Abstract': [True, True, True],
    'Evidence Start': [19433, 19434, 19433],
    'Evidence End': [19623, 19624, 19624]},
   {'UserID': [0, 1, 3, 2],
    'PromptID': [131, 131, 131, 131],
    'PMCID': [2871176, 2871176, 2871176, 2871176],
    'Valid Label': [True, True, True, True],
    'Valid Reasoning': [True, True, True, True],
    'Label': ['significantly decreased',
     'significantly decreased',
     'significantly decreased',
     'significantly decreased'],
    'Annotations': ['Reductions in the proinsulin : insulin ratio were greater with both liraglutide 1.2 and 1.8 mg compared with either rosiglitazone or placebo (Table 2; P ≤ 0.02)',
     'Reductions in the proinsulin : insulin ratio were greater with both liraglutide 1.2 and 1.8 mg compared with either rosiglitazone or placebo (Table 2; P ≤ 0.02). ',
     'Reductions in the proinsulin : insulin ratio were greater with both liraglutide 1.2 and 1.8 mg compared with either rosiglitazone or placebo (Table 2; P ≤ 0.02). ',
     'Reductions in the proinsulin : insulin ratio were greater with both liraglutide 1.2 and 1.8 mg compared with either rosiglitazone or placebo (Table 2; P ≤ 0.02)'],
    'Label Code': [-1, -1, -1, -1],
    'In Abstract': [True, True, True, True],
    'Evidence Start': [20566, 20566, 20566, 20566],
    'Evidence End': [20726, 20728, 20728, 20726]},
   {'UserID': [0, 1, 1, 3, 2],
    'PromptID': [109, 109, 109, 109, 109],
    'PMCID': [2871176, 2871176, 2871176, 2871176, 2871176],
    'Valid Label': [True, True, True, True, True],
    'Valid Reasoning': [True, True, True, True, True],
    'Label': ['significantly decreased',
     'significantly decreased',
     'significantly decreased',
     'significantly decreased',
     'significantly decreased'],
    'Annotations': ['Rosiglitazone also was superior to placebo (P < 0.0001)',
     'Rosiglitazone also was superior to placebo (P < 0.0001).',
     ' The greatest decreases occurred with liraglutide 1.2 and 1.8 mg (Fig. 3a–c). After 26 weeks, HbA1c decreased by 1.1% from baseline (primary endpoint) with either liraglutide 1.2 or 1.8 mg, respectively, compared with either placebo (+0.2%) or rosiglitazone (−0.4%) (Fig. 3d). Estimated treatment differences and 95% CIs to placebo were: liraglutide 1.8 mg: −1.4% (1.6, −1.1); liraglutide 1.2 mg: −1.3% (1.5, −1.1); liraglutide 0.6 mg: −0.8% (−1.1, −0.6); rosiglitazone: −0.7% (−0.9, −0.4). All liraglutide doses were superior to placebo (P < 0.0001), while the two higher liraglutide doses were superior to rosiglitazone (P < 0.0001). Liraglutide 0.6 mg was non-inferior to rosiglitazone. ',
     'Rosiglitazone also was superior to placebo (P < 0.0001).',
     'Rosiglitazone also was superior to placebo (P < 0.0001).'],
    'Label Code': [-1, -1, -1, -1, -1],
    'In Abstract': [True, True, True, True, True],
    'Evidence Start': [14368, 14368, 13678, 14368, 14368],
    'Evidence End': [14423, 14424, 14368, 14424, 14424]},
   {'UserID': [0, 1, 3, 2],
    'PromptID': [146, 146, 146, 146],
    'PMCID': [2871176, 2871176, 2871176, 2871176],
    'Valid Label': [True, True, True, True],
    'Valid Reasoning': [True, True, True, True],
    'Label': ['no significant difference',
     'no significant difference',
     'no significant difference',
     'no significant difference'],
    'Annotations': ['Reductions in diastolic blood pressure also occurred with all treatments (0.7–1.4 mmHg), with no significant differences between treatments.',
     'Reductions in diastolic blood pressure also occurred with all treatments (0.7–1.4 mmHg), with no significant differences between treatments. ',
     'Reductions in diastolic blood pressure also occurred with all treatments (0.7–1.4 mmHg), with no significant differences between treatments. ',
     'Reductions in diastolic blood pressure also occurred with all treatments (0.7–1.4 mmHg), with no significant differences between treatments. '],
    'Label Code': [0, 0, 0, 0],
    'In Abstract': [True, True, True, True],
    'Evidence Start': [22232, 22232, 22232, 22232],
    'Evidence End': [22372, 22373, 22373, 22373]},
   {'UserID': [0, 1, 3, 2],
    'PromptID': [110, 110, 110, 110],
    'PMCID': [2871176, 2871176, 2871176, 2871176],
    'Valid Label': [True, True, True, True],
    'Valid Reasoning': [True, True, True, True],
    'Label': ['significantly increased',
     'significantly increased',
     'significantly increased',
     'significantly increased'],
    'Annotations': ['The estimated proportion of subjects treated with either liraglutide 1.2 or 1.8 mg reaching ADA/EASD and IDF/AACE HbA1c targets was substantially greater compared with either placebo (P < 0.0001)',
     'The percentage of subjects reaching ADA [2] and International Diabetes Federation (IDF)/American Association of Clinical Endocrinologists (AACE) [11,12] treatment HbA1c goals with liraglutide was dose dependent (Fig. 4). At week 26, 42% and 21% of subjects treated with liraglutide 1.8 mg reached an HbA1c < 7.0% and ≤ 6.5%, respectively, compared with 8% and 4% for placebo (Fig. 4). The estimated proportion of subjects treated with either liraglutide 1.2 or 1.8 mg reaching ADA/EASD and IDF/AACE HbA1c targets was substantially greater compared with either placebo (P < 0.0001) or rosiglitazone (Fig. 4; P ≤ 0.0003), with more patients reaching < 7.0% with liraglutide 1.8 mg compared with 1.2 mg (P = 0.018).  ',
     'The estimated proportion of subjects treated with either liraglutide 1.2 or 1.8 mg reaching ADA/EASD and IDF/AACE HbA1c targets was substantially greater compared with either placebo (P < 0.0001) or rosiglitazone (Fig. 4; P ≤ 0.0003), with more patients reaching < 7.0% with liraglutide 1.8 mg compared with 1.2 mg (P = 0.018).  ',
     'The percentage of subjects reaching ADA [2] and International Diabetes Federation (IDF)/American Association of Clinical Endocrinologists (AACE) [11,12] treatment HbA1c goals with liraglutide was dose dependent (Fig. 4). At week 26, 42% and 21% of subjects treated with liraglutide 1.8 mg reached an HbA1c < 7.0% and ≤ 6.5%, respectively, compared with 8% and 4% for placebo (Fig. 4). The estimated proportion of subjects treated with either liraglutide 1.2 or 1.8 mg reaching ADA/EASD and IDF/AACE HbA1c targets was substantially greater compared with either placebo (P < 0.0001) or rosiglitazone (Fig. 4; P ≤ 0.0003), with more patients reaching < 7.0% with liraglutide 1.8 mg compared with 1.2 mg (P = 0.018).  '],
    'Label Code': [1, 1, 1, 1],
    'In Abstract': [True, True, True, True],
    'Evidence Start': [16120, 15735, 16120, 15735],
    'Evidence End': [16315, 16449, 16449, 16449]},
   {'UserID': [1, 3, 2],
    'PromptID': [100, 100, 100],
    'PMCID': [2871176, 2871176, 2871176],
    'Valid Label': [True, True, True],
    'Valid Reasoning': [True, True, True],
    'Label': ['significantly decreased',
     'significantly decreased',
     'significantly decreased'],
    'Annotations': ['After 26 weeks, HbA1c decreased by 1.1% from baseline (primary endpoint) with either liraglutide 1.2 or 1.8 mg, respectively, compared with either placebo (+0.2%) or rosiglitazone (−0.4%) (Fig. 3d). ',
     'After 26 weeks, HbA1c decreased by 1.1% from baseline (primary endpoint) with either liraglutide 1.2 or 1.8 mg, respectively, compared with either placebo (+0.2%) or rosiglitazone (−0.4%) ',
     'HbA1c decreased rapidly with all doses of liraglutide when added to glimepiride compared with either rosiglitazone or placebo (i.e. glimepiride monotherapy), irrespective of previous therapy. The greatest decreases occurred with liraglutide 1.2 and 1.8 mg (Fig. 3a–c). After 26 weeks, HbA1c decreased by 1.1% from baseline (primary endpoint) with either liraglutide 1.2 or 1.8 mg, respectively, compared with either placebo (+0.2%) or rosiglitazone (−0.4%) (Fig. 3d). Estimated treatment differences and 95% CIs to placebo were: liraglutide 1.8 mg: −1.4% (1.6, −1.1); liraglutide 1.2 mg: −1.3% (1.5, −1.1); liraglutide 0.6 mg: −0.8% (−1.1, −0.6); rosiglitazone: −0.7% (−0.9, −0.4). All liraglutide doses were superior to placebo (P < 0.0001), while the two higher liraglutide doses were superior to rosiglitazone (P < 0.0001). '],
    'Label Code': [-1, -1, -1],
    'In Abstract': [True, True, True],
    'Evidence Start': [13756, 13756, 13487],
    'Evidence End': [13955, 13944, 14314]},
   {'UserID': [0, 1, 3, 2],
    'PromptID': [138, 138, 138, 138],
    'PMCID': [2871176, 2871176, 2871176, 2871176],
    'Valid Label': [True, True, True, True],
    'Valid Reasoning': [True, True, True, True],
    'Label': ['no significant difference',
     'no significant difference',
     'no significant difference',
     'no significant difference'],
    'Annotations': ['HOMA-B increased with liraglutide (1.8 or 1.2 mg) compared with rosiglitazone (P < 0.05), while this increase was only different to placebo with liraglutide 1.2 mg (P = 0.01) and not liraglutide 1.8 mg (P = 0.051)',
     'HOMA-B increased with liraglutide (1.8 or 1.2 mg) compared with rosiglitazone (P < 0.05), while this increase was only different to placebo with liraglutide 1.2 mg (P = 0.01) and not liraglutide 1.8 mg (P = 0.051).',
     'HOMA-B increased with liraglutide (1.8 or 1.2 mg) compared with rosiglitazone (P < 0.05), while this increase was only different to placebo with liraglutide 1.2 mg (P = 0.01) and not liraglutide 1.8 mg (P = 0.051)',
     'HOMA-B increased with liraglutide (1.8 or 1.2 mg) compared with rosiglitazone (P < 0.05), while this increase was only different to placebo with liraglutide 1.2 mg (P = 0.01) and not liraglutide 1.8 mg (P = 0.051).'],
    'Label Code': [0, 0, 0, 0],
    'In Abstract': [True, True, True, True],
    'Evidence Start': [20728, 20728, 20728, 20728],
    'Evidence End': [20941, 20942, 20941, 20942]},
   {'UserID': [0, 1, 3, 2],
    'PromptID': [119, 119, 119, 119],
    'PMCID': [2871176, 2871176, 2871176, 2871176],
    'Valid Label': [True, True, True, True],
    'Valid Reasoning': [True, True, True, True],
    'Label': ['significantly increased',
     'significantly increased',
     'significantly increased',
     'significantly increased'],
    'Annotations': ['The percentage of subjects achieving FPG values between 5.0 mmol/l and ≤ 7.2 mmol/l (ADA target) after 26 weeks was higher with liraglutide: 0.6 mg (19%; P = 0.002); 1.2 mg (37%; P < 0.001); and 1.8 mg (38%;P < 0.001) compared with placebo (7%).',
     'The percentage of subjects achieving FPG values between 5.0 mmol/l and ≤ 7.2 mmol/l (ADA target) after 26 weeks was higher with liraglutide: 0.6 mg (19%; P = 0.002); 1.2 mg (37%; P < 0.001); and 1.8 mg (38%;P < 0.001) compared with placebo (7%). ',
     'The percentage of subjects achieving FPG values between 5.0 mmol/l and ≤ 7.2 mmol/l (ADA target) after 26 weeks was higher with liraglutide: 0.6 mg (19%; P = 0.002); 1.2 mg (37%; P < 0.001)',
     'The percentage of subjects achieving FPG values between 5.0 mmol/l and ≤ 7.2 mmol/l (ADA target) after 26 weeks was higher with liraglutide: 0.6 mg (19%; P = 0.002); 1.2 mg (37%; P < 0.001); and 1.8 mg (38%;P < 0.001) compared with placebo (7%). '],
    'Label Code': [1, 1, 1, 1],
    'In Abstract': [True, True, True, True],
    'Evidence Start': [18230, 18230, 18230, 18230],
    'Evidence End': [18475, 18476, 18419, 18476]},
   {'UserID': [0, 3, 2],
    'PromptID': [130, 130, 130],
    'PMCID': [2871176, 2871176, 2871176],
    'Valid Label': [True, True, True],
    'Valid Reasoning': [True, True, True],
    'Label': ['significantly increased',
     'significantly increased',
     'significantly increased'],
    'Annotations': ['Unlike rosiglitazone, weight did not increase substantially with liraglutide and the differences between rosiglitazone and liraglutide were statistically significant (−2.3 to −1.4 kg; P < 0.0001)',
     'Changes in body weight with liraglutide 1.8 mg (−0.2 kg, baseline 83.0 kg), 1.2 mg (+0.3 kg, baseline 80.0 kg) or placebo (−0.1 kg, baseline 81.9 kg) were less than with rosiglitazone (+2.1 kg, P < 0.0001, baseline 80.6 kg)',
     'Unlike rosiglitazone, weight did not increase substantially with liraglutide and the differences between rosiglitazone and liraglutide were statistically significant (−2.3 to −1.4 kg; P < 0.0001), although there were no significant differences compared with placebo. '],
    'Label Code': [1, 1, 1],
    'In Abstract': [True, True, True],
    'Evidence Start': [19950, 1756, 19950],
    'Evidence End': [20145, 1979, 20217]}]}}
```

### Data Fields

- `PMCID` (`int`): ID to identify the articles.
- `Text` (`str`): Article text.
- `Prompts` (`dict`): Prompts and annotations with keys:
  - 'PromptID': Which prompt the doctor is answering.
  - 'PMCID'
  - 'Outcome': Represent the fill-in-the-blank input for the following prompt formed "With respect to outcome, characterize the reported difference between intervention and those receiving comparator".
  - 'Intervention': Represent the fill-in-the-blank input for the following prompt formed "With respect to outcome, characterize the reported difference between intervention and those receiving comparator".
  - 'Comparator': Represent the fill-in-the-blank input for the following prompt formed "With respect to outcome, characterize the reported difference between intervention and those receiving comparator".
  - 'Annotations': The annotation files consist of the following headings: UserID, PromptID, PMCID, Valid Label, Valid Reasoning, Label, Annotations, Label Code, In Abstract, Start Evidence, End Evidence.

### Data Splits


| name | train | validation | test |
|------|------:|-----------:|-----:|
| 1.1  |  1931 |        248 |  240 |
| 2.0  |  2690 |        340 |  334 |

## Dataset Creation

### Curation Rationale

[More Information Needed]

### Source Data

[More Information Needed]

#### Initial Data Collection and Normalization

[More Information Needed]

#### Who are the source language producers?

[More Information Needed]

### Annotations

[More Information Needed]

#### Annotation process

[More Information Needed]

#### Who are the annotators?

[More Information Needed]

### Personal and Sensitive Information

[More Information Needed]

## Considerations for Using the Data

### Social Impact of Dataset

[More Information Needed]

### Discussion of Biases

[More Information Needed]

### Other Known Limitations

[More Information Needed]

## Additional Information

### Dataset Curators

[More Information Needed]

### Licensing Information

[More Information Needed]

### Citation Information

```
@inproceedings{lehman2019inferring,
  title={Inferring Which Medical Treatments Work from Reports of Clinical Trials},
  author={Lehman, Eric and DeYoung, Jay and Barzilay, Regina and Wallace, Byron C},
  booktitle={Proceedings of the North American Chapter of the Association for Computational Linguistics (NAACL)},
  pages={3705--3717},
  year={2019}
}

@misc{deyoung2020evidence,
    title={Evidence Inference 2.0: More Data, Better Models},
    author={Jay DeYoung and Eric Lehman and Ben Nye and Iain J. Marshall and Byron C. Wallace},
    year={2020},
    eprint={2005.04177},
    archivePrefix={arXiv},
    primaryClass={cs.CL}
}
```

### Contributions

Thanks to [@Narsil](https://github.com/Narsil) for adding this dataset.