# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['supabase', 'supabase.lib', 'supabase.lib.storage']

package_data = \
{'': ['*']}

install_requires = \
['gotrue>=0.5.0,<0.6.0',
 'httpx>=0.21.3,<0.22.0',
 'postgrest-py>=0.8.1,<0.9.0',
 'realtime>=0.0.4,<0.0.5']

setup_kwargs = {
    'name': 'supabase',
    'version': '0.3.2',
    'description': 'Supabase client for Python.',
    'long_description': '# supabase-py\n\n[![License: MIT](https://img.shields.io/badge/License-MIT-green.svg?label=license)](https://opensource.org/licenses/MIT)\n[![CI](https://github.com/supabase-community/supabase-py/actions/workflows/ci.yml/badge.svg)](https://github.com/supabase-community/supabase-py/actions/workflows/ci.yml)\n[![Python](https://img.shields.io/pypi/pyversions/supabase)](https://pypi.org/project/supabase)\n[![Version](https://img.shields.io/pypi/v/supabase?color=%2334D058)](https://pypi.org/project/supabase)\n[![Codecov](https://codecov.io/gh/supabase-community/supabase-py/branch/develop/graph/badge.svg)](https://codecov.io/gh/supabase-community/supabase-py)\n[![Last commit](https://img.shields.io/github/last-commit/supabase-community/supabase-py.svg?style=flat)](https://github.com/supabase-community/supabase-py/commits)\n[![GitHub commit activity](https://img.shields.io/github/commit-activity/m/supabase-community/supabase-py)](https://github.com/supabase-community/supabase-py/commits)\n[![Github Stars](https://img.shields.io/github/stars/supabase-community/supabase-py?style=flat&logo=github)](https://github.com/supabase-community/supabase-py/stargazers)\n[![Github Forks](https://img.shields.io/github/forks/supabase-community/supabase-py?style=flat&logo=github)](https://github.com/supabase-community/supabase-py/network/members)\n[![Github Watchers](https://img.shields.io/github/watchers/supabase-community/supabase-py?style=flat&logo=github)](https://github.com/supabase-community/supabase-py)\n[![GitHub contributors](https://img.shields.io/github/contributors/supabase-community/supabase-py)](https://github.com/supabase-community/supabase-py/graphs/contributors)\n\nSupabase client for Python. This mirrors the design of [supabase-js](https://github.com/supabase/supabase-js/blob/master/README.md)\n\n## Status\n\n- [x] Alpha: We are testing Supabase with a closed set of customers\n- [x] Public Alpha: Anyone can sign up over at [app.supabase.io](https://app.supabase.io). But go easy on us, there are a few kinks.\n- [ ] Public Beta: Stable enough for most non-enterprise use-cases\n- [ ] Public: Production-ready\n\nWe are currently in Public Alpha. Watch "releases" of this repo to get notified of major updates.\n\n<kbd><img src="https://gitcdn.link/repo/supabase/supabase/master/web/static/watch-repo.gif" alt="Watch this repo"/></kbd>\n\n## Installation\n\n**Recomended:** First activate your virtual environment, with your favourites system. For example, we like `poetry` and `conda`!\n\n### PyPi installation\n\nNow install the package. (for > Python 3.7)\n\n```bash\npip install supabase\n```\n\n### Local installation\n\nYou can also installing from after cloning this repo. Install like below to install in Development Mode, which means when you edit the source code the changes will be reflected in your python module.\n\n```bash\npip install -e .\n```\n\n## Usage\n\nIt\'s usually best practice to set your api key environment variables in some way that version control doesn\'t track them, e.g don\'t put them in your python modules! Set the key and url for the supabase instance in the shell, or better yet, use a dotenv file. Heres how to set the variables in the shell.\n\n```bash\nexport SUPABASE_URL="my-url-to-my-awesome-supabase-instance"\nexport SUPABASE_KEY="my-supa-dupa-secret-supabase-api-key"\n```\n\nWe can then read the keys in the python source code.\n\n```python\nimport os\nfrom supabase import create_client, Client\n\nurl: str = os.environ.get("SUPABASE_URL")\nkey: str = os.environ.get("SUPABASE_KEY")\nsupabase: Client = create_client(url, key)\n```\n\nUse the supabase client to interface with your database.\n\n### Running Tests\n\nCurrently the test suites are in a state of flux. We are expanding our clients tests to ensure things are working, and for now can connect to this test instance, that is populated with the following table:\n\n<p align="center">\n  <img width="720" height="481" src="https://i.ibb.co/Bq7Kdty/db.png">\n</p>\n\nThe above test database is a blank supabase instance that has populated the `countries` table with the built in countries script that can be found in the supabase UI. You can launch the test scripts and point to the above test database by running\n\n```bash\n./test.sh\n```\n\n### See issues for what to work on\n\nRough roadmap:\n\n- [ ] Wrap [Postgrest-py](https://github.com/supabase/postgrest-py/)\n- [ ] Wrap [Realtime-py](https://github.com/supabase/realtime-py)\n- [x] Wrap [Gotrue-py](https://github.com/J0/gotrue-py)\n\n### Client Library\n\nThis is a sample of how you\'d use supabase-py. Functions and tests are WIP\n\n## Authenticate\n\n```python\nfrom supabase import create_client, Client\n\nurl: str = os.environ.get("SUPABASE_TEST_URL")\nkey: str = os.environ.get("SUPABASE_TEST_KEY")\nsupabase: Client = create_client(url, key)\n# Create a random user login email and password.\nrandom_email: str = "3hf82fijf92@supamail.com"\nrandom_password: str = "fqj13bnf2hiu23h"\nuser = supabase.auth.sign_up(email=random_email, password=random_password)\n```\n\n## Sign-in\n\n```python\nfrom supabase import create_client, Client\n\nurl: str = os.environ.get("SUPABASE_TEST_URL")\nkey: str = os.environ.get("SUPABASE_TEST_KEY")\nsupabase: Client = create_client(url, key)\n# Sign in using the user email and password.\nrandom_email: str = "3hf82fijf92@supamail.com"\nrandom_password: str = "fqj13bnf2hiu23h"\nuser = supabase.auth.sign_in(email=random_email, password=random_password)\n```\n\n## Managing Data\n\n### Insertion of Data\n\n```python\nfrom supabase import create_client, Client\n\nurl: str = os.environ.get("SUPABASE_TEST_URL")\nkey: str = os.environ.get("SUPABASE_TEST_KEY")\nsupabase: Client = create_client(url, key)\ndata = supabase.table("countries").insert({"name":"Germany"}).execute()\nassert len(data.get("data", [])) > 0\n```\n\n### Selection of Data\n\n```python\nfrom supabase import create_client, Client\n\nurl: str = os.environ.get("SUPABASE_TEST_URL")\nkey: str = os.environ.get("SUPABASE_TEST_KEY")\nsupabase: Client = create_client(url, key)\ndata = supabase.table("countries").select("*").execute()\n# Assert we pulled real data.\nassert len(data.get("data", [])) > 0\n```\n\n### Update of Data\n\n```python\nfrom supabase import create_client, Client\n\nurl: str = os.environ.get("SUPABASE_TEST_URL")\nkey: str = os.environ.get("SUPABASE_TEST_KEY")\nsupabase: Client = create_client(url, key)\ndata = supabase.table("countries").update({"country": "Indonesia", "capital_city": "Jakarta"}).eq("id", "1").execute()\n```\n\n## Realtime Changes\n\nRealtime changes are unfortunately still a WIP. Feel free to file PRs to [realtime-py](https://github.com/supabase-community/realtime-py)\n\nSee [Supabase Docs](https://supabase.io/docs/guides/client-libraries) for full list of examples\n',
    'author': 'Joel Lee',
    'author_email': 'joel@joellee.org',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/supabase-community/supabase-py',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
