# -*- coding: utf-8 -*-
from south.utils import datetime_utils as datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models


class Migration(SchemaMigration):
    def forwards(self, orm):
        # Deleting model 'MentionedEvent'
        db.delete_table(u'sentry_hipchat_ac_mentionedevent')

    def backwards(self, orm):
        # Adding model 'MentionedEvent'
        db.create_table(
            u'sentry_hipchat_ac_mentionedevent', (
                (
                    'last_mentioned',
                    self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now)
                ), (
                    'group', self.gf('sentry.db.models.fields.foreignkey.FlexibleForeignKey')(
                        related_name='hipchat_mentioned_groups', to=orm['sentry.Group']
                    )
                ), (u'id', self.gf('django.db.models.fields.AutoField')(primary_key=True)), (
                    'project', self.gf('sentry.db.models.fields.foreignkey.FlexibleForeignKey')(
                        related_name='hipchat_mentioned_events', to=orm['sentry.Project']
                    )
                ), (
                    'event', self.gf('sentry.db.models.fields.foreignkey.FlexibleForeignKey')(
                        related_name='hipchat_mentioned_events', null=True, to=orm['sentry.Event']
                    )
                ), (
                    'tenant', self.gf('sentry.db.models.fields.foreignkey.FlexibleForeignKey')(
                        to=orm['sentry_hipchat_ac.Tenant']
                    )
                ),
            )
        )
        db.send_create_signal(u'hipchat_ac', ['MentionedEvent'])

    models = {
        'sentry.organization': {
            'Meta': {
                'object_name': 'Organization'
            },
            'date_added':
            ('django.db.models.fields.DateTimeField', [], {
                'default': 'datetime.datetime.now'
            }),
            'flags': ('django.db.models.fields.BigIntegerField', [], {
                'default': '1'
            }),
            'id':
            ('sentry.db.models.fields.bounded.BoundedBigAutoField', [], {
                'primary_key': 'True'
            }),
            'members': (
                'django.db.models.fields.related.ManyToManyField', [], {
                    'related_name': "'org_memberships'",
                    'symmetrical': 'False',
                    'through': "orm['sentry.OrganizationMember']",
                    'to': "orm['sentry.User']"
                }
            ),
            'name': ('django.db.models.fields.CharField', [], {
                'max_length': '64'
            }),
            'slug':
            ('django.db.models.fields.SlugField', [], {
                'unique': 'True',
                'max_length': '50'
            }),
            'status':
            ('sentry.db.models.fields.bounded.BoundedPositiveIntegerField', [], {
                'default': '0'
            })
        },
        'sentry.organizationmember': {
            'Meta': {
                'unique_together': "(('organization', 'user'), ('organization', 'email'))",
                'object_name': 'OrganizationMember'
            },
            'counter': (
                'sentry.db.models.fields.bounded.BoundedPositiveIntegerField', [], {
                    'null': 'True',
                    'blank': 'True'
                }
            ),
            'date_added':
            ('django.db.models.fields.DateTimeField', [], {
                'default': 'datetime.datetime.now'
            }),
            'email': (
                'django.db.models.fields.EmailField', [], {
                    'max_length': '75',
                    'null': 'True',
                    'blank': 'True'
                }
            ),
            'flags': ('django.db.models.fields.BigIntegerField', [], {
                'default': '0'
            }),
            'has_global_access': ('django.db.models.fields.BooleanField', [], {
                'default': 'True'
            }),
            'id':
            ('sentry.db.models.fields.bounded.BoundedBigAutoField', [], {
                'primary_key': 'True'
            }),
            'organization': (
                'sentry.db.models.fields.foreignkey.FlexibleForeignKey', [], {
                    'related_name': "'member_set'",
                    'to': "orm['sentry.Organization']"
                }
            ),
            'role':
            ('django.db.models.fields.CharField', [], {
                'default': "'member'",
                'max_length': '32'
            }),
            'teams': (
                'django.db.models.fields.related.ManyToManyField', [], {
                    'to': "orm['sentry.Team']",
                    'symmetrical': 'False',
                    'through': "orm['sentry.OrganizationMemberTeam']",
                    'blank': 'True'
                }
            ),
            'type':
            ('sentry.db.models.fields.bounded.BoundedPositiveIntegerField', [], {
                'default': '50'
            }),
            'user': (
                'sentry.db.models.fields.foreignkey.FlexibleForeignKey', [], {
                    'blank': 'True',
                    'related_name': "'sentry_orgmember_set'",
                    'null': 'True',
                    'to': "orm['sentry.User']"
                }
            )
        },
        'sentry.organizationmemberteam': {
            'Meta': {
                'unique_together': "(('team', 'organizationmember'),)",
                'object_name': 'OrganizationMemberTeam',
                'db_table': "'sentry_organizationmember_teams'"
            },
            'id': ('sentry.db.models.fields.bounded.BoundedAutoField', [], {
                'primary_key': 'True'
            }),
            'is_active': ('django.db.models.fields.BooleanField', [], {
                'default': 'True'
            }),
            'organizationmember': (
                'sentry.db.models.fields.foreignkey.FlexibleForeignKey', [], {
                    'to': "orm['sentry.OrganizationMember']"
                }
            ),
            'team': (
                'sentry.db.models.fields.foreignkey.FlexibleForeignKey', [], {
                    'to': "orm['sentry.Team']"
                }
            )
        },
        'sentry.project': {
            'Meta': {
                'unique_together': "(('team', 'slug'), ('organization', 'slug'))",
                'object_name': 'Project'
            },
            'date_added':
            ('django.db.models.fields.DateTimeField', [], {
                'default': 'datetime.datetime.now'
            }),
            'first_event': ('django.db.models.fields.DateTimeField', [], {
                'null': 'True'
            }),
            'id':
            ('sentry.db.models.fields.bounded.BoundedBigAutoField', [], {
                'primary_key': 'True'
            }),
            'name': ('django.db.models.fields.CharField', [], {
                'max_length': '200'
            }),
            'organization': (
                'sentry.db.models.fields.foreignkey.FlexibleForeignKey', [], {
                    'to': "orm['sentry.Organization']"
                }
            ),
            'public': ('django.db.models.fields.BooleanField', [], {
                'default': 'False'
            }),
            'slug': ('django.db.models.fields.SlugField', [], {
                'max_length': '50',
                'null': 'True'
            }),
            'status': (
                'sentry.db.models.fields.bounded.BoundedPositiveIntegerField', [], {
                    'default': '0',
                    'db_index': 'True'
                }
            ),
            'team': (
                'sentry.db.models.fields.foreignkey.FlexibleForeignKey', [], {
                    'to': "orm['sentry.Team']"
                }
            )
        },
        'sentry.team': {
            'Meta': {
                'unique_together': "(('organization', 'slug'),)",
                'object_name': 'Team'
            },
            'date_added': (
                'django.db.models.fields.DateTimeField', [], {
                    'default': 'datetime.datetime.now',
                    'null': 'True'
                }
            ),
            'id':
            ('sentry.db.models.fields.bounded.BoundedBigAutoField', [], {
                'primary_key': 'True'
            }),
            'name': ('django.db.models.fields.CharField', [], {
                'max_length': '64'
            }),
            'organization': (
                'sentry.db.models.fields.foreignkey.FlexibleForeignKey', [], {
                    'to': "orm['sentry.Organization']"
                }
            ),
            'slug': ('django.db.models.fields.SlugField', [], {
                'max_length': '50'
            }),
            'status':
            ('sentry.db.models.fields.bounded.BoundedPositiveIntegerField', [], {
                'default': '0'
            })
        },
        'sentry.user': {
            'Meta': {
                'object_name': 'User',
                'db_table': "'auth_user'"
            },
            'date_joined':
            ('django.db.models.fields.DateTimeField', [], {
                'default': 'datetime.datetime.now'
            }),
            'email':
            ('django.db.models.fields.EmailField', [], {
                'max_length': '75',
                'blank': 'True'
            }),
            'first_name':
            ('django.db.models.fields.CharField', [], {
                'max_length': '30',
                'blank': 'True'
            }),
            'id': ('sentry.db.models.fields.bounded.BoundedAutoField', [], {
                'primary_key': 'True'
            }),
            'is_active': ('django.db.models.fields.BooleanField', [], {
                'default': 'True'
            }),
            'is_managed': ('django.db.models.fields.BooleanField', [], {
                'default': 'False'
            }),
            'is_staff': ('django.db.models.fields.BooleanField', [], {
                'default': 'False'
            }),
            'is_superuser': ('django.db.models.fields.BooleanField', [], {
                'default': 'False'
            }),
            'last_login':
            ('django.db.models.fields.DateTimeField', [], {
                'default': 'datetime.datetime.now'
            }),
            'last_name':
            ('django.db.models.fields.CharField', [], {
                'max_length': '30',
                'blank': 'True'
            }),
            'password': ('django.db.models.fields.CharField', [], {
                'max_length': '128'
            }),
            'username':
            ('django.db.models.fields.CharField', [], {
                'unique': 'True',
                'max_length': '128'
            })
        },
        u'sentry_hipchat_ac.tenant': {
            'Meta': {
                'object_name': 'Tenant'
            },
            'api_base_url': ('django.db.models.fields.CharField', [], {
                'max_length': '250'
            }),
            'auth_user': (
                'sentry.db.models.fields.foreignkey.FlexibleForeignKey', [], {
                    'related_name': "'hipchat_tenant_set'",
                    'null': 'True',
                    'to': "orm['sentry.User']"
                }
            ),
            'capabilities_url': ('django.db.models.fields.CharField', [], {
                'max_length': '250'
            }),
            'homepage': ('django.db.models.fields.CharField', [], {
                'max_length': '250'
            }),
            'id':
            ('django.db.models.fields.CharField', [], {
                'max_length': '40',
                'primary_key': 'True'
            }),
            'installed_from': ('django.db.models.fields.CharField', [], {
                'max_length': '250'
            }),
            'organizations': (
                'django.db.models.fields.related.ManyToManyField', [], {
                    'related_name': "'hipchat_tenant_set'",
                    'symmetrical': 'False',
                    'to': "orm['sentry.Organization']"
                }
            ),
            'projects': (
                'django.db.models.fields.related.ManyToManyField', [], {
                    'related_name': "'hipchat_tenant_set'",
                    'symmetrical': 'False',
                    'to': "orm['sentry.Project']"
                }
            ),
            'room_id': ('django.db.models.fields.CharField', [], {
                'max_length': '40'
            }),
            'room_name':
            ('django.db.models.fields.CharField', [], {
                'max_length': '200',
                'null': 'True'
            }),
            'room_owner_id':
            ('django.db.models.fields.CharField', [], {
                'max_length': '40',
                'null': 'True'
            }),
            'room_owner_name':
            ('django.db.models.fields.CharField', [], {
                'max_length': '200',
                'null': 'True'
            }),
            'secret': ('django.db.models.fields.CharField', [], {
                'max_length': '120'
            }),
            'token_url': ('django.db.models.fields.CharField', [], {
                'max_length': '250'
            })
        }
    }

    complete_apps = ['hipchat_ac']
