# -*- coding: utf-8 -*-
from south.utils import datetime_utils as datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models
from sentry.db.models import FlexibleForeignKey


class Migration(SchemaMigration):
    def forwards(self, orm):
        # Adding model 'MentionedEvent'
        db.create_table(
            u'sentry_hipchat_ac_mentionedevent', (
                (u'id', self.gf('django.db.models.fields.AutoField')(primary_key=True)), (
                    'project', self.gf('sentry.db.models.fields.foreignkey.FlexibleForeignKey')(
                        related_name='hipchat_mentioned_events', to=orm['sentry.Project']
                    )
                ), (
                    'group', self.gf('sentry.db.models.fields.foreignkey.FlexibleForeignKey')(
                        related_name='hipchat_mentioned_groups', to=orm['sentry.Group']
                    )
                ), (
                    'event', self.gf('sentry.db.models.fields.foreignkey.FlexibleForeignKey')(
                        related_name='hipchat_mentioned_events', null=True, to=orm['sentry.Event']
                    )
                ), (
                    'tenant', self.gf('sentry.db.models.fields.foreignkey.FlexibleForeignKey')(
                        to=orm['sentry_hipchat_ac.Tenant']
                    )
                ), (
                    'last_mentioned',
                    self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now)
                ),
            )
        )
        db.send_create_signal(u'hipchat_ac', ['MentionedEvent'])

        # Adding model 'Tenant'
        db.create_table(
            u'sentry_hipchat_ac_tenant', (
                (
                    'id',
                    self.gf('django.db.models.fields.CharField')(max_length=40, primary_key=True)
                ), ('room_id', self.gf('django.db.models.fields.CharField')(max_length=40)), (
                    'room_name',
                    self.gf('django.db.models.fields.CharField')(max_length=200, null=True)
                ), (
                    'room_owner_id',
                    self.gf('django.db.models.fields.CharField')(max_length=40, null=True)
                ), (
                    'room_owner_name',
                    self.gf('django.db.models.fields.CharField')(max_length=200, null=True)
                ), ('secret', self.gf('django.db.models.fields.CharField')(max_length=120)),
                ('homepage', self.gf('django.db.models.fields.CharField')(max_length=250)),
                ('token_url', self.gf('django.db.models.fields.CharField')(max_length=250)),
                ('capabilities_url', self.gf('django.db.models.fields.CharField')(max_length=250)),
                ('api_base_url', self.gf('django.db.models.fields.CharField')(max_length=250)),
                ('installed_from', self.gf('django.db.models.fields.CharField')(max_length=250)), (
                    'auth_user', self.gf('sentry.db.models.fields.foreignkey.FlexibleForeignKey')(
                        related_name='hipchat_tenant_set', null=True, to=orm['sentry.User']
                    )
                ),
            )
        )
        db.send_create_signal(u'hipchat_ac', ['Tenant'])

        # Adding M2M table for field organizations on 'Tenant'
        m2m_table_name = db.shorten_name(u'sentry_hipchat_ac_tenant_organizations')
        db.create_table(
            m2m_table_name, (
                ('id', models.AutoField(verbose_name='ID', primary_key=True, auto_created=True)),
                ('tenant', models.ForeignKey(orm[u'sentry_hipchat_ac.tenant'], null=False)),
                ('organization', FlexibleForeignKey(orm['sentry.organization'], null=False))
            )
        )
        db.create_unique(m2m_table_name, ['tenant_id', 'organization_id'])

        # Adding M2M table for field projects on 'Tenant'
        m2m_table_name = db.shorten_name(u'sentry_hipchat_ac_tenant_projects')
        db.create_table(
            m2m_table_name, (
                ('id', models.AutoField(verbose_name='ID', primary_key=True, auto_created=True)),
                ('tenant', models.ForeignKey(orm[u'sentry_hipchat_ac.tenant'], null=False)),
                ('project', FlexibleForeignKey(orm['sentry.project'], null=False))
            )
        )
        db.create_unique(m2m_table_name, ['tenant_id', 'project_id'])

    def backwards(self, orm):
        # Deleting model 'MentionedEvent'
        db.delete_table(u'sentry_hipchat_ac_mentionedevent')

        # Deleting model 'Tenant'
        db.delete_table(u'sentry_hipchat_ac_tenant')

        # Removing M2M table for field organizations on 'Tenant'
        db.delete_table(db.shorten_name(u'sentry_hipchat_ac_tenant_organizations'))

        # Removing M2M table for field projects on 'Tenant'
        db.delete_table(db.shorten_name(u'sentry_hipchat_ac_tenant_projects'))

    models = {
        'sentry.event': {
            'Meta': {
                'unique_together': "(('project', 'event_id'),)",
                'object_name': 'Event',
                'db_table': "'sentry_message'",
                'index_together': "(('group', 'datetime'),)"
            },
            'data':
            ('sentry.db.models.fields.node.NodeField', [], {
                'null': 'True',
                'blank': 'True'
            }),
            'datetime': (
                'django.db.models.fields.DateTimeField', [], {
                    'default': 'datetime.datetime.now',
                    'db_index': 'True'
                }
            ),
            'event_id': (
                'django.db.models.fields.CharField', [], {
                    'max_length': '32',
                    'null': 'True',
                    'db_column': "'message_id'"
                }
            ),
            'group': (
                'sentry.db.models.fields.foreignkey.FlexibleForeignKey', [], {
                    'blank': 'True',
                    'related_name': "'event_set'",
                    'null': 'True',
                    'to': "orm['sentry.Group']"
                }
            ),
            'id':
            ('sentry.db.models.fields.bounded.BoundedBigAutoField', [], {
                'primary_key': 'True'
            }),
            'message': ('django.db.models.fields.TextField', [], {}),
            'num_comments': (
                'sentry.db.models.fields.bounded.BoundedPositiveIntegerField', [], {
                    'default': '0',
                    'null': 'True'
                }
            ),
            'platform':
            ('django.db.models.fields.CharField', [], {
                'max_length': '64',
                'null': 'True'
            }),
            'project': (
                'sentry.db.models.fields.foreignkey.FlexibleForeignKey', [], {
                    'to': "orm['sentry.Project']",
                    'null': 'True'
                }
            ),
            'time_spent':
            ('sentry.db.models.fields.bounded.BoundedIntegerField', [], {
                'null': 'True'
            })
        },
        'sentry.group': {
            'Meta': {
                'object_name': 'Group',
                'db_table': "'sentry_groupedmessage'",
                'index_together': "(('project', 'first_release'),)"
            },
            'active_at':
            ('django.db.models.fields.DateTimeField', [], {
                'null': 'True',
                'db_index': 'True'
            }),
            'culprit': (
                'django.db.models.fields.CharField', [], {
                    'max_length': '200',
                    'null': 'True',
                    'db_column': "'view'",
                    'blank': 'True'
                }
            ),
            'data': (
                'sentry.db.models.fields.gzippeddict.GzippedDictField', [], {
                    'null': 'True',
                    'blank': 'True'
                }
            ),
            'first_release': (
                'sentry.db.models.fields.foreignkey.FlexibleForeignKey', [], {
                    'to': "orm['sentry.Release']",
                    'null': 'True'
                }
            ),
            'first_seen': (
                'django.db.models.fields.DateTimeField', [], {
                    'default': 'datetime.datetime.now',
                    'db_index': 'True'
                }
            ),
            'id':
            ('sentry.db.models.fields.bounded.BoundedBigAutoField', [], {
                'primary_key': 'True'
            }),
            'is_public': (
                'django.db.models.fields.NullBooleanField', [], {
                    'default': 'False',
                    'null': 'True',
                    'blank': 'True'
                }
            ),
            'last_seen': (
                'django.db.models.fields.DateTimeField', [], {
                    'default': 'datetime.datetime.now',
                    'db_index': 'True'
                }
            ),
            'level': (
                'sentry.db.models.fields.bounded.BoundedPositiveIntegerField', [], {
                    'default': '40',
                    'db_index': 'True',
                    'blank': 'True'
                }
            ),
            'logger': (
                'django.db.models.fields.CharField', [], {
                    'default': "''",
                    'max_length': '64',
                    'db_index': 'True',
                    'blank': 'True'
                }
            ),
            'message': ('django.db.models.fields.TextField', [], {}),
            'num_comments': (
                'sentry.db.models.fields.bounded.BoundedPositiveIntegerField', [], {
                    'default': '0',
                    'null': 'True'
                }
            ),
            'platform':
            ('django.db.models.fields.CharField', [], {
                'max_length': '64',
                'null': 'True'
            }),
            'project': (
                'sentry.db.models.fields.foreignkey.FlexibleForeignKey', [], {
                    'to': "orm['sentry.Project']",
                    'null': 'True'
                }
            ),
            'resolved_at':
            ('django.db.models.fields.DateTimeField', [], {
                'null': 'True',
                'db_index': 'True'
            }),
            'score': ('sentry.db.models.fields.bounded.BoundedIntegerField', [], {
                'default': '0'
            }),
            'status': (
                'sentry.db.models.fields.bounded.BoundedPositiveIntegerField', [], {
                    'default': '0',
                    'db_index': 'True'
                }
            ),
            'time_spent_count':
            ('sentry.db.models.fields.bounded.BoundedIntegerField', [], {
                'default': '0'
            }),
            'time_spent_total':
            ('sentry.db.models.fields.bounded.BoundedIntegerField', [], {
                'default': '0'
            }),
            'times_seen': (
                'sentry.db.models.fields.bounded.BoundedPositiveIntegerField', [], {
                    'default': '1',
                    'db_index': 'True'
                }
            )
        },
        'sentry.organization': {
            'Meta': {
                'object_name': 'Organization'
            },
            'date_added':
            ('django.db.models.fields.DateTimeField', [], {
                'default': 'datetime.datetime.now'
            }),
            'flags': ('django.db.models.fields.BigIntegerField', [], {
                'default': '0'
            }),
            'id':
            ('sentry.db.models.fields.bounded.BoundedBigAutoField', [], {
                'primary_key': 'True'
            }),
            'members': (
                'django.db.models.fields.related.ManyToManyField', [], {
                    'related_name': "'org_memberships'",
                    'symmetrical': 'False',
                    'through': "orm['sentry.OrganizationMember']",
                    'to': "orm['sentry.User']"
                }
            ),
            'name': ('django.db.models.fields.CharField', [], {
                'max_length': '64'
            }),
            'slug':
            ('django.db.models.fields.SlugField', [], {
                'unique': 'True',
                'max_length': '50'
            }),
            'status':
            ('sentry.db.models.fields.bounded.BoundedPositiveIntegerField', [], {
                'default': '0'
            })
        },
        'sentry.organizationmember': {
            'Meta': {
                'unique_together': "(('organization', 'user'), ('organization', 'email'))",
                'object_name': 'OrganizationMember'
            },
            'counter': (
                'sentry.db.models.fields.bounded.BoundedPositiveIntegerField', [], {
                    'null': 'True',
                    'blank': 'True'
                }
            ),
            'date_added':
            ('django.db.models.fields.DateTimeField', [], {
                'default': 'datetime.datetime.now'
            }),
            'email': (
                'django.db.models.fields.EmailField', [], {
                    'max_length': '75',
                    'null': 'True',
                    'blank': 'True'
                }
            ),
            'flags': ('django.db.models.fields.BigIntegerField', [], {
                'default': '0'
            }),
            'has_global_access': ('django.db.models.fields.BooleanField', [], {
                'default': 'True'
            }),
            'id':
            ('sentry.db.models.fields.bounded.BoundedBigAutoField', [], {
                'primary_key': 'True'
            }),
            'organization': (
                'sentry.db.models.fields.foreignkey.FlexibleForeignKey', [], {
                    'related_name': "'member_set'",
                    'to': "orm['sentry.Organization']"
                }
            ),
            'teams': (
                'django.db.models.fields.related.ManyToManyField', [], {
                    'to': "orm['sentry.Team']",
                    'symmetrical': 'False',
                    'through': "orm['sentry.OrganizationMemberTeam']",
                    'blank': 'True'
                }
            ),
            'type':
            ('sentry.db.models.fields.bounded.BoundedPositiveIntegerField', [], {
                'default': '50'
            }),
            'user': (
                'sentry.db.models.fields.foreignkey.FlexibleForeignKey', [], {
                    'blank': 'True',
                    'related_name': "'sentry_orgmember_set'",
                    'null': 'True',
                    'to': "orm['sentry.User']"
                }
            )
        },
        'sentry.organizationmemberteam': {
            'Meta': {
                'unique_together': "(('team', 'organizationmember'),)",
                'object_name': 'OrganizationMemberTeam',
                'db_table': "'sentry_organizationmember_teams'"
            },
            'id': ('sentry.db.models.fields.bounded.BoundedAutoField', [], {
                'primary_key': 'True'
            }),
            'is_active': ('django.db.models.fields.BooleanField', [], {
                'default': 'True'
            }),
            'organizationmember': (
                'sentry.db.models.fields.foreignkey.FlexibleForeignKey', [], {
                    'to': "orm['sentry.OrganizationMember']"
                }
            ),
            'team': (
                'sentry.db.models.fields.foreignkey.FlexibleForeignKey', [], {
                    'to': "orm['sentry.Team']"
                }
            )
        },
        'sentry.project': {
            'Meta': {
                'unique_together': "(('team', 'slug'), ('organization', 'slug'))",
                'object_name': 'Project'
            },
            'date_added':
            ('django.db.models.fields.DateTimeField', [], {
                'default': 'datetime.datetime.now'
            }),
            'first_event': ('django.db.models.fields.DateTimeField', [], {
                'null': 'True'
            }),
            'id':
            ('sentry.db.models.fields.bounded.BoundedBigAutoField', [], {
                'primary_key': 'True'
            }),
            'name': ('django.db.models.fields.CharField', [], {
                'max_length': '200'
            }),
            'organization': (
                'sentry.db.models.fields.foreignkey.FlexibleForeignKey', [], {
                    'to': "orm['sentry.Organization']"
                }
            ),
            'public': ('django.db.models.fields.BooleanField', [], {
                'default': 'False'
            }),
            'slug': ('django.db.models.fields.SlugField', [], {
                'max_length': '50',
                'null': 'True'
            }),
            'status': (
                'sentry.db.models.fields.bounded.BoundedPositiveIntegerField', [], {
                    'default': '0',
                    'db_index': 'True'
                }
            ),
            'team': (
                'sentry.db.models.fields.foreignkey.FlexibleForeignKey', [], {
                    'to': "orm['sentry.Team']"
                }
            )
        },
        'sentry.release': {
            'Meta': {
                'unique_together': "(('project', 'version'),)",
                'object_name': 'Release'
            },
            'data': ('jsonfield.fields.JSONField', [], {
                'default': '{}'
            }),
            'date_added':
            ('django.db.models.fields.DateTimeField', [], {
                'default': 'datetime.datetime.now'
            }),
            'date_released':
            ('django.db.models.fields.DateTimeField', [], {
                'null': 'True',
                'blank': 'True'
            }),
            'date_started':
            ('django.db.models.fields.DateTimeField', [], {
                'null': 'True',
                'blank': 'True'
            }),
            'id':
            ('sentry.db.models.fields.bounded.BoundedBigAutoField', [], {
                'primary_key': 'True'
            }),
            'new_groups':
            ('sentry.db.models.fields.bounded.BoundedPositiveIntegerField', [], {
                'default': '0'
            }),
            'owner': (
                'sentry.db.models.fields.foreignkey.FlexibleForeignKey', [], {
                    'to': "orm['sentry.User']",
                    'null': 'True',
                    'blank': 'True'
                }
            ),
            'project': (
                'sentry.db.models.fields.foreignkey.FlexibleForeignKey', [], {
                    'to': "orm['sentry.Project']"
                }
            ),
            'ref': (
                'django.db.models.fields.CharField', [], {
                    'max_length': '64',
                    'null': 'True',
                    'blank': 'True'
                }
            ),
            'url': (
                'django.db.models.fields.URLField', [], {
                    'max_length': '200',
                    'null': 'True',
                    'blank': 'True'
                }
            ),
            'version': ('django.db.models.fields.CharField', [], {
                'max_length': '64'
            })
        },
        'sentry.team': {
            'Meta': {
                'unique_together': "(('organization', 'slug'),)",
                'object_name': 'Team'
            },
            'date_added': (
                'django.db.models.fields.DateTimeField', [], {
                    'default': 'datetime.datetime.now',
                    'null': 'True'
                }
            ),
            'id':
            ('sentry.db.models.fields.bounded.BoundedBigAutoField', [], {
                'primary_key': 'True'
            }),
            'name': ('django.db.models.fields.CharField', [], {
                'max_length': '64'
            }),
            'organization': (
                'sentry.db.models.fields.foreignkey.FlexibleForeignKey', [], {
                    'to': "orm['sentry.Organization']"
                }
            ),
            'slug': ('django.db.models.fields.SlugField', [], {
                'max_length': '50'
            }),
            'status':
            ('sentry.db.models.fields.bounded.BoundedPositiveIntegerField', [], {
                'default': '0'
            })
        },
        'sentry.user': {
            'Meta': {
                'object_name': 'User',
                'db_table': "'auth_user'"
            },
            'date_joined':
            ('django.db.models.fields.DateTimeField', [], {
                'default': 'datetime.datetime.now'
            }),
            'email':
            ('django.db.models.fields.EmailField', [], {
                'max_length': '75',
                'blank': 'True'
            }),
            'first_name':
            ('django.db.models.fields.CharField', [], {
                'max_length': '30',
                'blank': 'True'
            }),
            'id': ('sentry.db.models.fields.bounded.BoundedAutoField', [], {
                'primary_key': 'True'
            }),
            'is_active': ('django.db.models.fields.BooleanField', [], {
                'default': 'True'
            }),
            'is_managed': ('django.db.models.fields.BooleanField', [], {
                'default': 'False'
            }),
            'is_staff': ('django.db.models.fields.BooleanField', [], {
                'default': 'False'
            }),
            'is_superuser': ('django.db.models.fields.BooleanField', [], {
                'default': 'False'
            }),
            'last_login':
            ('django.db.models.fields.DateTimeField', [], {
                'default': 'datetime.datetime.now'
            }),
            'last_name':
            ('django.db.models.fields.CharField', [], {
                'max_length': '30',
                'blank': 'True'
            }),
            'password': ('django.db.models.fields.CharField', [], {
                'max_length': '128'
            }),
            'username':
            ('django.db.models.fields.CharField', [], {
                'unique': 'True',
                'max_length': '128'
            })
        },
        u'sentry_hipchat_ac.mentionedevent': {
            'Meta': {
                'object_name': 'MentionedEvent'
            },
            'event': (
                'sentry.db.models.fields.foreignkey.FlexibleForeignKey', [], {
                    'related_name': "'hipchat_mentioned_events'",
                    'null': 'True',
                    'to': "orm['sentry.Event']"
                }
            ),
            'group': (
                'sentry.db.models.fields.foreignkey.FlexibleForeignKey', [], {
                    'related_name': "'hipchat_mentioned_groups'",
                    'to': "orm['sentry.Group']"
                }
            ),
            u'id': ('django.db.models.fields.AutoField', [], {
                'primary_key': 'True'
            }),
            'last_mentioned':
            ('django.db.models.fields.DateTimeField', [], {
                'default': 'datetime.datetime.now'
            }),
            'project': (
                'sentry.db.models.fields.foreignkey.FlexibleForeignKey', [], {
                    'related_name': "'hipchat_mentioned_events'",
                    'to': "orm['sentry.Project']"
                }
            ),
            'tenant': (
                'sentry.db.models.fields.foreignkey.FlexibleForeignKey', [], {
                    'to': u"orm['sentry_hipchat_ac.Tenant']"
                }
            )
        },
        u'sentry_hipchat_ac.tenant': {
            'Meta': {
                'object_name': 'Tenant'
            },
            'api_base_url': ('django.db.models.fields.CharField', [], {
                'max_length': '250'
            }),
            'auth_user': (
                'sentry.db.models.fields.foreignkey.FlexibleForeignKey', [], {
                    'related_name': "'hipchat_tenant_set'",
                    'null': 'True',
                    'to': "orm['sentry.User']"
                }
            ),
            'capabilities_url': ('django.db.models.fields.CharField', [], {
                'max_length': '250'
            }),
            'homepage': ('django.db.models.fields.CharField', [], {
                'max_length': '250'
            }),
            'id':
            ('django.db.models.fields.CharField', [], {
                'max_length': '40',
                'primary_key': 'True'
            }),
            'installed_from': ('django.db.models.fields.CharField', [], {
                'max_length': '250'
            }),
            'organizations': (
                'django.db.models.fields.related.ManyToManyField', [], {
                    'related_name': "'hipchat_tenant_set'",
                    'symmetrical': 'False',
                    'to': "orm['sentry.Organization']"
                }
            ),
            'projects': (
                'django.db.models.fields.related.ManyToManyField', [], {
                    'related_name': "'hipchat_tenant_set'",
                    'symmetrical': 'False',
                    'to': "orm['sentry.Project']"
                }
            ),
            'room_id': ('django.db.models.fields.CharField', [], {
                'max_length': '40'
            }),
            'room_name':
            ('django.db.models.fields.CharField', [], {
                'max_length': '200',
                'null': 'True'
            }),
            'room_owner_id':
            ('django.db.models.fields.CharField', [], {
                'max_length': '40',
                'null': 'True'
            }),
            'room_owner_name':
            ('django.db.models.fields.CharField', [], {
                'max_length': '200',
                'null': 'True'
            }),
            'secret': ('django.db.models.fields.CharField', [], {
                'max_length': '120'
            }),
            'token_url': ('django.db.models.fields.CharField', [], {
                'max_length': '250'
            })
        }
    }

    complete_apps = ['hipchat_ac']
