import { Construct } from 'constructs';
/**
 * @experimental
 */
export interface RedisOptions {
    /**
     * (experimental) Number of slave replicas.
     *
     * @default 2
     * @experimental
     */
    readonly slaveReplicas?: number;
    /**
     * (experimental) Extra labels to associate with resources.
     *
     * @default - none
     * @experimental
     */
    readonly labels?: {
        [name: string]: string;
    };
}
/**
 * @experimental
 */
export declare class Redis extends Construct {
    /**
     * (experimental) The DNS host for the master server.
     *
     * @experimental
     */
    readonly masterHost: string;
    /**
     * (experimental) The DNS host for the slave service.
     *
     * @experimental
     */
    readonly slaveHost: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, options?: RedisOptions);
}
