#  MIT License
#
#  Copyright (c) 2019 Sam McCormack
#
#  Permission is hereby granted, free of charge, to any person obtaining a copy
#  of this software and associated documentation files (the "Software"), to deal
#  in the Software without restriction, including without limitation the rights
#  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
#  copies of the Software, and to permit persons to whom the Software is
#  furnished to do so, subject to the following conditions:
#
#  The above copyright notice and this permission notice shall be included in all
#  copies or substantial portions of the Software.
#
#  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
#  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
#  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
#  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
#  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
#  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
#  SOFTWARE.
import re
from os import path

from setuptools import setup

here = path.abspath(path.dirname(__file__))

with open("scheduler/__init__.py") as f:
    regexp = re.compile(r"[0-9]+\.[0-9]+\.[0-9]+b[0-9]+")
    version = regexp.findall(f.read())[0]

with open(path.join(here, "README.md"), encoding="utf-8") as f:
    long_description = f.read()

setup(
    name="AsyncProcessScheduler",
    version=version,
    packages=["scheduler"],
    python_requires="~=3.6",
    install_requires=["psutil"],
    description="GUI-friendly library for scheduling processes using coroutines.",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/CabbageDevelopment/async-process-scheduler",
    author="Sam McCormack",
    author_email="contact@cabbagedevelopment.com",
    classifiers=[
        "Development Status :: 4 - Beta",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: MIT License",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
    ],
    keywords="async asyncio processing multiprocessing scheduler scheduling processes coroutines gui",
    project_urls={
        "Source": "https://github.com/CabbageDevelopment/async-process-scheduler"
    },
)
