dictionary_tag         = "Cullen et al. 2022 (subm.)"

reference              = "Cullen, McLure, McLeod, Dunlop, Donnan, Carnall, et al., arXiv (2022)"

url                    = "https://arxiv.org/pdf/2208.04914.pdf"

description            = \
"""
From galaxies selected to lie at 8 < z < 15 using a combination of JWST ERO and ERS NIRcam 
imaging and ground-based imaging of the COSMOS field.
WARNING: After publication of these data, a bug was found in the JWST reduction pipeline and an 
issue with the zero-point magnitudes was detected. The values of the beta slope may change once 
these issues are resolved, but this should not affect qualitatively the results (Cullen, private communication).
"""

data_structure         = "points" #grid or points

extracted              = False

ndim                   = 1

dimensions_descriptors = ["redshift"]

axes                   = [8.76, 8.38, 7.41, 8.02, 8.2 , 7.75, 7.66, 7.66, 7.58, 8.11, 
                          8.02, 7.58, 8.57, 7.58, 8.86, 9.68, 8.57,  8.86,  8.96,  9.06,  
                          9.16,  9.16,  9.16,  9.26,  9.26, 9.36,  9.36,  9.47,  9.47,  
                          9.57,  9.68,  9.68,  9.79,  9.79, 10.  , 10.11, 10.22, 10.22, 
                          10.34, 10.56, 10.56, 10.56, 10.56, 10.79, 11.03, 11.15, 11.52, 
                          12.03, 12.16, 12.42, 12.56, 14.28, 16.74]

values                 = [-2.26, -2.92, -2.06, -2.17, -1.02, -2.7 , -2.88, -1.21, -2.16, 
                          -3.73, -1.95, -1.07, -2.31, -1.85, -1.97, -1.2, -1.16, -1.08, 
                          -3.29, -3.17, -3.6 , -3.17, -2.81, -4.02, -2.37, -1.23, -1.44, 
                          -1.78, -2.17, -1.2 , -2.91, -2.12, -4.19, -2.89, -1.26, -3.14, 
                          -2.75, -0.49, -2.1 , -1.83, -1.7 , -2.94, -2.6 , -1.29, -1.65, 
                          -2.46, -2.64, -1.84, -2.59, -2.31, -2.75, -2.84, -2.33 ]

err_up                 = [0.48, 0.91, 0.43, 0.84, 0.32, 0.7 , 0.37, 0.25, 0.64, 1.01, 
                          0.81, 0.59, 0.66, 0.68, 0.38, 0.56, 0.48, 0.34, 1.15, 0.55, 
                          0.6 , 0.65, 0.79, 0.94, 0.74, 0.32, 0.25, 0.67, 0.59, 1.53, 
                          0.59, 0.26, 1.19, 0.29, 0.93, 0.56, 0.74, 1.14, 0.71, 0.16, 
                          0.65, 0.37, 0.37, 0.78, 0.25, 0.29, 0.66, 0.54, 0.64, 0.2 , 
                          1.24, 0.68, 0.14]

err_down               = [0.53, 1.03, 0.55, 1.01, 0.35, 0.96, 0.4 , 0.26, 0.69, 1.71, 
                          0.84, 0.55, 0.79, 0.77, 0.45, 0.62, 0.49, 0.31, 1.31, 0.56, 
                          0.69, 0.75, 0.81, 1.27, 0.63, 0.32, 0.23, 0.58, 0.5 , 1.49, 
                          0.59, 0.24, 1.69, 0.33, 0.89, 0.63, 0.76, 0.78, 0.67, 0.15, 
                          0.58, 0.33, 0.35, 0.77, 0.22, 0.29, 0.68, 0.54, 0.64, 0.18, 
                          1.48, 0.67, 0.14]

upper_lim              = False

lower_lim              = False

M_UV                   = [-21.76, -21.65, -22.05, -21.4 , -22.35, -21.49, -22.15, -22.61, 
                          -21.02, -21.33, -21.68, -21.3 , -21.15, -21.57, -22.16, -22.57, 
                          -19.42, -19.23, -18.84, -18.94, -18.77, -18.71, -18.88, -18.74,
                          -19.12, -19.55, -20.38, -18.58, -18.99, -18.52, -19.31, -19.49,
                          -18.68, -19.15, -18.62, -18.96, -19.07, -18.87, -19.16, -20.58,
                          -19.41, -19.61, -19.84, -19.28, -19.51, -19.62, -19.31, -19.18,
                          -19.01, -20.91, -18.61, -19.62, -21.76]

mean_SNR               = [4.61, 2.63, 4.66, 2.57, 6.53, 2.86, 6.71, 8.23, 4.05, 2.11, 
                          3.07, 3.4 , 2.45, 2.91, 5.51, 3.79, 3.5 ,  5.88,  1.97,  3.67,  
                          3.36,  2.89,  2.39,  2.16,  3.16, 5.82,  7.14,  3.13,  3.45,  
                          1.2 ,  2.05,  6.55,  1.85,  5.17, 3.  ,  2.27,  2.97,  2.42,  
                          2.82, 12.34,  2.82,  5.6 ,  5.38, 2.88,  6.77,  4.23,  2.07,  
                          2.56,  2.3 ,  9.76,  0.87,  1.61, 10.89]

num_filters            = [3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 3, 3, 3, 3, 3, 
                          3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
                          3, 3, 4, 4, 3, 3, 3, 3, 3, 4, 4]

imaging_field          = ['cosmos', 'cosmos', 'cosmos', 'cosmos', 'cosmos', 'cosmos', 
                          'cosmos', 'cosmos', 'cosmos', 'cosmos', 'cosmos', 'cosmos', 
                          'cosmos', 'cosmos', 'cosmos', 'cosmos', 'jwst', 'jwst', 'jwst',
                          'jwst', 'jwst', 'jwst', 'jwst', 'jwst', 'jwst', 'jwst', 'jwst',
                          'jwst', 'jwst', 'jwst', 'jwst', 'jwst', 'jwst', 'jwst', 'jwst',
                          'jwst', 'jwst', 'jwst', 'jwst', 'jwst', 'jwst', 'jwst', 'jwst',
                          'jwst', 'jwst', 'jwst', 'jwst', 'jwst', 'jwst', 'jwst', 'jwst',
                          'jwst', 'jwst']
