dictionary_tag         = "Meyer et al. 2020"

reference              = "Meyer, Bosman, Kakiichi, Ellis; MNRAS 483, 19 (2019)"

url                    = "https://ui.adsabs.harvard.edu/abs/2020MNRAS.494.1560M/abstract"

description            = \
"""
From a sample of 8 z>6 QSO spectra and 13 LBGs + 21 LAEs galaxies. They are used to determine the correlation of galaxies with transmission spikes in the Ly-a forest.
NOTE: we assume the average rdshift of the detected LAEs and LBGs as reported in Tables A1 and A2 of the paper. This is used also to transform comoving to proper distances.
"""

data_structure         = "points" #grid or points

extracted              = True #False if the original paper provides number, True if extracted from plots

ndim                   = 3

dimensions_descriptors = ["redshift", "proper distance [pMpc]", "galaxy type"]

axes                   = [[5.7, 0.93, 'LBG'], [5.7, 2.25, 'LBG'], [5.7, 3.55, 'LBG'], [5.7, 4.88, 'LBG'], [5.7, 6.20, 'LBG'], \
                          [5.7, 7.53, 'LBG'], [5.7, 8.83, 'LBG'], [5.7, 10.15, 'LBG'], [5.7, 11.47, 'LBG'], [5.7, 12.78, 'LBG'], \
                          [5.7, 14.11, 'LBG'], [5.7, 0.64, 'LAE'], [5.7, 1.96, 'LAE'], [5.7, 3.27, 'LAE'], [5.7, 4.58, 'LAE'], \
                          [5.7, 5.89, 'LAE'], [5.7, 7.20, 'LAE'], [5.7, 8.55, 'LAE'], [5.7, 9.86, 'LAE'], [5.7, 11.16, 'LAE'], 
                          [5.7, 12.49, 'LAE'], [5.7, 13.81, 'LAE']]
 
values                 = [0.492715, -0.479470, 0.038411, 0.112583, -0.427815, -0.001325, -0.063576, -0.521854, -0.176159, -0.031788,\
                          0.333775, -0.454305, 0.182781, 0.074172, 0.250331, 0.274172, 0.603974, 0.335099, -0.031788, 0.588079, \
                          0.323179, -0.217219]

err_up                 = [0.75231788, 0.11523179, 0.12847682, 0.27682119, 0.17483444, \
                          0.19602649, 0.20529801, 0.20264901, 0.24238411, 0.25165563, \
                          0.28476821, 0.09933775, 0.16556291, 0.16953642, 0.15231788, \
                          0.1192053 , 0.24768212, 0.26622517, 0.19470199, 0.21986755, \
                          0.23576159, 0.10860927]

err_down               = [1.00264901, 0.12582781, 0.13112583, 0.27682119, 0.18013245, \
                          0.20397351, 0.2013245 , 0.20264901, 0.24768212, 0.25298013, \
                          0.28741722, 0.10066225, 0.16291391, 0.16688742, 0.14304636, \
                          0.11655629, 0.24635762, 0.26754967, 0.18807947, 0.21854305, \
                          0.23046358, 0.10596026]

upper_lim              = False

lower_lim              = False

err_left               = [0.64618828, 0.66982931, 0.63830793, 0.65406862, 0.66982931, \
                          0.65406862, 0.64618828, 0.64618828, 0.64618828, 0.64618828, \
                          0.64618828, 0.66194897, 0.66194897, 0.65406862, 0.63830793, \
                          0.64618828, 0.64618828, 0.66982931, 0.66982931, 0.63830793, \
                          0.66982931, 0.66982931] 

err_right              = [0.65406862, 0.64618828, 0.68559   , 0.65406862, 0.65406862, \
                          0.63042759, 0.63830793, 0.65406862, 0.66194897, 0.65406862, \
                          0.66982931, 0.66982931, 0.63830793, 0.64618828, 0.66982931, \
                          0.65406862, 0.66982931, 0.64618828, 0.64618828, 0.66982931, \
                          0.63830793, 0.65406862]
