# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/01_generators.ipynb.

# %% auto 0
__all__ = ['generate_ci', 'generate_doc_foundations', 'generate_setup']

# %% ../nbs/01_generators.ipynb 3
from fastcore.xtras import Path
from nbdev.cli import *
import requests

# %% ../nbs/01_generators.ipynb 4
def generate_ci():
    """
    Generates a Github action for running nbdev tests
    """
    path = Path('.github/workflows')
    if not path.exists(): path.mkdir(parents=True)
    if (path/'nbdev.yml').exists(): 
        print("nbdev.yml already exists, please modify the existing version")
        return
    
    f = open(path/'nbdev.yml', 'w')
    f.write('''
name: nbdev CI
on: [push, pull_request]
jobs:
  build:
    runs-on: ubuntu-latest
    steps:
    - uses: actions/checkout@v1
    - uses: actions/setup-python@v1
      with:
        python-version: '3.6'
        architecture: 'x64'
    - name: Install the library
      run: |
        pip install nbdev jupyter
        pip install -e .
    - name: Read all notebooks
      run: |
        nbdev_read_nbs
    - name: Check if all notebooks are cleaned
      run: |
        echo "Check we are starting with clean git checkout"
        if [ -n "$(git status -uno -s)" ]; then echo "git status is not clean"; false; fi
        echo "Trying to strip out notebooks"
        nbdev_clean_nbs
        echo "Check that strip out was unnecessary"
        git status -s # display the status to see which nbs need cleaning up
        if [ -n "$(git status -uno -s)" ]; then echo -e "!!! Detected unstripped out notebooks\n!!!Remember to run nbdev_install_git_hooks"; false; fi
    - name: Check if there is no diff library/notebooks
      run: |
        if [ -n "$(nbdev_diff_nbs)" ]; then echo -e "!!! Detected difference between the notebooks and the library"; false; fi
    - name: Run tests
      run: |
        nbdev_test_nbs''')

# %% ../nbs/01_generators.ipynb 5
def generate_doc_foundations():
    """
    Grabs the needed files for documentation from [nbdev_template](https://github.com/fastai/nbdev_template)
    """
    _base_url = 'https://raw.githubusercontent.com/fastai/nbdev/master/docs'
    _urls = {
        'Gemfile':f'{_base_url}/Gemfile',
        'Gemfile.lock': f'{_base_url}/Gemfile.lock',
        'feed.xml': f'{_base_url}/feed.xml',
        'sitemap.xml': f'{_base_url}/sitemap.xml',
        '.gitignore': f'{_base_url}/.gitignore' # Specific gitignore
    }
    print("Initializing documentation foundation...")
    base_path = Path('docs')
    base_path.mkdir(exist_ok=True)
    for fname, url in _urls.items():
        r = requests.get(url)
        with open(base_path/fname, 'w') as f:
            f.write(r.text)

# %% ../nbs/01_generators.ipynb 7
def generate_setup():
    """
    Grabs the original setup.py file from [nbdev_template](https://github.com/fastai/nbdev_template)
    """
    r = requests.get('https://raw.githubusercontent.com/fastai/nbdev/master/setup.py')
    with open('setup.py', 'w') as f: f.write(r.text)
