from pytest import fixture

from compas.data import json_dumps
from compas.data import json_loads

from compas_model.models import Model
from compas_model.elements import Element
from compas_model.interactions import Interaction


@fixture
def mock_model():
    model = Model()
    a = Element(name="a")
    b = Element(name="b")
    c = Element(name="c")
    group = model.add_group(name="group_ab")
    model.add_element(a, parent=group)
    model.add_element(b, parent=group)
    model.add_element(c)
    model.add_interaction(a, c, interaction=Interaction(name="i_a_c"))
    model.add_interaction(b, c, interaction=Interaction(name="i_b_c"))
    return model


def test_serialize_model(mock_model):
    guids = [str(e.guid) for e in mock_model.elements()]
    elements = list(mock_model.elements())
    a = elements[0]
    b = elements[1]
    c = elements[2]

    mock_model: Model = json_loads(json_dumps(mock_model))

    assert len(list(mock_model.elements())) == 3
    assert guids == [str(e.guid) for e in mock_model.elements()]
    assert mock_model.has_interaction(a, c)
    assert mock_model.has_interaction(b, c)


def test_model_deepcopy(mock_model):
    c_model = mock_model.copy()

    assert c_model is not None
    assert c_model.graph is not None
    assert c_model.tree is not None
    assert len(c_model.tree.elements) == 3
