class Constants(object):
    def __setattr__(self, key: str, value: int) -> None:
        super(Constants, self).__setattr__(key, value)


# CYCLONE_CONSTANTS
vlxDevConstants = Constants()

# /* g_cyclone_general_info */
vlxDevConstants.A_CYC_APPL_SW_VERSION = 1
vlxDevConstants.A_CYC_APPL_SW_VERSION_1 = 2
vlxDevConstants.A_CYC_APPL_SW_VERSION_2 = 3
vlxDevConstants.A_CYC_APPL_SW_VERSION_3 = 4
vlxDevConstants.A_CYC_APPL_SW_VERSION_4 = 5
vlxDevConstants.A_CYC_APPL_SW_VERSION_5 = 6
vlxDevConstants.A_CYC_APPL_SW_VERSION_6 = 7
vlxDevConstants.A_CYC_APPL_SW_VERSION_7 = 8
vlxDevConstants.A_CYC_APPL_SW_VERSION_8 = 9
vlxDevConstants.A_CYC_APPL_SW_VERSION_9 = 10
vlxDevConstants.A_CYC_BOOT_SW_VERSION = 11
vlxDevConstants.A_CYC_APPL_SW_SIZE_0 = 12
vlxDevConstants.A_CYC_APPL_SW_SIZE_1 = 13
vlxDevConstants.A_CYC_SERIAL_NUMBER_MSW = 14
vlxDevConstants.A_CYC_SERIAL_NUMBER_LSW = 15
vlxDevConstants.A_CYC_MACHINE_TYPE = 16
vlxDevConstants.A_CYC_MACHINE_MODEL = 17
vlxDevConstants.A_CYC_MASTER_PASSWORD = 18
vlxDevConstants.A_CYC_CONFIGURATION_MSW = 19
vlxDevConstants.A_CYC_CONFIGURATION_LSW = 20
vlxDevConstants.A_CYC_CONFIGURATION_NA_0 = 21
vlxDevConstants.A_CYC_CONFIGURATION_NA_1 = 22
vlxDevConstants.A_CYC_CONFIGURATION_NA_2 = 23
vlxDevConstants.A_CYC_CONFIGURATION_NA_3 = 24
vlxDevConstants.A_CYC_CONFIGURATION_CHECKSUM = 25

# /* g_typhoon_general_info */
vlxDevConstants.A_CYC_TYP_SERIAL_NUMBER_MSW = 257
vlxDevConstants.A_CYC_TYP_SERIAL_NUMBER_LSW = 258
vlxDevConstants.A_CYC_TYP_PANEL_MODEL = 259
vlxDevConstants.A_CYC_TYP_APPL_SW_VERSION = 260
vlxDevConstants.A_CYC_TYP_APPL_SW_VERSION_1 = 261
vlxDevConstants.A_CYC_TYP_APPL_SW_VERSION_2 = 262
vlxDevConstants.A_CYC_TYP_APPL_SW_VERSION_3 = 263
vlxDevConstants.A_CYC_TYP_APPL_SW_VERSION_4 = 264
vlxDevConstants.A_CYC_TYP_APPL_SW_VERSION_5 = 265
vlxDevConstants.A_CYC_TYP_APPL_SW_VERSION_6 = 266
vlxDevConstants.A_CYC_TYP_APPL_SW_VERSION_7 = 267
vlxDevConstants.A_CYC_TYP_APPL_SW_VERSION_8 = 268
vlxDevConstants.A_CYC_TYP_APPL_SW_VERSION_9 = 269
vlxDevConstants.A_CYC_TYP_BOOT_SW_VERSION = 270
vlxDevConstants.A_CYC_TYP_APPL_SW_SIZE_0 = 271
vlxDevConstants.A_CYC_TYP_APPL_SW_SIZE_1 = 272

# /* g_cyclone_hw_state */
vlxDevConstants.A_CYC_FAN_SPEED = 4353
vlxDevConstants.A_CYC_TEMP_EXTRACT_AIR = 4354
vlxDevConstants.A_CYC_TEMP_EXHAUST_AIR = 4355
vlxDevConstants.A_CYC_TEMP_OUTDOOR_AIR = 4356
vlxDevConstants.A_CYC_TEMP_SUPPLY_CELL_AIR = 4357
vlxDevConstants.A_CYC_TEMP_SUPPLY_AIR = 4358
vlxDevConstants.A_CYC_RH_LEVEL = 4359
vlxDevConstants.A_CYC_CO2_LEVEL = 4360
vlxDevConstants.A_CYC_EXTR_FAN_SPEED = 4361
vlxDevConstants.A_CYC_SUPP_FAN_SPEED = 4362
vlxDevConstants.A_CYC_RH_VALUE = 4363
vlxDevConstants.A_CYC_CO2_VALUE = 4364
vlxDevConstants.A_CYC_FIREPLACE_SWITCH = 4365
vlxDevConstants.A_CYC_DIGITAL_INPUT = 4366
vlxDevConstants.A_CYC_ANALOG_CTRL_INPUT = 4367
vlxDevConstants.A_CYC_MULTISENSOR_CO2 = 4368
vlxDevConstants.A_CYC_MULTISENSOR_TEMP = 4369
vlxDevConstants.A_CYC_MULTISENSOR_RH = 4370
vlxDevConstants.A_CYC_VOLTAGE_LOW = 4371
vlxDevConstants.A_CYC_ANALOG_SENSOR_INPUT = 4372
vlxDevConstants.A_CYC_RH_SENSOR_0 = 4373
vlxDevConstants.A_CYC_RH_SENSOR_1 = 4374
vlxDevConstants.A_CYC_RH_SENSOR_2 = 4375
vlxDevConstants.A_CYC_RH_SENSOR_3 = 4376
vlxDevConstants.A_CYC_RH_SENSOR_4 = 4377
vlxDevConstants.A_CYC_RH_SENSOR_5 = 4378
vlxDevConstants.A_CYC_CO2_SENSOR_0 = 4379
vlxDevConstants.A_CYC_CO2_SENSOR_1 = 4380
vlxDevConstants.A_CYC_CO2_SENSOR_2 = 4381
vlxDevConstants.A_CYC_CO2_SENSOR_3 = 4382
vlxDevConstants.A_CYC_CO2_SENSOR_4 = 4383
vlxDevConstants.A_CYC_CO2_SENSOR_5 = 4384
vlxDevConstants.A_CYC_DIP_SWITCH_0 = 4385
vlxDevConstants.A_CYC_DIP_SWITCH_1 = 4386
vlxDevConstants.A_CYC_DIP_SWITCH_2 = 4387
vlxDevConstants.A_CYC_DIP_SWITCH_3 = 4388
vlxDevConstants.A_CYC_TEMP_OPTIONAL = 4389
vlxDevConstants.A_CYC_VOC_LEVEL = 4390
vlxDevConstants.A_CYC_VOC_SENSOR_0 = 4391
vlxDevConstants.A_CYC_VOC_SENSOR_1 = 4392
vlxDevConstants.A_CYC_VOC_SENSOR_2 = 4393
vlxDevConstants.A_CYC_VOC_SENSOR_3 = 4394

# /* g_cyclone_sw_state */
vlxDevConstants.A_CYC_STATE = 4609
vlxDevConstants.A_CYC_MODE = 4610
vlxDevConstants.A_CYC_DEFROSTING = 4611
vlxDevConstants.A_CYC_BOOST_TIMER = 4612
vlxDevConstants.A_CYC_FIREPLACE_TIMER = 4613
vlxDevConstants.A_CYC_EXTRA_TIMER = 4614
vlxDevConstants.A_CYC_WEEKLY_TIMER_ENABLED = 4615
vlxDevConstants.A_CYC_CELL_STATE = 4616
vlxDevConstants.A_CYC_TOTAL_UP_TIME_YEARS = 4617
vlxDevConstants.A_CYC_TOTAL_UP_TIME_HOURS = 4618
vlxDevConstants.A_CYC_CURRENT_UP_TIME_HOURS = 4619
vlxDevConstants.A_CYC_REMAINING_TIME_FOR_FILTER = 4620
vlxDevConstants.A_CYC_LIMP_MODE = 4621
vlxDevConstants.A_CYC_METRICS = 4622
vlxDevConstants.A_CYC_DEFROST_COUNT_IN_24H = 4623
vlxDevConstants.A_CYC_DEFROST_COUNT_IN_WEEK = 4624
vlxDevConstants.A_CYC_DEFROST_SUPERMELT_THRESHOLD = 4625
vlxDevConstants.A_CYC_ENABLED = 4626
vlxDevConstants.A_CYC_COMMAND = 4627
vlxDevConstants.A_CYC_MLV_STATE = 4628
vlxDevConstants.A_CYC_UPD_ADDRESS_1 = 4629
vlxDevConstants.A_CYC_UPD_ADDRESS_2 = 4630
vlxDevConstants.A_CYC_CLOUD_STATUS = 4631

# /* g_cyclone_time */
vlxDevConstants.A_CYC_MINUTE = 4849
vlxDevConstants.A_CYC_HOUR = 4850
vlxDevConstants.A_CYC_DAY = 4851
vlxDevConstants.A_CYC_MONTH = 4852
vlxDevConstants.A_CYC_YEAR = 4853
vlxDevConstants.A_CYC_WEEKDAY = 4854

# /* g_cyclone_output */
vlxDevConstants.A_CYC_IO_EXTRACT_FAN = 4865
vlxDevConstants.A_CYC_IO_SUPPLY_FAN = 4866
vlxDevConstants.A_CYC_IO_ERROR = 4867
vlxDevConstants.A_CYC_IO_HEATER = 4868
vlxDevConstants.A_CYC_IO_EXTRA_HEATER = 4869
vlxDevConstants.A_CYC_IO_BYPASS = 4870

# /* g_cyclone_input */
vlxDevConstants.A_CYC_IN_EXTRACT_FAN = 5121
vlxDevConstants.A_CYC_IN_SUPPLY_FAN = 5122
vlxDevConstants.A_CYC_IN_ERROR = 5123
vlxDevConstants.A_CYC_IN_HEATER = 5124
vlxDevConstants.A_CYC_IN_EXTRA_HEATER = 5125
vlxDevConstants.A_CYC_IN_BYPASS = 5126

# /* g_cyclone_config */
vlxDevConstants.A_CYC_BETA_STATE = 8193
vlxDevConstants.A_CYC_GW_ADDRESS_1 = 8194
vlxDevConstants.A_CYC_GW_ADDRESS_2 = 8195
vlxDevConstants.A_CYC_MASK_ADDRESS_1 = 8196
vlxDevConstants.A_CYC_MASK_ADDRESS_2 = 8197
vlxDevConstants.A_CYC_RH_0_ADDRESS = 8199
vlxDevConstants.A_CYC_RH_1_ADDRESS = 8200
vlxDevConstants.A_CYC_RH_2_ADDRESS = 8201
vlxDevConstants.A_CYC_RH_3_ADDRESS = 8202
vlxDevConstants.A_CYC_RH_4_ADDRESS = 8203
vlxDevConstants.A_CYC_RH_5_ADDRESS = 8204
vlxDevConstants.A_CYC_CO2_0_ADDRESS = 8205
vlxDevConstants.A_CYC_CO2_1_ADDRESS = 8206
vlxDevConstants.A_CYC_CO2_2_ADDRESS = 8207
vlxDevConstants.A_CYC_CO2_3_ADDRESS = 8208
vlxDevConstants.A_CYC_CO2_4_ADDRESS = 8209
vlxDevConstants.A_CYC_CO2_5_ADDRESS = 8210
vlxDevConstants.A_CYC_ETH_CLOUD_ENABLED = 8211
vlxDevConstants.A_CYC_IP_ADDRESS_1 = 8212
vlxDevConstants.A_CYC_IP_ADDRESS_2 = 8213
vlxDevConstants.A_CYC_UUID0 = 8214
vlxDevConstants.A_CYC_UUID1 = 8215
vlxDevConstants.A_CYC_UUID2 = 8216
vlxDevConstants.A_CYC_UUID3 = 8217
vlxDevConstants.A_CYC_UUID4 = 8218
vlxDevConstants.A_CYC_UUID5 = 8219
vlxDevConstants.A_CYC_UUID6 = 8220
vlxDevConstants.A_CYC_UUID7 = 8221

# /* g_cyclone_settings */
vlxDevConstants.A_CYC_USED_SETTINGS_VARIABLES = 20481
vlxDevConstants.A_CYC_MODBUS_ADDRESS = 20482
vlxDevConstants.A_CYC_MODBUS_BAUD_X100 = 20483
vlxDevConstants.A_CYC_MODBUS_FRAME = 20484
vlxDevConstants.A_CYC_EXTR_FAN_BALANCE_BASE = 20485
vlxDevConstants.A_CYC_SUPP_FAN_BALANCE_BASE = 20486
vlxDevConstants.A_CYC_FIREPLACE_EXTR_FAN = 20487
vlxDevConstants.A_CYC_FIREPLACE_SUPP_FAN = 20488
vlxDevConstants.A_CYC_RH_BASIC_LEVEL = 20490
vlxDevConstants.A_CYC_CO2_THRESHOLD = 20491
vlxDevConstants.A_CYC_EXTRA_ENABLED = 20492
vlxDevConstants.A_CYC_EXTRA_AIR_TEMP_TARGET = 20493
vlxDevConstants.A_CYC_EXTRA_EXTR_FAN = 20494
vlxDevConstants.A_CYC_EXTRA_SUPP_FAN = 20495
vlxDevConstants.A_CYC_EXTRA_TIME = 20496
vlxDevConstants.A_CYC_AWAY_RH_CTRL_ENABLED = 20499
vlxDevConstants.A_CYC_AWAY_CO2_CTRL_ENABLED = 20500
vlxDevConstants.A_CYC_AWAY_SPEED_SETTING = 20501
vlxDevConstants.A_CYC_AWAY_AIR_TEMP_TARGET = 20502
vlxDevConstants.A_CYC_HOME_RH_CTRL_ENABLED = 20505
vlxDevConstants.A_CYC_HOME_CO2_CTRL_ENABLED = 20506
vlxDevConstants.A_CYC_HOME_SPEED_SETTING = 20507
vlxDevConstants.A_CYC_HOME_AIR_TEMP_TARGET = 20508
vlxDevConstants.A_CYC_BOOST_RH_CTRL_ENABLED = 20511
vlxDevConstants.A_CYC_BOOST_CO2_CTRL_ENABLED = 20512
vlxDevConstants.A_CYC_BOOST_SPEED_SETTING = 20513
vlxDevConstants.A_CYC_BOOST_AIR_TEMP_TARGET = 20514
vlxDevConstants.A_CYC_RELAY_MODE = 20517
vlxDevConstants.A_CYC_DIGITAL_INPUT_1_MODE = 20518
vlxDevConstants.A_CYC_DIGITAL_INPUT_2_MODE = 20519
vlxDevConstants.A_CYC_ANALOG_INPUT_MODE = 20520
vlxDevConstants.A_CYC_MLV_SUPPLY_LOWER_LIMIT = 20521
vlxDevConstants.A_CYC_MLV_AUTO_MANUAL = 20523
vlxDevConstants.A_CYC_DEFROST_MODE = 20524
vlxDevConstants.A_CYC_DEFROST_RH_PARAM = 20525
vlxDevConstants.A_CYC_DEFROST_TEMP_PARAM = 20526
vlxDevConstants.A_CYC_DEFROST_EXH_OFFSET = 20527
vlxDevConstants.A_CYC_DEFROST_COMP_LIMIT = 20528
vlxDevConstants.A_CYC_MLV_SUMMER_SETPOINT = 20529
vlxDevConstants.A_CYC_MLV_MODES = 20530
vlxDevConstants.A_CYC_MLV_WINTER_SETPOINT = 20531
vlxDevConstants.A_CYC_MLV_SUMMER_HYSTERESIS = 20532
vlxDevConstants.A_CYC_MLV_WINTER_HYSTERESIS = 20533
vlxDevConstants.A_CYC_WATERHEATER_STORED_I = 20534
vlxDevConstants.A_CYC_INSTALLATION_DONE = 20535
vlxDevConstants.A_CYC_DEFROST_RH_OFFSET = 20536
vlxDevConstants.A_CYC_FILTER_CHANGE_INTERVAL = 20537
vlxDevConstants.A_CYC_CELL_TYPE = 20538
vlxDevConstants.A_CYC_EXTRA_HEATER_TYPE = 20539
vlxDevConstants.A_CYC_POST_HEATER_TYPE = 20540
vlxDevConstants.A_CYC_BRANDING = 20541
vlxDevConstants.A_CYC_SIDEDNESS = 20542
vlxDevConstants.A_CYC_RH_LEVEL_MODE = 20543
vlxDevConstants.A_CYC_BOOST_TIME = 20544
vlxDevConstants.A_CYC_FIREPLACE_TIME = 20545
vlxDevConstants.A_CYC_FILTER_CHANGED_DAY = 20546
vlxDevConstants.A_CYC_FILTER_CHANGED_MONTH = 20547
vlxDevConstants.A_CYC_FILTER_CHANGED_YEAR = 20548
vlxDevConstants.A_CYC_SUPPLY_HEATING_ADJUST_MODE = 20549
vlxDevConstants.A_CYC_MIN_DEFROST_TIME = 20550
vlxDevConstants.A_CYC_PARTIAL_BYPASS = 20551
vlxDevConstants.A_CYC_BYPASS_LOCKED = 20552
vlxDevConstants.A_CYC_OPT_TEMP_SENSOR_MODE = 20553
vlxDevConstants.A_CYC_POST_HEATER_WINTER_SETPOINT = 20554
vlxDevConstants.A_CYC_DEWPOINT_LIMIT_IN_USE = 20555

# /* g_typhoon_settings */
vlxDevConstants.A_CYC_LANGUAGE = 21761
vlxDevConstants.A_CYC_PARENTAL_PASSWORD = 21762
vlxDevConstants.A_CYC_USER_PASSWORD = 21763
vlxDevConstants.A_CYC_ACCESS_LEVEL = 21764
vlxDevConstants.A_CYC_PARENTAL_CTRL_ENABLED = 21765
vlxDevConstants.A_CYC_BOOST_TIMER_ENABLED = 21766
vlxDevConstants.A_CYC_FIREPLACE_TIMER_ENABLED = 21767
vlxDevConstants.A_CYC_SUMMER_TIME_AUTO_ENAB = 21768
vlxDevConstants.A_CYC_12_HOUR_CLOCK_ENABLED = 21769
vlxDevConstants.A_CYC_SLEEP_DELAY = 21770
vlxDevConstants.A_CYC_BG_LIGHT_LEVEL = 21771
vlxDevConstants.A_CYC_EXTRA_TIMER_ENABLED = 21772

# /* g_self_test */
vlxDevConstants.A_CYC_SUPP_FAN_TEST = 32769
vlxDevConstants.A_CYC_EXTR_FAN_TEST = 32770
vlxDevConstants.A_CYC_BY_PASS_TEST = 32771
vlxDevConstants.A_CYC_HEATER_TEST = 32772
vlxDevConstants.A_CYC_EXTRA_HEATER_TEST = 32773
vlxDevConstants.A_CYC_EFFICIENCY_TEST = 32774
vlxDevConstants.A_CYC_SUPPLY_EFFICIENCY = 32775
vlxDevConstants.A_CYC_EXTRACT_EFFICIENCY = 32776

# /* g_faults */
vlxDevConstants.A_CYC_TOTAL_FAULT_COUNT = 36865
vlxDevConstants.A_CYC_FAULT_CODE = 36866
vlxDevConstants.A_CYC_FAULT_SEVERITY = 36867
vlxDevConstants.A_CYC_FAULT_FIRST_DATE = 36868
vlxDevConstants.A_CYC_FAULT_LAST_DATE = 36869
vlxDevConstants.A_CYC_FAULT_COUNT = 36870
vlxDevConstants.A_CYC_FAULT_ACTIVITY = 36871
vlxDevConstants.A_CYC_FAULT_CODE_2 = 36872
vlxDevConstants.A_CYC_FAULT_SEVERITY_2 = 36873
vlxDevConstants.A_CYC_FAULT_FIRST_DATE_2 = 36874
vlxDevConstants.A_CYC_FAULT_LAST_DATE_2 = 36875
vlxDevConstants.A_CYC_FAULT_COUNT_2 = 36876
vlxDevConstants.A_CYC_FAULT_ACTIVITY_2 = 36877
vlxDevConstants.A_CYC_FAULT_CODE_3 = 36878
vlxDevConstants.A_CYC_FAULT_SEVERITY_3 = 36879
vlxDevConstants.A_CYC_FAULT_FIRST_DATE_3 = 36880
vlxDevConstants.A_CYC_FAULT_LAST_DATE_3 = 36881
vlxDevConstants.A_CYC_FAULT_COUNT_3 = 36882
vlxDevConstants.A_CYC_FAULT_ACTIVITY_3 = 36883
vlxDevConstants.A_CYC_FAULT_CODE_4 = 36884
vlxDevConstants.A_CYC_FAULT_SEVERITY_4 = 36885
vlxDevConstants.A_CYC_FAULT_FIRST_DATE_4 = 36886
vlxDevConstants.A_CYC_FAULT_LAST_DATE_4 = 36887
vlxDevConstants.A_CYC_FAULT_COUNT_4 = 36888
vlxDevConstants.A_CYC_FAULT_ACTIVITY_4 = 36889
vlxDevConstants.A_CYC_FAULT_CODE_5 = 36890
vlxDevConstants.A_CYC_FAULT_SEVERITY_5 = 36891
vlxDevConstants.A_CYC_FAULT_FIRST_DATE_5 = 36892
vlxDevConstants.A_CYC_FAULT_LAST_DATE_5 = 36893
vlxDevConstants.A_CYC_FAULT_COUNT_5 = 36894
vlxDevConstants.A_CYC_FAULT_ACTIVITY_5 = 36895
vlxDevConstants.A_CYC_FAULT_CODE_6 = 36896
vlxDevConstants.A_CYC_FAULT_SEVERITY_6 = 36897
vlxDevConstants.A_CYC_FAULT_FIRST_DATE_6 = 36898
vlxDevConstants.A_CYC_FAULT_LAST_DATE_6 = 36899
vlxDevConstants.A_CYC_FAULT_COUNT_6 = 36900
vlxDevConstants.A_CYC_FAULT_ACTIVITY_6 = 36901
vlxDevConstants.A_CYC_FAULT_CODE_7 = 36902
vlxDevConstants.A_CYC_FAULT_SEVERITY_7 = 36903
vlxDevConstants.A_CYC_FAULT_FIRST_DATE_7 = 36904
vlxDevConstants.A_CYC_FAULT_LAST_DATE_7 = 36905
vlxDevConstants.A_CYC_FAULT_COUNT_7 = 36906
vlxDevConstants.A_CYC_FAULT_ACTIVITY_7 = 36907
vlxDevConstants.A_CYC_FAULT_CODE_8 = 36908
vlxDevConstants.A_CYC_FAULT_SEVERITY_8 = 36909
vlxDevConstants.A_CYC_FAULT_FIRST_DATE_8 = 36910
vlxDevConstants.A_CYC_FAULT_LAST_DATE_8 = 36911
vlxDevConstants.A_CYC_FAULT_COUNT_8 = 36912
vlxDevConstants.A_CYC_FAULT_ACTIVITY_8 = 36913
vlxDevConstants.A_CYC_FAULT_CODE_9 = 36914
vlxDevConstants.A_CYC_FAULT_SEVERITY_9 = 36915
vlxDevConstants.A_CYC_FAULT_FIRST_DATE_9 = 36916
vlxDevConstants.A_CYC_FAULT_LAST_DATE_9 = 36917
vlxDevConstants.A_CYC_FAULT_COUNT_9 = 36918
vlxDevConstants.A_CYC_FAULT_ACTIVITY_9 = 36919
vlxDevConstants.A_CYC_FAULT_CODE_10 = 36920
vlxDevConstants.A_CYC_FAULT_SEVERITY_10 = 36921
vlxDevConstants.A_CYC_FAULT_FIRST_DATE_10 = 36922
vlxDevConstants.A_CYC_FAULT_LAST_DATE_10 = 36923
vlxDevConstants.A_CYC_FAULT_COUNT_10 = 36924
vlxDevConstants.A_CYC_FAULT_ACTIVITY_10 = 36925
vlxDevConstants.A_CYC_FAULT_CODE_11 = 36926
vlxDevConstants.A_CYC_FAULT_SEVERITY_11 = 36927
vlxDevConstants.A_CYC_FAULT_FIRST_DATE_11 = 36928
vlxDevConstants.A_CYC_FAULT_LAST_DATE_11 = 36929
vlxDevConstants.A_CYC_FAULT_COUNT_11 = 36930
vlxDevConstants.A_CYC_FAULT_ACTIVITY_11 = 36931
vlxDevConstants.A_CYC_FAULT_CODE_12 = 36932
vlxDevConstants.A_CYC_FAULT_SEVERITY_12 = 36933
vlxDevConstants.A_CYC_FAULT_FIRST_DATE_12 = 36934
vlxDevConstants.A_CYC_FAULT_LAST_DATE_12 = 36935
vlxDevConstants.A_CYC_FAULT_COUNT_12 = 36936
vlxDevConstants.A_CYC_FAULT_ACTIVITY_12 = 36937
vlxDevConstants.A_CYC_FAULT_CODE_13 = 36938
vlxDevConstants.A_CYC_FAULT_SEVERITY_13 = 36939
vlxDevConstants.A_CYC_FAULT_FIRST_DATE_13 = 36940
vlxDevConstants.A_CYC_FAULT_LAST_DATE_13 = 36941
vlxDevConstants.A_CYC_FAULT_COUNT_13 = 36942
vlxDevConstants.A_CYC_FAULT_ACTIVITY_13 = 36943
vlxDevConstants.A_CYC_FAULT_CODE_14 = 36944
vlxDevConstants.A_CYC_FAULT_SEVERITY_14 = 36945
vlxDevConstants.A_CYC_FAULT_FIRST_DATE_14 = 36946
vlxDevConstants.A_CYC_FAULT_LAST_DATE_14 = 36947
vlxDevConstants.A_CYC_FAULT_COUNT_14 = 36948
vlxDevConstants.A_CYC_FAULT_ACTIVITY_14 = 36949
vlxDevConstants.A_CYC_FAULT_CODE_15 = 36950
vlxDevConstants.A_CYC_FAULT_SEVERITY_15 = 36951
vlxDevConstants.A_CYC_FAULT_FIRST_DATE_15 = 36952
vlxDevConstants.A_CYC_FAULT_LAST_DATE_15 = 36953
vlxDevConstants.A_CYC_FAULT_COUNT_15 = 36954
vlxDevConstants.A_CYC_FAULT_ACTIVITY_15 = 36955
vlxDevConstants.A_CYC_FAULT_CODE_16 = 36956
vlxDevConstants.A_CYC_FAULT_SEVERITY_16 = 36957
vlxDevConstants.A_CYC_FAULT_FIRST_DATE_16 = 36958
vlxDevConstants.A_CYC_FAULT_LAST_DATE_16 = 36959
vlxDevConstants.A_CYC_FAULT_COUNT_16 = 36960
vlxDevConstants.A_CYC_FAULT_ACTIVITY_16 = 36961
vlxDevConstants.A_CYC_FAULT_CODE_17 = 36962
vlxDevConstants.A_CYC_FAULT_SEVERITY_17 = 36963
vlxDevConstants.A_CYC_FAULT_FIRST_DATE_17 = 36964
vlxDevConstants.A_CYC_FAULT_LAST_DATE_17 = 36965
vlxDevConstants.A_CYC_FAULT_COUNT_17 = 36966
vlxDevConstants.A_CYC_FAULT_ACTIVITY_17 = 36967
vlxDevConstants.A_CYC_FAULT_CODE_18 = 36968
vlxDevConstants.A_CYC_FAULT_SEVERITY_18 = 36969
vlxDevConstants.A_CYC_FAULT_FIRST_DATE_18 = 36970
vlxDevConstants.A_CYC_FAULT_LAST_DATE_18 = 36971
vlxDevConstants.A_CYC_FAULT_COUNT_18 = 36972
vlxDevConstants.A_CYC_FAULT_ACTIVITY_18 = 36973
vlxDevConstants.A_CYC_FAULT_CODE_19 = 36974
vlxDevConstants.A_CYC_FAULT_SEVERITY_19 = 36975
vlxDevConstants.A_CYC_FAULT_FIRST_DATE_19 = 36976
vlxDevConstants.A_CYC_FAULT_LAST_DATE_19 = 36977
vlxDevConstants.A_CYC_FAULT_COUNT_19 = 36978
vlxDevConstants.A_CYC_FAULT_ACTIVITY_19 = 36979
vlxDevConstants.A_CYC_FAULT_CODE_20 = 36980
vlxDevConstants.A_CYC_FAULT_SEVERITY_20 = 36981
vlxDevConstants.A_CYC_FAULT_FIRST_DATE_20 = 36982
vlxDevConstants.A_CYC_FAULT_LAST_DATE_20 = 36983
vlxDevConstants.A_CYC_FAULT_COUNT_20 = 36984
vlxDevConstants.A_CYC_FAULT_ACTIVITY_20 = 36985
vlxDevConstants.A_CYC_FAULT_CODE_21 = 36986
vlxDevConstants.A_CYC_FAULT_SEVERITY_21 = 36987
vlxDevConstants.A_CYC_FAULT_FIRST_DATE_21 = 36988
vlxDevConstants.A_CYC_FAULT_LAST_DATE_21 = 36989
vlxDevConstants.A_CYC_FAULT_COUNT_21 = 36990
vlxDevConstants.A_CYC_FAULT_ACTIVITY_21 = 36991
vlxDevConstants.A_CYC_FAULT_CODE_22 = 36992
vlxDevConstants.A_CYC_FAULT_SEVERITY_22 = 36993
vlxDevConstants.A_CYC_FAULT_FIRST_DATE_22 = 36994
vlxDevConstants.A_CYC_FAULT_LAST_DATE_22 = 36995
vlxDevConstants.A_CYC_FAULT_COUNT_22 = 36996
vlxDevConstants.A_CYC_FAULT_ACTIVITY_22 = 36997
vlxDevConstants.A_CYC_FAULT_CODE_23 = 36998
vlxDevConstants.A_CYC_FAULT_SEVERITY_23 = 36999
vlxDevConstants.A_CYC_FAULT_FIRST_DATE_23 = 37000
vlxDevConstants.A_CYC_FAULT_LAST_DATE_23 = 37001
vlxDevConstants.A_CYC_FAULT_COUNT_23 = 37002
vlxDevConstants.A_CYC_FAULT_ACTIVITY_23 = 37003
vlxDevConstants.A_CYC_FAULT_CODE_24 = 37004
vlxDevConstants.A_CYC_FAULT_SEVERITY_24 = 37005
vlxDevConstants.A_CYC_FAULT_FIRST_DATE_24 = 37006
vlxDevConstants.A_CYC_FAULT_LAST_DATE_24 = 37007
vlxDevConstants.A_CYC_FAULT_COUNT_24 = 37008
vlxDevConstants.A_CYC_FAULT_ACTIVITY_24 = 37009
vlxDevConstants.A_CYC_FAULT_CODE_25 = 37010
vlxDevConstants.A_CYC_FAULT_SEVERITY_25 = 37011
vlxDevConstants.A_CYC_FAULT_FIRST_DATE_25 = 37012
vlxDevConstants.A_CYC_FAULT_LAST_DATE_25 = 37013
vlxDevConstants.A_CYC_FAULT_COUNT_25 = 37014
vlxDevConstants.A_CYC_FAULT_ACTIVITY_25 = 37015
vlxDevConstants.A_CYC_FAULT_CODE_26 = 37016
vlxDevConstants.A_CYC_FAULT_SEVERITY_26 = 37017
vlxDevConstants.A_CYC_FAULT_FIRST_DATE_26 = 37018
vlxDevConstants.A_CYC_FAULT_LAST_DATE_26 = 37019
vlxDevConstants.A_CYC_FAULT_COUNT_26 = 37020
vlxDevConstants.A_CYC_FAULT_ACTIVITY_26 = 37021
vlxDevConstants.A_CYC_FAULT_CODE_27 = 37022
vlxDevConstants.A_CYC_FAULT_SEVERITY_27 = 37023
vlxDevConstants.A_CYC_FAULT_FIRST_DATE_27 = 37024
vlxDevConstants.A_CYC_FAULT_LAST_DATE_27 = 37025
vlxDevConstants.A_CYC_FAULT_COUNT_27 = 37026
vlxDevConstants.A_CYC_FAULT_ACTIVITY_27 = 37027
vlxDevConstants.A_CYC_FAULT_CODE_28 = 37028
vlxDevConstants.A_CYC_FAULT_SEVERITY_28 = 37029
vlxDevConstants.A_CYC_FAULT_FIRST_DATE_28 = 37030
vlxDevConstants.A_CYC_FAULT_LAST_DATE_28 = 37031
vlxDevConstants.A_CYC_FAULT_COUNT_28 = 37032
vlxDevConstants.A_CYC_FAULT_ACTIVITY_28 = 37033
vlxDevConstants.A_CYC_FAULT_CODE_29 = 37034
vlxDevConstants.A_CYC_FAULT_SEVERITY_29 = 37035
vlxDevConstants.A_CYC_FAULT_FIRST_DATE_29 = 37036
vlxDevConstants.A_CYC_FAULT_LAST_DATE_29 = 37037
vlxDevConstants.A_CYC_FAULT_COUNT_29 = 37038
vlxDevConstants.A_CYC_FAULT_ACTIVITY_29 = 37039
vlxDevConstants.A_CYC_FAULT_CODE_30 = 37040
vlxDevConstants.A_CYC_FAULT_SEVERITY_30 = 37041
vlxDevConstants.A_CYC_FAULT_FIRST_DATE_30 = 37042
vlxDevConstants.A_CYC_FAULT_LAST_DATE_30 = 37043
vlxDevConstants.A_CYC_FAULT_COUNT_30 = 37044
vlxDevConstants.A_CYC_FAULT_ACTIVITY_30 = 37045
vlxDevConstants.A_CYC_FAULT_CODE_31 = 37046
vlxDevConstants.A_CYC_FAULT_SEVERITY_31 = 37047
vlxDevConstants.A_CYC_FAULT_FIRST_DATE_31 = 37048
vlxDevConstants.A_CYC_FAULT_LAST_DATE_31 = 37049
vlxDevConstants.A_CYC_FAULT_COUNT_31 = 37050
vlxDevConstants.A_CYC_FAULT_ACTIVITY_31 = 37051
vlxDevConstants.A_CYC_FAULT_CODE_32 = 37052
vlxDevConstants.A_CYC_FAULT_SEVERITY_32 = 37053
vlxDevConstants.A_CYC_FAULT_FIRST_DATE_32 = 37054
vlxDevConstants.A_CYC_FAULT_LAST_DATE_32 = 37055
vlxDevConstants.A_CYC_FAULT_COUNT_32 = 37056
vlxDevConstants.A_CYC_FAULT_ACTIVITY_32 = 37057
vlxDevConstants.A_CYC_FAULT_CODE_33 = 37058
vlxDevConstants.A_CYC_FAULT_SEVERITY_33 = 37059
vlxDevConstants.A_CYC_FAULT_FIRST_DATE_33 = 37060
vlxDevConstants.A_CYC_FAULT_LAST_DATE_33 = 37061
vlxDevConstants.A_CYC_FAULT_COUNT_33 = 37062
vlxDevConstants.A_CYC_FAULT_ACTIVITY_33 = 37063

# /* g_cyclone_weekly_schedule */
vlxDevConstants.A_CYC_SCHEDULE_MONDAY_00 = 40961
vlxDevConstants.A_CYC_SCHEDULE_MONDAY_01 = 40962
vlxDevConstants.A_CYC_SCHEDULE_MONDAY_02 = 40963
vlxDevConstants.A_CYC_SCHEDULE_MONDAY_03 = 40964
vlxDevConstants.A_CYC_SCHEDULE_MONDAY_04 = 40965
vlxDevConstants.A_CYC_SCHEDULE_MONDAY_05 = 40966
vlxDevConstants.A_CYC_SCHEDULE_MONDAY_06 = 40967
vlxDevConstants.A_CYC_SCHEDULE_MONDAY_07 = 40968
vlxDevConstants.A_CYC_SCHEDULE_MONDAY_08 = 40969
vlxDevConstants.A_CYC_SCHEDULE_MONDAY_09 = 40970
vlxDevConstants.A_CYC_SCHEDULE_MONDAY_10 = 40971
vlxDevConstants.A_CYC_SCHEDULE_MONDAY_11 = 40972
vlxDevConstants.A_CYC_SCHEDULE_MONDAY_12 = 40973
vlxDevConstants.A_CYC_SCHEDULE_MONDAY_13 = 40974
vlxDevConstants.A_CYC_SCHEDULE_MONDAY_14 = 40975
vlxDevConstants.A_CYC_SCHEDULE_MONDAY_15 = 40976
vlxDevConstants.A_CYC_SCHEDULE_MONDAY_16 = 40977
vlxDevConstants.A_CYC_SCHEDULE_MONDAY_17 = 40978
vlxDevConstants.A_CYC_SCHEDULE_MONDAY_18 = 40979
vlxDevConstants.A_CYC_SCHEDULE_MONDAY_19 = 40980
vlxDevConstants.A_CYC_SCHEDULE_MONDAY_20 = 40981
vlxDevConstants.A_CYC_SCHEDULE_MONDAY_21 = 40982
vlxDevConstants.A_CYC_SCHEDULE_MONDAY_22 = 40983
vlxDevConstants.A_CYC_SCHEDULE_MONDAY_23 = 40984
vlxDevConstants.A_CYC_SCHEDULE_TUESDAY_00 = 40985
vlxDevConstants.A_CYC_SCHEDULE_TUESDAY_01 = 40986
vlxDevConstants.A_CYC_SCHEDULE_TUESDAY_02 = 40987
vlxDevConstants.A_CYC_SCHEDULE_TUESDAY_03 = 40988
vlxDevConstants.A_CYC_SCHEDULE_TUESDAY_04 = 40989
vlxDevConstants.A_CYC_SCHEDULE_TUESDAY_05 = 40990
vlxDevConstants.A_CYC_SCHEDULE_TUESDAY_06 = 40991
vlxDevConstants.A_CYC_SCHEDULE_TUESDAY_07 = 40992
vlxDevConstants.A_CYC_SCHEDULE_TUESDAY_08 = 40993
vlxDevConstants.A_CYC_SCHEDULE_TUESDAY_09 = 40994
vlxDevConstants.A_CYC_SCHEDULE_TUESDAY_10 = 40995
vlxDevConstants.A_CYC_SCHEDULE_TUESDAY_11 = 40996
vlxDevConstants.A_CYC_SCHEDULE_TUESDAY_12 = 40997
vlxDevConstants.A_CYC_SCHEDULE_TUESDAY_13 = 40998
vlxDevConstants.A_CYC_SCHEDULE_TUESDAY_14 = 40999
vlxDevConstants.A_CYC_SCHEDULE_TUESDAY_15 = 41000
vlxDevConstants.A_CYC_SCHEDULE_TUESDAY_16 = 41001
vlxDevConstants.A_CYC_SCHEDULE_TUESDAY_17 = 41002
vlxDevConstants.A_CYC_SCHEDULE_TUESDAY_18 = 41003
vlxDevConstants.A_CYC_SCHEDULE_TUESDAY_19 = 41004
vlxDevConstants.A_CYC_SCHEDULE_TUESDAY_20 = 41005
vlxDevConstants.A_CYC_SCHEDULE_TUESDAY_21 = 41006
vlxDevConstants.A_CYC_SCHEDULE_TUESDAY_22 = 41007
vlxDevConstants.A_CYC_SCHEDULE_TUESDAY_23 = 41008
vlxDevConstants.A_CYC_SCHEDULE_WEDNESDAY_00 = 41009
vlxDevConstants.A_CYC_SCHEDULE_WEDNESDAY_01 = 41010
vlxDevConstants.A_CYC_SCHEDULE_WEDNESDAY_02 = 41011
vlxDevConstants.A_CYC_SCHEDULE_WEDNESDAY_03 = 41012
vlxDevConstants.A_CYC_SCHEDULE_WEDNESDAY_04 = 41013
vlxDevConstants.A_CYC_SCHEDULE_WEDNESDAY_05 = 41014
vlxDevConstants.A_CYC_SCHEDULE_WEDNESDAY_06 = 41015
vlxDevConstants.A_CYC_SCHEDULE_WEDNESDAY_07 = 41016
vlxDevConstants.A_CYC_SCHEDULE_WEDNESDAY_08 = 41017
vlxDevConstants.A_CYC_SCHEDULE_WEDNESDAY_09 = 41018
vlxDevConstants.A_CYC_SCHEDULE_WEDNESDAY_10 = 41019
vlxDevConstants.A_CYC_SCHEDULE_WEDNESDAY_11 = 41020
vlxDevConstants.A_CYC_SCHEDULE_WEDNESDAY_12 = 41021
vlxDevConstants.A_CYC_SCHEDULE_WEDNESDAY_13 = 41022
vlxDevConstants.A_CYC_SCHEDULE_WEDNESDAY_14 = 41023
vlxDevConstants.A_CYC_SCHEDULE_WEDNESDAY_15 = 41024
vlxDevConstants.A_CYC_SCHEDULE_WEDNESDAY_16 = 41025
vlxDevConstants.A_CYC_SCHEDULE_WEDNESDAY_17 = 41026
vlxDevConstants.A_CYC_SCHEDULE_WEDNESDAY_18 = 41027
vlxDevConstants.A_CYC_SCHEDULE_WEDNESDAY_19 = 41028
vlxDevConstants.A_CYC_SCHEDULE_WEDNESDAY_20 = 41029
vlxDevConstants.A_CYC_SCHEDULE_WEDNESDAY_21 = 41030
vlxDevConstants.A_CYC_SCHEDULE_WEDNESDAY_22 = 41031
vlxDevConstants.A_CYC_SCHEDULE_WEDNESDAY_23 = 41032
vlxDevConstants.A_CYC_SCHEDULE_THURSDAY_00 = 41033
vlxDevConstants.A_CYC_SCHEDULE_THURSDAY_01 = 41034
vlxDevConstants.A_CYC_SCHEDULE_THURSDAY_02 = 41035
vlxDevConstants.A_CYC_SCHEDULE_THURSDAY_03 = 41036
vlxDevConstants.A_CYC_SCHEDULE_THURSDAY_04 = 41037
vlxDevConstants.A_CYC_SCHEDULE_THURSDAY_05 = 41038
vlxDevConstants.A_CYC_SCHEDULE_THURSDAY_06 = 41039
vlxDevConstants.A_CYC_SCHEDULE_THURSDAY_07 = 41040
vlxDevConstants.A_CYC_SCHEDULE_THURSDAY_08 = 41041
vlxDevConstants.A_CYC_SCHEDULE_THURSDAY_09 = 41042
vlxDevConstants.A_CYC_SCHEDULE_THURSDAY_10 = 41043
vlxDevConstants.A_CYC_SCHEDULE_THURSDAY_11 = 41044
vlxDevConstants.A_CYC_SCHEDULE_THURSDAY_12 = 41045
vlxDevConstants.A_CYC_SCHEDULE_THURSDAY_13 = 41046
vlxDevConstants.A_CYC_SCHEDULE_THURSDAY_14 = 41047
vlxDevConstants.A_CYC_SCHEDULE_THURSDAY_15 = 41048
vlxDevConstants.A_CYC_SCHEDULE_THURSDAY_16 = 41049
vlxDevConstants.A_CYC_SCHEDULE_THURSDAY_17 = 41050
vlxDevConstants.A_CYC_SCHEDULE_THURSDAY_18 = 41051
vlxDevConstants.A_CYC_SCHEDULE_THURSDAY_19 = 41052
vlxDevConstants.A_CYC_SCHEDULE_THURSDAY_20 = 41053
vlxDevConstants.A_CYC_SCHEDULE_THURSDAY_21 = 41054
vlxDevConstants.A_CYC_SCHEDULE_THURSDAY_22 = 41055
vlxDevConstants.A_CYC_SCHEDULE_THURSDAY_23 = 41056
vlxDevConstants.A_CYC_SCHEDULE_FRIDAY_00 = 41057
vlxDevConstants.A_CYC_SCHEDULE_FRIDAY_01 = 41058
vlxDevConstants.A_CYC_SCHEDULE_FRIDAY_02 = 41059
vlxDevConstants.A_CYC_SCHEDULE_FRIDAY_03 = 41060
vlxDevConstants.A_CYC_SCHEDULE_FRIDAY_04 = 41061
vlxDevConstants.A_CYC_SCHEDULE_FRIDAY_05 = 41062
vlxDevConstants.A_CYC_SCHEDULE_FRIDAY_06 = 41063
vlxDevConstants.A_CYC_SCHEDULE_FRIDAY_07 = 41064
vlxDevConstants.A_CYC_SCHEDULE_FRIDAY_08 = 41065
vlxDevConstants.A_CYC_SCHEDULE_FRIDAY_09 = 41066
vlxDevConstants.A_CYC_SCHEDULE_FRIDAY_10 = 41067
vlxDevConstants.A_CYC_SCHEDULE_FRIDAY_11 = 41068
vlxDevConstants.A_CYC_SCHEDULE_FRIDAY_12 = 41069
vlxDevConstants.A_CYC_SCHEDULE_FRIDAY_13 = 41070
vlxDevConstants.A_CYC_SCHEDULE_FRIDAY_14 = 41071
vlxDevConstants.A_CYC_SCHEDULE_FRIDAY_15 = 41072
vlxDevConstants.A_CYC_SCHEDULE_FRIDAY_16 = 41073
vlxDevConstants.A_CYC_SCHEDULE_FRIDAY_17 = 41074
vlxDevConstants.A_CYC_SCHEDULE_FRIDAY_18 = 41075
vlxDevConstants.A_CYC_SCHEDULE_FRIDAY_19 = 41076
vlxDevConstants.A_CYC_SCHEDULE_FRIDAY_20 = 41077
vlxDevConstants.A_CYC_SCHEDULE_FRIDAY_21 = 41078
vlxDevConstants.A_CYC_SCHEDULE_FRIDAY_22 = 41079
vlxDevConstants.A_CYC_SCHEDULE_FRIDAY_23 = 41080
vlxDevConstants.A_CYC_SCHEDULE_SATURDAY_00 = 41081
vlxDevConstants.A_CYC_SCHEDULE_SATURDAY_01 = 41082
vlxDevConstants.A_CYC_SCHEDULE_SATURDAY_02 = 41083
vlxDevConstants.A_CYC_SCHEDULE_SATURDAY_03 = 41084
vlxDevConstants.A_CYC_SCHEDULE_SATURDAY_04 = 41085
vlxDevConstants.A_CYC_SCHEDULE_SATURDAY_05 = 41086
vlxDevConstants.A_CYC_SCHEDULE_SATURDAY_06 = 41087
vlxDevConstants.A_CYC_SCHEDULE_SATURDAY_07 = 41088
vlxDevConstants.A_CYC_SCHEDULE_SATURDAY_08 = 41089
vlxDevConstants.A_CYC_SCHEDULE_SATURDAY_09 = 41090
vlxDevConstants.A_CYC_SCHEDULE_SATURDAY_10 = 41091
vlxDevConstants.A_CYC_SCHEDULE_SATURDAY_11 = 41092
vlxDevConstants.A_CYC_SCHEDULE_SATURDAY_12 = 41093
vlxDevConstants.A_CYC_SCHEDULE_SATURDAY_13 = 41094
vlxDevConstants.A_CYC_SCHEDULE_SATURDAY_14 = 41095
vlxDevConstants.A_CYC_SCHEDULE_SATURDAY_15 = 41096
vlxDevConstants.A_CYC_SCHEDULE_SATURDAY_16 = 41097
vlxDevConstants.A_CYC_SCHEDULE_SATURDAY_17 = 41098
vlxDevConstants.A_CYC_SCHEDULE_SATURDAY_18 = 41099
vlxDevConstants.A_CYC_SCHEDULE_SATURDAY_19 = 41100
vlxDevConstants.A_CYC_SCHEDULE_SATURDAY_20 = 41101
vlxDevConstants.A_CYC_SCHEDULE_SATURDAY_21 = 41102
vlxDevConstants.A_CYC_SCHEDULE_SATURDAY_22 = 41103
vlxDevConstants.A_CYC_SCHEDULE_SATURDAY_23 = 41104
vlxDevConstants.A_CYC_SCHEDULE_SUNDAY_00 = 41105
vlxDevConstants.A_CYC_SCHEDULE_SUNDAY_01 = 41106
vlxDevConstants.A_CYC_SCHEDULE_SUNDAY_02 = 41107
vlxDevConstants.A_CYC_SCHEDULE_SUNDAY_03 = 41108
vlxDevConstants.A_CYC_SCHEDULE_SUNDAY_04 = 41109
vlxDevConstants.A_CYC_SCHEDULE_SUNDAY_05 = 41110
vlxDevConstants.A_CYC_SCHEDULE_SUNDAY_06 = 41111
vlxDevConstants.A_CYC_SCHEDULE_SUNDAY_07 = 41112
vlxDevConstants.A_CYC_SCHEDULE_SUNDAY_08 = 41113
vlxDevConstants.A_CYC_SCHEDULE_SUNDAY_09 = 41114
vlxDevConstants.A_CYC_SCHEDULE_SUNDAY_10 = 41115
vlxDevConstants.A_CYC_SCHEDULE_SUNDAY_11 = 41116
vlxDevConstants.A_CYC_SCHEDULE_SUNDAY_12 = 41117
vlxDevConstants.A_CYC_SCHEDULE_SUNDAY_13 = 41118
vlxDevConstants.A_CYC_SCHEDULE_SUNDAY_14 = 41119
vlxDevConstants.A_CYC_SCHEDULE_SUNDAY_15 = 41120
vlxDevConstants.A_CYC_SCHEDULE_SUNDAY_16 = 41121
vlxDevConstants.A_CYC_SCHEDULE_SUNDAY_17 = 41122
vlxDevConstants.A_CYC_SCHEDULE_SUNDAY_18 = 41123
vlxDevConstants.A_CYC_SCHEDULE_SUNDAY_19 = 41124
vlxDevConstants.A_CYC_SCHEDULE_SUNDAY_20 = 41125
vlxDevConstants.A_CYC_SCHEDULE_SUNDAY_21 = 41126
vlxDevConstants.A_CYC_SCHEDULE_SUNDAY_22 = 41127
vlxDevConstants.A_CYC_SCHEDULE_SUNDAY_23 = 41128

# /* Configuration constants */
vlxDevConstants.C_CYC_STATE_HOME = 0
vlxDevConstants.C_CYC_STATE_AWAY = 1
vlxDevConstants.C_CYC_STATE_BOOST = 2
vlxDevConstants.C_CYC_EVENT_NONE = 0
vlxDevConstants.C_CYC_EVENT_HOME = 1
vlxDevConstants.C_CYC_EVENT_AWAY = 2
vlxDevConstants.C_CYC_EVENT_BOOST = 3
vlxDevConstants.C_CYC_MODE_NORMAL = 0
vlxDevConstants.C_CYC_MODE_TESTING = 1
vlxDevConstants.C_CYC_MODE_MANUAL = 2
vlxDevConstants.C_CYC_MODE_DEFROST = 3
vlxDevConstants.C_CYC_MODE_SELF_TEST = 4
vlxDevConstants.C_CYC_MODE_OFF = 5
vlxDevConstants.C_CYC_MODE_EMC_TEST = 6
vlxDevConstants.C_CYC_NONE = 0
vlxDevConstants.C_CYC_ELECTRIC = 1
vlxDevConstants.C_CYC_WATER = 2
vlxDevConstants.C_CYC_MLV = 3
vlxDevConstants.C_CYC_HEATING_SUPPLY = 0
vlxDevConstants.C_CYC_HEATING_EXTRACT = 1
vlxDevConstants.C_CYC_HEATING_COOLING = 2
vlxDevConstants.C_CYC_LEFT = 0
vlxDevConstants.C_CYC_RIGHT = 1
vlxDevConstants.C_CYC_RELAY_SERVICE_REM = 0
vlxDevConstants.C_CYC_RELAY_ERROR = 1
vlxDevConstants.C_CYC_RELAY_ERR_SERVICE = 2
vlxDevConstants.C_CYC_RELAY_FIRE_ALARM = 3
vlxDevConstants.C_CYC_RELAY_BYPASS_STATE = 4
vlxDevConstants.C_CYC_RELAY_MLV = 5
vlxDevConstants.C_CYC_RELAY_NONE = 6
vlxDevConstants.C_CYC_RELAY_AIRHEATER = 7
vlxDevConstants.C_CYC_RELAY_RUNSTATE = 8
vlxDevConstants.C_CYC_DIG_IN_NONE = 0
vlxDevConstants.C_CYC_DIG_IN_FIREPLACE = 1
vlxDevConstants.C_CYC_DIG_IN_HOME_STATE = 2
vlxDevConstants.C_CYC_DIG_IN_FP_DIRECT = 3
vlxDevConstants.C_CYC_DIG_IN_FIRE_ALARM = 4
vlxDevConstants.C_CYC_DIG_IN_BOOST = 5
vlxDevConstants.C_CYC_DIG_IN_BYPASS = 6
vlxDevConstants.C_CYC_DIG_IN_SCHEDULER = 7
vlxDevConstants.C_CYC_DIG_IN_EXTRA = 8
vlxDevConstants.C_CYC_ANA_IN_NONE = 0
vlxDevConstants.C_CYC_ANA_IN_SITUATION = 1
vlxDevConstants.C_CYC_ANA_IN_SPEED = 2
vlxDevConstants.C_CYC_ANA_IN_POST_HEAT = 3
vlxDevConstants.C_CYC_BYPASS_MODE = 0
vlxDevConstants.C_CYC_FAN_STOP_MODE = 1
vlxDevConstants.C_CYC_CELL_STATE_HEATRECO = 0
vlxDevConstants.C_CYC_CELL_STATE_COOLRECO = 1
vlxDevConstants.C_CYC_CELL_STATE_BYPASS = 2
vlxDevConstants.C_CYC_CELL_STATE_DEFROST = 3
vlxDevConstants.C_CYC_OPT_NONE = 0
vlxDevConstants.C_CYC_MLV_OUTDOOR = 1
vlxDevConstants.C_CYC_OPT_TEMP_EXTRACT = 2
vlxDevConstants.C_CYC_MLV_SUPPLY = 3
vlxDevConstants.C_CYC_ACCESS_FREE = 0
vlxDevConstants.C_CYC_ACCESS_LIMITED = 1
vlxDevConstants.C_CYC_ACCESS_VERY_LIMITED = 2
vlxDevConstants.C_CYC_NOT_TESTED = 0
vlxDevConstants.C_CYC_TESTED = 1
vlxDevConstants.C_CYC_FAILED = 2
vlxDevConstants.C_CYC_TESTING = 3
vlxDevConstants.C_CYC_NOT_TESTABLE = 4
vlxDevConstants.C_CYC_HRC_ALUMINIUM = 0
vlxDevConstants.C_CYC_HRC_PLASTIC = 1
vlxDevConstants.C_CYC_HRC_ENTALPHY = 2
vlxDevConstants.C_COMMAND_UPDATE_REQUEST = 16
vlxDevConstants.C_COMMAND_UPDATE_SEND = 17
vlxDevConstants.C_COMMAND_UPDATE_GET = 18
vlxDevConstants.C_COMMAND_START_APPLICATION = 19
vlxDevConstants.C_COMMAND_RESTART = 20
vlxDevConstants.C_COMMAND_CREATE_NEW_UUID = 21
vlxDevConstants.C_COMMAND_TYPHOON_READY_FOR_UPDATE = 50
vlxDevConstants.C_COMMAND_TYPHOON_USB_TRANSFER = 51
vlxDevConstants.C_COMMAND_UPDATE_GET_ETH = 22
vlxDevConstants.C_COMMAND_CLEAR_AND_REBOOT = 23
vlxDevConstants.C_COMMAND_UPDATE_GET_ETH_CLOUD = 24
vlxDevConstants.C_COMMAND_UPDATE_CLOUD_BETA = 25
vlxDevConstants.C_COMMAND_UPDATE_CLOUD_ALPHA = 26
vlxDevConstants.C_COMMAND_UPDATE_CLOUD_FORCE_MASTER = 27
vlxDevConstants.C_COMMAND_UPDATE_CHECK_CLOUD_VERSION = 28
vlxDevConstants.C_COMMAND_UPDATE_CLOUD_INSIDER = 29
vlxDevConstants.C_COMMAND_FORCE_FACTORY_SETTINGS = 30
vlxDevConstants.C_COMMAND_SAVE_FACTORY_SETTINGS = 32
vlxDevConstants.C_COMMAND_RESTORE_FACTORY_SETTINGS = 33
vlxDevConstants.C_COMMAND_SAVE_INSTALLATION_SETTINGS = 34
vlxDevConstants.C_COMMAND_RESTORE_INSTALLATION_SETTINGS = 35
vlxDevConstants.C_COMMAND_SAVE_USER_SETTINGS = 36
vlxDevConstants.C_COMMAND_RESTORE_USER_SETTINGS = 37
vlxDevConstants.C_COMMAND_SAVE_CLIENT_DATA = 38
vlxDevConstants.C_COMMAND_CLEAR_ALL = 39
vlxDevConstants.C_COMMAND_RESET = 40
vlxDevConstants.C_COMMAND_FORCE_UPDATE = 47
vlxDevConstants.C_COMMAND_STOP_CONTROL = 48
vlxDevConstants.C_COMMAND_START_CONTROL = 49
vlxDevConstants.C_COMMAND_CHECK_STORAGES = 52
vlxDevConstants.C_COMMAND_DEBUGGING_START = 80
vlxDevConstants.C_COMMAND_DEBUGGING_GET = 81
vlxDevConstants.C_COMMAND_DUMPSCRATCHFLASH = 82
vlxDevConstants.C_COMMAND_CLEARSCRATCHFLASH = 83
vlxDevConstants.C_COMMAND_REVERSE_NETDEBUG = 84
vlxDevConstants.C_CYC_NEGATIVE = 0
vlxDevConstants.C_CYC_AFFIRMATIVE = 1
vlxDevConstants.C_CYC_OPT_TEMP_NONE = 0
vlxDevConstants.C_CYC_OPT_TEMP_MLV = 1

# /* Websocket constants */
vlxDevConstants.WS_WEB_UI_DATA_LENGTH_ERROR = 255
vlxDevConstants.WS_WEB_UI_DATA_TABLE_BOUNDARY_ERROR = 254
vlxDevConstants.WS_WEB_UI_DATA_BOUNDARY_ERROR = 253
vlxDevConstants.WS_WEB_UI_DATA_INVALID_COMMAND = 252
vlxDevConstants.WS_WEB_UI_DATA_CHECKSUM_ERROR = 251
vlxDevConstants.WS_WEB_UI_COMMAND_READ_DATA = 250
vlxDevConstants.WS_WEB_UI_COMMAND_WRITE_DATA = 249
vlxDevConstants.WS_WEB_UI_DATA_SEND_REPLY = 248
vlxDevConstants.WS_WEB_UI_COMMAND_LOG = 247
vlxDevConstants.WS_WEB_UI_COMMAND_READ_TABLES = 246
vlxDevConstants.WS_WEB_UI_ACK = 245
vlxDevConstants.WS_WEB_UI_COMMAND_LOG_LIMITED = 244
vlxDevConstants.WS_WEB_UI_COMMAND_LOG_RAW = 243
vlxDevConstants.WS_WEB_UI_DATA_OK = 0
vlxDevConstants.WS_WEB_UI_DATA_ERROR = 1
vlxDevConstants.WS_WEB_UI_DATA_REQUEST = 2
vlxDevConstants.WS_WEB_UI_DATA_RW_ERROR = 3
vlxDevConstants.WS_LOG_EXTRACT_AIR_TEMP = 0
vlxDevConstants.WS_LOG_EXHAUST_AIR_TEMP = 1
vlxDevConstants.WS_LOG_OUTDOOR_AIR_TEMP = 2
vlxDevConstants.WS_LOG_SUPPLY_AIR_TEMP = 3
vlxDevConstants.WS_LOG_MAX_CO2 = 4
vlxDevConstants.WS_LOG_MAX_HUMIDITY = 5
vlxDevConstants.WS_LOG_SUPPLY_CELL_AIR_TEMP = 6
vlxDevConstants.WS_LOG_METRICS_1 = 7
vlxDevConstants.WS_LOG_FAN_SPEED = 8

# /* Modbus table ranges */
vlxDevConstants.RANGE_START_g_cyclone_general_info = 0
vlxDevConstants.RANGE_END_g_cyclone_general_info = 35
vlxDevConstants.RANGE_START_g_typhoon_general_info = 256
vlxDevConstants.RANGE_END_g_typhoon_general_info = 282
vlxDevConstants.RANGE_START_g_cyclone_hw_state = 4352
vlxDevConstants.RANGE_END_g_cyclone_hw_state = 4394
vlxDevConstants.RANGE_START_g_cyclone_sw_state = 4608
vlxDevConstants.RANGE_END_g_cyclone_sw_state = 4632
vlxDevConstants.RANGE_START_g_cyclone_time = 4848
vlxDevConstants.RANGE_END_g_cyclone_time = 4854
vlxDevConstants.RANGE_START_g_cyclone_output = 4864
vlxDevConstants.RANGE_END_g_cyclone_output = 4870
vlxDevConstants.RANGE_START_g_cyclone_input = 5120
vlxDevConstants.RANGE_END_g_cyclone_input = 5126
vlxDevConstants.RANGE_START_g_cyclone_config = 8192
vlxDevConstants.RANGE_END_g_cyclone_config = 8221
vlxDevConstants.RANGE_START_g_cyclone_settings = 20480
vlxDevConstants.RANGE_END_g_cyclone_settings = 20555
vlxDevConstants.RANGE_START_g_typhoon_settings = 21760
vlxDevConstants.RANGE_END_g_typhoon_settings = 21782
vlxDevConstants.RANGE_START_g_self_test = 32768
vlxDevConstants.RANGE_END_g_self_test = 32783
vlxDevConstants.RANGE_START_g_faults = 36864
vlxDevConstants.RANGE_END_g_faults = 37063
vlxDevConstants.RANGE_START_g_cyclone_weekly_schedule = 40960
vlxDevConstants.RANGE_END_g_cyclone_weekly_schedule = 41128


# /* CYCLONE_READ_CONSTANTS */
vlxReadConstants = Constants()

# /* g_cyclone_general_info  */
vlxReadConstants.CYC_APPL_SW_VERSION = 1
vlxReadConstants.CYC_APPL_SW_VERSION_1 = 2
vlxReadConstants.CYC_APPL_SW_VERSION_2 = 3
vlxReadConstants.CYC_APPL_SW_VERSION_3 = 4
vlxReadConstants.CYC_APPL_SW_VERSION_4 = 5
vlxReadConstants.CYC_APPL_SW_VERSION_5 = 6
vlxReadConstants.CYC_APPL_SW_VERSION_6 = 7
vlxReadConstants.CYC_APPL_SW_VERSION_7 = 8
vlxReadConstants.CYC_APPL_SW_VERSION_8 = 9
vlxReadConstants.CYC_APPL_SW_VERSION_9 = 10
vlxReadConstants.CYC_BOOT_SW_VERSION = 11
vlxReadConstants.CYC_APPL_SW_SIZE_0 = 12
vlxReadConstants.CYC_APPL_SW_SIZE_1 = 13
vlxReadConstants.CYC_SERIAL_NUMBER_MSW = 14
vlxReadConstants.CYC_SERIAL_NUMBER_LSW = 15
vlxReadConstants.CYC_MACHINE_TYPE = 16
vlxReadConstants.CYC_MACHINE_MODEL = 17
vlxReadConstants.CYC_MASTER_PASSWORD = 18
vlxReadConstants.CYC_CONFIGURATION_MSW = 19
vlxReadConstants.CYC_CONFIGURATION_LSW = 20
vlxReadConstants.CYC_CONFIGURATION_NA_0 = 21
vlxReadConstants.CYC_CONFIGURATION_NA_1 = 22
vlxReadConstants.CYC_CONFIGURATION_NA_2 = 23
vlxReadConstants.CYC_CONFIGURATION_NA_3 = 24
vlxReadConstants.CYC_CONFIGURATION_CHECKSUM = 25
vlxReadConstants.CYC_NUM_OF_GENERAL_INFO = 36

# /* g_typhoon_general_info  */
vlxReadConstants.CYC_TYP_SERIAL_NUMBER_MSW = 1
vlxReadConstants.CYC_TYP_SERIAL_NUMBER_LSW = 2
vlxReadConstants.CYC_TYP_PANEL_MODEL = 3
vlxReadConstants.CYC_TYP_APPL_SW_VERSION = 4
vlxReadConstants.CYC_TYP_APPL_SW_VERSION_1 = 5
vlxReadConstants.CYC_TYP_APPL_SW_VERSION_2 = 6
vlxReadConstants.CYC_TYP_APPL_SW_VERSION_3 = 7
vlxReadConstants.CYC_TYP_APPL_SW_VERSION_4 = 8
vlxReadConstants.CYC_TYP_APPL_SW_VERSION_5 = 9
vlxReadConstants.CYC_TYP_APPL_SW_VERSION_6 = 10
vlxReadConstants.CYC_TYP_APPL_SW_VERSION_7 = 11
vlxReadConstants.CYC_TYP_APPL_SW_VERSION_8 = 12
vlxReadConstants.CYC_TYP_APPL_SW_VERSION_9 = 13
vlxReadConstants.CYC_TYP_BOOT_SW_VERSION = 14
vlxReadConstants.CYC_TYP_APPL_SW_SIZE_0 = 15
vlxReadConstants.CYC_TYP_APPL_SW_SIZE_1 = 16
vlxReadConstants.CYC_NUM_OF_GENERAL_TYP_INFO = 27

# /* g_cyclone_hw_state  */
vlxReadConstants.CYC_FAN_SPEED = 1
vlxReadConstants.CYC_TEMP_EXTRACT_AIR = 2
vlxReadConstants.CYC_TEMP_EXHAUST_AIR = 3
vlxReadConstants.CYC_TEMP_OUTDOOR_AIR = 4
vlxReadConstants.CYC_TEMP_SUPPLY_CELL_AIR = 5
vlxReadConstants.CYC_TEMP_SUPPLY_AIR = 6
vlxReadConstants.CYC_RH_LEVEL = 7
vlxReadConstants.CYC_CO2_LEVEL = 8
vlxReadConstants.CYC_EXTR_FAN_SPEED = 9
vlxReadConstants.CYC_SUPP_FAN_SPEED = 10
vlxReadConstants.CYC_RH_VALUE = 11
vlxReadConstants.CYC_CO2_VALUE = 12
vlxReadConstants.CYC_FIREPLACE_SWITCH = 13
vlxReadConstants.CYC_DIGITAL_INPUT = 14
vlxReadConstants.CYC_ANALOG_CTRL_INPUT = 15
vlxReadConstants.CYC_MULTISENSOR_CO2 = 16
vlxReadConstants.CYC_MULTISENSOR_TEMP = 17
vlxReadConstants.CYC_MULTISENSOR_RH = 18
vlxReadConstants.CYC_VOLTAGE_LOW = 19
vlxReadConstants.CYC_ANALOG_SENSOR_INPUT = 20
vlxReadConstants.CYC_RH_SENSOR_0 = 21
vlxReadConstants.CYC_RH_SENSOR_1 = 22
vlxReadConstants.CYC_RH_SENSOR_2 = 23
vlxReadConstants.CYC_RH_SENSOR_3 = 24
vlxReadConstants.CYC_RH_SENSOR_4 = 25
vlxReadConstants.CYC_RH_SENSOR_5 = 26
vlxReadConstants.CYC_CO2_SENSOR_0 = 27
vlxReadConstants.CYC_CO2_SENSOR_1 = 28
vlxReadConstants.CYC_CO2_SENSOR_2 = 29
vlxReadConstants.CYC_CO2_SENSOR_3 = 30
vlxReadConstants.CYC_CO2_SENSOR_4 = 31
vlxReadConstants.CYC_CO2_SENSOR_5 = 32
vlxReadConstants.CYC_DIP_SWITCH_0 = 33
vlxReadConstants.CYC_DIP_SWITCH_1 = 34
vlxReadConstants.CYC_DIP_SWITCH_2 = 35
vlxReadConstants.CYC_DIP_SWITCH_3 = 36
vlxReadConstants.CYC_TEMP_OPTIONAL = 37
vlxReadConstants.CYC_VOC_LEVEL = 38
vlxReadConstants.CYC_VOC_SENSOR_0 = 39
vlxReadConstants.CYC_VOC_SENSOR_1 = 40
vlxReadConstants.CYC_VOC_SENSOR_2 = 41
vlxReadConstants.CYC_VOC_SENSOR_3 = 42
vlxReadConstants.CYC_NUM_OF_HW_STATES = 43

# /* g_cyclone_sw_state  */
vlxReadConstants.CYC_STATE = 1
vlxReadConstants.CYC_MODE = 2
vlxReadConstants.CYC_DEFROSTING = 3
vlxReadConstants.CYC_BOOST_TIMER = 4
vlxReadConstants.CYC_FIREPLACE_TIMER = 5
vlxReadConstants.CYC_EXTRA_TIMER = 6
vlxReadConstants.CYC_WEEKLY_TIMER_ENABLED = 7
vlxReadConstants.CYC_CELL_STATE = 8
vlxReadConstants.CYC_TOTAL_UP_TIME_YEARS = 9
vlxReadConstants.CYC_TOTAL_UP_TIME_HOURS = 10
vlxReadConstants.CYC_CURRENT_UP_TIME_HOURS = 11
vlxReadConstants.CYC_REMAINING_TIME_FOR_FILTER = 12
vlxReadConstants.CYC_LIMP_MODE = 13
vlxReadConstants.CYC_METRICS = 14
vlxReadConstants.CYC_DEFROST_COUNT_IN_24H = 15
vlxReadConstants.CYC_DEFROST_COUNT_IN_WEEK = 16
vlxReadConstants.CYC_DEFROST_SUPERMELT_THRESHOLD = 17
vlxReadConstants.CYC_ENABLED = 18
vlxReadConstants.CYC_COMMAND = 19
vlxReadConstants.CYC_MLV_STATE = 20
vlxReadConstants.CYC_UPD_ADDRESS_1 = 21
vlxReadConstants.CYC_UPD_ADDRESS_2 = 22
vlxReadConstants.CYC_CLOUD_STATUS = 23
vlxReadConstants.CYC_NUM_OF_SW_STATES = 25

# /* g_cyclone_time  */
vlxReadConstants.CYC_MINUTE = 1
vlxReadConstants.CYC_HOUR = 2
vlxReadConstants.CYC_DAY = 3
vlxReadConstants.CYC_MONTH = 4
vlxReadConstants.CYC_YEAR = 5
vlxReadConstants.CYC_WEEKDAY = 6
vlxReadConstants.CYC_NUM_OF_TIME_ELEMENTS = 7

# /* g_cyclone_output  */
vlxReadConstants.CYC_IO_EXTRACT_FAN = 1
vlxReadConstants.CYC_IO_SUPPLY_FAN = 2
vlxReadConstants.CYC_IO_ERROR = 3
vlxReadConstants.CYC_IO_HEATER = 4
vlxReadConstants.CYC_IO_EXTRA_HEATER = 5
vlxReadConstants.CYC_IO_BYPASS = 6
vlxReadConstants.CYC_NUM_OF_OUTPUTS = 7

# /* g_cyclone_input  */
vlxReadConstants.CYC_IN_EXTRACT_FAN = 1
vlxReadConstants.CYC_IN_SUPPLY_FAN = 2
vlxReadConstants.CYC_IN_ERROR = 3
vlxReadConstants.CYC_IN_HEATER = 4
vlxReadConstants.CYC_IN_EXTRA_HEATER = 5
vlxReadConstants.CYC_IN_BYPASS = 6
vlxReadConstants.CYC_NUM_OF_INPUTS = 7

# /* g_cyclone_config  */
vlxReadConstants.CYC_BETA_STATE = 1
vlxReadConstants.CYC_GW_ADDRESS_1 = 2
vlxReadConstants.CYC_GW_ADDRESS_2 = 3
vlxReadConstants.CYC_MASK_ADDRESS_1 = 4
vlxReadConstants.CYC_MASK_ADDRESS_2 = 5
vlxReadConstants.CYC_RH_0_ADDRESS = 7
vlxReadConstants.CYC_RH_1_ADDRESS = 8
vlxReadConstants.CYC_RH_2_ADDRESS = 9
vlxReadConstants.CYC_RH_3_ADDRESS = 10
vlxReadConstants.CYC_RH_4_ADDRESS = 11
vlxReadConstants.CYC_RH_5_ADDRESS = 12
vlxReadConstants.CYC_CO2_0_ADDRESS = 13
vlxReadConstants.CYC_CO2_1_ADDRESS = 14
vlxReadConstants.CYC_CO2_2_ADDRESS = 15
vlxReadConstants.CYC_CO2_3_ADDRESS = 16
vlxReadConstants.CYC_CO2_4_ADDRESS = 17
vlxReadConstants.CYC_CO2_5_ADDRESS = 18
vlxReadConstants.CYC_ETH_CLOUD_ENABLED = 19
vlxReadConstants.CYC_IP_ADDRESS_1 = 20
vlxReadConstants.CYC_IP_ADDRESS_2 = 21
vlxReadConstants.CYC_UUID0 = 22
vlxReadConstants.CYC_UUID1 = 23
vlxReadConstants.CYC_UUID2 = 24
vlxReadConstants.CYC_UUID3 = 25
vlxReadConstants.CYC_UUID4 = 26
vlxReadConstants.CYC_UUID5 = 27
vlxReadConstants.CYC_UUID6 = 28
vlxReadConstants.CYC_UUID7 = 29
vlxReadConstants.CYC_NUM_OF_CONFIGS = 30

# /* g_cyclone_settings  */
vlxReadConstants.CYC_USED_SETTINGS_VARIABLES = 1
vlxReadConstants.CYC_MODBUS_ADDRESS = 2
vlxReadConstants.CYC_MODBUS_BAUD_X100 = 3
vlxReadConstants.CYC_MODBUS_FRAME = 4
vlxReadConstants.CYC_EXTR_FAN_BALANCE_BASE = 5
vlxReadConstants.CYC_SUPP_FAN_BALANCE_BASE = 6
vlxReadConstants.CYC_FIREPLACE_EXTR_FAN = 7
vlxReadConstants.CYC_FIREPLACE_SUPP_FAN = 8
vlxReadConstants.CYC_RH_BASIC_LEVEL = 10
vlxReadConstants.CYC_CO2_THRESHOLD = 11
vlxReadConstants.CYC_EXTRA_ENABLED = 12
vlxReadConstants.CYC_EXTRA_AIR_TEMP_TARGET = 13
vlxReadConstants.CYC_EXTRA_EXTR_FAN = 14
vlxReadConstants.CYC_EXTRA_SUPP_FAN = 15
vlxReadConstants.CYC_EXTRA_TIME = 16
vlxReadConstants.CYC_AWAY_RH_CTRL_ENABLED = 19
vlxReadConstants.CYC_AWAY_CO2_CTRL_ENABLED = 20
vlxReadConstants.CYC_AWAY_SPEED_SETTING = 21
vlxReadConstants.CYC_AWAY_AIR_TEMP_TARGET = 22
vlxReadConstants.CYC_HOME_RH_CTRL_ENABLED = 25
vlxReadConstants.CYC_HOME_CO2_CTRL_ENABLED = 26
vlxReadConstants.CYC_HOME_SPEED_SETTING = 27
vlxReadConstants.CYC_HOME_AIR_TEMP_TARGET = 28
vlxReadConstants.CYC_BOOST_RH_CTRL_ENABLED = 31
vlxReadConstants.CYC_BOOST_CO2_CTRL_ENABLED = 32
vlxReadConstants.CYC_BOOST_SPEED_SETTING = 33
vlxReadConstants.CYC_BOOST_AIR_TEMP_TARGET = 34
vlxReadConstants.CYC_RELAY_MODE = 37
vlxReadConstants.CYC_DIGITAL_INPUT_1_MODE = 38
vlxReadConstants.CYC_DIGITAL_INPUT_2_MODE = 39
vlxReadConstants.CYC_ANALOG_INPUT_MODE = 40
vlxReadConstants.CYC_MLV_SUPPLY_LOWER_LIMIT = 41
vlxReadConstants.CYC_MLV_AUTO_MANUAL = 43
vlxReadConstants.CYC_DEFROST_MODE = 44
vlxReadConstants.CYC_DEFROST_RH_PARAM = 45
vlxReadConstants.CYC_DEFROST_TEMP_PARAM = 46
vlxReadConstants.CYC_DEFROST_EXH_OFFSET = 47
vlxReadConstants.CYC_DEFROST_COMP_LIMIT = 48
vlxReadConstants.CYC_MLV_SUMMER_SETPOINT = 49
vlxReadConstants.CYC_MLV_MODES = 50
vlxReadConstants.CYC_MLV_WINTER_SETPOINT = 51
vlxReadConstants.CYC_MLV_SUMMER_HYSTERESIS = 52
vlxReadConstants.CYC_MLV_WINTER_HYSTERESIS = 53
vlxReadConstants.CYC_WATERHEATER_STORED_I = 54
vlxReadConstants.CYC_INSTALLATION_DONE = 55
vlxReadConstants.CYC_DEFROST_RH_OFFSET = 56
vlxReadConstants.CYC_FILTER_CHANGE_INTERVAL = 57
vlxReadConstants.CYC_CELL_TYPE = 58
vlxReadConstants.CYC_EXTRA_HEATER_TYPE = 59
vlxReadConstants.CYC_POST_HEATER_TYPE = 60
vlxReadConstants.CYC_BRANDING = 61
vlxReadConstants.CYC_SIDEDNESS = 62
vlxReadConstants.CYC_RH_LEVEL_MODE = 63
vlxReadConstants.CYC_BOOST_TIME = 64
vlxReadConstants.CYC_FIREPLACE_TIME = 65
vlxReadConstants.CYC_FILTER_CHANGED_DAY = 66
vlxReadConstants.CYC_FILTER_CHANGED_MONTH = 67
vlxReadConstants.CYC_FILTER_CHANGED_YEAR = 68
vlxReadConstants.CYC_SUPPLY_HEATING_ADJUST_MODE = 69
vlxReadConstants.CYC_MIN_DEFROST_TIME = 70
vlxReadConstants.CYC_PARTIAL_BYPASS = 71
vlxReadConstants.CYC_BYPASS_LOCKED = 72
vlxReadConstants.CYC_OPT_TEMP_SENSOR_MODE = 73
vlxReadConstants.CYC_POST_HEATER_WINTER_SETPOINT = 74
vlxReadConstants.CYC_DEWPOINT_LIMIT_IN_USE = 75
vlxReadConstants.CYC_NUM_OF_CYC_SETTINGS = 76

# /* g_typhoon_settings  */
vlxReadConstants.CYC_LANGUAGE = 1
vlxReadConstants.CYC_PARENTAL_PASSWORD = 2
vlxReadConstants.CYC_USER_PASSWORD = 3
vlxReadConstants.CYC_ACCESS_LEVEL = 4
vlxReadConstants.CYC_PARENTAL_CTRL_ENABLED = 5
vlxReadConstants.CYC_BOOST_TIMER_ENABLED = 6
vlxReadConstants.CYC_FIREPLACE_TIMER_ENABLED = 7
vlxReadConstants.CYC_SUMMER_TIME_AUTO_ENAB = 8
vlxReadConstants.CYC_12_HOUR_CLOCK_ENABLED = 9
vlxReadConstants.CYC_SLEEP_DELAY = 10
vlxReadConstants.CYC_BG_LIGHT_LEVEL = 11
vlxReadConstants.CYC_EXTRA_TIMER_ENABLED = 12
vlxReadConstants.CYC_NUM_OF_TYP_SETTINGS = 23

# /* g_self_test  */
vlxReadConstants.CYC_SUPP_FAN_TEST = 1
vlxReadConstants.CYC_EXTR_FAN_TEST = 2
vlxReadConstants.CYC_BY_PASS_TEST = 3
vlxReadConstants.CYC_HEATER_TEST = 4
vlxReadConstants.CYC_EXTRA_HEATER_TEST = 5
vlxReadConstants.CYC_EFFICIENCY_TEST = 6
vlxReadConstants.CYC_SUPPLY_EFFICIENCY = 7
vlxReadConstants.CYC_EXTRACT_EFFICIENCY = 8
vlxReadConstants.CYC_NUM_OF_SELF_TESTS = 16

# /* g_faults  */
vlxReadConstants.CYC_TOTAL_FAULT_COUNT = 1
vlxReadConstants.CYC_FAULT_CODE = 2
vlxReadConstants.CYC_FAULT_SEVERITY = 3
vlxReadConstants.CYC_FAULT_FIRST_DATE = 4
vlxReadConstants.CYC_FAULT_LAST_DATE = 5
vlxReadConstants.CYC_FAULT_COUNT = 6
vlxReadConstants.CYC_FAULT_ACTIVITY = 7
vlxReadConstants.CYC_FAULT_CODE_2 = 8
vlxReadConstants.CYC_FAULT_SEVERITY_2 = 9
vlxReadConstants.CYC_FAULT_FIRST_DATE_2 = 10
vlxReadConstants.CYC_FAULT_LAST_DATE_2 = 11
vlxReadConstants.CYC_FAULT_COUNT_2 = 12
vlxReadConstants.CYC_FAULT_ACTIVITY_2 = 13
vlxReadConstants.CYC_FAULT_CODE_3 = 14
vlxReadConstants.CYC_FAULT_SEVERITY_3 = 15
vlxReadConstants.CYC_FAULT_FIRST_DATE_3 = 16
vlxReadConstants.CYC_FAULT_LAST_DATE_3 = 17
vlxReadConstants.CYC_FAULT_COUNT_3 = 18
vlxReadConstants.CYC_FAULT_ACTIVITY_3 = 19
vlxReadConstants.CYC_FAULT_CODE_4 = 20
vlxReadConstants.CYC_FAULT_SEVERITY_4 = 21
vlxReadConstants.CYC_FAULT_FIRST_DATE_4 = 22
vlxReadConstants.CYC_FAULT_LAST_DATE_4 = 23
vlxReadConstants.CYC_FAULT_COUNT_4 = 24
vlxReadConstants.CYC_FAULT_ACTIVITY_4 = 25
vlxReadConstants.CYC_FAULT_CODE_5 = 26
vlxReadConstants.CYC_FAULT_SEVERITY_5 = 27
vlxReadConstants.CYC_FAULT_FIRST_DATE_5 = 28
vlxReadConstants.CYC_FAULT_LAST_DATE_5 = 29
vlxReadConstants.CYC_FAULT_COUNT_5 = 30
vlxReadConstants.CYC_FAULT_ACTIVITY_5 = 31
vlxReadConstants.CYC_FAULT_CODE_6 = 32
vlxReadConstants.CYC_FAULT_SEVERITY_6 = 33
vlxReadConstants.CYC_FAULT_FIRST_DATE_6 = 34
vlxReadConstants.CYC_FAULT_LAST_DATE_6 = 35
vlxReadConstants.CYC_FAULT_COUNT_6 = 36
vlxReadConstants.CYC_FAULT_ACTIVITY_6 = 37
vlxReadConstants.CYC_FAULT_CODE_7 = 38
vlxReadConstants.CYC_FAULT_SEVERITY_7 = 39
vlxReadConstants.CYC_FAULT_FIRST_DATE_7 = 40
vlxReadConstants.CYC_FAULT_LAST_DATE_7 = 41
vlxReadConstants.CYC_FAULT_COUNT_7 = 42
vlxReadConstants.CYC_FAULT_ACTIVITY_7 = 43
vlxReadConstants.CYC_FAULT_CODE_8 = 44
vlxReadConstants.CYC_FAULT_SEVERITY_8 = 45
vlxReadConstants.CYC_FAULT_FIRST_DATE_8 = 46
vlxReadConstants.CYC_FAULT_LAST_DATE_8 = 47
vlxReadConstants.CYC_FAULT_COUNT_8 = 48
vlxReadConstants.CYC_FAULT_ACTIVITY_8 = 49
vlxReadConstants.CYC_FAULT_CODE_9 = 50
vlxReadConstants.CYC_FAULT_SEVERITY_9 = 51
vlxReadConstants.CYC_FAULT_FIRST_DATE_9 = 52
vlxReadConstants.CYC_FAULT_LAST_DATE_9 = 53
vlxReadConstants.CYC_FAULT_COUNT_9 = 54
vlxReadConstants.CYC_FAULT_ACTIVITY_9 = 55
vlxReadConstants.CYC_FAULT_CODE_10 = 56
vlxReadConstants.CYC_FAULT_SEVERITY_10 = 57
vlxReadConstants.CYC_FAULT_FIRST_DATE_10 = 58
vlxReadConstants.CYC_FAULT_LAST_DATE_10 = 59
vlxReadConstants.CYC_FAULT_COUNT_10 = 60
vlxReadConstants.CYC_FAULT_ACTIVITY_10 = 61
vlxReadConstants.CYC_FAULT_CODE_11 = 62
vlxReadConstants.CYC_FAULT_SEVERITY_11 = 63
vlxReadConstants.CYC_FAULT_FIRST_DATE_11 = 64
vlxReadConstants.CYC_FAULT_LAST_DATE_11 = 65
vlxReadConstants.CYC_FAULT_COUNT_11 = 66
vlxReadConstants.CYC_FAULT_ACTIVITY_11 = 67
vlxReadConstants.CYC_FAULT_CODE_12 = 68
vlxReadConstants.CYC_FAULT_SEVERITY_12 = 69
vlxReadConstants.CYC_FAULT_FIRST_DATE_12 = 70
vlxReadConstants.CYC_FAULT_LAST_DATE_12 = 71
vlxReadConstants.CYC_FAULT_COUNT_12 = 72
vlxReadConstants.CYC_FAULT_ACTIVITY_12 = 73
vlxReadConstants.CYC_FAULT_CODE_13 = 74
vlxReadConstants.CYC_FAULT_SEVERITY_13 = 75
vlxReadConstants.CYC_FAULT_FIRST_DATE_13 = 76
vlxReadConstants.CYC_FAULT_LAST_DATE_13 = 77
vlxReadConstants.CYC_FAULT_COUNT_13 = 78
vlxReadConstants.CYC_FAULT_ACTIVITY_13 = 79
vlxReadConstants.CYC_FAULT_CODE_14 = 80
vlxReadConstants.CYC_FAULT_SEVERITY_14 = 81
vlxReadConstants.CYC_FAULT_FIRST_DATE_14 = 82
vlxReadConstants.CYC_FAULT_LAST_DATE_14 = 83
vlxReadConstants.CYC_FAULT_COUNT_14 = 84
vlxReadConstants.CYC_FAULT_ACTIVITY_14 = 85
vlxReadConstants.CYC_FAULT_CODE_15 = 86
vlxReadConstants.CYC_FAULT_SEVERITY_15 = 87
vlxReadConstants.CYC_FAULT_FIRST_DATE_15 = 88
vlxReadConstants.CYC_FAULT_LAST_DATE_15 = 89
vlxReadConstants.CYC_FAULT_COUNT_15 = 90
vlxReadConstants.CYC_FAULT_ACTIVITY_15 = 91
vlxReadConstants.CYC_FAULT_CODE_16 = 92
vlxReadConstants.CYC_FAULT_SEVERITY_16 = 93
vlxReadConstants.CYC_FAULT_FIRST_DATE_16 = 94
vlxReadConstants.CYC_FAULT_LAST_DATE_16 = 95
vlxReadConstants.CYC_FAULT_COUNT_16 = 96
vlxReadConstants.CYC_FAULT_ACTIVITY_16 = 97
vlxReadConstants.CYC_FAULT_CODE_17 = 98
vlxReadConstants.CYC_FAULT_SEVERITY_17 = 99
vlxReadConstants.CYC_FAULT_FIRST_DATE_17 = 100
vlxReadConstants.CYC_FAULT_LAST_DATE_17 = 101
vlxReadConstants.CYC_FAULT_COUNT_17 = 102
vlxReadConstants.CYC_FAULT_ACTIVITY_17 = 103
vlxReadConstants.CYC_FAULT_CODE_18 = 104
vlxReadConstants.CYC_FAULT_SEVERITY_18 = 105
vlxReadConstants.CYC_FAULT_FIRST_DATE_18 = 106
vlxReadConstants.CYC_FAULT_LAST_DATE_18 = 107
vlxReadConstants.CYC_FAULT_COUNT_18 = 108
vlxReadConstants.CYC_FAULT_ACTIVITY_18 = 109
vlxReadConstants.CYC_FAULT_CODE_19 = 110
vlxReadConstants.CYC_FAULT_SEVERITY_19 = 111
vlxReadConstants.CYC_FAULT_FIRST_DATE_19 = 112
vlxReadConstants.CYC_FAULT_LAST_DATE_19 = 113
vlxReadConstants.CYC_FAULT_COUNT_19 = 114
vlxReadConstants.CYC_FAULT_ACTIVITY_19 = 115
vlxReadConstants.CYC_FAULT_CODE_20 = 116
vlxReadConstants.CYC_FAULT_SEVERITY_20 = 117
vlxReadConstants.CYC_FAULT_FIRST_DATE_20 = 118
vlxReadConstants.CYC_FAULT_LAST_DATE_20 = 119
vlxReadConstants.CYC_FAULT_COUNT_20 = 120
vlxReadConstants.CYC_FAULT_ACTIVITY_20 = 121
vlxReadConstants.CYC_FAULT_CODE_21 = 122
vlxReadConstants.CYC_FAULT_SEVERITY_21 = 123
vlxReadConstants.CYC_FAULT_FIRST_DATE_21 = 124
vlxReadConstants.CYC_FAULT_LAST_DATE_21 = 125
vlxReadConstants.CYC_FAULT_COUNT_21 = 126
vlxReadConstants.CYC_FAULT_ACTIVITY_21 = 127
vlxReadConstants.CYC_FAULT_CODE_22 = 128
vlxReadConstants.CYC_FAULT_SEVERITY_22 = 129
vlxReadConstants.CYC_FAULT_FIRST_DATE_22 = 130
vlxReadConstants.CYC_FAULT_LAST_DATE_22 = 131
vlxReadConstants.CYC_FAULT_COUNT_22 = 132
vlxReadConstants.CYC_FAULT_ACTIVITY_22 = 133
vlxReadConstants.CYC_FAULT_CODE_23 = 134
vlxReadConstants.CYC_FAULT_SEVERITY_23 = 135
vlxReadConstants.CYC_FAULT_FIRST_DATE_23 = 136
vlxReadConstants.CYC_FAULT_LAST_DATE_23 = 137
vlxReadConstants.CYC_FAULT_COUNT_23 = 138
vlxReadConstants.CYC_FAULT_ACTIVITY_23 = 139
vlxReadConstants.CYC_FAULT_CODE_24 = 140
vlxReadConstants.CYC_FAULT_SEVERITY_24 = 141
vlxReadConstants.CYC_FAULT_FIRST_DATE_24 = 142
vlxReadConstants.CYC_FAULT_LAST_DATE_24 = 143
vlxReadConstants.CYC_FAULT_COUNT_24 = 144
vlxReadConstants.CYC_FAULT_ACTIVITY_24 = 145
vlxReadConstants.CYC_FAULT_CODE_25 = 146
vlxReadConstants.CYC_FAULT_SEVERITY_25 = 147
vlxReadConstants.CYC_FAULT_FIRST_DATE_25 = 148
vlxReadConstants.CYC_FAULT_LAST_DATE_25 = 149
vlxReadConstants.CYC_FAULT_COUNT_25 = 150
vlxReadConstants.CYC_FAULT_ACTIVITY_25 = 151
vlxReadConstants.CYC_FAULT_CODE_26 = 152
vlxReadConstants.CYC_FAULT_SEVERITY_26 = 153
vlxReadConstants.CYC_FAULT_FIRST_DATE_26 = 154
vlxReadConstants.CYC_FAULT_LAST_DATE_26 = 155
vlxReadConstants.CYC_FAULT_COUNT_26 = 156
vlxReadConstants.CYC_FAULT_ACTIVITY_26 = 157
vlxReadConstants.CYC_FAULT_CODE_27 = 158
vlxReadConstants.CYC_FAULT_SEVERITY_27 = 159
vlxReadConstants.CYC_FAULT_FIRST_DATE_27 = 160
vlxReadConstants.CYC_FAULT_LAST_DATE_27 = 161
vlxReadConstants.CYC_FAULT_COUNT_27 = 162
vlxReadConstants.CYC_FAULT_ACTIVITY_27 = 163
vlxReadConstants.CYC_FAULT_CODE_28 = 164
vlxReadConstants.CYC_FAULT_SEVERITY_28 = 165
vlxReadConstants.CYC_FAULT_FIRST_DATE_28 = 166
vlxReadConstants.CYC_FAULT_LAST_DATE_28 = 167
vlxReadConstants.CYC_FAULT_COUNT_28 = 168
vlxReadConstants.CYC_FAULT_ACTIVITY_28 = 169
vlxReadConstants.CYC_FAULT_CODE_29 = 170
vlxReadConstants.CYC_FAULT_SEVERITY_29 = 171
vlxReadConstants.CYC_FAULT_FIRST_DATE_29 = 172
vlxReadConstants.CYC_FAULT_LAST_DATE_29 = 173
vlxReadConstants.CYC_FAULT_COUNT_29 = 174
vlxReadConstants.CYC_FAULT_ACTIVITY_29 = 175
vlxReadConstants.CYC_FAULT_CODE_30 = 176
vlxReadConstants.CYC_FAULT_SEVERITY_30 = 177
vlxReadConstants.CYC_FAULT_FIRST_DATE_30 = 178
vlxReadConstants.CYC_FAULT_LAST_DATE_30 = 179
vlxReadConstants.CYC_FAULT_COUNT_30 = 180
vlxReadConstants.CYC_FAULT_ACTIVITY_30 = 181
vlxReadConstants.CYC_FAULT_CODE_31 = 182
vlxReadConstants.CYC_FAULT_SEVERITY_31 = 183
vlxReadConstants.CYC_FAULT_FIRST_DATE_31 = 184
vlxReadConstants.CYC_FAULT_LAST_DATE_31 = 185
vlxReadConstants.CYC_FAULT_COUNT_31 = 186
vlxReadConstants.CYC_FAULT_ACTIVITY_31 = 187
vlxReadConstants.CYC_FAULT_CODE_32 = 188
vlxReadConstants.CYC_FAULT_SEVERITY_32 = 189
vlxReadConstants.CYC_FAULT_FIRST_DATE_32 = 190
vlxReadConstants.CYC_FAULT_LAST_DATE_32 = 191
vlxReadConstants.CYC_FAULT_COUNT_32 = 192
vlxReadConstants.CYC_FAULT_ACTIVITY_32 = 193
vlxReadConstants.CYC_FAULT_CODE_33 = 194
vlxReadConstants.CYC_FAULT_SEVERITY_33 = 195
vlxReadConstants.CYC_FAULT_FIRST_DATE_33 = 196
vlxReadConstants.CYC_FAULT_LAST_DATE_33 = 197
vlxReadConstants.CYC_FAULT_COUNT_33 = 198
vlxReadConstants.CYC_FAULT_ACTIVITY_33 = 199
vlxReadConstants.CYC_NUM_OF_FAULTS = 200

# /* g_cyclone_weekly_schedule  */
vlxReadConstants.CYC_SCHEDULE_MONDAY_00 = 1
vlxReadConstants.CYC_SCHEDULE_MONDAY_01 = 2
vlxReadConstants.CYC_SCHEDULE_MONDAY_02 = 3
vlxReadConstants.CYC_SCHEDULE_MONDAY_03 = 4
vlxReadConstants.CYC_SCHEDULE_MONDAY_04 = 5
vlxReadConstants.CYC_SCHEDULE_MONDAY_05 = 6
vlxReadConstants.CYC_SCHEDULE_MONDAY_06 = 7
vlxReadConstants.CYC_SCHEDULE_MONDAY_07 = 8
vlxReadConstants.CYC_SCHEDULE_MONDAY_08 = 9
vlxReadConstants.CYC_SCHEDULE_MONDAY_09 = 10
vlxReadConstants.CYC_SCHEDULE_MONDAY_10 = 11
vlxReadConstants.CYC_SCHEDULE_MONDAY_11 = 12
vlxReadConstants.CYC_SCHEDULE_MONDAY_12 = 13
vlxReadConstants.CYC_SCHEDULE_MONDAY_13 = 14
vlxReadConstants.CYC_SCHEDULE_MONDAY_14 = 15
vlxReadConstants.CYC_SCHEDULE_MONDAY_15 = 16
vlxReadConstants.CYC_SCHEDULE_MONDAY_16 = 17
vlxReadConstants.CYC_SCHEDULE_MONDAY_17 = 18
vlxReadConstants.CYC_SCHEDULE_MONDAY_18 = 19
vlxReadConstants.CYC_SCHEDULE_MONDAY_19 = 20
vlxReadConstants.CYC_SCHEDULE_MONDAY_20 = 21
vlxReadConstants.CYC_SCHEDULE_MONDAY_21 = 22
vlxReadConstants.CYC_SCHEDULE_MONDAY_22 = 23
vlxReadConstants.CYC_SCHEDULE_MONDAY_23 = 24
vlxReadConstants.CYC_SCHEDULE_TUESDAY_00 = 25
vlxReadConstants.CYC_SCHEDULE_TUESDAY_01 = 26
vlxReadConstants.CYC_SCHEDULE_TUESDAY_02 = 27
vlxReadConstants.CYC_SCHEDULE_TUESDAY_03 = 28
vlxReadConstants.CYC_SCHEDULE_TUESDAY_04 = 29
vlxReadConstants.CYC_SCHEDULE_TUESDAY_05 = 30
vlxReadConstants.CYC_SCHEDULE_TUESDAY_06 = 31
vlxReadConstants.CYC_SCHEDULE_TUESDAY_07 = 32
vlxReadConstants.CYC_SCHEDULE_TUESDAY_08 = 33
vlxReadConstants.CYC_SCHEDULE_TUESDAY_09 = 34
vlxReadConstants.CYC_SCHEDULE_TUESDAY_10 = 35
vlxReadConstants.CYC_SCHEDULE_TUESDAY_11 = 36
vlxReadConstants.CYC_SCHEDULE_TUESDAY_12 = 37
vlxReadConstants.CYC_SCHEDULE_TUESDAY_13 = 38
vlxReadConstants.CYC_SCHEDULE_TUESDAY_14 = 39
vlxReadConstants.CYC_SCHEDULE_TUESDAY_15 = 40
vlxReadConstants.CYC_SCHEDULE_TUESDAY_16 = 41
vlxReadConstants.CYC_SCHEDULE_TUESDAY_17 = 42
vlxReadConstants.CYC_SCHEDULE_TUESDAY_18 = 43
vlxReadConstants.CYC_SCHEDULE_TUESDAY_19 = 44
vlxReadConstants.CYC_SCHEDULE_TUESDAY_20 = 45
vlxReadConstants.CYC_SCHEDULE_TUESDAY_21 = 46
vlxReadConstants.CYC_SCHEDULE_TUESDAY_22 = 47
vlxReadConstants.CYC_SCHEDULE_TUESDAY_23 = 48
vlxReadConstants.CYC_SCHEDULE_WEDNESDAY_00 = 49
vlxReadConstants.CYC_SCHEDULE_WEDNESDAY_01 = 50
vlxReadConstants.CYC_SCHEDULE_WEDNESDAY_02 = 51
vlxReadConstants.CYC_SCHEDULE_WEDNESDAY_03 = 52
vlxReadConstants.CYC_SCHEDULE_WEDNESDAY_04 = 53
vlxReadConstants.CYC_SCHEDULE_WEDNESDAY_05 = 54
vlxReadConstants.CYC_SCHEDULE_WEDNESDAY_06 = 55
vlxReadConstants.CYC_SCHEDULE_WEDNESDAY_07 = 56
vlxReadConstants.CYC_SCHEDULE_WEDNESDAY_08 = 57
vlxReadConstants.CYC_SCHEDULE_WEDNESDAY_09 = 58
vlxReadConstants.CYC_SCHEDULE_WEDNESDAY_10 = 59
vlxReadConstants.CYC_SCHEDULE_WEDNESDAY_11 = 60
vlxReadConstants.CYC_SCHEDULE_WEDNESDAY_12 = 61
vlxReadConstants.CYC_SCHEDULE_WEDNESDAY_13 = 62
vlxReadConstants.CYC_SCHEDULE_WEDNESDAY_14 = 63
vlxReadConstants.CYC_SCHEDULE_WEDNESDAY_15 = 64
vlxReadConstants.CYC_SCHEDULE_WEDNESDAY_16 = 65
vlxReadConstants.CYC_SCHEDULE_WEDNESDAY_17 = 66
vlxReadConstants.CYC_SCHEDULE_WEDNESDAY_18 = 67
vlxReadConstants.CYC_SCHEDULE_WEDNESDAY_19 = 68
vlxReadConstants.CYC_SCHEDULE_WEDNESDAY_20 = 69
vlxReadConstants.CYC_SCHEDULE_WEDNESDAY_21 = 70
vlxReadConstants.CYC_SCHEDULE_WEDNESDAY_22 = 71
vlxReadConstants.CYC_SCHEDULE_WEDNESDAY_23 = 72
vlxReadConstants.CYC_SCHEDULE_THURSDAY_00 = 73
vlxReadConstants.CYC_SCHEDULE_THURSDAY_01 = 74
vlxReadConstants.CYC_SCHEDULE_THURSDAY_02 = 75
vlxReadConstants.CYC_SCHEDULE_THURSDAY_03 = 76
vlxReadConstants.CYC_SCHEDULE_THURSDAY_04 = 77
vlxReadConstants.CYC_SCHEDULE_THURSDAY_05 = 78
vlxReadConstants.CYC_SCHEDULE_THURSDAY_06 = 79
vlxReadConstants.CYC_SCHEDULE_THURSDAY_07 = 80
vlxReadConstants.CYC_SCHEDULE_THURSDAY_08 = 81
vlxReadConstants.CYC_SCHEDULE_THURSDAY_09 = 82
vlxReadConstants.CYC_SCHEDULE_THURSDAY_10 = 83
vlxReadConstants.CYC_SCHEDULE_THURSDAY_11 = 84
vlxReadConstants.CYC_SCHEDULE_THURSDAY_12 = 85
vlxReadConstants.CYC_SCHEDULE_THURSDAY_13 = 86
vlxReadConstants.CYC_SCHEDULE_THURSDAY_14 = 87
vlxReadConstants.CYC_SCHEDULE_THURSDAY_15 = 88
vlxReadConstants.CYC_SCHEDULE_THURSDAY_16 = 89
vlxReadConstants.CYC_SCHEDULE_THURSDAY_17 = 90
vlxReadConstants.CYC_SCHEDULE_THURSDAY_18 = 91
vlxReadConstants.CYC_SCHEDULE_THURSDAY_19 = 92
vlxReadConstants.CYC_SCHEDULE_THURSDAY_20 = 93
vlxReadConstants.CYC_SCHEDULE_THURSDAY_21 = 94
vlxReadConstants.CYC_SCHEDULE_THURSDAY_22 = 95
vlxReadConstants.CYC_SCHEDULE_THURSDAY_23 = 96
vlxReadConstants.CYC_SCHEDULE_FRIDAY_00 = 97
vlxReadConstants.CYC_SCHEDULE_FRIDAY_01 = 98
vlxReadConstants.CYC_SCHEDULE_FRIDAY_02 = 99
vlxReadConstants.CYC_SCHEDULE_FRIDAY_03 = 100
vlxReadConstants.CYC_SCHEDULE_FRIDAY_04 = 101
vlxReadConstants.CYC_SCHEDULE_FRIDAY_05 = 102
vlxReadConstants.CYC_SCHEDULE_FRIDAY_06 = 103
vlxReadConstants.CYC_SCHEDULE_FRIDAY_07 = 104
vlxReadConstants.CYC_SCHEDULE_FRIDAY_08 = 105
vlxReadConstants.CYC_SCHEDULE_FRIDAY_09 = 106
vlxReadConstants.CYC_SCHEDULE_FRIDAY_10 = 107
vlxReadConstants.CYC_SCHEDULE_FRIDAY_11 = 108
vlxReadConstants.CYC_SCHEDULE_FRIDAY_12 = 109
vlxReadConstants.CYC_SCHEDULE_FRIDAY_13 = 110
vlxReadConstants.CYC_SCHEDULE_FRIDAY_14 = 111
vlxReadConstants.CYC_SCHEDULE_FRIDAY_15 = 112
vlxReadConstants.CYC_SCHEDULE_FRIDAY_16 = 113
vlxReadConstants.CYC_SCHEDULE_FRIDAY_17 = 114
vlxReadConstants.CYC_SCHEDULE_FRIDAY_18 = 115
vlxReadConstants.CYC_SCHEDULE_FRIDAY_19 = 116
vlxReadConstants.CYC_SCHEDULE_FRIDAY_20 = 117
vlxReadConstants.CYC_SCHEDULE_FRIDAY_21 = 118
vlxReadConstants.CYC_SCHEDULE_FRIDAY_22 = 119
vlxReadConstants.CYC_SCHEDULE_FRIDAY_23 = 120
vlxReadConstants.CYC_SCHEDULE_SATURDAY_00 = 121
vlxReadConstants.CYC_SCHEDULE_SATURDAY_01 = 122
vlxReadConstants.CYC_SCHEDULE_SATURDAY_02 = 123
vlxReadConstants.CYC_SCHEDULE_SATURDAY_03 = 124
vlxReadConstants.CYC_SCHEDULE_SATURDAY_04 = 125
vlxReadConstants.CYC_SCHEDULE_SATURDAY_05 = 126
vlxReadConstants.CYC_SCHEDULE_SATURDAY_06 = 127
vlxReadConstants.CYC_SCHEDULE_SATURDAY_07 = 128
vlxReadConstants.CYC_SCHEDULE_SATURDAY_08 = 129
vlxReadConstants.CYC_SCHEDULE_SATURDAY_09 = 130
vlxReadConstants.CYC_SCHEDULE_SATURDAY_10 = 131
vlxReadConstants.CYC_SCHEDULE_SATURDAY_11 = 132
vlxReadConstants.CYC_SCHEDULE_SATURDAY_12 = 133
vlxReadConstants.CYC_SCHEDULE_SATURDAY_13 = 134
vlxReadConstants.CYC_SCHEDULE_SATURDAY_14 = 135
vlxReadConstants.CYC_SCHEDULE_SATURDAY_15 = 136
vlxReadConstants.CYC_SCHEDULE_SATURDAY_16 = 137
vlxReadConstants.CYC_SCHEDULE_SATURDAY_17 = 138
vlxReadConstants.CYC_SCHEDULE_SATURDAY_18 = 139
vlxReadConstants.CYC_SCHEDULE_SATURDAY_19 = 140
vlxReadConstants.CYC_SCHEDULE_SATURDAY_20 = 141
vlxReadConstants.CYC_SCHEDULE_SATURDAY_21 = 142
vlxReadConstants.CYC_SCHEDULE_SATURDAY_22 = 143
vlxReadConstants.CYC_SCHEDULE_SATURDAY_23 = 144
vlxReadConstants.CYC_SCHEDULE_SUNDAY_00 = 145
vlxReadConstants.CYC_SCHEDULE_SUNDAY_01 = 146
vlxReadConstants.CYC_SCHEDULE_SUNDAY_02 = 147
vlxReadConstants.CYC_SCHEDULE_SUNDAY_03 = 148
vlxReadConstants.CYC_SCHEDULE_SUNDAY_04 = 149
vlxReadConstants.CYC_SCHEDULE_SUNDAY_05 = 150
vlxReadConstants.CYC_SCHEDULE_SUNDAY_06 = 151
vlxReadConstants.CYC_SCHEDULE_SUNDAY_07 = 152
vlxReadConstants.CYC_SCHEDULE_SUNDAY_08 = 153
vlxReadConstants.CYC_SCHEDULE_SUNDAY_09 = 154
vlxReadConstants.CYC_SCHEDULE_SUNDAY_10 = 155
vlxReadConstants.CYC_SCHEDULE_SUNDAY_11 = 156
vlxReadConstants.CYC_SCHEDULE_SUNDAY_12 = 157
vlxReadConstants.CYC_SCHEDULE_SUNDAY_13 = 158
vlxReadConstants.CYC_SCHEDULE_SUNDAY_14 = 159
vlxReadConstants.CYC_SCHEDULE_SUNDAY_15 = 160
vlxReadConstants.CYC_SCHEDULE_SUNDAY_16 = 161
vlxReadConstants.CYC_SCHEDULE_SUNDAY_17 = 162
vlxReadConstants.CYC_SCHEDULE_SUNDAY_18 = 163
vlxReadConstants.CYC_SCHEDULE_SUNDAY_19 = 164
vlxReadConstants.CYC_SCHEDULE_SUNDAY_20 = 165
vlxReadConstants.CYC_SCHEDULE_SUNDAY_21 = 166
vlxReadConstants.CYC_SCHEDULE_SUNDAY_22 = 167
vlxReadConstants.CYC_SCHEDULE_SUNDAY_23 = 168
vlxReadConstants.CYC_NUM_OF_SCHEDULED_EVENTS = 169

# /**
#  * Created by janne.hamalainen on 9.9.2014.
#  * Extra constanst are modbus "addresses" that are used
#  * only in datamodel. These values are never transferred as such
#  * to the device. Instead iowebdatatodevice.js class handles the
#  * parameters and sends valid data to the device using real modbus
#  * addresses. This is needed since most of the data stored in the
#  * datamodel is not suitable for the device as such and needs some
#  * kind of conversion.
#  */


# // Extra Constants defined just for DataModel use
# // These ID Values in DataModel must be unique

KExtParamBase = 0x10000  # 65536


vlxDevConstants.EXT_BROWSER_IP = KExtParamBase + 0
vlxDevConstants.EXT_NUM_OF_RH_SENSORS = KExtParamBase + 1
vlxDevConstants.EXT_NUM_OF_CO2_SENSORS = KExtParamBase + 2
vlxDevConstants.EXT_CYC_APPL_SW_VERSION = KExtParamBase + 3


vlxDevConstants.EXT_TEMP_NOW_EXTRACT_AIR = KExtParamBase + 4
vlxDevConstants.EXT_TEMP_NOW_SUPPLY_AIR = KExtParamBase + 5
vlxDevConstants.EXT_TEMP_NOW_OUTDOOR_AIR = KExtParamBase + 6
vlxDevConstants.EXT_TEMP_NOW_EXHAUST_AIR = KExtParamBase + 7
vlxDevConstants.EXT_MODBUS_STOPBIT = KExtParamBase + 8
vlxDevConstants.EXT_MODBUS_PARITY = KExtParamBase + 9
vlxDevConstants.EXT_CYC_TIME = KExtParamBase + 10
vlxDevConstants.EXT_CYC_DATE = KExtParamBase + 11
vlxDevConstants.EXT_CYC_SERIAL_NUMBER = KExtParamBase + 12
vlxDevConstants.EXT_CYC_FILTER_CHANGED_DATE = KExtParamBase + 13
vlxDevConstants.EXT_CYC_ACTIVE_PROFILE = KExtParamBase + 14
vlxDevConstants.EXT_CYC_PROFILE_SUPPLY_AIR = KExtParamBase + 15
vlxDevConstants.EXT_CYC_PROFILE_OUTDOOR_AIR = KExtParamBase + 16
vlxDevConstants.EXT_CYC_CURRENT_UP_TIME = KExtParamBase + 17
vlxDevConstants.EXT_CYC_TOTAL_UP_TIME = KExtParamBase + 18
vlxDevConstants.EXT_REFRESH_GRAPHS = KExtParamBase + 19
vlxDevConstants.EXT_BROWSER_PORT = KExtParamBase + 20
vlxDevConstants.EXT_CYC_WEEKLY_EVENTS = KExtParamBase + 21
vlxDevConstants.EXT_CYC_FAULT_ARRAY = KExtParamBase + 22
vlxDevConstants.EXT_CYC_START_SELFTEST = KExtParamBase + 23
vlxDevConstants.EXT_CYC_POWER = KExtParamBase + 24
vlxDevConstants.EXT_CYC_TIME = KExtParamBase + 25
vlxDevConstants.EXT_CYC_DATE = KExtParamBase + 26
vlxDevConstants.EXT_LISTENER_ENABLED = KExtParamBase + 27
vlxDevConstants.EXT_SHOW_WIZARD = KExtParamBase + 28
vlxDevConstants.EXT_CYC_CONFIG_NUMBER = KExtParamBase + 29
vlxDevConstants.EXT_PAGES_LOADED = KExtParamBase + 30
vlxDevConstants.EXT_ERROR_SOLVED = KExtParamBase + 31
vlxDevConstants.EXT_CYC_SUPP_FAN_SPEED = KExtParamBase + 32
vlxDevConstants.EXT_CYC_EXTR_FAN_SPEED = KExtParamBase + 33
vlxDevConstants.EXT_GRAPH_DURATION = KExtParamBase + 34
vlxDevConstants.EXT_GRAPH_DURATION_IN_DAYS = KExtParamBase + 35
vlxDevConstants.EXT_TEST_MODE_SWITCH = KExtParamBase + 36
vlxDevConstants.EXT_SERVICE_MODE = KExtParamBase + 37
vlxDevConstants.EXT_DATA_SC = KExtParamBase + 38
vlxDevConstants.EXT_CONFIG_BUTTON = KExtParamBase + 39
vlxDevConstants.EXT_CONFIG_DONE = KExtParamBase + 40
vlxDevConstants.EXT_WIZARD_DONE = KExtParamBase + 41
vlxDevConstants.EXT_OFFLINE_MODE = KExtParamBase + 42
vlxDevConstants.EXT_HOME_AIR_TEMP_TARGET = KExtParamBase + 43
vlxDevConstants.EXT_AWAY_AIR_TEMP_TARGET = KExtParamBase + 44
vlxDevConstants.EXT_BOOST_AIR_TEMP_TARGET = KExtParamBase + 45
vlxDevConstants.EXT_BOOT_FINISHED = KExtParamBase + 46
vlxDevConstants.EXT_USER_PASSWORD = KExtParamBase + 47
# // KExtParamBase+48 is free
vlxDevConstants.EXT_DATA_POLLING = KExtParamBase + 49
vlxDevConstants.EXT_DATA_POLLING_INTERVAL = KExtParamBase + 50
vlxDevConstants.EXT_DATA_POLLING_ENABLED = KExtParamBase + 51
vlxDevConstants.EXT_DATA_POLLING_UI_UPDATE_ENABLED = KExtParamBase + 52
vlxDevConstants.EXT_CLEAR_WEEK_EVENTS = KExtParamBase + 53
vlxDevConstants.EXT_CYC_OLD_WEEKLY_EVENTS = KExtParamBase + 54
vlxDevConstants.EXT_DIGITAL_INPUT_1_MODE = KExtParamBase + 55
vlxDevConstants.EXT_DIGITAL_INPUT_2_MODE = KExtParamBase + 56
vlxDevConstants.EXT_ANALOG_INPUT_MODE = KExtParamBase + 57
vlxDevConstants.EXT_EXTRA_AIR_TEMP_TARGET = KExtParamBase + 58
vlxDevConstants.EXT_EXTRA_EXTR_FAN = KExtParamBase + 59
vlxDevConstants.EXT_EXTRA_SUPP_FAN = KExtParamBase + 60
vlxDevConstants.EXT_EXTRA_TIME = KExtParamBase + 61
vlxDevConstants.EXT_EXTRA_TIMER_ENABLED = KExtParamBase + 62
vlxDevConstants.EXT_MACHINE_TYPE = KExtParamBase + 63
vlxDevConstants.EXT_DEFROST_ON = KExtParamBase + 64
vlxDevConstants.EXT_FILTER_CHANGE_INTERVAL = KExtParamBase + 65
vlxDevConstants.EXT_BOOST_TIMER_ENABLED = KExtParamBase + 66
vlxDevConstants.EXT_BOOST_TIME = KExtParamBase + 67
vlxDevConstants.EXT_CYC_DEFROST_TEMP_PARAM = KExtParamBase + 68
vlxDevConstants.EXT_CYC_DEFROST_RH_OFFSET = KExtParamBase + 69
vlxDevConstants.EXT_LISTENER_SKIPPER = KExtParamBase + 70
vlxDevConstants.EXT_CYC_EXTRA_HEATER_TYPE = KExtParamBase + 71
vlxDevConstants.EXT_CYC_POST_HEATER_TYPE = KExtParamBase + 72
vlxDevConstants.EXT_CYC_DEFROSTING = KExtParamBase + 73
vlxDevConstants.EXT_INFOBANNER_CONTENT = KExtParamBase + 74
vlxDevConstants.EXT_UUID_STRING = KExtParamBase + 75
vlxDevConstants.EXT_CLOUD_CONNECT = KExtParamBase + 76
vlxDevConstants.EXT_CLOUD_DISCONNECT = KExtParamBase + 77
vlxDevConstants.EXT_LANGUAGE = KExtParamBase + 78
vlxDevConstants.EXT_USERNAME = KExtParamBase + 79
vlxDevConstants.EXT_LC_CHANGED = KExtParamBase + 80
vlxDevConstants.EXT_GRANT_ACCESS_SEND = KExtParamBase + 81
vlxDevConstants.EXT_GRANT_ACCESS_EMAIL = KExtParamBase + 82
vlxDevConstants.EXT_GRANT_ACCESS_EMAIL_VALID = KExtParamBase + 83
vlxDevConstants.EXT_GRANT_ACCESS_EMAIL_LIST = KExtParamBase + 84
vlxDevConstants.EXT_CLOUD_CONNECTION_STATUS = KExtParamBase + 85
vlxDevConstants.EXT_ACCESSRIGHTS_ARRAY = KExtParamBase + 86
vlxDevConstants.EXT_IP_ADDRESS = KExtParamBase + 87
vlxDevConstants.EXT_GATEWAY_ADDRESS = KExtParamBase + 88
vlxDevConstants.EXT_MASK_ADDRESS = KExtParamBase + 89
vlxDevConstants.EXT_POST_HEATER_WINTER_SETPOINT = KExtParamBase + 90
vlxDevConstants.EXT_CYC_MLV_WINTER_SETPOINT = KExtParamBase + 91
vlxDevConstants.EXT_CYC_MLV_SUMMER_SETPOINT = KExtParamBase + 92
vlxDevConstants.EXT_CYC_MLV_SUPPLY_LOWER_LIMIT = KExtParamBase + 93
vlxDevConstants.EXT_BYPASS_LOCKED = KExtParamBase + 94

# // factory settings
KExtParamFactoryBase = 0x20000
vlxDevConstants.EXT_CYC_RESTORE_FACTORY_SETTINGS = KExtParamFactoryBase + 5
vlxDevConstants.EXT_CYC_SAVE_INSTALLATION_SETTINGS = KExtParamFactoryBase + 6
vlxDevConstants.EXT_CYC_RESTORE_INSTALLATION_SETTINGS = KExtParamFactoryBase + 7
vlxDevConstants.EXT_CYC_SAVE_USER_SETTINGS = KExtParamFactoryBase + 8
vlxDevConstants.EXT_CYC_RESTORE_USER_SETTINGS = KExtParamFactoryBase + 9
vlxDevConstants.EXT_CYC_RESTORE_SERVICE_MODE = KExtParamFactoryBase + 10


# // sensors
KExtParamSensorBase = 0x30000
vlxDevConstants.EXT_SEN_ANALOG_SENSOR_INPUT = KExtParamSensorBase + 4372
vlxDevConstants.EXT_SEN_RH_SENSOR_0 = KExtParamSensorBase + 4373
vlxDevConstants.EXT_SEN_RH_SENSOR_1 = KExtParamSensorBase + 4374
vlxDevConstants.EXT_SEN_RH_SENSOR_2 = KExtParamSensorBase + 4375
vlxDevConstants.EXT_SEN_RH_SENSOR_3 = KExtParamSensorBase + 4376
vlxDevConstants.EXT_SEN_RH_SENSOR_4 = KExtParamSensorBase + 4377
vlxDevConstants.EXT_SEN_RH_SENSOR_5 = KExtParamSensorBase + 4378
vlxDevConstants.EXT_SEN_CO2_SENSOR_0 = KExtParamSensorBase + 4379
vlxDevConstants.EXT_SEN_CO2_SENSOR_1 = KExtParamSensorBase + 4380
vlxDevConstants.EXT_SEN_CO2_SENSOR_2 = KExtParamSensorBase + 4381
vlxDevConstants.EXT_SEN_CO2_SENSOR_3 = KExtParamSensorBase + 4382
vlxDevConstants.EXT_SEN_CO2_SENSOR_4 = KExtParamSensorBase + 4383
vlxDevConstants.EXT_SEN_CO2_SENSOR_5 = KExtParamSensorBase + 4384
vlxDevConstants.EXT_SEN_CO2_SENSOR_5 = KExtParamSensorBase + 4385

# Queue types
IoQueue = Constants()
IoQueue.KItemTypeNormal = 0
IoQueue.KItemTypeLog = 1
IoQueue.KItemTypeWeek = 2
IoQueue.KItemTypeFetch = 3

# //access rights array
vlxDevConstants.EXT_SEN_CO2_SENSOR_5 = KExtParamSensorBase + 4385

vlxOffsetKeys = (
    "CYC_NUM_OF_GENERAL_INFO",
    "CYC_NUM_OF_GENERAL_TYP_INFO",
    "CYC_NUM_OF_HW_STATES",
    "CYC_NUM_OF_SW_STATES",
    "CYC_NUM_OF_TIME_ELEMENTS",
    "CYC_NUM_OF_OUTPUTS",
    "CYC_NUM_OF_INPUTS",
    "CYC_NUM_OF_CONFIGS",
    "CYC_NUM_OF_CYC_SETTINGS",
    "CYC_NUM_OF_TYP_SETTINGS",
    "CYC_NUM_OF_SELF_TESTS",
    "CYC_NUM_OF_FAULTS",
    "CYC_NUM_OF_SCHEDULED_EVENTS",
)

vlxOffsetObject = Constants()

sum = 0
for key in vlxOffsetKeys:
    sum = sum + getattr(vlxReadConstants, key)
    setattr(vlxOffsetObject, key, sum + 1)
