# Generated by Django 3.1.4 on 2021-01-15 11:24

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion

from cms.templates.models import (CMS_BLOCK_TYPES,
                                  CMS_PAGE_TEMPLATES,
                                  CMS_TEMPLATE_BLOCK_SECTIONS)

class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='PageTemplate',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('is_active', models.BooleanField()),
                ('name', models.CharField(blank=True, max_length=160, null=True)),
                ('template_file', models.CharField(choices=(lambda: CMS_PAGE_TEMPLATES)(), max_length=1024)),
                ('image', models.ImageField(blank=True, max_length=512, null=True, upload_to='images/page_templates_previews')),
                ('note', models.TextField(blank=True, help_text='Editorial Board Notes, not visible by public.', null=True)),
                ('created_by', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='pagetemplate_created_by', to=settings.AUTH_USER_MODEL)),
                ('modified_by', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='pagetemplate_modified_by', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name_plural': 'Page Templates',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='TemplateBlock',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('is_active', models.BooleanField()),
                ('name', models.CharField(blank=True, help_text='Specify the container section in the template where this block would be rendered.', max_length=60, null=True)),
                ('description', models.TextField(blank=True, help_text='Description of this block', null=True)),
                ('type', models.TextField(choices=(lambda: CMS_BLOCK_TYPES)())),
                ('content', models.TextField(blank=True, help_text='according to the block template schema', null=True)),
                ('image', models.ImageField(blank=True, max_length=512, null=True, upload_to='images/block_templates_previews')),
                ('created_by', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='templateblock_created_by', to=settings.AUTH_USER_MODEL)),
                ('modified_by', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='templateblock_modified_by', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name_plural': 'Template Blocks',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='PageTemplateBlock',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('order', models.IntegerField(blank=True, default=10, null=True)),
                ('is_active', models.BooleanField()),
                ('section', models.CharField(blank=True, choices=(lambda: CMS_TEMPLATE_BLOCK_SECTIONS)(), 
                                             help_text='Specify the container section in the template where this block would be rendered.', 
                                             max_length=33, null=True)),
                ('block', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='cmstemplates.templateblock')),
                ('created_by', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='pagetemplateblock_created_by', to=settings.AUTH_USER_MODEL)),
                ('modified_by', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='pagetemplateblock_modified_by', to=settings.AUTH_USER_MODEL)),
                ('template', models.ForeignKey(limit_choices_to={'is_active': True}, on_delete=django.db.models.deletion.CASCADE, to='cmstemplates.pagetemplate')),
            ],
            options={
                'verbose_name_plural': 'Page Template Blocks',
            },
        ),
    ]
