# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/api/v2/auth/common.proto, envoy/api/v2/auth/secret.proto, envoy/api/v2/auth/tls.proto
# plugin: python-betterproto
import warnings
from dataclasses import dataclass
from datetime import timedelta
from typing import List, Optional

import betterproto


class TlsParametersTlsProtocol(betterproto.Enum):
    TLS_AUTO = 0
    TLSv1_0 = 1
    TLSv1_1 = 2
    TLSv1_2 = 3
    TLSv1_3 = 4


class CertificateValidationContextTrustChainVerification(betterproto.Enum):
    VERIFY_TRUST_CHAIN = 0
    ACCEPT_UNTRUSTED = 1


@dataclass(eq=False, repr=False)
class TlsParameters(betterproto.Message):
    # Minimum TLS protocol version. By default, it's ``TLSv1_2`` for clients and
    # ``TLSv1_0`` for servers.
    tls_minimum_protocol_version: "TlsParametersTlsProtocol" = betterproto.enum_field(1)
    # Maximum TLS protocol version. By default, it's ``TLSv1_2`` for clients and
    # ``TLSv1_3`` for servers.
    tls_maximum_protocol_version: "TlsParametersTlsProtocol" = betterproto.enum_field(2)
    # If specified, the TLS listener will only support the specified `cipher list
    # <https://commondatastorage.googleapis.com/chromium-boringssl-
    # docs/ssl.h.html#Cipher-suite-configuration>`_ when negotiating TLS 1.0-1.2
    # (this setting has no effect when negotiating TLS 1.3). If not specified,
    # the default list will be used. In non-FIPS builds, the default cipher list
    # is: .. code-block:: none   [ECDHE-ECDSA-AES128-GCM-SHA256|ECDHE-ECDSA-
    # CHACHA20-POLY1305]   [ECDHE-RSA-AES128-GCM-SHA256|ECDHE-RSA-
    # CHACHA20-POLY1305]   ECDHE-ECDSA-AES128-SHA   ECDHE-RSA-AES128-SHA
    # AES128-GCM-SHA256   AES128-SHA   ECDHE-ECDSA-AES256-GCM-SHA384   ECDHE-RSA-
    # AES256-GCM-SHA384   ECDHE-ECDSA-AES256-SHA   ECDHE-RSA-AES256-SHA
    # AES256-GCM-SHA384   AES256-SHA In builds using :ref:`BoringSSL FIPS
    # <arch_overview_ssl_fips>`, the default cipher list is: .. code-block:: none
    # ECDHE-ECDSA-AES128-GCM-SHA256   ECDHE-RSA-AES128-GCM-SHA256   ECDHE-ECDSA-
    # AES128-SHA   ECDHE-RSA-AES128-SHA   AES128-GCM-SHA256   AES128-SHA   ECDHE-
    # ECDSA-AES256-GCM-SHA384   ECDHE-RSA-AES256-GCM-SHA384   ECDHE-ECDSA-
    # AES256-SHA   ECDHE-RSA-AES256-SHA   AES256-GCM-SHA384   AES256-SHA
    cipher_suites: List[str] = betterproto.string_field(3)
    # If specified, the TLS connection will only support the specified ECDH
    # curves. If not specified, the default curves will be used. In non-FIPS
    # builds, the default curves are: .. code-block:: none   X25519   P-256 In
    # builds using :ref:`BoringSSL FIPS <arch_overview_ssl_fips>`, the default
    # curve is: .. code-block:: none   P-256
    ecdh_curves: List[str] = betterproto.string_field(4)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class PrivateKeyProvider(betterproto.Message):
    """
    BoringSSL private key method configuration. The private key methods are
    used for external (potentially asynchronous) signing and decryption
    operations. Some use cases for private key methods would be TPM support and
    TLS acceleration.
    """

    # Private key method provider name. The name must match a supported private
    # key method provider type.
    provider_name: str = betterproto.string_field(1)
    config: "betterproto_lib_google_protobuf.Struct" = betterproto.message_field(
        2, group="config_type"
    )
    typed_config: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(
        3, group="config_type"
    )

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.config:
            warnings.warn("PrivateKeyProvider.config is deprecated", DeprecationWarning)


@dataclass(eq=False, repr=False)
class TlsCertificate(betterproto.Message):
    """[#next-free-field: 7]"""

    # The TLS certificate chain.
    certificate_chain: "_core__.DataSource" = betterproto.message_field(1)
    # The TLS private key.
    private_key: "_core__.DataSource" = betterproto.message_field(2)
    # BoringSSL private key method provider. This is an alternative to
    # :ref:`private_key <envoy_api_field_auth.TlsCertificate.private_key>` field.
    # This can't be marked as ``oneof`` due to API compatibility reasons. Setting
    # both :ref:`private_key <envoy_api_field_auth.TlsCertificate.private_key>`
    # and :ref:`private_key_provider
    # <envoy_api_field_auth.TlsCertificate.private_key_provider>` fields will
    # result in an error.
    private_key_provider: "PrivateKeyProvider" = betterproto.message_field(6)
    # The password to decrypt the TLS private key. If this field is not set, it
    # is assumed that the TLS private key is not password encrypted.
    password: "_core__.DataSource" = betterproto.message_field(3)
    # [#not-implemented-hide:]
    ocsp_staple: "_core__.DataSource" = betterproto.message_field(4)
    # [#not-implemented-hide:]
    signed_certificate_timestamp: List[
        "_core__.DataSource"
    ] = betterproto.message_field(5)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class TlsSessionTicketKeys(betterproto.Message):
    # Keys for encrypting and decrypting TLS session tickets. The first key in
    # the array contains the key to encrypt all new sessions created by this
    # context. All keys are candidates for decrypting received tickets. This
    # allows for easy rotation of keys by, for example, putting the new key
    # first, and the previous key second. If :ref:`session_ticket_keys
    # <envoy_api_field_auth.DownstreamTlsContext.session_ticket_keys>` is not
    # specified, the TLS library will still support resuming sessions via
    # tickets, but it will use an internally-generated and managed key, so
    # sessions cannot be resumed across hot restarts or on different hosts. Each
    # key must contain exactly 80 bytes of cryptographically-secure random data.
    # For example, the output of ``openssl rand 80``. .. attention::   Using this
    # feature has serious security considerations and risks. Improper handling of
    # keys   may result in loss of secrecy in connections, even if ciphers
    # supporting perfect forward   secrecy are used. See
    # https://www.imperialviolet.org/2013/06/27/botchingpfs.html for some
    # discussion. To minimize the risk, you must:   * Keep the session ticket
    # keys at least as secure as your TLS certificate private keys   * Rotate
    # session ticket keys at least daily, and preferably hourly   * Always
    # generate keys using a cryptographically-secure random data source
    keys: List["_core__.DataSource"] = betterproto.message_field(1)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class CertificateValidationContext(betterproto.Message):
    """[#next-free-field: 11]"""

    # TLS certificate data containing certificate authority certificates to use
    # in verifying a presented peer certificate (e.g. server certificate for
    # clusters or client certificate for listeners). If not specified and a peer
    # certificate is presented it will not be verified. By default, a client
    # certificate is optional, unless one of the additional options
    # (:ref:`require_client_certificate
    # <envoy_api_field_auth.DownstreamTlsContext.require_client_certificate>`,
    # :ref:`verify_certificate_spki <envoy_api_field_auth.CertificateValidationCo
    # ntext.verify_certificate_spki>`, :ref:`verify_certificate_hash <envoy_api_f
    # ield_auth.CertificateValidationContext.verify_certificate_hash>`, or
    # :ref:`match_subject_alt_names <envoy_api_field_auth.CertificateValidationCo
    # ntext.match_subject_alt_names>`) is also specified. It can optionally
    # contain certificate revocation lists, in which case Envoy will verify that
    # the presented peer certificate has not been revoked by one of the included
    # CRLs. See :ref:`the TLS overview <arch_overview_ssl_enabling_verification>`
    # for a list of common system CA locations.
    trusted_ca: "_core__.DataSource" = betterproto.message_field(1)
    # An optional list of base64-encoded SHA-256 hashes. If specified, Envoy will
    # verify that the SHA-256 of the DER-encoded Subject Public Key Information
    # (SPKI) of the presented certificate matches one of the specified values. A
    # base64-encoded SHA-256 of the Subject Public Key Information (SPKI) of the
    # certificate can be generated with the following command: .. code-block::
    # bash   $ openssl x509 -in path/to/client.crt -noout -pubkey     | openssl
    # pkey -pubin -outform DER     | openssl dgst -sha256 -binary     | openssl
    # enc -base64   NvqYIYSbgK2vCJpQhObf77vv+bQWtc5ek5RIOwPiC9A= This is the
    # format used in HTTP Public Key Pinning. When both:
    # :ref:`verify_certificate_hash <envoy_api_field_auth.CertificateValidationCo
    # ntext.verify_certificate_hash>` and :ref:`verify_certificate_spki <envoy_ap
    # i_field_auth.CertificateValidationContext.verify_certificate_spki>` are
    # specified, a hash matching value from either of the lists will result in
    # the certificate being accepted. .. attention::   This option is preferred
    # over :ref:`verify_certificate_hash   <envoy_api_field_auth.CertificateValid
    # ationContext.verify_certificate_hash>`,   because SPKI is tied to a private
    # key, so it doesn't change when the certificate   is renewed using the same
    # private key.
    verify_certificate_spki: List[str] = betterproto.string_field(3)
    # An optional list of hex-encoded SHA-256 hashes. If specified, Envoy will
    # verify that the SHA-256 of the DER-encoded presented certificate matches
    # one of the specified values. A hex-encoded SHA-256 of the certificate can
    # be generated with the following command: .. code-block:: bash   $ openssl
    # x509 -in path/to/client.crt -outform DER | openssl dgst -sha256 | cut -d" "
    # -f2   df6ff72fe9116521268f6f2dd4966f51df479883fe7037b39f75916ac3049d1a A
    # long hex-encoded and colon-separated SHA-256 (a.k.a. "fingerprint") of the
    # certificate can be generated with the following command: .. code-block::
    # bash   $ openssl x509 -in path/to/client.crt -noout -fingerprint -sha256 |
    # cut -d"=" -f2   DF:6F:F7:2F:E9:11:65:21:26:8F:6F:2D:D4:96:6F:51:DF:47:98:83
    # :FE:70:37:B3:9F:75:91:6A:C3:04:9D:1A Both of those formats are acceptable.
    # When both: :ref:`verify_certificate_hash <envoy_api_field_auth.CertificateV
    # alidationContext.verify_certificate_hash>` and
    # :ref:`verify_certificate_spki <envoy_api_field_auth.CertificateValidationCo
    # ntext.verify_certificate_spki>` are specified, a hash matching value from
    # either of the lists will result in the certificate being accepted.
    verify_certificate_hash: List[str] = betterproto.string_field(2)
    # An optional list of Subject Alternative Names. If specified, Envoy will
    # verify that the Subject Alternative Name of the presented certificate
    # matches one of the specified values. .. attention::   Subject Alternative
    # Names are easily spoofable and verifying only them is insecure,   therefore
    # this option must be used together with :ref:`trusted_ca
    # <envoy_api_field_auth.CertificateValidationContext.trusted_ca>`.
    verify_subject_alt_name: List[str] = betterproto.string_field(4)
    # An optional list of Subject Alternative name matchers. Envoy will verify
    # that the Subject Alternative Name of the presented certificate matches one
    # of the specified matches. When a certificate has wildcard DNS SAN entries,
    # to match a specific client, it should be configured with exact match type
    # in the :ref:`string matcher <envoy_api_msg_type.matcher.StringMatcher>`.
    # For example if the certificate has "\*.example.com" as DNS SAN entry, to
    # allow only "api.example.com", it should be configured as shown below. ..
    # code-block:: yaml  match_subject_alt_names:    exact: "api.example.com" ..
    # attention::   Subject Alternative Names are easily spoofable and verifying
    # only them is insecure,   therefore this option must be used together with
    # :ref:`trusted_ca
    # <envoy_api_field_auth.CertificateValidationContext.trusted_ca>`.
    match_subject_alt_names: List[
        "___type_matcher__.StringMatcher"
    ] = betterproto.message_field(9)
    # [#not-implemented-hide:] Must present a signed time-stamped OCSP response.
    require_ocsp_staple: Optional[bool] = betterproto.message_field(
        5, wraps=betterproto.TYPE_BOOL
    )
    # [#not-implemented-hide:] Must present signed certificate time-stamp.
    require_signed_certificate_timestamp: Optional[bool] = betterproto.message_field(
        6, wraps=betterproto.TYPE_BOOL
    )
    # An optional `certificate revocation list
    # <https://en.wikipedia.org/wiki/Certificate_revocation_list>`_ (in PEM
    # format). If specified, Envoy will verify that the presented peer
    # certificate has not been revoked by this CRL. If this DataSource contains
    # multiple CRLs, all of them will be used.
    crl: "_core__.DataSource" = betterproto.message_field(7)
    # If specified, Envoy will not reject expired certificates.
    allow_expired_certificate: bool = betterproto.bool_field(8)
    # Certificate trust chain verification mode.
    trust_chain_verification: "CertificateValidationContextTrustChainVerification" = (
        betterproto.enum_field(10)
    )

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.verify_subject_alt_name:
            warnings.warn(
                "CertificateValidationContext.verify_subject_alt_name is deprecated",
                DeprecationWarning,
            )


@dataclass(eq=False, repr=False)
class GenericSecret(betterproto.Message):
    # Minimum TLS protocol version. By default, it's ``TLSv1_2`` for clients and
    # ``TLSv1_0`` for servers.
    secret: "_core__.DataSource" = betterproto.message_field(1)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class SdsSecretConfig(betterproto.Message):
    """
    BoringSSL private key method configuration. The private key methods are
    used for external (potentially asynchronous) signing and decryption
    operations. Some use cases for private key methods would be TPM support and
    TLS acceleration.
    """

    # Private key method provider name. The name must match a supported private
    # key method provider type.
    name: str = betterproto.string_field(1)
    sds_config: "_core__.ConfigSource" = betterproto.message_field(2)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class Secret(betterproto.Message):
    """[#next-free-field: 7]"""

    # The TLS certificate chain.
    name: str = betterproto.string_field(1)
    # The TLS private key.
    tls_certificate: "TlsCertificate" = betterproto.message_field(2, group="type")
    # BoringSSL private key method provider. This is an alternative to
    # :ref:`private_key <envoy_api_field_auth.TlsCertificate.private_key>` field.
    # This can't be marked as ``oneof`` due to API compatibility reasons. Setting
    # both :ref:`private_key <envoy_api_field_auth.TlsCertificate.private_key>`
    # and :ref:`private_key_provider
    # <envoy_api_field_auth.TlsCertificate.private_key_provider>` fields will
    # result in an error.
    session_ticket_keys: "TlsSessionTicketKeys" = betterproto.message_field(
        3, group="type"
    )
    # The password to decrypt the TLS private key. If this field is not set, it
    # is assumed that the TLS private key is not password encrypted.
    validation_context: "CertificateValidationContext" = betterproto.message_field(
        4, group="type"
    )
    # [#not-implemented-hide:]
    generic_secret: "GenericSecret" = betterproto.message_field(5, group="type")

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class UpstreamTlsContext(betterproto.Message):
    # Minimum TLS protocol version. By default, it's ``TLSv1_2`` for clients and
    # ``TLSv1_0`` for servers.
    common_tls_context: "CommonTlsContext" = betterproto.message_field(1)
    # Maximum TLS protocol version. By default, it's ``TLSv1_2`` for clients and
    # ``TLSv1_3`` for servers.
    sni: str = betterproto.string_field(2)
    # If specified, the TLS listener will only support the specified `cipher list
    # <https://commondatastorage.googleapis.com/chromium-boringssl-
    # docs/ssl.h.html#Cipher-suite-configuration>`_ when negotiating TLS 1.0-1.2
    # (this setting has no effect when negotiating TLS 1.3). If not specified,
    # the default list will be used. In non-FIPS builds, the default cipher list
    # is: .. code-block:: none   [ECDHE-ECDSA-AES128-GCM-SHA256|ECDHE-ECDSA-
    # CHACHA20-POLY1305]   [ECDHE-RSA-AES128-GCM-SHA256|ECDHE-RSA-
    # CHACHA20-POLY1305]   ECDHE-ECDSA-AES128-SHA   ECDHE-RSA-AES128-SHA
    # AES128-GCM-SHA256   AES128-SHA   ECDHE-ECDSA-AES256-GCM-SHA384   ECDHE-RSA-
    # AES256-GCM-SHA384   ECDHE-ECDSA-AES256-SHA   ECDHE-RSA-AES256-SHA
    # AES256-GCM-SHA384   AES256-SHA In builds using :ref:`BoringSSL FIPS
    # <arch_overview_ssl_fips>`, the default cipher list is: .. code-block:: none
    # ECDHE-ECDSA-AES128-GCM-SHA256   ECDHE-RSA-AES128-GCM-SHA256   ECDHE-ECDSA-
    # AES128-SHA   ECDHE-RSA-AES128-SHA   AES128-GCM-SHA256   AES128-SHA   ECDHE-
    # ECDSA-AES256-GCM-SHA384   ECDHE-RSA-AES256-GCM-SHA384   ECDHE-ECDSA-
    # AES256-SHA   ECDHE-RSA-AES256-SHA   AES256-GCM-SHA384   AES256-SHA
    allow_renegotiation: bool = betterproto.bool_field(3)
    # If specified, the TLS connection will only support the specified ECDH
    # curves. If not specified, the default curves will be used. In non-FIPS
    # builds, the default curves are: .. code-block:: none   X25519   P-256 In
    # builds using :ref:`BoringSSL FIPS <arch_overview_ssl_fips>`, the default
    # curve is: .. code-block:: none   P-256
    max_session_keys: Optional[int] = betterproto.message_field(
        4, wraps=betterproto.TYPE_UINT32
    )

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class DownstreamTlsContext(betterproto.Message):
    """
    BoringSSL private key method configuration. The private key methods are
    used for external (potentially asynchronous) signing and decryption
    operations. Some use cases for private key methods would be TPM support and
    TLS acceleration.
    """

    # Private key method provider name. The name must match a supported private
    # key method provider type.
    common_tls_context: "CommonTlsContext" = betterproto.message_field(1)
    require_client_certificate: Optional[bool] = betterproto.message_field(
        2, wraps=betterproto.TYPE_BOOL
    )
    require_sni: Optional[bool] = betterproto.message_field(
        3, wraps=betterproto.TYPE_BOOL
    )
    session_ticket_keys: "TlsSessionTicketKeys" = betterproto.message_field(
        4, group="session_ticket_keys_type"
    )
    session_ticket_keys_sds_secret_config: "SdsSecretConfig" = (
        betterproto.message_field(5, group="session_ticket_keys_type")
    )
    disable_stateless_session_resumption: bool = betterproto.bool_field(
        7, group="session_ticket_keys_type"
    )
    session_timeout: timedelta = betterproto.message_field(6)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class CommonTlsContext(betterproto.Message):
    """[#next-free-field: 7]"""

    # The TLS certificate chain.
    tls_params: "TlsParameters" = betterproto.message_field(1)
    # The TLS private key.
    tls_certificates: List["TlsCertificate"] = betterproto.message_field(2)
    # BoringSSL private key method provider. This is an alternative to
    # :ref:`private_key <envoy_api_field_auth.TlsCertificate.private_key>` field.
    # This can't be marked as ``oneof`` due to API compatibility reasons. Setting
    # both :ref:`private_key <envoy_api_field_auth.TlsCertificate.private_key>`
    # and :ref:`private_key_provider
    # <envoy_api_field_auth.TlsCertificate.private_key_provider>` fields will
    # result in an error.
    tls_certificate_sds_secret_configs: List[
        "SdsSecretConfig"
    ] = betterproto.message_field(6)
    # The password to decrypt the TLS private key. If this field is not set, it
    # is assumed that the TLS private key is not password encrypted.
    validation_context: "CertificateValidationContext" = betterproto.message_field(
        3, group="validation_context_type"
    )
    # [#not-implemented-hide:]
    validation_context_sds_secret_config: "SdsSecretConfig" = betterproto.message_field(
        7, group="validation_context_type"
    )
    # [#not-implemented-hide:]
    combined_validation_context: "CommonTlsContextCombinedCertificateValidationContext" = betterproto.message_field(
        8, group="validation_context_type"
    )
    alpn_protocols: List[str] = betterproto.string_field(4)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class CommonTlsContextCombinedCertificateValidationContext(betterproto.Message):
    default_validation_context: "CertificateValidationContext" = (
        betterproto.message_field(1)
    )
    validation_context_sds_secret_config: "SdsSecretConfig" = betterproto.message_field(
        2
    )

    def __post_init__(self) -> None:
        super().__post_init__()


from .. import core as _core__
from ....type import matcher as ___type_matcher__
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf
