# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pyphysim',
 'pyphysim.c_extensions',
 'pyphysim.cell',
 'pyphysim.channel_estimation',
 'pyphysim.channels',
 'pyphysim.comm',
 'pyphysim.extra',
 'pyphysim.extra.MATLAB',
 'pyphysim.ia',
 'pyphysim.mimo',
 'pyphysim.modulators',
 'pyphysim.pointprocess',
 'pyphysim.progressbar',
 'pyphysim.reference_signals',
 'pyphysim.simulations',
 'pyphysim.subspace',
 'pyphysim.util']

package_data = \
{'': ['*']}

install_requires = \
['configobj', 'matplotlib', 'numba', 'numpy', 'scipy']

setup_kwargs = {
    'name': 'pyphysim',
    'version': '0.5',
    'description': 'Simulation of digital communication (physical layer) in python',
    'long_description': '![Testing](https://travis-ci.org/darcamo/pyphysim.svg?branch=master)\n[![Coverage Status](https://coveralls.io/repos/github/darcamo/pyphysim/badge.svg?branch=master)](https://coveralls.io/github/darcamo/pyphysim?branch=master)\n[![Documentation Status](https://readthedocs.org/projects/pyphysim/badge/?version=latest)](http://pyphysim.readthedocs.io/en/latest/?badge=latest)\n[![pre-commit](https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&logoColor=white)](https://github.com/pre-commit/pre-commit)\n\nPyPhysim\n========\n\nSimulation of Digital Communication (physical layer) in Python.\n\nThis includes classes related to digital modulation (M-QAM, M-PSK, etc), AWGN\nchannel, Rayleigh and tapped delay line channel models, channel estimation,\nMIMO, OFDM, etc.. It also includes classes related to multiuser transmission,\nsuch as block diagonalization, interference alignment, etc., as well as classes\nrepresenting access nodes and users for easily creating physical layer\nsimulations.\n\nFurthermore, a framework for implementing Monte Carlo simulations is also\nimplemented (see the pyphysim.simulations package) to help with creating\nsimulators that run many independent realizations and average the results.\n\n\nInstallation\n------------\n\nPyphysim is available in [Pypi](https://pypi.org/project/pyphysim/) and can be\ninstalled with pip or similar tools. If you want to install from the git\nrepository, then install [poetry](https://python-poetry.org/) first, clone the\nrepository, and run the command `poetry install` from the cloned folder to\ninstall pyphysim and its dependencies in a virtual environment (created by\npoetry). After that, just use `poetry shell` to activate the environment and you\nshould be able to import pyphysim from python started in that shell.\n\n\nExamples\n========\n\nThere are a few notebooks in the\n[notebooks](https://github.com/darcamo/pyphysim/tree/master/notebooks) folder in\nthe GitHub repository. A list of some of the notebooks with a small description\nis shown below for quick access.\n\n- [Transmission_with_AWGN_channel.ipynb](https://github.com/darcamo/pyphysim/blob/master/notebooks/Transmission_with_AWGN_channel.ipynb):\n  Illustrates the use of digital modulation to transmit through an AWGN channel\n  and the usage of classes that help creating Monte Carlo simulations\n- [Transmission_with_Rayleigh_and_AWGN_channels.ipynb](https://github.com/darcamo/pyphysim/blob/master/notebooks/Transmission_with_Rayleigh_and_AWGN_channels.ipynb): Extends the previous notebook to transmission through a Rayleigh channel and discuss running simulation\n- [TDL_and_OFDM.ipynb](https://github.com/darcamo/pyphysim/blob/master/notebooks/TDL_and_OFDM.ipynb): Simulation of transmission through a frequency selective channel that varies in time using OFDM\n- [PathLoss classes.ipynb](https://github.com/darcamo/pyphysim/blob/master/notebooks/PathLoss_classes.ipynb): Illustrate some path loss classes\n- [Alamouti.ipynb](https://github.com/darcamo/pyphysim/blob/master/notebooks/Alamouti.ipynb): Illustrates how to simulate using multiple antennas and how to use configuration files\n',
    'author': 'Darlan Cavalcante Moreira',
    'author_email': 'darcamo@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/darcamo/pyphysim',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
