# -*- coding: utf-8 -*-

sd_doc_data = '''
####################################################################################################
# ДОКУМЕНТАЦИЯ ПО ФОРМАТУ .sd, ПРЕДНАЗНАЧЕННОМУ ДЛЯ ХРАНЕНИЯ СЛУЖЕБНЫХ И КОНФИГУРАЦИОННЫХ ДАННЫХ
####################################################################################################
#
# Основные концепции и возможности, заложенные при разработке формата:
#    Максимальная доступность для восприятия сложных по структуре данных
#    Простые и интуитивно понятные синтаксические правила
#    Возможность однострочной записи простых словарей и списков
#    Возможность многострочной записи многомерных словарей
#    Возможность многострочной записи строкового значения
#    Возможность многострочной записи длинных списков
#    Возможность работы с комментариями к данным и файлу
# --------------------------------------------------------------------------------------------------
# Правила для записи содержимого файла формата .sd:
#    В рамках правил, удобство для восприятия данных и их структуры определяет выбор вида записи
#    Текстовые комментарии и описания записываются после знака решётки
#    Комментарии, записанные над строкой или в строке с ключом первого уровня, принадлежат ключам
#    Для комментария, записанного в строке с ключом, рекомендуется четырёх пробельный отступ
#    Для многострочной записи словарей доступны только комментарии, записанные в строках с ключами
#    Имена ключей записываются с использованием латинских букв, цифр и знака подчёркивания
#    Имена ключей начинаются с буквы или с нижнего подчёркивания и не содержат пробелов
#    После записи ключей первого уровня ставится знак равенства
#    При однострочной записи словаря, перед и после знака равенства ставится пробел
#    При многострочной записи словаря, пробел ставится перед знаком равенства
#    После двоеточия и запятой необходим пробел
#    Для записи словарей с более чем одним уровнем вложенности используется многострочная запись
#    Для многострочной записи значение вложенного словаря записывается в строке под ключом
#    При многострочной записи словарей, перед именами ключей необходимы точки
#    Количество точек перед именами вложенных ключей определяется глубиной их вложенности
#    Не многострочные значения без вложенного словаря записываются на одной строке с ключом
#    При записи элементов списка между их значениями необходима запятая
#    При однострочной записи словаря, для каждого ключа возможна запись одного строкового значения
#    Рекомендуемая длина каждого значения списка не должна превышать 50 символов
#    Значения, превышающие 50 символов, оптимально должны быть единственными, либо последними
#    Для списков длинной более 100 знаков, нужно использовать многострочную запись
#    Для списков имеющих вложенный список, нужно использовать многострочную запись
#    В списках возможен только один уровень вложенности списков
#    Для многострочной записи списков необходимы обрамляющие строки с тройными дефисами
#    При многострочной записи списков, запятая после каждого значения не ставится
#    Рекомендуемое количество знаков всех элементов списка для каждого ключа составляет 100 знаков
#    Для однострочной записи, после знака равно рекомендуется суммарная запись не более 100 символов
#    Значения, в которых есть пробелы или запятые, необходимо заключить в тройные кавычки
#    Значения, заканчивающиеся двоеточием, необходимо заключить в тройные кавычки
#    Значения в тройных кавычках рекомендуется делать либо единственными, либо последними
#    Только для ключа первого уровня возможна многострочная запись единственного значения
#    Для многострочной записи одного значения необходимы обрамляющие строки с тройными кавычками
#    Перед надстрочным комментарием и после многострочной записи добавляются пустые строки
#
####################################################################################################


# Пример записи данных в формате .sd (An example of writing data in the .sd format):
main_key_0 =    # comment for multiline list
---
large_lists_of_values are written in the column
each_value_of_an_element_in_the_list_must_be_preceded_by
lists_recorded_with_more_than_a_ hundred_characters_should_be_recorded_in_multiline_format
value_1, value_2, value_3
---

# some comment for main_key_1
main_key_1 =
.key_1:
..key_1_1:  """String with spaces. Possibly other type of quotes."""    # some comment for key_1_1
..key_1_2:
...key_1_2_1: lue_without_spaces
...key_1_2_2:  """triple quoted values can contain characters such as space or comma"""
.key_2: value_2_1, """last list element"""
.key_3: a_good_solution_is_to_place_an_element_value_greater_than_50_characters_as_the_only_one

main_key_2 = some_value_will_be_read_as_a_string    # comment for the main_key_2
main_key_3 = value_3_1, value_3_2, the_long_element_value_over_50_characters_is_placed_last
main_key_4 = key_4_1: v_4_1_1, key_4_2: in_a_one_line_notation_each_key_has_only_one_str_value
main_key_5 = key_5_1: v_5_1_1, key_5_2: v_5_2_1, key_5_3: """should be used no more than 3 pair"""
''' + \
"""
# temporary comment
main_key_6 =    # comment for the main_key_6
'''
Multi-line write of value,
for main_key_6.
'''""" + \
'''

_main_key_7 = """I'm glad to your attention. If bugs are found, write: bug_report@daliton.org"""


####################################################################################################
# Для декодирования данных хранящихся в формате .sd необходимо передать адрес файла с данными:
#    from sd_format import sd
#    sd_obj = sd(sd_file_path)
#    my_dict = sd_obj.decoding_result
#
# После декодирования данные преобразуются в Python dict:
#     dict = {
#         'keys_comments': {
#             'own_comments': ['Title of .sd file', 'Top description', 'Bottom description'],
#             '_main_key_0': {'own_comments': 
#                 ['Пример записи данных в формате .sd (An example of writing data in the .sd format):', 
#                 'comment for multiline list']
#             },
#             'main_key_1 ': {
#                 'key_1': {
#                     'own_comments': ['', ''],
#                     'key_1_1': {'own_comments': ['', 'some comment for key_1_1']},
#                     'key_1_2': {
#                         'own_comments': ['', ''],
#                         'key_1_2_1': {'own_comments': ['', '']},
#                         'key_1_2_2': {'own_comments': ['', '']}
#                     }
#                 },
#                 'key_2': {'own_comments': ['', '']},
#                 'key_3': {'own_comments': ['', '']}, 
#                 'own_comments': ['some comment for main_key_1', '']
#             },
#             'main_key_2 ': {'own_comments': ['', 'comment for the main_key_2']},
#             'main_key_3 ': {'own_comments': ['', '']},
#             'main_key_4 ': {'own_comments': ['', '']},
#             'main_key_5 ': {'own_comments': ['', '']},
#             'main_key_6 ': {'own_comments': ['temporary comment', 'comment for the main_key_6']},
#             '_main_key_7 ': {'own_comments': ['', '']}
#         },
#         '_main_key_0': 
#             ['large lists of values are written in the column', 
#             'each_value_of_an_element_in_the_list_must_be_preceded_by', 
#             'lists_recorded_with_more_than_a_hundred_characters_should_be_recorded_in_multiline_format', 
#             ['value_1', 'value_2', 'value_3']],
#         'main_key_1 ': {
#             'key_1': {
#                 'key_1_1': 'String with spaces. Possibly other type of quotes.',
#                 'key_1_2': {
#                     'key_1_2_1': 'lue_without_spaces',
#                     'key_1_2_2': 'triple quoted values can contain characters such as space or comma'
#                 }
#             },
#             'key_2': ['value_2_1', 'last list element'],
#             'key_3': 'a_good_solution_is_to_place_an_element_value_greater_than_50_characters_as_the_only_one'
#         },
#         'main_key_2 ': 'some_value_will_be_read_as_a_string',
#         'main_key_3 ': ['value_3_1', 'value_3_2', 'the_long_element_value_over_50_characters_is_placed_last'],
#         'main_key_4 ': {'key_4_1': 'v_4_1_1', 'key_4_2': 'in_a_one_line_notation_each_key_has_only_one_str_value'},
#         'main_key_5 ': {'key_5_1': 'v_5_1_1', 'key_5_2': 'v_5_2_1', 'key_5_3': 'should be used no more than 3 pair'},
#         'main_key_6 ': 'Multi-line write of value, \\nfor main_key_6.',
#         '_main_key_7 ': "I'm glad to your attention. If bugs are found, write: bug_report@daliton.org"
#     }
#
# Если Python словарь нужно сохранить в файл в формате .sd, в качестве параметров необходимо
# передать адрес по которому нужно сохранить файл, а также сам словарь:
#    sd(sd_file_path, my_dict)
#
#
####################################################################################################
'''


def documentation_output_about_sd_format():
    print()
    print(sd_doc_data)
    print()
    return sd_doc_data


sd_documentation_output = documentation_output_about_sd_format
sd_info = documentation_output_about_sd_format
