# StructureBoost

StructureBoost is a package to do Gradient Boosting in a manner that exploits the **structure** of categorical variables.

Have you ever used "US state" as a variable in a prediction problem and thought "Why can't my algorithm use the geography of the states to make better predictions?"

Or you've used the month of the year as a predictor, but noticed that January should border December the same way that June borders July. (or hour of the day, or day of the week)

StructureBoost can help.  Read the documentation and references below.  Or dive into some [examples](https://github.com/numeristical/structureboost/tree/master/examples)

## Video Lectures

There are some explanatory videos on the [Numeristical Youtube Channel](https://www.youtube.com/channel/UCfsbASar8nsLs4NbhQwuaVg)


## Documentation
[Read the Docs](https://structureboost.readthedocs.io/)

## References:

Lucena, B. "Exploiting Categorical Structure with Tree-Based Methods. Proceedings of the Twenty Third International Conference on Artificial Intelligence and Statistics, PMLR 108:2949-2958, 2020. [http://proceedings.mlr.press/v108/lucena20a/lucena20a.pdf](http://proceedings.mlr.press/v108/lucena20a/lucena20a.pdf)

Lucena, B. "StructureBoost: Efficient Gradient Boosting for Structured Categorical Variables." [https://arxiv.org/abs/2007.04446](https://arxiv.org/abs/2007.04446)
