/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io.hdf5;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.sysds.runtime.io.hdf5.H5BufferBuilder;
import org.apache.sysds.runtime.io.hdf5.H5RootObject;
import org.apache.sysds.runtime.io.hdf5.H5RuntimeException;
import org.apache.sysds.runtime.io.hdf5.Utils;

public class H5LocalHeap {
    private static final byte[] HEAP_SIGNATURE = "HEAP".getBytes(StandardCharsets.US_ASCII);
    private final long dataSegmentSize;
    private final long offsetToHeadOfFreeList;
    private final long addressOfDataSegment;
    private final ByteBuffer dataBuffer;
    private final H5RootObject rootObject;

    public H5LocalHeap(H5RootObject rootObject, long address) {
        try {
            this.rootObject = rootObject;
            int sizeOfLength = rootObject.getSuperblock().sizeOfLengths;
            int sizeOfOffset = rootObject.getSuperblock().sizeOfOffsets;
            int headerSize = 8 + sizeOfLength + sizeOfLength + sizeOfOffset;
            ByteBuffer header = rootObject.readBufferFromAddress(address, headerSize);
            byte[] formatSignatureBytes = new byte[4];
            header.get(formatSignatureBytes, 0, formatSignatureBytes.length);
            if (!Arrays.equals(HEAP_SIGNATURE, formatSignatureBytes)) {
                throw new H5RuntimeException("Heap signature not matched");
            }
            rootObject.setLocalHeapVersion(header.get());
            header.position(8);
            this.dataSegmentSize = Utils.readBytesAsUnsignedLong(header, sizeOfLength);
            this.offsetToHeadOfFreeList = Utils.readBytesAsUnsignedLong(header, sizeOfLength);
            this.addressOfDataSegment = Utils.readBytesAsUnsignedLong(header, sizeOfOffset);
            this.dataBuffer = rootObject.readBufferFromAddress(this.addressOfDataSegment, (int)this.dataSegmentSize);
        }
        catch (Exception e) {
            throw new H5RuntimeException("Error reading local heap", e);
        }
    }

    public H5LocalHeap(H5RootObject rootObject, String childName, long dataSegmentSize, long offsetToHeadOfFreeList, long addressOfDataSegment) {
        this.rootObject = rootObject;
        this.dataSegmentSize = dataSegmentSize;
        int blockCount = (int)((float)childName.length() / 8.0f + 1.0f) + 1;
        this.offsetToHeadOfFreeList = (long)blockCount * 8L;
        this.addressOfDataSegment = addressOfDataSegment;
        byte[] childName_atBytes = childName.getBytes(StandardCharsets.US_ASCII);
        this.dataBuffer = ByteBuffer.allocate((int)this.dataSegmentSize);
        this.dataBuffer.position(8);
        this.dataBuffer.put(childName_atBytes);
        this.dataBuffer.put((byte)0);
        this.dataBuffer.position(blockCount * 8 - 1);
        this.dataBuffer.putShort((short)1);
        this.dataBuffer.position((int)(this.offsetToHeadOfFreeList + 8L - 1L));
        this.dataBuffer.putShort((short)(this.dataSegmentSize - this.offsetToHeadOfFreeList));
    }

    public void toBuffer(H5BufferBuilder bb) {
        bb.writeBytes(HEAP_SIGNATURE);
        bb.writeByte(this.rootObject.localHeapVersion);
        bb.writeBytes(new byte[3]);
        bb.writeLong(this.dataSegmentSize);
        bb.writeLong(this.offsetToHeadOfFreeList);
        bb.writeLong(this.addressOfDataSegment);
        bb.writeBytes(this.dataBuffer.array());
    }

    public short getVersion() {
        return this.rootObject.localHeapVersion;
    }

    public long getDataSegmentSize() {
        return this.dataSegmentSize;
    }

    public long getOffsetToHeadOfFreeList() {
        return this.offsetToHeadOfFreeList;
    }

    public long getAddressOfDataSegment() {
        return this.addressOfDataSegment;
    }

    public ByteBuffer getDataBuffer() {
        return this.dataBuffer;
    }
}

