/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.lib;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.compress.CompressedMatrixBlockFactory;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.ColGroupEmpty;
import org.apache.sysds.runtime.compress.lib.CLALibUtils;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class CLALibAppend {
    private static final Log LOG = LogFactory.getLog((String)CLALibAppend.class.getName());

    public static MatrixBlock append(MatrixBlock left, MatrixBlock right, int k) {
        int m = left.getNumRows();
        int n = left.getNumColumns() + right.getNumColumns();
        if (left.isEmpty() && right instanceof CompressedMatrixBlock) {
            return CLALibAppend.appendLeftEmpty(left, (CompressedMatrixBlock)right, m, n);
        }
        if (right.isEmpty() && left instanceof CompressedMatrixBlock) {
            return CLALibAppend.appendRightEmpty((CompressedMatrixBlock)left, right, m, n);
        }
        if (!(left instanceof CompressedMatrixBlock)) {
            LOG.info((Object)"Trying to compress left side of append");
            left = (MatrixBlock)CompressedMatrixBlockFactory.compress(left, k).getLeft();
        }
        if (!(right instanceof CompressedMatrixBlock)) {
            LOG.info((Object)"Trying to compress right side of append");
            right = (MatrixBlock)CompressedMatrixBlockFactory.compress(right, k).getLeft();
        }
        if (!(left instanceof CompressedMatrixBlock) || !(right instanceof CompressedMatrixBlock)) {
            return CLALibAppend.uc(left).append(CLALibAppend.uc(right), null);
        }
        CompressedMatrixBlock leftC = (CompressedMatrixBlock)left;
        CompressedMatrixBlock rightC = (CompressedMatrixBlock)right;
        CompressedMatrixBlock ret = new CompressedMatrixBlock(m, n);
        ret = CLALibAppend.appendColGroups(ret, leftC.getColGroups(), rightC.getColGroups(), leftC.getNumColumns());
        double compressedSize = ret.getInMemorySize();
        double uncompressedSize = MatrixBlock.estimateSizeInMemory(m, n, ret.getSparsity());
        double ratio = uncompressedSize / compressedSize;
        if (compressedSize < uncompressedSize) {
            return ret;
        }
        String message = String.format("Decompressing c bind matrix because it had to small compression ratio: %2.3f", ratio);
        return ret.getUncompressed(message);
    }

    private static MatrixBlock appendRightEmpty(CompressedMatrixBlock left, MatrixBlock right, int m, int n) {
        CompressedMatrixBlock ret = new CompressedMatrixBlock(m, n);
        ArrayList<AColGroup> newGroup = new ArrayList<AColGroup>(1);
        newGroup.add(ColGroupEmpty.generate(right.getNumColumns()));
        ret = CLALibAppend.appendColGroups(ret, left.getColGroups(), newGroup, left.getNumColumns());
        return ret;
    }

    private static MatrixBlock appendLeftEmpty(MatrixBlock left, CompressedMatrixBlock right, int m, int n) {
        CompressedMatrixBlock ret = new CompressedMatrixBlock(m, n);
        ArrayList<AColGroup> newGroup = new ArrayList<AColGroup>(1);
        newGroup.add(ColGroupEmpty.generate(left.getNumColumns()));
        ret = CLALibAppend.appendColGroups(ret, newGroup, right.getColGroups(), left.getNumColumns());
        return ret;
    }

    private static CompressedMatrixBlock appendColGroups(CompressedMatrixBlock ret, List<AColGroup> left, List<AColGroup> right, int leftNumCols) {
        AColGroup tmp;
        ret.allocateColGroupList(new ArrayList<AColGroup>(left.size() + right.size()));
        int nRows = ret.getNumRows();
        long nnz = 0L;
        for (AColGroup group : left) {
            tmp = group.copy();
            ret.getColGroups().add(tmp);
            nnz += group.getNumberNonZeros(nRows);
        }
        for (AColGroup group : right) {
            tmp = group.copy();
            tmp.shiftColIndices(leftNumCols);
            ret.getColGroups().add(tmp);
            nnz += group.getNumberNonZeros(nRows);
        }
        ret.setNonZeros(nnz);
        CLALibUtils.combineConstColumns(ret);
        return ret;
    }

    private static MatrixBlock uc(MatrixBlock mb) {
        return CompressedMatrixBlock.getUncompressed(mb);
    }
}

