/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.jetty.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.spark_project.jetty.client.api.Connection;
import org.spark_project.jetty.client.api.Destination;
import org.spark_project.jetty.util.BlockingArrayQueue;
import org.spark_project.jetty.util.Promise;
import org.spark_project.jetty.util.component.ContainerLifeCycle;
import org.spark_project.jetty.util.component.Dumpable;
import org.spark_project.jetty.util.log.Log;
import org.spark_project.jetty.util.log.Logger;
import org.spark_project.jetty.util.thread.Sweeper;

public class ConnectionPool
implements Closeable,
Dumpable,
Sweeper.Sweepable {
    protected static final Logger LOG = Log.getLogger(ConnectionPool.class);
    private final AtomicInteger connectionCount = new AtomicInteger();
    private final ReentrantLock lock = new ReentrantLock();
    private final Destination destination;
    private final int maxConnections;
    private final Promise<Connection> requester;
    private final BlockingDeque<Connection> idleConnections;
    private final BlockingQueue<Connection> activeConnections;

    public ConnectionPool(Destination destination, int maxConnections, Promise<Connection> requester) {
        this.destination = destination;
        this.maxConnections = maxConnections;
        this.requester = requester;
        this.idleConnections = new LinkedBlockingDeque<Connection>(maxConnections);
        this.activeConnections = new BlockingArrayQueue<Connection>(maxConnections);
    }

    public int getConnectionCount() {
        return this.connectionCount.get();
    }

    public BlockingQueue<Connection> getIdleConnections() {
        return this.idleConnections;
    }

    public BlockingQueue<Connection> getActiveConnections() {
        return this.activeConnections;
    }

    public Connection acquire() {
        Connection connection = this.activateIdle();
        if (connection == null) {
            connection = this.tryCreate();
        }
        return connection;
    }

    private Connection tryCreate() {
        int next2;
        int current;
        do {
            if ((next2 = (current = this.getConnectionCount()) + 1) <= this.maxConnections) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Max connections {}/{} reached", current, this.maxConnections);
            }
            return this.activateIdle();
        } while (!this.connectionCount.compareAndSet(current, next2));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Connection {}/{} creation", next2, this.maxConnections);
        }
        this.destination.newConnection(new Promise<Connection>(){

            @Override
            public void succeeded(Connection connection) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Connection {}/{} creation succeeded {}", next2, ConnectionPool.this.maxConnections, connection);
                }
                ConnectionPool.this.idleCreated(connection);
                ConnectionPool.this.requester.succeeded(connection);
            }

            @Override
            public void failed(Throwable x) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Connection " + next2 + "/" + ConnectionPool.this.maxConnections + " creation failed", x);
                }
                ConnectionPool.this.connectionCount.decrementAndGet();
                ConnectionPool.this.requester.failed(x);
            }
        });
        return this.activateIdle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void idleCreated(Connection connection) {
        boolean idle;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            idle = this.idleConnections.offerLast(connection);
        }
        finally {
            lock.unlock();
        }
        this.idle(connection, idle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection activateIdle() {
        boolean acquired;
        Connection connection;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            connection = (Connection)this.idleConnections.pollFirst();
            if (connection == null) {
                Connection connection2 = null;
                return connection2;
            }
            acquired = this.activeConnections.offer(connection);
        }
        finally {
            lock.unlock();
        }
        if (acquired) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Connection active {}", connection);
            }
            this.acquired(connection);
            return connection;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Connection active overflow {}", connection);
        }
        connection.close();
        return null;
    }

    protected void acquired(Connection connection) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean release(Connection connection) {
        boolean idle;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (!this.activeConnections.remove(connection)) {
                boolean bl = false;
                return bl;
            }
            idle = this.idleConnections.offerFirst(connection);
        }
        finally {
            lock.unlock();
        }
        this.released(connection);
        return this.idle(connection, idle);
    }

    protected boolean idle(Connection connection, boolean idle) {
        if (idle) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Connection idle {}", connection);
            }
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Connection idle overflow {}", connection);
        }
        connection.close();
        return false;
    }

    protected void released(Connection connection) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Connection connection) {
        boolean removed;
        boolean idleRemoved;
        boolean activeRemoved;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            activeRemoved = this.activeConnections.remove(connection);
            idleRemoved = this.idleConnections.remove(connection);
        }
        finally {
            lock.unlock();
        }
        if (activeRemoved) {
            this.released(connection);
        }
        boolean bl = removed = activeRemoved || idleRemoved;
        if (removed) {
            int pooled = this.connectionCount.decrementAndGet();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Connection removed {} - pooled: {}", connection, pooled);
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive(Connection connection) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            boolean bl = this.activeConnections.contains(connection);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIdle(Connection connection) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            boolean bl = this.idleConnections.contains(connection);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public boolean isEmpty() {
        return this.connectionCount.get() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ArrayList<Connection> idles = new ArrayList<Connection>();
        ArrayList<Connection> actives = new ArrayList<Connection>();
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            idles.addAll(this.idleConnections);
            this.idleConnections.clear();
            actives.addAll(this.activeConnections);
            this.activeConnections.clear();
        }
        finally {
            lock.unlock();
        }
        this.connectionCount.set(0);
        for (Connection connection : idles) {
            connection.close();
        }
        for (Connection connection : actives) {
            connection.close();
        }
    }

    @Override
    public String dump() {
        return ContainerLifeCycle.dump(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(Appendable out, String indent) throws IOException {
        ArrayList<Connection> actives = new ArrayList<Connection>();
        ArrayList<Connection> idles = new ArrayList<Connection>();
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            actives.addAll(this.activeConnections);
            idles.addAll(this.idleConnections);
        }
        finally {
            lock.unlock();
        }
        ContainerLifeCycle.dumpObject(out, this);
        ContainerLifeCycle.dump(out, indent, actives, idles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sweep() {
        ArrayList<Sweeper.Sweepable> toSweep = new ArrayList<Sweeper.Sweepable>();
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            for (Connection connection : this.getActiveConnections()) {
                if (!(connection instanceof Sweeper.Sweepable)) continue;
                toSweep.add((Sweeper.Sweepable)((Object)connection));
            }
        }
        finally {
            lock.unlock();
        }
        for (Sweeper.Sweepable candidate : toSweep) {
            if (!candidate.sweep()) continue;
            boolean removed = this.getActiveConnections().remove(candidate);
            LOG.warn("Connection swept: {}{}{} from active connections{}{}", candidate, System.lineSeparator(), removed ? "Removed" : "Not removed", System.lineSeparator(), this.dump());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        int idleSize;
        int activeSize;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            activeSize = this.activeConnections.size();
            idleSize = this.idleConnections.size();
        }
        finally {
            lock.unlock();
        }
        return String.format("%s[c=%d/%d,a=%d,i=%d]", this.getClass().getSimpleName(), this.connectionCount.get(), this.maxConnections, activeSize, idleSize);
    }
}

