# Code Coverage

The code coverage information generated by azure pipeline is uploaded to `codecov.io`.
You can see more information here: https://docs.codecov.io/docs/about-code-coverage

## What is it?

From their website: "Codecov provides highly integrated tools to group, merge, archive, and compare coverage reports."

## How does it manage tokens?

This should be automatic and detect that it is running the azure pipeline for the repo.
A token can be manually generated by anyone that has write access by going here: https://codecov.io/gh/tianocore/edk2-basetools/settings
This token is only used to upload reports and cannot be used for any administrative tasks.

## Who has access to it?

Everyone can access the reports.
Administrative functions are gated off of github access.
So members with write access can change some settings and team member can change more global settings.

## Does codecov.io handle PR (incoming noise) vs CI (baseline)

Yes.
It automatically infers the branch is being run.

## It commented on my PR?

Yes. It does that.

## Where is the policy about what is a PR failure?

See `codecov.yaml` and this documentation: https://docs.codecov.io/docs/codecov-yaml#section-team-yaml
But it currently defines no policy.

## I use this repo as a template for my Azure Pipelines, do I get code coverage?

Good news!
You can just pass in a parameter and it will turn on (it is off by default).

Here's an example:
```yaml
- template: templates/build-test-job.yml
  parameters:
    vm_image: 'windows-latest'
    pypi_auth_feed: 'Pypi-edk2-basetools'
    root_package_folder: "edk2basetools"
    name: 'windows'
    codecov_enabled: true
```

Notice that last one? `codecov_enabled: true`
That's what you need to add.
