[![PyPi](https://img.shields.io/pypi/v/tinyscript.svg)](https://pypi.python.org/pypi/tinyscript/)
[![Read The Docs](https://readthedocs.org/projects/python-tinyscript/badge/?version=latest)](https://python-tinyscript.readthedocs.io/en/latest/?badge=latest)
[![Build Status](https://travis-ci.org/dhondta/python-tinyscript.svg?branch=master)](https://travis-ci.org/dhondta/python-tinyscript)
[![Coverage Status](https://coveralls.io/repos/github/dhondta/python-tinyscript/badge.svg?branch=master)](https://coveralls.io/github/dhondta/python-tinyscript?branch=master)
[![Python Versions](https://img.shields.io/pypi/pyversions/tinyscript.svg)](https://pypi.python.org/pypi/tinyscript/)
[![Requirements Status](https://requires.io/github/dhondta/python-tinyscript/requirements.svg?branch=master)](https://requires.io/github/dhondta/python-tinyscript/requirements/?branch=master)
[![Known Vulnerabilities](https://snyk.io/test/github/dhondta/python-tinyscript/badge.svg?targetFile=requirements.txt)](https://snyk.io/test/github/dhondta/python-tinyscript?targetFile=requirements.txt)
[![License](https://img.shields.io/pypi/l/tinyscript.svg)](https://pypi.python.org/pypi/tinyscript/)

# TinyScript

This library is aimed to provide useful features and to shorten required lines of code for writing nice-looking scripts or tools.

<p align="center">
    <img src="https://dhondta.github.io/python-tinyscript/docs/demos/simple-script.svg">
</p>

## Example tools

### Security

- [AppMemDumper](https://github.com/dhondta/AppmemDumper) (Windows forensics)
- [Bots Scheduler](https://github.com/dhondta/bots-scheduler) (Web security services job scheduler)
- [DroneSploit](https://github.com/dhondta/dronesploit) (startup script)
- [Malicious Macro Tester](https://github.com/dhondta/malicious-macro-tester) (malicious VB macro detection)
- [Paddinganograph](https://gist.github.com/dhondta/90a07d9d106775b0cd29bb51ffe15954) (base32/64 padding-based steganography)
- [Solitaire Cipher](https://gist.github.com/dhondta/1858f406fc55e5e5d440ff26432ad0a4) (encryption)
- [StegoLSB](https://gist.github.com/dhondta/d2151c82dcd9a610a7380df1c6a0272c) (Least Significant Bit)
- [StegoPIT](https://gist.github.com/dhondta/30abb35bb8ee86109d17437b11a1477a) (Pixel Indicator Technique)
- [StegoPVD](https://gist.github.com/dhondta/feaf4f5fb3ed8d1eb7515abe8cde4880) (Pixel Value Differencing)
- [STIX Report Generator](https://gist.github.com/dhondta/ca5fb748957b1ec6f13418ac41c94d5b)
- [WLF (Word List Filter)](https://gist.github.com/dhondta/82a7919f8aafc1393c37c2d0f06b77e8)

### Utils

- [Audio Assembler](https://gist.github.com/dhondta/8b3c7d95b056cae3505df853a098fc4f)
- [Documentation Text Masker](https://gist.github.com/dhondta/5cae9533240471eac155bd51593af2e0)
- [Email Origin](https://gist.github.com/dhondta/9a8027062ff770b2aa5d8422ddd78b57)
- [Loose Comparison Input Generator](https://gist.github.com/dhondta/8937374f087f708c608bcacac431969f) (PHP Type Juggling)
- [PDF Preview Generator](https://gist.github.com/dhondta/f57dfde304905644ca5c43e48c249125)
- [Recursive Compression](https://github.com/dhondta/recursive-compression)
- [WebGrep](https://github.com/dhondta/webgrep) (Web text search)
