# codat-common

<!-- Start SDK Installation -->
## SDK Installation

```bash
pip install codat-common
```
<!-- End SDK Installation -->

## SDK Example Usage
<!-- Start SDK Example Usage -->
```python
import codat
from codat.models import operations, shared

s = codat.Codat()
s.config_security(
    security=shared.Security(
        api_key="YOUR_API_KEY_HERE",
    )
)
   
req = operations.CreateCompanyRequest(
    request=operations.CreateCompanyRequestBody(
        description="unde",
        name="deserunt",
    ),
)
    
res = s.companies.create_company(req)

if res.create_company_200_application_json_object is not None:
    # handle response
```
<!-- End SDK Example Usage -->

<!-- Start SDK Available Operations -->
## SDK Available Operations


### companies

* `create_company` - Create a company
* `delete_companies_company_id` - Delete a company
* `get_companies_company_id` - Get company
* `list_companies` - List companies
* `put_companies_company_id` - Update a company

### connections

* `create_data_connection` - Create a data connection
* `delete_company_connection` - Delete connection
* `get_companies_company_id_connections_connection_id_authorization` - Update authorization
* `get_company_connection` - Get connection
* `list_company_connections` - List connections
* `patch_company_connection` - Unlink connection

### data_status

* `get_companies_company_id_data_status` - Get data status
* `get_company_data_history` - Get pull operations
* `get_pull_operation` - Get pull operation

### integrations

* `get_integrations_platform_key` - Get integration
* `get_integrations_platform_key_branding` - Get branding
* `list_integrations` - List integrations

### push_data

* `get_companies_company_id_connections_connection_id_push` - List push options
* `get_companies_company_id_push` - List push operations
* `get_companies_company_id_push_push_operation_key` - Get push operation

### refresh_data

* `create_many_pull_operations` - Queue pull operations
* `create_pull_operation` - Queue pull operation

### settings

* `get_profile_sync_settings` - Get sync settings
* `get_settings_profile` - Get profile
* `post_profile_sync_settings` - Update all sync settings
* `put_profile` - Update profile

### webhooks

* `get_webhook` - Get webhook
* `list_rules` - List webhooks
* `post_rules` - Create webhook
<!-- End SDK Available Operations -->

### SDK Generated by [Speakeasy](https://docs.speakeasyapi.dev/docs/using-speakeasy/client-sdks)
