# SpeakerPy

`SpeakerPy` - это Python-библиотека для синтеза речи, основанная на моделях Silero Text-to-Speech.

![logo](docs/docs/source/_static/logo315x318.png)

## Возможные сферы применения SpeakerPy

`SpeakerPy` предлагает ряд возможностей для синтеза речи, что делает его полезным инструментом для различных задач и сфер деятельности. Ниже приведены некоторые примеры областей, где может быть использовано приложение `SpeakerPy`:

1. **Образование**: SpeakerPy может использоваться для озвучивания учебных материалов, таких как лекции, статьи и книги, что поможет студентам и преподавателям легче воспринимать информацию и экономить время.

2. **Аудиокниги**: SpeakerPy может быть использован для создания аудиокниг из текстовых документов, что облегчит доступ к литературе для людей с ограниченными возможностями и тех, кто предпочитает слушать, а не читать.

3. **Подкасты и радио**: SpeakerPy можно использовать для создания подкастов и радиопередач на основе текстовых материалов, таких как новости, статьи или блоги.

4. **Доступность**: SpeakerPy может быть полезным для разработки приложений и веб-сайтов с функцией Text-to-Speech, что позволит сделать контент доступным для людей с нарушениями зрения или другими ограниченными возможностями.

5. **Озвучивание видео**: SpeakerPy можно использовать для автоматического озвучивания видеоматериалов, таких как презентации, обучающие видео или даже корпоративные ролики.

6. **Иностранные языки**: SpeakerPy может быть использован для озвучивания текстов на иностранных языках, что поможет изучающим язык лучше понять произношение и интонацию.

7. **Навигационные системы**: SpeakerPy можно применять в навигационных системах и голосовых помощниках для автоматического озвучивания маршрутов, инструкций и другой полезной информации.

8. **Техническая поддержка**: SpeakerPy может быть интегрирован в системы технической поддержки для автоматического озвучивания ответов на часто задаваемые вопросы или инструкций по решению проблем.

9. **Маркетинг и реклама**: SpeakerPy может быть использован для создания голосовых объявлений, промо-роликов и презентаций, что позволит сэкономить время и средства на озвучивание профессиональными дикторами.

10. **Медицина**: SpeakerPy может применяться для озвучивания медицинских текстов, инструкций по применению лекарств или результатов диагностики, что упростит восприятие информации для пациентов и медицинских специалистов.

11. **Наука и исследования**: SpeakerPy может использоваться для озвучивания научных статей, докладов и конференций, что облегчит доступ к информации для ученых и исследователей.

12. **Кастомизация голосовых ассистентов**: SpeakerPy может быть использован для кастомизации голоса виртуальных ассистентов, таких как Siri, Google Assistant или Alexa, что позволит пользователям выбирать голосовые опции, которые им больше нравятся.

13. **Замена голоса**: SpeakerPy может использоваться для смены голоса в существующих аудиозаписях, например для анонимизации подкастов или интервью.

14. **Текстовые редакторы**: SpeakerPy может быть интегрирован в текстовые редакторы для предоставления функции Text-to-Speech, что поможет авторам и редакторам проверять свои тексты на ошибки и стилистические неточности.

Эти примеры лишь часть возможностей применения SpeakerPy. Благодаря своей гибкости и мощным функциям, SpeakerPy может быть адаптирован для использования в самых разнообразных сферах и отраслях, где требуется синтезировать речь из текста. От маркетинга и рекламы до медицины и науки, SpeakerPy может стать полезным инструментом для разработчиков, специалистов по контенту и конечных пользователей.

В целом, возможности использования SpeakerPy ограничены лишь фантазией и потребностями конкретных пользователей или проектов. Благодаря своей универсальности и простоте использования, SpeakerPy может найти свое место в самых разных областях и помочь решать самые разнообразные задачи.

## Особенности и преимущества SpeakerPy

- **Транскрипция чисел и английских слов**: SpeakerPy способен озвучивать числа и английские слова через транскрипцию.
- **Синтез больших объемов текста**: SpeakerPy может синтезировать большие объемы текста без проблем.
- **Корректное деление текста на куски**: благодаря использованию библиотеки nltk, SpeakerPy корректно делит большие тексты на предложения.
- **Кеширование синтезированного текста**: SpeakerPy синтезирует и хранит текст по кускам, что позволяет кешировать уже ранее синтезированный текст и избежать повторного синтезирования.
- **Работа в автономном режиме**: SpeakerPy синтезирует звук локально, без подключения к интернету, что позволяет использовать его в автономном режиме.
- **Сохранение синтезированного текста в MP3**: SpeakerPy предоставляет возможность сохранять синтезированный текст в формате MP3.

## Установка

### Системные требования

- 2 ГБ ОЗУ

### Установка  через pip

`SpeakerPy` можно установить с помощью pip:

```bash
pip install speakerpy
```

### Установка и запуск через Docker

Скачать образ

```bash
docker pull xable/speakerpy
```

> Собрать образ(весит 8.27GB):
>
> ```bash
> make docker-build
> ```

Запустить образ:

```bash
make docker-run
```

## Использование CLI

```bash
╰─➤  python -m speakerpy --help
usage: __main__.py [-h] -l {ru,en} -f FILE -t {mp3,speak} [-sr SAMPLE_RATE] [-s SPEED] [-n NAME_TEXT] [-a AUDIO_DIR]

🎙️ SpeakerPy: CLI для синтеза речи с использованием SpeakerPy 🎙️

options:
  -h, --help            show this help message and exit
  -l {ru,en}, --language {ru,en} 
                        Язык синтеза (ru | en)
  -f FILE, --file FILE  Путь к файлу с текстом для озвучивания
  -t {mp3,speak}, --type_out {mp3,speak}
                        Каким образом вывести синтезированный текст (mp3 | speak)
  -sr SAMPLE_RATE, --sample_rate SAMPLE_RATE
                        Частота дискретизации (по умолчанию: 48000)
  -s SPEED, --speed SPEED
                        Скорость чтения (по умолчанию: 1.0)
  -n NAME_TEXT, --name_text NAME_TEXT
                        Имя для текста, с таким именем сохранится итоговый mp3 файл (по умолчанию: имя файла с текстом)
  -a AUDIO_DIR, --audio_dir AUDIO_DIR
                        Папка для сохранения готовых аудио файлов (по умолчанию: текущая папка)

Примеры использования:
  python -m speakerpy -l ru -t speak -f ./books/example.txt;
  python -m speakerpy -l ru -t mp3 -f ./books/example.txt;
  python -m speakerpy -l en -t speak -f ./books/example.txt;
  python -m speakerpy -l en -t mp3 -f ./books/example.txt;
```

## Основные компоненты

Проект состоит из двух основных компонентов: Lib Speak и Lib SL Text.

### Lib Speak

Lib Speak включает классы `Speaker` и `SpeakerBase` для синтеза речи с использованием моделей Silero. Основные методы класса `Speaker`:

1. `speak`: произнесение текста.
2. `to_mp3`: конвертация текста в аудиофайл MP3.

#### Пример использования функции speak

```python
from lib_speak import Speaker
from lib_sl_text import SeleroText

text = SeleroText("Пример текста для синтеза речи")
speaker = Speaker(model_id="ru_v3", language="ru", speaker="aidar", device="cpu")
speaker.speak(text=text, sample_rate=48000, speed=1.0)
```

#### Пример использования функции to_mp3

```python
from lib_speak import Speaker
from lib_sl_text import SeleroText

text = SeleroText("Пример текста для синтеза речи")
speaker = Speaker(model_id="ru_v3", language="ru", speaker="aidar", device="cpu")
speaker.to_mp3(text=text, name_text="Текст", sample_rate=48000, audio_dir=pathlib.Path(__file__).parent.parent / "mp3", speed=1.0)
```

### Lib SL Text

Lib SL Text содержит класс `SeleroText` для обработки текста перед синтезом речи. Основной метод класса `SeleroText`:

1. `chunk`: разделение текста на блоки.

#### Использование класса SeleroText

```python
text = SeleroText("Привет, мир!", to_language="ru")
```

Разделение текста на куски с помощью метода `chunk()`:

```python
for chunk in text.chunk():
    print(chunk)
```

## Ресурсы и ссылки

- <a href="https://github.com/snakers4/silero-models/blob/master/models.yml" target="_new">Silero Models на GitHub</a>
- <a href="https://www.sphinx-doc.org/" target="_new">Sphinx</a>
- <a href="https://github.com/readthedocs/sphinx_rtd_theme" target="_new">Sphinx RTD Theme</a>
- <a href="https://readthedocs.org/" target="_new">Read the Docs</a>
