#!/usr/bin/env python
from accessoryFunctions.accessoryFunctions import printtime
from glob import glob
import os
import re
__author__ = 'adamkoziol'


class Compress(object):

    def remove(self):
        """Removes unnecessary temporary files generated by the pipeline"""
        import shutil
        printtime('Removing large and/or temporary files', self.start)
        removefolder = list()
        for sample in self.metadata:
            # Find the folders in the spades output directory that should be removed
            for folder in glob(os.path.join(sample.general.spadesoutput, 'K*')):
                removefolder.append(folder)
            removefolder.append(os.path.join(sample.general.spadesoutput, 'misc'))
            removefolder.append(os.path.join(sample.general.spadesoutput, 'tmp'))
            # Use os.walk to iterate through all the files in the sample output directory
            for path, dirs, files in os.walk(sample.general.outputdirectory):
                for item in files:
                    # Use regex to find files to remove
                    if re.search(".fastq$", item) or re.search(".fastq.gz$", item) or re.search(".bam$", item) \
                            or re.search(".bt2$", item) or re.search(".tab$", item) or re.search("^before", item) \
                            or re.search("^baitedtargets", item) or re.search("_combined.csv$", item) \
                            or re.search("^scaffolds", item) or re.search(".fastg$", item) or re.search(".gfa$", item) \
                            or re.search(".bai$", item):
                        # Keep the baitedtargets.fa files
                        if item != 'baitedtargets.fa':
                            # Remove the unnecessary files
                            try:
                                os.remove(os.path.join(path, item))
                            except IOError:
                                pass
        # # Clear out the folders
        for folder in removefolder:
            try:
                shutil.rmtree(folder)
            except (OSError, TypeError):
                pass

    def __init__(self, inputobject):
        self.metadata = inputobject.runmetadata.samples
        self.start = inputobject.starttime
        self.remove()
