# SQLAlchemy

**FastAPI Users** provides the necessary tools to work with SQL databases thanks to [SQLAlchemy Core](https://docs.sqlalchemy.org/en/13/core/) and [encode/databases](https://www.encode.io/databases/) package for full async support.

## Installation

Install the database driver that corresponds to your DBMS:

```sh
pip install 'databases[postgresql]'
```

```sh
pip install 'databases[mysql]'
```

```sh
pip install 'databases[sqlite]'
```

For the sake of this tutorial from now on, we'll use a simple SQLite databse.

## Setup User table

Let's declare our SQLAlchemy `User` table.

```py hl_lines="13 14"
{!./src/db_sqlalchemy.py!}
```

As you can see, **FastAPI Users** provides a mixin that will include base fields for our `User` table. You can of course add you own fields there to fit to your needs!

## Create the tables

We'll now create an SQLAlchemy engine and ask it to create all the defined tables.

```py hl_lines="17 18 19 20"
{!./src/db_sqlalchemy.py!}
```

!!! warning
    In production, it's strongly recommended to setup a migration system to update your SQL schemas. See [Alembic](https://alembic.sqlalchemy.org/en/latest/).

## Create the database adapter dependency

The database adapter of **FastAPI Users** makes the link between your database configuration and the users logic. It should be generated by a FastAPI dependency.

```py hl_lines="25 26"
{!./src/db_sqlalchemy.py!}
```

Notice that we pass it three things:

* A reference to your [`UserDB` model](../models.md).
* A `database` instance, which allows us to do asynchronous request to the database.
* The `users` variable, which is the actual SQLAlchemy table behind the table class.

## What about SQLAlchemy ORM?

The primary objective was to use pure async approach as much as possible. However, we understand that ORM is convenient and useful for many developers. If this feature becomes very demanded, we will add a database adapter for SQLAlchemy ORM.
