# Generated by Django 4.0.2 on 2022-05-11 22:32

from ..orm import fields
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Attachment',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('active', models.BooleanField(default=True)),
                ('created_date', models.DateTimeField(blank=True, default=django.utils.timezone.now, null=True, verbose_name='Fecha de creación')),
                ('updated_date', models.DateTimeField(blank=True, null=True, verbose_name='Fecha de actualización')),
                ('created_by', models.IntegerField(null=True, verbose_name='Creado por')),
                ('updated_by', models.IntegerField(null=True, verbose_name='Actualizado por')),
                ('origin_model_name', models.TextField(blank=True, null=True, verbose_name='Modelo de origen')),
                ('origin_model_id', models.TextField(blank=True, null=True, verbose_name='Id del modelo de origen')),
                ('name', fields.CharField(blank=True, default='', max_length=200, null=True, verbose_name='Nombre')),
                ('file', models.FileField(upload_to='attachments/%Y/%m/%d/')),
            ],
            options={
                'verbose_name': 'Adjunto',
                'verbose_name_plural': 'Adjuntos',
                'db_table': 'base_attachment',
            },
        ),
        migrations.CreateModel(
            name='ConfigCategory',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('active', models.BooleanField(default=True)),
                ('created_date', models.DateTimeField(blank=True, default=django.utils.timezone.now, null=True, verbose_name='Fecha de creación')),
                ('updated_date', models.DateTimeField(blank=True, null=True, verbose_name='Fecha de actualización')),
                ('created_by', models.IntegerField(null=True, verbose_name='Creado por')),
                ('updated_by', models.IntegerField(null=True, verbose_name='Actualizado por')),
                ('name', fields.CharField(blank=True, default='', max_length=200, null=True, verbose_name='Nombre')),
            ],
            options={
                'verbose_name': 'Categoría de Configuración',
                'verbose_name_plural': 'Categorías de Configuraciones',
                'db_table': 'base_config_category',
            },
        ),
        migrations.CreateModel(
            name='Data',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('model_name', fields.CharField(blank=True, default='', max_length=200, null=True, verbose_name='Nombre del modelo')),
                ('model_id', fields.IntegerField(default=0, verbose_name='ID del modelo')),
                ('identifier', fields.CharField(blank=True, default='', max_length=200, null=True, verbose_name='Identificador')),
                ('created_date', models.DateTimeField(blank=True, default=django.utils.timezone.now, null=True, verbose_name='Fecha de creación')),
            ],
            options={
                'verbose_name': 'Información de registro',
                'verbose_name_plural': 'Información de registro',
                'db_table': 'base_data',
            },
        ),
        migrations.CreateModel(
            name='Logbook',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('origin_model_name', models.TextField(blank=True, null=True, verbose_name='Modelo de origen')),
                ('origin_model_id', models.TextField(blank=True, null=True, verbose_name='Id del modelo de origen')),
                ('from_changes', fields.TextField(default='', max_length=500, null=True, verbose_name='Original')),
                ('to_changes', fields.TextField(default='', max_length=500, null=True, verbose_name='Cambios')),
                ('created_date', fields.DateTimeField(blank=True, default=django.utils.timezone.now, null=True, verbose_name='Fecha de creación')),
                ('user_name', fields.CharField(blank=True, default='', max_length=200, null=True, verbose_name='Usuario')),
                ('user_id', fields.IntegerField(default=0, null=True, verbose_name='Id del usuario')),
            ],
            options={
                'verbose_name': 'Bitácora',
                'verbose_name_plural': 'Bitácora',
                'db_table': 'base_logbook',
            },
        ),
        migrations.CreateModel(
            name='UIView',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('active', models.BooleanField(default=True)),
                ('created_date', models.DateTimeField(blank=True, default=django.utils.timezone.now, null=True, verbose_name='Fecha de creación')),
                ('updated_date', models.DateTimeField(blank=True, null=True, verbose_name='Fecha de actualización')),
                ('created_by', models.IntegerField(null=True, verbose_name='Creado por')),
                ('updated_by', models.IntegerField(null=True, verbose_name='Actualizado por')),
                ('name', fields.CharField(blank=True, default='', max_length=200, null=True, verbose_name='Nombre')),
                ('model', fields.CharField(blank=True, default='', max_length=200, null=True, verbose_name='Modelo')),
                ('path', fields.CharField(blank=True, default='', max_length=200, null=True, verbose_name='Ruta')),
                ('content', fields.TextField(default='', max_length=500, null=True, verbose_name='Contenido')),
            ],
            options={
                'verbose_name': 'Vista UI',
                'verbose_name_plural': 'Vistas UI',
                'db_table': 'base_ui_view',
            },
        ),
        migrations.CreateModel(
            name='Menu',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('active', models.BooleanField(default=True)),
                ('created_date', models.DateTimeField(blank=True, default=django.utils.timezone.now, null=True, verbose_name='Fecha de creación')),
                ('updated_date', models.DateTimeField(blank=True, null=True, verbose_name='Fecha de actualización')),
                ('created_by', models.IntegerField(null=True, verbose_name='Creado por')),
                ('updated_by', models.IntegerField(null=True, verbose_name='Actualizado por')),
                ('name', fields.CharField(blank=True, default='', max_length=200, null=True, verbose_name='Nombre')),
                ('icon', fields.CharField(blank=True, default='', max_length=200, null=True, verbose_name='Icono')),
                ('sorting_number', fields.IntegerField(default=0, verbose_name='Número de ordenamiento')),
                ('route', fields.CharField(blank=True, default='', max_length=200, null=True, verbose_name='Ruta')),
                ('parent_menu', fields.ForeignKey(null=True, on_delete=django.db.models.deletion.PROTECT, to='moarcframework.menu', verbose_name='Menú padre')),
            ],
            options={
                'verbose_name': 'Menú de navegación',
                'verbose_name_plural': 'Menú de navegación',
                'db_table': 'base_menu',
                'ordering': ['sorting_number'],
            },
        ),
        migrations.CreateModel(
            name='Config',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('active', models.BooleanField(default=True)),
                ('created_date', models.DateTimeField(blank=True, default=django.utils.timezone.now, null=True, verbose_name='Fecha de creación')),
                ('updated_date', models.DateTimeField(blank=True, null=True, verbose_name='Fecha de actualización')),
                ('created_by', models.IntegerField(null=True, verbose_name='Creado por')),
                ('updated_by', models.IntegerField(null=True, verbose_name='Actualizado por')),
                ('name', fields.CharField(blank=True, default='', max_length=200, null=True, verbose_name='Nombre')),
                ('description', fields.TextField(default='', max_length=500, null=True, verbose_name='Descripción')),
                ('value', fields.TextField(default='', max_length=500, null=True, verbose_name='Valor')),
                ('data_type', fields.TextField(default='string', max_length=500, null=True, verbose_name='Tipo de dato')),
                ('config_category', fields.ForeignKey(null=True, on_delete=django.db.models.deletion.PROTECT, related_name='configs', to='moarcframework.configcategory')),
            ],
            options={
                'verbose_name': 'Configuración',
                'verbose_name_plural': 'Configuraciones',
                'db_table': 'base_config',
            },
        ),
    ]
