# Copyright 2021 Zuru Tech HK Limited. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Official Experiments configuration."""

from anomaly_toolbox.experiments.anogan import AnoGANExperiment
from anomaly_toolbox.experiments.descargan import DeScarGANExperiment
from anomaly_toolbox.experiments.egbad import EGBADExperiment
from anomaly_toolbox.experiments.experiment import Experiment
from anomaly_toolbox.experiments.ganomaly import GANomalyExperiment

__all__ = [
    "AnoGANExperiment",
    "DeScarGANExperiment",
    "EGBADExperiment",
    "GANomalyExperiment",
    "Experiment",
]

__experiments__ = [
    "AnoGANExperiment",
    "DeScarGANExperiment",
    "EGBADExperiment",
    "GANomalyExperiment",
]
