YARP 3.2.0 (2019-06-27)                                                {#v3_2_0}
=======================

[TOC]

YARP 3.2.0 Release Notes
========================


A (partial) list of bug fixed and issues resolved in this release can be found
[here](https://github.com/robotology/yarp/issues?q=label%3A%22Fixed+in%3A+YARP+v3.2.0%22).


Important Changes
-----------------

### Dependencies

* Optional dependency on YCM now requires version 0.10.4 or later.
* Optional dependency on RobotTestingFramework now requires version 2 or later.
* Rplidar SDK updated to 1.9.0
* Thrift updated to 0.12.0
* QCustomPlot 2 is now supported.
* Optional dependency on LibOVR now requires version 1.17 or later.

### Bindings

* Removed support for 'Chicken Scheme' and 'Allegro Common Lisp'.
* Swig 4 is now supported.

### Devices

* The `portaudio` and the `ServerSoundGrabber` device drivers are deprecated.

New Features
------------

### Build System

* `.ini` files for plugins configured with `yarp_prepare_plugin` can now be
   automatically generated by `yarp_add_plugin` and installed by passing the
   `YARP_INI DESTINATION` argument to `yarp_install`.
* The `CREATE_LIB_MATH` CMake option was renamed `YARP_COMPILE_libYARP_math`.
* The `CREATE_GUIS` CMake option was renamed `YARP_COMPILE_GUIS`.
* All the `CREATE_<UPPERCASE_EXECUTABLE>` were renamed
  `YARP_COMPILE_<lowercase-executable>`
* All the `YARP_USE_<UPPERCASEPACKAGENAME>` were renamed
  `YARP_USE_<PackageName>`
* All the `YARP_USE_SYSTEM_<UPPERCASEPACKAGENAME>` were renamed
  `YARP_USE_SYSTEM_<PackageName>`
* All the internal CMake variables related to packages now use the same case
  as the relative CMake module (i.e. `YARP_HAS_OpenCV` instead of
  `YARP_HAS_OPENCV`)
* `yarp_idl_to_dir` signature changed, and now supports passing optional
  parameters:
  ```
     yarp_idl_to_dir(INPUT_FILES <file> [file]
                     OUTPUT_DIR <dir>
                     [SOURCES_VAR <var>]
                     [HEADERS_VAR <var>]
                     [INCLUDE_DIRS_VAR <var>]
                     [THRIFT_INCLUDE_PREFIX]
                     [THRIFT_NO_NAMESPACE_PREFIX]
                     [THRIFT_NO_COPYRIGHT}
                     [THRIFT_NO_EDITOR]
                     [THRIFT_NO_DOC]
                     [VERBOSE])
  ```
  The old behaviour is still supported, but deprecated.
* `yarp_idl_to_dir` always regenerates files if they are not available.
* `yarp_idl_to_dir` No longer generates build targets.
* Files returned by `yarp_idl_to_dir` are now relative to current directory.


### Libraries

#### YARP_conf

* The `yarp/conf/options.h` header file is deprecated.

#### YARP_OS

* The following methods signatures were changed to accept `const char` instead
  of `int` as terminating character:
    * `ConnectionReader::expectText()`
    * `ConnectionWriter::appendString()`
    * `InputStream::readLine()`
* Added `YarpPluginSelector::checkPlugin()` static method.
* `ConnectionWriter::appendString()` is deprecated in favour of `appendText()`.
* `ConnectionWriter::appendRawString()` is deprecated in favour of
  `appendString()`.
* Added `ConnectionReader::expectString()`.
* Added the `initiliizer_list` constructor in `yarp::os::Property`.
* Added the `initiliizer_list` constructor in `yarp::os::Bottle`.
* `yarp::os::NameSpace`: All methods in the interface that take `ContactStyle`
  as parameter, are now passed by reference instead of by value.
  * ```diff
    - virtual bool connectPortToTopic(const Contact& src, const Contact& dest, ContactStyle style) = 0;
    + virtual bool connectPortToTopic(const Contact& src, const Contact& dest, const ContactStyle& style) = 0;
    ```
  * ```diff
    - virtual bool connectTopicToPort(const Contact& src, const Contact& dest, ContactStyle style) = 0;
    + virtual bool connectTopicToPort(const Contact& src, const Contact& dest, const ContactStyle& style) = 0;
    ```
  * ```diff
    - virtual bool disconnectPortFromTopic(const Contact& src, const Contact& dest, ContactStyle style) = 0;
    + virtual bool disconnectPortFromTopic(const Contact& src, const Contact& dest, const ContactStyle& style) = 0;
    ```
  * ```diff
    - virtual bool disconnectTopicFromPort(const Contact& src, const Contact& dest, ContactStyle style) = 0;
    + virtual bool disconnectTopicFromPort(const Contact& src, const Contact& dest, const ContactStyle& style) = 0;
    ```
  * ```diff
    - virtual bool connectPortToPortPersistently(const Contact& src, const Contact& dest, ContactStyle style) = 0;
    + virtual bool connectPortToPortPersistently(const Contact& src, const Contact& dest, const ContactStyle& style) = 0;
    ```
  * ```diff
    - virtual bool disconnectPortToPortPersistently(const Contact& src, const Contact& dest, ContactStyle style) = 0;
    + virtual bool disconnectPortToPortPersistently(const Contact& src, const Contact& dest, const ContactStyle& style) = 0;
    ```

#### YARP_sig

* Added `ImageUtils.h`, an header containing the following image utilities:
  - `utils::vertSplit`
  - `utils::horzSplit`
  - `utils::vertConcat`
  - `utils::horzConcat`
* `yarp::sig::file` Added support to write .png files

* Added the following methods to `VectorOf`:
  - VectorOf(std::initializer_list<T>)
  - begin(), end(), cbegin(), cend()
  - reserve(size_t)
  - capacity()
  - push_back(T&&)
  - emplace_back(_Args...)
* Deprecated `VectorOf::getFirst()` in favour of `data()` and `begin()`.
  Use either `data()` if you need the pointer to the first element, or `begin()`
  if you need the iterator.
* Added `yarp::sig::IntrinsicParams` and `yarp::sig::YarpDistortion` emum.
* Added two methods for computing a `yarp::sig::PointCloud` from depth images:
  - `utils::depthToPC`
  - `utils::depthRgbToPC`
* Deprecated `getIplImage` and `wrapIplImage` in favour of the new utilities of
  `YARP_cv`.
* Added move semantics in `yarp::sig::Image`.
* The `yarp::sig::Sound` class was heavily refactored:
  - New data types:
    * `Sound::audio_sample` (`short int`)
  - Changed signatures:
    * ```diff
      - Sound(int bytesPerSample)
      + Sound(size_t bytesPerSample)
      ```
    * ```diff
      - int get(size_t sample, size_t channel) const
      + audio_sample get(size_t sample, size_t channel) const
      ```
    * ```diff
      - void set(int value, size_t sample, size_t channel)
      + void set(audio_sample value, size_t sample, size_t channel)
      ```
    * ```diff
      - void setSafe(int value, size_t sample, size_t channel)
      + void setSafe(audio_sample value, size_t sample, size_t channel)
      ```
    * ```diff
      - size_t getFrequency() const
      + int getFrequency() const
      ```
    * ```diff
      - void setFrequency(size_t freq)
      + void setFrequency(int freq)
      ```
  - Removed methods:
    * `unsigned char *getRawData() const`
    * `size_t getRawDataSize() const`
  - Added methods:
    * `bool operator==(const Sound& alt) const`
    * `bool clearChannel(size_t channel)`
    * `Sound extractChannelAsSound(size_t channel_id) const`
    * `std::vector<std::reference_wrapper<audio_sample>> getChannel(size_t channel_id)`
    * `bool replaceChannel(size_t id, Sound channel)`
    * `std::vector<std::reference_wrapper<audio_sample>> getInterleavedAudioRawData() const`
    * `std::vector<std::reference_wrapper<audio_sample>> getNonInterleavedAudioRawData() const`
    * `std::string toString() const`
    * `double getDuration() const`


#### YARP_dev

* `yarp::dev::IMap2D::clear()` method renamed to
  `yarp::dev::IMap2D::clearAllMaps()`.
* `yarp::dev::INavigation2D` derives from `INavigation2DControlActions`
  and `INavigation2DTargetActions`.
* `yarp::dev::INavigation2DControlActions`. The following methods have been
  added:
  `getAllNavigationWaypoints(std::vector<yarp::dev::Map2DLocation>& waypoints)`
  `getCurrentNavigationWaypoint(yarp::dev::Map2DLocation& curr_waypoint)`
  `getCurrentNavigationMap(yarp::dev::NavigationMapTypeEnum map_type, yarp::dev::MapGrid2D& map)`
* `yarp::dev::INavigation2DTargetActions`. The following method has been added:
  `gotoTargetByRelativeLocation(double x, double y)`
* The following method now accepts a parameter (with default value = infinite
  for backward compatibility):
  `yarp::dev::INavigation2DTargetActions::suspendNavigation(const double time_s = std::numeric_limits<double>::infinity())`
* `yarp::dev::ILocalization2D` added the new two following methods:
  - `bool getLocalizationStatus(LocalizationStatusEnum& status)`
  - `bool getEstimatedPoses(std::vector<yarp::dev::Map2DLocation>& poses)`
* `yarp::dev::ILocalization2D` added the new type: `LocalizationStatusEnum`
* `yarp::dev::IBattery::getBatteryStatus()` now uses Battery_status enum,
  instead of int.
* `yarp::dev::INavigation2D`. Added method
  `yarp::dev::INavigation2DControlActions::recomputeCurrentNavigationPath()`.
* `yarp::dev::INavigation2D`. Added helper static methods:
  - `yarp::dev::INavigation2DHelpers::statusToString()`
  - `yarp::dev::INavigation2DHelpers::stringToStatus()`
* `yarp::dev::INavigation2D`. Added method:
  `yarp::dev::INavigation2D::getNameOfCurrentTarget()` to the interface.
* `yarp::dev::INavigation2D`. Method:
  `yarp::dev::INavigation2D::gotoTargetByLocationName()` now accepts area names.
* `yarp::dev::INavigation2D`. Added class `yarp::dev::Map2DArea`.
* `yarp::dev::INavigation2D`. Added methods `getArea()`, `checkInsideArea()` and
  `checkNearToLocation()`.
* `yarp::dev::INavigation2DTargetActions`. Added method
  `applyVelocityCommand()`.
* `yarp::dev::Map2DServer`. Changed locations.ini file format to support
  load/save of Map2DLocation and Map2DArea.
* Updated `AnalogWrapper` to open multiple ros topics for `wrenchStamped`
    ros msg type.
* Added `const` counterpart of `yarp::dev::CanBuffer::getPointer()`.
* `yarp::dev::IMap2D` Added method `yarp::dev::IMap2D::renameLocation()`
* `yarp::dev::IMap2D` Added method `yarp::dev::IMap2D::renameArea()`
* Added `yarp::dev::CircularAudioBuffer` and `yarp::dev::AudioBufferSize`
  classes.
* IAudioRender:
  - Changed signatures:
    * ```diff
      - bool renderSound(yarp::sig::Sound& sound)
      + bool renderSound(const yarp::sig::Sound& sound)
      ```
  - Added methods:
    * `bool getPlaybackAudioBufferMaxSize(yarp::dev::AudioBufferSize& size)`
    * `bool getPlaybackAudioBufferCurrentSize(yarp::dev::AudioBufferSize& size)`
    * `bool resetPlaybackAudioBuffer()`
    * `bool getRecordingAudioBufferMaxSize(yarp::dev::AudioBufferSize& size)`
    * `bool getRecordingAudioBufferCurrentSize(yarp::dev::AudioBufferSize& size)`
    * `bool resetRecordingAudioBuffer()`
* IAudioGrabberSound:
  - Changed signatures:
    * ```diff
      - bool getSound(yarp::sig::Sound& sound)
      + bool getSound(yarp::sig::Sound& sound, size_t min_number_of_samples, size_t max_number_of_samples, double max_samples_timeout_s)
      ```
  - Added methods:
    * `bool getRecordingAudioBufferMaxSize(yarp::dev::AudioBufferSize& size)`
    * `bool getRecordingAudioBufferCurrentSize(yarp::dev::AudioBufferSize& size)`
    * `bool resetRecordingAudioBuffer()`


#### YARP_cv

* Added `YARP_cv`, a conversion library from YARP images to cv::Mat and
  viceversa.


### Devices

* New devices:
  - `fakeBattery`
  - `navigation2DServer`
  - `localization2DServer`
  - `usbCamera` (imported from the iCub repository)
  - `fakeNavigation`
  - `fakeLocalizer`
  - `audioRecorderWrapper`
  - `portaudioRecorder`
  - `portaudioPlayer`
  - `audioPlayerWrapper`
  - `fakeSpeaker`
  - `fakeMicrophone`
* Add `physFocalLength` parameter for RGBD devices (check documentation for more
  details).

##### `BatteryWrapper`

* Now handles correctly `--subdevice` option.

##### `imuBosch_BNO055`

* Added `MultipleAnalogSensor` interface support.
* Fixed conversion factor for gyro and magnetometer.
* Fixed unit measure in ThreeAxis interface.

##### `Navigation2DClient`

* Added handler for rpc string commands.
  By default the  port is called `<client_name>/user_commands/rpc`.

##### `fakeLaser`

* Added configuration parameters to set the range and the resolution of the
  device.

##### `analogServer`

* Has learned to forward return codes to `analogSensorClient` (#1981).
* Now forwards `calibrateSensor(const yarp::sig::Vector& value)`
  calls to wrapped subdevices.

##### `ServerSoundGrabber`

* No longer implements `IAudioGrabberSound`.

##### `ServerFrameGrabber`

* No longer implements audio interfaces.


### RFModules

* Added the possibility to compile `RFModule`s as plugin and load them runtime
  in a single process context.


### Tools

##### `yarprobotinterface`
* YARP//DTD yarprobotinterface 3.0//EN is now the default parser for robot xml configuration files.
  `yarprobotinterface` will not run anymore deprecated DTD format v1.0

##### `yarpidl_thrift`

* The thrift tool was refactored.
* Fix list serialization for i8, i16 and i64 (#1962)
* Structs can now be exported in dll APIs using the `yarp.api.include` and
  `yarp.api.keyword` annotations.
* Portables serialized using `appendExternalBlock` (i.e. `yarp::sig::Vector`)
  can now be safely returned by thrift methods.
* Files are now generating using namespace as subdirectory (this can be
  disabled using the no_namespace_prefix option.
* Constants and typedefs are now properly generated in the namespace.


##### `yarphear`

* Use `portaudioPlayer` instead of `portaudio` device.


### GUIs

##### `yarpmanager`

* Allow to specify an address for every host in the `cluster-config.xml` file.
  This allow to use host names that cannot be resolved automatically by the
  network.

##### `yarpview`

* Added size (w,h) info for:
  - the image received on the yarp port
  - the image currently displayed in yarpview


Bug Fixes
---------

### Libraries

#### YARP_dev

* `ImplementPositionControl::checkMotionDone` now correctly returns a single
  value as from API (#2027).


Contributors
------------

This is a list of people that contributed to this release (generated from the
git history using `git shortlog -ens --no-merges v3.1.0..v3.2.0`):

```
   413	Daniele E. Domenichelli <daniele.domenichelli@iit.it>
   154	Nicolò Genesio <nicolo.genesio@iit.it>
    76	Marco Randazzo <marco.randazzo@iit.it>
    70	Alberto Cardellino <alberto.cardellino@iit.it>
    19	Valentina Gaggero <valentina.gaggero@iit.it>
    13	Silvio Traversaro <silvio.traversaro@iit.it>
    11	Bartek Łukawski <bwmn.peter@gmail.com>
     8	Damiano Enerli <damiano.enerli@iit.it>
     7	Ugo Pattacini <ugo.pattacini@iit.it>
     5	Yeshasvi Tirupachuri <yeshasvi.tirupachuri@iit.it>
     4	Andrea Ruzzenenti <andrea.ruzzenenti@iit.it>
     4	Claudio Fantacci <claudio.fantacci@iit.it>
     4	Matteo Brunettini <matteo.brunettini@iit.it>
     4	Stefano Dafarra <stefano.dafarra@iit.it>
     3	Andrea Ruzzenenti <ruzzenenti.a@gmail.com>
     2	Arren Glover <arren.glover@iit.it>
     2	Diego Ferigo <diego.ferigo@iit.it>
     2	Nuno Guedelha <nuno.guedelha@iit.it>
     2	Prashanth Ramadoss <prashanth.ramadoss@iit.it>
     2	Tobias Fischer <t.fischer@imperial.ac.uk>
     1	Austin Kothig <kothiga2112@gmail.com>
     1	Emilio Benenati <emilio.benenati@iit.it>
     1	Francesco Romano <francesco.romano@iit.it>
     1	GiulioRomualdi <giulio.romualdi@gmail.com>
     1	Jason Chevrie <jason.chevrie@iit.it>
     1	Mohamed Babiker Mohamed Elobaid <mohamed.elobaid@iit.it>
     1	Vadim Tikhanoff <vadim.tikhanoff@iit.it>
     1	YARP Developers <yarp0-devel@lists.sourceforge.net>
```
