YARP 2.3.68.1 (2017-06-15)                                          {#v2_3_68_1}
==========================

[TOC]

YARP 2.3.68.1 Release Notes
===========================


A (partial) list of bug fixed and issues resolved in this release can be found
[here](https://github.com/robotology/yarp/issues?q=label%3A%22Fixed+in%3A+YARP+v2.3.68.1%22).


Important Changes
-----------------

### Build System

* `YARP_gsl` was removed from the `YARP_LIBRARIES` CMake variable where it was
  erroneously added. If you are using that library you might need to add
  `YARP::YARP_gsl` to the list of libraries linked by your target.

* The `CREATE_SHARED_LIBRARY` option is deprecated in favour of the standard
  `BUILD_SHARED_LIBS`.

* Plugins are now added to `FeatureSummary` if available.

* Fixed symbol visibility logic. Not exported symbols are now always hidden. The
  `YARP_EXPERIMENTAL_FILTER_API` option can be used to hide also symbols from
  the `impl` libraries (it will not build at the moment).


### Devices

#### depthCamera

* Spelling of the `length`-related parameters was fixed. You might have to fix
  your configuration files.


New Features
------------

### Build System

* Builds from git repositories will now contain the git commit and dirty state
  in the version number (For example 2.3.68+98-20161222.4+git3942468+dirty
  (2.3.68+98)). `YARP_VERSION_MAJOR`, `YARP_VERSION_MINOR`, `YARP_VERSION_PATCH`
  and `YARP_VERSION_TWEAK` meanings hasn't changed. `YARP_VERSION_STRING` was
  removed since it was never used.

### Devices

* Added new `laserFromDepth` device.


Bug Fixes
---------

### Build System

* Fixed `YARP_CLEAN_API` build with GCC 6.1 or later (that uses c++14 by
  default) by forcing `-std=c++98` (#978).
* Fixed `YARP_EXPERIMENTAL_CXX11` on MSVC 12 2013.
* The `YARP_ABORT_ON_WARNING` and `YARP_FATAL_ERRORS` options were restored.
* Added workaround for FindCUDA bug when crosscompiling.
  See https://gitlab.kitware.com/cmake/cmake/issues/16509.

### CMake Modules

* Fixed issues in `yarp_add_idl` command when generating files using paths
  containing `..`
* Fixed issues in `yarp_idl_to_dir` command when generating files on paths
  containing white spaces.


### Libraries

#### YARP_OS

* Fixed typo preventing successful compilation on linux/mac with C++11 enabled.
* `yarp::os::idl::BareStyle<T>` and `yarp::os::idl::BareStyle<T>` are no longer
  erroneously marked as `YARP_OS_API`.
* Fixed memory leak in `yarp::os::Contact` when SKIP_ACE is enabled.
* Fixed Windows 2000 detection in `SystemInfo`.
* Fixed security issue related to the buffer size in yInfo(), yDebug(), etc.
  functions.
* Maximum string size in yInfo(), yDebug(), etc. functions was increased to 1024
  characters.
* Fixed commands `yarp name get /port accepts` and `yarp name get /port offers`.
* Fixed deadlock during a device closure after calling a prepare of a closed port.
* Fixed reply to `yarp::os::Node::Helper::getBusInfo` if no connections available,
  now it returns an empty list.

#### YARP_sig

* Ensure that after yarp::sig::VectorOf::resize(), the constructor operator
  for the new objects is called.
* Added missing YARP_sig_API to yarp::sig::file::soundStreamReader.

#### YARP_dev

* Added warning when loading a plugin with a wrong library parameter (#975).
* Fixed the communication of mirroring and intrinsic parameter through sender and
  parser in IVisualParamsImpl.
* Fixed ControlBoardRemapper not returning an error on malformed axesNames.
* `IControlLimits2Raw` now inherits publicly from IControlLimitsRaw.
* Fixed missing include of `yarp/dev/api.h` in `IEncoders.h` (#1127)
* Fixed missing include of `yarp/os/Vocab.h` in `IControlMode.h` (#1199)
* Fixed FrameTransformClient::waitForTransform() (#1183)
* Fixed memory leak in ControlBoardWrapper.
* Fixed memory leak in Rangefinder2DClient.
* Fixed wrong ROS message in ControlBoardWrapper if ROS = `only`.

#### YARP_math

* Fix resizing of output matrices in SVD (#1062, #1066).


### Private libraries

#### YARP_manager

* Fixed typo in `setEnvironemnt`, now `setEnvironment`

### Tools

#### `yarprobotinterface`

* Devices are now closed in the reverse order as they are created.

#### `yarpidl_rosmsg`

* Fixed an out-of-bounds error if an array contained in a ros message has size
  == 0
* Fixed segfault when publishing a ros message including a null vector

#### `yarpdataplayer`

* Fixed memory leak.


### GUIs

#### yarpview

* Fixed RPATH.

#### yarpscope

* Fixed RPATH.

#### yarpmanager

* Removed extra ';' from environment variables and port prefix (#980, #982).
* Fixed `saveAs` action(#755).
* Added warning in case of creation of a new file(application) that already
  exists.
* Fixed double tab open of the same application.
* Added key shortcuts for the actions.
* Removed automatically applications, modules and resources that no longer exist
  on disk when double click on them or click *edit*.
* Fixed the addition to the tree of multiple applications pointing to the same xml
  file.
* Fixed refresh button, before ignored every text entry changed int the application
  tab.
* Added automatic refresh on the application tab open.
* Added automatic application tab open when you load an application from disk.
* Disabled the *select all* after pressing run all, stop all, refresh all and kill
  all actions.
* Added run/stop/kill/connect/disconnect all and run/stop/kill/connect/disconnect
  selected

#### yarplaserscannergui

* Fixed close button not closing the gui (#720).
* Fixed laser orientation to have x axis pointing towards N and y axis towards
  W (as in ROS)

#### yarpbatterygui

* Fixed memory leak in closing.

### Carriers

* Fixed issue in `tcpros` carrier causing a severe slowdown of
  `yarp::os::Publisher` when multiple ros clients are connected to the same
  topic.

### Devices

* Fixed `rangeFinder2DClient` and `getLaserMeasurement()` function of various
  hardware devices: laser_angle_of_view was not computed correctly.
* Fixed bugs in `AnalogWrapper`: `start()` return value is checked (important
  for avoiding address conflict), all the ports needed are opened only once and
  not multiple times, fixed memory leaks.

#### fakeMotionControl

* Fixed error in open function.
* Better param check.

#### depthCamera

* Added missing distortion model params.
* Implemented camInfo messages for ros interoperation.
* Fixed parsing file error.
* Cleanup and improved documentation.
* Fixed segmentation fault on device shutdown.
* Fixed segmentation fault when passing an incorrect configuration.
* Fixed resolution from config.

#### fakeLaser

* Improved fakeLaser test to display x and y axis.

#### rangeFinder2DWrapper

* Added internal subdevice spawn and attach.
* Fixed parameter name in error message.

#### rpLidar

* Allow to set negative max_angle & min_angle, allowing a virtual rotation of
  the sensor zero (#1019).


### Bindings

* RPATH is now correctly set for python bindings.



Contributors
------------

This is a list of people that contributed to this release (generated from the
git history using `git shortlog -ens --no-merges v2.3.68..v2.3.68.1`):

```
   145	Daniele E. Domenichelli <daniele.domenichelli@iit.it>
    44	Nicolò Genesio <nicolo.genesio@iit.it>
    15	Andrea Ruzzenenti <andrea.ruzzenenti@iit.it>
    13	Alberto Cardellino <alberto.cardellino@iit.it>
    12	Marco Randazzo <marco.randazzo@iit.it>
     9	Francesco Romano <francesco.romano@iit.it>
     7	Matteo Brunettini <matteo.brunettini@iit.it>
     6	Silvio Traversaro <silvio.traversaro@iit.it>
     5	Lorenzo Natale <lorenzo.natale@iit.it>
     4	Bartek Łukawski <bwmn.peter@gmail.com>
     3	Aiko Dinale <aiko.dinale@iit.it>
     2	Ali Paikan <ali.paikan@iit.it>
     2	Bertrand Higy <bertrand.higy@iit.it>
     2	Juan G. Victores <jcgvicto@gmail.com>
     1	Giovanni Saponaro <gsaponaro@isr.ist.utl.pt>
     1	Tobias Fischer <t.fischer@imperial.ac.uk>
     1	Ugo Pattacini <ugo.pattacini@iit.it>
     1	Vítor Galvão <info@vitorgalvao.com>
     1	Zero King <l2dy@icloud.com>
```
