"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.getSagemakerModel = void 0;
const s3a = require("@aws-cdk/aws-s3-assets");
const core_1 = require("@aws-cdk/core");
// linear learner ECR images can be found here:
// https://github.com/awsdocs/amazon-sagemaker-developer-guide/blob/master/doc_source/sagemaker-algo-docker-registry-paths.md
function getSagemakerModel(stack) {
    const containerMap = new core_1.CfnMapping(stack, 'mappings', {
        mapping: {
            "us-east-1": {
                containerArn: "382416733822.dkr.ecr.us-east-1.amazonaws.com/linear-learner:latest",
            },
            "us-east-2": {
                containerArn: "404615174143.dkr.ecr.us-east-2.amazonaws.com/linear-learner:latest",
            },
            "us-west-1": {
                containerArn: "632365934929.dkr.ecr.us-west-1.amazonaws.com/linear-learner:latest",
            },
            "us-west-2": {
                containerArn: "174872318107.dkr.ecr.us-west-2.amazonaws.com/linear-learner:latest",
            },
            "af-south-1": {
                containerArn: "455444449433.dkr.ecr.af-south-1.amazonaws.com/linear-learner:latest",
            },
            "ap-east-1": {
                containerArn: "286214385809.dkr.ecr.ap-east-1.amazonaws.com/linear-learner:latest",
            },
            "ap-south-1": {
                containerArn: "991648021394.dkr.ecr.ap-south-1.amazonaws.com/linear-learner:latest",
            },
            "ap-northeast-2": {
                containerArn: "835164637446.dkr.ecr.ap-northeast-2.amazonaws.com/linear-learner:latest",
            },
            "ap-southeast-1": {
                containerArn: "475088953585.dkr.ecr.ap-southeast-1.amazonaws.com/linear-learner:latest",
            },
            "ap-southeast-2": {
                containerArn: "712309505854.dkr.ecr.ap-southeast-2.amazonaws.com/linear-learner:latest",
            },
            "ap-northeast-1": {
                containerArn: "351501993468.dkr.ecr.ap-northeast-1.amazonaws.com/linear-learner:latest",
            },
            "ca-central-1": {
                containerArn: "469771592824.dkr.ecr.ca-central-1.amazonaws.com/linear-learner:latest",
            },
            "eu-central-1": {
                containerArn: "664544806723.dkr.ecr.eu-central-1.amazonaws.com/linear-learner:latest",
            },
            "eu-west-1": {
                containerArn: "438346466558.dkr.ecr.eu-west-1.amazonaws.com/linear-learner:latest",
            },
            "eu-west-2": {
                containerArn: "644912444149.dkr.ecr.eu-west-2.amazonaws.com/linear-learner:latest",
            },
            "eu-west-3": {
                containerArn: "749696950732.dkr.ecr.eu-west-3.amazonaws.com/linear-learner:latest",
            },
            "eu-north-1": {
                containerArn: "669576153137.dkr.ecr.eu-north-1.amazonaws.com/linear-learner:latest",
            },
            "eu-south-1": {
                containerArn: "257386234256.dkr.ecr.eu-south-1.amazonaws.com/linear-learner:latest",
            },
            "me-south-1": {
                containerArn: "249704162688.dkr.ecr.me-south-1.amazonaws.com/linear-learner:latest",
            },
            "sa-east-1": {
                containerArn: "855470959533.dkr.ecr.sa-east-1.amazonaws.com/linear-learner:latest",
            },
            "us-gov-west-1": {
                containerArn: "226302683700.dkr.ecr.us-gov-west-1.amazonaws.com/linear-learner:latest",
            },
        }
    });
    const modelAsset = new s3a.Asset(stack, 'SampleAsset', {
        path: 'model/model.tar.gz',
    });
    return [containerMap, modelAsset];
}
exports.getSagemakerModel = getSagemakerModel;
//# sourceMappingURL=data:application/json;base64,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