"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
const defaults = require("@aws-solutions-constructs/core");
const lambda = require("@aws-cdk/aws-lambda");
const test_helper_1 = require("./test-helper");
const core_2 = require("@aws-solutions-constructs/core");
// Setup
const app = new core_1.App();
const stack = new core_1.Stack(app, core_2.generateIntegStackName(__filename));
stack.templateOptions.description = 'Integration Test for aws-lambda-sagemakerendpoint';
const [containerMap, modelAsset] = test_helper_1.getSagemakerModel(stack);
const [sagemakerEndpoint, endpointConfig, model] = defaults.deploySagemakerEndpoint(stack, {
    modelProps: {
        primaryContainer: {
            image: containerMap.findInMap(core_1.Stack.of(stack).region, "containerArn"),
            modelDataUrl: modelAsset.s3ObjectUrl
        },
    },
});
sagemakerEndpoint.node.addDependency(modelAsset);
endpointConfig === null || endpointConfig === void 0 ? void 0 : endpointConfig.node.addDependency(modelAsset);
model === null || model === void 0 ? void 0 : model.node.addDependency(modelAsset);
const constructProps = {
    existingSagemakerEndpointObj: sagemakerEndpoint,
    lambdaFunctionProps: {
        runtime: lambda.Runtime.PYTHON_3_8,
        code: lambda.Code.fromAsset(`${__dirname}/lambda`),
        handler: 'index.handler',
        timeout: core_1.Duration.minutes(5),
        memorySize: 128,
    },
};
const lambdaToSagemakerConstruct = new lib_1.LambdaToSagemakerEndpoint(stack, 'test-lambda-sagemaker', constructProps);
lambdaToSagemakerConstruct.node.addDependency(modelAsset);
// Synth
app.synth();
//# sourceMappingURL=data:application/json;base64,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