"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
const defaults = require("@aws-solutions-constructs/core");
const lambda = require("@aws-cdk/aws-lambda");
const test_helper_1 = require("./test-helper");
const core_2 = require("@aws-solutions-constructs/core");
// Setup
const app = new core_1.App();
const stack = new core_1.Stack(app, core_2.generateIntegStackName(__filename));
stack.templateOptions.description = 'Integration Test for aws-lambda-sagemakerendpoint';
// deploy lambda function
const fn = defaults.deployLambdaFunction(stack, {
    runtime: lambda.Runtime.PYTHON_3_8,
    code: lambda.Code.fromAsset(`${__dirname}/lambda`),
    handler: 'index.handler',
    timeout: core_1.Duration.minutes(5),
    memorySize: 128,
});
const [containerMap, modelAsset] = test_helper_1.getSagemakerModel(stack);
const constructProps = {
    modelProps: {
        primaryContainer: {
            image: containerMap.findInMap(core_1.Stack.of(stack).region, "containerArn"),
            modelDataUrl: modelAsset.s3ObjectUrl
        },
    },
    existingLambdaObj: fn,
};
//   Fix names and construct IDs
const lambdaToSagemakerConstruct = new lib_1.LambdaToSagemakerEndpoint(stack, 'test-lambda-sagemaker', constructProps);
lambdaToSagemakerConstruct.node.addDependency(modelAsset);
// Synth
app.synth();
//# sourceMappingURL=data:application/json;base64,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