"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
const lambda = require("@aws-cdk/aws-lambda");
const test_helper_1 = require("./test-helper");
const core_2 = require("@aws-solutions-constructs/core");
// Setup
const app = new core_1.App();
const stack = new core_1.Stack(app, core_2.generateIntegStackName(__filename));
stack.templateOptions.description = 'Integration Test for aws-lambda-sagemakerendpoint';
const [containerMap, modelAsset] = test_helper_1.getSagemakerModel(stack);
const constructProps = {
    modelProps: {
        primaryContainer: {
            image: containerMap.findInMap(core_1.Stack.of(stack).region, "containerArn"),
            modelDataUrl: modelAsset.s3ObjectUrl
        },
    },
    lambdaFunctionProps: {
        runtime: lambda.Runtime.PYTHON_3_8,
        code: lambda.Code.fromAsset(`${__dirname}/lambda`),
        handler: 'index.handler',
        timeout: core_1.Duration.minutes(5),
        memorySize: 128,
    },
};
const lambdaToSagemakerConstruct = new lib_1.LambdaToSagemakerEndpoint(stack, 'test-lambda-sagemaker', constructProps);
lambdaToSagemakerConstruct.node.addDependency(modelAsset);
// Synth
app.synth();
//# sourceMappingURL=data:application/json;base64,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