/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import * as lambda from '@aws-cdk/aws-lambda';
import * as ec2 from '@aws-cdk/aws-ec2';
import * as sagemaker from '@aws-cdk/aws-sagemaker';
import { Construct } from '@aws-cdk/core';
/**
 * @summary The properties for the LambdaToSagemakerEndpoint class
 */
export interface LambdaToSagemakerEndpointProps {
    /**
     * Existing instance of Lambda Function object, Providing both this and lambdaFunctionProps will cause an error.
     *
     * @default - None
     */
    readonly existingLambdaObj?: lambda.Function;
    /**
     * User provided props to override the default props for the Lambda function
     *
     * @default - Default props are used
     */
    readonly lambdaFunctionProps?: lambda.FunctionProps;
    /**
     * Existing SageMaker Enpoint object, providing both this and endpointProps will cause an error.
     *
     * @default - None
     */
    readonly existingSagemakerEndpointObj?: sagemaker.CfnEndpoint;
    /**
     * User provided props to create SageMaker Model
     *
     * @default - None
     */
    readonly modelProps?: sagemaker.CfnModelProps | any;
    /**
     * User provided props to create SageMaker Endpoint Configuration
     *
     * @default - Default props are used
     */
    readonly endpointConfigProps?: sagemaker.CfnEndpointConfigProps;
    /**
     * User provided props to create SageMaker Endpoint
     *
     * @default - Default props are used
     */
    readonly endpointProps?: sagemaker.CfnEndpointProps;
    /**
     * An existing VPC for the construct to use (construct will NOT create a new VPC in this case)
     *
     * @default - None
     */
    readonly existingVpc?: ec2.IVpc;
    /**
     * Properties to override default properties if deployVpc is true
     *
     * @default - None
     */
    readonly vpcProps?: ec2.VpcProps;
    /**
     * Whether to deploy a new VPC
     *
     * @default - false
     */
    readonly deployVpc?: boolean;
    /**
     * Optional Name for the Lambda function environment variable set to the name of the SageMaker endpoint.
     *
     * @default - SAGEMAKER_ENDPOINT_NAME
     */
    readonly sagemakerEnvironmentVariableName?: string;
}
/**
 * @summary The LambdaToSagemakerEndpoint class.
 */
export declare class LambdaToSagemakerEndpoint extends Construct {
    readonly lambdaFunction: lambda.Function;
    readonly sagemakerEndpoint: sagemaker.CfnEndpoint;
    readonly sagemakerEndpointConfig?: sagemaker.CfnEndpointConfig;
    readonly sagemakerModel?: sagemaker.CfnModel;
    readonly vpc?: ec2.IVpc;
    /**
     * @summary Constructs a new instance of the LambdaToSagemakerEndpoint class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a scope-unique id.
     * @param {LambdaToSagemakerEndpointProps} props - user provided props for the construct.
     * @since 1.87.1
     * @access public
     */
    constructor(scope: Construct, id: string, props: LambdaToSagemakerEndpointProps);
}
