/* automatically generated by rust-bindgen 0.58.1 */

#[allow(non_snake_case, non_camel_case_types, non_upper_case_globals)]
pub mod root {
    #[repr(C)]
    #[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
    pub struct __BindgenBitfieldUnit<Storage> {
        storage: Storage,
    }
    impl<Storage> __BindgenBitfieldUnit<Storage> {
        #[inline]
        pub const fn new(storage: Storage) -> Self {
            Self { storage }
        }
    }
    impl<Storage> __BindgenBitfieldUnit<Storage>
    where
        Storage: AsRef<[u8]> + AsMut<[u8]>,
    {
        #[inline]
        pub fn get_bit(&self, index: usize) -> bool {
            debug_assert!(index / 8 < self.storage.as_ref().len());
            let byte_index = index / 8;
            let byte = self.storage.as_ref()[byte_index];
            let bit_index = if cfg!(target_endian = "big") {
                7 - (index % 8)
            } else {
                index % 8
            };
            let mask = 1 << bit_index;
            byte & mask == mask
        }
        #[inline]
        pub fn set_bit(&mut self, index: usize, val: bool) {
            debug_assert!(index / 8 < self.storage.as_ref().len());
            let byte_index = index / 8;
            let byte = &mut self.storage.as_mut()[byte_index];
            let bit_index = if cfg!(target_endian = "big") {
                7 - (index % 8)
            } else {
                index % 8
            };
            let mask = 1 << bit_index;
            if val {
                *byte |= mask;
            } else {
                *byte &= !mask;
            }
        }
        #[inline]
        pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
            debug_assert!(bit_width <= 64);
            debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
            debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
            let mut val = 0;
            for i in 0..(bit_width as usize) {
                if self.get_bit(i + bit_offset) {
                    let index = if cfg!(target_endian = "big") {
                        bit_width as usize - 1 - i
                    } else {
                        i
                    };
                    val |= 1 << index;
                }
            }
            val
        }
        #[inline]
        pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
            debug_assert!(bit_width <= 64);
            debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
            debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
            for i in 0..(bit_width as usize) {
                let mask = 1 << i;
                let val_bit_is_set = val & mask == mask;
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                self.set_bit(index + bit_offset, val_bit_is_set);
            }
        }
    }
    #[allow(unused_imports)]
    use self::super::root;
    pub type __int8_t = ::std::os::raw::c_schar;
    pub type __uint8_t = ::std::os::raw::c_uchar;
    pub type __uint16_t = ::std::os::raw::c_ushort;
    pub type __uint32_t = ::std::os::raw::c_uint;
    pub type __int64_t = ::std::os::raw::c_long;
    pub type __uint64_t = ::std::os::raw::c_ulong;
    pub mod std {
        #[allow(unused_imports)]
        use self::super::super::root;
        pub type string = [u64; 4usize];
        #[repr(C)]
        #[repr(align(1))]
        #[derive(Debug, Copy, Clone)]
        pub struct input_iterator_tag {
            pub _bindgen_opaque_blob: u8,
        }
        #[test]
        fn bindgen_test_layout_input_iterator_tag() {
            assert_eq!(
                ::std::mem::size_of::<input_iterator_tag>(),
                1usize,
                concat!("Size of: ", stringify!(input_iterator_tag))
            );
            assert_eq!(
                ::std::mem::align_of::<input_iterator_tag>(),
                1usize,
                concat!("Alignment of ", stringify!(input_iterator_tag))
            );
        }
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct reverse_iterator {
            pub _address: u8,
        }
        pub type reverse_iterator___traits_type = u8;
        pub type reverse_iterator_iterator_type = u8;
        pub type reverse_iterator_difference_type = u8;
        pub type reverse_iterator_pointer = u8;
        pub type reverse_iterator_reference = u8;
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct allocator {
            pub _address: u8,
        }
        pub type allocator_value_type = u8;
        pub type allocator_size_type = u64;
        pub type allocator_difference_type = u64;
        pub type allocator_pointer = u8;
        pub type allocator_const_pointer = u8;
        pub type allocator_reference = u8;
        pub type allocator_const_reference = u8;
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct allocator_rebind {
            pub _address: u8,
        }
        pub type allocator_rebind_other = u8;
        pub type allocator_propagate_on_container_move_assignment = u8;
        pub type allocator_is_always_equal = u8;
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct default_delete {
            pub _address: u8,
        }
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct unique_ptr {
            pub _address: u8,
        }
        pub type unique_ptr__DeleterConstraint = u8;
        pub type unique_ptr_pointer = u8;
        pub type unique_ptr_element_type = u8;
        pub type unique_ptr_deleter_type = u8;
        pub type unique_ptr___safe_conversion_up = u8;
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct vector {
            pub _address: u8,
        }
        pub type vector__Base = u8;
        pub type vector__Tp_alloc_type = u8;
        pub type vector__Alloc_traits = u8;
        pub type vector_value_type = u8;
        pub type vector_pointer = u8;
        pub type vector_const_pointer = u8;
        pub type vector_reference = u8;
        pub type vector_const_reference = u8;
        pub type vector_iterator = u8;
        pub type vector_const_iterator = u8;
        pub type vector_const_reverse_iterator = u8;
        pub type vector_reverse_iterator = u8;
        pub type vector_size_type = u64;
        pub type vector_difference_type = u64;
        pub type vector_allocator_type = u8;
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct vector__Temporary_value {
            pub _address: u8,
        }
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct atomic {
            pub _address: u8,
        }
        pub type atomic_value_type = u8;
        pub mod chrono {
            #[allow(unused_imports)]
            use self::super::super::super::root;
        }
    }
    pub mod __gnu_cxx {
        #[allow(unused_imports)]
        use self::super::super::root;
    }
    pub mod c10 {
        #[allow(unused_imports)]
        use self::super::super::root;
        pub mod detail {
            #[allow(unused_imports)]
            use self::super::super::super::root;
            #[repr(C)]
            #[derive(Debug)]
            pub struct UniqueVoidPtr {
                pub data_: *mut ::std::os::raw::c_void,
                pub ctx_: [u64; 2usize],
            }
            #[test]
            fn bindgen_test_layout_UniqueVoidPtr() {
                assert_eq!(
                    ::std::mem::size_of::<UniqueVoidPtr>(),
                    24usize,
                    concat!("Size of: ", stringify!(UniqueVoidPtr))
                );
                assert_eq!(
                    ::std::mem::align_of::<UniqueVoidPtr>(),
                    8usize,
                    concat!("Alignment of ", stringify!(UniqueVoidPtr))
                );
                assert_eq!(
                    unsafe { &(*(::std::ptr::null::<UniqueVoidPtr>())).data_ as *const _ as usize },
                    0usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(UniqueVoidPtr),
                        "::",
                        stringify!(data_)
                    )
                );
                assert_eq!(
                    unsafe { &(*(::std::ptr::null::<UniqueVoidPtr>())).ctx_ as *const _ as usize },
                    8usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(UniqueVoidPtr),
                        "::",
                        stringify!(ctx_)
                    )
                );
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct intrusive_target_default_null_type {
                pub _address: u8,
            }
        }
        pub mod guts {
            #[allow(unused_imports)]
            use self::super::super::super::root;
            pub mod typelist {
                #[allow(unused_imports)]
                use self::super::super::super::super::root;
            }
        }
        #[repr(i8)]
        #[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
        pub enum DeviceType {
            CPU = 0,
            CUDA = 1,
            MKLDNN = 2,
            OPENGL = 3,
            OPENCL = 4,
            IDEEP = 5,
            HIP = 6,
            FPGA = 7,
            MSNPU = 8,
            XLA = 9,
            Vulkan = 10,
            Metal = 11,
            XPU = 12,
            MLC = 13,
            Meta = 14,
            HPU = 15,
            COMPILE_TIME_MAX_DEVICE_TYPES = 16,
        }
        pub type DeviceIndex = i8;
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct Device {
            pub type_: root::c10::DeviceType,
            pub index_: root::c10::DeviceIndex,
        }
        pub use self::super::super::root::c10::DeviceType as Device_Type;
        #[test]
        fn bindgen_test_layout_Device() {
            assert_eq!(
                ::std::mem::size_of::<Device>(),
                2usize,
                concat!("Size of: ", stringify!(Device))
            );
            assert_eq!(
                ::std::mem::align_of::<Device>(),
                1usize,
                concat!("Alignment of ", stringify!(Device))
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<Device>())).type_ as *const _ as usize },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(Device),
                    "::",
                    stringify!(type_)
                )
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<Device>())).index_ as *const _ as usize },
                1usize,
                concat!(
                    "Offset of field: ",
                    stringify!(Device),
                    "::",
                    stringify!(index_)
                )
            );
        }
        extern "C" {
            #[link_name = "\u{1}_ZN3c106DeviceC1ERKNSt7__cxx1112basic_stringIcSt11char_traitsIcESaIcEEE"]
            pub fn Device_Device(
                this: *mut root::c10::Device,
                device_string: *const root::std::string,
            );
        }
        impl Device {
            #[inline]
            pub unsafe fn new(device_string: *const root::std::string) -> Self {
                let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
                Device_Device(__bindgen_tmp.as_mut_ptr(), device_string);
                __bindgen_tmp.assume_init()
            }
        }
        pub type DeleterFnPtr =
            ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>;
        #[repr(C)]
        #[derive(Debug)]
        pub struct DataPtr {
            pub ptr_: root::c10::detail::UniqueVoidPtr,
            pub device_: root::c10::Device,
        }
        #[test]
        fn bindgen_test_layout_DataPtr() {
            assert_eq!(
                ::std::mem::size_of::<DataPtr>(),
                32usize,
                concat!("Size of: ", stringify!(DataPtr))
            );
            assert_eq!(
                ::std::mem::align_of::<DataPtr>(),
                8usize,
                concat!("Alignment of ", stringify!(DataPtr))
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<DataPtr>())).ptr_ as *const _ as usize },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(DataPtr),
                    "::",
                    stringify!(ptr_)
                )
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<DataPtr>())).device_ as *const _ as usize },
                24usize,
                concat!(
                    "Offset of field: ",
                    stringify!(DataPtr),
                    "::",
                    stringify!(device_)
                )
            );
        }
        #[repr(C)]
        pub struct Allocator__bindgen_vtable(::std::os::raw::c_void);
        #[repr(C)]
        #[derive(Debug)]
        pub struct Allocator {
            pub vtable_: *const Allocator__bindgen_vtable,
        }
        #[test]
        fn bindgen_test_layout_Allocator() {
            assert_eq!(
                ::std::mem::size_of::<Allocator>(),
                8usize,
                concat!("Size of: ", stringify!(Allocator))
            );
            assert_eq!(
                ::std::mem::align_of::<Allocator>(),
                8usize,
                concat!("Alignment of ", stringify!(Allocator))
            );
        }
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct ArrayRef<T> {
            pub Data: *const T,
            pub Length: root::c10::ArrayRef_size_type,
            pub _phantom_0: ::std::marker::PhantomData<::std::cell::UnsafeCell<T>>,
        }
        pub type ArrayRef_iterator<T> = *const T;
        pub type ArrayRef_const_iterator<T> = *const T;
        pub type ArrayRef_size_type = usize;
        pub type ArrayRef_value_type<T> = T;
        pub type ArrayRef_reverse_iterator = u8;
        pub type IntArrayRef = root::c10::ArrayRef<i64>;
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct optional {
            pub _address: u8,
        }
        pub type optional_OptionalBase = u8;
        pub type optional_value_type = u8;
        pub mod impl_ {
            #[allow(unused_imports)]
            use self::super::super::super::root;
            #[repr(C)]
            pub struct SizesAndStrides {
                pub size_: usize,
                pub __bindgen_anon_1: root::c10::impl_::SizesAndStrides__bindgen_ty_1,
            }
            pub type SizesAndStrides_sizes_iterator = *mut i64;
            pub type SizesAndStrides_sizes_const_iterator = *const i64;
            pub type SizesAndStrides_strides_iterator = *mut i64;
            pub type SizesAndStrides_strides_const_iterator = *const i64;
            #[repr(C)]
            #[derive(Copy, Clone)]
            pub union SizesAndStrides__bindgen_ty_1 {
                pub outOfLineStorage_: *mut i64,
                pub inlineStorage_: [i64; 10usize],
            }
            #[test]
            fn bindgen_test_layout_SizesAndStrides__bindgen_ty_1() {
                assert_eq!(
                    ::std::mem::size_of::<SizesAndStrides__bindgen_ty_1>(),
                    80usize,
                    concat!("Size of: ", stringify!(SizesAndStrides__bindgen_ty_1))
                );
                assert_eq!(
                    ::std::mem::align_of::<SizesAndStrides__bindgen_ty_1>(),
                    8usize,
                    concat!("Alignment of ", stringify!(SizesAndStrides__bindgen_ty_1))
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<SizesAndStrides__bindgen_ty_1>())).outOfLineStorage_
                            as *const _ as usize
                    },
                    0usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(SizesAndStrides__bindgen_ty_1),
                        "::",
                        stringify!(outOfLineStorage_)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<SizesAndStrides__bindgen_ty_1>())).inlineStorage_
                            as *const _ as usize
                    },
                    0usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(SizesAndStrides__bindgen_ty_1),
                        "::",
                        stringify!(inlineStorage_)
                    )
                );
            }
            #[test]
            fn bindgen_test_layout_SizesAndStrides() {
                assert_eq!(
                    ::std::mem::size_of::<SizesAndStrides>(),
                    88usize,
                    concat!("Size of: ", stringify!(SizesAndStrides))
                );
                assert_eq!(
                    ::std::mem::align_of::<SizesAndStrides>(),
                    8usize,
                    concat!("Alignment of ", stringify!(SizesAndStrides))
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<SizesAndStrides>())).size_ as *const _ as usize
                    },
                    0usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(SizesAndStrides),
                        "::",
                        stringify!(size_)
                    )
                );
            }
        }
        pub mod raw {
            #[allow(unused_imports)]
            use self::super::super::super::root;
        }
        #[repr(C)]
        pub struct intrusive_ptr_target__bindgen_vtable(::std::os::raw::c_void);
        #[repr(C)]
        #[derive(Debug)]
        pub struct intrusive_ptr_target {
            pub vtable_: *const intrusive_ptr_target__bindgen_vtable,
            pub refcount_: u64,
            pub weakcount_: u64,
        }
        #[test]
        fn bindgen_test_layout_intrusive_ptr_target() {
            assert_eq!(
                ::std::mem::size_of::<intrusive_ptr_target>(),
                24usize,
                concat!("Size of: ", stringify!(intrusive_ptr_target))
            );
            assert_eq!(
                ::std::mem::align_of::<intrusive_ptr_target>(),
                8usize,
                concat!("Alignment of ", stringify!(intrusive_ptr_target))
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<intrusive_ptr_target>())).refcount_ as *const _ as usize
                },
                8usize,
                concat!(
                    "Offset of field: ",
                    stringify!(intrusive_ptr_target),
                    "::",
                    stringify!(refcount_)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<intrusive_ptr_target>())).weakcount_ as *const _ as usize
                },
                16usize,
                concat!(
                    "Offset of field: ",
                    stringify!(intrusive_ptr_target),
                    "::",
                    stringify!(weakcount_)
                )
            );
        }
        #[repr(C)]
        #[derive(Debug)]
        pub struct intrusive_ptr<TTarget> {
            pub target_: *mut TTarget,
            pub _phantom_0: ::std::marker::PhantomData<::std::cell::UnsafeCell<TTarget>>,
        }
        pub type intrusive_ptr_element_type<TTarget> = TTarget;
        #[repr(C)]
        #[derive(Debug)]
        pub struct StorageImpl {
            pub _base: root::c10::intrusive_ptr_target,
            pub data_ptr_: root::c10::DataPtr,
            pub size_bytes_: usize,
            pub resizable_: bool,
            pub received_cuda_: bool,
            pub allocator_: *mut root::c10::Allocator,
        }
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct StorageImpl_use_byte_size_t {
            pub _address: u8,
        }
        #[test]
        fn bindgen_test_layout_StorageImpl_use_byte_size_t() {
            assert_eq!(
                ::std::mem::size_of::<StorageImpl_use_byte_size_t>(),
                1usize,
                concat!("Size of: ", stringify!(StorageImpl_use_byte_size_t))
            );
            assert_eq!(
                ::std::mem::align_of::<StorageImpl_use_byte_size_t>(),
                1usize,
                concat!("Alignment of ", stringify!(StorageImpl_use_byte_size_t))
            );
        }
        #[test]
        fn bindgen_test_layout_StorageImpl() {
            assert_eq!(
                ::std::mem::size_of::<StorageImpl>(),
                80usize,
                concat!("Size of: ", stringify!(StorageImpl))
            );
            assert_eq!(
                ::std::mem::align_of::<StorageImpl>(),
                8usize,
                concat!("Alignment of ", stringify!(StorageImpl))
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<StorageImpl>())).data_ptr_ as *const _ as usize },
                24usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StorageImpl),
                    "::",
                    stringify!(data_ptr_)
                )
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<StorageImpl>())).size_bytes_ as *const _ as usize },
                56usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StorageImpl),
                    "::",
                    stringify!(size_bytes_)
                )
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<StorageImpl>())).resizable_ as *const _ as usize },
                64usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StorageImpl),
                    "::",
                    stringify!(resizable_)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<StorageImpl>())).received_cuda_ as *const _ as usize
                },
                65usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StorageImpl),
                    "::",
                    stringify!(received_cuda_)
                )
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<StorageImpl>())).allocator_ as *const _ as usize },
                72usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StorageImpl),
                    "::",
                    stringify!(allocator_)
                )
            );
        }
        impl root::c10::DispatchKey {
            pub const CatchAll: root::c10::DispatchKey = DispatchKey::Undefined;
        }
        impl root::c10::DispatchKey {
            pub const EndOfBackendKeys: root::c10::DispatchKey = DispatchKey::PrivateUse3;
        }
        impl root::c10::DispatchKey {
            pub const EndOfAliasKeys: root::c10::DispatchKey =
                DispatchKey::CompositeExplicitAutograd;
        }
        impl root::c10::DispatchKey {
            pub const CPUTensorId: root::c10::DispatchKey = DispatchKey::CPU;
        }
        impl root::c10::DispatchKey {
            pub const CUDATensorId: root::c10::DispatchKey = DispatchKey::CUDA;
        }
        impl root::c10::DispatchKey {
            pub const DefaultBackend: root::c10::DispatchKey =
                DispatchKey::CompositeExplicitAutograd;
        }
        impl root::c10::DispatchKey {
            pub const PrivateUse1_PreAutograd: root::c10::DispatchKey =
                DispatchKey::AutogradPrivateUse1;
        }
        impl root::c10::DispatchKey {
            pub const PrivateUse2_PreAutograd: root::c10::DispatchKey =
                DispatchKey::AutogradPrivateUse2;
        }
        impl root::c10::DispatchKey {
            pub const PrivateUse3_PreAutograd: root::c10::DispatchKey =
                DispatchKey::AutogradPrivateUse3;
        }
        impl root::c10::DispatchKey {
            pub const Autocast: root::c10::DispatchKey = DispatchKey::AutocastCUDA;
        }
        #[repr(u8)]
        #[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
        pub enum DispatchKey {
            Undefined = 0,
            CPU = 1,
            CUDA = 2,
            HIP = 3,
            FPGA = 4,
            MSNPU = 5,
            XLA = 6,
            MLC = 7,
            Vulkan = 8,
            Metal = 9,
            XPU = 10,
            HPU = 11,
            Meta = 12,
            QuantizedCPU = 13,
            QuantizedCUDA = 14,
            QuantizedXPU = 15,
            CustomRNGKeyId = 16,
            MkldnnCPU = 17,
            SparseCPU = 18,
            SparseCUDA = 19,
            SparseHIP = 20,
            SparseXPU = 21,
            SparseCsrCPU = 22,
            SparseCsrCUDA = 23,
            NestedTensor = 24,
            PrivateUse1 = 25,
            PrivateUse2 = 26,
            PrivateUse3 = 27,
            BackendSelect = 28,
            FuncTorchPython = 29,
            Named = 30,
            FuncTorchDynamicLayerBackMode = 31,
            ADInplaceOrView = 32,
            AutogradOther = 33,
            AutogradCPU = 34,
            AutogradCUDA = 35,
            AutogradXLA = 36,
            AutogradXPU = 37,
            AutogradMLC = 38,
            AutogradHPU = 39,
            AutogradNestedTensor = 40,
            AutogradPrivateUse1 = 41,
            AutogradPrivateUse2 = 42,
            AutogradPrivateUse3 = 43,
            Tracer = 44,
            AutocastCUDA = 45,
            FuncTorchBatched = 46,
            FuncTorchVmapMode = 47,
            Batched = 48,
            VmapMode = 49,
            FuncTorchGradWrapper = 50,
            FuncTorchDynamicLayerFrontMode = 51,
            TESTING_ONLY_GenericWrapper = 52,
            TESTING_ONLY_GenericMode = 53,
            NumDispatchKeys = 54,
            Autograd = 55,
            CompositeImplicitAutograd = 56,
            CompositeExplicitAutograd = 57,
        }
        pub mod llvm {
            #[allow(unused_imports)]
            use self::super::super::super::root;
        }
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct DispatchKeySet {
            pub repr_: u64,
        }
        #[repr(u32)]
        #[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
        pub enum DispatchKeySet_Full {
            FULL = 0,
        }
        #[repr(u32)]
        #[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
        pub enum DispatchKeySet_FullAfter {
            FULL_AFTER = 0,
        }
        #[repr(u32)]
        #[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
        pub enum DispatchKeySet_Raw {
            RAW = 0,
        }
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct DispatchKeySet_iterator {
            pub data_ptr_: *const u64,
            pub i_: u8,
        }
        pub type DispatchKeySet_iterator_self_type = root::c10::DispatchKeySet_iterator;
        pub type DispatchKeySet_iterator_iterator_category = root::std::input_iterator_tag;
        pub use self::super::super::root::c10::DispatchKey as DispatchKeySet_iterator_value_type;
        pub type DispatchKeySet_iterator_difference_type = isize;
        #[test]
        fn bindgen_test_layout_DispatchKeySet_iterator() {
            assert_eq!(
                ::std::mem::size_of::<DispatchKeySet_iterator>(),
                16usize,
                concat!("Size of: ", stringify!(DispatchKeySet_iterator))
            );
            assert_eq!(
                ::std::mem::align_of::<DispatchKeySet_iterator>(),
                8usize,
                concat!("Alignment of ", stringify!(DispatchKeySet_iterator))
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<DispatchKeySet_iterator>())).data_ptr_ as *const _
                        as usize
                },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(DispatchKeySet_iterator),
                    "::",
                    stringify!(data_ptr_)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<DispatchKeySet_iterator>())).i_ as *const _ as usize
                },
                8usize,
                concat!(
                    "Offset of field: ",
                    stringify!(DispatchKeySet_iterator),
                    "::",
                    stringify!(i_)
                )
            );
        }
        #[test]
        fn bindgen_test_layout_DispatchKeySet() {
            assert_eq!(
                ::std::mem::size_of::<DispatchKeySet>(),
                8usize,
                concat!("Size of: ", stringify!(DispatchKeySet))
            );
            assert_eq!(
                ::std::mem::align_of::<DispatchKeySet>(),
                8usize,
                concat!("Alignment of ", stringify!(DispatchKeySet))
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<DispatchKeySet>())).repr_ as *const _ as usize },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(DispatchKeySet),
                    "::",
                    stringify!(repr_)
                )
            );
        }
        #[repr(i8)]
        #[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
        pub enum Layout {
            Strided = 0,
            Sparse = 1,
            SparseCsr = 2,
            Mkldnn = 3,
            NumOptions = 4,
        }
        #[repr(i8)]
        #[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
        pub enum MemoryFormat {
            Contiguous = 0,
            Preserve = 1,
            ChannelsLast = 2,
            ChannelsLast3d = 3,
        }
        pub mod util {
            #[allow(unused_imports)]
            use self::super::super::super::root;
        }
        #[repr(C)]
        #[derive(Debug)]
        pub struct Storage {
            pub storage_impl_: root::c10::intrusive_ptr<root::c10::StorageImpl>,
        }
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct Storage_use_byte_size_t {
            pub _address: u8,
        }
        #[test]
        fn bindgen_test_layout_Storage_use_byte_size_t() {
            assert_eq!(
                ::std::mem::size_of::<Storage_use_byte_size_t>(),
                1usize,
                concat!("Size of: ", stringify!(Storage_use_byte_size_t))
            );
            assert_eq!(
                ::std::mem::align_of::<Storage_use_byte_size_t>(),
                1usize,
                concat!("Alignment of ", stringify!(Storage_use_byte_size_t))
            );
        }
        #[test]
        fn bindgen_test_layout_Storage() {
            assert_eq!(
                ::std::mem::size_of::<Storage>(),
                8usize,
                concat!("Size of: ", stringify!(Storage))
            );
            assert_eq!(
                ::std::mem::align_of::<Storage>(),
                8usize,
                concat!("Alignment of ", stringify!(Storage))
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<Storage>())).storage_impl_ as *const _ as usize },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(Storage),
                    "::",
                    stringify!(storage_impl_)
                )
            );
        }
        #[repr(C)]
        pub struct AutogradMetaInterface__bindgen_vtable(::std::os::raw::c_void);
        #[repr(C)]
        #[derive(Debug)]
        pub struct AutogradMetaInterface {
            pub vtable_: *const AutogradMetaInterface__bindgen_vtable,
        }
        #[test]
        fn bindgen_test_layout_AutogradMetaInterface() {
            assert_eq!(
                ::std::mem::size_of::<AutogradMetaInterface>(),
                8usize,
                concat!("Size of: ", stringify!(AutogradMetaInterface))
            );
            assert_eq!(
                ::std::mem::align_of::<AutogradMetaInterface>(),
                8usize,
                concat!("Alignment of ", stringify!(AutogradMetaInterface))
            );
        }
        extern "C" {
            #[link_name = "\u{1}_ZN3c1021AutogradMetaInterfaceD1Ev"]
            pub fn AutogradMetaInterface_AutogradMetaInterface_destructor(
                this: *mut root::c10::AutogradMetaInterface,
            );
        }
        #[repr(C)]
        pub struct NamedTensorMetaInterface__bindgen_vtable(::std::os::raw::c_void);
        #[repr(C)]
        #[derive(Debug)]
        pub struct NamedTensorMetaInterface {
            pub vtable_: *const NamedTensorMetaInterface__bindgen_vtable,
        }
        #[test]
        fn bindgen_test_layout_NamedTensorMetaInterface() {
            assert_eq!(
                ::std::mem::size_of::<NamedTensorMetaInterface>(),
                8usize,
                concat!("Size of: ", stringify!(NamedTensorMetaInterface))
            );
            assert_eq!(
                ::std::mem::align_of::<NamedTensorMetaInterface>(),
                8usize,
                concat!("Alignment of ", stringify!(NamedTensorMetaInterface))
            );
        }
        #[repr(C)]
        #[derive(Debug)]
        pub struct VariableVersion {
            pub version_counter_:
                root::c10::intrusive_ptr<root::c10::VariableVersion_VersionCounter>,
        }
        #[repr(C)]
        #[derive(Debug)]
        pub struct VariableVersion_VersionCounter {
            pub _base: root::c10::intrusive_ptr_target,
            pub version_: u32,
        }
        #[test]
        fn bindgen_test_layout_VariableVersion_VersionCounter() {
            assert_eq!(
                ::std::mem::size_of::<VariableVersion_VersionCounter>(),
                32usize,
                concat!("Size of: ", stringify!(VariableVersion_VersionCounter))
            );
            assert_eq!(
                ::std::mem::align_of::<VariableVersion_VersionCounter>(),
                8usize,
                concat!("Alignment of ", stringify!(VariableVersion_VersionCounter))
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<VariableVersion_VersionCounter>())).version_ as *const _
                        as usize
                },
                24usize,
                concat!(
                    "Offset of field: ",
                    stringify!(VariableVersion_VersionCounter),
                    "::",
                    stringify!(version_)
                )
            );
        }
        #[repr(u32)]
        #[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
        pub enum VariableVersion_Disabled {
            DISABLED = 0,
        }
        #[test]
        fn bindgen_test_layout_VariableVersion() {
            assert_eq!(
                ::std::mem::size_of::<VariableVersion>(),
                8usize,
                concat!("Size of: ", stringify!(VariableVersion))
            );
            assert_eq!(
                ::std::mem::align_of::<VariableVersion>(),
                8usize,
                concat!("Alignment of ", stringify!(VariableVersion))
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<VariableVersion>())).version_counter_ as *const _
                        as usize
                },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(VariableVersion),
                    "::",
                    stringify!(version_counter_)
                )
            );
        }
        #[repr(C)]
        pub struct TensorImpl {
            pub _base: root::c10::intrusive_ptr_target,
            pub storage_: root::c10::Storage,
            pub autograd_meta_: u64,
            pub named_tensor_meta_: u64,
            pub version_counter_: root::c10::VariableVersion,
            pub pyobj_: *mut root::PyObject,
            pub sizes_and_strides_: root::c10::impl_::SizesAndStrides,
            pub storage_offset_: i64,
            pub numel_: i64,
            pub data_type_: root::caffe2::TypeMeta,
            pub device_opt_: [u8; 3usize],
            pub _bitfield_align_1: [u8; 0],
            pub _bitfield_1: root::__BindgenBitfieldUnit<[u8; 1usize]>,
            pub storage_access_should_throw_: bool,
            pub _bitfield_align_2: [u8; 0],
            pub _bitfield_2: root::__BindgenBitfieldUnit<[u8; 1usize]>,
            pub key_set_: root::c10::DispatchKeySet,
        }
        #[repr(u32)]
        #[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
        pub enum TensorImpl_ImplType {
            VIEW = 0,
        }
        #[repr(u8)]
        #[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
        pub enum TensorImpl_HasContiguityPolicy {
            Default = 0,
            ContiguityNotSupported = 1,
            CustomBehavior = 2,
        }
        extern "C" {
            #[link_name = "\u{1}_ZN3c1010TensorImpl42err_msg_tensor_metadata_change_not_allowedE"]
            pub static TensorImpl_err_msg_tensor_metadata_change_not_allowed:
                *const ::std::os::raw::c_char;
        }
        #[test]
        fn bindgen_test_layout_TensorImpl() {
            assert_eq!(
                ::std::mem::size_of::<TensorImpl>(),
                184usize,
                concat!("Size of: ", stringify!(TensorImpl))
            );
            assert_eq!(
                ::std::mem::align_of::<TensorImpl>(),
                8usize,
                concat!("Alignment of ", stringify!(TensorImpl))
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<TensorImpl>())).storage_ as *const _ as usize },
                24usize,
                concat!(
                    "Offset of field: ",
                    stringify!(TensorImpl),
                    "::",
                    stringify!(storage_)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<TensorImpl>())).autograd_meta_ as *const _ as usize
                },
                32usize,
                concat!(
                    "Offset of field: ",
                    stringify!(TensorImpl),
                    "::",
                    stringify!(autograd_meta_)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<TensorImpl>())).named_tensor_meta_ as *const _ as usize
                },
                40usize,
                concat!(
                    "Offset of field: ",
                    stringify!(TensorImpl),
                    "::",
                    stringify!(named_tensor_meta_)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<TensorImpl>())).version_counter_ as *const _ as usize
                },
                48usize,
                concat!(
                    "Offset of field: ",
                    stringify!(TensorImpl),
                    "::",
                    stringify!(version_counter_)
                )
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<TensorImpl>())).pyobj_ as *const _ as usize },
                56usize,
                concat!(
                    "Offset of field: ",
                    stringify!(TensorImpl),
                    "::",
                    stringify!(pyobj_)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<TensorImpl>())).sizes_and_strides_ as *const _ as usize
                },
                64usize,
                concat!(
                    "Offset of field: ",
                    stringify!(TensorImpl),
                    "::",
                    stringify!(sizes_and_strides_)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<TensorImpl>())).storage_offset_ as *const _ as usize
                },
                152usize,
                concat!(
                    "Offset of field: ",
                    stringify!(TensorImpl),
                    "::",
                    stringify!(storage_offset_)
                )
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<TensorImpl>())).numel_ as *const _ as usize },
                160usize,
                concat!(
                    "Offset of field: ",
                    stringify!(TensorImpl),
                    "::",
                    stringify!(numel_)
                )
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<TensorImpl>())).data_type_ as *const _ as usize },
                168usize,
                concat!(
                    "Offset of field: ",
                    stringify!(TensorImpl),
                    "::",
                    stringify!(data_type_)
                )
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<TensorImpl>())).device_opt_ as *const _ as usize },
                170usize,
                concat!(
                    "Offset of field: ",
                    stringify!(TensorImpl),
                    "::",
                    stringify!(device_opt_)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<TensorImpl>())).storage_access_should_throw_ as *const _
                        as usize
                },
                174usize,
                concat!(
                    "Offset of field: ",
                    stringify!(TensorImpl),
                    "::",
                    stringify!(storage_access_should_throw_)
                )
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<TensorImpl>())).key_set_ as *const _ as usize },
                176usize,
                concat!(
                    "Offset of field: ",
                    stringify!(TensorImpl),
                    "::",
                    stringify!(key_set_)
                )
            );
        }
        extern "C" {
            #[link_name = "\u{1}_ZN3c1010TensorImplC1EONS_7StorageENS_14DispatchKeySetEN6caffe28TypeMetaE"]
            pub fn TensorImpl_TensorImpl(
                this: *mut root::c10::TensorImpl,
                storage: *mut root::c10::Storage,
                arg1: root::c10::DispatchKeySet,
                data_type: root::caffe2::TypeMeta,
            );
        }
        extern "C" {
            #[link_name = "\u{1}_ZN3c1010TensorImplC1ENS0_8ImplTypeEONS_7StorageENS_14DispatchKeySetEN6caffe28TypeMetaE"]
            pub fn TensorImpl_TensorImpl1(
                this: *mut root::c10::TensorImpl,
                arg1: root::c10::TensorImpl_ImplType,
                storage: *mut root::c10::Storage,
                arg2: root::c10::DispatchKeySet,
                data_type: root::caffe2::TypeMeta,
            );
        }
        extern "C" {
            #[link_name = "\u{1}_ZN3c1010TensorImplC1ENS_14DispatchKeySetEN6caffe28TypeMetaENS_8optionalINS_6DeviceEEE"]
            pub fn TensorImpl_TensorImpl2(
                this: *mut root::c10::TensorImpl,
                arg1: root::c10::DispatchKeySet,
                data_type: root::caffe2::TypeMeta,
                device_opt: [u8; 3usize],
            );
        }
        impl TensorImpl {
            #[inline]
            pub fn is_contiguous_(&self) -> bool {
                unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u8) }
            }
            #[inline]
            pub fn set_is_contiguous_(&mut self, val: bool) {
                unsafe {
                    let val: u8 = ::std::mem::transmute(val);
                    self._bitfield_1.set(0usize, 1u8, val as u64)
                }
            }
            #[inline]
            pub fn has_contiguity_(&self) -> u8 {
                unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 2u8) as u8) }
            }
            #[inline]
            pub fn set_has_contiguity_(&mut self, val: u8) {
                unsafe {
                    let val: u8 = ::std::mem::transmute(val);
                    self._bitfield_1.set(1usize, 2u8, val as u64)
                }
            }
            #[inline]
            pub fn new_bitfield_1(
                is_contiguous_: bool,
                has_contiguity_: u8,
            ) -> root::__BindgenBitfieldUnit<[u8; 1usize]> {
                let mut __bindgen_bitfield_unit: root::__BindgenBitfieldUnit<[u8; 1usize]> =
                    Default::default();
                __bindgen_bitfield_unit.set(0usize, 1u8, {
                    let is_contiguous_: u8 = unsafe { ::std::mem::transmute(is_contiguous_) };
                    is_contiguous_ as u64
                });
                __bindgen_bitfield_unit.set(1usize, 2u8, {
                    let has_contiguity_: u8 = unsafe { ::std::mem::transmute(has_contiguity_) };
                    has_contiguity_ as u64
                });
                __bindgen_bitfield_unit
            }
            #[inline]
            pub fn is_channels_last_(&self) -> bool {
                unsafe { ::std::mem::transmute(self._bitfield_2.get(0usize, 1u8) as u8) }
            }
            #[inline]
            pub fn set_is_channels_last_(&mut self, val: bool) {
                unsafe {
                    let val: u8 = ::std::mem::transmute(val);
                    self._bitfield_2.set(0usize, 1u8, val as u64)
                }
            }
            #[inline]
            pub fn is_channels_last_contiguous_(&self) -> bool {
                unsafe { ::std::mem::transmute(self._bitfield_2.get(1usize, 1u8) as u8) }
            }
            #[inline]
            pub fn set_is_channels_last_contiguous_(&mut self, val: bool) {
                unsafe {
                    let val: u8 = ::std::mem::transmute(val);
                    self._bitfield_2.set(1usize, 1u8, val as u64)
                }
            }
            #[inline]
            pub fn is_channels_last_3d_(&self) -> bool {
                unsafe { ::std::mem::transmute(self._bitfield_2.get(2usize, 1u8) as u8) }
            }
            #[inline]
            pub fn set_is_channels_last_3d_(&mut self, val: bool) {
                unsafe {
                    let val: u8 = ::std::mem::transmute(val);
                    self._bitfield_2.set(2usize, 1u8, val as u64)
                }
            }
            #[inline]
            pub fn is_channels_last_3d_contiguous_(&self) -> bool {
                unsafe { ::std::mem::transmute(self._bitfield_2.get(3usize, 1u8) as u8) }
            }
            #[inline]
            pub fn set_is_channels_last_3d_contiguous_(&mut self, val: bool) {
                unsafe {
                    let val: u8 = ::std::mem::transmute(val);
                    self._bitfield_2.set(3usize, 1u8, val as u64)
                }
            }
            #[inline]
            pub fn is_non_overlapping_and_dense_(&self) -> bool {
                unsafe { ::std::mem::transmute(self._bitfield_2.get(4usize, 1u8) as u8) }
            }
            #[inline]
            pub fn set_is_non_overlapping_and_dense_(&mut self, val: bool) {
                unsafe {
                    let val: u8 = ::std::mem::transmute(val);
                    self._bitfield_2.set(4usize, 1u8, val as u64)
                }
            }
            #[inline]
            pub fn is_wrapped_number_(&self) -> bool {
                unsafe { ::std::mem::transmute(self._bitfield_2.get(5usize, 1u8) as u8) }
            }
            #[inline]
            pub fn set_is_wrapped_number_(&mut self, val: bool) {
                unsafe {
                    let val: u8 = ::std::mem::transmute(val);
                    self._bitfield_2.set(5usize, 1u8, val as u64)
                }
            }
            #[inline]
            pub fn allow_tensor_metadata_change_(&self) -> bool {
                unsafe { ::std::mem::transmute(self._bitfield_2.get(6usize, 1u8) as u8) }
            }
            #[inline]
            pub fn set_allow_tensor_metadata_change_(&mut self, val: bool) {
                unsafe {
                    let val: u8 = ::std::mem::transmute(val);
                    self._bitfield_2.set(6usize, 1u8, val as u64)
                }
            }
            #[inline]
            pub fn reserved_(&self) -> bool {
                unsafe { ::std::mem::transmute(self._bitfield_2.get(7usize, 1u8) as u8) }
            }
            #[inline]
            pub fn set_reserved_(&mut self, val: bool) {
                unsafe {
                    let val: u8 = ::std::mem::transmute(val);
                    self._bitfield_2.set(7usize, 1u8, val as u64)
                }
            }
            #[inline]
            pub fn new_bitfield_2(
                is_channels_last_: bool,
                is_channels_last_contiguous_: bool,
                is_channels_last_3d_: bool,
                is_channels_last_3d_contiguous_: bool,
                is_non_overlapping_and_dense_: bool,
                is_wrapped_number_: bool,
                allow_tensor_metadata_change_: bool,
                reserved_: bool,
            ) -> root::__BindgenBitfieldUnit<[u8; 1usize]> {
                let mut __bindgen_bitfield_unit: root::__BindgenBitfieldUnit<[u8; 1usize]> =
                    Default::default();
                __bindgen_bitfield_unit.set(0usize, 1u8, {
                    let is_channels_last_: u8 = unsafe { ::std::mem::transmute(is_channels_last_) };
                    is_channels_last_ as u64
                });
                __bindgen_bitfield_unit.set(1usize, 1u8, {
                    let is_channels_last_contiguous_: u8 =
                        unsafe { ::std::mem::transmute(is_channels_last_contiguous_) };
                    is_channels_last_contiguous_ as u64
                });
                __bindgen_bitfield_unit.set(2usize, 1u8, {
                    let is_channels_last_3d_: u8 =
                        unsafe { ::std::mem::transmute(is_channels_last_3d_) };
                    is_channels_last_3d_ as u64
                });
                __bindgen_bitfield_unit.set(3usize, 1u8, {
                    let is_channels_last_3d_contiguous_: u8 =
                        unsafe { ::std::mem::transmute(is_channels_last_3d_contiguous_) };
                    is_channels_last_3d_contiguous_ as u64
                });
                __bindgen_bitfield_unit.set(4usize, 1u8, {
                    let is_non_overlapping_and_dense_: u8 =
                        unsafe { ::std::mem::transmute(is_non_overlapping_and_dense_) };
                    is_non_overlapping_and_dense_ as u64
                });
                __bindgen_bitfield_unit.set(5usize, 1u8, {
                    let is_wrapped_number_: u8 =
                        unsafe { ::std::mem::transmute(is_wrapped_number_) };
                    is_wrapped_number_ as u64
                });
                __bindgen_bitfield_unit.set(6usize, 1u8, {
                    let allow_tensor_metadata_change_: u8 =
                        unsafe { ::std::mem::transmute(allow_tensor_metadata_change_) };
                    allow_tensor_metadata_change_ as u64
                });
                __bindgen_bitfield_unit.set(7usize, 1u8, {
                    let reserved_: u8 = unsafe { ::std::mem::transmute(reserved_) };
                    reserved_ as u64
                });
                __bindgen_bitfield_unit
            }
            #[inline]
            pub unsafe fn new(
                storage: *mut root::c10::Storage,
                arg1: root::c10::DispatchKeySet,
                data_type: root::caffe2::TypeMeta,
            ) -> Self {
                let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
                TensorImpl_TensorImpl(__bindgen_tmp.as_mut_ptr(), storage, arg1, data_type);
                __bindgen_tmp.assume_init()
            }
            #[inline]
            pub unsafe fn new1(
                arg1: root::c10::TensorImpl_ImplType,
                storage: *mut root::c10::Storage,
                arg2: root::c10::DispatchKeySet,
                data_type: root::caffe2::TypeMeta,
            ) -> Self {
                let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
                TensorImpl_TensorImpl1(__bindgen_tmp.as_mut_ptr(), arg1, storage, arg2, data_type);
                __bindgen_tmp.assume_init()
            }
            #[inline]
            pub unsafe fn new2(
                arg1: root::c10::DispatchKeySet,
                data_type: root::caffe2::TypeMeta,
                device_opt: [u8; 3usize],
            ) -> Self {
                let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
                TensorImpl_TensorImpl2(__bindgen_tmp.as_mut_ptr(), arg1, data_type, device_opt);
                __bindgen_tmp.assume_init()
            }
        }
        #[repr(C)]
        pub struct UndefinedTensorImpl {
            pub _base: root::c10::TensorImpl,
        }
        extern "C" {
            #[link_name = "\u{1}_ZN3c1019UndefinedTensorImpl10_singletonE"]
            pub static mut UndefinedTensorImpl__singleton: root::c10::UndefinedTensorImpl;
        }
        #[test]
        fn bindgen_test_layout_UndefinedTensorImpl() {
            assert_eq!(
                ::std::mem::size_of::<UndefinedTensorImpl>(),
                184usize,
                concat!("Size of: ", stringify!(UndefinedTensorImpl))
            );
            assert_eq!(
                ::std::mem::align_of::<UndefinedTensorImpl>(),
                8usize,
                concat!("Alignment of ", stringify!(UndefinedTensorImpl))
            );
        }
        pub mod ivalue {
            #[allow(unused_imports)]
            use self::super::super::super::root;
        }
    }
    pub mod caffe2 {
        #[allow(unused_imports)]
        use self::super::super::root;
        pub mod detail {
            #[allow(unused_imports)]
            use self::super::super::super::root;
            pub type TypeMetaData_New =
                ::std::option::Option<unsafe extern "C" fn() -> *mut ::std::os::raw::c_void>;
            pub type TypeMetaData_PlacementNew = ::std::option::Option<
                unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void, arg2: usize),
            >;
            pub type TypeMetaData_Copy = ::std::option::Option<
                unsafe extern "C" fn(
                    arg1: *const ::std::os::raw::c_void,
                    arg2: *mut ::std::os::raw::c_void,
                    arg3: usize,
                ),
            >;
            pub type TypeMetaData_PlacementDelete = ::std::option::Option<
                unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void, arg2: usize),
            >;
            pub type TypeMetaData_Delete =
                ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>;
        }
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct TypeMeta {
            pub index_: u16,
        }
        pub type TypeMeta_New = root::caffe2::detail::TypeMetaData_New;
        pub type TypeMeta_PlacementNew = root::caffe2::detail::TypeMetaData_PlacementNew;
        pub type TypeMeta_Copy = root::caffe2::detail::TypeMetaData_Copy;
        pub type TypeMeta_PlacementDelete = root::caffe2::detail::TypeMetaData_PlacementDelete;
        pub type TypeMeta_Delete = root::caffe2::detail::TypeMetaData_Delete;
        extern "C" {
            #[link_name = "\u{1}_ZN6caffe28TypeMeta13nextTypeIndexE"]
            pub static mut TypeMeta_nextTypeIndex: u16;
        }
        #[test]
        fn bindgen_test_layout_TypeMeta() {
            assert_eq!(
                ::std::mem::size_of::<TypeMeta>(),
                2usize,
                concat!("Size of: ", stringify!(TypeMeta))
            );
            assert_eq!(
                ::std::mem::align_of::<TypeMeta>(),
                2usize,
                concat!("Alignment of ", stringify!(TypeMeta))
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<TypeMeta>())).index_ as *const _ as usize },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(TypeMeta),
                    "::",
                    stringify!(index_)
                )
            );
        }
        extern "C" {
            #[link_name = "\u{1}_ZN6caffe28TypeMetaC1Ev"]
            pub fn TypeMeta_TypeMeta(this: *mut root::caffe2::TypeMeta);
        }
        impl TypeMeta {
            #[inline]
            pub unsafe fn new() -> Self {
                let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
                TypeMeta_TypeMeta(__bindgen_tmp.as_mut_ptr());
                __bindgen_tmp.assume_init()
            }
        }
    }
    pub mod at {
        #[allow(unused_imports)]
        use self::super::super::root;
        pub mod detail {
            #[allow(unused_imports)]
            use self::super::super::super::root;
        }
        pub mod impl_ {
            #[allow(unused_imports)]
            use self::super::super::super::root;
        }
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct QTensorImpl {
            _unused: [u8; 0],
        }
    }
    pub mod torch {
        #[allow(unused_imports)]
        use self::super::super::root;
    }
    pub mod ska {
        #[allow(unused_imports)]
        use self::super::super::root;
    }
    pub mod google {
        #[allow(unused_imports)]
        use self::super::super::root;
        pub mod base {
            #[allow(unused_imports)]
            use self::super::super::super::root;
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct _object {
        _unused: [u8; 0],
    }
    pub type PyObject = root::_object;
    pub mod ska_ordered {
        #[allow(unused_imports)]
        use self::super::super::root;
    }
    #[test]
    fn __bindgen_test_layout_ArrayRef_open0_int64_t_close0_instantiation() {
        assert_eq!(
            ::std::mem::size_of::<root::c10::ArrayRef<i64>>(),
            16usize,
            concat!(
                "Size of template specialization: ",
                stringify!(root::c10::ArrayRef<i64>)
            )
        );
        assert_eq!(
            ::std::mem::align_of::<root::c10::ArrayRef<i64>>(),
            8usize,
            concat!(
                "Alignment of template specialization: ",
                stringify!(root::c10::ArrayRef<i64>)
            )
        );
    }
    #[test]
    fn __bindgen_test_layout_intrusive_ptr_open0_StorageImpl_intrusive_target_default_null_type_open1_StorageImpl_close1_close0_instantiation(
    ) {
        assert_eq!(
            ::std::mem::size_of::<root::c10::intrusive_ptr<root::c10::StorageImpl>>(),
            8usize,
            concat!(
                "Size of template specialization: ",
                stringify!(root::c10::intrusive_ptr<root::c10::StorageImpl>)
            )
        );
        assert_eq!(
            ::std::mem::align_of::<root::c10::intrusive_ptr<root::c10::StorageImpl>>(),
            8usize,
            concat!(
                "Alignment of template specialization: ",
                stringify!(root::c10::intrusive_ptr<root::c10::StorageImpl>)
            )
        );
    }
    #[test]
    fn __bindgen_test_layout_intrusive_target_default_null_type_open0_StorageImpl_close0_instantiation(
    ) {
        assert_eq!(
            ::std::mem::size_of::<root::c10::detail::intrusive_target_default_null_type>(),
            1usize,
            concat!(
                "Size of template specialization: ",
                stringify!(root::c10::detail::intrusive_target_default_null_type)
            )
        );
        assert_eq!(
            ::std::mem::align_of::<root::c10::detail::intrusive_target_default_null_type>(),
            1usize,
            concat!(
                "Alignment of template specialization: ",
                stringify!(root::c10::detail::intrusive_target_default_null_type)
            )
        );
    }
    #[test]
    fn __bindgen_test_layout_intrusive_ptr_open0_VariableVersion_VersionCounter_intrusive_target_default_null_type_open1_VariableVersion_VersionCounter_close1_close0_instantiation(
    ) {
        assert_eq!(
            ::std::mem::size_of::<
                root::c10::intrusive_ptr<root::c10::VariableVersion_VersionCounter>,
            >(),
            8usize,
            concat!(
                "Size of template specialization: ",
                stringify!(root::c10::intrusive_ptr<root::c10::VariableVersion_VersionCounter>)
            )
        );
        assert_eq!(
            ::std::mem::align_of::<
                root::c10::intrusive_ptr<root::c10::VariableVersion_VersionCounter>,
            >(),
            8usize,
            concat!(
                "Alignment of template specialization: ",
                stringify!(root::c10::intrusive_ptr<root::c10::VariableVersion_VersionCounter>)
            )
        );
    }
    #[test]
    fn __bindgen_test_layout_intrusive_target_default_null_type_open0_VariableVersion_VersionCounter_close0_instantiation(
    ) {
        assert_eq!(
            ::std::mem::size_of::<root::c10::detail::intrusive_target_default_null_type>(),
            1usize,
            concat!(
                "Size of template specialization: ",
                stringify!(root::c10::detail::intrusive_target_default_null_type)
            )
        );
        assert_eq!(
            ::std::mem::align_of::<root::c10::detail::intrusive_target_default_null_type>(),
            1usize,
            concat!(
                "Alignment of template specialization: ",
                stringify!(root::c10::detail::intrusive_target_default_null_type)
            )
        );
    }
    #[test]
    fn __bindgen_test_layout_intrusive_ptr_open0_TensorImpl_intrusive_target_default_null_type_open1_TensorImpl_close1_close0_instantiation(
    ) {
        assert_eq!(
            ::std::mem::size_of::<root::c10::intrusive_ptr<root::c10::TensorImpl>>(),
            8usize,
            concat!(
                "Size of template specialization: ",
                stringify!(root::c10::intrusive_ptr<root::c10::TensorImpl>)
            )
        );
        assert_eq!(
            ::std::mem::align_of::<root::c10::intrusive_ptr<root::c10::TensorImpl>>(),
            8usize,
            concat!(
                "Alignment of template specialization: ",
                stringify!(root::c10::intrusive_ptr<root::c10::TensorImpl>)
            )
        );
    }
    #[test]
    fn __bindgen_test_layout_intrusive_target_default_null_type_open0_TensorImpl_close0_instantiation(
    ) {
        assert_eq!(
            ::std::mem::size_of::<root::c10::detail::intrusive_target_default_null_type>(),
            1usize,
            concat!(
                "Size of template specialization: ",
                stringify!(root::c10::detail::intrusive_target_default_null_type)
            )
        );
        assert_eq!(
            ::std::mem::align_of::<root::c10::detail::intrusive_target_default_null_type>(),
            1usize,
            concat!(
                "Alignment of template specialization: ",
                stringify!(root::c10::detail::intrusive_target_default_null_type)
            )
        );
    }
    #[test]
    fn __bindgen_test_layout_ArrayRef_open0_int64_t_close0_instantiation_1() {
        assert_eq!(
            ::std::mem::size_of::<root::c10::ArrayRef<i64>>(),
            16usize,
            concat!(
                "Size of template specialization: ",
                stringify!(root::c10::ArrayRef<i64>)
            )
        );
        assert_eq!(
            ::std::mem::align_of::<root::c10::ArrayRef<i64>>(),
            8usize,
            concat!(
                "Alignment of template specialization: ",
                stringify!(root::c10::ArrayRef<i64>)
            )
        );
    }
    #[test]
    fn __bindgen_test_layout_ArrayRef_open0_int_close0_instantiation() {
        assert_eq!(
            ::std::mem::size_of::<root::c10::ArrayRef<::std::os::raw::c_int>>(),
            16usize,
            concat!(
                "Size of template specialization: ",
                stringify!(root::c10::ArrayRef<::std::os::raw::c_int>)
            )
        );
        assert_eq!(
            ::std::mem::align_of::<root::c10::ArrayRef<::std::os::raw::c_int>>(),
            8usize,
            concat!(
                "Alignment of template specialization: ",
                stringify!(root::c10::ArrayRef<::std::os::raw::c_int>)
            )
        );
    }
    #[test]
    fn __bindgen_test_layout_ArrayRef_open0_size_t_close0_instantiation() {
        assert_eq!(
            ::std::mem::size_of::<root::c10::ArrayRef<usize>>(),
            16usize,
            concat!(
                "Size of template specialization: ",
                stringify!(root::c10::ArrayRef<usize>)
            )
        );
        assert_eq!(
            ::std::mem::align_of::<root::c10::ArrayRef<usize>>(),
            8usize,
            concat!(
                "Alignment of template specialization: ",
                stringify!(root::c10::ArrayRef<usize>)
            )
        );
    }
}
