import enum


class EventType(enum.Enum):
    """Represents the type of a event."""

    # Chat
    MESSAGE = "MESSAGE"
    COMMAND = "COMMAND"
    CALLBACK_QUERY = "CALLBACK_QUERY"
    INLINE_QUERY = "INLINE_QUERY"
    # Community
    CHANNEL_CREATE = "CHANNEL_CREATE"
    CHANNEL_UPDATE = "CHANNEL_UPDATE"
    CHANNEL_DELETE = "CHANNEL_DELETE"
    GROUP_CREATE = "GROUP_CREATE"
    GROUP_UPDATE = "GROUP_UPDATE"
    GROUP_DELETE = "GROUP_DELETE"
    USER_BAN = "USER_BAN"
    USER_UNBAN = "USER_UNBAN"
    MEMBER_JOIN = "MEMBER_JOIN"
    MEMBER_LEAVE = "MEMBER_LEAVE"
    COMMUNITY_UPDATE = "COMMUNITY_UPDATE"
