# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/01-retrieval.ipynb (unless otherwise specified).

__all__ = ['save_latest_raw_holiday_data', 'load_holidays_df', 'holidays_df_to_s', 'load_holidays_s']

# Cell
import json
import numpy as np
import pandas as pd

import requests

# Cell
def save_latest_raw_holiday_data(raw_data_dir, holidays_url='https://www.gov.uk/bank-holidays.json'):
    holidays_json = get_holidays_json(holidays_url)

    with open(f'{raw_data_dir}/holidays.json', 'w') as fp:
        json.dump(holidays_json, fp)

    return

# Cell
def load_holidays_df(raw_data_dir):
    with open(f'{raw_data_dir}/holidays.json', 'r') as fp:
        holidays_json = json.load(fp)

    df_holidays = pd.DataFrame(holidays_json['england-and-wales']['events'])
    df_holidays['date'] = pd.to_datetime(df_holidays['date'])

    return df_holidays

# Cell
def holidays_df_to_s(df_holidays):
    holidays_dt_range = pd.date_range(df_holidays['date'].min(), df_holidays['date'].max(), freq='30T', tz='UTC')

    s_holidays = pd.Series(np.isin(holidays_dt_range.date, df_holidays['date'].dt.date), index=holidays_dt_range).astype(int)
    s_holidays.index.name = 'datetime'
    s_holidays.name = 'holiday'

    return s_holidays

# Cell
def load_holidays_s(raw_data_dir):
    df_holidays = load_holidays_df(raw_data_dir)
    s_holidays = holidays_df_to_s(df_holidays)

    return s_holidays