"""
Autogenerated using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__

hub.exec.boto3.client.route53.create_hosted_zone
hub.exec.boto3.client.route53.delete_hosted_zone
hub.exec.boto3.client.route53.get_hosted_zone
hub.exec.boto3.client.route53.list_hosted_zones
"""
from typing import Any
from typing import Dict
from typing import List

__contracts__ = ["resource"]


async def present(
    hub,
    ctx,
    name: str,
    hosted_zone_name: str,
    caller_reference: str,
    resource_id: str = None,
    config: Dict = None,
    vpcs: Dict = None,
    delegation_set_id: str = None,
    tags: List = None,
) -> Dict[str, Any]:
    r"""
        **Autogenerated function**

        Creates a new public or private hosted zone. You create records in a public hosted zone to define how you want
        to route traffic on the internet for a domain, such as example.com, and its subdomains (apex.example.com,
        acme.example.com). You create records in a private hosted zone to define how you want to route traffic for a
        domain and its subdomains within one or more Amazon Virtual Private Clouds (Amazon VPCs).   You can't convert a
        public hosted zone to a private hosted zone or vice versa. Instead, you must create a new hosted zone with the
        same name and create new resource record sets.  For more information about charges for hosted zones, see Amazon
        Route 53 Pricing. Note the following:   You can't create a hosted zone for a top-level domain (TLD) such as
        .com.   For public hosted zones, Route 53 automatically creates a default SOA record and four NS records for the
        zone. For more information about SOA and NS records, see NS and SOA Records that Route 53 Creates for a Hosted
        Zone in the Amazon Route 53 Developer Guide. If you want to use the same name servers for multiple public hosted
        zones, you can optionally associate a reusable delegation set with the hosted zone. See the DelegationSetId
        element.   If your domain is registered with a registrar other than Route 53, you must update the name servers
        with your registrar to make Route 53 the DNS service for the domain. For more information, see Migrating DNS
        Service for an Existing Domain to Amazon Route 53 in the Amazon Route 53 Developer Guide.    When you submit a
        CreateHostedZone request, the initial status of the hosted zone is PENDING. For public hosted zones, this means
        that the NS and SOA records are not yet available on all Route 53 DNS servers. When the NS and SOA records are
        available, the status of the zone changes to INSYNC. The CreateHostedZone request requires the caller to have an
        ec2:DescribeVpcs permission.

        Args:
            name(Text): An Idem name of the resource.
            hosted_zone_name(Text): A unique string that identifies a hosted zone.
            caller_reference(Text): A unique string that identifies the request and that allows failed CreateHostedZone
                                      requests to be retried without the risk of executing the operation twice.
                                      You must use a unique CallerReference string every time you submit a CreateHostedZone request.
                                      CallerReference can be any unique string, for example, a date/time stamp.,
            resource_id(Text, optional): AWS route53 zone id to identify the resource
            config(dictionary, optional):A complex type that contains the following optional values: Defaults to None
                * Comment(Text) -- Any comments that you want to include about the hosted zone.
                * PrivateZone(boolean) -- A value that indicates whether this is a private hosted zone.
            vpcs(dictionary, optional): A complex type that contains information about the Amazon VPC that you're associating with
                                 this hosted zone. Defaults to None
                * VPCId(Text) -- (Private hosted zones only) The region that an Amazon VPC was created in.
                * VPCRegion(Text) -- (Private hosted zones only) The ID of an Amazon VPC.
            delegation_set_id(string, optional): Id of a reusable delegation set,
            tags(List, optional): The tags to assign to the VPC. Defaults to None.
                * Key (Text) -- The key of the tag. Tag keys are case-sensitive and accept a maximum of 127 Unicode characters. May not begin with aws: .
                * Value (Text) -- The value of the tag. Tag values are case-sensitive and accept a maximum of 255 Unicode characters.


            Request Syntax:
            [hosted_zone_id]:
              aws.route53.hosted_zone.present:
              - name: 'string'
              - hosted_zone_name: 'string'
              - resource_id: 'string'
              - caller_reference: 'string'
              - config:
                  PrivateZone: 'string'
                  Comment: 'string'
              - vpcs:
                  VPCId: 'string'
                  VPCRegion: 'string'
              - delegation_set_id: 'string'
    -         - tags:
                - Key: 'string'
                  Value: 'string'

        Returns:
            Dict[str, Any]

        Examples:

            .. code-block:: sls

                resource_is_present:
                  aws.route53.hosted_zone.present:
                    - name: value
                    - resource_id: value
                    - caller_reference: value
                    - config:
                        PrivateZone: True
                        Comment: 'description of hosted zone config'
                    - vpcs:
                        VPCId: 'vpc id'
                        VPCRegion: 'us-east1'
                    - delegation_set_id: 'string'
    -               - tags:
                        - Key: 'tag key'
                          Value: 'tag value'
    """
    result = dict(comment="", old_state=None, new_state=None, name=name, result=True)
    before = None
    if resource_id:
        before = await hub.exec.boto3.client.route53.get_hosted_zone(
            ctx, Id=resource_id
        )

    if ctx.get("test", False):
        if before["result"]:
            result["comment"] = f"Would update aws.route53.hosted_zone {name}"
            result["result"] = True
        else:
            result["comment"] = f"Would create aws.route53.hosted_zone {name}"
            result["result"] = True
        return result
    hosted_zone_id = None
    is_resource_updated = False

    if before:
        hosted_zone_id = resource_id
        old_tags = None
        tags_ret = await hub.exec.boto3.client.route53.list_tags_for_resource(
            ctx, ResourceType="hostedzone", ResourceId=resource_id.split("/")[-1]
        )
        if tags_ret["result"]:
            old_tags = tags_ret["ret"].get("ResourceTagSet").get("Tags", [])

            result[
                "old_state"
            ] = hub.tool.aws.hosted_zone_utils.convert_raw_hosted_zone_to_present(
                raw_resource=before,
                idem_resource_name=name,
                tags=old_tags,
            )
        else:
            result["result"] = False
            error = tags_ret["Comments"]
            hub.log.debug(f"Tag addition failed for {name} with error {error}")

        # Check if comments needs to be updated.
        if (
            config is not None
            and config.get("Comment") is not None
            and config.get("Comment")
            != before["ret"]["HostedZone"]["Config"].get("Comment")
        ):
            update_ret_comment = (
                await hub.exec.boto3.client.route53.update_hosted_zone_comment(
                    ctx,
                    Id=resource_id,
                    Comment=config.get("Comment"),
                )
            )
            if update_ret_comment["result"]:
                is_resource_updated = True
                comment = config.get("Comment")
                result[
                    "comment"
                ] = f"'{name}' already present. Updated comment to {comment}"
            else:
                result["comment"] = update_ret_comment["comment"]
                result["result"] = False

        # Check if tags needs to be updated
        if tags is not None and old_tags != tags:
            update_ret_tags = await hub.exec.aws.route53.tag.update_tags(
                ctx,
                resource_type="hostedzone",
                resource_id=resource_id,
                old_tags=old_tags,
                new_tags=tags,
            )
            if update_ret_tags["result"]:
                is_resource_updated = True
                if result["comment"]:
                    result["comment"] = (
                        result["comment"]
                        + ","
                        + f"'{name}' already present. Updated tags {tags}"
                    )
                else:
                    result["comment"] = f"'{name}' already present. Updated tags {tags}"

            else:
                result["comment"] = result["comment"] + "," + update_ret_tags["comment"]
                result["result"] = False
    else:
        try:
            ret = await hub.exec.boto3.client.route53.create_hosted_zone(
                ctx,
                Name=hosted_zone_name,
                VPC=vpcs,
                CallerReference=caller_reference,
                HostedZoneConfig=config,
                DelegationSetId=delegation_set_id,
            )
            result["result"] = ret["result"]
            if not result["result"]:
                result["comment"] = ret["comment"]
                result["result"] = False
                return result

            result["comment"] = f"Created '{name}'"
            hosted_zone_id = ret["ret"]["HostedZone"]["Id"]
            # add tag
            add_tags = await hub.exec.aws.route53.tag.update_tags(
                ctx,
                resource_type="hostedzone",
                resource_id=hosted_zone_id,
                old_tags=None,
                new_tags=tags,
            )
            if not add_tags["result"]:
                error = add_tags["Comments"]
                result["result"] = False
                hub.log.debug(f"Tag addition failed for {name} with error {error}")
                result["comment"] = f"Tag addition failed for {name} with error {error}"

        except hub.tool.boto3.exception.ClientError as e:
            result["comment"] = f"{e.__class__.__name__}: {e}"
            result["result"] = False

    try:
        if not before or is_resource_updated:
            after = await hub.exec.boto3.client.route53.get_hosted_zone(
                ctx, Id=hosted_zone_id
            )

            if after["result"]:
                tags_ret = await hub.exec.boto3.client.route53.list_tags_for_resource(
                    ctx,
                    ResourceType="hostedzone",
                    ResourceId=hosted_zone_id.split("/")[-1],
                )

                if tags_ret["result"]:
                    tags = tags_ret["ret"]["ResourceTagSet"].get("Tags")

                result[
                    "new_state"
                ] = hub.tool.aws.hosted_zone_utils.convert_raw_hosted_zone_to_present(
                    raw_resource=after,
                    idem_resource_name=name,
                    tags=tags,
                )

    except Exception as e:
        result["comment"] = str(e)
        result["result"] = False
    return result


async def absent(hub, ctx, name: str, resource_id: str) -> Dict[str, Any]:
    r"""
    **Autogenerated function**

    Deletes a hosted zone. If the hosted zone was created by another service, such as Cloud Map, see Deleting Public
    Hosted Zones That Were Created by Another Service in the Amazon Route 53 Developer Guide for information about
    how to delete it. (The process is the same for public and private hosted zones that were created by another
    service.) If you want to keep your domain registration but you want to stop routing internet traffic to your
    website or web application, we recommend that you delete resource record sets in the hosted zone instead of
    deleting the hosted zone.  If you delete a hosted zone, you can't undelete it. You must create a new hosted zone
    and update the name servers for your domain registration, which can require up to 48 hours to take effect. (If
    you delegated responsibility for a subdomain to a hosted zone and you delete the child hosted zone, you must
    update the name servers in the parent hosted zone.) In addition, if you delete a hosted zone, someone could
    hijack the domain and route traffic to their own resources using your domain name.  If you want to avoid the
    monthly charge for the hosted zone, you can transfer DNS service for the domain to a free DNS service. When you
    transfer DNS service, you have to update the name servers for the domain registration. If the domain is
    registered with Route 53, see UpdateDomainNameservers for information about how to replace Route 53 name servers
    with name servers for the new DNS service. If the domain is registered with another registrar, use the method
    provided by the registrar to update name servers for the domain registration. For more information, perform an
    internet search on "free DNS service." You can delete a hosted zone only if it contains only the default SOA
    record and NS resource record sets. If the hosted zone contains other resource record sets, you must delete them
    before you can delete the hosted zone. If you try to delete a hosted zone that contains other resource record
    sets, the request fails, and Route 53 returns a HostedZoneNotEmpty error. For information about deleting records
    from your hosted zone, see ChangeResourceRecordSets. To verify that the hosted zone has been deleted, do one of
    the following:   Use the GetHostedZone action to request information about the hosted zone.   Use the
    ListHostedZones action to get a list of the hosted zones associated with the current Amazon Web Services
    account.

    Args:
        name(Text): The Idem name of the route53 hosted zone.
        resource_id(Text): The AWS ID of the route53 hosted zone

    Returns:
        Dict[str, Any]

    Examples:

        .. code-block:: sls

            resource_is_absent:
              aws.route53.hosted_zone.absent:
                - name: value
                - resource_id: value
    """
    result = dict(comment="", old_state=None, new_state=None, name=name, result=True)
    before = None
    if resource_id:
        before = await hub.exec.boto3.client.route53.get_hosted_zone(
            ctx, Id=resource_id
        )

    if not before["result"]:
        result["comment"] = f"'{name}' is already absent."
    elif ctx.get("test", False):
        if before["result"]:
            result["comment"] = f"Would delete aws.route53.hosted_zone {name}"
            result["result"] = True
        return result
    else:
        tags = None
        tags_ret = await hub.exec.boto3.client.route53.list_tags_for_resource(
            ctx, ResourceType="hostedzone", ResourceId=resource_id.split("/")[-1]
        )
        if tags_ret["result"]:
            tags = tags_ret["ret"]["ResourceTagSet"].get("Tags")
        result[
            "old_state"
        ] = hub.tool.aws.hosted_zone_utils.convert_raw_hosted_zone_to_present(
            raw_resource=before,
            idem_resource_name=name,
            tags=tags,
        )
        try:
            ret = await hub.exec.boto3.client.route53.delete_hosted_zone(
                ctx, Id=resource_id
            )
            result["result"] = ret["result"]
            if not result["result"]:
                result["comment"] = ret["comment"]
                result["result"] = False
                return result
            result["comment"] = f"Deleted '{name}'"
        except hub.tool.boto3.exception.ClientError as e:
            result["comment"] = f"{e.__class__.__name__}: {e}"

    return result


async def describe(hub, ctx) -> Dict[str, Dict[str, Any]]:
    r"""
    **Autogenerated function**

    Describe the resource in a way that can be recreated/managed with the corresponding "present" function


    Retrieves a list of the public and private hosted zones that are associated with the current Amazon Web Services
    account.


    Returns:
        Dict[str, Any]

    Examples:

        .. code-block:: bash

            $ idem describe aws.route53.hosted_zone
    """

    result = {}

    ret = await hub.exec.boto3.client.route53.list_hosted_zones(ctx)
    if not ret["result"]:
        hub.log.debug(f"Could not describe hosted_zone {ret['comment']}")
        return result

    for hosted_zone in ret["ret"]["HostedZones"]:
        tags = None
        resource_id = hosted_zone.get("Id")

        individual_hosted_zone = await hub.exec.boto3.client.route53.get_hosted_zone(
            ctx, Id=resource_id
        )

        tags_ret = await hub.exec.boto3.client.route53.list_tags_for_resource(
            ctx, ResourceType="hostedzone", ResourceId=resource_id.split("/")[-1]
        )
        if tags_ret["result"]:
            tags = tags_ret["ret"]["ResourceTagSet"].get("Tags")

        resource_translated = (
            hub.tool.aws.hosted_zone_utils.convert_raw_hosted_zone_to_present(
                raw_resource=individual_hosted_zone,
                idem_resource_name=resource_id,
                tags=tags,
            )
        )
        result[resource_id] = {
            "aws.route53.hosted_zone.present": [
                {parameter_key: parameter_value}
                for parameter_key, parameter_value in resource_translated.items()
            ]
        }

    return result
