"""
Autogenerated using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__

hub.exec.boto3.client.eks.create_nodegroup
hub.exec.boto3.client.eks.delete_nodegroup
hub.exec.boto3.client.eks.describe_nodegroup
hub.exec.boto3.client.eks.list_nodegroups
"""
import copy
from collections import OrderedDict
from typing import Any
from typing import Dict
from typing import List

from dict_tools import differ

__contracts__ = ["resource"]

TREQ = {
    "absent": {
        "require": [
            "aws.ec2.subnet.absent",
            "aws.ec2.vpc.absent",
            "aws.iam.role.absent",
            "aws.iam.role_policy_attachment.absent",
            "aws.eks.cluster.absent",
        ],
    },
    "present": {
        "require": [
            "aws.ec2.subnet.present",
            "aws.ec2.vpc.present",
            "aws.iam.role.present",
            "aws.iam.role_policy_attachment.present",
            "aws.eks.cluster.present",
        ],
    },
}
default_attempts = 120


async def present(
    hub,
    ctx,
    name: str,
    cluster_name: str,
    scaling_config: Dict = None,
    disk_size: int = None,
    subnets: List = None,
    instance_types: List = None,
    ami_type: str = None,
    remote_access: Dict = None,
    node_role: str = None,
    labels: Dict = None,
    taints: List = None,
    tags: Dict = None,
    client_request_token: str = None,
    launch_template: Dict = None,
    update_config: Dict = None,
    capacity_type: str = None,
    version: str = None,
    release_version: str = None,
) -> Dict[str, Any]:
    r"""
    **Autogenerated function**

    Creates a managed node group for an Amazon EKS cluster. You can only create a node group for your cluster that
    is equal to the current Kubernetes version for the cluster. All node groups are created with the latest AMI
    release version for the respective minor Kubernetes version of the cluster, unless you deploy a custom AMI using
    a launch template. For more information about using launch templates, see Launch template support. An Amazon EKS
    managed node group is an Amazon EC2 Auto Scaling group and associated Amazon EC2 instances that are managed by
    Amazon Web Services for an Amazon EKS cluster. Each node group uses a version of the Amazon EKS optimized Amazon
    Linux 2 AMI. For more information, see Managed Node Groups in the Amazon EKS User Guide.

    Args:
        name(Text): A name, ID to identify the resource.
        cluster_name(Text, required): The name of the cluster to create the node group in.
        scaling_config(Dict, optional): The scaling configuration details for the Auto Scaling group that is created
            for your node group
        capacity_type(Text, optional): The capacity type for your node group
        disk_size(integer, optional): The root device disk size (in GiB) for your node group instances. The default
            disk size is 20 GiB.
        subnets(List, required): The subnets to use for the Auto Scaling group that is created for your node group.
        instance_types(Text, optional): Specify the instance types for a node group.
        ami_type(Text, optional): The AMI type for your node group. GPU instance types should use the AL2_x86_64_GPU
            AMI type. Non-GPU instances should use the AL2_x86_64 AMI type. Arm instances should use the AL2_ARM_64 AMI
            type.
        remote_access(Dict, optional): The remote access (SSH) configuration to use with your node group. If you
            specify launchTemplate , then don't specify remoteAccess , or the node group deployment will fail.
        node_role(Text, required): The Amazon Resource Name (ARN) of the IAM role to associate with your node group.
            The Amazon EKS worker node kubelet daemon makes calls to Amazon Web Services APIs on your behalf. Nodes
            receive permissions for these API calls through an IAM instance profile and associated policies. Before you
            can launch nodes and register them into a cluster, you must create an IAM role for those nodes to use when
            they are launched.
        labels(Dict, optional): The Kubernetes labels to be applied to the nodes in the node group when they are created.
        taints(List, optional): The Kubernetes taints to be applied to the nodes in the node group.
        tags(Dict, optional): The metadata to apply to the node group to assist with categorization and organization.
            Each tag consists of a key and an optional value. You define both. Node group tags do not propagate to any
            other resources associated with the node group, such as the Amazon EC2 instances or subnets.
        client_request_token(Text, optional): Unique, case-sensitive identifier that you provide to ensure the
            idempotency of the request.
        launch_template(Dict, optional): An object representing a node group's launch template specification. If
            specified, then do not specify instanceTypes , diskSize , or remoteAccess and make sure that the launch
            template meets the requirements in launchTemplateSpecification
        update_config(Dict, optional): The node group update configuration
        version(Text, optional): The Kubernetes version to use for your managed nodes. By default, the Kubernetes
            version of the cluster is used, and this is the only accepted specified value. If you specify launchTemplate
            , and your launch template uses a custom AMI, then don't specify version , or the node group deployment will
            fail. For more information about using launch templates with Amazon EKS, see Launch template support in the
            Amazon EKS User Guide.
        release_version(Text, optional): The AMI version of the Amazon EKS optimized AMI to use with your node group.
            By default, the latest available AMI version for the node group's current Kubernetes version is used. For
            more information, see Amazon EKS optimized Amazon Linux 2 AMI versions in the Amazon EKS User Guide . If you
            specify launchTemplate , and your launch template uses a custom AMI, then don't specify releaseVersion ,
            or the node group deployment will fail. For more information about using launch templates with Amazon EKS,
            see Launch template support in the Amazon EKS User Guide.

    Returns:
        Dict[str, Any]

    Examples:

        .. code-block:: sls

            nodes1:
              aws.eks.nodegroup.present:
              - cluster_name: idem-test-cluster
              - node_group_arn: arn:aws:eks:us-west-2:000000000000:nodegroup/prod/idem-test-instance-e1a573b9-4e74-48f0-85c4-c214a8ec8ada/id123
              - version: '1.21'
              - release_version: 1.21.5-20220123
              - status: ACTIVE
              - capacity_type: ON_DEMAND
              - instance_types:
                - t1.micro
              - subnets:
                - subnet-31813031
              - ami_type: AL2_x86_64
              - node_role: arn:aws:iam::000000000000:role/idem-test-role-2075a427-24c2-4021-abc3-9b542834addb
              - disk_size: 20
              - scaling_config:
                  desiredSize: 2
                  maxSize: 2
                  minSize: 2
              - update_config:
                  maxUnavailable: 1
              - tags:
                  Name: idem-test-instance-e1a573b9-4e74-48f0-85c4-c214a8ec8ada

    """

    result = dict(comment="", old_state=None, new_state=None, name=name, result=True)
    is_not_changed = True
    before = await hub.exec.boto3.client.eks.describe_nodegroup(
        ctx, clusterName=cluster_name, nodegroupName=name
    )
    if ctx.get("test", False):
        if before:
            result["comment"] = f"Would update aws.eks.nodegroup {name}"
            result["result"] = True
        else:
            result["comment"] = f"Would create aws.eks.nodegroup {name}"
            result["result"] = True
        return result
    try:
        if before:
            result["comment"] = f"'{name}' already exists"
            result["old_state"] = before["ret"]["nodegroup"]
            arn = before["ret"]["nodegroup"]["arn"]
            if before["ret"]["nodegroup"].get("clientRequestToken"):
                client_request_token = before["ret"]["nodegroup"]["clientRequestToken"]
            else:
                client_request_token = None
            # change depends on version, releaseVersion
            if (version and before["ret"]["nodegroup"].get("version") != version) or (
                release_version
                and before["ret"]["nodegroup"].get("releaseVersion") != release_version
            ):
                ret = await hub.exec.boto3.client.eks.update_nodegroup_version(
                    ctx,
                    nodegroupName=name,
                    clusterName=cluster_name,
                    version=version,
                    releaseVersion=release_version,
                    launchTemplate=launch_template,
                    clientRequestToken=client_request_token,
                )
                result["result"] = ret["result"]
                if not result["result"]:
                    result["comment"] = ret["comment"]
                    return result
                await hub.tool.boto3.client.wait(
                    ctx,
                    "eks",
                    "nodegroup_active",
                    None,
                    nodegroupName=name,
                    clusterName=cluster_name,
                    WaiterConfig={"MaxAttempts": default_attempts},
                )
                is_not_changed = False
            # change depends on labels, scaling_group, taint, update_config
            node_config_change = hub.tool.aws.eks_utils.get_updated_node_group_config(
                before["ret"]["nodegroup"],
                labels,
                taints,
                scaling_config,
                update_config,
            )
            if node_config_change:
                ret = await hub.exec.boto3.client.eks.update_nodegroup_config(
                    ctx,
                    clusterName=cluster_name,
                    nodegroupName=name,
                    labels=node_config_change.get("labels"),
                    taints=node_config_change.get("taints"),
                    scalingConfig=node_config_change.get("scaling_config"),
                    updateConfig=node_config_change.get("update_config"),
                    clientRequestToken=client_request_token,
                )
                result["result"] = ret["result"]
                if not result["result"]:
                    result["comment"] = ret["comment"]
                    return result
                await hub.tool.boto3.client.wait(
                    ctx,
                    "eks",
                    "nodegroup_active",
                    None,
                    nodegroupName=name,
                    clusterName=cluster_name,
                    WaiterConfig={"MaxAttempts": default_attempts},
                )
                is_not_changed = False
            # update tags
            old_tags = (
                copy.deepcopy(before["ret"]["nodegroup"].get("tags"))
                if before["ret"]["nodegroup"].get("tags")
                else {}
            )
            update_tags_ret = await hub.exec.aws.eks.tag.update_eks_tags(
                ctx=ctx,
                resource_arn=arn,
                old_tags=old_tags,
                new_tags=tags,
            )
            if not update_tags_ret["result"]:
                result["comment"] = update_tags_ret["comment"]
                result["result"] = False
                return result
            if update_tags_ret["ret"]:
                is_not_changed = False
            if not is_not_changed:
                result["comment"] = f"Updated '{name}'"
        else:
            try:
                ret = await hub.exec.boto3.client.eks.create_nodegroup(
                    ctx,
                    clusterName=cluster_name,
                    nodegroupName=name,
                    scalingConfig=scaling_config,
                    diskSize=disk_size,
                    subnets=subnets,
                    instanceTypes=instance_types,
                    amiType=ami_type,
                    remoteAccess=remote_access,
                    nodeRole=node_role,
                    labels=labels,
                    taints=taints,
                    tags=tags,
                    clientRequestToken=client_request_token,
                    launchTemplate=launch_template,
                    updateConfig=update_config,
                    capacityType=capacity_type,
                    version=version,
                    releaseVersion=release_version,
                )
                result["result"] = ret["result"]
                if not result["result"]:
                    result["comment"] = ret["comment"]
                    return result
                await hub.tool.boto3.client.wait(
                    ctx,
                    "eks",
                    "nodegroup_active",
                    None,
                    nodegroupName=name,
                    clusterName=cluster_name,
                    WaiterConfig={"MaxAttempts": default_attempts},
                )
                result["comment"] = f"Created '{name}'"
            except hub.tool.boto3.exception.ClientError as e:
                result["comment"] = f"{e.__class__.__name__}: {e}"
                result["result"] = False
    except Exception as e1:
        result["comment"] = f"{e1.__class__.__name__}: {e1}"
        result["result"] = False
        return result

    try:
        if is_not_changed:
            after = await hub.exec.boto3.client.eks.describe_nodegroup(
                ctx, clusterName=cluster_name, nodegroupName=name
            )
            result["new_state"] = after["ret"]["nodegroup"]
        else:
            result["new_state"] = copy.deepcopy(result["old_state"])
    except Exception as e:
        result["comment"] = str(e)
        result["result"] = False
    return result


async def absent(hub, ctx, name: str, cluster_name: str) -> Dict[str, Any]:
    r"""
    **Autogenerated function**

    Deletes an Amazon EKS node group for a cluster.

    Args:
        name(Text): A name, ID to identify the resource.
        cluster_name(Text, required): The name of the cluster to create the node group in.

    Returns:
        Dict[str, Any]

    Examples:

        .. code-block:: sls

            nodes1:
              aws.eks.nodegroup.absent:
                - cluster_name: idem-test-cluster
    """

    result = dict(comment="", old_state=None, new_state=None, name=name, result=True)

    before = await hub.exec.boto3.client.eks.describe_nodegroup(
        ctx, clusterName=cluster_name, nodegroupName=name
    )

    if not before:
        result["comment"] = f"'{name}' already absent"
    elif ctx.get("test", False):
        result["comment"] = f"Would delete aws.eks.nodegroup {name}"
        return result
    else:
        result["old_state"] = before["ret"]["nodegroup"]
        try:
            ret = await hub.exec.boto3.client.eks.delete_nodegroup(
                ctx, clusterName=cluster_name, nodegroupName=name
            )
            result["result"] = ret["result"]
            if not result["result"]:
                result["comment"] = ret["comment"]
                result["result"] = False
                return result
            await hub.tool.boto3.client.wait(
                ctx,
                "eks",
                "nodegroup_deleted",
                None,
                nodegroupName=name,
                clusterName=cluster_name,
                WaiterConfig={"MaxAttempts": default_attempts},
            )
            result["comment"] = f"Deleted '{name}'"
        except Exception as e:
            result["comment"] = f"{e.__class__.__name__}: {e}"

    return result


async def describe(hub, ctx) -> Dict[str, Dict[str, Any]]:
    r"""
    **Autogenerated function**

    Describe the resource in a way that can be recreated/managed with the corresponding "present" function


    Lists the Amazon EKS managed node groups associated with the specified cluster in your Amazon Web Services
    account in the specified Region. Self-managed node groups are not listed.


    Returns:
        Dict[str, Any]

    Examples:

        .. code-block:: bash

            $ idem describe aws.eks.nodegroup
    """

    result = {}
    cluster_ret = await hub.exec.boto3.client.eks.list_clusters(ctx)
    if not cluster_ret["result"]:
        hub.log.debug(f"Could not describe cluster {cluster_ret['comment']}")
        return {}
    cluster_node_groups = []
    try:
        for name in cluster_ret["ret"]["clusters"]:
            node_group_ret = await hub.exec.boto3.client.eks.list_nodegroups(
                ctx, clusterName=name
            )
            if not node_group_ret["result"]:
                result["comment"] = node_group_ret["comment"]
                return result
            for group in node_group_ret["ret"]["nodegroups"]:
                cluster_node_groups.append({"name": name, "group": group})
    except Exception as e:
        result["comment"] = str(e)
        result["result"] = False
        return result

    describe_parameters = OrderedDict(
        {
            "clusterName": "cluster_name",
            "nodegroupArn": "node_group_arn",
            "version": "version",
            "releaseVersion": "release_version",
            "status": "status",
            "capacityType": "capacity_type",
            "instanceTypes": "instance_types",
            "subnets": "subnets",
            "amiType": "ami_type",
            "nodeRole": "node_role",
            "diskSize": "disk_size",
            "clientRequestToken": "client_request_token",
        }
    )

    for node_groups in cluster_node_groups:
        cluster_name = node_groups["name"]
        node_group = node_groups["group"]
        describe_ret = await hub.exec.boto3.client.eks.describe_nodegroup(
            ctx, clusterName=cluster_name, nodegroupName=node_group
        )
        nodegroup = describe_ret["ret"]["nodegroup"]
        new_node_group = []
        for parameter_old_key, parameter_new_key in describe_parameters.items():
            if nodegroup.get(parameter_old_key) is not None:
                new_node_group.append(
                    {parameter_new_key: nodegroup.get(parameter_old_key)}
                )
        if nodegroup.get("scalingConfig"):
            new_node_group.append(
                {"scaling_config": nodegroup.get("scalingConfig").copy()}
            )
        if nodegroup.get("labels"):
            new_node_group.append({"labels": nodegroup.get("labels").copy()})
        if nodegroup.get("remoteAccess"):
            new_node_group.append(
                {"remote_access": nodegroup.get("remoteAccess").copy()}
            )
        if nodegroup.get("taints"):
            new_node_group.append({"taints": nodegroup.get("taints").copy()})
        if nodegroup.get("launchTemplate"):
            new_node_group.append(
                {"launch_template": nodegroup.get("launchTemplate").copy()}
            )
        if nodegroup.get("updateConfig"):
            new_node_group.append(
                {"update_config": nodegroup.get("updateConfig").copy()}
            )
        if nodegroup.get("resources"):
            new_node_group.append({"resources": nodegroup.get("resources").copy()})
        if nodegroup.get("tags"):
            new_node_group.append({"tags": nodegroup.get("tags").copy()})

        result[node_group] = {"aws.eks.nodegroup.present": new_node_group}
    return result
