"""
Autogenerated using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__

hub.exec.boto3.client.ec2.create_transit_gateway
hub.exec.boto3.client.ec2.delete_transit_gateway
hub.exec.boto3.client.ec2.describe_transit_gateways
hub.exec.boto3.client.ec2.modify_transit_gateway
"""
from collections import OrderedDict
from typing import Any
from typing import Dict
from typing import List

__contracts__ = ["resource"]
TREQ = {
    "present": {
        "require": ["aws.ec2.subnet.present"],
        "require": ["aws.ec2.vpc.present"],
        "require": ["aws.ec2.transit_gateway.present"],
    },
}


async def present(
    hub,
    ctx,
    name: str,
    transit_gateway: str,
    vpc_id: str,
    subnet_ids: List,
    options: dict = None,
    tags: List = None,
) -> Dict[str, Any]:
    r"""
    **Autogenerated function**

    Attaches the specified VPC to the specified transit gateway. If you attach a VPC with a CIDR range that overlaps
    the CIDR range of a VPC that is already attached, the new VPC CIDR range is not propagated to the default
    propagation route table. To send VPC traffic to an attached transit gateway, add a route to the VPC route table
    using CreateRoute.

    Args:
        name(Text): A name, ID to identify the resource.
        transit_gateway(Text): The ID of the transit gateway.
        vpc_id(Text): The ID of the VPC.
        subnet_ids(List): The IDs of one or more subnets. You can specify only one subnet per Availability Zone.
                       You must specify at least one subnet, but we recommend that you specify two subnets for better availability.
                       The transit gateway uses one IP address from each specified subnet.
             * (Text)
        options(dictionary, optional): The VPC attachment options.
             *  DnsSupport (Text) -- Enable or disable DNS support. Enabled by default.,
             *  Ipv6Support (Text) -- Enable or disable IPv6 support. The default is disable.,
             *  ApplianceModeSupport (string) -- Enable or disable support for appliance mode. If enabled, a traffic flow between a source and destination uses the same Availability Zone for the VPC attachment for the lifetime of that flow. The default is disable .
        tags(List, optional): The tags to apply to the VPC attachment.
            * Key (Text) -- The key of the tag. Tag keys are case-sensitive and accept a maximum of 127 Unicode characters. May not begin with aws: .
            * Value (Text) -- The value of the tag. Tag values are case-sensitive and accept a maximum of 255 Unicode characters.

    Request Syntax:
        [transit-gateway-resource-id]:
          aws.ec2.transit_gateway_vpc_attachment.present:
            - transit_gateway: 'string'
            - vpc_id: 'string'
            - subnet_ids:
               - 'string'
            - options:
                ApplianceModeSupport: 'string'
                DnsSupport: 'string'
                Ipv6Support: 'string'
            - tags:
                - Key: 'string'
                  Value: 'string'
    Returns:
        Dict[str, Any]

    Examples:

        .. code-block:: sls

            tgw-attach-0871e9c72becf0710:
                aws.ec2.transit_gateway_vpc_attachment.present:
                - transit_gateway: tgw-02994a8dda824c337
                - vpc_id: vpc-0afa0d5fe3fc2785c
                - subnet_ids:
                   - subnet-07f91b9ebd252be49
                - options:
                    ApplianceModeSupport: disable
                    DnsSupport: enable
                    Ipv6Support: disable
                - tags:
                    - Key: Name
                      Value: test-transit-gateway-attachment

    """
    result = dict(comment="", old_state=None, new_state=None, name=name, result=True)
    before = await hub.exec.aws.ec2.transit_gateway_vpc_attachment.get_transit_gateway_vpc_attachment_by_id(
        ctx, name
    )
    before = before["ret"]
    result["old_state"] = before
    if ctx.get("test", False):
        if before:
            result[
                "comment"
            ] = f"Would update aws.ec2.transit_gateway_vpc_attachment {name}"
            result["result"] = True
        else:
            result[
                "comment"
            ] = f"Would create aws.ec2.transit_gateway_vpc_attachment {name}"
            result["result"] = True
        return result

    try:
        if before:
            if subnet_ids is not None:
                update_ret = await hub.exec.aws.ec2.transit_gateway_vpc_attachment.update_transit_gateway_vpc_attachment(
                    ctx=ctx,
                    transit_gateway_vpc_attachment_id=before.get(
                        "TransitGatewayAttachmentId"
                    ),
                    old_subnets=before.get("SubnetIds"),
                    new_subnets=subnet_ids,
                    old_options=before.get("Options"),
                    new_options=options,
                )
                if not update_ret["result"]:
                    result["comment"] = update_ret["comment"]
                    result["result"] = False
            if result["result"] and (tags is not None):
                # Update tags
                update_ret = await hub.exec.aws.ec2.tag.update_tags(
                    ctx=ctx,
                    resource_id=before.get("TransitGatewayAttachmentId"),
                    old_tags=before.get("Tags"),
                    new_tags=tags,
                )
                if not update_ret["result"]:
                    result["comment"] = update_ret["comment"]
                    result["result"] = False

            if result["result"]:
                result["comment"] = f"'Updated transit gateway {name}'"

        else:
            ret = await hub.exec.boto3.client.ec2.create_transit_gateway_vpc_attachment(
                ctx,
                TransitGatewayId=transit_gateway,
                VpcId=vpc_id,
                SubnetIds=subnet_ids,
                Options=options,
                TagSpecifications=[
                    {"ResourceType": "transit-gateway-attachment", "Tags": tags}
                ]
                if tags
                else None,
            )
            result["comment"] = f"Created '{name}'"
            result["result"] = ret["result"]

            if (
                ret["result"]
                and ret["ret"]
                and "TransitGatewayVpcAttachment" in ret["ret"]
            ):
                name = ret["ret"]["TransitGatewayVpcAttachment"][
                    "TransitGatewayAttachmentId"
                ]

            if not result["result"]:
                result["comment"] = ret["comment"]
                return result

    except hub.tool.boto3.exception.ClientError as e:
        result["result"] = False
        result["comment"] = f"{e.__class__.__name__}: {e}"

    try:
        after = await hub.exec.aws.ec2.transit_gateway_vpc_attachment.get_transit_gateway_vpc_attachment_by_id(
            ctx, name
        )
        after = after["ret"]
        result["new_state"] = after
    except Exception as e:
        result["comment"] = str(e)
        result["result"] = False
    return result


async def absent(hub, ctx, name: str) -> Dict[str, Any]:
    r"""
    **Autogenerated function**

    Deletes the specified VPC attachment.

    Args:
        name(Text): A name, ID to identify the resource.

    Returns:
        Dict[str, Any]

    Examples:

        .. code-block:: sls

            resource_is_absent:
              aws_auto.ec2.transit_gateway_vpc_attachment.absent:
                - name: value
    """

    result = dict(comment="", old_state=None, new_state=None, name=name, result=True)
    before = await hub.exec.aws.ec2.transit_gateway_vpc_attachment.get_transit_gateway_vpc_attachment_by_id(
        ctx, name
    )
    if not before["result"]:
        result["comment"] = before["comment"]
        result["result"] = False
        return result
    before = before["ret"]
    result["old_state"] = before
    if not before:
        result["comment"] = f"'{name}' already absent"
    elif before["State"] and (
        before["State"] == "deleted" or before["State"] == "deleting"
    ):
        result["comment"] = f"'{name}' is already {before['State']}"
    elif ctx.get("test", False):
        result[
            "comment"
        ] = f"Would delete aws.ec2.transit_gateway_vpc_attachment {name}"
        return result
    else:
        try:
            ret = await hub.exec.boto3.client.ec2.delete_transit_gateway_vpc_attachment(
                ctx, TransitGatewayAttachmentId=name
            )
            result["result"] = ret["result"]
            if not result["result"]:
                result["comment"] = ret["comment"]
                result["result"] = False
                return result
            result["comment"] = f"Deleted '{name}'"
        except hub.tool.boto3.exception.ClientError as e:
            result["comment"] = f"{e.__class__.__name__}: {e}"
    return result


async def describe(hub, ctx) -> Dict[str, Dict[str, Any]]:
    r"""
    **Autogenerated function**

    Describe the resource in a way that can be recreated/managed with the corresponding "present" function


    Describes one or more VPC attachments. By default, all VPC attachments are described. Alternatively, you can
    filter the results.


    Returns:
        Dict[str, Any]

    Examples:

        .. code-block:: bash

            $ idem describe aws_auto.ec2.transit_gateway_vpc_attachment
    """

    result = {}

    ret = await hub.exec.boto3.client.ec2.describe_transit_gateway_vpc_attachments(ctx)
    if not ret["result"]:
        hub.log.debug(
            f"Could not describe transit_gateway_vpc_attachments {ret['comment']}"
        )
        return result
    describe_parameters = OrderedDict(
        {
            "TransitGatewayId": "transit_gateway",
            "VpcId": "vpc_id",
            "SubnetIds": "subnet_ids",
            "Tags": "tags",
            "Options": "options",
        }
    )
    for transit_gateway_vpc_attachment in ret["ret"]["TransitGatewayVpcAttachments"]:
        transit_gateway_vpc_attachment_id = transit_gateway_vpc_attachment.get(
            "TransitGatewayAttachmentId"
        )
        resource_translated = []

        for parameter_old_key, parameter_new_key in describe_parameters.items():
            if transit_gateway_vpc_attachment.get(parameter_old_key) is not None:
                resource_translated.append(
                    {
                        parameter_new_key: transit_gateway_vpc_attachment.get(
                            parameter_old_key
                        )
                    }
                )

        result[transit_gateway_vpc_attachment_id] = {
            "aws.ec2.transit_gateway_vpc_attachment.present": resource_translated
        }

    return result
