"""
Autogenerated state module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__

hub.exec.boto3.client.logs.describe_log_groups
hub.exec.boto3.client.logs.create_log_group
hub.exec.boto3.client.logs.delete_log_group
"""
import copy
from collections import OrderedDict
from typing import Any
from typing import Dict


__contracts__ = ["resource"]


async def present(
    hub, ctx, name: str, kms_key_id: str = None, tags: dict = None
) -> Dict[str, Any]:
    r"""
    **Autogenerated function**

    Creates a log group if it does not already exist. You can create up to 5000 log groups per account.
    You must use the following guidelines when naming a log group:
        - Log group names must be unique within a region for an AWS account.
        - Log group names can be between 1 and 512 characters long.
        - Log group names consist of the following characters: a-z, A-Z, 0-9, '_' (underscore), '-' (hyphen), '/' (forward slash), and '.' (period).
    If you associate a AWS Key Management Service (AWS KMS) customer master key (CMK) with the log group, ingested data is encrypted using the CMK.
    This association is stored as long as the data encrypted with the CMK is still within Amazon CloudWatch Logs. This enables Amazon CloudWatch Logs
    to decrypt this data whenever it is requested.
    If you attempt to associate a CMK with the log group but the CMK does not exist or the CMK is disabled, you will receive an InvalidParameterException error.

    Args:
        name(Text): A name to identify the resource.
        kms_key_id(Text, optional): The Amazon Resource Name (ARN) of the CMK to use when encrypting log data.
        tags(dict, optional): The key-value pairs to use for the tags.

    Request Syntax:
        [log_group_name]:
          aws.cloudwatch.log_group.present:
          - name: 'string'
          - kms_key_id: 'string'
          - tags:
            - 'string': 'string'

    Returns:
        Dict[str, Any]

    Examples:

        .. code-block:: sls

            resource_is_present:
              aws.cloudwatch.log_group.present:
                - name: value
                - tags:
                     TestKey4: TestValue4
                - kms_key_id: "arn:aws:kms:us-east-1:xxxxxxxxx:key/xxxx-9500-xxxxx"
    """

    result = dict(comment="", name=name, old_state=None, new_state=None, result=True)
    update_new_state = True
    before = await hub.exec.boto3.client.logs.describe_log_groups(
        ctx, logGroupNamePrefix=name
    )
    if ctx.get("test", False):
        if before:
            result["comment"] = "Would update aws.cloudwatch.log_group"
            result["result"] = True
        else:
            result["comment"] = "Would create aws.cloudwatch.log_group"
            result["result"] = True
        return result

    try:
        if before["ret"]["logGroups"]:
            result["old_state"] = before["ret"]["logGroups"][0]
            result["comment"] = f"'{name}' already present."
            old_tags = await hub.exec.boto3.client.logs.list_tags_log_group(
                ctx, logGroupName=name
            )
            if tags is not None and dict(old_tags["ret"]["tags"]) != tags:
                update_ret = await hub.exec.aws.cloudwatch.tag.update_tags(
                    ctx=ctx,
                    resource_name=name,
                    old_tags=old_tags["ret"]["tags"],
                    new_tags=tags,
                )
                if update_ret["result"]:
                    result["comment"] = f"'{name}' already present. Updating tags"
                else:
                    result["comment"] = update_ret["comment"]
                    result["result"] = False
            else:
                update_new_state = False
        else:
            ret = await hub.exec.boto3.client.logs.create_log_group(
                ctx, logGroupName=name, kmsKeyId=kms_key_id, tags=tags
            )
            result["result"] = ret["result"]
            if not result["result"]:
                result["comment"] = ret["comment"]
                return result
            ret["comment"] = f"Created '{name}'"
    except hub.tool.boto3.exception.ClientError as e:
        result["result"] = False
        result["comment"] = f"{e.__class__.__name__}: {e}"
    try:
        if update_new_state:
            after = await hub.exec.boto3.client.logs.describe_log_groups(
                ctx, logGroupNamePrefix=name
            )
            result["new_state"] = after["ret"]["logGroups"][0]
        else:
            result["new_state"] = copy.deepcopy(result["old_state"])
    except Exception as e:
        result["comment"] = str(e)
        result["result"] = False
    return result


async def absent(hub, ctx, name: str) -> Dict[str, Any]:
    r"""
    **Autogenerated function**

    Deletes the specified cloudwatch log group.

    Args:
        name(Text): The log Group name.

    Returns:
        Dict[str, Any]

    Examples:

        .. code-block:: sls

            resource_is_absent:
              aws.cloudwatch.log_group.absent:
                - name: value
    """

    result = dict(comment="", name=name, old_state=None, new_state=None, result=True)
    before = await hub.exec.boto3.client.logs.describe_log_groups(
        ctx, logGroupNamePrefix=name
    )
    if not before["ret"]["logGroups"]:
        result["comment"] = f"'{name}' already absent"
    elif ctx.get("test", False):
        result["comment"] = f"Would delete aws.cloudwatch.log_group {name}"
        return result
    else:
        result["old_state"] = before["ret"]["logGroups"][0]
        try:
            ret = await hub.exec.boto3.client.logs.delete_log_group(
                ctx, logGroupName=name
            )
            result["result"] = ret["result"]
            if not result["result"]:
                result["comment"] = ret["comment"]
                return result
            result["comment"] = f"Deleted '{name}'"
        except hub.tool.boto3.exception.ClientError as e:
            result["comment"] = f"{e.__class__.__name__}: {e}"
    return result


async def describe(hub, ctx) -> Dict[str, Dict[str, Any]]:
    r"""
    **Autogenerated function**

    Describe the resource in a way that can be recreated/managed with the corresponding "present" function


    Returns a list of cloudwatch log group descriptions. If a log group name is specified, the list contains only
    the description of that group.


    Returns:
        Dict[str, Any]

    Examples:

        .. code-block:: bash

            $ idem describe aws.cloudwatch.log_group
    """
    result = {}
    ret = await hub.exec.boto3.client.logs.describe_log_groups(ctx)
    if not ret["result"]:
        hub.log.debug(f"Could not describe log groups {ret['comment']}")
        return {}

    describe_parameters = OrderedDict(
        {
            "kmsKeyId": "kms_key_id",
        }
    )
    for log_group in ret["ret"]["logGroups"]:
        logGroupName = log_group.get("logGroupName")
        tags = await hub.exec.boto3.client.logs.list_tags_log_group(
            ctx, logGroupName=logGroupName
        )
        resource_translated = []
        for parameter_old_key, parameter_new_key in describe_parameters.items():
            if log_group.get(parameter_old_key) is not None:
                resource_translated.append(
                    {parameter_new_key: log_group.get(parameter_old_key)}
                )
        if tags["ret"]["tags"]:
            resource_translated.append({"tags": dict(tags["ret"]["tags"])})
        result[logGroupName] = {"aws.cloudwatch.log_group.present": resource_translated}
    return result
