"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FactName = exports.Fact = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * (experimental) A database of regional information.
 *
 * @experimental
 */
class Fact {
    constructor() {
        throw new Error('Use the static methods of Fact instead!');
    }
    /**
     * @returns the list of names of AWS regions for which there is at least one registered fact. This
     * may not be an exhaustive list of all available AWS regions.
     * @experimental
     */
    static get regions() {
        return Object.keys(this.database);
    }
    /**
     * (experimental) Retrieves a fact from this Fact database.
     *
     * @param region the name of the region (e.g: `us-east-1`).
     * @param name the name of the fact being looked up (see the `FactName` class for details).
     * @returns the fact value if it is known, and `undefined` otherwise.
     * @experimental
     */
    static find(region, name) {
        const regionFacts = this.database[region];
        return regionFacts && regionFacts[name];
    }
    /**
     * (experimental) Retrieve a fact from the Fact database.
     *
     * (retrieval will fail if the specified region or
     * fact name does not exist.)
     *
     * @param region the name of the region (e.g: `us-east-1`).
     * @param name the name of the fact being looked up (see the `FactName` class for details).
     * @experimental
     */
    static requireFact(region, name) {
        const foundFact = this.find(region, name);
        if (!foundFact) {
            throw new Error(`No fact ${name} could be found for region: ${region} and name: ${name}`);
        }
        return foundFact;
    }
    /**
     * (experimental) Registers a new fact in this Fact database.
     *
     * @param fact the new fact to be registered.
     * @param allowReplacing whether new facts can replace existing facts or not.
     * @experimental
     */
    static register(fact, allowReplacing = false) {
        const regionFacts = this.database[fact.region] || (this.database[fact.region] = {});
        if (fact.name in regionFacts && regionFacts[fact.name] !== fact.value && !allowReplacing) {
            throw new Error(`Region ${fact.region} already has a fact ${fact.name}, with value ${regionFacts[fact.name]}`);
        }
        if (fact.value !== undefined) {
            regionFacts[fact.name] = fact.value;
        }
    }
    /**
     * (experimental) Removes a fact from the database.
     *
     * @param region the region for which the fact is to be removed.
     * @param name the name of the fact to remove.
     * @param value the value that should be removed (removal will fail if the value is specified, but does not match the current stored value).
     * @experimental
     */
    static unregister(region, name, value) {
        const regionFacts = this.database[region] || {};
        if (name in regionFacts && value && regionFacts[name] !== value) {
            throw new Error(`Attempted to remove ${name} from ${region} with value ${value}, but the fact's value is ${regionFacts[name]}`);
        }
        delete regionFacts[name];
    }
}
exports.Fact = Fact;
_a = JSII_RTTI_SYMBOL_1;
Fact[_a] = { fqn: "monocdk.region_info.Fact", version: "1.106.1" };
Fact.database = {};
/**
 * (experimental) All standardized fact names.
 *
 * @experimental
 */
class FactName {
    /**
     * (experimental) The name of the regional service principal for a given service.
     *
     * @param service the service name, either simple (e.g: `s3`, `codedeploy`) or qualified (e.g: `s3.amazonaws.com`). The `.amazonaws.com` and `.amazonaws.com.cn` domains are stripped from service names, so they are canonicalized in that respect.
     * @experimental
     */
    static servicePrincipal(service) {
        return `service-principal:${service.replace(/\.amazonaws\.com(\.cn)?$/, '')}`;
    }
}
exports.FactName = FactName;
_b = JSII_RTTI_SYMBOL_1;
FactName[_b] = { fqn: "monocdk.region_info.FactName", version: "1.106.1" };
/**
 * (experimental) The name of the partition for a region (e.g: 'aws', 'aws-cn', ...).
 *
 * @experimental
 */
FactName.PARTITION = 'partition';
/**
 * (experimental) The domain suffix for a region (e.g: 'amazonaws.com`).
 *
 * @experimental
 */
FactName.DOMAIN_SUFFIX = 'domainSuffix';
/**
 * (experimental) Whether the AWS::CDK::Metadata CloudFormation Resource is available in-region or not.
 *
 * The value is a boolean
 * modelled as `YES` or `NO`.
 *
 * @experimental
 */
FactName.CDK_METADATA_RESOURCE_AVAILABLE = 'cdk:metadata-resource:available';
/**
 * (experimental) The endpoint used for hosting S3 static websites.
 *
 * @experimental
 */
FactName.S3_STATIC_WEBSITE_ENDPOINT = 's3-static-website:endpoint';
/**
 * (experimental) The endpoint used for aliasing S3 static websites in Route 53.
 *
 * @experimental
 */
FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID = 's3-static-website:route-53-hosted-zone-id';
/**
 * (experimental) The prefix for VPC Endpoint Service names, cn.com.amazonaws.vpce for China regions, com.amazonaws.vpce otherwise.
 *
 * @experimental
 */
FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX = 'vpcEndpointServiceNamePrefix';
/**
 * (experimental) The account for ELBv2 in this region.
 *
 * @experimental
 */
FactName.ELBV2_ACCOUNT = 'elbv2Account';
/**
 * (experimental) The ID of the AWS account that owns the public ECR repository that contains the AWS Deep Learning Containers images in a given region.
 *
 * @experimental
 */
FactName.DLC_REPOSITORY_ACCOUNT = 'dlcRepositoryAccount';
/**
 * (experimental) The ID of the AWS account that owns the public ECR repository that contains the AWS App Mesh Envoy Proxy images in a given region.
 *
 * @experimental
 */
FactName.APPMESH_ECR_ACCOUNT = 'appMeshRepositoryAccount';
//# sourceMappingURL=data:application/json;base64,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