"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SimpleSynthAction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const crypto = require("crypto");
const path = require("path");
const codebuild = require("../../../aws-codebuild"); // Automatically re-written from '@aws-cdk/aws-codebuild'
const codepipeline = require("../../../aws-codepipeline"); // Automatically re-written from '@aws-cdk/aws-codepipeline'
const codepipeline_actions = require("../../../aws-codepipeline-actions"); // Automatically re-written from '@aws-cdk/aws-codepipeline-actions'
const core_1 = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
const fs_1 = require("../private/fs");
const _util_1 = require("./_util");
const DEFAULT_OUTPUT_DIR = 'cdk.out';
/**
 * (experimental) A standard synth with a generated buildspec.
 *
 * @experimental
 */
class SimpleSynthAction {
    /**
     * @experimental
     */
    constructor(props) {
        var _b, _c, _d;
        this.props = props;
        // A number of actionProperties get read before bind() is even called (so before we
        // have made the Project and can construct the actual CodeBuildAction)
        //
        // - actionName
        // - resource
        // - region
        // - category
        // - role
        // - owner
        this._actionProperties = {
            actionName: (_b = props.actionName) !== null && _b !== void 0 ? _b : 'Synth',
            category: codepipeline.ActionCategory.BUILD,
            provider: 'CodeBuild',
            artifactBounds: { minInputs: 0, maxInputs: 5, minOutputs: 0, maxOutputs: 5 },
            inputs: [props.sourceArtifact],
            outputs: [props.cloudAssemblyArtifact, ...((_c = props.additionalArtifacts) !== null && _c !== void 0 ? _c : []).map(a => a.artifact)],
        };
        if (this.props.installCommand && this.props.installCommands) {
            throw new Error('Pass either \'installCommand\' or \'installCommands\', but not both');
        }
        if (this.props.buildCommand && this.props.buildCommands) {
            throw new Error('Pass either \'buildCommand\' or \'buildCommands\', but not both');
        }
        const addls = (_d = props.additionalArtifacts) !== null && _d !== void 0 ? _d : [];
        if (Object.keys(addls).length > 0) {
            if (!props.cloudAssemblyArtifact.artifactName) {
                throw new Error('You must give all output artifacts, including the \'cloudAssemblyArtifact\', names when using \'additionalArtifacts\'');
            }
            for (const addl of addls) {
                if (!addl.artifact.artifactName) {
                    throw new Error('You must give all output artifacts passed to SimpleSynthAction names when using \'additionalArtifacts\'');
                }
            }
        }
    }
    /**
     * (experimental) Create a standard NPM synth action.
     *
     * Uses `npm ci` to install dependencies and `npx cdk synth` to synthesize.
     *
     * If you need a build step, add `buildCommand: 'npm run build'`.
     *
     * @experimental
     */
    static standardNpmSynth(options) {
        var _b, _c, _d;
        return new SimpleSynthAction({
            ...options,
            installCommand: (_b = options.installCommand) !== null && _b !== void 0 ? _b : 'npm ci',
            synthCommand: (_c = options.synthCommand) !== null && _c !== void 0 ? _c : 'npx cdk synth',
            vpc: options.vpc,
            subnetSelection: options.subnetSelection,
            environment: {
                ...options.environment,
                environmentVariables: {
                    // Need this in case the CDK CLI is not in the 'package.json' of the project,
                    // and 'npx' is going to download it; without this setting, 'npx' will not properly
                    // install the package into the root user's home directory
                    NPM_CONFIG_UNSAFE_PERM: { value: 'true' },
                    ...(_d = options.environment) === null || _d === void 0 ? void 0 : _d.environmentVariables,
                },
            },
        });
    }
    /**
     * (experimental) Create a standard Yarn synth action.
     *
     * Uses `yarn install --frozen-lockfile` to install dependencies and `npx cdk synth` to synthesize.
     *
     * If you need a build step, add `buildCommand: 'yarn build'`.
     *
     * @experimental
     */
    static standardYarnSynth(options) {
        var _b, _c, _d;
        return new SimpleSynthAction({
            ...options,
            installCommand: (_b = options.installCommand) !== null && _b !== void 0 ? _b : 'yarn install --frozen-lockfile',
            synthCommand: (_c = options.synthCommand) !== null && _c !== void 0 ? _c : 'npx cdk synth',
            vpc: options.vpc,
            subnetSelection: options.subnetSelection,
            environment: {
                ...options.environment,
                environmentVariables: {
                    // Need this in case the CDK CLI is not in the 'package.json' of the project,
                    // and 'npx' is going to download it; without this setting, 'npx' will not properly
                    // install the package into the root user's home directory
                    NPM_CONFIG_UNSAFE_PERM: { value: 'true' },
                    ...(_d = options.environment) === null || _d === void 0 ? void 0 : _d.environmentVariables,
                },
            },
        });
    }
    /**
     * (experimental) Exists to implement IAction.
     *
     * @experimental
     */
    get actionProperties() {
        return this._actionProperties;
    }
    /**
     * (experimental) Project generated to run the synth command.
     *
     * @experimental
     */
    get project() {
        if (!this._project) {
            throw new Error('Project becomes available after SimpleSynthAction has been bound to a stage');
        }
        return this._project;
    }
    /**
     * (experimental) Exists to implement IAction.
     *
     * @experimental
     */
    bind(scope, stage, options) {
        var _b, _c, _d, _e;
        const buildCommands = (_b = this.props.buildCommands) !== null && _b !== void 0 ? _b : [this.props.buildCommand];
        const installCommands = (_c = this.props.installCommands) !== null && _c !== void 0 ? _c : [this.props.installCommand];
        const testCommands = (_d = this.props.testCommands) !== null && _d !== void 0 ? _d : [];
        const synthCommand = this.props.synthCommand;
        const buildSpec = codebuild.BuildSpec.fromObject({
            version: '0.2',
            phases: {
                pre_build: {
                    commands: _util_1.filterEmpty([
                        this.props.subdirectory ? `cd ${this.props.subdirectory}` : '',
                        ...installCommands,
                    ]),
                },
                build: {
                    commands: _util_1.filterEmpty([
                        ...buildCommands,
                        ...testCommands,
                        synthCommand,
                    ]),
                },
            },
            artifacts: renderArtifacts(this),
        });
        const environment = { buildImage: codebuild.LinuxBuildImage.STANDARD_5_0, ...this.props.environment };
        const environmentVariables = {
            ..._util_1.copyEnvironmentVariables(...this.props.copyEnvironmentVariables || []),
        };
        // A hash over the values that make the CodeBuild Project unique (and necessary
        // to restart the pipeline if one of them changes). projectName is not necessary to include
        // here because the pipeline will definitely restart if projectName changes.
        // (Resolve tokens)
        const projectConfigHash = hash(core_1.Stack.of(scope).resolve({
            environment: serializeBuildEnvironment(environment),
            buildSpecString: buildSpec.toBuildSpec(),
            environmentVariables,
        }));
        const project = new codebuild.PipelineProject(scope, 'CdkBuildProject', {
            projectName: this.props.projectName,
            environment,
            vpc: this.props.vpc,
            subnetSelection: this.props.subnetSelection,
            buildSpec,
            environmentVariables,
        });
        if (this.props.rolePolicyStatements !== undefined) {
            this.props.rolePolicyStatements.forEach(policyStatement => {
                project.addToRolePolicy(policyStatement);
            });
        }
        this._project = project;
        this._action = new codepipeline_actions.CodeBuildAction({
            actionName: this.actionProperties.actionName,
            input: this.props.sourceArtifact,
            outputs: [this.props.cloudAssemblyArtifact, ...((_e = this.props.additionalArtifacts) !== null && _e !== void 0 ? _e : []).map(a => a.artifact)],
            // Inclusion of the hash here will lead to the pipeline structure for any changes
            // made the config of the underlying CodeBuild Project.
            // Hence, the pipeline will be restarted. This is necessary if the users
            // adds (for example) build or test commands to the buildspec.
            environmentVariables: {
                ...this.props.environmentVariables,
                _PROJECT_CONFIG_HASH: { value: projectConfigHash },
            },
            project,
        });
        this._actionProperties = this._action.actionProperties;
        return this._action.bind(scope, stage, options);
        function renderArtifacts(self) {
            var _b;
            // save the generated files in the output artifact
            // This part of the buildspec has to look completely different depending on whether we're
            // using secondary artifacts or not.
            const cloudAsmArtifactSpec = {
                'base-directory': fs_1.toPosixPath(path.join((_b = self.props.subdirectory) !== null && _b !== void 0 ? _b : '.', DEFAULT_OUTPUT_DIR)),
                'files': '**/*',
            };
            if (self.props.additionalArtifacts) {
                const secondary = {};
                if (!self.props.cloudAssemblyArtifact.artifactName) {
                    throw new Error('When using additional output artifacts, you must also name the CloudAssembly artifact');
                }
                secondary[self.props.cloudAssemblyArtifact.artifactName] = cloudAsmArtifactSpec;
                self.props.additionalArtifacts.forEach((art) => {
                    var _b;
                    if (!art.artifact.artifactName) {
                        throw new Error('You must give the output artifact a name');
                    }
                    secondary[art.artifact.artifactName] = {
                        'base-directory': fs_1.toPosixPath(path.join((_b = self.props.subdirectory) !== null && _b !== void 0 ? _b : '.', art.directory)),
                        'files': '**/*',
                    };
                });
                return { 'secondary-artifacts': secondary };
            }
            return cloudAsmArtifactSpec;
        }
    }
    /**
     * (experimental) The CodeBuild Project's principal.
     *
     * @experimental
     */
    get grantPrincipal() {
        return this.project.grantPrincipal;
    }
    /**
     * (experimental) Exists to implement IAction.
     *
     * @experimental
     */
    onStateChange(name, target, options) {
        if (!this._action) {
            throw new Error('Need bind() first');
        }
        return this._action.onStateChange(name, target, options);
    }
}
exports.SimpleSynthAction = SimpleSynthAction;
_a = JSII_RTTI_SYMBOL_1;
SimpleSynthAction[_a] = { fqn: "monocdk.pipelines.SimpleSynthAction", version: "1.106.1" };
function hash(obj) {
    const d = crypto.createHash('sha256');
    d.update(JSON.stringify(obj));
    return d.digest('hex');
}
/**
 * Serialize a build environment to data (get rid of constructs & objects), so we can JSON.stringify it
 */
function serializeBuildEnvironment(env) {
    var _b, _c, _d, _e, _f;
    return {
        privileged: env.privileged,
        environmentVariables: env.environmentVariables,
        type: (_b = env.buildImage) === null || _b === void 0 ? void 0 : _b.type,
        imageId: (_c = env.buildImage) === null || _c === void 0 ? void 0 : _c.imageId,
        computeType: env.computeType,
        imagePullPrincipalType: (_d = env.buildImage) === null || _d === void 0 ? void 0 : _d.imagePullPrincipalType,
        secretsManagerArn: (_f = (_e = env.buildImage) === null || _e === void 0 ? void 0 : _e.secretsManagerCredentials) === null || _f === void 0 ? void 0 : _f.secretArn,
    };
}
//# sourceMappingURL=data:application/json;base64,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