"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StackOutput = exports.CdkStage = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cpactions = require("../../aws-codepipeline-actions"); // Automatically re-written from '@aws-cdk/aws-codepipeline-actions'
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const actions_1 = require("./actions");
const asset_manifest_1 = require("./private/asset-manifest");
const toposort_1 = require("./private/toposort");
// v2 - keep this import as a separate section to reduce merge conflict when forward merging with the v2 branch.
// eslint-disable-next-line
const core_2 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * (experimental) Stage in a CdkPipeline.
 *
 * You don't need to instantiate this class directly. Use
 * `cdkPipeline.addStage()` instead.
 *
 * @experimental
 */
class CdkStage extends core_2.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        this._nextSequentialRunOrder = 1; // Must start at 1 eh
        this._manualApprovalCounter = 1;
        this.stacksToDeploy = new Array();
        this._prepared = false;
        this.stageName = props.stageName;
        this.pipelineStage = props.pipelineStage;
        this.cloudAssemblyArtifact = props.cloudAssemblyArtifact;
        this.host = props.host;
        core_1.Aspects.of(this).add({ visit: () => this.prepareStage() });
    }
    /**
     * (experimental) Add all stacks in the application Stage to this stage.
     *
     * The application construct should subclass `Stage` and can contain any
     * number of `Stacks` inside it that may have dependency relationships
     * on one another.
     *
     * All stacks in the application will be deployed in the appropriate order,
     * and all assets found in the application will be added to the asset
     * publishing stage.
     *
     * @experimental
     */
    addApplication(appStage, options = {}) {
        var _c;
        const asm = appStage.synth({ validateOnSynthesis: true });
        const extraRunOrderSpace = (_c = options.extraRunOrderSpace) !== null && _c !== void 0 ? _c : 0;
        if (asm.stacks.length === 0) {
            // If we don't check here, a more puzzling "stage contains no actions"
            // error will be thrown come deployment time.
            throw new Error(`The given Stage construct ('${appStage.node.path}') should contain at least one Stack`);
        }
        const sortedTranches = toposort_1.topologicalSort(asm.stacks, stack => stack.id, stack => stack.dependencies.map(d => d.id));
        for (const stacks of sortedTranches) {
            const runOrder = this.nextSequentialRunOrder(extraRunOrderSpace + 2); // 2 actions for Prepare/Execute ChangeSet
            let executeRunOrder = runOrder + extraRunOrderSpace + 1;
            // If we need to insert a manual approval action, then what's the executeRunOrder
            // now is where we add a manual approval step, and we allocate 1 more runOrder
            // for the execute.
            if (options.manualApprovals) {
                this.addManualApprovalAction({ runOrder: runOrder + 1 });
                executeRunOrder = this.nextSequentialRunOrder();
            }
            // These don't have a dependency on each other, so can all be added in parallel
            for (const stack of stacks) {
                this.addStackArtifactDeployment(stack, { runOrder, executeRunOrder });
            }
        }
    }
    /**
     * (experimental) Add a deployment action based on a stack artifact.
     *
     * @experimental
     */
    addStackArtifactDeployment(stackArtifact, options = {}) {
        var _c, _d;
        // Get all assets manifests and add the assets in 'em to the asset publishing stage.
        this.publishAssetDependencies(stackArtifact);
        // Remember for later, see 'prepare()'
        // We know that deploying a stack is going to take up 2 runorder slots later on.
        const runOrder = (_c = options.runOrder) !== null && _c !== void 0 ? _c : this.nextSequentialRunOrder(2);
        const executeRunOrder = (_d = options.executeRunOrder) !== null && _d !== void 0 ? _d : runOrder + 1;
        this.stacksToDeploy.push({
            prepareRunOrder: runOrder,
            executeRunOrder,
            stackArtifact,
        });
        this.advanceRunOrderPast(runOrder);
        this.advanceRunOrderPast(executeRunOrder);
    }
    /**
     * (experimental) Add a manual approval action.
     *
     * If you need more flexibility than what this method offers,
     * use `addAction` with a `ManualApprovalAction`.
     *
     * @experimental
     */
    addManualApprovalAction(options = {}) {
        var _c;
        let actionName = options.actionName;
        if (!actionName) {
            actionName = `ManualApproval${this._manualApprovalCounter > 1 ? this._manualApprovalCounter : ''}`;
            this._manualApprovalCounter += 1;
        }
        this.addActions(new cpactions.ManualApprovalAction({
            actionName,
            runOrder: (_c = options.runOrder) !== null && _c !== void 0 ? _c : this.nextSequentialRunOrder(),
        }));
    }
    /**
     * (experimental) Add one or more CodePipeline Actions.
     *
     * You need to make sure it is created with the right runOrder. Call `nextSequentialRunOrder()`
     * for every action to get actions to execute in sequence.
     *
     * @experimental
     */
    addActions(...actions) {
        for (const action of actions) {
            this.pipelineStage.addAction(action);
        }
    }
    /**
     * (experimental) Return the runOrder number necessary to run the next Action in sequence with the rest.
     *
     * FIXME: This is here because Actions are immutable and can't be reordered
     * after creation, nor is there a way to specify relative priorities, which
     * is a limitation that we should take away in the base library.
     *
     * @experimental
     */
    nextSequentialRunOrder(count = 1) {
        const ret = this._nextSequentialRunOrder;
        this._nextSequentialRunOrder += count;
        return ret;
    }
    /**
     * (experimental) Whether this Stage contains an action to deploy the given stack, identified by its artifact ID.
     *
     * @experimental
     */
    deploysStack(artifactId) {
        return this.stacksToDeploy.map(s => s.stackArtifact.id).includes(artifactId);
    }
    /**
     * Actually add all the DeployStack actions to the stage.
     *
     * We do this late because before we can render the actual DeployActions,
     * we need to know whether or not we need to capture the stack outputs.
     *
     * FIXME: This is here because Actions are immutable and can't be reordered
     * after creation, nor is there a way to specify relative priorities, which
     * is a limitation that we should take away in the base library.
     */
    prepareStage() {
        // FIXME: Make sure this only gets run once. There seems to be an issue in the reconciliation
        // loop that may trigger this more than once if it throws an error somewhere, and the exception
        // that gets thrown here will then override the actual failure.
        if (this._prepared) {
            return;
        }
        this._prepared = true;
        for (const { prepareRunOrder, stackArtifact, executeRunOrder } of this.stacksToDeploy) {
            const artifact = this.host.stackOutputArtifact(stackArtifact.id);
            this.pipelineStage.addAction(actions_1.DeployCdkStackAction.fromStackArtifact(this, stackArtifact, {
                baseActionName: this.simplifyStackName(stackArtifact.stackName),
                cloudAssemblyInput: this.cloudAssemblyArtifact,
                output: artifact,
                outputFileName: artifact ? 'outputs.json' : undefined,
                prepareRunOrder,
                executeRunOrder,
            }));
        }
    }
    /**
     * Advance the runorder counter so that the next sequential number is higher than the given one
     */
    advanceRunOrderPast(lastUsed) {
        this._nextSequentialRunOrder = Math.max(lastUsed + 1, this._nextSequentialRunOrder);
    }
    /**
     * Simplify the stack name by removing the `Stage-` prefix if it exists.
     */
    simplifyStackName(s) {
        return stripPrefix(s, `${this.stageName}-`);
    }
    /**
     * Make sure all assets depended on by this stack are published in this pipeline
     *
     * Taking care to exclude the stack template itself -- it is being published
     * as an asset because the CLI needs to know the asset publishing role when
     * pushing the template to S3, but in the case of CodePipeline we always
     * reference the template from the artifact bucket.
     *
     * (NOTE: this is only true for top-level stacks, not nested stacks. Nested
     * Stack templates are always published as assets).
     */
    publishAssetDependencies(stackArtifact) {
        const assetManifests = stackArtifact.dependencies.filter(isAssetManifest);
        for (const manifestArtifact of assetManifests) {
            const manifest = asset_manifest_1.AssetManifestReader.fromFile(manifestArtifact.file);
            for (const entry of manifest.entries) {
                let assetType;
                if (entry instanceof asset_manifest_1.DockerImageManifestEntry) {
                    assetType = actions_1.AssetType.DOCKER_IMAGE;
                }
                else if (entry instanceof asset_manifest_1.FileManifestEntry) {
                    // Don't publishg the template for this stack
                    if (entry.source.packaging === 'file' && entry.source.path === stackArtifact.templateFile) {
                        continue;
                    }
                    assetType = actions_1.AssetType.FILE;
                }
                else {
                    throw new Error(`Unrecognized asset type: ${entry.type}`);
                }
                this.host.publishAsset({
                    assetManifestPath: manifestArtifact.file,
                    assetId: entry.id.assetId,
                    assetSelector: entry.id.toString(),
                    assetType,
                });
            }
        }
    }
}
exports.CdkStage = CdkStage;
_a = JSII_RTTI_SYMBOL_1;
CdkStage[_a] = { fqn: "monocdk.pipelines.CdkStage", version: "1.106.1" };
/**
 * (experimental) A single output of a Stack.
 *
 * @experimental
 */
class StackOutput {
    /**
     * (experimental) Build a StackOutput from a known artifact and an output name.
     *
     * @experimental
     */
    constructor(artifactFile, outputName) {
        this.artifactFile = artifactFile;
        this.outputName = outputName;
    }
}
exports.StackOutput = StackOutput;
_b = JSII_RTTI_SYMBOL_1;
StackOutput[_b] = { fqn: "monocdk.pipelines.StackOutput", version: "1.106.1" };
function stripPrefix(s, prefix) {
    return s.startsWith(prefix) ? s.substr(prefix.length) : s;
}
function isAssetManifest(s) {
    // instanceof is too risky, and we're at a too late stage to properly fix.
    // return s instanceof cxapi.AssetManifestArtifact;
    return s.constructor.name === 'AssetManifestArtifact';
}
//# sourceMappingURL=data:application/json;base64,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